/***********************************************************************
 * Common Tools -- Common classes used in various projects
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 * InputFile.h
 *
 *
 */

#ifndef __INPUTFILE_H__
#define __INPUTFILE_H__

//#include "OGMEvents.h"
#include "OGMCommonDefs.h"
#include "OGMInputStream.h"

class OGMInputFile : public InputStream {
private:
	virtual void _initialize(void);
protected:
	char *buffer;
	long  buffersize;
	long  data_in_buffer;
	char *bufferpos;
	int   file;
public:
	OGMInputFile(void);
	OGMInputFile(char *input_file, long buffer_size);
	virtual ~OGMInputFile(void);
	virtual s64   get_pos(void) { return (TELLI64(file)-data_in_buffer); };
	virtual s64   Seek(s64 offset, int pos);
	virtual long  Read(void *dest, long n_bytes);
	virtual bool  _EOF(void);
	virtual void  Close(void);
	virtual bool  SynchOn(unsigned short synch, unsigned short synch_bits, long max_search, long *search_length=NULL);
};

#endif /* __INPUTFILE_H__ */