//	VirtualDubMod - Video processing and capture application based on VirtualDub by Avery Lee
//	Copyright (C) 1998-2002 VirtualDubMod Developers
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//  Adapted from a sample by Todd Jeffreys

#ifndef f_CREDITS_MOD_H
#define f_CREDITS_MOD_H

typedef struct tagCREDITCOLOR {
	float r,g,b;
} CREDITCOLOR, *LPCREDITCOLOR;

typedef struct tagCREDIT {
	char *credit;
	CREDITCOLOR color;
} CREDIT, *LPCREDIT;

#define COL_BLACK	{0.0f, 0.0f, 0.0f}
#define COL_RED		{1.0f, 0.0f, 0.0f}
#define COL_GREEN	{0.0f, 1.0f, 0.0f}
#define COL_BLUE	{0.0f, 0.0f, 1.0f}
#define COL_YELLOW	{1.0f, 1.0f, 0.0f}
#define COL_WHITE	{1.0f, 1.0f, 1.0f}
#define COL_HEADING	COL_RED
#define COL_ITEM	COL_YELLOW
#define COL_TEXT	COL_WHITE
#define COL_NONE	COL_BLACK

CREDIT modCredits [] = {
	{"virtualdubmod.sf.net", COL_BLUE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Developers:", COL_HEADING},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Belgabor", COL_ITEM},
	{"Cyrius", COL_ITEM},
	{"Pulco-Citron", COL_ITEM},
	{"Stone-D", COL_ITEM},
	{"Stream", COL_ITEM},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Project Admin:", COL_HEADING},
	{"", COL_NONE},
	{"", COL_NONE},
	{"ChristianHJW", COL_ITEM},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Web Designers:", COL_HEADING},
	{"", COL_NONE},
	{"", COL_NONE},
	{"mf", COL_ITEM},
	{"Putteh", COL_ITEM},
	{"Taarji", COL_ITEM},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Code from the following", COL_HEADING},
	{"Mods was used:", COL_HEADING},
	{"", COL_NONE},
	{"", COL_NONE},
	{"NanDub", COL_ITEM},
	{"Nando", COL_TEXT},
	{"", COL_NONE},
	{"VirtualDubAVS", COL_ITEM},
	{"Belgabor", COL_TEXT},
	{"", COL_NONE},
	{"VirtualDubMPeg2", COL_ITEM},
	{"Pulco-Citron", COL_TEXT},
	{"", COL_NONE},
	{"VirtualDubNet", COL_ITEM},
	{"Thomas Matern", COL_TEXT},
	{"", COL_NONE},
	{"VirtualDubOGM", COL_ITEM},
	{"Cyrius", COL_TEXT},
	{"", COL_NONE},
	{"VirtualDubSync", COL_ITEM},
	{"Andreas Dittrich", COL_TEXT},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Thanks go to:", COL_HEADING},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Ben Rudiak-Gould", COL_ITEM},
	{"AVISynth", COL_TEXT},
	{"do I need to say more?", COL_TEXT},
	{"", COL_NONE},
	{"& the AVISynth2 Team", COL_ITEM},
	{"Making fantastic", COL_TEXT},
	{"what was already great =)", COL_TEXT},
	{"", COL_NONE},
	{"Jackei", COL_ITEM},
	{"MPEG2 support from DVD2avi", COL_TEXT},
	{"", COL_NONE},
	{"Koepi", COL_ITEM},
	{"OggMux's chapters import feature ;)", COL_TEXT},
	{"", COL_NONE},
	{"Markus Oberhumer & Laszlo Molnar", COL_ITEM},
	{"UPX, the executable packer", COL_TEXT},
	{"which makes downloading", COL_TEXT},
	{"this a breeze ;)", COL_TEXT},
	{"", COL_NONE},
	{"mf", COL_ITEM},
	{"Suggested a new layout", COL_TEXT},
	{"for the internal", COL_TEXT},
	{"resize filter :)", COL_TEXT},
	{"", COL_NONE},
	{"Mosu", COL_ITEM},
	{"Author of ogmtools :)", COL_TEXT},
	{"", COL_NONE},
	{"OGO & trbarry", COL_ITEM},
	{"Modifications to Jackei's code", COL_TEXT},
	{"& lots of good ideas.", COL_TEXT},
	{"", COL_NONE},
	{"Scintilla", COL_ITEM},
	{"Great syntax higlighting", COL_TEXT},
	{"component", COL_TEXT},
	{"", COL_NONE},
	{"S_O & fccHandler", COL_ITEM},
	{"MPEG1 fixes", COL_TEXT},
	{"", COL_NONE},
	{"Todd Jeffreys", COL_ITEM},
	{"Sample source for", COL_TEXT},
	{"this scroller", COL_TEXT},
	{"", COL_NONE},
	{"Toff", COL_ITEM},
	{"Neat tweaking mod", COL_TEXT},
	{"for the AVS editor", COL_TEXT},
	{"", COL_NONE},
	{"Tobias Waldvogel", COL_ITEM},
	{"Filters to use the", COL_TEXT},
	{"OGG format for multimedia", COL_TEXT},
	{"", COL_NONE},
	{"Xiph.org", COL_ITEM},
	{"OGG format, Vorbis codec", COL_TEXT},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"Our very special thanks", COL_YELLOW},
	{"go to Avery Lee.", COL_YELLOW},
	{"Without your great work", COL_YELLOW},
	{"on VirtualDub all of", COL_YELLOW},
	{"this would have been", COL_YELLOW},
	{"impossible =D", COL_YELLOW},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"", COL_NONE},
	{"or at least a big hassle", COL_RED},
	{";)", COL_RED},
	{NULL, COL_NONE}
};


#endif
