/*
 *  l3table.cpp
 *
 *  Contains tables for MPEG Audio Layer III decoding
 *
 *  Last modified : 08/02/97
 */

#include "all.h"
#include "l3table.h"

#ifdef __WIN32__
#pragma warning (disable: 4305)
#endif

extern int32 slen[2][16] =
{
 {0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4},
 {0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3}
};

extern int32 pretab[22] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};


extern struct SBI sfBandIndex[6] =
{
 {{0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576},
  {0,4,8,12,18,24,32,42,56,74,100,132,174,192}},
 {{0,6,12,18,24,30,36,44,54,66,80,96,114,136,162,194,232,278,330,394,464,540,576},
  {0,4,8,12,18,26,36,48,62,80,104,136,180,192}},
 {{0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576},
  {0,4,8,12,18,26,36,48,62,80,104,134,174,192}},

 {{0,4,8,12,16,20,24,30,36,44,52,62,74,90,110,134,162,196,238,288,342,418,576},
  {0,4,8,12,16,22,30,40,52,66,84,106,136,192}},
 {{0,4,8,12,16,20,24,30,36,42,50,60,72,88,106,128,156,190,230,276,330,384,576},
  {0,4,8,12,16,22,28,38,50,64,80,100,126,192}},
 {{0,4,8,12,16,20,24,30,36,44,54,66,82,102,126,156,194,240,296,364,448,550,576},
  {0,4,8,12,16,22,30,42,58,78,104,138,180,192}}
};

extern real two_to_negative_half_pow[64] =
{ 1.0000000000E+00f, 7.0710678119E-01f, 5.0000000000E-01f, 3.5355339059E-01f,
  2.5000000000E-01f, 1.7677669530E-01f, 1.2500000000E-01f, 8.8388347648E-02f,
  6.2500000000E-02f, 4.4194173824E-02f, 3.1250000000E-02f, 2.2097086912E-02f,
  1.5625000000E-02f, 1.1048543456E-02f, 7.8125000000E-03f, 5.5242717280E-03f,
  3.9062500000E-03f, 2.7621358640E-03f, 1.9531250000E-03f, 1.3810679320E-03f,
  9.7656250000E-04f, 6.9053396600E-04f, 4.8828125000E-04f, 3.4526698300E-04f,
  2.4414062500E-04f, 1.7263349150E-04f, 1.2207031250E-04f, 8.6316745750E-05f,
  6.1035156250E-05f, 4.3158372875E-05f, 3.0517578125E-05f, 2.1579186438E-05f,
  1.5258789062E-05f, 1.0789593219E-05f, 7.6293945312E-06f, 5.3947966094E-06f,
  3.8146972656E-06f, 2.6973983047E-06f, 1.9073486328E-06f, 1.3486991523E-06f,
  9.5367431641E-07f, 6.7434957617E-07f, 4.7683715820E-07f, 3.3717478809E-07f,
  2.3841857910E-07f, 1.6858739404E-07f, 1.1920928955E-07f, 8.4293697022E-08f,
  5.9604644775E-08f, 4.2146848511E-08f, 2.9802322388E-08f, 2.1073424255E-08f,
  1.4901161194E-08f, 1.0536712128E-08f, 7.4505805969E-09f, 5.2683560639E-09f,
  3.7252902985E-09f, 2.6341780319E-09f, 1.8626451492E-09f, 1.3170890160E-09f,
  9.3132257462E-10f, 6.5854450798E-10f, 4.6566128731E-10f, 3.2927225399E-10f
};

extern real  t_43[8192] =
{
    0.000000,    1.000000,    2.519842,    4.326749,    6.349604,    8.549880,   10.902724,   13.390518,
   16.000000,   18.720754,   21.544347,   24.463781,   27.473142,   30.567351,   33.741992,   36.993181,
   40.317474,   43.711787,   47.173345,   50.699631,   54.288352,   57.937408,   61.644865,   65.408941,
   69.227979,   73.100443,   77.024898,   81.000000,   85.024491,   89.097188,   93.216975,   97.382800,
  101.593667,  105.848633,  110.146801,  114.487321,  118.869381,  123.292209,  127.755065,  132.257246,
  136.798076,  141.376907,  145.993119,  150.646117,  155.335327,  160.060199,  164.820202,  169.614826,
  174.443577,  179.305980,  184.201575,  189.129918,  194.090580,  199.083145,  204.107210,  209.162385,
  214.248292,  219.364564,  224.510845,  229.686789,  234.892058,  240.126328,  245.389280,  250.680604,
  256.000000,  261.347174,  266.721841,  272.123723,  277.552547,  283.008049,  288.489971,  293.998060,
  299.532071,  305.091761,  310.676898,  316.287249,  321.922592,  327.582707,  333.267377,  338.976394,
  344.709550,  350.466646,  356.247482,  362.051866,  367.879608,  373.730522,  379.604427,  385.501143,
  391.420496,  397.362314,  403.326427,  409.312672,  415.320884,  421.350905,  427.402579,  433.475750,
  439.570269,  445.685987,  451.822757,  457.980436,  464.158883,  470.357960,  476.577530,  482.817459,
  489.077615,  495.357868,  501.658090,  507.978156,  514.317941,  520.677324,  527.056184,  533.454404,
  539.871867,  546.308458,  552.764065,  559.238575,  565.731879,  572.243870,  578.774440,  585.323483,
  591.890898,  598.476581,  605.080431,  611.702349,  618.342238,  625.000000,  631.675540,  638.368763,
  645.079578,  651.807891,  658.553612,  665.316653,  672.096925,  678.894340,  685.708813,  692.540258,
  699.388593,  706.253733,  713.135597,  720.034104,  726.949174,  733.880729,  740.828689,  747.792979,
  754.773522,  761.770242,  768.783065,  775.811917,  782.856726,  789.917420,  796.993927,  804.086177,
  811.194101,  818.317630,  825.456695,  832.611230,  839.781167,  846.966442,  854.166988,  861.382741,
  868.613637,  875.859614,  883.120608,  890.396558,  897.687403,  904.993081,  912.313534,  919.648701,
  926.998523,  934.362944,  941.741904,  949.135347,  956.543216,  963.965455,  971.402010,  978.852824,
  986.317844,  993.797016, 1001.290286, 1008.797602, 1016.318911, 1023.854161, 1031.403302, 1038.966281,
 1046.543049, 1054.133555, 1061.737750, 1069.355585, 1076.987011, 1084.631981, 1092.290445, 1099.962357,
 1107.647670, 1115.346337, 1123.058312, 1130.783550, 1138.522004, 1146.273630, 1154.038383, 1161.816220,
 1169.607095, 1177.410967, 1185.227790, 1193.057524, 1200.900125, 1208.755551, 1216.623760, 1224.504712,
 1232.398364, 1240.304677, 1248.223610, 1256.155123, 1264.099175, 1272.055728, 1280.024742, 1288.006179,
 1296.000000, 1304.006166, 1312.024641, 1320.055385, 1328.098362, 1336.153535, 1344.220866, 1352.300320,
 1360.391859, 1368.495449, 1376.611053, 1384.738635, 1392.878162, 1401.029597, 1409.192905, 1417.368054,
 1425.555007, 1433.753732, 1441.964195, 1450.186361, 1458.420199, 1466.665675, 1474.922755, 1483.191409,
 1491.471603, 1499.763305, 1508.066484, 1516.381107, 1524.707144, 1533.044563, 1541.393333, 1549.753423,
 1558.124804, 1566.507443, 1574.901312, 1583.306381, 1591.722619, 1600.149996, 1608.588485, 1617.038055,
 1625.498677, 1633.970323, 1642.452964, 1650.946572, 1659.451118, 1667.966574, 1676.492913, 1685.030106,
 1693.578126, 1702.136946, 1710.706539, 1719.286878, 1727.877935, 1736.479684, 1745.092099, 1753.715153,
 1762.348820, 1770.993074, 1779.647889, 1788.313239, 1796.989100, 1805.675444, 1814.372248, 1823.079487,
 1831.797134, 1840.525165, 1849.263556, 1858.012283, 1866.771320, 1875.540644, 1884.320231, 1893.110056,
 1901.910095, 1910.720326, 1919.540725, 1928.371268, 1937.211932, 1946.062693, 1954.923530, 1963.794418,
 1972.675336, 1981.566261, 1990.467169, 1999.378040, 2008.298850, 2017.229578, 2026.170201, 2035.120698,
 2044.081047, 2053.051227, 2062.031215, 2071.020990, 2080.020532, 2089.029819, 2098.048830, 2107.077544,
 2116.115940, 2125.163998, 2134.221697, 2143.289017, 2152.365936, 2161.452435, 2170.548495, 2179.654093,
 2188.769212, 2197.893830, 2207.027929, 2216.171488, 2225.324488, 2234.486909, 2243.658733, 2252.839939,
 2262.030510, 2271.230425, 2280.439666, 2289.658214, 2298.886050, 2308.123156, 2317.369513, 2326.625102,
 2335.889905, 2345.163905, 2354.447082, 2363.739418, 2373.040896, 2382.351497, 2391.671205, 2401.000000,
 2410.337866, 2419.684784, 2429.040737, 2438.405709, 2447.779680, 2457.162635, 2466.554556, 2475.955426,
 2485.365228, 2494.783945, 2504.211560, 2513.648057, 2523.093418, 2532.547627, 2542.010668, 2551.482524,
 2560.963179, 2570.452617, 2579.950820, 2589.457774, 2598.973461, 2608.497867, 2618.030975, 2627.572769,
 2637.123233, 2646.682352, 2656.250110, 2665.826492, 2675.411482, 2685.005064, 2694.607223, 2704.217944,
 2713.837212, 2723.465012, 2733.101328, 2742.746145, 2752.399449, 2762.061224, 2771.731456, 2781.410129,
 2791.097231, 2800.792744, 2810.496656, 2820.208951, 2829.929616, 2839.658635, 2849.395994, 2859.141679,
 2868.895677, 2878.657972, 2888.428550, 2898.207399, 2907.994503, 2917.789849, 2927.593423, 2937.405211,
 2947.225199, 2957.053374, 2966.889722, 2976.734230, 2986.586884, 2996.447670, 3006.316576, 3016.193588,
 3026.078692, 3035.971875, 3045.873125, 3055.782428, 3065.699771, 3075.625140, 3085.558524, 3095.499909,
 3105.449282, 3115.406631, 3125.371943, 3135.345204, 3145.326403, 3155.315526, 3165.312562, 3175.317497,
 3185.330320, 3195.351017, 3205.379577, 3215.415987, 3225.460235, 3235.512308, 3245.572195, 3255.639884,
 3265.715361, 3275.798616, 3285.889637, 3295.988410, 3306.094926, 3316.209171, 3326.331133, 3336.460802,
 3346.598165, 3356.743211, 3366.895929, 3377.056305, 3387.224330, 3397.399991, 3407.583277, 3417.774177,
 3427.972680, 3438.178773, 3448.392446, 3458.613687, 3468.842486, 3479.078831, 3489.322711, 3499.574115,
 3509.833032, 3520.099451, 3530.373360, 3540.654750, 3550.943609, 3561.239927, 3571.543692, 3581.854894,
 3592.173522, 3602.499566, 3612.833015, 3623.173857, 3633.522084, 3643.877683, 3654.240646, 3664.610960,
 3674.988617, 3685.373604, 3695.765913, 3706.165533, 3716.572453, 3726.986664, 3737.408154, 3747.836915,
 3758.272936, 3768.716206, 3779.166716, 3789.624455, 3800.089415, 3810.561584, 3821.040953, 3831.527512,
 3842.021251, 3852.522160, 3863.030230, 3873.545451, 3884.067812, 3894.597305, 3905.133920, 3915.677647,
 3926.228477, 3936.786399, 3947.351405, 3957.923485, 3968.502630, 3979.088830, 3989.682075, 4000.282357,
 4010.889666, 4021.503992, 4032.125327, 4042.753661, 4053.388986, 4064.031291, 4074.680568, 4085.336807,
 4096.000000, 4106.670137, 4117.347210, 4128.031209, 4138.722126, 4149.419951, 4160.124676, 4170.836292,
 4181.554789, 4192.280159, 4203.012394, 4213.751484, 4224.497421, 4235.250196, 4246.009800, 4256.776225,
 4267.549462, 4278.329502, 4289.116337, 4299.909959, 4310.710358, 4321.517527, 4332.331456, 4343.152138,
 4353.979564, 4364.813725, 4375.654614, 4386.502221, 4397.356539, 4408.217559, 4419.085273, 4429.959673,
 4440.840751, 4451.728498, 4462.622906, 4473.523967, 4484.431673, 4495.346016, 4506.266988, 4517.194581,
 4528.128786, 4539.069597, 4550.017004, 4560.970999, 4571.931576, 4582.898726, 4593.872441, 4604.852714,
 4615.839536, 4626.832899, 4637.832797, 4648.839221, 4659.852163, 4670.871616, 4681.897572, 4692.930024,
 4703.968963, 4715.014383, 4726.066275, 4737.124632, 4748.189446, 4759.260711, 4770.338417, 4781.422559,
 4792.513128, 4803.610117, 4814.713519, 4825.823326, 4836.939531, 4848.062126, 4859.191105, 4870.326459,
 4881.468181, 4892.616265, 4903.770703, 4914.931488, 4926.098612, 4937.272069, 4948.451851, 4959.637951,
 4970.830361, 4982.029076, 4993.234087, 5004.445388, 5015.662972, 5026.886831, 5038.116959, 5049.353348,
 5060.595992, 5071.844883, 5083.100016, 5094.361382, 5105.628975, 5116.902788, 5128.182814, 5139.469046,
 5150.761478, 5162.060103, 5173.364914, 5184.675904, 5195.993066, 5207.316394, 5218.645881, 5229.981521,
 5241.323306, 5252.671230, 5264.025286, 5275.385468, 5286.751770, 5298.124183, 5309.502703, 5320.887323,
 5332.278035, 5343.674833, 5355.077712, 5366.486664, 5377.901683, 5389.322762, 5400.749896, 5412.183077,
 5423.622300, 5435.067557, 5446.518843, 5457.976152, 5469.439476, 5480.908810, 5492.384147, 5503.865481,
 5515.352806, 5526.846116, 5538.345404, 5549.850664, 5561.361890, 5572.879076, 5584.402215, 5595.931301,
 5607.466329, 5619.007292, 5630.554185, 5642.107000, 5653.665732, 5665.230375, 5676.800923, 5688.377370,
 5699.959709, 5711.547936, 5723.142043, 5734.742025, 5746.347876, 5757.959590, 5769.577161, 5781.200584,
 5792.829852, 5804.464959, 5816.105900, 5827.752668, 5839.405259, 5851.063665, 5862.727882, 5874.397904,
 5886.073724, 5897.755337, 5909.442738, 5921.135920, 5932.834878, 5944.539606, 5956.250098, 5967.966350,
 5979.688354, 5991.416106, 6003.149600, 6014.888830, 6026.633791, 6038.384476, 6050.140882, 6061.903001,
 6073.670828, 6085.444359, 6097.223586, 6109.008506, 6120.799112, 6132.595399, 6144.397361, 6156.204993,
 6168.018289, 6179.837245, 6191.661854, 6203.492112, 6215.328012, 6227.169550, 6239.016720, 6250.869517,
 6262.727935, 6274.591969, 6286.461614, 6298.336865, 6310.217716, 6322.104162, 6333.996197, 6345.893817,
 6357.797016, 6369.705789, 6381.620131, 6393.540036, 6405.465500, 6417.396517, 6429.333082, 6441.275190,
 6453.222835, 6465.176013, 6477.134719, 6489.098947, 6501.068692, 6513.043949, 6525.024714, 6537.010981,
 6549.002744, 6561.000000, 6573.002743, 6585.010967, 6597.024669, 6609.043842, 6621.068483, 6633.098585,
 6645.134145, 6657.175157, 6669.221616, 6681.273517, 6693.330855, 6705.393626, 6717.461825, 6729.535446,
 6741.614485, 6753.698937, 6765.788798, 6777.884061, 6789.984723, 6802.090779, 6814.202223, 6826.319052,
 6838.441259, 6850.568842, 6862.701794, 6874.840111, 6886.983788, 6899.132821, 6911.287205, 6923.446935,
 6935.612006, 6947.782414, 6959.958154, 6972.139221, 6984.325611, 6996.517319, 7008.714341, 7020.916672,
 7033.124306, 7045.337241, 7057.555470, 7069.778990, 7082.007795, 7094.241882, 7106.481246, 7118.725881,
 7130.975785, 7143.230951, 7155.491376, 7167.757056, 7180.027984, 7192.304158, 7204.585573, 7216.872224,
 7229.164106, 7241.461216, 7253.763548, 7266.071099, 7278.383864, 7290.701838, 7303.025018, 7315.353398,
 7327.686975, 7340.025743, 7352.369699, 7364.718839, 7377.073157, 7389.432650, 7401.797314, 7414.167143,
 7426.542134, 7438.922282, 7451.307583, 7463.698033, 7476.093627, 7488.494362, 7500.900233, 7513.311235,
 7525.727365, 7538.148618, 7550.574989, 7563.006476, 7575.443073, 7587.884777, 7600.331583, 7612.783487,
 7625.240485, 7637.702572, 7650.169745, 7662.641999, 7675.119331, 7687.601736, 7700.089209, 7712.581748,
 7725.079347, 7737.582003, 7750.089712, 7762.602469, 7775.120271, 7787.643113, 7800.170991, 7812.703902,
 7825.241841, 7837.784804, 7850.332787, 7862.885787, 7875.443798, 7888.006818, 7900.574842, 7913.147866,
 7925.725887, 7938.308900, 7950.896901, 7963.489886, 7976.087852, 7988.690794, 8001.298709, 8013.911593,
 8026.529441, 8039.152250, 8051.780016, 8064.412735, 8077.050403, 8089.693017, 8102.340572, 8114.993064,
 8127.650490, 8140.312846, 8152.980128, 8165.652333, 8178.329455, 8191.011492, 8203.698440, 8216.390295,
 8229.087053, 8241.788711, 8254.495264, 8267.206709, 8279.923042, 8292.644259, 8305.370357, 8318.101332,
 8330.837180, 8343.577897, 8356.323480, 8369.073925, 8381.829228, 8394.589385, 8407.354394, 8420.124249,
 8432.898948, 8445.678487, 8458.462862, 8471.252070, 8484.046106, 8496.844968, 8509.648651, 8522.457152,
 8535.270468, 8548.088594, 8560.911527, 8573.739264, 8586.571801, 8599.409134, 8612.251259, 8625.098174,
 8637.949875, 8650.806357, 8663.667618, 8676.533654, 8689.404461, 8702.280037, 8715.160376, 8728.045476,
 8740.935334, 8753.829945, 8766.729307, 8779.633415, 8792.542267, 8805.455858, 8818.374186, 8831.297247,
 8844.225037, 8857.157553, 8870.094791, 8883.036748, 8895.983421, 8908.934807, 8921.890901, 8934.851700,
 8947.817201, 8960.787401, 8973.762296, 8986.741882, 8999.726157, 9012.715117, 9025.708758, 9038.707077,
 9051.710072, 9064.717737, 9077.730071, 9090.747070, 9103.768730, 9116.795048, 9129.826021, 9142.861645,
 9155.901917, 9168.946835, 9181.996393, 9195.050590, 9208.109422, 9221.172885, 9234.240977, 9247.313694,
 9260.391032, 9273.472989, 9286.559562, 9299.650746, 9312.746539, 9325.846938, 9338.951939, 9352.061539,
 9365.175734, 9378.294523, 9391.417901, 9404.545865, 9417.678412, 9430.815538, 9443.957242, 9457.103518,
 9470.254365, 9483.409779, 9496.569757, 9509.734296, 9522.903392, 9536.077043, 9549.255245, 9562.437995,
 9575.625290, 9588.817127, 9602.013503, 9615.214414, 9628.419858, 9641.629831, 9654.844330, 9668.063353,
 9681.286896, 9694.514956, 9707.747529, 9720.984614, 9734.226206, 9747.472303, 9760.722902, 9773.977999,
 9787.237592, 9800.501677, 9813.770252, 9827.043313, 9840.320858, 9853.602883, 9866.889385, 9880.180361,
 9893.475809, 9906.775725, 9920.080107, 9933.388951, 9946.702254, 9960.020013, 9973.342226, 9986.668889,
10000.000000,10013.335555,10026.675552,10040.019987,10053.368857,10066.722161,10080.079894,10093.442053,
10106.808637,10120.179641,10133.555064,10146.934901,10160.319151,10173.707810,10187.100875,10200.498344,
10213.900213,10227.306480,10240.717141,10254.132195,10267.551637,10280.975466,10294.403678,10307.836271,
10321.273241,10334.714585,10348.160302,10361.610388,10375.064840,10388.523655,10401.986831,10415.454364,
10428.926253,10442.402493,10455.883083,10469.368019,10482.857299,10496.350920,10509.848879,10523.351173,
10536.857800,10550.368756,10563.884040,10577.403647,10590.927576,10604.455824,10617.988388,10631.525264,
10645.066452,10658.611947,10672.161747,10685.715849,10699.274250,10712.836948,10726.403941,10739.975224,
10753.550797,10767.130655,10780.714796,10794.303218,10807.895918,10821.492892,10835.094140,10848.699656,
10862.309440,10875.923489,10889.541799,10903.164368,10916.791193,10930.422273,10944.057603,10957.697182,
10971.341006,10984.989074,10998.641382,11012.297928,11025.958709,11039.623723,11053.292967,11066.966438,
11080.644134,11094.326053,11108.012190,11121.702545,11135.397114,11149.095895,11162.798885,11176.506082,
11190.217483,11203.933085,11217.652886,11231.376883,11245.105074,11258.837456,11272.574027,11286.314784,
11300.059724,11313.808845,11327.562145,11341.319621,11355.081270,11368.847090,11382.617078,11396.391232,
11410.169549,11423.952027,11437.738663,11451.529455,11465.324400,11479.123496,11492.926740,11506.734130,
11520.545663,11534.361337,11548.181149,11562.005097,11575.833179,11589.665391,11603.501732,11617.342198,
11631.186788,11645.035499,11658.888329,11672.745275,11686.606334,11700.471505,11714.340784,11728.214170,
11742.091660,11755.973251,11769.858942,11783.748729,11797.642610,11811.540583,11825.442646,11839.348796,
11853.259030,11867.173346,11881.091743,11895.014217,11908.940766,11922.871387,11936.806079,11950.744839,
11964.687665,11978.634553,11992.585503,12006.540511,12020.499575,12034.462692,12048.429861,12062.401080,
12076.376344,12090.355654,12104.339005,12118.326396,12132.317824,12146.313287,12160.312783,12174.316310,
12188.323864,12202.335444,12216.351048,12230.370673,12244.394316,12258.421976,12272.453650,12286.489336,
12300.529032,12314.572735,12328.620443,12342.672154,12356.727866,12370.787575,12384.851281,12398.918980,
12412.990671,12427.066350,12441.146017,12455.229668,12469.317302,12483.408916,12497.504507,12511.604075,
12525.707615,12539.815127,12553.926608,12568.042055,12582.161467,12596.284841,12610.412175,12624.543467,
12638.678715,12652.817915,12666.961067,12681.108168,12695.259216,12709.414208,12723.573143,12737.736017,
12751.902830,12766.073579,12780.248261,12794.426874,12808.609417,12822.795886,12836.986281,12851.180598,
12865.378836,12879.580992,12893.787065,12907.997051,12922.210950,12936.428758,12950.650474,12964.876095,
12979.105619,12993.339045,13007.576370,13021.817591,13036.062708,13050.311717,13064.564616,13078.821404,
13093.082079,13107.346637,13121.615077,13135.887398,13150.163596,13164.443670,13178.727617,13193.015436,
13207.307125,13221.602680,13235.902101,13250.205385,13264.512531,13278.823535,13293.138396,13307.457112,
13321.779680,13336.106100,13350.436367,13364.770482,13379.108441,13393.450242,13407.795884,13422.145364,
13436.498680,13450.855830,13465.216813,13479.581625,13493.950266,13508.322733,13522.699023,13537.079136,
13551.463069,13565.850819,13580.242386,13594.637766,13609.036958,13623.439960,13637.846770,13652.257385,
13666.671804,13681.090025,13695.512046,13709.937865,13724.367479,13738.800887,13753.238087,13767.679077,
13782.123854,13796.572417,13811.024764,13825.480893,13839.940802,13854.404489,13868.871952,13883.343188,
13897.818197,13912.296976,13926.779522,13941.265835,13955.755912,13970.249751,13984.747351,13999.248708,
14013.753822,14028.262691,14042.775312,14057.291683,14071.811803,14086.335669,14100.863281,14115.394635,
14129.929730,14144.468564,14159.011135,14173.557441,14188.107480,14202.661250,14217.218750,14231.779977,
14246.344930,14260.913606,14275.486004,14290.062122,14304.641958,14319.225510,14333.812776,14348.403754,
14362.998443,14377.596840,14392.198943,14406.804752,14421.414263,14436.027475,14450.644386,14465.264995,
14479.889298,14494.517296,14509.148984,14523.784363,14538.423430,14553.066182,14567.712619,14582.362738,
14597.016537,14611.674015,14626.335170,14641.000000,14655.668503,14670.340677,14685.016521,14699.696032,
14714.379209,14729.066050,14743.756553,14758.450716,14773.148537,14787.850016,14802.555149,14817.263935,
14831.976372,14846.692459,14861.412193,14876.135573,14890.862597,14905.593263,14920.327569,14935.065514,
14949.807096,14964.552313,14979.301163,14994.053644,15008.809755,15023.569493,15038.332858,15053.099847,
15067.870458,15082.644690,15097.422541,15112.204010,15126.989093,15141.777790,15156.570099,15171.366018,
15186.165546,15200.968679,15215.775418,15230.585760,15245.399703,15260.217246,15275.038386,15289.863123,
15304.691453,15319.523377,15334.358891,15349.197994,15364.040685,15378.886961,15393.736821,15408.590264,
15423.447287,15438.307888,15453.172066,15468.039820,15482.911147,15497.786047,15512.664516,15527.546554,
15542.432158,15557.321327,15572.214060,15587.110354,15602.010208,15616.913620,15631.820589,15646.731113,
15661.645189,15676.562817,15691.483995,15706.408720,15721.336992,15736.268809,15751.204169,15766.143070,
15781.085510,15796.031489,15810.981003,15825.934053,15840.890635,15855.850748,15870.814391,15885.781562,
15900.752259,15915.726481,15930.704226,15945.685492,15960.670277,15975.658581,15990.650401,16005.645735,
16020.644583,16035.646942,16050.652811,16065.662188,16080.675071,16095.691459,16110.711350,16125.734743,
16140.761636,16155.792027,16170.825914,16185.863297,16200.904173,16215.948541,16230.996399,16246.047745,
16261.102579,16276.160898,16291.222700,16306.287985,16321.356750,16336.428994,16351.504716,16366.583913,
16381.666584,16396.752727,16411.842341,16426.935425,16442.031976,16457.131994,16472.235476,16487.342421,
16502.452827,16517.566693,16532.684017,16547.804797,16562.929033,16578.056722,16593.187863,16608.322454,
16623.460494,16638.601981,16653.746913,16668.895290,16684.047109,16699.202368,16714.361068,16729.523204,
16744.688777,16759.857785,16775.030226,16790.206098,16805.385400,16820.568131,16835.754288,16850.943871,
16866.136877,16881.333306,16896.533155,16911.736424,16926.943110,16942.153213,16957.366730,16972.583659,
16987.804001,17003.027752,17018.254912,17033.485478,17048.719451,17063.956826,17079.197605,17094.441784,
17109.689362,17124.940338,17140.194711,17155.452478,17170.713638,17185.978190,17201.246133,17216.517464,
17231.792182,17247.070287,17262.351775,17277.636646,17292.924898,17308.216530,17323.511541,17338.809928,
17354.111690,17369.416826,17384.725335,17400.037214,17415.352462,17430.671079,17445.993061,17461.318409,
17476.647120,17491.979193,17507.314626,17522.653419,17537.995569,17553.341074,17568.689935,17584.042149,
17599.397714,17614.756629,17630.118893,17645.484505,17660.853462,17676.225764,17691.601408,17706.980394,
17722.362720,17737.748384,17753.137386,17768.529723,17783.925394,17799.324399,17814.726734,17830.132399,
17845.541393,17860.953714,17876.369360,17891.788331,17907.210624,17922.636238,17938.065173,17953.497425,
17968.932995,17984.371880,17999.814079,18015.259591,18030.708415,18046.160548,18061.615990,18077.074738,
18092.536793,18108.002151,18123.470812,18138.942775,18154.418038,18169.896599,18185.378458,18200.863612,
18216.352060,18231.843802,18247.338835,18262.837158,18278.338770,18293.843670,18309.351855,18324.863325,
18340.378078,18355.896113,18371.417429,18386.942023,18402.469895,18418.001044,18433.535467,18449.073164,
18464.614132,18480.158372,18495.705881,18511.256658,18526.810702,18542.368011,18557.928583,18573.492419,
18589.059515,18604.629871,18620.203486,18635.780358,18651.360485,18666.943867,18682.530502,18698.120388,
18713.713525,18729.309910,18744.909543,18760.512422,18776.118546,18791.727914,18807.340524,18822.956374,
18838.575464,18854.197793,18869.823358,18885.452158,18901.084193,18916.719460,18932.357958,18947.999687,
18963.644645,18979.292830,18994.944241,19010.598877,19026.256736,19041.917817,19057.582120,19073.249641,
19088.920381,19104.594338,19120.271510,19135.951896,19151.635495,19167.322306,19183.012327,19198.705557,
19214.401994,19230.101638,19245.804487,19261.510539,19277.219794,19292.932250,19308.647906,19324.366760,
19340.088811,19355.814058,19371.542500,19387.274135,19403.008962,19418.746980,19434.488187,19450.232582,
19465.980164,19481.730931,19497.484883,19513.242017,19529.002334,19544.765830,19560.532506,19576.302359,
19592.075389,19607.851595,19623.630974,19639.413526,19655.199249,19670.988143,19686.780205,19702.575435,
19718.373831,19734.175393,19749.980118,19765.788005,19781.599054,19797.413263,19813.230631,19829.051156,
19844.874837,19860.701674,19876.531664,19892.364806,19908.201100,19924.040543,19939.883136,19955.728875,
19971.577761,19987.429792,20003.284967,20019.143283,20035.004742,20050.869340,20066.737076,20082.607951,
20098.481961,20114.359107,20130.239386,20146.122797,20162.009340,20177.899014,20193.791815,20209.687745,
20225.586801,20241.488982,20257.394286,20273.302714,20289.214263,20305.128932,20321.046720,20336.967626,
20352.891648,20368.818786,20384.749038,20400.682403,20416.618879,20432.558466,20448.501162,20464.446967,
20480.395878,20496.347894,20512.303016,20528.261240,20544.222566,20560.186993,20576.154520,20592.125145,
20608.098867,20624.075685,20640.055598,20656.038605,20672.024704,20688.013894,20704.006174,20720.001543,
20736.000000,20752.001543,20768.006171,20784.013883,20800.024679,20816.038555,20832.055513,20848.075549,
20864.098664,20880.124856,20896.154123,20912.186465,20928.221880,20944.260368,20960.301926,20976.346555,
20992.394252,21008.445017,21024.498848,21040.555744,21056.615704,21072.678727,21088.744811,21104.813957,
21120.886161,21136.961424,21153.039743,21169.121119,21185.205549,21201.293033,21217.383569,21233.477156,
21249.573793,21265.673480,21281.776214,21297.881994,21313.990820,21330.102690,21346.217604,21362.335559,
21378.456555,21394.580591,21410.707666,21426.837778,21442.970926,21459.107109,21475.246326,21491.388576,
21507.533858,21523.682170,21539.833512,21555.987882,21572.145279,21588.305702,21604.469150,21620.635622,
21636.805116,21652.977632,21669.153168,21685.331724,21701.513297,21717.697888,21733.885494,21750.076116,
21766.269750,21782.466398,21798.666056,21814.868725,21831.074403,21847.283089,21863.494782,21879.709481,
21895.927184,21912.147891,21928.371600,21944.598311,21960.828022,21977.060732,21993.296440,22009.535145,
22025.776846,22042.021541,22058.269230,22074.519912,22090.773584,22107.030248,22123.289900,22139.552540,
22155.818168,22172.086781,22188.358379,22204.632961,22220.910525,22237.191071,22253.474598,22269.761103,
22286.050587,22302.343048,22318.638485,22334.936897,22351.238283,22367.542642,22383.849973,22400.160274,
22416.473544,22432.789784,22449.108990,22465.431163,22481.756301,22498.084404,22514.415469,22530.749496,
22547.086485,22563.426433,22579.769340,22596.115205,22612.464026,22628.815803,22645.170535,22661.528220,
22677.888857,22694.252446,22710.618984,22726.988473,22743.360909,22759.736292,22776.114621,22792.495896,
22808.880114,22825.267275,22841.657378,22858.050421,22874.446404,22890.845326,22907.247185,22923.651981,
22940.059712,22956.470378,22972.883977,22989.300508,23005.719971,23022.142364,23038.567686,23054.995936,
23071.427113,23087.861216,23104.298245,23120.738197,23137.181072,23153.626869,23170.075587,23186.527224,
23202.981781,23219.439255,23235.899646,23252.362952,23268.829173,23285.298308,23301.770355,23318.245314,
23334.723184,23351.203963,23367.687650,23384.174245,23400.663746,23417.156152,23433.651463,23450.149677,
23466.650794,23483.154812,23499.661730,23516.171547,23532.684263,23549.199876,23565.718385,23582.239789,
23598.764087,23615.291279,23631.821363,23648.354338,23664.890203,23681.428957,23697.970599,23714.515128,
23731.062544,23747.612844,23764.166029,23780.722096,23797.281046,23813.842877,23830.407588,23846.975178,
23863.545646,23880.118991,23896.695212,23913.274308,23929.856278,23946.441122,23963.028837,23979.619424,
23996.212880,24012.809206,24029.408400,24046.010461,24062.615388,24079.223180,24095.833837,24112.447356,
24129.063738,24145.682981,24162.305084,24178.930046,24195.557867,24212.188545,24228.822079,24245.458468,
24262.097712,24278.739809,24295.384759,24312.032559,24328.683211,24345.336711,24361.993060,24378.652257,
24395.314300,24411.979189,24428.646922,24445.317499,24461.990918,24478.667179,24495.346281,24512.028223,
24528.713003,24545.400621,24562.091076,24578.784367,24595.480492,24612.179452,24628.881244,24645.585869,
24662.293325,24679.003610,24695.716725,24712.432668,24729.151438,24745.873035,24762.597457,24779.324703,
24796.054772,24812.787664,24829.523378,24846.261912,24863.003266,24879.747438,24896.494428,24913.244235,
24929.996857,24946.752295,24963.510546,24980.271610,24997.035487,25013.802174,25030.571672,25047.343978,
25064.119093,25080.897016,25097.677744,25114.461278,25131.247617,25148.036759,25164.828704,25181.623451,
25198.420998,25215.221345,25232.024491,25248.830435,25265.639176,25282.450713,25299.265045,25316.082172,
25332.902091,25349.724804,25366.550307,25383.378601,25400.209685,25417.043558,25433.880218,25450.719665,
25467.561898,25484.406916,25501.254718,25518.105303,25534.958670,25551.814819,25568.673748,25585.535457,
25602.399944,25619.267208,25636.137250,25653.010067,25669.885660,25686.764026,25703.645165,25720.529077,
25737.415759,25754.305213,25771.197435,25788.092426,25804.990185,25821.890710,25838.794002,25855.700058,
25872.608878,25889.520461,25906.434807,25923.351913,25940.271781,25957.194407,25974.119793,25991.047936,
26007.978835,26024.912491,26041.848902,26058.788067,26075.729985,26092.674655,26109.622077,26126.572249,
26143.525171,26160.480842,26177.439260,26194.400426,26211.364337,26228.330994,26245.300395,26262.272540,
26279.247427,26296.225056,26313.205425,26330.188534,26347.174383,26364.162969,26381.154293,26398.148353,
26415.145148,26432.144678,26449.146942,26466.151939,26483.159667,26500.170127,26517.183317,26534.199236,
26551.217883,26568.239258,26585.263360,26602.290188,26619.319740,26636.352017,26653.387017,26670.424739,
26687.465183,26704.508347,26721.554231,26738.602834,26755.654154,26772.708192,26789.764946,26806.824416,
26823.886600,26840.951498,26858.019109,26875.089431,26892.162465,26909.238209,26926.316662,26943.397823,
26960.481693,26977.568269,26994.657551,27011.749538,27028.844229,27045.941624,27063.041721,27080.144520,
27097.250020,27114.358219,27131.469118,27148.582715,27165.699009,27182.818000,27199.939687,27217.064068,
27234.191143,27251.320912,27268.453373,27285.588525,27302.726368,27319.866901,27337.010122,27354.156032,
27371.304629,27388.455912,27405.609881,27422.766535,27439.925872,27457.087892,27474.252595,27491.419979,
27508.590044,27525.762788,27542.938211,27560.116312,27577.297090,27594.480545,27611.666675,27628.855480,
27646.046958,27663.241110,27680.437934,27697.637429,27714.839595,27732.044430,27749.251934,27766.462107,
27783.674946,27800.890452,27818.108624,27835.329460,27852.552960,27869.779123,27887.007948,27904.239435,
27921.473583,27938.710390,27955.949856,27973.191981,27990.436762,28007.684201,28024.934295,28042.187044,
28059.442446,28076.700503,28093.961211,28111.224571,28128.490582,28145.759243,28163.030554,28180.304512,
28197.581118,28214.860371,28232.142270,28249.426814,28266.714002,28284.003834,28301.296308,28318.591424,
28335.889182,28353.189579,28370.492617,28387.798292,28405.106606,28422.417557,28439.731144,28457.047366,
28474.366223,28491.687714,28509.011838,28526.338594,28543.667982,28561.000000,28578.334648,28595.671925,
28613.011831,28630.354364,28647.699523,28665.047309,28682.397719,28699.750754,28717.106412,28734.464693,
28751.825596,28769.189120,28786.555264,28803.924028,28821.295410,28838.669411,28856.046028,28873.425262,
28890.807112,28908.191576,28925.578655,28942.968346,28960.360650,28977.755566,28995.153093,29012.553229,
29029.955975,29047.361330,29064.769292,29082.179861,29099.593036,29117.008817,29134.427203,29151.848192,
29169.271784,29186.697979,29204.126775,29221.558171,29238.992168,29256.428764,29273.867958,29291.309750,
29308.754139,29326.201124,29343.650704,29361.102879,29378.557648,29396.015009,29413.474963,29430.937508,
29448.402644,29465.870370,29483.340685,29500.813588,29518.289079,29535.767157,29553.247821,29570.731070,
29588.216904,29605.705322,29623.196322,29640.689905,29658.186069,29675.684815,29693.186140,29710.690044,
29728.196527,29745.705587,29763.217225,29780.731439,29798.248228,29815.767591,29833.289529,29850.814040,
29868.341123,29885.870778,29903.403004,29920.937800,29938.475165,29956.015099,29973.557601,29991.102670,
30008.650305,30026.200506,30043.753272,30061.308602,30078.866496,30096.426952,30113.989970,30131.555549,
30149.123688,30166.694387,30184.267645,30201.843461,30219.421835,30237.002765,30254.586251,30272.172293,
30289.760889,30307.352038,30324.945740,30342.541995,30360.140801,30377.742158,30395.346065,30412.952521,
30430.561526,30448.173078,30465.787178,30483.403823,30501.023015,30518.644751,30536.269031,30553.895855,
30571.525221,30589.157129,30606.791579,30624.428569,30642.068098,30659.710167,30677.354773,30695.001918,
30712.651599,30730.303816,30747.958568,30765.615855,30783.275676,30800.938030,30818.602917,30836.270335,
30853.940284,30871.612763,30889.287772,30906.965310,30924.645376,30942.327969,30960.013089,30977.700734,
30995.390905,31013.083600,31030.778819,31048.476561,31066.176826,31083.879612,31101.584918,31119.292745,
31137.003092,31154.715957,31172.431340,31190.149240,31207.869657,31225.592590,31243.318038,31261.046000,
31278.776476,31296.509465,31314.244967,31331.982980,31349.723504,31367.466538,31385.212081,31402.960133,
31420.710693,31438.463761,31456.219335,31473.977415,31491.738000,31509.501090,31527.266683,31545.034780,
31562.805379,31580.578479,31598.354081,31616.132183,31633.912784,31651.695884,31669.481483,31687.269578,
31705.060171,31722.853260,31740.648844,31758.446922,31776.247495,31794.050561,31811.856119,31829.664169,
31847.474711,31865.287743,31883.103264,31900.921275,31918.741774,31936.564761,31954.390235,31972.218195,
31990.048640,32007.881571,32025.716986,32043.554884,32061.395265,32079.238128,32097.083473,32114.931298,
32132.781604,32150.634389,32168.489652,32186.347394,32204.207613,32222.070308,32239.935480,32257.803127,
32275.673248,32293.545843,32311.420912,32329.298453,32347.178465,32365.060949,32382.945904,32400.833328,
32418.723221,32436.615583,32454.510412,32472.407709,32490.307472,32508.209700,32526.114394,32544.021552,
32561.931173,32579.843258,32597.757805,32615.674814,32633.594283,32651.516213,32669.440602,32687.367451,
32705.296757,32723.228521,32741.162743,32759.099420,32777.038553,32794.980141,32812.924183,32830.870678,
32848.819627,32866.771027,32884.724879,32902.681182,32920.639936,32938.601139,32956.564790,32974.530890,
32992.499437,33010.470432,33028.443872,33046.419758,33064.398089,33082.378864,33100.362083,33118.347744,
33136.335848,33154.326393,33172.319379,33190.314805,33208.312671,33226.312976,33244.315719,33262.320900,
33280.328517,33298.338571,33316.351061,33334.365985,33352.383344,33370.403136,33388.425361,33406.450019,
33424.477108,33442.506628,33460.538578,33478.572959,33496.609768,33514.649006,33532.690671,33550.734763,
33568.781282,33586.830227,33604.881597,33622.935391,33640.991609,33659.050250,33677.111314,33695.174800,
33713.240706,33731.309034,33749.379781,33767.452948,33785.528533,33803.606536,33821.686957,33839.769794,
33857.855047,33875.942716,33894.032799,33912.125296,33930.220207,33948.317531,33966.417267,33984.519414,
34002.623973,34020.730941,34038.840320,34056.952107,34075.066302,34093.182905,34111.301916,34129.423332,
34147.547154,34165.673382,34183.802014,34201.933050,34220.066489,34238.202330,34256.340574,34274.481219,
34292.624264,34310.769710,34328.917555,34347.067799,34365.220440,34383.375480,34401.532916,34419.692748,
34437.854976,34456.019599,34474.186617,34492.356028,34510.527832,34528.702028,34546.878617,34565.057596,
34583.238966,34601.422726,34619.608876,34637.797414,34655.988340,34674.181653,34692.377354,34710.575440,
34728.775912,34746.978769,34765.184010,34783.391635,34801.601643,34819.814033,34838.028805,34856.245958,
34874.465492,34892.687406,34910.911699,34929.138371,34947.367420,34965.598848,34983.832652,35002.068832,
35020.307388,35038.548319,35056.791624,35075.037303,35093.285355,35111.535779,35129.788576,35148.043743,
35166.301282,35184.561190,35202.823468,35221.088114,35239.355129,35257.624511,35275.896260,35294.170376,
35312.446857,35330.725704,35349.006915,35367.290490,35385.576428,35403.864729,35422.155392,35440.448416,
35458.743801,35477.041547,35495.341652,35513.644116,35531.948938,35550.256119,35568.565656,35586.877550,
35605.191800,35623.508406,35641.827366,35660.148680,35678.472348,35696.798369,35715.126743,35733.457468,
35751.790544,35770.125971,35788.463747,35806.803873,35825.146348,35843.491171,35861.838341,35880.187859,
35898.539722,35916.893932,35935.250486,35953.609386,35971.970629,35990.334215,36008.700144,36027.068415,
36045.439028,36063.811982,36082.187276,36100.564910,36118.944883,36137.327195,36155.711844,36174.098831,
36192.488155,36210.879815,36229.273810,36247.670141,36266.068806,36284.469805,36302.873137,36321.278801,
36339.686798,36358.097126,36376.509785,36394.924774,36413.342093,36431.761742,36450.183718,36468.608023,
36487.034654,36505.463613,36523.894898,36542.328508,36560.764443,36579.202703,36597.643286,36616.086193,
36634.531422,36652.978974,36671.428846,36689.881040,36708.335554,36726.792388,36745.251541,36763.713012,
36782.176802,36800.642908,36819.111332,36837.582072,36856.055127,36874.530498,36893.008183,36911.488182,
36929.970494,36948.455119,36966.942056,36985.431305,37003.922865,37022.416735,37040.912915,37059.411404,
37077.912202,37096.415309,37114.920722,37133.428443,37151.938470,37170.450803,37188.965441,37207.482384,
37226.001631,37244.523181,37263.047035,37281.573191,37300.101648,37318.632407,37337.165467,37355.700827,
37374.238486,37392.778444,37411.320700,37429.865255,37448.412106,37466.961255,37485.512699,37504.066439,
37522.622474,37541.180803,37559.741427,37578.304343,37596.869552,37615.437053,37634.006846,37652.578930,
37671.153305,37689.729969,37708.308922,37726.890165,37745.473695,37764.059513,37782.647618,37801.238010,
37819.830688,37838.425651,37857.022899,37875.622431,37894.224246,37912.828345,37931.434727,37950.043390,
37968.654335,37987.267561,38005.883067,38024.500853,38043.120918,38061.743262,38080.367884,38098.994783,
38117.623960,38136.255413,38154.889141,38173.525145,38192.163424,38210.803977,38229.446804,38248.091904,
38266.739276,38285.388920,38304.040836,38322.695023,38341.351480,38360.010206,38378.671202,38397.334467,
38416.000000,38434.667800,38453.337868,38472.010202,38490.684801,38509.361666,38528.040796,38546.722191,
38565.405849,38584.091770,38602.779954,38621.470399,38640.163107,38658.858075,38677.555304,38696.254793,
38714.956541,38733.660548,38752.366813,38771.075336,38789.786116,38808.499152,38827.214445,38845.931993,
38864.651796,38883.373854,38902.098166,38920.824731,38939.553548,38958.284618,38977.017940,38995.753513,
39014.491337,39033.231410,39051.973734,39070.718306,39089.465127,39108.214196,39126.965512,39145.719075,
39164.474884,39183.232940,39201.993240,39220.755785,39239.520575,39258.287608,39277.056884,39295.828403,
39314.602164,39333.378166,39352.156409,39370.936893,39389.719617,39408.504580,39427.291781,39446.081222,
39464.872899,39483.666815,39502.462966,39521.261354,39540.061978,39558.864837,39577.669930,39596.477258,
39615.286819,39634.098613,39652.912639,39671.728897,39690.547387,39709.368107,39728.191058,39747.016239,
39765.843649,39784.673288,39803.505155,39822.339249,39841.175571,39860.014120,39878.854894,39897.697895,
39916.543120,39935.390570,39954.240244,39973.092141,39991.946261,40010.802604,40029.661169,40048.521955,
40067.384962,40086.250189,40105.117636,40123.987302,40142.859188,40161.733291,40180.609612,40199.488151,
40218.368906,40237.251877,40256.137064,40275.024467,40293.914083,40312.805914,40331.699959,40350.596216,
40369.494686,40388.395368,40407.298262,40426.203366,40445.110682,40464.020207,40482.931941,40501.845884,
40520.762036,40539.680396,40558.600963,40577.523737,40596.448717,40615.375904,40634.305295,40653.236891,
40672.170692,40691.106696,40710.044904,40728.985314,40747.927927,40766.872741,40785.819757,40804.768973,
40823.720390,40842.674006,40861.629821,40880.587835,40899.548047,40918.510457,40937.475064,40956.441868,
40975.410868,40994.382063,41013.355453,41032.331038,41051.308818,41070.288790,41089.270956,41108.255314,
41127.241865,41146.230607,41165.221540,41184.214664,41203.209977,41222.207480,41241.207172,41260.209053,
41279.213122,41298.219378,41317.227821,41336.238451,41355.251267,41374.266268,41393.283455,41412.302825,
41431.324380,41450.348119,41469.374040,41488.402144,41507.432429,41526.464897,41545.499545,41564.536374,
41583.575383,41602.616571,41621.659938,41640.705484,41659.753208,41678.803109,41697.855187,41716.909442,
41735.965873,41755.024479,41774.085261,41793.148217,41812.213346,41831.280650,41850.350126,41869.421775,
41888.495596,41907.571589,41926.649753,41945.730087,41964.812591,41983.897265,42002.984108,42022.073120,
42041.164299,42060.257647,42079.353161,42098.450842,42117.550689,42136.652702,42155.756880,42174.863222,
42193.971729,42213.082399,42232.195233,42251.310229,42270.427388,42289.546708,42308.668189,42327.791832,
42346.917634,42366.045596,42385.175718,42404.307998,42423.442437,42442.579033,42461.717787,42480.858697,
42500.001764,42519.146987,42538.294365,42557.443898,42576.595586,42595.749427,42614.905422,42634.063570,
42653.223870,42672.386322,42691.550926,42710.717681,42729.886587,42749.057642,42768.230847,42787.406201,
42806.583704,42825.763355,42844.945154,42864.129099,42883.315192,42902.503430,42921.693815,42940.886344,
42960.081019,42979.277838,42998.476800,43017.677906,43036.881155,43056.086546,43075.294079,43094.503753,
43113.715569,43132.929525,43152.145621,43171.363856,43190.584230,43209.806743,43229.031395,43248.258183,
43267.487109,43286.718172,43305.951370,43325.186705,43344.424174,43363.663779,43382.905518,43402.149390,
43421.395396,43440.643535,43459.893806,43479.146209,43498.400744,43517.657409,43536.916205,43556.177132,
43575.440187,43594.705372,43613.972686,43633.242127,43652.513696,43671.787393,43691.063216,43710.341166,
43729.621241,43748.903442,43768.187767,43787.474217,43806.762791,43826.053489,43845.346309,43864.641252,
43883.938317,43903.237504,43922.538812,43941.842240,43961.147789,43980.455457,43999.765245,44019.077151,
44038.391176,44057.707319,44077.025579,44096.345956,44115.668450,44134.993059,44154.319784,44173.648625,
44192.979579,44212.312649,44231.647831,44250.985127,44270.324536,44289.666057,44309.009690,44328.355435,
44347.703290,44367.053256,44386.405332,44405.759517,44425.115812,44444.474215,44463.834726,44483.197345,
44502.562072,44521.928905,44541.297845,44560.668890,44580.042041,44599.417297,44618.794657,44638.174121,
44657.555689,44676.939360,44696.325134,44715.713010,44735.102988,44754.495067,44773.889248,44793.285528,
44812.683908,44832.084388,44851.486967,44870.891645,44890.298421,44909.707294,44929.118265,44948.531332,
44967.946496,44987.363756,45006.783111,45026.204561,45045.628105,45065.053744,45084.481476,45103.911302,
45123.343220,45142.777230,45162.213332,45181.651526,45201.091811,45220.534185,45239.978650,45259.425205,
45278.873849,45298.324581,45317.777402,45337.232310,45356.689306,45376.148388,45395.609557,45415.072812,
45434.538152,45454.005578,45473.475088,45492.946683,45512.420361,45531.896122,45551.373967,45570.853893,
45590.335902,45609.819992,45629.306164,45648.794415,45668.284748,45687.777159,45707.271651,45726.768221,
45746.266869,45765.767595,45785.270399,45804.775280,45824.282238,45843.791272,45863.302382,45882.815567,
45902.330826,45921.848161,45941.367569,45960.889051,45980.412606,45999.938233,46019.465933,46038.995705,
46058.527548,46078.061462,46097.597446,46117.135500,46136.675624,46156.217818,46175.762080,46195.308410,
46214.856808,46234.407273,46253.959806,46273.514405,46293.071070,46312.629800,46332.190596,46351.753457,
46371.318382,46390.885371,46410.454424,46430.025539,46449.598717,46469.173958,46488.751260,46508.330623,
46527.912047,46547.495532,46567.081077,46586.668681,46606.258345,46625.850067,46645.443847,46665.039685,
46684.637581,46704.237534,46723.839543,46743.443608,46763.049729,46782.657906,46802.268137,46821.880422,
46841.494762,46861.111155,46880.729601,46900.350100,46919.972651,46939.597254,46959.223908,46978.852613,
46998.483369,47018.116175,47037.751030,47057.387935,47077.026889,47096.667890,47116.310940,47135.956038,
47155.603182,47175.252374,47194.903611,47214.556895,47234.212223,47253.869597,47273.529015,47293.190478,
47312.853984,47332.519533,47352.187126,47371.856760,47391.528437,47411.202155,47430.877915,47450.555715,
47470.235555,47489.917436,47509.601356,47529.287315,47548.975312,47568.665348,47588.357421,47608.051532,
47627.747680,47647.445864,47667.146085,47686.848341,47706.552632,47726.258958,47745.967319,47765.677713,
47785.390142,47805.104603,47824.821097,47844.539623,47864.260181,47883.982771,47903.707392,47923.434043,
47943.162725,47962.893436,47982.626177,48002.360947,48022.097745,48041.836572,48061.577426,48081.320307,
48101.065216,48120.812151,48140.561111,48160.312098,48180.065110,48199.820146,48219.577207,48239.336292,
48259.097401,48278.860532,48298.625687,48318.392864,48338.162062,48357.933282,48377.706523,48397.481785,
48417.259067,48437.038369,48456.819691,48476.603031,48496.388390,48516.175767,48535.965162,48555.756575,
48575.550004,48595.345450,48615.142912,48634.942390,48654.743883,48674.547391,48694.352913,48714.160450,
48733.970000,48753.781563,48773.595140,48793.410728,48813.228329,48833.047942,48852.869565,48872.693200,
48892.518845,48912.346500,48932.176164,48952.007838,48971.841520,48991.677211,49011.514910,49031.354616,
49051.196330,49071.040050,49090.885777,49110.733509,49130.583247,49150.434991,49170.288738,49190.144491,
49210.002247,49229.862007,49249.723769,49269.587535,49289.453302,49309.321072,49329.190843,49349.062615,
49368.936388,49388.812162,49408.689935,49428.569707,49448.451479,49468.335249,49488.221018,49508.108784,
49527.998548,49547.890309,49567.784066,49587.679820,49607.577570,49627.477315,49647.379055,49667.282790,
49687.188519,49707.096242,49727.005959,49746.917669,49766.831371,49786.747065,49806.664752,49826.584429,
49846.506098,49866.429758,49886.355408,49906.283048,49926.212677,49946.144295,49966.077902,49986.013497,
50005.951080,50025.890651,50045.832209,50065.775753,50085.721284,50105.668801,50125.618303,50145.569790,
50165.523262,50185.478719,50205.436159,50225.395583,50245.356990,50265.320380,50285.285752,50305.253106,
50325.222442,50345.193759,50365.167057,50385.142335,50405.119593,50425.098830,50445.080047,50465.063243,
50485.048417,50505.035569,50525.024699,50545.015806,50565.008891,50585.003951,50605.000988,50625.000000,
50645.000987,50665.003950,50685.008887,50705.015798,50725.024683,50745.035541,50765.048373,50785.063176,
50805.079953,50825.098700,50845.119420,50865.142110,50885.166771,50905.193402,50925.222003,50945.252574,
50965.285113,50985.319621,51005.356098,51025.394543,51045.434955,51065.477334,51085.521680,51105.567992,
51125.616271,51145.666515,51165.718724,51185.772898,51205.829037,51225.887139,51245.947206,51266.009235,
51286.073228,51306.139183,51326.207100,51346.276979,51366.348820,51386.422621,51406.498383,51426.576105,
51446.655787,51466.737429,51486.821030,51506.906589,51526.994107,51547.083582,51567.175015,51587.268406,
51607.363753,51627.461057,51647.560316,51667.661532,51687.764702,51707.869828,51727.976908,51748.085942,
51768.196930,51788.309871,51808.424765,51828.541612,51848.660411,51868.781162,51888.903864,51909.028518,
51929.155122,51949.283677,51969.414181,51989.546636,52009.681039,52029.817391,52049.955692,52070.095941,
52090.238137,52110.382281,52130.528372,52150.676409,52170.826392,52190.978322,52211.132197,52231.288017,
52251.445781,52271.605490,52291.767143,52311.930739,52332.096279,52352.263761,52372.433186,52392.604553,
52412.777862,52432.953112,52453.130303,52473.309434,52493.490506,52513.673518,52533.858469,52554.045359,
52574.234188,52594.424955,52614.617660,52634.812303,52655.008883,52675.207400,52695.407853,52715.610242,
52735.814568,52756.020828,52776.229024,52796.439154,52816.651218,52836.865217,52857.081149,52877.299014,
52897.518811,52917.740542,52937.964204,52958.189798,52978.417323,52998.646779,53018.878166,53039.111483,
53059.346730,53079.583906,53099.823011,53120.064045,53140.307008,53160.551898,53180.798716,53201.047461,
53221.298134,53241.550732,53261.805257,53282.061708,53302.320084,53322.580385,53342.842611,53363.106761,
53383.372835,53403.640833,53423.910754,53444.182598,53464.456364,53484.732053,53505.009663,53525.289195,
53545.570647,53565.854021,53586.139315,53606.426528,53626.715661,53647.006714,53667.299685,53687.594575,
53707.891383,53728.190109,53748.490752,53768.793312,53789.097789,53809.404183,53829.712492,53850.022717,
53870.334857,53890.648912,53910.964881,53931.282765,53951.602563,53971.924274,53992.247898,54012.573434,
54032.900883,54053.230244,54073.561517,54093.894701,54114.229796,54134.566802,54154.905717,54175.246543,
54195.589278,54215.933922,54236.280475,54256.628936,54276.979306,54297.331583,54317.685767,54338.041859,
54358.399857,54378.759761,54399.121571,54419.485287,54439.850908,54460.218434,54480.587864,54500.959199,
54521.332437,54541.707579,54562.084623,54582.463571,54602.844421,54623.227172,54643.611826,54663.998381,
54684.386836,54704.777192,54725.169449,54745.563605,54765.959661,54786.357616,54806.757470,54827.159222,
54847.562872,54867.968420,54888.375866,54908.785208,54929.196448,54949.609583,54970.024615,54990.441542,
55010.860364,55031.281082,55051.703694,55072.128200,55092.554600,55112.982894,55133.413081,55153.845160,
55174.279132,55194.714996,55215.152752,55235.592400,55256.033938,55276.477367,55296.922687,55317.369897,
55337.818996,55358.269984,55378.722862,55399.177628,55419.634283,55440.092825,55460.553255,55481.015572,
55501.479776,55521.945867,55542.413844,55562.883706,55583.355454,55603.829088,55624.304606,55644.782008,
55665.261295,55685.742465,55706.225519,55726.710456,55747.197276,55767.685978,55788.176562,55808.669027,
55829.163374,55849.659602,55870.157711,55890.657700,55911.159569,55931.663318,55952.168945,55972.676452,
55993.185837,56013.697101,56034.210242,56054.725261,56075.242158,56095.760931,56116.281580,56136.804106,
56157.328507,56177.854784,56198.382937,56218.912964,56239.444865,56259.978641,56280.514290,56301.051813,
56321.591209,56342.132477,56362.675618,56383.220632,56403.767516,56424.316273,56444.866900,56465.419398,
56485.973766,56506.530005,56527.088113,56547.648090,56568.209936,56588.773651,56609.339235,56629.906686,
56650.476005,56671.047192,56691.620245,56712.195165,56732.771951,56753.350603,56773.931121,56794.513504,
56815.097752,56835.683865,56856.271841,56876.861682,56897.453387,56918.046954,56938.642385,56959.239678,
56979.838833,57000.439850,57021.042729,57041.647469,57062.254070,57082.862532,57103.472853,57124.085035,
57144.699076,57165.314976,57185.932736,57206.552353,57227.173829,57247.797163,57268.422355,57289.049403,
57309.678309,57330.309071,57350.941689,57371.576163,57392.212493,57412.850678,57433.490717,57454.132611,
57474.776360,57495.421962,57516.069418,57536.718727,57557.369889,57578.022903,57598.677770,57619.334489,
57639.993059,57660.653480,57681.315752,57701.979875,57722.645848,57743.313670,57763.983343,57784.654864,
57805.328235,57826.003454,57846.680521,57867.359436,57888.040199,57908.722809,57929.407266,57950.093569,
57970.781719,57991.471714,58012.163556,58032.857242,58053.552774,58074.250150,58094.949370,58115.650434,
58136.353342,58157.058093,58177.764687,58198.473124,58219.183403,58239.895524,58260.609486,58281.325290,
58302.042935,58322.762421,58343.483747,58364.206913,58384.931919,58405.658764,58426.387448,58447.117971,
58467.850332,58488.584531,58509.320568,58530.058442,58550.798154,58571.539702,58592.283087,58613.028307,
58633.775364,58654.524256,58675.274983,58696.027545,58716.781941,58737.538172,58758.296236,58779.056134,
58799.817865,58820.581429,58841.346826,58862.114054,58882.883115,58903.654007,58924.426730,58945.201285,
58965.977670,58986.755885,59007.535930,59028.317805,59049.101509,59069.887042,59090.674404,59111.463594,
59132.254612,59153.047457,59173.842131,59194.638631,59215.436958,59236.237111,59257.039091,59277.842896,
59298.648527,59319.455983,59340.265263,59361.076368,59381.889298,59402.704051,59423.520628,59444.339028,
59465.159251,59485.981296,59506.805164,59527.630853,59548.458365,59569.287697,59590.118851,59610.951825,
59631.786619,59652.623234,59673.461668,59694.301922,59715.143995,59735.987886,59756.833596,59777.681124,
59798.530470,59819.381634,59840.234614,59861.089412,59881.946025,59902.804456,59923.664702,59944.526763,
59965.390640,59986.256332,60007.123839,60027.993160,60048.864295,60069.737243,60090.612005,60111.488580,
60132.366968,60153.247168,60174.129181,60195.013005,60215.898641,60236.786088,60257.675345,60278.566414,
60299.459292,60320.353981,60341.250479,60362.148786,60383.048902,60403.950827,60424.854561,60445.760102,
60466.667451,60487.576608,60508.487572,60529.400342,60550.314919,60571.231302,60592.149491,60613.069486,
60633.991286,60654.914890,60675.840300,60696.767513,60717.696531,60738.627352,60759.559977,60780.494405,
60801.430635,60822.368668,60843.308503,60864.250140,60885.193578,60906.138818,60927.085858,60948.034699,
60968.985341,60989.937782,61010.892023,61031.848063,61052.805903,61073.765541,61094.726977,61115.690212,
61136.655244,61157.622074,61178.590701,61199.561125,61220.533345,61241.507362,61262.483175,61283.460783,
61304.440187,61325.421385,61346.404379,61367.389167,61388.375748,61409.364124,61430.354293,61451.346256,
61472.340011,61493.335559,61514.332899,61535.332031,61556.332955,61577.335670,61598.340176,61619.346473,
61640.354561,61661.364438,61682.376105,61703.389562,61724.404808,61745.421843,61766.440667,61787.461279,
61808.483679,61829.507866,61850.533841,61871.561603,61892.591152,61913.622487,61934.655609,61955.690516,
61976.727209,61997.765687,62018.805950,62039.847998,62060.891830,62081.937447,62102.984847,62124.034030,
62145.084997,62166.137746,62187.192278,62208.248592,62229.306688,62250.366566,62271.428225,62292.491666,
62313.556886,62334.623888,62355.692669,62376.763231,62397.835571,62418.909692,62439.985591,62461.063268,
62482.142724,62503.223958,62524.306970,62545.391759,62566.478325,62587.566669,62608.656788,62629.748684,
62650.842356,62671.937804,62693.035026,62714.134024,62735.234797,62756.337344,62777.441665,62798.547760,
62819.655629,62840.765271,62861.876685,62882.989873,62904.104832,62925.221564,62946.340068,62967.460343,
62988.582389,63009.706206,63030.831794,63051.959152,63073.088280,63094.219178,63115.351845,63136.486281,
63157.622486,63178.760459,63199.900200,63221.041710,63242.184987,63263.330032,63284.476843,63305.625421,
63326.775766,63347.927876,63369.081753,63390.237395,63411.394802,63432.553975,63453.714912,63474.877613,
63496.042079,63517.208308,63538.376300,63559.546056,63580.717575,63601.890856,63623.065900,63644.242706,
63665.421273,63686.601602,63707.783692,63728.967543,63750.153154,63771.340526,63792.529658,63813.720549,
63834.913200,63856.107609,63877.303778,63898.501705,63919.701390,63940.902834,63962.106034,63983.310993,
64004.517708,64025.726180,64046.936408,64068.148393,64089.362134,64110.577630,64131.794881,64153.013888,
64174.234649,64195.457164,64216.681434,64237.907458,64259.135235,64280.364765,64301.596049,64322.829085,
64344.063873,64365.300414,64386.538707,64407.778751,64429.020546,64450.264092,64471.509389,64492.756436,
64514.005234,64535.255781,64556.508078,64577.762124,64599.017919,64620.275462,64641.534754,64662.795794,
64684.058582,64705.323117,64726.589400,64747.857429,64769.127205,64790.398728,64811.671996,64832.947010,
64854.223770,64875.502275,64896.782525,64918.064520,64939.348259,64960.633742,64981.920969,65003.209939,
65024.500652,65045.793109,65067.087308,65088.383249,65109.680933,65130.980358,65152.281525,65173.584433,
65194.889082,65216.195472,65237.503601,65258.813471,65280.125081,65301.438431,65322.753519,65344.070347,
65365.388913,65386.709217,65408.031260,65429.355040,65450.680558,65472.007814,65493.336806,65514.667535,
65536.000000,65557.334201,65578.670138,65600.007811,65621.347219,65642.688362,65664.031240,65685.375852,
65706.722198,65728.070278,65749.420092,65770.771639,65792.124919,65813.479931,65834.836676,65856.195154,
65877.555363,65898.917304,65920.280976,65941.646379,65963.013513,65984.382377,66005.752972,66027.125296,
66048.499350,66069.875134,66091.252646,66112.631888,66134.012858,66155.395556,66176.779982,66198.166136,
66219.554017,66240.943626,66262.334961,66283.728022,66305.122811,66326.519325,66347.917564,66369.317530,
66390.719220,66412.122636,66433.527775,66454.934640,66476.343228,66497.753540,66519.165576,66540.579335,
66561.994817,66583.412021,66604.830948,66626.251597,66647.673968,66669.098061,66690.523874,66711.951409,
66733.380665,66754.811641,66776.244337,66797.678753,66819.114889,66840.552744,66861.992318,66883.433611,
66904.876623,66926.321353,66947.767800,66969.215966,66990.665849,67012.117449,67033.570766,67055.025799,
67076.482549,67097.941015,67119.401197,67140.863094,67162.326707,67183.792034,67205.259076,67226.727833,
67248.198304,67269.670488,67291.144386,67312.619998,67334.097322,67355.576360,67377.057109,67398.539571,
67420.023745,67441.509631,67462.997228,67484.486536,67505.977556,67527.470285,67548.964725,67570.460875,
67591.958735,67613.458304,67634.959583,67656.462570,67677.967267,67699.473671,67720.981784,67742.491605,
67764.003133,67785.516368,67807.031311,67828.547960,67850.066316,67871.586379,67893.108147,67914.631621,
67936.156800,67957.683684,67979.212274,68000.742568,68022.274566,68043.808269,68065.343675,68086.880785,
68108.419598,68129.960114,68151.502333,68173.046254,68194.591878,68216.139203,68237.688230,68259.238959,
68280.791388,68302.345519,68323.901350,68345.458881,68367.018113,68388.579044,68410.141675,68431.706005,
68453.272034,68474.839761,68496.409188,68517.980312,68539.553134,68561.127654,68582.703871,68604.281786,
68625.861397,68647.442705,68669.025709,68690.610409,68712.196805,68733.784896,68755.374683,68776.966165,
68798.559341,68820.154212,68841.750777,68863.349036,68884.948988,68906.550634,68928.153973,68949.759005,
68971.365730,68992.974147,69014.584256,69036.196056,69057.809549,69079.424732,69101.041606,69122.660172,
69144.280427,69165.902373,69187.526009,69209.151335,69230.778349,69252.407054,69274.037446,69295.669528,
69317.303298,69338.938756,69360.575902,69382.214735,69403.855256,69425.497464,69447.141358,69468.786939,
69490.434207,69512.083160,69533.733799,69555.386123,69577.040133,69598.695828,69620.353207,69642.012271,
69663.673019,69685.335450,69706.999566,69728.665365,69750.332846,69772.002011,69793.672859,69815.345388,
69837.019600,69858.695493,69880.373068,69902.052325,69923.733262,69945.415880,69967.100179,69988.786158,
70010.473816,70032.163155,70053.854173,70075.546870,70097.241246,70118.937301,70140.635034,70162.334445,
70184.035535,70205.738302,70227.442746,70249.148867,70270.856666,70292.566140,70314.277292,70335.990119,
70357.704622,70379.420801,70401.138655,70422.858184,70444.579387,70466.302266,70488.026818,70509.753045,
70531.480945,70553.210519,70574.941767,70596.674687,70618.409280,70640.145545,70661.883482,70683.623092,
70705.364373,70727.107326,70748.851950,70770.598244,70792.346210,70814.095846,70835.847152,70857.600128,
70879.354773,70901.111088,70922.869072,70944.628725,70966.390047,70988.153037,71009.917695,71031.684020,
71053.452014,71075.221675,71096.993003,71118.765998,71140.540659,71162.316986,71184.094980,71205.874640,
71227.655965,71249.438955,71271.223611,71293.009931,71314.797916,71336.587565,71358.378878,71380.171855,
71401.966495,71423.762799,71445.560765,71467.360395,71489.161687,71510.964641,71532.769257,71554.575535,
71576.383475,71598.193075,71620.004337,71641.817259,71663.631842,71685.448085,71707.265988,71729.085551,
71750.906774,71772.729655,71794.554196,71816.380395,71838.208252,71860.037768,71881.868942,71903.701774,
71925.536263,71947.372409,71969.210212,71991.049672,72012.890788,72034.733561,72056.577989,72078.424073,
72100.271813,72122.121207,72143.972257,72165.824962,72187.679320,72209.535333,72231.393000,72253.252321,
72275.113295,72296.975923,72318.840203,72340.706136,72362.573721,72384.442959,72406.313848,72428.186389,
72450.060582,72471.936426,72493.813921,72515.693066,72537.573862,72559.456308,72581.340404,72603.226150,
72625.113545,72647.002590,72668.893283,72690.785625,72712.679616,72734.575255,72756.472541,72778.371476,
72800.272058,72822.174287,72844.078163,72865.983686,72887.890855,72909.799670,72931.710132,72953.622239,
72975.535992,72997.451390,73019.368433,73041.287120,73063.207453,73085.129429,73107.053050,73128.978314,
73150.905221,73172.833772,73194.763966,73216.695803,73238.629282,73260.564404,73282.501168,73304.439573,
73326.379620,73348.321308,73370.264638,73392.209608,73414.156218,73436.104469,73458.054360,73480.005891,
73501.959062,73523.913871,73545.870320,73567.828408,73589.788134,73611.749499,73633.712502,73655.677143,
73677.643421,73699.611336,73721.580889,73743.552079,73765.524905,73787.499368,73809.475467,73831.453202,
73853.432572,73875.413578,73897.396219,73919.380496,73941.366406,73963.353952,73985.343131,74007.333944,
74029.326392,74051.320472,74073.316186,74095.313533,74117.312513,74139.313125,74161.315369,74183.319246,
74205.324754,74227.331894,74249.340665,74271.351067,74293.363100,74315.376763,74337.392057,74359.408981,
74381.427535,74403.447719,74425.469532,74447.492974,74469.518045,74491.544744,74513.573072,74535.603028,
74557.634612,74579.667824,74601.702663,74623.739130,74645.777223,74667.816943,74689.858290,74711.901262,
74733.945861,74755.992086,74778.039936,74800.089411,74822.140512,74844.193237,74866.247587,74888.303561,
74910.361159,74932.420382,74954.481227,74976.543696,74998.607789,75020.673504,75042.740842,75064.809802,
75086.880384,75108.952589,75131.026415,75153.101862,75175.178931,75197.257621,75219.337931,75241.419862,
75263.503413,75285.588585,75307.675376,75329.763786,75351.853816,75373.945465,75396.038733,75418.133620,
75440.230125,75462.328248,75484.427989,75506.529348,75528.632324,75550.736917,75572.843127,75594.950954,
75617.060397,75639.171457,75661.284133,75683.398424,75705.514331,75727.631854,75749.750991,75771.871743,
75793.994110,75816.118091,75838.243686,75860.370895,75882.499718,75904.630154,75926.762204,75948.895866,
75971.031141,75993.168029,76015.306528,76037.446640,76059.588364,76081.731699,76103.876645,76126.023203,
76148.171371,76170.321150,76192.472539,76214.625539,76236.780148,76258.936367,76281.094195,76303.253633,
76325.414679,76347.577335,76369.741598,76391.907471,76414.074951,76436.244038,76458.414734,76480.587037,
76502.760946,76524.936463,76547.113587,76569.292316,76591.472652,76613.654594,76635.838142,76658.023295,
76680.210053,76702.398416,76724.588384,76746.779957,76768.973133,76791.167914,76813.364299,76835.562288,
76857.761879,76879.963074,76902.165872,76924.370273,76946.576276,76968.783881,76990.993088,77013.203897,
77035.416307,77057.630319,77079.845932,77102.063146,77124.281960,77146.502375,77168.724389,77190.948004,
77213.173218,77235.400032,77257.628445,77279.858457,77302.090068,77324.323278,77346.558085,77368.794491,
77391.032495,77413.272096,77435.513295,77457.756090,77480.000483,77502.246472,77524.494058,77546.743240,
77568.994018,77591.246392,77613.500362,77635.755926,77658.013086,77680.271841,77702.532190,77724.794134,
77747.057672,77769.322804,77791.589530,77813.857849,77836.127761,77858.399266,77880.672365,77902.947056,
77925.223339,77947.501214,77969.780681,77992.061740,78014.344390,78036.628632,78058.914465,78081.201888,
78103.490902,78125.781506,78148.073700,78170.367484,78192.662858,78214.959821,78237.258373,78259.558515,
78281.860245,78304.163563,78326.468470,78348.774965,78371.083047,78393.392718,78415.703975,78438.016820,
78460.331252,78482.647270,78504.964875,78527.284066,78549.604843,78571.927206,78594.251154,78616.576688,
78638.903807,78661.232511,78683.562799,78705.894672,78728.228129,78750.563170,78772.899795,78795.238003,
78817.577795,78839.919170,78862.262127,78884.606668,78906.952790,78929.300495,78951.649782,78974.000651,
78996.353101,79018.707132,79041.062745,79063.419938,79085.778712,79108.139067,79130.501001,79152.864516,
79175.229610,79197.596284,79219.964537,79242.334369,79264.705780,79287.078770,79309.453338,79331.829484,
79354.207208,79376.586510,79398.967389,79421.349846,79443.733880,79466.119490,79488.506677,79510.895441,
79533.285781,79555.677696,79578.071188,79600.466255,79622.862897,79645.261114,79667.660906,79690.062273,
79712.465214,79734.869730,79757.275819,79779.683482,79802.092718,79824.503528,79846.915911,79869.329867,
79891.745395,79914.162496,79936.581169,79959.001414,79981.423231,80003.846619,80026.271579,80048.698109,
80071.126211,80093.555883,80115.987126,80138.419939,80160.854321,80183.290274,80205.727796,80228.166888,
80250.607548,80273.049778,80295.493576,80317.938942,80340.385877,80362.834380,80385.284451,80407.736089,
80430.189295,80452.644067,80475.100407,80497.558313,80520.017786,80542.478825,80564.941430,80587.405601,
80609.871338,80632.338640,80654.807507,80677.277939,80699.749936,80722.223497,80744.698623,80767.175313,
80789.653567,80812.133384,80834.614765,80857.097708,80879.582215,80902.068285,80924.555917,80947.045112,
80969.535869,80992.028187,81014.522068,81037.017510,81059.514513,81082.013077,81104.513202,81127.014887,
81149.518133,81172.022940,81194.529306,81217.037232,81239.546717,81262.057762,81284.570365,81307.084528,
81329.600249,81352.117529,81374.636367,81397.156763,81419.678717,81442.202229,81464.727298,81487.253924,
81509.782107,81532.311846,81554.843142,81577.375995,81599.910403,81622.446368,81644.983888,81667.522963,
81690.063594,81712.605780,81735.149520,81757.694816,81780.241665,81802.790069,81825.340026,81847.891538,
81870.444602,81892.999220,81915.555392,81938.113116,81960.672392,81983.233221,82005.795603,82028.359536,
82050.925021,82073.492058,82096.060646,82118.630786,82141.202476,82163.775717,82186.350508,82208.926850,
82231.504742,82254.084184,82276.665175,82299.247716,82321.831806,82344.417445,82367.004633,82389.593370,
82412.183655,82434.775488,82457.368869,82479.963798,82502.560275,82525.158298,82547.757869,82570.358987,
82592.961652,82615.565863,82638.171620,82660.778923,82683.387772,82705.998167,82728.610107,82751.223593,
82773.838623,82796.455199,82819.073319,82841.692983,82864.314191,82886.936943,82909.561240,82932.187079,
82954.814462,82977.443388,83000.073857,83022.705869,83045.339423,83067.974519,83090.611158,83113.249338,
83135.889060,83158.530323,83181.173128,83203.817473,83226.463360,83249.110787,83271.759754,83294.410261,
83317.062309,83339.715896,83362.371023,83385.027689,83407.685894,83430.345638,83453.006921,83475.669742,
83498.334102,83521.000000,83543.667435,83566.336409,83589.006919,83611.678967,83634.352552,83657.027674,
83679.704332,83702.382527,83725.062258,83747.743525,83770.426328,83793.110666,83815.796540,83838.483949,
83861.172893,83883.863372,83906.555385,83929.248932,83951.944014,83974.640629,83997.338779,84020.038461,
84042.739677,84065.442427,84088.146709,84110.852523,84133.559870,84156.268750,84178.979161,84201.691105,
84224.404580,84247.119586,84269.836124,84292.554192,84315.273792,84337.994922,84360.717582,84383.441773,
84406.167494,84428.894744,84451.623524,84474.353833,84497.085672,84519.819040,84542.553936,84565.290361,
84588.028314,84610.767795,84633.508804,84656.251341,84678.995406,84701.740998,84724.488117,84747.236763,
84769.986935,84792.738634,84815.491860,84838.246611,84861.002888,84883.760691,84906.520020,84929.280874,
84952.043252,84974.807156,84997.572584,85020.339537,85043.108014,85065.878015,85088.649540,85111.422589,
85134.197161,85156.973256,85179.750874,85202.530015,85225.310679,85248.092865,85270.876573,85293.661804,
85316.448556,85339.236830,85362.026625,85384.817941,85407.610778,85430.405137,85453.201015,85475.998414,
85498.797334,85521.597773,85544.399732,85567.203210,85590.008208,85612.814726,85635.622762,85658.432317,
85681.243390,85704.055982,85726.870092,85749.685720,85772.502865,85795.321528,85818.141709,85840.963407,
85863.786621,85886.611353,85909.437601,85932.265365,85955.094645,85977.925442,86000.757754,86023.591581,
86046.426924,86069.263782,86092.102155,86114.942043,86137.783446,86160.626362,86183.470793,86206.316738,
86229.164196,86252.013168,86274.863653,86297.715652,86320.569163,86343.424187,86366.280724,86389.138772,
86411.998333,86434.859406,86457.721991,86480.586087,86503.451695,86526.318813,86549.187443,86572.057583,
86594.929234,86617.802395,86640.677067,86663.553248,86686.430939,86709.310139,86732.190849,86755.073068,
86777.956796,86800.842033,86823.728778,86846.617031,86869.506793,86892.398062,86915.290840,86938.185124,
86961.080917,86983.978216,87006.877022,87029.777335,87052.679155,87075.582481,87098.487313,87121.393651,
87144.301495,87167.210844,87190.121699,87213.034059,87235.947924,87258.863293,87281.780167,87304.698546,
87327.618429,87350.539815,87373.462706,87396.387100,87419.312997,87442.240398,87465.169302,87488.099708,
87511.031617,87533.965029,87556.899942,87579.836358,87602.774275,87625.713694,87648.654615,87671.597037,
87694.540959,87717.486383,87740.433307,87763.381732,87786.331657,87809.283082,87832.236007,87855.190431,
87878.146355,87901.103778,87924.062700,87947.023121,87969.985041,87992.948459,88015.913376,88038.879790,
88061.847703,88084.817113,88107.788021,88130.760426,88153.734328,88176.709727,88199.686623,88222.665015,
88245.644903,88268.626288,88291.609169,88314.593545,88337.579417,88360.566785,88383.555647,88406.546004,
88429.537857,88452.531204,88475.526045,88498.522380,88521.520209,88544.519533,88567.520349,88590.522660,
88613.526463,88636.531759,88659.538549,88682.546831,88705.556605,88728.567872,88751.580630,88774.594881,
88797.610623,88820.627857,88843.646582,88866.666798,88889.688505,88912.711702,88935.736391,88958.762569,
88981.790238,89004.819396,89027.850045,89050.882182,89073.915810,89096.950926,89119.987531,89143.025625,
89166.065208,89189.106279,89212.148839,89235.192886,89258.238421,89281.285444,89304.333954,89327.383951,
89350.435436,89373.488407,89396.542865,89419.598809,89442.656240,89465.715157,89488.775560,89511.837448,
89534.900822,89557.965681,89581.032026,89604.099855,89627.169169,89650.239968,89673.312251,89696.386018,
89719.461269,89742.538004,89765.616223,89788.695925,89811.777110,89834.859779,89857.943930,89881.029563,
89904.116680,89927.205278,89950.295359,89973.386921,89996.479965,90019.574491,90042.670498,90065.767986,
90088.866955,90111.967405,90135.069335,90158.172746,90181.277637,90204.384008,90227.491859,90250.601189,
90273.711999,90296.824288,90319.938056,90343.053303,90366.170028,90389.288232,90412.407915,90435.529075,
90458.651713,90481.775830,90504.901423,90528.028494,90551.157042,90574.287067,90597.418569,90620.551547,
90643.686002,90666.821933,90689.959340,90713.098223,90736.238582,90759.380416,90782.523725,90805.668509,
90828.814769,90851.962503,90875.111711,90898.262394,90921.414551,90944.568182,90967.723286,90990.879865,
91014.037916,91037.197441,91060.358439,91083.520910,91106.684853,91129.850269,91153.017157,91176.185517,
91199.355349,91222.526653,91245.699428,91268.873675,91292.049392,91315.226581,91338.405241,91361.585371,
91384.766971,91407.950042,91431.134582,91454.320593,91477.508073,91500.697023,91523.887442,91547.079330,
91570.272687,91593.467513,91616.663807,91639.861569,91663.060800,91686.261499,91709.463665,91732.667300,
91755.872401,91779.078970,91802.287006,91825.496508,91848.707478,91871.919914,91895.133816,91918.349184,
91941.566019,91964.784319,91988.004084,92011.225315,92034.448011,92057.672173,92080.897799,92104.124889,
92127.353444,92150.583464,92173.814947,92197.047895,92220.282306,92243.518180,92266.755518,92289.994320,
92313.234584,92336.476311,92359.719500,92382.964153,92406.210267,92429.457843,92452.706881,92475.957381,
92499.209343,92522.462766,92545.717649,92568.973994,92592.231800,92615.491066,92638.751793,92662.013980,
92685.277627,92708.542734,92731.809300,92755.077326,92778.346811,92801.617756,92824.890159,92848.164021,
92871.439342,92894.716121,92917.994359,92941.274054,92964.555207,92987.837818,93011.121886,93034.407412,
93057.694395,93080.982835,93104.272731,93127.564084,93150.856894,93174.151159,93197.446881,93220.744059,
93244.042692,93267.342781,93290.644325,93313.947324,93337.251778,93360.557687,93383.865050,93407.173868,
93430.484140,93453.795866,93477.109046,93500.423679,93523.739766,93547.057307,93570.376300,93593.696746,
93617.018646,93640.341997,93663.666801,93686.993058,93710.320766,93733.649926,93756.980538,93780.312602,
93803.646117,93826.981082,93850.317499,93873.655367,93896.994685,93920.335454,93943.677672,93967.021341,
93990.366460,94013.713028,94037.061046,94060.410514,94083.761430,94107.113796,94130.467610,94153.822873,
94177.179584,94200.537743,94223.897351,94247.258406,94270.620910,94293.984860,94317.350258,94340.717104,
94364.085396,94387.455135,94410.826321,94434.198953,94457.573031,94480.948556,94504.325526,94527.703943,
94551.083805,94574.465112,94597.847864,94621.232062,94644.617704,94668.004791,94691.393322,94714.783298,
94738.174718,94761.567582,94784.961889,94808.357641,94831.754835,94855.153473,94878.553554,94901.955078,
94925.358045,94948.762454,94972.168305,94995.575599,95018.984334,95042.394512,95065.806131,95089.219192,
95112.633694,95136.049637,95159.467021,95182.885845,95206.306110,95229.727816,95253.150962,95276.575548,
95300.001574,95323.429039,95346.857944,95370.288289,95393.720072,95417.153295,95440.587956,95464.024056,
95487.461595,95510.900572,95534.340986,95557.782839,95581.226130,95604.670858,95628.117023,95651.564626,
95675.013666,95698.464143,95721.916056,95745.369406,95768.824192,95792.280414,95815.738073,95839.197167,
95862.657697,95886.119662,95909.583063,95933.047898,95956.514169,95979.981874,96003.451014,96026.921589,
96050.393598,96073.867040,96097.341917,96120.818227,96144.295971,96167.775148,96191.255759,96214.737802,
96238.221278,96261.706187,96285.192529,96308.680302,96332.169508,96355.660146,96379.152215,96402.645717,
96426.140649,96449.637013,96473.134808,96496.634034,96520.134691,96543.636778,96567.140296,96590.645243,
96614.151621,96637.659429,96661.168667,96684.679334,96708.191430,96731.704955,96755.219910,96778.736293,
96802.254105,96825.773346,96849.294015,96872.816111,96896.339636,96919.864589,96943.390969,96966.918777,
96990.448012,97013.978674,97037.510763,97061.044279,97084.579221,97108.115590,97131.653385,97155.192606,
97178.733253,97202.275325,97225.818824,97249.363747,97272.910096,97296.457870,97320.007068,97343.557692,
97367.109739,97390.663211,97414.218108,97437.774428,97461.332172,97484.891340,97508.451931,97532.013945,
97555.577383,97579.142244,97602.708527,97626.276233,97649.845361,97673.415912,97696.987885,97720.561280,
97744.136096,97767.712334,97791.289993,97814.869074,97838.449576,97862.031499,97885.614842,97909.199606,
97932.785790,97956.373395,97979.962419,98003.552864,98027.144728,98050.738012,98074.332715,98097.928837,
98121.526378,98145.125338,98168.725717,98192.327514,98215.930730,98239.535364,98263.141415,98286.748885,
98310.357772,98333.968077,98357.579799,98381.192938,98404.807494,98428.423467,98452.040857,98475.659663,
98499.279885,98522.901524,98546.524578,98570.149048,98593.774934,98617.402235,98641.030952,98664.661084,
98688.292630,98711.925591,98735.559967,98759.195758,98782.832962,98806.471581,98830.111614,98853.753060,
98877.395920,98901.040193,98924.685880,98948.332980,98971.981492,98995.631418,99019.282756,99042.935506,
99066.589668,99090.245243,99113.902229,99137.560628,99161.220437,99184.881659,99208.544291,99232.208334,
99255.873789,99279.540654,99303.208929,99326.878615,99350.549711,99374.222218,99397.896134,99421.571460,
99445.248195,99468.926340,99492.605893,99516.286856,99539.969228,99563.653009,99587.338198,99611.024795,
99634.712801,99658.402214,99682.093036,99705.785265,99729.478902,99753.173946,99776.870397,99800.568256,
99824.267521,99847.968193,99871.670271,99895.373756,99919.078647,99942.784944,99966.492647,99990.201755,
100013.912269,100037.624188,100061.337513,100085.052243,100108.768377,100132.485916,100156.204860,100179.925208,
100203.646960,100227.370117,100251.094677,100274.820641,100298.548008,100322.276779,100346.006953,100369.738530,
100393.471510,100417.205892,100440.941677,100464.678865,100488.417454,100512.157446,100535.898839,100559.641635,
100583.385831,100607.131430,100630.878429,100654.626829,100678.376631,100702.127833,100725.880435,100749.634438,
100773.389841,100797.146645,100820.904848,100844.664451,100868.425453,100892.187855,100915.951656,100939.716856,
100963.483455,100987.251452,101011.020849,101034.791643,101058.563836,101082.337427,101106.112416,101129.888803,
101153.666587,101177.445769,101201.226348,101225.008324,101248.791697,101272.576466,101296.362633,101320.150195,
101343.939154,101367.729509,101391.521260,101415.314407,101439.108950,101462.904888,101486.702221,101510.500949,
101534.301072,101558.102590,101581.905503,101605.709810,101629.515512,101653.322607,101677.131097,101700.940980,
101724.752258,101748.564928,101772.378992,101796.194449,101820.011299,101843.829542,101867.649178,101891.470206,
101915.292626,101939.116439,101962.941643,101986.768240,102010.596228,102034.425608,102058.256379,102082.088541,
102105.922095,102129.757039,102153.593374,102177.431099,102201.270215,102225.110722,102248.952618,102272.795904,
102296.640580,102320.486646,102344.334101,102368.182945,102392.033178,102415.884800,102439.737811,102463.592211,
102487.447999,102511.305176,102535.163740,102559.023693,102582.885033,102606.747761,102630.611877,102654.477379,
102678.344269,102702.212546,102726.082210,102749.953261,102773.825698,102797.699521,102821.574731,102845.451326,
102869.329308,102893.208675,102917.089428,102940.971566,102964.855090,102988.739998,103012.626291,103036.513970,
103060.403032,103084.293479,103108.185311,103132.078527,103155.973126,103179.869109,103203.766476,103227.665227,
103251.565360,103275.466877,103299.369777,103323.274060,103347.179725,103371.086773,103394.995203,103418.905016,
103442.816210,103466.728786,103490.642744,103514.558084,103538.474805,103562.392907,103586.312390,103610.233254,
103634.155499,103658.079125,103682.004131,103705.930517,103729.858283,103753.787430,103777.717956,103801.649862,
103825.583147,103849.517811,103873.453855,103897.391278,103921.330079,103945.270260,103969.211818,103993.154755,
104017.099071,104041.044764,104064.991835,104088.940284,104112.890111,104136.841315,104160.793896,104184.747855,
104208.703190,104232.659902,104256.617991,104280.577456,104304.538297,104328.500515,104352.464109,104376.429078,
104400.395423,104424.363144,104448.332240,104472.302711,104496.274557,104520.247779,104544.222375,104568.198345,
104592.175690,104616.154409,104640.134502,104664.115969,104688.098810,104712.083025,104736.068613,104760.055574,
104784.043909,104808.033616,104832.024697,104856.017150,104880.010975,104904.006173,104928.002743,104952.000686,
104976.000000,105000.000686,105024.002743,105048.006172,105072.010972,105096.017143,105120.024685,105144.033598,
105168.043882,105192.055536,105216.068561,105240.082955,105264.098720,105288.115855,105312.134359,105336.154233,
105360.175476,105384.198088,105408.222070,105432.247420,105456.274139,105480.302227,105504.331683,105528.362508,
105552.394701,105576.428261,105600.463190,105624.499486,105648.537150,105672.576181,105696.616580,105720.658345,
105744.701477,105768.745976,105792.791842,105816.839074,105840.887672,105864.937637,105888.988967,105913.041664,
105937.095726,105961.151153,105985.207946,106009.266104,106033.325627,106057.386515,106081.448767,106105.512385,
106129.577366,106153.643712,106177.711422,106201.780496,106225.850934,106249.922735,106273.995900,106298.070429,
106322.146320,106346.223574,106370.302192,106394.382172,106418.463515,106442.546220,106466.630287,106490.715716,
106514.802508,106538.890661,106562.980176,106587.071052,106611.163290,106635.256888,106659.351848,106683.448169,
106707.545850,106731.644892,106755.745295,106779.847058,106803.950180,106828.054663,106852.160506,106876.267708,
106900.376270,106924.486191,106948.597471,106972.710110,106996.824108,107020.939465,107045.056180,107069.174254,
107093.293686,107117.414477,107141.536625,107165.660131,107189.784994,107213.911216,107238.038794,107262.167730,
107286.298023,107310.429672,107334.562679,107358.697041,107382.832761,107406.969837,107431.108268,107455.248056,
107479.389200,107503.531699,107527.675554,107551.820764,107575.967329,107600.115250,107624.264525,107648.415155,
107672.567140,107696.720479,107720.875173,107745.031220,107769.188622,107793.347378,107817.507487,107841.668950,
107865.831766,107889.995935,107914.161457,107938.328333,107962.496561,107986.666142,108010.837075,108035.009361,
108059.182999,108083.357989,108107.534330,108131.712024,108155.891069,108180.071465,108204.253213,108228.436312,
108252.620762,108276.806562,108300.993714,108325.182216,108349.372068,108373.563270,108397.755823,108421.949725,
108446.144977,108470.341579,108494.539531,108518.738831,108542.939481,108567.141480,108591.344827,108615.549524,
108639.755569,108663.962962,108688.171704,108712.381793,108736.593231,108760.806016,108785.020150,108809.235630,
108833.452458,108857.670634,108881.890156,108906.111025,108930.333241,108954.556804,108978.781713,109003.007968,
109027.235570,109051.464517,109075.694811,109099.926450,109124.159434,109148.393765,109172.629440,109196.866460,
109221.104826,109245.344536,109269.585591,109293.827991,109318.071735,109342.316823,109366.563255,109390.811031,
109415.060151,109439.310614,109463.562421,109487.815571,109512.070065,109536.325901,109560.583081,109584.841603,
109609.101468,109633.362675,109657.625224,109681.889116,109706.154349,109730.420925,109754.688842,109778.958101,
109803.228701,109827.500642,109851.773924,109876.048548,109900.324512,109924.601817,109948.880462,109973.160448,
109997.441774,110021.724440,110046.008446,110070.293791,110094.580477,110118.868501,110143.157866,110167.448569,
110191.740611,110216.033992,110240.328712,110264.624771,110288.922168,110313.220903,110337.520976,110361.822388,
110386.125137,110410.429224,110434.734648,110459.041410,110483.349510,110507.658946,110531.969719,110556.281829,
110580.595276,110604.910059,110629.226179,110653.543635,110677.862427,110702.182555,110726.504019,110750.826818,
110775.150953,110799.476423,110823.803229,110848.131369,110872.460844,110896.791655,110921.123799,110945.457279,
110969.792092,110994.128240,111018.465722,111042.804538,111067.144687,111091.486170,111115.828987,111140.173136,
111164.518619,111188.865435,111213.213584,111237.563066,111261.913880,111286.266027,111310.619505,111334.974316,
111359.330459,111383.687934,111408.046741,111432.406879,111456.768348,111481.131149,111505.495281,111529.860744,
111554.227538,111578.595662,111602.965117,111627.335902,111651.708018,111676.081463,111700.456239,111724.832344,
111749.209779,111773.588544,111797.968638,111822.350061,111846.732813,111871.116895,111895.502305,111919.889043,
111944.277111,111968.666506,111993.057230,112017.449282,112041.842662,112066.237369,112090.633404,112115.030767,
112139.429457,112163.829474,112188.230819,112212.633490,112237.037488,112261.442812,112285.849464,112310.257441,
112334.666745,112359.077374,112383.489330,112407.902611,112432.317218,112456.733151,112481.150409,112505.568992,
112529.988900,112554.410133,112578.832690,112603.256573,112627.681779,112652.108310,112676.536166,112700.965345,
112725.395848,112749.827675,112774.260826,112798.695300,112823.131097,112847.568218,112872.006661,112896.446428,
112920.887517,112945.329929,112969.773663,112994.218720,113018.665099,113043.112799,113067.561822,113092.012166,
113116.463833,113140.916820,113165.371129,113189.826759,113214.283710,113238.741982,113263.201575,113287.662488,
113312.124722,113336.588276,113361.053150,113385.519344,113409.986858,113434.455692,113458.925846,113483.397319,
113507.870111,113532.344223,113556.819653,113581.296403,113605.774471,113630.253858,113654.734563,113679.216587,
113703.699928,113728.184588,113752.670566,113777.157862,113801.646475,113826.136405,113850.627653,113875.120218,
113899.614101,113924.109300,113948.605816,113973.103648,113997.602797,114022.103262,114046.605044,114071.108141,
114095.612555,114120.118284,114144.625329,114169.133690,114193.643365,114218.154356,114242.666662,114267.180283,
114291.695219,114316.211470,114340.729035,114365.247914,114389.768107,114414.289615,114438.812437,114463.336572,
114487.862021,114512.388784,114536.916860,114561.446249,114585.976951,114610.508966,114635.042294,114659.576935,
114684.112889,114708.650154,114733.188732,114757.728622,114782.269824,114806.812338,114831.356164,114855.901301,
114880.447749,114904.995509,114929.544580,114954.094962,114978.646655,115003.199659,115027.753973,115052.309597,
115076.866532,115101.424777,115125.984332,115150.545197,115175.107372,115199.670856,115224.235650,115248.801753,
115273.369165,115297.937886,115322.507916,115347.079255,115371.651903,115396.225859,115420.801123,115445.377696,
115469.955576,115494.534765,115519.115261,115543.697065,115568.280177,115592.864595,115617.450322,115642.037355,
115666.625695,115691.215342,115715.806295,115740.398556,115764.992122,115789.586995,115814.183174,115838.780659,
115863.379449,115887.979546,115912.580948,115937.183655,115961.787668,115986.392986,116010.999609,116035.607537,
116060.216769,116084.827306,116109.439148,116134.052294,116158.666744,116183.282498,116207.899556,116232.517917,
116257.137583,116281.758552,116306.380824,116331.004399,116355.629278,116380.255459,116404.882944,116429.511730,
116454.141820,116478.773212,116503.405906,116528.039902,116552.675200,116577.311800,116601.949702,116626.588905,
116651.229410,116675.871216,116700.514323,116725.158731,116749.804440,116774.451450,116799.099760,116823.749371,
116848.400282,116873.052493,116897.706005,116922.360816,116947.016927,116971.674338,116996.333048,117020.993057,
117045.654366,117070.316974,117094.980881,117119.646087,117144.312591,117168.980394,117193.649495,117218.319895,
117242.991592,117267.664588,117292.338882,117317.014473,117341.691362,117366.369548,117391.049032,117415.729813,
117440.411890,117465.095265,117489.779937,117514.465905,117539.153170,117563.841731,117588.531588,117613.222741,
117637.915190,117662.608936,117687.303976,117712.000313,117736.697944,117761.396871,117786.097094,117810.798611,
117835.501423,117860.205530,117884.910931,117909.617627,117934.325617,117959.034901,117983.745480,118008.457352,
118033.170518,118057.884978,118082.600731,118107.317778,118132.036117,118156.755750,118181.476676,118206.198895,
118230.922406,118255.647210,118280.373307,118305.100696,118329.829377,118354.559349,118379.290614,118404.023171,
118428.757019,118453.492159,118478.228590,118502.966312,118527.705325,118552.445630,118577.187225,118601.930110,
118626.674287,118651.419753,118676.166510,118700.914557,118725.663894,118750.414521,118775.166438,118799.919644,
118824.674140,118849.429925,118874.187000,118898.945363,118923.705015,118948.465956,118973.228186,118997.991704,
119022.756511,119047.522606,119072.289989,119097.058660,119121.828619,119146.599865,119171.372399,119196.146221,
119220.921330,119245.697726,119270.475409,119295.254379,119320.034636,119344.816180,119369.599010,119394.383126,
119419.168529,119443.955218,119468.743193,119493.532453,119518.323000,119543.114832,119567.907949,119592.702352,
119617.498040,119642.295012,119667.093270,119691.892813,119716.693640,119741.495752,119766.299148,119791.103829,
119815.909793,119840.717042,119865.525574,119890.335390,119915.146490,119939.958873,119964.772540,119989.587489,
120014.403722,120039.221238,120064.040036,120088.860117,120113.681481,120138.504127,120163.328055,120188.153266,
120212.979758,120237.807532,120262.636588,120287.466926,120312.298545,120337.131446,120361.965627,120386.801090,
120411.637833,120436.475858,120461.315163,120486.155749,120510.997615,120535.840761,120560.685187,120585.530894,
120610.377880,120635.226146,120660.075692,120684.926517,120709.778622,120734.632006,120759.486669,120784.342610,
120809.199831,120834.058331,120858.918108,120883.779165,120908.641499,120933.505112,120958.370003,120983.236172,
121008.103619,121032.972343,121057.842345,121082.713624,121107.586180,121132.460013,121157.335124,121182.211511,
121207.089175,121231.968116,121256.848333,121281.729827,121306.612596,121331.496642,121356.381964,121381.268561,
121406.156434,121431.045583,121455.936007,121480.827706,121505.720681,121530.614931,121555.510455,121580.407254,
121605.305328,121630.204677,121655.105299,121680.007196,121704.910368,121729.814813,121754.720532,121779.627524,
121804.535791,121829.445330,121854.356143,121879.268230,121904.181589,121929.096221,121954.012126,121978.929304,
122003.847754,122028.767477,122053.688472,122078.610739,122103.534279,122128.459090,122153.385173,122178.312527,
122203.241153,122228.171051,122253.102219,122278.034659,122302.968370,122327.903352,122352.839604,122377.777127,
122402.715921,122427.655984,122452.597318,122477.539922,122502.483797,122527.428940,122552.375354,122577.323037,
122602.271990,122627.222212,122652.173703,122677.126463,122702.080492,122727.035790,122751.992357,122776.950192,
122801.909295,122826.869667,122851.831307,122876.794215,122901.758391,122926.723834,122951.690546,122976.658524,
123001.627770,123026.598284,123051.570064,123076.543112,123101.517426,123126.493007,123151.469855,123176.447969,
123201.427350,123226.407996,123251.389909,123276.373088,123301.357533,123326.343243,123351.330219,123376.318460,
123401.307967,123426.298739,123451.290776,123476.284078,123501.278645,123526.274476,123551.271572,123576.269932,
123601.269557,123626.270446,123651.272599,123676.276016,123701.280696,123726.286640,123751.293848,123776.302319,
123801.312054,123826.323051,123851.335312,123876.348836,123901.363622,123926.379671,123951.396982,123976.415556,
124001.435392,124026.456491,124051.478851,124076.502473,124101.527357,124126.553502,124151.580909,124176.609578,
124201.639507,124226.670698,124251.703150,124276.736862,124301.771835,124326.808069,124351.845564,124376.884318,
124401.924333,124426.965608,124452.008143,124477.051938,124502.096993,124527.143307,124552.190880,124577.239713,
124602.289805,124627.341157,124652.393767,124677.447636,124702.502764,124727.559150,124752.616795,124777.675698,
124802.735859,124827.797278,124852.859956,124877.923891,124902.989084,124928.055534,124953.123242,124978.192207,
125003.262429,125028.333909,125053.406645,125078.480638,125103.555888,125128.632394,125153.710157,125178.789176,
125203.869451,125228.950983,125254.033770,125279.117813,125304.203112,125329.289666,125354.377476,125379.466541,
125404.556861,125429.648436,125454.741267,125479.835352,125504.930691,125530.027285,125555.125134,125580.224237,
125605.324594,125630.426205,125655.529070,125680.633189,125705.738562,125730.845188,125755.953067,125781.062200,
125806.172586,125831.284225,125856.397117,125881.511261,125906.626659,125931.743309,125956.861211,125981.980366,
126007.100773,126032.222431,126057.345342,126082.469505,126107.594919,126132.721585,126157.849502,126182.978670,
126208.109090,126233.240761,126258.373682,126283.507855,126308.643278,126333.779952,126358.917876,126384.057050,
126409.197475,126434.339149,126459.482074,126484.626248,126509.771672,126534.918346,126560.066269,126585.215441,
126610.365863,126635.517533,126660.670453,126685.824621,126710.980038,126736.136704,126761.294618,126786.453780,
126811.614191,126836.775849,126861.938756,126887.102910,126912.268312,126937.434962,126962.602859,126987.772003,
127012.942395,127038.114033,127063.286919,127088.461051,127113.636430,127138.813056,127163.990928,127189.170047,
127214.350412,127239.532023,127264.714879,127289.898982,127315.084330,127340.270924,127365.458764,127390.647849,
127415.838179,127441.029754,127466.222574,127491.416639,127516.611948,127541.808503,127567.006301,127592.205345,
127617.405632,127642.607164,127667.809939,127693.013958,127718.219222,127743.425728,127768.633479,127793.842472,
127819.052709,127844.264189,127869.476912,127894.690878,127919.906087,127945.122539,127970.340233,127995.559169,
128020.779347,128046.000768,128071.223431,128096.447336,128121.672482,128146.898870,128172.126500,128197.355371,
128222.585484,128247.816837,128273.049432,128298.283268,128323.518344,128348.754661,128373.992219,128399.231017,
128424.471056,128449.712335,128474.954853,128500.198612,128525.443611,128550.689849,128575.937327,128601.186044,
128626.436001,128651.687197,128676.939632,128702.193306,128727.448219,128752.704371,128777.961761,128803.220390,
128828.480257,128853.741362,128879.003706,128904.267287,128929.532107,128954.798164,128980.065459,129005.333992,
129030.603761,129055.874769,129081.147013,129106.420494,129131.695213,129156.971168,129182.248359,129207.526788,
129232.806452,129258.087354,129283.369491,129308.652864,129333.937474,129359.223319,129384.510400,129409.798716,
129435.088268,129460.379055,129485.671078,129510.964336,129536.258828,129561.554556,129586.851518,129612.149715,
129637.449146,129662.749812,129688.051712,129713.354846,129738.659215,129763.964817,129789.271653,129814.579722,
129839.889025,129865.199562,129890.511332,129915.824335,129941.138571,129966.454040,129991.770742,130017.088677,
130042.407844,130067.728244,130093.049876,130118.372740,130143.696836,130169.022165,130194.348725,130219.676517,
130245.005540,130270.335795,130295.667282,130321.000000,130346.333949,130371.669128,130397.005539,130422.343181,
130447.682053,130473.022156,130498.363489,130523.706053,130549.049847,130574.394870,130599.741124,130625.088608,
130650.437321,130675.787264,130701.138437,130726.490838,130751.844469,130777.199329,130802.555419,130827.912737,
130853.271283,130878.631059,130903.992063,130929.354295,130954.717756,130980.082444,131005.448361,131030.815506,
131056.183878,131081.553479,131106.924307,131132.296362,131157.669644,131183.044154,131208.419891,131233.796855,
131259.175046,131284.554463,131309.935107,131335.316978,131360.700075,131386.084398,131411.469948,131436.856723,
131462.244725,131487.633952,131513.024405,131538.416083,131563.808987,131589.203116,131614.598470,131639.995050,
131665.392854,131690.791883,131716.192137,131741.593616,131766.996319,131792.400246,131817.805398,131843.211774,
131868.619374,131894.028197,131919.438245,131944.849516,131970.262011,131995.675729,132021.090671,132046.506835,
132071.924223,132097.342834,132122.762667,132148.183724,132173.606003,132199.029504,132224.454228,132249.880174,
132275.307342,132300.735732,132326.165344,132351.596178,132377.028234,132402.461511,132427.896009,132453.331729,
132478.768670,132504.206832,132529.646215,132555.086819,132580.528644,132605.971689,132631.415955,132656.861441,
132682.308147,132707.756074,132733.205221,132758.655587,132784.107173,132809.559979,132835.014005,132860.469250,
132885.925714,132911.383397,132936.842300,132962.302421,132987.763762,133013.226321,133038.690099,133064.155095,
133089.621310,133115.088743,133140.557394,133166.027263,133191.498350,133216.970655,133242.444177,133267.918918,
133293.394875,133318.872050,133344.350442,133369.830052,133395.310878,133420.792921,133446.276181,133471.760658,
133497.246351,133522.733260,133548.221386,133573.710728,133599.201286,133624.693060,133650.186050,133675.680255,
133701.175677,133726.672313,133752.170165,133777.669233,133803.169515,133828.671012,133854.173725,133879.677652,
133905.182794,133930.689150,133956.196721,133981.705506,134007.215505,134032.726719,134058.239146,134083.752787,
134109.267643,134134.783711,134160.300993,134185.819489,134211.339198,134236.860120,134262.382255,134287.905603,
134313.430164,134338.955938,134364.482924,134390.011123,134415.540534,134441.071157,134466.602992,134492.136040,
134517.670299,134543.205770,134568.742453,134594.280348,134619.819453,134645.359771,134670.901299,134696.444038,
134721.987989,134747.533150,134773.079522,134798.627105,134824.175898,134849.725902,134875.277116,134900.829540,
134926.383174,134951.938019,134977.494073,135003.051336,135028.609810,135054.169493,135079.730385,135105.292486,
135130.855797,135156.420317,135181.986046,135207.552983,135233.121129,135258.690484,135284.261047,135309.832819,
135335.405798,135360.979986,135386.555382,135412.131986,135437.709798,135463.288817,135488.869044,135514.450478,
135540.033119,135565.616968,135591.202024,135616.788287,135642.375757,135667.964433,135693.554316,135719.145406,
135744.737702,135770.331205,135795.925913,135821.521828,135847.118948,135872.717275,135898.316807,135923.917545,
135949.519488,135975.122637,136000.726991,136026.332550,136051.939314,136077.547284,136103.156458,136128.766836,
136154.378420,136179.991207,136205.605199,136231.220396,136256.836796,136282.454401,136308.073210,136333.693222,
136359.314438,136384.936857,136410.560481,136436.185307,136461.811337,136487.438569,136513.067005,136538.696644,
136564.327485,136589.959530,136615.592776,136641.227225,136666.862877,136692.499731,136718.137787,136743.777044,
136769.417504,136795.059166,136820.702029,136846.346094,136871.991360,136897.637827,136923.285496,136948.934366,
136974.584437,137000.235708,137025.888181,137051.541854,137077.196727,137102.852801,137128.510076,137154.168550,
137179.828225,137205.489099,137231.151174,137256.814448,137282.478922,137308.144595,137333.811468,137359.479540,
137385.148812,137410.819282,137436.490951,137462.163820,137487.837886,137513.513152,137539.189616,137564.867279,
137590.546139,137616.226198,137641.907455,137667.589910,137693.273563,137718.958414,137744.644462,137770.331708,
137796.020151,137821.709791,137847.400629,137873.092664,137898.785895,137924.480324,137950.175949,137975.872771,
138001.570789,138027.270004,138052.970415,138078.672022,138104.374825,138130.078824,138155.784019,138181.490410,
138207.197996,138232.906778,138258.616756,138284.327928,138310.040296,138335.753859,138361.468616,138387.184569,
138412.901716,138438.620058,138464.339595,138490.060326,138515.782251,138541.505370,138567.229683,138592.955191,
138618.681892,138644.409787,138670.138875,138695.869157,138721.600633,138747.333302,138773.067163,138798.802218,
138824.538466,138850.275907,138876.014541,138901.754367,138927.495385,138953.237596,138978.981000,139004.725595,
139030.471383,139056.218362,139081.966534,139107.715897,139133.466452,139159.218198,139184.971136,139210.725265,
139236.480585,139262.237096,139287.994798,139313.753692,139339.513775,139365.275050,139391.037515,139416.801170,
139442.566016,139468.332052,139494.099278,139519.867694,139545.637300,139571.408096,139597.180081,139622.953256,
139648.727620,139674.503174,139700.279917,139726.057848,139751.836969,139777.617279,139803.398778,139829.181465,
139854.965341,139880.750405,139906.536657,139932.324098,139958.112727,139983.902544,140009.693549,140035.485741,
140061.279122,140087.073689,140112.869445,140138.666387,140164.464517,140190.263834,140216.064338,140241.866029,
140267.668907,140293.472971,140319.278222,140345.084660,140370.892284,140396.701094,140422.511090,140448.322272,
140474.134641,140499.948195,140525.762934,140551.578860,140577.395971,140603.214267,140629.033748,140654.854415,
140680.676267,140706.499304,140732.323525,140758.148931,140783.975522,140809.803298,140835.632258,140861.462402,
140887.293730,140913.126242,140938.959939,140964.794819,140990.630883,141016.468131,141042.306562,141068.146176,
141093.986974,141119.828956,141145.672120,141171.516467,141197.361997,141223.208710,141249.056606,141274.905684,
141300.755944,141326.607387,141352.460013,141378.313820,141404.168809,141430.024981,141455.882334,141481.740868,
141507.600585,141533.461483,141559.323562,141585.186822,141611.051264,141636.916887,141662.783690,141688.651675,
141714.520840,141740.391186,141766.262712,141792.135419,141818.009306,141843.884373,141869.760621,141895.638048,
141921.516655,141947.396442,141973.277408,141999.159555,142025.042880,142050.927385,142076.813069,142102.699932,
142128.587975,142154.477196,142180.367596,142206.259174,142232.151931,142258.045867,142283.940981,142309.837273,
142335.734744,142361.633392,142387.533219,142413.434223,142439.336405,142465.239764,142491.144301,142517.050016,
142542.956907,142568.864976,142594.774222,142620.684645,142646.596245,142672.509022,142698.422975,142724.338105,
142750.254411,142776.171894,142802.090552,142828.010387,142853.931398,142879.853585,142905.776948,142931.701486,
142957.627200,142983.554089,143009.482154,143035.411394,143061.341809,143087.273399,143113.206164,143139.140104,
143165.075219,143191.011508,143216.948972,143242.887610,143268.827423,143294.768410,143320.710571,143346.653905,
143372.598414,143398.544097,143424.490953,143450.438983,143476.388186,143502.338562,143528.290112,143554.242835,
143580.196731,143606.151800,143632.108041,143658.065456,143684.024043,143709.983802,143735.944734,143761.906838,
143787.870115,143813.834563,143839.800184,143865.766976,143891.734940,143917.704076,143943.674383,143969.645862,
143995.618512,144021.592333,144047.567325,144073.543489,144099.520823,144125.499328,144151.479004,144177.459850,
144203.441867,144229.425055,144255.409412,144281.394940,144307.381638,144333.369506,144359.358543,144385.348751,
144411.340128,144437.332674,144463.326390,144489.321276,144515.317331,144541.314554,144567.312947,144593.312509,
144619.313239,144645.315138,144671.318206,144697.322442,144723.327847,144749.334420,144775.342161,144801.351070,
144827.361148,144853.372393,144879.384805,144905.398386,144931.413134,144957.429049,144983.446132,145009.464382,
145035.483799,145061.504383,145087.526135,145113.549052,145139.573137,145165.598388,145191.624806,145217.652390,
145243.681141,145269.711057,145295.742140,145321.774389,145347.807803,145373.842384,145399.878130,145425.915041,
145451.953118,145477.992360,145504.032768,145530.074341,145556.117079,145582.160981,145608.206049,145634.252281,
145660.299678,145686.348240,145712.397965,145738.448856,145764.500910,145790.554128,145816.608511,145842.664057,
145868.720767,145894.778641,145920.837679,145946.897880,145972.959244,145999.021772,146025.085462,146051.150316,
146077.216333,146103.283512,146129.351855,146155.421360,146181.492027,146207.563857,146233.636850,146259.711004,
146285.786321,146311.862800,146337.940440,146364.019243,146390.099207,146416.180333,146442.262620,146468.346069,
146494.430679,146520.516450,146546.603383,146572.691476,146598.780730,146624.871145,146650.962721,146677.055457,
146703.149354,146729.244411,146755.340628,146781.438006,146807.536543,146833.636241,146859.737098,146885.839116,
146911.942292,146938.046629,146964.152125,146990.258780,147016.366594,147042.475568,147068.585700,147094.696992,
147120.809442,147146.923051,147173.037819,147199.153745,147225.270830,147251.389073,147277.508474,147303.629033,
147329.750750,147355.873626,147381.997659,147408.122849,147434.249197,147460.376703,147486.505366,147512.635187,
147538.766164,147564.898299,147591.031591,147617.166039,147643.301645,147669.438407,147695.576325,147721.715400,
147747.855632,147773.997019,147800.139563,147826.283263,147852.428119,147878.574131,147904.721298,147930.869621,
147957.019100,147983.169734,148009.321523,148035.474468,148061.628568,148087.783823,148113.940233,148140.097797,
148166.256517,148192.416391,148218.577419,148244.739602,148270.902939,148297.067431,148323.233077,148349.399876,
148375.567830,148401.736937,148427.907198,148454.078613,148480.251181,148506.424903,148532.599778,148558.775806,
148584.952987,148611.131321,148637.310808,148663.491448,148689.673241,148715.856186,148742.040284,148768.225534,
148794.411936,148820.599491,148846.788198,148872.978056,148899.169067,148925.361229,148951.554543,148977.749009,
149003.944626,149030.141394,149056.339314,149082.538385,149108.738607,149134.939980,149161.142504,149187.346179,
149213.551004,149239.756980,149265.964106,149292.172383,149318.381810,149344.592387,149370.804114,149397.016991,
149423.231018,149449.446195,149475.662522,149501.879998,149528.098623,149554.318398,149580.539322,149606.761395,
149632.984618,149659.208989,149685.434509,149711.661178,149737.888995,149764.117961,149790.348076,149816.579339,
149842.811750,149869.045309,149895.280017,149921.515872,149947.752875,149973.991026,150000.230325,150026.470771,
150052.712364,150078.955105,150105.198993,150131.444029,150157.690211,150183.937540,150210.186017,150236.435640,
150262.686409,150288.938325,150315.191388,150341.445597,150367.700952,150393.957453,150420.215100,150446.473894,
150472.733833,150498.994918,150525.257148,150551.520524,150577.785046,150604.050713,150630.317525,150656.585482,
150682.854584,150709.124831,150735.396224,150761.668760,150787.942442,150814.217268,150840.493238,150866.770353,
150893.048612,150919.328016,150945.608563,150971.890254,150998.173089,151024.457068,151050.742190,151077.028457,
151103.315866,151129.604419,151155.894115,151182.184954,151208.476937,151234.770062,151261.064330,151287.359741,
151313.656294,151339.953990,151366.252829,151392.552810,151418.853933,151445.156198,151471.459606,151497.764155,
151524.069846,151550.376679,151576.684654,151602.993770,151629.304028,151655.615427,151681.927967,151708.241649,
151734.556471,151760.872435,151787.189539,151813.507785,151839.827170,151866.147697,151892.469364,151918.792171,
151945.116119,151971.441206,151997.767434,152024.094802,152050.423310,152076.752957,152103.083745,152129.415671,
152155.748738,152182.082943,152208.418288,152234.754772,152261.092396,152287.431158,152313.771059,152340.112099,
152366.454278,152392.797595,152419.142051,152445.487645,152471.834377,152498.182248,152524.531257,152550.881404,
152577.232688,152603.585111,152629.938671,152656.293369,152682.649205,152709.006177,152735.364288,152761.723535,
152788.083919,152814.445441,152840.808100,152867.171895,152893.536827,152919.902896,152946.270101,152972.638443,
152999.007921,153025.378535,153051.750285,153078.123172,153104.497194,153130.872353,153157.248647,153183.626076,
153210.004642,153236.384342,153262.765178,153289.147150,153315.530256,153341.914498,153368.299875,153394.686386,
153421.074032,153447.462813,153473.852729,153500.243779,153526.635963,153553.029282,153579.423735,153605.819322,
153632.216043,153658.613898,153685.012887,153711.413009,153737.814265,153764.216655,153790.620178,153817.024834,
153843.430623,153869.837546,153896.245602,153922.654790,153949.065112,153975.476566,154001.889153,154028.302872,
154054.717724,154081.133708,154107.550825,154133.969073,154160.388454,154186.808966,154213.230611,154239.653387,
154266.077295,154292.502334,154318.928505,154345.355807,154371.784241,154398.213806,154424.644502,154451.076328,
154477.509286,154503.943375,154530.378594,154556.814944,154583.252424,154609.691035,154636.130776,154662.571647,
154689.013649,154715.456780,154741.901041,154768.346433,154794.792954,154821.240604,154847.689384,154874.139294,
154900.590333,154927.042501,154953.495798,154979.950224,155006.405780,155032.862464,155059.320277,155085.779219,
155112.239289,155138.700488,155165.162815,155191.626270,155218.090854,155244.556565,155271.023405,155297.491372,
155323.960468,155350.430691,155376.902042,155403.374520,155429.848125,155456.322858,155482.798719,155509.275706,
155535.753820,155562.233062,155588.713430,155615.194925,155641.677546,155668.161295,155694.646169,155721.132170,
155747.619297,155774.107551,155800.596930,155827.087436,155853.579067,155880.071824,155906.565707,155933.060716,
155959.556850,155986.054109,156012.552494,156039.052004,156065.552639,156092.054399,156118.557284,156145.061294,
156171.566428,156198.072688,156224.580072,156251.088580,156277.598212,156304.108969,156330.620850,156357.133856,
156383.647985,156410.163238,156436.679614,156463.197115,156489.715739,156516.235487,156542.756358,156569.278352,
156595.801469,156622.325710,156648.851074,156675.377560,156701.905170,156728.433902,156754.963757,156781.494734,
156808.026834,156834.560056,156861.094401,156887.629868,156914.166456,156940.704167,156967.243000,156993.782954,
157020.324030,157046.866228,157073.409547,157099.953988,157126.499550,157153.046233,157179.594037,157206.142962,
157232.693009,157259.244176,157285.796464,157312.349872,157338.904401,157365.460051,157392.016821,157418.574711,
157445.133722,157471.693852,157498.255103,157524.817473,157551.380963,157577.945573,157604.511303,157631.078152,
157657.646120,157684.215208,157710.785415,157737.356741,157763.929186,157790.502751,157817.077434,157843.653236,
157870.230156,157896.808195,157923.387353,157949.967629,157976.549023,158003.131536,158029.715166,158056.299915,
158082.885781,158109.472766,158136.060868,158162.650087,158189.240425,158215.831879,158242.424452,158269.018141,
158295.612947,158322.208871,158348.805912,158375.404069,158402.003343,158428.603734,158455.205242,158481.807866,
158508.411606,158535.016463,158561.622436,158588.229526,158614.837731,158641.447052,158668.057489,158694.669042,
158721.281710,158747.895495,158774.510394,158801.126409,158827.743539,158854.361785,158880.981145,158907.601621,
158934.223211,158960.845917,158987.469737,159014.094672,159040.720721,159067.347885,159093.976163,159120.605555,
159147.236062,159173.867682,159200.500417,159227.134265,159253.769228,159280.405304,159307.042493,159333.680797,
159360.320213,159386.960743,159413.602386,159440.245143,159466.889012,159493.533994,159520.180090,159546.827298,
159573.475618,159600.125052,159626.775597,159653.427256,159680.080026,159706.733909,159733.388904,159760.045011,
159786.702230,159813.360560,159840.020003,159866.680557,159893.342223,159920.005000,159946.668889,159973.333888,
160000.000000,160026.667222,160053.335555,160080.004999,160106.675554,160133.347220,160160.019996,160186.693883,
160213.368881,160240.044988,160266.722206,160293.400535,160320.079973,160346.760521,160373.442179,160400.124947,
160426.808825,160453.493813,160480.179910,160506.867116,160533.555432,160560.244857,160586.935391,160613.627034,
160640.319786,160667.013648,160693.708618,160720.404696,160747.101883,160773.800179,160800.499584,160827.200096,
160853.901717,160880.604446,160907.308283,160934.013228,160960.719281,160987.426442,161014.134710,161040.844086,
161067.554569,161094.266160,161120.978859,161147.692664,161174.407577,161201.123597,161227.840723,161254.558957,
161281.278297,161307.998744,161334.720298,161361.442958,161388.166724,161414.891597,161441.617576,161468.344662,
161495.072853,161521.802150,161548.532553,161575.264062,161601.996677,161628.730397,161655.465222,161682.201153,
161708.938190,161735.676331,161762.415578,161789.155930,161815.897386,161842.639948,161869.383614,161896.128385,
161922.874261,161949.621241,161976.369326,162003.118514,162029.868807,162056.620205,162083.372706,162110.126311,
162136.881020,162163.636833,162190.393749,162217.151769,162243.910893,162270.671120,162297.432450,162324.194883,
162350.958420,162377.723059,162404.488802,162431.255647,162458.023596,162484.792646,162511.562800,162538.334056,
162565.106414,162591.879875,162618.654437,162645.430102,162672.206869,162698.984738,162725.763709,162752.543782,
162779.324956,162806.107232,162832.890609,162859.675088,162886.460668,162913.247349,162940.035132,162966.824015,
162993.614000,163020.405085,163047.197271,163073.990558,163100.784945,163127.580433,163154.377021,163181.174709,
163207.973498,163234.773387,163261.574376,163288.376465,163315.179654,163341.983942,163368.789330,163395.595818,
163422.403406,163449.212092,163476.021878,163502.832764,163529.644748,163556.457832,163583.272014,163610.087295,
163636.903675,163663.721154,163690.539732,163717.359408,163744.180182,163771.002055,163797.825026,163824.649095,
163851.474262,163878.300527,163905.127890,163931.956351,163958.785909,163985.616565,164012.448319,164039.281170,
164066.115119,164092.950164,164119.786307,164146.623547,164173.461884,164200.301318,164227.141848,164253.983476,
164280.826200,164307.670020,164334.514937,164361.360951,164388.208060,164415.056266,164441.905568,164468.755966,
164495.607459,164522.460049,164549.313734,164576.168515,164603.024392,164629.881364,164656.739431,164683.598594,
164710.458852,164737.320205,164764.182653,164791.046196,164817.910833,164844.776566,164871.643393,164898.511315,
164925.380331,164952.250441,164979.121646,165005.993946,165032.867339,165059.741826,165086.617407,165113.494082
};

extern real io[2][32] =
{
 { 1.0000000000E+00f, 8.4089641526E-01f, 7.0710678119E-01f, 5.9460355751E-01f,
   5.0000000001E-01f, 4.2044820763E-01f, 3.5355339060E-01f, 2.9730177876E-01f,
   2.5000000001E-01f, 2.1022410382E-01f, 1.7677669530E-01f, 1.4865088938E-01f,
   1.2500000000E-01f, 1.0511205191E-01f, 8.8388347652E-02f, 7.4325444691E-02f,
   6.2500000003E-02f, 5.2556025956E-02f, 4.4194173826E-02f, 3.7162722346E-02f,
   3.1250000002E-02f, 2.6278012978E-02f, 2.2097086913E-02f, 1.8581361173E-02f,
   1.5625000001E-02f, 1.3139006489E-02f, 1.1048543457E-02f, 9.2906805866E-03f,
   7.8125000006E-03f, 6.5695032447E-03f, 5.5242717285E-03f, 4.6453402934E-03f },
 { 1.0000000000E+00f, 7.0710678119E-01f, 5.0000000000E-01f, 3.5355339060E-01f,
   2.5000000000E-01f, 1.7677669530E-01f, 1.2500000000E-01f, 8.8388347650E-02f,
   6.2500000001E-02f, 4.4194173825E-02f, 3.1250000001E-02f, 2.2097086913E-02f, 
   1.5625000000E-02f, 1.1048543456E-02f, 7.8125000002E-03f, 5.5242717282E-03f,
   3.9062500001E-03f, 2.7621358641E-03f, 1.9531250001E-03f, 1.3810679321E-03f,
   9.7656250004E-04f, 6.9053396603E-04f, 4.8828125002E-04f, 3.4526698302E-04f,
   2.4414062501E-04f, 1.7263349151E-04f, 1.2207031251E-04f, 8.6316745755E-05f,
   6.1035156254E-05f, 4.3158372878E-05f, 3.0517578127E-05f, 2.1579186439E-05f }
};

extern real  TAN12[16] =
{
 0.0, 0.26794919, 0.57735027, 1.0,
 1.73205081, 3.73205081, 9.9999999e10, -3.73205081,
 -1.73205081, -1.0, -0.57735027, -0.26794919,
 0.0, 0.26794919, 0.57735027, 1.0
};

extern int32 ss_div[576] =
{
	 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	 3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
	 4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
	 5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
	 6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
	 7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
	 8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
	 9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
	15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
	18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
	19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
	20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
	21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
	22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
	23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
	27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31
};

extern int32 ss_mod[576] =
{
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17
};

extern int32 reorder_table[6][576] =
{
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51,
   40, 46, 52, 41, 47, 53, 54, 60, 66, 55, 61, 67, 56, 62, 68, 57,
   63, 69, 58, 64, 70, 59, 65, 71, 72, 80, 88, 73, 81, 89, 74, 82,
   90, 75, 83, 91, 76, 84, 92, 77, 85, 93, 78, 86, 94, 79, 87, 95,
   96,106,116, 97,107,117, 98,108,118, 99,109,119,100,110,120,101,
  111,121,102,112,122,103,113,123,104,114,124,105,115,125,126,140,
  154,127,141,155,128,142,156,129,143,157,130,144,158,131,145,159,
  132,146,160,133,147,161,134,148,162,135,149,163,136,150,164,137,
  151,165,138,152,166,139,153,167,168,186,204,169,187,205,170,188,
  206,171,189,207,172,190,208,173,191,209,174,192,210,175,193,211,
  176,194,212,177,195,213,178,196,214,179,197,215,180,198,216,181,
  199,217,182,200,218,183,201,219,184,202,220,185,203,221,222,248,
  274,223,249,275,224,250,276,225,251,277,226,252,278,227,253,279,
  228,254,280,229,255,281,230,256,282,231,257,283,232,258,284,233,
  259,285,234,260,286,235,261,287,236,262,288,237,263,289,238,264,
  290,239,265,291,240,266,292,241,267,293,242,268,294,243,269,295,
  244,270,296,245,271,297,246,272,298,247,273,299,300,332,364,301,
  333,365,302,334,366,303,335,367,304,336,368,305,337,369,306,338,
  370,307,339,371,308,340,372,309,341,373,310,342,374,311,343,375,
  312,344,376,313,345,377,314,346,378,315,347,379,316,348,380,317,
  349,381,318,350,382,319,351,383,320,352,384,321,353,385,322,354,
  386,323,355,387,324,356,388,325,357,389,326,358,390,327,359,391,
  328,360,392,329,361,393,330,362,394,331,363,395,396,438,480,397,
  439,481,398,440,482,399,441,483,400,442,484,401,443,485,402,444,
  486,403,445,487,404,446,488,405,447,489,406,448,490,407,449,491,
  408,450,492,409,451,493,410,452,494,411,453,495,412,454,496,413,
  455,497,414,456,498,415,457,499,416,458,500,417,459,501,418,460,
  502,419,461,503,420,462,504,421,463,505,422,464,506,423,465,507,
  424,466,508,425,467,509,426,468,510,427,469,511,428,470,512,429,
  471,513,430,472,514,431,473,515,432,474,516,433,475,517,434,476,
  518,435,477,519,436,478,520,437,479,521,522,540,558,523,541,559,
  524,542,560,525,543,561,526,544,562,527,545,563,528,546,564,529,
  547,565,530,548,566,531,549,567,532,550,568,533,551,569,534,552,
  570,535,553,571,536,554,572,537,555,573,538,556,574,539,557,575},
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51,
   40, 46, 52, 41, 47, 53, 54, 62, 70, 55, 63, 71, 56, 64, 72, 57,
   65, 73, 58, 66, 74, 59, 67, 75, 60, 68, 76, 61, 69, 77, 78, 88,
   98, 79, 89, 99, 80, 90,100, 81, 91,101, 82, 92,102, 83, 93,103,
   84, 94,104, 85, 95,105, 86, 96,106, 87, 97,107,108,120,132,109,
  121,133,110,122,134,111,123,135,112,124,136,113,125,137,114,126,
  138,115,127,139,116,128,140,117,129,141,118,130,142,119,131,143,
  144,158,172,145,159,173,146,160,174,147,161,175,148,162,176,149,
  163,177,150,164,178,151,165,179,152,166,180,153,167,181,154,168,
  182,155,169,183,156,170,184,157,171,185,186,204,222,187,205,223,
  188,206,224,189,207,225,190,208,226,191,209,227,192,210,228,193,
  211,229,194,212,230,195,213,231,196,214,232,197,215,233,198,216,
  234,199,217,235,200,218,236,201,219,237,202,220,238,203,221,239,
  240,264,288,241,265,289,242,266,290,243,267,291,244,268,292,245,
  269,293,246,270,294,247,271,295,248,272,296,249,273,297,250,274,
  298,251,275,299,252,276,300,253,277,301,254,278,302,255,279,303,
  256,280,304,257,281,305,258,282,306,259,283,307,260,284,308,261,
  285,309,262,286,310,263,287,311,312,344,376,313,345,377,314,346,
  378,315,347,379,316,348,380,317,349,381,318,350,382,319,351,383,
  320,352,384,321,353,385,322,354,386,323,355,387,324,356,388,325,
  357,389,326,358,390,327,359,391,328,360,392,329,361,393,330,362,
  394,331,363,395,332,364,396,333,365,397,334,366,398,335,367,399,
  336,368,400,337,369,401,338,370,402,339,371,403,340,372,404,341,
  373,405,342,374,406,343,375,407,408,452,496,409,453,497,410,454,
  498,411,455,499,412,456,500,413,457,501,414,458,502,415,459,503,
  416,460,504,417,461,505,418,462,506,419,463,507,420,464,508,421,
  465,509,422,466,510,423,467,511,424,468,512,425,469,513,426,470,
  514,427,471,515,428,472,516,429,473,517,430,474,518,431,475,519,
  432,476,520,433,477,521,434,478,522,435,479,523,436,480,524,437,
  481,525,438,482,526,439,483,527,440,484,528,441,485,529,442,486,
  530,443,487,531,444,488,532,445,489,533,446,490,534,447,491,535,
  448,492,536,449,493,537,450,494,538,451,495,539,540,552,564,541,
  553,565,542,554,566,543,555,567,544,556,568,545,557,569,546,558,
  570,547,559,571,548,560,572,549,561,573,550,562,574,551,563,575},
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51,
   40, 46, 52, 41, 47, 53, 54, 62, 70, 55, 63, 71, 56, 64, 72, 57,
   65, 73, 58, 66, 74, 59, 67, 75, 60, 68, 76, 61, 69, 77, 78, 88,
   98, 79, 89, 99, 80, 90,100, 81, 91,101, 82, 92,102, 83, 93,103,
   84, 94,104, 85, 95,105, 86, 96,106, 87, 97,107,108,120,132,109,
  121,133,110,122,134,111,123,135,112,124,136,113,125,137,114,126,
  138,115,127,139,116,128,140,117,129,141,118,130,142,119,131,143,
  144,158,172,145,159,173,146,160,174,147,161,175,148,162,176,149,
  163,177,150,164,178,151,165,179,152,166,180,153,167,181,154,168,
  182,155,169,183,156,170,184,157,171,185,186,204,222,187,205,223,
  188,206,224,189,207,225,190,208,226,191,209,227,192,210,228,193,
  211,229,194,212,230,195,213,231,196,214,232,197,215,233,198,216,
  234,199,217,235,200,218,236,201,219,237,202,220,238,203,221,239,
  240,264,288,241,265,289,242,266,290,243,267,291,244,268,292,245,
  269,293,246,270,294,247,271,295,248,272,296,249,273,297,250,274,
  298,251,275,299,252,276,300,253,277,301,254,278,302,255,279,303,
  256,280,304,257,281,305,258,282,306,259,283,307,260,284,308,261,
  285,309,262,286,310,263,287,311,312,342,372,313,343,373,314,344,
  374,315,345,375,316,346,376,317,347,377,318,348,378,319,349,379,
  320,350,380,321,351,381,322,352,382,323,353,383,324,354,384,325,
  355,385,326,356,386,327,357,387,328,358,388,329,359,389,330,360,
  390,331,361,391,332,362,392,333,363,393,334,364,394,335,365,395,
  336,366,396,337,367,397,338,368,398,339,369,399,340,370,400,341,
  371,401,402,442,482,403,443,483,404,444,484,405,445,485,406,446,
  486,407,447,487,408,448,488,409,449,489,410,450,490,411,451,491,
  412,452,492,413,453,493,414,454,494,415,455,495,416,456,496,417,
  457,497,418,458,498,419,459,499,420,460,500,421,461,501,422,462,
  502,423,463,503,424,464,504,425,465,505,426,466,506,427,467,507,
  428,468,508,429,469,509,430,470,510,431,471,511,432,472,512,433,
  473,513,434,474,514,435,475,515,436,476,516,437,477,517,438,478,
  518,439,479,519,440,480,520,441,481,521,522,540,558,523,541,559,
  524,542,560,525,543,561,526,544,562,527,545,563,528,546,564,529,
  547,565,530,548,566,531,549,567,532,550,568,533,551,569,534,552,
  570,535,553,571,536,554,572,537,555,573,538,556,574,539,557,575},
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47,
   48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53,
   59, 65, 66, 74, 82, 67, 75, 83, 68, 76, 84, 69, 77, 85, 70, 78,
   86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90,100,110, 91,101,111,
   92,102,112, 93,103,113, 94,104,114, 95,105,115, 96,106,116, 97,
  107,117, 98,108,118, 99,109,119,120,132,144,121,133,145,122,134,
  146,123,135,147,124,136,148,125,137,149,126,138,150,127,139,151,
  128,140,152,129,141,153,130,142,154,131,143,155,156,170,184,157,
  171,185,158,172,186,159,173,187,160,174,188,161,175,189,162,176,
  190,163,177,191,164,178,192,165,179,193,166,180,194,167,181,195,
  168,182,196,169,183,197,198,216,234,199,217,235,200,218,236,201,
  219,237,202,220,238,203,221,239,204,222,240,205,223,241,206,224,
  242,207,225,243,208,226,244,209,227,245,210,228,246,211,229,247,
  212,230,248,213,231,249,214,232,250,215,233,251,252,274,296,253,
  275,297,254,276,298,255,277,299,256,278,300,257,279,301,258,280,
  302,259,281,303,260,282,304,261,283,305,262,284,306,263,285,307,
  264,286,308,265,287,309,266,288,310,267,289,311,268,290,312,269,
  291,313,270,292,314,271,293,315,272,294,316,273,295,317,318,348,
  378,319,349,379,320,350,380,321,351,381,322,352,382,323,353,383,
  324,354,384,325,355,385,326,356,386,327,357,387,328,358,388,329,
  359,389,330,360,390,331,361,391,332,362,392,333,363,393,334,364,
  394,335,365,395,336,366,396,337,367,397,338,368,398,339,369,399,
  340,370,400,341,371,401,342,372,402,343,373,403,344,374,404,345,
  375,405,346,376,406,347,377,407,408,464,520,409,465,521,410,466,
  522,411,467,523,412,468,524,413,469,525,414,470,526,415,471,527,
  416,472,528,417,473,529,418,474,530,419,475,531,420,476,532,421,
  477,533,422,478,534,423,479,535,424,480,536,425,481,537,426,482,
  538,427,483,539,428,484,540,429,485,541,430,486,542,431,487,543,
  432,488,544,433,489,545,434,490,546,435,491,547,436,492,548,437,
  493,549,438,494,550,439,495,551,440,496,552,441,497,553,442,498,
  554,443,499,555,444,500,556,445,501,557,446,502,558,447,503,559,
  448,504,560,449,505,561,450,506,562,451,507,563,452,508,564,453,
  509,565,454,510,566,455,511,567,456,512,568,457,513,569,458,514,
  570,459,515,571,460,516,572,461,517,573,462,518,574,463,519,575},
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47,
   48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53,
   59, 65, 66, 72, 78, 67, 73, 79, 68, 74, 80, 69, 75, 81, 70, 76,
   82, 71, 77, 83, 84, 94,104, 85, 95,105, 86, 96,106, 87, 97,107,
   88, 98,108, 89, 99,109, 90,100,110, 91,101,111, 92,102,112, 93,
  103,113,114,126,138,115,127,139,116,128,140,117,129,141,118,130,
  142,119,131,143,120,132,144,121,133,145,122,134,146,123,135,147,
  124,136,148,125,137,149,150,164,178,151,165,179,152,166,180,153,
  167,181,154,168,182,155,169,183,156,170,184,157,171,185,158,172,
  186,159,173,187,160,174,188,161,175,189,162,176,190,163,177,191,
  192,208,224,193,209,225,194,210,226,195,211,227,196,212,228,197,
  213,229,198,214,230,199,215,231,200,216,232,201,217,233,202,218,
  234,203,219,235,204,220,236,205,221,237,206,222,238,207,223,239,
  240,260,280,241,261,281,242,262,282,243,263,283,244,264,284,245,
  265,285,246,266,286,247,267,287,248,268,288,249,269,289,250,270,
  290,251,271,291,252,272,292,253,273,293,254,274,294,255,275,295,
  256,276,296,257,277,297,258,278,298,259,279,299,300,326,352,301,
  327,353,302,328,354,303,329,355,304,330,356,305,331,357,306,332,
  358,307,333,359,308,334,360,309,335,361,310,336,362,311,337,363,
  312,338,364,313,339,365,314,340,366,315,341,367,316,342,368,317,
  343,369,318,344,370,319,345,371,320,346,372,321,347,373,322,348,
  374,323,349,375,324,350,376,325,351,377,378,444,510,379,445,511,
  380,446,512,381,447,513,382,448,514,383,449,515,384,450,516,385,
  451,517,386,452,518,387,453,519,388,454,520,389,455,521,390,456,
  522,391,457,523,392,458,524,393,459,525,394,460,526,395,461,527,
  396,462,528,397,463,529,398,464,530,399,465,531,400,466,532,401,
  467,533,402,468,534,403,469,535,404,470,536,405,471,537,406,472,
  538,407,473,539,408,474,540,409,475,541,410,476,542,411,477,543,
  412,478,544,413,479,545,414,480,546,415,481,547,416,482,548,417,
  483,549,418,484,550,419,485,551,420,486,552,421,487,553,422,488,
  554,423,489,555,424,490,556,425,491,557,426,492,558,427,493,559,
  428,494,560,429,495,561,430,496,562,431,497,563,432,498,564,433,
  499,565,434,500,566,435,501,567,436,502,568,437,503,569,438,504,
  570,439,505,571,440,506,572,441,507,573,442,508,574,443,509,575},
 {  0,  4,  8,  1,  5,  9,  2,  6, 10,  3,  7, 11, 12, 16, 20, 13,
   17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30,
   34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47,
   48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53,
   59, 65, 66, 74, 82, 67, 75, 83, 68, 76, 84, 69, 77, 85, 70, 78,
   86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90,102,114, 91,103,115,
   92,104,116, 93,105,117, 94,106,118, 95,107,119, 96,108,120, 97,
  109,121, 98,110,122, 99,111,123,100,112,124,101,113,125,126,142,
  158,127,143,159,128,144,160,129,145,161,130,146,162,131,147,163,
  132,148,164,133,149,165,134,150,166,135,151,167,136,152,168,137,
  153,169,138,154,170,139,155,171,140,156,172,141,157,173,174,194,
  214,175,195,215,176,196,216,177,197,217,178,198,218,179,199,219,
  180,200,220,181,201,221,182,202,222,183,203,223,184,204,224,185,
  205,225,186,206,226,187,207,227,188,208,228,189,209,229,190,210,
  230,191,211,231,192,212,232,193,213,233,234,260,286,235,261,287,
  236,262,288,237,263,289,238,264,290,239,265,291,240,266,292,241,
  267,293,242,268,294,243,269,295,244,270,296,245,271,297,246,272,
  298,247,273,299,248,274,300,249,275,301,250,276,302,251,277,303,
  252,278,304,253,279,305,254,280,306,255,281,307,256,282,308,257,
  283,309,258,284,310,259,285,311,312,346,380,313,347,381,314,348,
  382,315,349,383,316,350,384,317,351,385,318,352,386,319,353,387,
  320,354,388,321,355,389,322,356,390,323,357,391,324,358,392,325,
  359,393,326,360,394,327,361,395,328,362,396,329,363,397,330,364,
  398,331,365,399,332,366,400,333,367,401,334,368,402,335,369,403,
  336,370,404,337,371,405,338,372,406,339,373,407,340,374,408,341,
  375,409,342,376,410,343,377,411,344,378,412,345,379,413,414,456,
  498,415,457,499,416,458,500,417,459,501,418,460,502,419,461,503,
  420,462,504,421,463,505,422,464,506,423,465,507,424,466,508,425,
  467,509,426,468,510,427,469,511,428,470,512,429,471,513,430,472,
  514,431,473,515,432,474,516,433,475,517,434,476,518,435,477,519,
  436,478,520,437,479,521,438,480,522,439,481,523,440,482,524,441,
  483,525,442,484,526,443,485,527,444,486,528,445,487,529,446,488,
  530,447,489,531,448,490,532,449,491,533,450,492,534,451,493,535,
  452,494,536,453,495,537,454,496,538,455,497,539,540,552,564,541,
  553,565,542,554,566,543,555,567,544,556,568,545,557,569,546,558,
  570,547,559,571,548,560,572,549,561,573,550,562,574,551,563,575}
};

extern real  cs[8] =
{
 0.857492925712f, 0.881741997318f, 0.949628649103f, 0.983314592492f,
 0.995517816065f, 0.999160558175f, 0.999899195243f, 0.999993155067f
};

extern real  ca[8] =
{
 -0.5144957554270f, -0.4717319685650f, -0.3133774542040f, -0.1819131996110f,
 -0.0945741925262f, -0.0409655828852f, -0.0141985685725f, -0.00369997467375f
};

