//	common types used 

#ifndef DVD2AVI_INC_TYPES_H
#define DVD2AVI_INC_TYPES_H

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <ddraw.h>
#include <vfw.h>
#include <winreg.h>
#include <direct.h>
#include <io.h>
#include <fcntl.h>
//#include "resource.h"





#define CRITICAL_ERROR_LEVEL	50

#define PICTURE_START_CODE			0x100
#define SLICE_START_CODE_MIN		0x101
#define SLICE_START_CODE_MAX		0x1AF
#define USER_DATA_START_CODE		0x1B2
#define SEQUENCE_HEADER_CODE		0x1B3
#define EXTENSION_START_CODE		0x1B5
#define SEQUENCE_END_CODE			0x1B7
#define GROUP_START_CODE			0x1B8

#define SYSTEM_END_CODE				0x1B9
#define PACK_START_CODE				0x1BA
#define SYSTEM_START_CODE			0x1BB

#define VIDEO_ELEMENTARY_STREAM		0x1E0

#define PRIVATE_STREAM_1			0x1BD
#define PRIVATE_STREAM_2			0x1BF
#define AUDIO_ELEMENTARY_STREAM_0	0x1C0
#define AUDIO_ELEMENTARY_STREAM_1	0x1C1
#define AUDIO_ELEMENTARY_STREAM_2	0x1C2
#define AUDIO_ELEMENTARY_STREAM_3	0x1C3
#define AUDIO_ELEMENTARY_STREAM_4	0x1C4
#define AUDIO_ELEMENTARY_STREAM_5	0x1C5
#define AUDIO_ELEMENTARY_STREAM_6	0x1C6
#define AUDIO_ELEMENTARY_STREAM_7	0x1C7

#define SUB_SUB						0x20
#define SUB_AC3						0x80
#define SUB_DTS						0x88
#define SUB_PCM						0xA0

/* extension start code IDs */
#define SEQUENCE_EXTENSION_ID					1
#define SEQUENCE_DISPLAY_EXTENSION_ID			2
#define QUANT_MATRIX_EXTENSION_ID				3
#define COPYRIGHT_EXTENSION_ID					4
#define PICTURE_DISPLAY_EXTENSION_ID			7
#define PICTURE_CODING_EXTENSION_ID				8

#define ZIG_ZAG									0
#define MB_WEIGHT								32
#define MB_CLASS4								64

#define I_TYPE			1
#define P_TYPE			2
#define B_TYPE			3

#define MACROBLOCK_INTRA				1
#define MACROBLOCK_PATTERN				2
#define MACROBLOCK_MOTION_BACKWARD		4
#define MACROBLOCK_MOTION_FORWARD		8
#define MACROBLOCK_QUANT				16

#define TOP_FIELD		1
#define BOTTOM_FIELD	2
#define FRAME_PICTURE	3

#define MC_FIELD		1
#define MC_FRAME		2
#define MC_16X8			2
#define MC_DMV			3

#define MV_FIELD		0
#define MV_FRAME		1

#define CHROMA420		1
#define CHROMA422		2
#define CHROMA444		3

#define BUFFER_SIZE				2048
#define MAX_FILE_NUMBER			256



#define IDCT_MMX		1
#define IDCT_SSEMMX		2
#define	IDCT_FPU		3
#define IDCT_REF		4
#define IDCT_SSE2MMX	5

#define LOCATE_INIT			0
#define LOCATE_FORWARD		1
#define LOCATE_BACKWARD		-1
#define LOCATE_SCROLL		2
#define LOCATE_RIP			3

#define CHANNEL				8

#define TRACK_NONE		255
#define TRACK_1			0
#define TRACK_2			1
#define TRACK_3			2
#define TRACK_4			3
#define TRACK_5			4
#define TRACK_6			5
#define TRACK_7			6
#define TRACK_8			7

#define FORMAT_AUTO			0
#define FORMAT_AC3			1
#define FORMAT_MPA			2
#define FORMAT_LPCM			3
#define FORMAT_DTS			4

#define AUDIO_DEMUXALL		0
#define AUDIO_DEMUXONE		1
#define AUDIO_DECODE		2
#define AUDIO_BESWEET		3

#define DRC_NONE		0
#define DRC_LIGHT		1
#define DRC_NORMAL		2
#define DRC_HEAVY		3

#define FO_NONE			0
#define FO_FILM			1
#define FO_SWAP			2

#define SRC_NONE		0
#define SRC_LOW			1
#define SRC_MID			2
#define SRC_HIGH		3
#define SRC_UHIGH		4

#define TRACK_PITCH		500
#define MIN_WIDTH		288
#define MIN_HEIGHT		128


#define ASPECT_FREE	0
#define ASPECT_43	1
#define ASPECT_185	2
#define ASPECT_235	3
#define ASPECT_UNKNOWN	4

#define		KEY_OFF		0
#define		KEY_INPUT	1
#define		KEY_OP		2



typedef enum
{
	FILTER_BILINEAR			= 0,
	FILTER_SOFT_BICUBIC		= 1,
	FILTER_PRECISE_BICUBIC	= 2,
	FILTER_NEUTRAL_BICUBIC	= 3,
	FILTER_CUSTOM_BICUBIC	= 4,
	FILTER_NEAREST_NEIGHBOR	= 5
} ResizeType;

typedef enum
{
	STORE_RGB24		= 1,
	STORE_YUY2		= 2,
	STORE_YUV		= 3
} StorageColorFormat;


typedef struct  {
	FILE					*file;
	char					filename[_MAX_PATH];
	int						rip;
	int						size;
	int						delay;
} PCMStream;

typedef struct  {
	__int64					length[MAX_FILE_NUMBER];
	__int64					total;
	__int64					run;
	__int64					start;
	__int64					end;
	int						trackleft;
	int						trackright;
	int						locate;
	int						startfile;
	__int64					startloc;
	int						endfile;
	__int64					endloc;
	int						file;
	__int64					lba;
	int						leftfile;
	__int64					leftlba;
	int						rightfile;
	__int64					rightlba;
	unsigned int			op;
	unsigned int			mi;
	unsigned int			ed;
	unsigned int			elapsed;
	unsigned int			elapsedMs;
	unsigned int			remain;
	float					percent;
} PROCESS;

typedef struct  {
	BOOL					mmx;
	BOOL					_3dnow;
	BOOL					extended_3dnow;
	BOOL					ssemmx;
	BOOL					ssefpu;
	BOOL					sse2mmx;
} CPU;



typedef struct
{
	int Clip_Top;
	int Clip_Bottom;
	int Clip_Left;
	int Clip_Right;
	int Clip_Width;
	int Clip_Height;
	int Squeeze_Width;
	int Squeeze_Height;
	int Coded_Picture_Width, Coded_Picture_Height, Chroma_Width, Chroma_Height;
	int block_count, Second_Field;
	int horizontal_size, vertical_size, mb_width, mb_height;
	ResizeType Resize_Function;
	int Aspect_Change;
	int f_code[2][2];
	int picture_structure;
	int frame_pred_frame_dct;
	int progressive_frame;
	int concealment_motion_vectors;
	int intra_dc_precision;
	int top_field_first;
	int repeat_first_field;
	int intra_vlc_format;
	int avi_size, frame_count, kframe_count;
	int Resize_Width, Resize_Height;
	unsigned char *backward_reference_frame[3], *forward_reference_frame[3];
	unsigned char *auxframe[3], *current_frame[3];
	unsigned char *u422, *v422, *u444, *v444, *rgb24, *rgb24_temp, *rgb24_temp2, *yuy2, *yuy2_temp, *lum;
	//unsigned char *YUV;
	__int64 RGB_Scale, RGB_Offset, RGB_CRV, RGB_CBU, RGB_CGX;
	int LumOffset, LumGain;

	int Edge_Width, Edge_Height;
	unsigned short VOB_ID, CELL_ID;
	int VideoPTS, AudioPTS;
	unsigned int Frame_Number;
} GlobalPictureInfo;

typedef struct
{
	int AVI_Flag;
	int Check_Flag;
	int D2V_Flag;
	int Display_Flag;
	int Fault_Flag;
	int File_Limit;
	int FO_Flag;
	int iDCT_Flag;
	int Pause_Flag;
	int Rip_Flag;
	int Scale_Flag;
	int Statistics_Flag;
	int Stop_Flag;
	StorageColorFormat Store_Flag;
	int MPEG2_Transport_AudioPID;
	int MPEG2_Transport_VideoPID;
	int SystemStream_Flag;
	int File_Flag;
	unsigned int Track_Flag,Track_Flag2;
	int Format_Flag;
//	int AC3_Flag;
//	int AC3_Flag2;
	int MPA_Flag;
	int Norm_Ratio;
	bool Quit;
	bool ThreadMode;
	bool D2vExists;
	bool Play_Flag;
	bool InitDecoder;
	int AudioInfo;//0 : normal mode. More : looking for info
} DVD2aviGlobalFlags;

typedef struct {
	int			type;
	int			file;
	__int64		lba;
	int			pf;
	int			trf;
}	D2VData;

typedef struct {
	FILE					*file;
	int						rip;
	unsigned int			mode;
	unsigned int			rate;
}	AC3Stream;
typedef struct {
	FILE					*file;
	int						rip;
	int						delay;
}	MPAStream;

typedef struct
{
	RECT wrect, crect, orect, prect;
	HDC hDC;

	FILE *D2VFile;
	HWND hWnd, hDlg, hTrack;
	HWND Preview;
	char szInput[_MAX_PATH], szOutput[_MAX_PATH], szBuffer[_MAX_PATH], szPath[_MAX_PATH];
}	DVD2aviGUIGlobals;

typedef struct
{
	float frame_rate, Frame_Rate;
	int Video_Type, FILM_Purity, NTSC_Purity, Bitrate_Meter;

	int Infile[MAX_FILE_NUMBER];
	char *Infilename[MAX_FILE_NUMBER];

	int intra_quantizer_matrix[64];
	int non_intra_quantizer_matrix[64];
	int chroma_intra_quantizer_matrix[64];
	int chroma_non_intra_quantizer_matrix[64];

	int load_intra_quantizer_matrix;
	int load_non_intra_quantizer_matrix;
	int load_chroma_intra_quantizer_matrix;
	int load_chroma_non_intra_quantizer_matrix;

	int q_scale_type;
	int alternate_scan;
	int quantizer_scale;

	short *block[8];
	void *fTempArray;

	/* ISO/IEC 13818-2 section 6.2.2.1:  sequence_header() */
	int frame_rate_code;
	int aspect_ratio_information;

	/* ISO/IEC 13818-2 section 6.2.2.3:  sequence_extension() */
	int progressive_sequence;
	int chroma_format;

	/* ISO/IEC 13818-2 section 6.2.3: picture_header() */
	int picture_coding_type;
	int temporal_reference;

	
	D2VData d2v_backward, d2v_forward, d2v_current;

	int CH[CHANNEL];
	short Sound_Max;

	AC3Stream ac3[CHANNEL];

	MPAStream mpa[CHANNEL];

} DVD2aviGlobals;

typedef void (*DVD2aviCallBackFunction)(const char *);
typedef void (*DVD2aviCallBackFunction2)(int);
typedef void (*DVD2aviCallBackFunction3)(const char *,int);
typedef void (*DVD2aviCallBackFunction4)(void);
typedef void (*DVD2aviCallBackFunction5)(unsigned char *data);
typedef void (*DVD2aviCallBackFunction6)(int,int);
typedef void (*DVD2aviCallBackFunction7)(int,int,__int64 a=0,int b=0);

typedef struct
{
	DVD2aviCallBackFunction Info;
	DVD2aviCallBackFunction VobId;
	DVD2aviCallBackFunction CellId;
	DVD2aviCallBackFunction AspectRatio;
	DVD2aviCallBackFunction FrameRate;
	DVD2aviCallBackFunction AudioType;
	DVD2aviCallBackFunction TimeStamp;
	DVD2aviCallBackFunction VideoType;
	DVD2aviCallBackFunction Elapsed;
	DVD2aviCallBackFunction Remain;
	DVD2aviCallBackFunction FileSize;
	DVD2aviCallBackFunction FileAvgBitRate;
	DVD2aviCallBackFunction FileKFRatio;
	DVD2aviCallBackFunction FileAvgRes;
	DVD2aviCallBackFunction FileEstSize;
	DVD2aviCallBackFunction AvgFPS;
	DVD2aviCallBackFunction FrameType;
	DVD2aviCallBackFunction CodedNumber;
	DVD2aviCallBackFunction File;
	DVD2aviCallBackFunction2 Progress;
	DVD2aviCallBackFunction FPS;
	DVD2aviCallBackFunction PlaybackNumber;
	DVD2aviCallBackFunction2 TrackProgress;
	DVD2aviCallBackFunction TitleInfo;

} InfoFunctions;

typedef struct
{
	DVD2aviCallBackFunction3 D2VOutput;
	DVD2aviCallBackFunction D2VOutputString;
	DVD2aviCallBackFunction7 D2VOutputImage;
	DVD2aviCallBackFunction4 AutoSize;
	DVD2aviCallBackFunction5 RenderRGB24;
	DVD2aviCallBackFunction4 ThreadKill;
	DVD2aviCallBackFunction6 ResizeWindow;
} OutputFunctions;

class DVDFrame
{
public:
	DVDFrame() {}
	DVDFrame(int p_type,int p_trf,__int64 p_lba=0,int p_file=0) : type(p_type)
	{data.trf = p_trf;data.lba = p_lba;data.file = p_file;}
//private:
	int type; // I,P,B
	D2VData data;
};

class DVD_EOF {};


typedef __int64 (WINAPI *pfnKeyOp) (int, char*[], HWND);
typedef void (WINAPI *pfnBufferOp) (unsigned char*, int, int);



#endif