//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define f_PREFS_CPP

#include <windows.h>
#include <commctrl.h>

#include "resource.h"
#include "helpfile.h"

#include "gui.h"
#include "oshelper.h"
#include "dub.h"
#include "dubstatus.h"
#include "prefs.h"
// *******************************************************************
// *** VirtualDubMod											   ***
// *** Tobias Minich, November 2002								   ***
// BEGIN *************************************************************
#include "accel.h"

extern ACCELKEYTABLE_AVS g_accelAVS;
extern WORD g_accelAVSCommand[VDM_ACCEL_AVS_COUNT];
extern char g_accelAVSDescription[VDM_ACCEL_AVS_COUNT][255];

extern ACCELKEYTABLE_CAPTURE g_accelCapture;
extern WORD g_accelCaptureCommand[VDM_ACCEL_CAPTURE_COUNT];
extern char g_accelCaptureDescription[VDM_ACCEL_CAPTURE_COUNT][255];

extern ACCELKEYTABLE_MAIN g_accelMain;
extern WORD g_accelMainCommand[VDM_ACCEL_MAIN_COUNT];
extern char g_accelMainDescription[VDM_ACCEL_MAIN_COUNT][255];

extern char g_accelKEYDescription[256][255];
extern WORD g_accelKEYKeycode[256];

static char g_szKeytableAVS[]="Keytable AVS";
static char g_szKeytableCapture[]="Keytable Capture";
static char g_szKeytableMain[]="Keytable Main";

extern HACCEL g_hAccelAVS;
extern HACCEL g_hAccelMain;

extern HMENU hMenuNormal;

extern HWND g_hWnd;

//extern WORD g_accelAVSCommand[];

extern DubOptions g_dubOpts;
char g_szPerformanceOptions[]="Performance Options";

// END ***************************************************************

extern HINSTANCE g_hInst;

Preferences g_prefs={
	{ 0, PreferencesMain::DEPTH_FASTEST, 0, TRUE, 0 },
	{ 50*16, 4*16 },
};

static char g_szMainPrefs[]="Main prefs";

// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
/*AVSPreferences g_AVSprefs={
	FALSE
};

static char g_szAVSPrefs[]="AVS prefs";

extern HACCEL g_hAccelMain;*/
// END ***************************************************************

////////////////////////////////////////////////////////////////

static DWORD dwPrefsHelpLookup[]={
	IDC_OUTPUT_DEPTH,			IDH_PREFS_MAIN_OUTPUTCOLORDEPTH,
	IDC_PREVIEW_PRIORITY,		IDH_PREFS_MAIN_PROCESSPRIORITY,
	IDC_DUB_PRIORITY,			IDH_PREFS_MAIN_PROCESSPRIORITY,
	IDC_TACK_EXTENSION,			IDH_PREFS_MAIN_ADDEXTENSION,		
	IDC_ENABLE_16DITHERING,		IDH_PREFS_DISPLAY_16BITDITHER,
	IDC_INTERFRAME_SLIDER,		IDH_PREFS_SCENE_INTERFRAME,
	IDC_INTRAFRAME_SLIDER,		IDH_PREFS_SCENE_INTRAFRAME,
	IDC_PERFOPT_DEFAULT,		IDH_PREFS_CPU_OPTIMIZATIONS,
	IDC_PERFOPT_FORCE,			IDH_PREFS_CPU_OPTIMIZATIONS,
	IDC_PERFOPT_FPU,			IDH_PREFS_CPU_OPTIMIZATIONS,
	IDC_PERFOPT_MMX,			IDH_PREFS_CPU_OPTIMIZATIONS,
	IDC_RESTRICT_AVI_1GB,		IDH_PREFS_AVI_RESTRICT_1GB,
	IDC_AUTOCORRECT_L3,			IDH_PREFS_AVI_AUTOCORRECT_L3,
	0
};

typedef struct PrefsDlgData {
	Preferences prefs;
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
//	AVSPreferences AVSprefs;
	ACCELKEYTABLE_AVS KeytableAVS;
	ACCELKEYTABLE_CAPTURE KeytableCapture;
	ACCELKEYTABLE_MAIN KeytableMain;
// END ***************************************************************

	HWND hwndDisplay;
	RECT rcTab;
} PrefsDlgData;

static void PreferencesChildPosition(HWND hWnd, PrefsDlgData *pdd) {
	SetWindowPos(hWnd, HWND_TOP, pdd->rcTab.left, pdd->rcTab.top, 0, 0, SWP_NOSIZE);
}

static BOOL APIENTRY PreferencesMainDlgProc( HWND hDlg, UINT message, UINT wParam, LONG lParam) {
	static char *szDepths[]={
		"Fastest (16-bit)",
		"Use output setting",
		"Match display depth",
		"16-bit (HiColor)",
		"24-bit (TrueColor)",
	};

	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hDlg, DWL_USER);
	HWND hwndItem;
	int i;

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hDlg, (PrefsDlgData *)lParam);
			SetWindowLong(hDlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			hwndItem = GetDlgItem(hDlg, IDC_OUTPUT_DEPTH);
			for(i=0; i<5; i++)
				SendMessage(hwndItem, CB_ADDSTRING, 0, (LPARAM)szDepths[i]);

			SendMessage(hwndItem, CB_SETCURSEL, pdd->prefs.main.iPreviewDepth, 0);


			hwndItem = GetDlgItem(hDlg, IDC_PREVIEW_PRIORITY);
			SendMessage(hwndItem, CB_ADDSTRING, 0, (LPARAM)"Default");
			for(i=0; i<8; i++)
				SendMessage(hwndItem, CB_ADDSTRING, 0, (LPARAM)g_szDubPriorities[i]);

			SendMessage(hwndItem, CB_SETCURSEL, pdd->prefs.main.iPreviewPriority, 0);

			hwndItem = GetDlgItem(hDlg, IDC_DUB_PRIORITY);
			SendMessage(hwndItem, CB_ADDSTRING, 0, (LPARAM)"Default");
			for(i=0; i<8; i++)
				SendMessage(hwndItem, CB_ADDSTRING, 0, (LPARAM)g_szDubPriorities[i]);

			SendMessage(hwndItem, CB_SETCURSEL, pdd->prefs.main.iDubPriority, 0);

			//////////////

			CheckDlgButton(hDlg, IDC_TACK_EXTENSION, pdd->prefs.main.fAttachExtension);
			return TRUE;

		case WM_DESTROY:
			pdd->prefs.main.iPreviewDepth = (char)SendDlgItemMessage(hDlg, IDC_OUTPUT_DEPTH, CB_GETCURSEL, 0, 0);
			pdd->prefs.main.iPreviewPriority = (char)SendDlgItemMessage(hDlg, IDC_PREVIEW_PRIORITY, CB_GETCURSEL, 0, 0);
			pdd->prefs.main.iDubPriority = (char)SendDlgItemMessage(hDlg, IDC_DUB_PRIORITY, CB_GETCURSEL, 0, 0);
			pdd->prefs.main.fAttachExtension = IsDlgButtonChecked(hDlg, IDC_TACK_EXTENSION);
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesDisplayDlgProc( HWND hDlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hDlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hDlg, (PrefsDlgData *)lParam);
			SetWindowLong(hDlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			CheckDlgButton(hDlg, IDC_ENABLE_16DITHERING, !!(pdd->prefs.fDisplay & Preferences::DISPF_DITHER16));

			return TRUE;

		case WM_DESTROY:
			pdd->prefs.fDisplay = IsDlgButtonChecked(hDlg, IDC_ENABLE_16DITHERING) ? Preferences::DISPF_DITHER16 : 0;
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesSceneDlgProc( HWND hDlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hDlg, DWL_USER);
	HWND hwndItem;
	long pos;

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hDlg, (PrefsDlgData *)lParam);
			SetWindowLong(hDlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			hwndItem = GetDlgItem(hDlg, IDC_INTERFRAME_SLIDER);
			SendMessage(hwndItem, TBM_SETRANGE, FALSE, MAKELONG(0,255));
			SendMessage(hwndItem, TBM_SETPOS, TRUE,
					pdd->prefs.scene.iCutThreshold
						? 256 - ((pdd->prefs.scene.iCutThreshold+8)>>4)
						: 0
					);
			SendMessage(hDlg, WM_HSCROLL, 0, (LPARAM)hwndItem);

			hwndItem = GetDlgItem(hDlg, IDC_INTRAFRAME_SLIDER);
			SendMessage(hwndItem, TBM_SETRANGE, FALSE, MAKELONG(0,256));
			SendMessage(hwndItem, TBM_SETPOS, TRUE, pdd->prefs.scene.iFadeThreshold);
			SendMessage(hDlg, WM_HSCROLL, 0, (LPARAM)hwndItem);

			return TRUE;

		case WM_HSCROLL:
			pos = SendMessage((HWND)lParam, TBM_GETPOS, 0, 0);
			switch(GetWindowLong((HWND)lParam, GWL_ID)) {
			case IDC_INTERFRAME_SLIDER:
				if (!pos)
					SetDlgItemText(hDlg, IDC_INTERFRAME_VALUE, "Off");
				else
					SetDlgItemInt(hDlg, IDC_INTERFRAME_VALUE, pos, FALSE);
				return TRUE;
			case IDC_INTRAFRAME_SLIDER:
				if (!pos)
					SetDlgItemText(hDlg, IDC_INTRAFRAME_VALUE, "Off");
				else
					SetDlgItemInt(hDlg, IDC_INTRAFRAME_VALUE, pos, FALSE);

				return TRUE;
			}
			break;

		case WM_DESTROY:
			{
				int x = SendDlgItemMessage(hDlg, IDC_INTERFRAME_SLIDER, TBM_GETPOS, 0, 0);

				pdd->prefs.scene.iCutThreshold = x?(256-x)<<4:0;
				pdd->prefs.scene.iFadeThreshold = SendDlgItemMessage(hDlg, IDC_INTRAFRAME_SLIDER, TBM_GETPOS, 0, 0);
			}
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesCPUDlgProc(HWND hDlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hDlg, DWL_USER);
	BOOL fTemp;

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hDlg, (PrefsDlgData *)lParam);
			SetWindowLong(hDlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			CheckDlgButton(hDlg, IDC_PERFOPT_FPU, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_FPU));
			CheckDlgButton(hDlg, IDC_PERFOPT_MMX, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_MMX));
			CheckDlgButton(hDlg, IDC_PERFOPT_SSE, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_SSE));
			CheckDlgButton(hDlg, IDC_PERFOPT_SSE2, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_SSE2));
			CheckDlgButton(hDlg, IDC_PERFOPT_SSEPARTIAL, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_INTEGER_SSE));
			CheckDlgButton(hDlg, IDC_PERFOPT_3DNOW, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_3DNOW));
			CheckDlgButton(hDlg, IDC_PERFOPT_3DNOW2, !!(pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_3DNOW_EXT));

			if (pdd->prefs.main.fOptimizations & PreferencesMain::OPTF_FORCE) {
				CheckDlgButton(hDlg, IDC_PERFOPT_FORCE, TRUE);
			} else {
				CheckDlgButton(hDlg, IDC_PERFOPT_DEFAULT, TRUE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_FPU), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_MMX), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSE), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSE2), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSEPARTIAL), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_3DNOW), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_3DNOW2), FALSE);
			}

			return TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
			case IDC_PERFOPT_DEFAULT:
			case IDC_PERFOPT_FORCE:
				fTemp = !!(SendMessage(GetDlgItem(hDlg, IDC_PERFOPT_FORCE), BM_GETSTATE, 0, 0)&3);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_FPU), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_MMX), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSE), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSE2), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_SSEPARTIAL), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_3DNOW), fTemp);
				EnableWindow(GetDlgItem(hDlg, IDC_PERFOPT_3DNOW2), fTemp);
			}
			return TRUE;

		case WM_DESTROY:
			pdd->prefs.main.fOptimizations	= (IsDlgButtonChecked(hDlg, IDC_PERFOPT_FORCE) ? PreferencesMain::OPTF_FORCE : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_FPU) ? PreferencesMain::OPTF_FPU : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_MMX) ? PreferencesMain::OPTF_MMX : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_3DNOW) ? PreferencesMain::OPTF_3DNOW : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_3DNOW2) ? PreferencesMain::OPTF_3DNOW_EXT : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_SSEPARTIAL) ? PreferencesMain::OPTF_INTEGER_SSE : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_SSE) ? PreferencesMain::OPTF_SSE : 0)
											| (IsDlgButtonChecked(hDlg, IDC_PERFOPT_SSE2) ? PreferencesMain::OPTF_SSE2 : 0);
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesAVIDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hdlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hdlg, (PrefsDlgData *)lParam);
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			CheckDlgButton(hdlg, IDC_RESTRICT_AVI_1GB, !!pdd->prefs.fAVIRestrict1Gb);
			CheckDlgButton(hdlg, IDC_AUTOCORRECT_L3, !!pdd->prefs.fNoCorrectLayer3);
			return TRUE;

		case WM_DESTROY:
			pdd->prefs.fAVIRestrict1Gb = IsDlgButtonChecked(hdlg, IDC_RESTRICT_AVI_1GB);
			pdd->prefs.fNoCorrectLayer3 = IsDlgButtonChecked(hdlg, IDC_AUTOCORRECT_L3);
			return TRUE;
	}

	return FALSE;
}

// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
void EnableDisableKeyEntries(HWND hdlg) {
	bool bPVirt = !(SendDlgItemMessage(hdlg, IDC_P_MODE, CB_GETCURSEL, 0, 0)==0);
	bool bPEmpty;
	if (bPVirt)
		bPEmpty = SendDlgItemMessage(hdlg, IDC_P_KEY, CB_GETCURSEL, 0, 0)==0;
	else
		bPEmpty = SendDlgItemMessage(hdlg, IDC_P_ASCII, EM_LINELENGTH, 0, 0)==0;
	bool bSVirt = !(SendDlgItemMessage(hdlg, IDC_S_MODE, CB_GETCURSEL, 0, 0)==0);
/*	if (bSVirt)
		bool bSEmpty = SendDlgItemMessage(hdlg, IDC_S_KEY, CB_GETCURSEL, 0, 0)==0;
	else
		bool bSEmpty = SendDlgItemMessage(hdlg, IDC_S_ASCII, EM_LINELENGTH, 0, 0)==0;
*/
	ShowWindow(GetDlgItem(hdlg, IDC_P_KEY), bPVirt);
	ShowWindow(GetDlgItem(hdlg, IDC_P_ASCII), !bPVirt);
	ShowWindow(GetDlgItem(hdlg, IDC_S_KEY), bSVirt);
	ShowWindow(GetDlgItem(hdlg, IDC_S_ASCII), !bSVirt);

	EnableWindow(GetDlgItem(hdlg, IDC_P_CONTROL), bPVirt);
	EnableWindow(GetDlgItem(hdlg, IDC_P_SHIFT), bPVirt);

	EnableWindow(GetDlgItem(hdlg, IDC_S_ALT), !bPEmpty);
	EnableWindow(GetDlgItem(hdlg, IDC_S_CONTROL), bSVirt&&(!bPEmpty));
	EnableWindow(GetDlgItem(hdlg, IDC_S_SHIFT), bSVirt&&(!bPEmpty));
	EnableWindow(GetDlgItem(hdlg, IDC_S_KEY), !bPEmpty);
	EnableWindow(GetDlgItem(hdlg, IDC_S_MODE), !bPEmpty);
	EnableWindow(GetDlgItem(hdlg, IDC_S_ASCII), !bPEmpty);
}

static BOOL APIENTRY KeysDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	ACCELKEYSTRANSFER *pdd = (ACCELKEYSTRANSFER *)GetWindowLong(hdlg, DWL_USER);
//	bool fTemp;
	char b[2];
	bool fVkP;
	bool fVkS;

	switch(message) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (ACCELKEYSTRANSFER *)lParam;

			//////////////
			SetWindowText(hdlg, pdd->description);
			int i, p, s;
			i = 0;
			p = 0;
			s = 0;

			fVkP = pdd->command.altkey[0].fVirt&FVIRTKEY;
			fVkS = pdd->command.altkey[1].fVirt&FVIRTKEY;

			HWND hwndItemP;
			HWND hwndItemS;
			hwndItemP = GetDlgItem(hdlg, IDC_P_KEY);
			hwndItemS = GetDlgItem(hdlg, IDC_S_KEY);
			char *temp;
			while (g_accelKEYKeycode[i]!=0) {
				temp = &g_accelKEYDescription[i][0];
				SendMessage(hwndItemP, CB_ADDSTRING, 0, (LPARAM) temp);
				SendMessage(hwndItemS, CB_ADDSTRING, 0, (LPARAM) temp);
				if ((pdd->command.altkey[0].key==g_accelKEYKeycode[i])&&fVkP) p = i;
				if ((pdd->command.altkey[1].key==g_accelKEYKeycode[i])&&fVkS) s = i;
				i++;
			}
			SendMessage(hwndItemP, CB_SETCURSEL, p, 0);
			SendMessage(hwndItemS, CB_SETCURSEL, s, 0);

			SendDlgItemMessage(hdlg, IDC_P_MODE, CB_ADDSTRING, 0, (LPARAM) "ASCII");
			SendDlgItemMessage(hdlg, IDC_P_MODE, CB_ADDSTRING, 0, (LPARAM) "VIRTKEY");
			SendDlgItemMessage(hdlg, IDC_P_MODE, CB_SETCURSEL, (fVkP)?1:0, 0);
			b[1]=0;
			if (!fVkP) {
				b[0]=pdd->command.altkey[0].key;
				SendDlgItemMessage(hdlg, IDC_P_ASCII, WM_SETTEXT, 0, (LPARAM) &b);
			}
			SendDlgItemMessage(hdlg, IDC_P_ASCII, EM_LIMITTEXT, 1, 0);

			SendDlgItemMessage(hdlg, IDC_S_MODE, CB_ADDSTRING, 0, (LPARAM) "ASCII");
			SendDlgItemMessage(hdlg, IDC_S_MODE, CB_ADDSTRING, 0, (LPARAM) "VIRTKEY");
			SendDlgItemMessage(hdlg, IDC_S_MODE, CB_SETCURSEL, (fVkS)?1:0, 0);
			b[1]=0;
			if (!fVkS) {
				b[0]=pdd->command.altkey[1].key;
				SendDlgItemMessage(hdlg, IDC_S_ASCII, WM_SETTEXT, 0, (LPARAM) &b);
			}
			SendDlgItemMessage(hdlg, IDC_S_ASCII, EM_LIMITTEXT, 1, 0);

			CheckDlgButton(hdlg, IDC_P_ALT, (pdd->command.altkey[0].fVirt&FALT)?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hdlg, IDC_P_CONTROL, (pdd->command.altkey[0].fVirt&FCONTROL)?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hdlg, IDC_P_SHIFT, (pdd->command.altkey[0].fVirt&FSHIFT)?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hdlg, IDC_S_ALT, (pdd->command.altkey[1].fVirt&FALT)?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hdlg, IDC_S_CONTROL, (pdd->command.altkey[1].fVirt&FCONTROL)?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hdlg, IDC_S_SHIFT, (pdd->command.altkey[1].fVirt&FSHIFT)?BST_CHECKED:BST_UNCHECKED);

			EnableDisableKeyEntries(hdlg);
			return TRUE;

	    case WM_COMMAND:
			switch(LOWORD(wParam)) {
			case IDC_P_KEY:
			case IDC_P_MODE:
			case IDC_S_MODE:
			case IDC_P_ASCII:
				EnableDisableKeyEntries(hdlg);
				return TRUE;

			case IDOK:
				fVkP = !(SendDlgItemMessage(hdlg, IDC_P_MODE, CB_GETCURSEL, 0, 0)==0);
				fVkS = !(SendDlgItemMessage(hdlg, IDC_S_MODE, CB_GETCURSEL, 0, 0)==0);
				b[0]=0;
				WORD akey;
				if (fVkP)
					akey = g_accelKEYKeycode[SendDlgItemMessage(hdlg, IDC_P_KEY, CB_GETCURSEL, 0, 0)];
				else {
					SendDlgItemMessage(hdlg, IDC_P_ASCII, WM_GETTEXT, 2, (LPARAM) &b);
					akey = b[0];
					if (akey==0) akey = (WORD) -1;
				}
				if (akey == (WORD) -1) {
					pdd->command.altkey[0].key = 0;
					pdd->command.altkey[1].key = 0;
					pdd->command.altkey[0].fVirt = 0;
					pdd->command.altkey[1].fVirt = 0;
				} else {
					pdd->command.altkey[0].key = akey;
					if (fVkP)
						pdd->command.altkey[0].fVirt = FVIRTKEY|(IsDlgButtonChecked(hdlg, IDC_P_ALT)?FALT:0)|(IsDlgButtonChecked(hdlg, IDC_P_CONTROL)?FCONTROL:0)|(IsDlgButtonChecked(hdlg, IDC_P_SHIFT)?FSHIFT:0);
					else
						pdd->command.altkey[0].fVirt = (IsDlgButtonChecked(hdlg, IDC_P_ALT)?FALT:0);
					b[0]=0;
					if (fVkS)
						akey = g_accelKEYKeycode[SendDlgItemMessage(hdlg, IDC_S_KEY, CB_GETCURSEL, 0, 0)];
					else {
						SendDlgItemMessage(hdlg, IDC_S_ASCII, WM_GETTEXT, 2, (LPARAM) &b);
						akey = b[0];
						if (akey==0) akey = (WORD) -1;
					}
					if (akey == (WORD) -1) {
						pdd->command.altkey[1].key = 0;
						pdd->command.altkey[1].fVirt = 0;
					} else {
						pdd->command.altkey[1].key = akey;
						if (fVkS)
							pdd->command.altkey[1].fVirt = FVIRTKEY|(IsDlgButtonChecked(hdlg, IDC_S_ALT)?FALT:0)|(IsDlgButtonChecked(hdlg, IDC_S_CONTROL)?FCONTROL:0)|(IsDlgButtonChecked(hdlg, IDC_S_SHIFT)?FSHIFT:0);
						else
							pdd->command.altkey[1].fVirt = (IsDlgButtonChecked(hdlg, IDC_S_ALT)?FALT:0);
					}
				}
/*				pdd->command.altkey[0].key = g_accelKEYKeycode[SendDlgItemMessage(hdlg, IDC_P_KEY, CB_GETCURSEL, 0, 0)];
				if (pdd->command.altkey[0].key == (WORD) -1) {
					pdd->command.altkey[0].key = 0;
					pdd->command.altkey[1].key = 0;
					pdd->command.altkey[0].fVirt = 0;
					pdd->command.altkey[1].fVirt = 0;
				} else {
					pdd->command.altkey[0].fVirt = FVIRTKEY|(IsDlgButtonChecked(hdlg, IDC_P_ALT)?FALT:0)|(IsDlgButtonChecked(hdlg, IDC_P_CONTROL)?FCONTROL:0)|(IsDlgButtonChecked(hdlg, IDC_P_SHIFT)?FSHIFT:0);
					pdd->command.altkey[1].key = g_accelKEYKeycode[SendDlgItemMessage(hdlg, IDC_S_KEY, CB_GETCURSEL, 0, 0)];
					if (pdd->command.altkey[1].key == (WORD) -1) {
						pdd->command.altkey[1].key = 0;
						pdd->command.altkey[1].fVirt = 0;
					} else {
						pdd->command.altkey[1].fVirt = FVIRTKEY|(IsDlgButtonChecked(hdlg, IDC_S_ALT)?FALT:0)|(IsDlgButtonChecked(hdlg, IDC_S_CONTROL)?FCONTROL:0)|(IsDlgButtonChecked(hdlg, IDC_S_SHIFT)?FSHIFT:0);
					}
				}
*/
				EndDialog(hdlg, TRUE);
				return TRUE;
			case IDCANCEL:

				EndDialog(hdlg, FALSE);
				return TRUE;
			}
            break;
		case WM_DESTROY:
//			pdd->AVSprefs.bAlternateKeys = (IsDlgButtonChecked(hdlg, IDC_REFRESH_KEY)==BST_CHECKED);
			return TRUE;
	}

	return FALSE;
}

/*
static BOOL APIENTRY PreferencesAVSDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hdlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hdlg, (PrefsDlgData *)lParam);
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////

			CheckDlgButton(hdlg, IDC_REFRESH_KEY, pdd->AVSprefs.bAlternateKeys?BST_CHECKED:BST_UNCHECKED);
			return TRUE;

		case WM_DESTROY:
			pdd->AVSprefs.bAlternateKeys = (IsDlgButtonChecked(hdlg, IDC_REFRESH_KEY)==BST_CHECKED);
			return TRUE;
	}

	return FALSE;
}*/

static BOOL APIENTRY PreferencesMainKeyDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hdlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hdlg, (PrefsDlgData *)lParam);
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETEXTENDEDLISTVIEWSTYLE, 
				LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES, LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);


			LVCOLUMN c;
			c.mask = LVCF_TEXT|LVCF_WIDTH;
			c.pszText = "Description";
			c.cx = 154;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 0, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Primary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 1, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Secondary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 2, (LPARAM) &c);

			LVITEM l;
			char buffer[255];
			int i;

			for(i=0; i<VDM_ACCEL_MAIN_COUNT; i++) {
				if (g_accelMainCommand[i]>-1) {
					l.mask = LVIF_PARAM|LVIF_TEXT;
					l.lParam = i;
					l.iItem = i;
					l.iSubItem = 0;
					l.pszText = &g_accelMainDescription[i][0];
					int index = SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTITEM, 0, (LPARAM) &l);
					l.mask = LVIF_TEXT;
					l.iItem = index;
					if (pdd->KeytableMain.command[i].altkey[0].key!=0) {
						l.iSubItem = 1;
						GetKeyString(pdd->KeytableMain.command[i].altkey[0].fVirt, pdd->KeytableMain.command[i].altkey[0].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
					if (pdd->KeytableMain.command[i].altkey[1].key!=0) {
						l.iSubItem = 2;
						GetKeyString(pdd->KeytableMain.command[i].altkey[1].fVirt, pdd->KeytableMain.command[i].altkey[1].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
				}
			}

			//CheckDlgButton(hdlg, IDC_REFRESH_KEY, pdd->AVSprefs.bAlternateKeys?BST_CHECKED:BST_UNCHECKED);
			return TRUE;

		case WM_NOTIFY:
			NMHDR *hdr;
			hdr = (LPNMHDR) lParam;
			if (wParam == IDC_LIST_AVS_KEYS) {
				if (hdr->code == NM_DBLCLK) {
					NMITEMACTIVATE *lpnmitem = (LPNMITEMACTIVATE) lParam;
					ACCELKEYSTRANSFER trans;
					LVITEM l;
					l.iItem = lpnmitem->iItem;
					l.iSubItem = 0;
					l.mask = LVIF_PARAM;
					SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_GETITEM, 0, (LPARAM) &l);
					trans.description = &g_accelMainDescription[l.lParam][0];
					trans.command = pdd->KeytableMain.command[l.lParam];
					if (DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_KEYS), hdlg, KeysDlgProc, (LPARAM) &trans)) {
						pdd->KeytableMain.command[l.lParam] = trans.command;
						l.mask = LVIF_TEXT;
						l.iItem = lpnmitem->iItem;
						if (trans.command.altkey[0].key!=0) {
							l.iSubItem = 1;
							GetKeyString(trans.command.altkey[0].fVirt, trans.command.altkey[0].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 1;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
						if (trans.command.altkey[1].key!=0) {
							l.iSubItem = 2;
							GetKeyString(trans.command.altkey[1].fVirt, trans.command.altkey[1].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 2;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
					}
				}
			}
			return TRUE;

		case WM_DESTROY:
			//pdd->AVSprefs.bAlternateKeys = (IsDlgButtonChecked(hdlg, IDC_REFRESH_KEY)==BST_CHECKED);
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesCaptureKeyDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hdlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hdlg, (PrefsDlgData *)lParam);
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETEXTENDEDLISTVIEWSTYLE, 
				LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES, LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);


			LVCOLUMN c;
			c.mask = LVCF_TEXT|LVCF_WIDTH;
			c.pszText = "Description";
			c.cx = 154;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 0, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Primary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 1, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Secondary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 2, (LPARAM) &c);

			LVITEM l;
			char buffer[255];
			int i;

			for(i=0; i<VDM_ACCEL_CAPTURE_COUNT; i++) {
				if (g_accelCaptureCommand[i]>-1) {
					l.mask = LVIF_PARAM|LVIF_TEXT;
					l.lParam = i;
					l.iItem = i;
					l.iSubItem = 0;
					l.pszText = &g_accelCaptureDescription[i][0];
					int index = SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTITEM, 0, (LPARAM) &l);
					l.mask = LVIF_TEXT;
					l.iItem = index;
					if (pdd->KeytableCapture.command[i].altkey[0].key!=0) {
						l.iSubItem = 1;
						GetKeyString(pdd->KeytableCapture.command[i].altkey[0].fVirt, pdd->KeytableCapture.command[i].altkey[0].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
					if (pdd->KeytableCapture.command[i].altkey[1].key!=0) {
						l.iSubItem = 2;
						GetKeyString(pdd->KeytableCapture.command[i].altkey[1].fVirt, pdd->KeytableCapture.command[i].altkey[1].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
				}
			}

			//CheckDlgButton(hdlg, IDC_REFRESH_KEY, pdd->AVSprefs.bAlternateKeys?BST_CHECKED:BST_UNCHECKED);
			return TRUE;

		case WM_NOTIFY:
			NMHDR *hdr;
			hdr = (LPNMHDR) lParam;
			if (wParam == IDC_LIST_AVS_KEYS) {
				if (hdr->code == NM_DBLCLK) {
					NMITEMACTIVATE *lpnmitem = (LPNMITEMACTIVATE) lParam;
					ACCELKEYSTRANSFER trans;
					LVITEM l;
					l.iItem = lpnmitem->iItem;
					l.iSubItem = 0;
					l.mask = LVIF_PARAM;
					SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_GETITEM, 0, (LPARAM) &l);
					trans.description = &g_accelCaptureDescription[l.lParam][0];
					trans.command = pdd->KeytableCapture.command[l.lParam];
					if (DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_KEYS), hdlg, KeysDlgProc, (LPARAM) &trans)) {
						pdd->KeytableCapture.command[l.lParam] = trans.command;
						l.mask = LVIF_TEXT;
						l.iItem = lpnmitem->iItem;
						if (trans.command.altkey[0].key!=0) {
							l.iSubItem = 1;
							GetKeyString(trans.command.altkey[0].fVirt, trans.command.altkey[0].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 1;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
						if (trans.command.altkey[1].key!=0) {
							l.iSubItem = 2;
							GetKeyString(trans.command.altkey[1].fVirt, trans.command.altkey[1].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 2;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
					}
				}
			}
			return TRUE;

		case WM_DESTROY:
			//pdd->AVSprefs.bAlternateKeys = (IsDlgButtonChecked(hdlg, IDC_REFRESH_KEY)==BST_CHECKED);
			return TRUE;
	}

	return FALSE;
}

static BOOL APIENTRY PreferencesAVSKeyDlgProc(HWND hdlg, UINT message, UINT wParam, LONG lParam) {
	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hdlg, DWL_USER);

	switch(message) {
		case WM_INITDIALOG:
			PreferencesChildPosition(hdlg, (PrefsDlgData *)lParam);
			SetWindowLong(hdlg, DWL_USER, lParam);
			pdd = (PrefsDlgData *)lParam;

			//////////////
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETEXTENDEDLISTVIEWSTYLE, 
				LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES, LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);


			LVCOLUMN c;
			c.mask = LVCF_TEXT|LVCF_WIDTH;
			c.pszText = "Description";
			c.cx = 154;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 0, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Primary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 1, (LPARAM) &c);
			c.mask = LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
			c.fmt = LVCFMT_CENTER;
			c.pszText = "Secondary Key";
			c.cx = 90;
			SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTCOLUMN, 2, (LPARAM) &c);

			LVITEM l;
			char buffer[255];
			int i;

			for(i=0; i<VDM_ACCEL_AVS_COUNT; i++) {
				if (g_accelAVSCommand[i]>-1) {
					l.mask = LVIF_PARAM|LVIF_TEXT;
					l.lParam = i;
					l.iItem = i;
					l.iSubItem = 0;
					l.pszText = &g_accelAVSDescription[i][0];
					int index = SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_INSERTITEM, 0, (LPARAM) &l);
					l.mask = LVIF_TEXT;
					l.iItem = index;
					if (pdd->KeytableAVS.command[i].altkey[0].key!=0) {
						l.iSubItem = 1;
						GetKeyString(pdd->KeytableAVS.command[i].altkey[0].fVirt, pdd->KeytableAVS.command[i].altkey[0].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
					if (pdd->KeytableAVS.command[i].altkey[1].key!=0) {
						l.iSubItem = 2;
						GetKeyString(pdd->KeytableAVS.command[i].altkey[1].fVirt, pdd->KeytableAVS.command[i].altkey[1].key, (char *) &buffer, 255);
						l.pszText = (char *) &buffer;
						SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
					}
				}
			}

			//CheckDlgButton(hdlg, IDC_REFRESH_KEY, pdd->AVSprefs.bAlternateKeys?BST_CHECKED:BST_UNCHECKED);
			return TRUE;

		case WM_NOTIFY:
			NMHDR *hdr;
			hdr = (LPNMHDR) lParam;
			if (wParam == IDC_LIST_AVS_KEYS) {
				if (hdr->code == NM_DBLCLK) {
					NMITEMACTIVATE *lpnmitem = (LPNMITEMACTIVATE) lParam;
					ACCELKEYSTRANSFER trans;
					LVITEM l;
					l.iItem = lpnmitem->iItem;
					l.iSubItem = 0;
					l.mask = LVIF_PARAM;
					SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_GETITEM, 0, (LPARAM) &l);
					trans.description = &g_accelAVSDescription[l.lParam][0];
					trans.command = pdd->KeytableAVS.command[l.lParam];
					if (DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_KEYS), hdlg, KeysDlgProc, (LPARAM) &trans)) {
						pdd->KeytableAVS.command[l.lParam] = trans.command;
						l.mask = LVIF_TEXT;
						l.iItem = lpnmitem->iItem;
						if (trans.command.altkey[0].key!=0) {
							l.iSubItem = 1;
							GetKeyString(trans.command.altkey[0].fVirt, trans.command.altkey[0].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 1;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
						if (trans.command.altkey[1].key!=0) {
							l.iSubItem = 2;
							GetKeyString(trans.command.altkey[1].fVirt, trans.command.altkey[1].key, (char *) &buffer, 255);
							l.pszText = (char *) &buffer;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) &l);
						} else {
							l.iSubItem = 2;
							SendDlgItemMessage(hdlg, IDC_LIST_AVS_KEYS, LVM_SETITEM, 0, (LPARAM) "");
						}
					}
				}
			}
			return TRUE;

		case WM_DESTROY:
			//pdd->AVSprefs.bAlternateKeys = (IsDlgButtonChecked(hdlg, IDC_REFRESH_KEY)==BST_CHECKED);
			return TRUE;
	}

	return FALSE;
}
// END ***************************************************************

////////////////////////////////////////////////////////////////

static struct prefsTabs {
	LPTSTR	rsrc;
	char	*name;
	DLGPROC	dProc;
} tabs[]={
	{	MAKEINTRESOURCE(IDD_PREFS_MAIN),	"Main",		PreferencesMainDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_DISPLAY),	"Display",	PreferencesDisplayDlgProc },
	{	MAKEINTRESOURCE(IDD_PREFS_SCENE),	"Scene",	PreferencesSceneDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_CPU),		"CPU",		PreferencesCPUDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_AVI),		"AVI",		PreferencesAVIDlgProc	},
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
//	{	MAKEINTRESOURCE(IDD_PREFS_AVS),		"AVS",		PreferencesAVSDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_KEYS),		"Main Keys",		PreferencesMainKeyDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_KEYS),		"Capture Keys",		PreferencesCaptureKeyDlgProc	},
	{	MAKEINTRESOURCE(IDD_PREFS_KEYS),		"Script Editor Keys",		PreferencesAVSKeyDlgProc	},
// END ***************************************************************
};

BOOL APIENTRY PreferencesDlgProc( HWND hDlg, UINT message, UINT wParam, LONG lParam) {

	PrefsDlgData *pdd = (PrefsDlgData *)GetWindowLong(hDlg, DWL_USER);

	//////////

	switch(message) {
		case WM_INITDIALOG:
			{
				RECT r, r2;
				LONG du = GetDialogBaseUnits();
				LONG duX = LOWORD(du);
				LONG duY = HIWORD(du);
				HWND hWndTab = GetDlgItem(hDlg, IDC_TAB);
				LONG xDelta, yDelta;
				POINT p;
				int i;

				if (!(pdd = new PrefsDlgData)) return FALSE;
				memset(pdd, 0, sizeof pdd);
				SetWindowLong(hDlg, DWL_USER, (LPARAM)pdd);

				pdd->prefs = g_prefs;
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
//				pdd->AVSprefs = g_AVSprefs;
				pdd->KeytableAVS = g_accelAVS;
				pdd->KeytableCapture = g_accelCapture;
				pdd->KeytableMain = g_accelMain;
// END ***************************************************************


				for(i=0; i<(sizeof tabs/sizeof tabs[0]); i++) {
					TC_ITEM ti;

					ti.mask		= TCIF_TEXT;
					ti.pszText	= tabs[i].name;

					TabCtrl_InsertItem(hWndTab, i, &ti);
				}

				r.left = r.top = 0;
				r.right = 250;
				r.bottom = 150;
				MapDialogRect(hDlg, &r);

				GetWindowRect(hWndTab, &r2);
				p.x = r2.left;
				p.y = r2.top;
				ScreenToClient(hDlg, &p);
				pdd->rcTab = r;

				TabCtrl_AdjustRect(hWndTab, TRUE, &r);
				OffsetRect(&pdd->rcTab, p.x-r.left, p.y-r.top);

				xDelta = (r.right-r.left) - (r2.right-r2.left);
				yDelta = (r.bottom-r.top) - (r2.bottom-r2.top);

				SetWindowPos(hWndTab, NULL, 0, 0, r.right-r.left, r.bottom-r.top, SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOZORDER);

				guiOffsetDlgItem(hDlg, IDC_SAVE, xDelta, yDelta);
				guiOffsetDlgItem(hDlg, IDOK, xDelta, yDelta);
				guiOffsetDlgItem(hDlg, IDCANCEL, xDelta, yDelta);

				GetWindowRect(hDlg, &r);
				SetWindowPos(hDlg, NULL, 0, 0, r.right-r.left + xDelta, r.bottom-r.top + yDelta, SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOZORDER);

				pdd->hwndDisplay = CreateDialogParam(g_hInst, tabs[0].rsrc, hDlg, tabs[0].dProc, (LPARAM)pdd);
			}
			return TRUE;

		case WM_DESTROY:
			if (pdd) {
				delete pdd;
				SetWindowLong(hDlg, DWL_USER, 0);
			}
			return TRUE;

		case WM_NOTIFY: {
			NMHDR *nm = (LPNMHDR)lParam;

			switch(nm->code) {
			case TCN_SELCHANGE:
				{
					int iTab = TabCtrl_GetCurSel(nm->hwndFrom);

					if (iTab>=0) {
						if (pdd->hwndDisplay) DestroyWindow(pdd->hwndDisplay);
						pdd->hwndDisplay = CreateDialogParam(g_hInst, tabs[iTab].rsrc, hDlg, tabs[iTab].dProc, (LPARAM)pdd);
					}
				}
				return TRUE;
			}
			}break;

	    case WM_COMMAND:
			switch(LOWORD(wParam)) {
			case IDC_SAVE:
			case IDOK:
				if (pdd->hwndDisplay) {
					DestroyWindow(pdd->hwndDisplay);
					pdd->hwndDisplay = NULL;
				}
				g_prefs = pdd->prefs;
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
/*				if (pdd->AVSprefs.bAlternateKeys) {
					g_hAccelMain = LoadAccelerators(g_hInst, MAKEINTRESOURCE(IDR_IDLE_KEYS_ALT));
				} else {
					g_hAccelMain = LoadAccelerators(g_hInst, MAKEINTRESOURCE(IDR_IDLE_KEYS));
				}
				g_AVSprefs = pdd->AVSprefs;
*/				g_accelAVS = pdd->KeytableAVS;
				g_accelCapture = pdd->KeytableCapture;
				g_accelMain = pdd->KeytableMain;
				DestroyAcceleratorTable(g_hAccelAVS);
				g_hAccelAVS = CreateAVSAccelerators();
				DestroyAcceleratorTable(g_hAccelMain);
				g_hAccelMain = CreateMainAccelerators();
				HMENU temp;
				temp = CreateMainMenu();
				SetMenu(g_hWnd, temp);
				DestroyMenu(hMenuNormal);
				hMenuNormal = temp;
// END ***************************************************************

				if (LOWORD(wParam) == IDC_SAVE) {
					SetConfigBinary("", g_szMainPrefs, (char *)&g_prefs, sizeof g_prefs);
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
//					SetConfigBinary("", g_szAVSPrefs, (char *)&g_AVSprefs, sizeof g_AVSprefs);
					SetConfigBinary("", g_szKeytableAVS, (char *)&g_accelAVS, sizeof g_accelAVS);
					SetConfigBinary("", g_szKeytableCapture, (char *)&g_accelCapture, sizeof g_accelCapture);
					SetConfigBinary("", g_szKeytableMain, (char *)&g_accelMain, sizeof g_accelMain);
// END ***************************************************************
				}

				EndDialog(hDlg, TRUE);
				return TRUE;
			case IDCANCEL:
				if (pdd->hwndDisplay) {
					DestroyWindow(pdd->hwndDisplay);
					pdd->hwndDisplay = NULL;
				}
				EndDialog(hDlg, FALSE);
				return TRUE;
			}
            break;

		case WM_HELP:
			{
				HELPINFO *lphi = (HELPINFO *)lParam;

				if (lphi->iContextType == HELPINFO_WINDOW)
					HelpPopupByID(hDlg, lphi->iCtrlId, dwPrefsHelpLookup);
			}
			return TRUE;
	}

	return FALSE;
}

void LoadPreferences() {
	DWORD dwSize;
	Preferences prefs_t;

	dwSize = QueryConfigBinary("", g_szMainPrefs, (char *)&prefs_t, sizeof prefs_t);

	if (dwSize) {
		if (dwSize > sizeof g_prefs) dwSize = sizeof g_prefs;

		memcpy(&g_prefs, &prefs_t, dwSize);
	}
// *******************************************************************
// *** REFRESH + AVS Modification								   ***
// *** Tobias Minich, August 2002								   ***
// BEGIN *************************************************************
/*	AVSPreferences AVSprefs_t;

	dwSize = QueryConfigBinary("", g_szAVSPrefs, (char *)&AVSprefs_t, sizeof AVSprefs_t);

	if (dwSize) {
		if (dwSize > sizeof g_AVSprefs) dwSize = sizeof g_AVSprefs;

		memcpy(&g_AVSprefs, &AVSprefs_t, dwSize);
	}
*/
	ACCELKEYTABLE_AVS KeytableAVS_t;

	dwSize = QueryConfigBinary("", g_szKeytableAVS, (char *)&KeytableAVS_t, sizeof KeytableAVS_t);

	if (dwSize) {
		if (dwSize > sizeof KeytableAVS_t) dwSize = sizeof KeytableAVS_t;

		memcpy(&g_accelAVS, &KeytableAVS_t, dwSize);
	}

	ACCELKEYTABLE_CAPTURE KeytableCapture_t;

	dwSize = QueryConfigBinary("", g_szKeytableCapture, (char *)&KeytableCapture_t, sizeof KeytableCapture_t);

	if (dwSize) {
		if (dwSize > sizeof KeytableCapture_t) dwSize = sizeof KeytableCapture_t;

		memcpy(&g_accelCapture, &KeytableCapture_t, dwSize);
	}

	ACCELKEYTABLE_MAIN KeytableMain_t;

	dwSize = QueryConfigBinary("", g_szKeytableMain, (char *)&KeytableMain_t, sizeof KeytableMain_t);

	if (dwSize) {
		if (dwSize > sizeof KeytableMain_t) dwSize = sizeof KeytableMain_t;

		memcpy(&g_accelMain, &KeytableMain_t, dwSize);
	}

	DubPerfOptions PerfOptions_t;

	dwSize = QueryConfigBinary("", g_szPerformanceOptions, (char *)&PerfOptions_t, sizeof PerfOptions_t);

	if (dwSize) {
		if (dwSize > sizeof PerfOptions_t) dwSize = sizeof PerfOptions_t;

		memcpy(&g_dubOpts.perf, &PerfOptions_t, dwSize);
	}
// END ***************************************************************
}
