/***********************************************************************
 * VirtualDub Modification for OGM
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 *
 *
 *
 */

#ifndef __SERIALGENERATOR_H__
#define __SERIALGENERATOR_H__

#include "OGMCommonDefs.h"
#include "../error.h"

// Type of creation for unique serials
#define T_INCREASING   1
#define T_RANDOM       2

/*
 * To create chain of integers (used for knowing which serials are registered)
 * Same remark here : please use the new operator, which put default values by itself
 */
struct int_mesh {
	int              num;;
	struct int_mesh *next;

	void* operator new(unsigned int nAlloc) {
		int_mesh* new_mesh = (int_mesh*)malloc(nAlloc);
		if(new_mesh) {
			new_mesh->num  = 0;
			new_mesh->next = NULL;
		}
		return new_mesh;
	}
};


class SerialGenerator {
private:
	int_mesh *registered_serials;
	int       creation_type;
	bool      force_creation;
protected:
public:
	SerialGenerator(int creation_type=T_INCREASING, bool force_creation=true);
	virtual ~SerialGenerator(void);
	int       get_creation_type(void) { return creation_type; };
	void      set_creation_type(int type) { creation_type = type; };
	bool      get_force_creation(void) { return force_creation; };
	void      set_force_creation(bool force) { force_creation = force; };
	int       create_unique_serial(int serial);
	void      register_serial(int seral);
	void      unregister_serial(int serial);
	bool      serial_in_use(int serial);
};

#endif /* __SERIALGENERATOR_H__ */
