//	VirtualDubMod - Video processing and capture application based on VirtualDub by Avery Lee
//	Copyright (C) 1998-2002 VirtualDubMod Developers
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//  Adapted from a sample by Todd Jeffreys

#ifndef f_OPENGLWND_H
#define f_OPENGLWND_H

#include <gl/gl.h>
#include <gl/glu.h>

class COpenGLWndController
{
private:
  // these are friends because these functions need to call SetParameters
  friend static LRESULT OnOpenGLSetController(HWND hWnd,void *pController);
  friend static LRESULT OnOpenGLCreate(HWND hWnd,LPCREATESTRUCT lpcs);
  void SetParameters(HDC hdc,HGLRC hglrc);
  virtual void vDraw() = 0;  // render it now
  
  HDC m_hdc;
  HGLRC m_hglrc;

public:
  void Draw();
  virtual ~COpenGLWndController() {;}
  virtual int  ValidatePixelFormat(HDC hdc,int suggestedFormat);
  virtual void WindowSized(int cx,int cy) = 0;
  virtual void Init() = 0;  // initialize textures
  virtual void Close() = 0; // the window is closing, destroy textures/etc
};

// lParam is an instance of COpenGLWndCallback, wParam is ignored
#define WM_SETCONTROLLER (WM_USER+1)
// lParam and wParam ignored.  Returns a pointer to the COpenGLWndController
#define WM_GETCONTROLLER (WM_USER+2)

BOOL RegisterOpenGLWindow(HINSTANCE hInst);
// Remember, once created, the window will call 'delete' on the controller.  
HWND CreateOpenGLWindow(HINSTANCE hInst,HWND hParent,DWORD style,UINT id,LPRECT rt,COpenGLWndController *pController,LPPIXELFORMATDESCRIPTOR pfd);

#endif