# fs_kmodule
require "log"
require "vfs"

class ModprobeError < RuntimeError
	def initialize(mod, opt, message)
		@mod = mod
		@opt = opt
		@message = message
	end
	def to_s
		return "Can't load module #{name} (option:#{opt}): #{message}"
	end
end

class KernelModuleFS < VFSWrapper
	def initialize(initrdfs)
		@initrdfs = initrdfs
		@kernel_version = @initrdfs.cmd_uname("-r").strip  # 例外は呼び出し元でキャッチ
		super()
	end
	attr_reader :kernel_version


	def mount(arkfs, image, path)
		if mounted?
			return
		end
		@basefs = LoopFS.new
		@basefs.mount(arkfs.loop_kmodule, image, path, "squashfs", "ro")
	end


	#######
	## Files
	##
	def pcimap_file
		return @basefs.point + "/#{@kernel_version}/modules.pcimap"
	end
	def usbmap_file
		return @basefs.point + "/#{@kernel_version}/modules.usbmap"
	end


	def load(mod, opt = nil)
		$log.info "loading module \"#{mod}\" #{opt}"

		# 例外は警告を出して無視（カーネル組み込みになっている場合がある）
		# 同じモジュールを2度読み込んだときは、modprobeは失敗しない
		begin
			$log.debug @initrdfs.cmd_modprobe(mod, opt)
		rescue
			$log.debugError $!
		end
	end

	def loadUserSpecified
		specified = $param.getValue("modprobe", "").split(",")
		specified.each {|s|
			begin
				mod, opt = s.split(":",2)
				self.load(mod, opt)
			rescue
				$log.warn $!
			end
		}
	end

	def reLoadUserSpecified
		# XXX: 未実装: reLoadUserSpecified
		loadUserSpecified
	end

end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"


