# fs_shadow
require "log"
require "vfs"

class RamShadowFS < VFS
	def mount(path, sizeopt)
		self.mountdev("shadowfs", path, "tmpfs", "size=#{sizeopt}")
	end
end

class ShadowFS < VFSWrapper
	DEFAULT_KEYFILE_NAME = "viver.shadow"

	def initialize(procfs)
		@procfs = procfs
		super()
	end

	def getSmartRamSize
		# MB単位で返す
		return @procfs.memtotal / 1024 / 4  # ProcFS::memtotalはKB単位で返してくる
	end

	def mount_phy(arkfs, disks, path_shadow, path_screen)
		# XXX: デフォルトのヒントにInternalを入れて内部メディアを優先させる？
		keyname, hints = $param.getFileAndHints("shadow", DEFAULT_KEYFILE_NAME, [])

		screenfs = disks.getBestVolumeByDirOrFile(keyname, hints) # 例外は呼び出し元でキャッチ
		$log.success "Found screen volume #{screenfs.name} by key #{keyname}"
		screenfs.remount("rw")  # XXX: 既にrwでマウントされていないなら、の条件分岐が必要

		if screenfs.mountedOnTrial?
			screenfs.move(path_screen)
		end

		keypath = screenfs.point + "/#{keyname}"
		if File.directory?(keypath)
			# keynameがディレクトリなので、BindFS
			@basefs = BindFS.new
			@basefs.mount(keypath, path_shadow)
		else
			# keynameがファイルなので、LoopFS
			@basefs = LoopFS.new
			# XXX: ファイルシステムは判別する？
			@basefs.mount(arkfs.loop_shadow, keypath, path_shadow, "ext3", "rw")
		end

		return screenfs

	end
	private :mount_phy


	def mount_ram(path_shadow)
		size = 64
		unit = "m"
		if (sizeline = $param.getValue("ramsize", nil)) != nil
			# ユーザーからのサイズ指定あり
			begin
				match = /^([1-9][0-9]*)(.?)[bB]?$/.match(sizeline)
				size_user = Integer(match[1])
				unit_user = match[2].upcase
				case unit_user
				when ""
					# デフォルトの単位はMB
					size = size_user
					unit = "m"
				when "K"
					size = size_user
					unit = "k"
				when "M"
					size = size_user
					unit = "m"
				when "G"
					size = size_user * 1024
					unit = "m"
				when "T"
					size = size_user * 1024 * 1024
					unit = "m"
				else
					raise
				end
			rescue
				raise InvalidParameterError.new(sizeline, "Invalid size")
			end

		else
			# 指定無し
			size = getSmartRamSize
			unit = "m"
		end

		$log.success "Shadow RAM size is #{size}#{unit}"
		@basefs = RamShadowFS.new
		@basefs.mount(path_shadow, "#{size}#{unit}")
	end
	private :mount_ram


	def mount(arkfs, disks, path_shadow, path_screen)
		if $param.set?("shadow") && $param.getValueBool("shadow", false) != false
			# 物理ディスクをマウント
			return mount_phy(arkfs, disks, path_shadow, path_screen)
		else
			# tmpfsをマウント
			mount_ram(path_shadow)
			return VFS.new
		end
	end
end

$log.debug "#{File.basename(__FILE__, ".*")} loaded"
