require "network_setup"
require "thread"  # TODO: thread.rbは外部ライブラリ
require "log"


class NetworkManager
	def initialize(initrdfs, kmodule)
		@initrdfs = initrdfs
		@kmodule  = kmodule
		@configured = Array.new
		@not_configured = Array.new
		@config_lock = Mutex.new
		@route = Array.new
	end


	class UserSpec
		def initialize(dev, addr, mask, line)
			@dev  = (dev  === nil ? "" : dev )
			@addr = (addr === nil ? "" : addr)
			@mask = (mask === nil ? "" : mask)
			@line = line
		end
		attr_reader :dev, :addr, :mask
		def to_s
			return @line
		end
	end

	def getUserParameter(line)
		# netip=192.168.0.1
		# netip=192.168.0.1/255.255.255.0
		# netip=eth0:192.168.0.1,eth1:192.168.1.1/255.255.255.0
		# netip=192.168.0.1,eth0:192.168.1.1   (invalid)
		userspec = Hash.new

		line.split(",").each {|e|
			dev, ips = e.split(":", 2)
			if ips === nil
				# dev指定なし
				ips = dev
				dev = ""
			end
			addr, mask = ips.split("/", 2)
			userspec[dev] = UserSpec.new(dev, addr, mask, e)
		}

		return userspec
		# TODO: getUserParameter: ルーティングの指定はどうする？
	end
	private :getUserParameter


	def getInterfaceList
		msg = @initrdfs.cmd_ip("link show")

		iflist = Array.new
		msg.split("\n").each {|line|
			# 1: lo: <LOOPBACK> mtu 16436 qdisc noqueue 
			#     link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
			# 2: eth0: <BROADCAST,MULTICAST> mtu 1500 qdisc pfifo_fast qlen 1000
			#     link/ether 00:12:34:56:78:9a brd ff:ff:ff:ff:ff:ff
			# 3: eth2: <BROADCAST,MULTICAST> mtu 1500 qdisc pfifo_fast qlen 1000
			#     link/ether 00:12:34:56:78:9a brd ff:ff:ff:ff:ff:ff
			# 4: sit0: <NOARP> mtu 1480 qdisc noop 
			#     link/sit 0.0.0.0 brd 0.0.0.0
			if (match = /^[0-9]+: ([^:]+): <.*BROADCAST.*>/.match(line))
				# ブロードキャストが可能なインターフェイスのみ
				# loは含まれない
				iflist.push(match[1])
				$log.info "Find network interface #{match[1]}"
			end
		}

		return iflist
	end
	private :getInterfaceList


	def wakeup(force_wakeup = false)
		if !force_wakeup && !@configured.empty? && @not_configured
			return
		end

		# af_packetをロード
		@kmodule.load("af_packet")

		# ipv6をロード（for vfield）
		@kmodule.load("ipv6")

		# ユーザーからの指定
		# netip=192.168.0.1
		# netip=192.168.0.1/255.255.255.0
		# netip=eth0:192.168.0.1,eth1:192.168.1.1/255.255.255.0
		# netip=192.168.0.1,eth0:192.168.1.1   (invalid)
		userspec = getUserParameter( $param.getValue("netip", "") )

		if @not_configured.empty? && @configured.empty?
			# 初回の実行
			# FIXME: リトライ時にユーザーからの指定でもう一度getInterfaceListしたいときは？

			# loを起動
			@initrdfs.cmd_ifconfig("lo 127.0.0.1 up")
			loif = getNetInfo("lo", "fallback")

			@not_configured = getInterfaceList

			# getInterfaceListが成功した後でloifを追加
			@configured.push(loif)
		end

		threads = Array.new
		tid = 100   # fallbackで192.168.#{tid}.254が割り振られる
		@not_configured.each {|netif|
			t = Thread.new(tid) {|id|
				if userspec.key?(netif)
					user = userspec[netif]
				elsif userspec.key?("")
					user = userspec[""]
				else
					user = ""
				end
				wakeupInterface(netif, id, user)
			}
			tid += 1
			threads.push(t)
		}
		threads.each { |t| t.join }

		@route = getRouteInfo
		if @route.default === nil
			# デフォルトゲートウェイが無いので、自分のIPアドレスを設定
			# ブロードキャストが使えないため
			# method == dhcp -> autoip -> fallback の順で探す
			useif = ""
			["dhcp", "autoip", "fallback"].each {|md|
				@configured.each {|netif|
					netif.name == "lo" && next
					if netif.method == md
						$log.debug "Setting auto default gateway #{netif.ipaddr}"
						begin
							@initrdfs.cmd_route("add default gw #{netif.ipaddr}")
							useif = netif.name
							break		# 最初に見つかったものを採用
						rescue
							$log.warn $!
						end
					end
				}
				!useif.empty? && break
			}
			@route = getRouteInfo

			if @route.default === nil
				# それでもnil
				@initrdfs.cmd_route("add default gw 127.0.0.1") rescue $log.error $!
				@route = getRouteInfo
			end

			# XXX: 自動デフォルトゲートウエイ: これでもnilだったら？
		end # 自動デフォルトゲートウエイ終わり

	end


	def getInfo
		return @configured, @route
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"

