#include "vfield.h"
#include "bufferedreq.h"
#include "request.h"
#include <cstring>

namespace VFIELD {


// DataSendor
BufferedRequest::BufferedRequest(DataRequest& request) :
	DataRange(request.start(), request.end()),
	m_data(request.buffer()) {}
BufferedRequest::BufferedRequest(char* buffer, pos_type start, pos_type end) :
	DataRange(start, end),
	m_data(buffer) {}
BufferedRequest::BufferedRequest(char* buffer, const DataRange& range) :
	DataRange(range),
	m_data(buffer) {}

BufferedRequest::~BufferedRequest() throw() {}

void BufferedRequest::notifyTriger(status_type message)
{
	return m_triger.notify(message);
}


}  // namespace VFIELD
