#ifndef VFIELD_NOTIFY_H__
#define VFIELD_NOTIFY_H__

#include <boost/shared_ptr.hpp>
#include <boost/optional.hpp>
#include <boost/thread.hpp>
//#include <boost/bind.hpp>
//#include <functional>

//#define VF_NOTIFY_SPIN_LOCK

namespace VFIELD {


template <typename Message> class NotifyTrigerIMPL;
template <typename Message> class NotifyTriger;
template <typename Message> class NotifyClient;


////
// NotifyTriger
//
template <typename Message>
class NotifyTriger {  // copyable, shared IMPL
friend class NotifyClient<Message>;
public:
	NotifyTriger();
	~NotifyTriger();
public:
	void notify(const Message& message);
private:
	boost::shared_ptr< NotifyTrigerIMPL<Message> > impl;
	boost::shared_ptr< NotifyTrigerIMPL<Message> > operator-> (void);
};


////
// NotifyClient
//
template <typename Message>
class NotifyClient {  // copyable
friend class NotifyTriger<Message>;
public:
	explicit NotifyClient(NotifyTriger<Message> triger);
	~NotifyClient();
public:
	typedef Message                  message_type;
	typedef boost::optional<Message> message_ptr;
public:
	const message_type& wait(void);
	const message_ptr&  timed_wait(unsigned short seconds);
private:
	NotifyTriger<Message> pimpl;
private:
	NotifyClient();
};



////
// implementation
//
template <typename Message>
class NotifyTrigerIMPL {
friend class NotifyClient<Message>;
public:
	NotifyTrigerIMPL();
	~NotifyTrigerIMPL();
public:
	void notify(const Message& message);
private:
	boost::mutex mutex;
#ifndef VF_NOTIFY_SPIN_LOCK	// thread lock
	boost::condition cond;
#endif  // VF_NOTIFY_SPIN_LOCK
	boost::optional<Message> message_state;
};


// Triger
template <typename Message>
NotifyTriger<Message>::NotifyTriger() : impl( new NotifyTrigerIMPL<Message>() ) {}
template <typename Message>
NotifyTriger<Message>::~NotifyTriger() {}

template <typename Message>
NotifyTrigerIMPL<Message>::NotifyTrigerIMPL() {}
template <typename Message>
NotifyTrigerIMPL<Message>::~NotifyTrigerIMPL() {}

template <typename Message>
boost::shared_ptr< NotifyTrigerIMPL<Message> > NotifyTriger<Message>::operator-> (void)
{ return impl; }

template <typename Message>
void NotifyTriger<Message>::notify(const Message& message) { return impl->notify(message); }
template <typename Message>
void NotifyTrigerIMPL<Message>::notify(const Message& message)
{
	boost::mutex::scoped_lock lk(mutex);
	message_state = message;
#ifndef VF_NOTIFY_SPIN_LOCK	// thread lock
	cond.notify_all();
#endif // VF_NOTIFY_SPIN_LOCK
}

// Client
template <typename Message>
NotifyClient<Message>::NotifyClient(NotifyTriger<Message> triger) : pimpl(triger) {}
template <typename Message>
NotifyClient<Message>::~NotifyClient() {}

template <typename Message>
const Message& NotifyClient<Message>::wait(void)
{
#ifndef VF_NOTIFY_SPIN_LOCK	// thread lock
	boost::mutex::scoped_lock lk( pimpl->mutex );
#endif // VF_NOTIFY_SPIN_LOCK
	//pimpl->cond.wait(
	//		lk,
	//		boost::bind(std::equal_to<bool>(), pimpl->message_state, true) 
	//		);
#ifndef VF_NOTIFY_SPIN_LOCK	// thread lock
	while( !pimpl->message_state ) {
		pimpl->cond.wait(lk);
	}
#else			// spin lock
	while( ! pimpl->message_state ) ;
#endif // VF_NOTIFY_SPIN_LOCK
	return *pimpl->message_state;
}

template <typename Message>
const boost::optional<Message>& NotifyClient<Message>::timed_wait(unsigned short seconds)
{
	boost::mutex::scoped_lock lk( pimpl->mutex );
	if( pimpl->message_state ) {
		return pimpl->message_state;
	}

	boost::xtime xt;
	boost::xtime_get(&xt, boost::TIME_UTC);
	xt.sec += seconds;

	//pimpl->cond.timed_wait(
	//		lk,
	//		xt,
	//		boost::bind(std::equal_to<bool>(), pimpl->message_state, true) 
	//		);
	while( !pimpl->message_state ) {
		if( !pimpl->cond.timed_wait(lk, xt) ) break;	// タイムアウトしたらbreak
	}

	return pimpl->message_state;
}


}  // namespace VFIELD

#endif /* notify.h */
