#ifndef VFIELD_INTERFACE_NBD_PROCESSOR__
#define VFIELD_INTERFACE_NBD_PROCESSOR__

#include "linux_nbd.h"
#include "tools.h"
#include <boost/thread.hpp>

namespace VFIELD {
class Interface;

namespace NBD{


inline uint32_t getType(const struct nbd_request& req) throw()
{
	return ntohl(req.type);
}

int Negotiate(int sock, boost::mutex* sock_mutex, uint64_t image_size) throw();
void WriteProcessor(int sock, boost::mutex* sock_mutex, const struct nbd_request& req) throw();
void DisconnectProcessor(int sock, boost::mutex* sock_mutex, const struct nbd_request& req) throw();
void ReadProcessor(int sock, boost::mutex* sock_mutex, const struct nbd_request& req, Interface* vfif);


}  // namespace NBD

}  // namespace VFIELD

#endif /* nbd_processor.h */
