#ifndef VFIELD_ENGINE_H__
#define VFIELD_ENGINE_H__

namespace VFIELD {

class BufferedRequest;
class StreamManager;
class RPCClient;
class VTable;
class FindAckMapper;
class ThreadPool;
class EngineCommander;

struct EngineToolSet {
	EngineToolSet(	StreamManager& smgr_,
			RPCClient& rpcc_,
			VTable& vtable_,
			ThreadPool& threadpool_	) :
		smgr(smgr_),
		rpcc(rpcc_),
		vtable(vtable_),
		threadpool(threadpool_)
	{}

	StreamManager&	smgr;
	RPCClient&	rpcc;
	VTable&		vtable;
	ThreadPool&	threadpool;
};

void SearchEngine(BufferedRequest& request, EngineToolSet tools, EngineCommander& commander);

}  // namespace VFIELD

#endif /* engine.h */
