#ifndef VFIELD_VFIELD_H__
#define VFIELD_VFIELD_H__

#include "protocol.h"
#include <cstdlib>
#include <stdint.h>

namespace VFIELD {


typedef uint64_t pos_type;

////
// StreamManager
//

// 最大保持コネクション数
// nコネクションまで許した場合、ネットワーク全体のコネクション数は n(n-1)/2 本
const size_t		STREAM_MANAGER_MAX_CONNECTION			= 100;
// STREAM_MANAGER_MAX_CONNECTION * STREAM_MANAGER_FUZZY_COEFFICIENTに達したら_MAX_CONNECTIONまで切断
const float		STREAM_MANAGER_FUZZY_COEFFICIENT		= 0.2;
// コネクション監視間隔(秒)
const unsigned int	STREAM_MANAGER_SWEEP_INTERVAL			= 30;

// Stream Get Dataのバッファサイズ
const size_t		STREAM_BUFFER_SIZE				= 16 * 1024;	// 16 KB (JumboFrame)

// connectと、ネゴシエーション時のwrite/readのタイムアウト時間
// TimeoutDBを使う。(この時間) × (タイムアウト回数+1) が実際のタイムアウト時間
// 遅延ACKの考慮が必要か
const long		STREAM_FAST_TIMEOUT_SEC				= 0;
const long		STREAM_FAST_TIMEOUT_USEC			= 700 * 1000;	// 700ms

// Stream Get Data と Stream Join の1回のwrite/readのタイムアウト
const long		STREAM_SOCKET_SEND_TIMEOUT_SEC			= 10;
const long		STREAM_SOCKET_SEND_TIMEOUT_USEC			= 0;
const long		STREAM_SOCKET_RECV_TIMEOUT_SEC			= 10;
const long		STREAM_SOCKET_RECV_TIMEOUT_USEC			= 0;

// タイムアウト回数がこの回数を超過したらV-Tableから削除
// 0は1回目のタイムアウトで削除、1は２回目のタイムアウトで削除
const unsigned int	STREAM_NODE_DOWN_DETECT_TIMEOUT_COUNT		= 3;

// ネゴシエーション時に発生したエラーのリトライ回数
// 0はリトライしない、1は1回リトライ
// タイムアウトとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_TIMEOUT		= 2;
// 接続相手がソケットを閉じたとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_SOCKET_CLOSED	= 1;
// ネゴシエーションが衝突したとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_CONFLICT		= 3;
// SocketErrorExceptionのとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_SOCKET_ERROR	= 1;
// std::runtime_errorのとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_RUNTIME_ERROR	= 1;
// そのほかの例外のとき
const unsigned short	STREAM_NEGOTIATION_RETRY_LIMIT_UNKNOWN_ERROR	= 1;

// メインループの耐久回数
const unsigned short	STREAM_MANAGER_RETRY_LIMIT			= 20;



////
// RPCServer
//
// メインループの耐久回数
const unsigned short RPC_SERVER_RETRY_LIMIT		= STREAM_MANAGER_RETRY_LIMIT;



////
// Storage
//
// Joinのリトライ回数
// 0はリトライしない、1は1回リトライ
const unsigned short STREAM_JOIN_RETRY_LIMIT		= 2;



////
// SearchEngine
//
const unsigned short SEARCH_ENGINE_RETRY_LIMIT		= 5;		// 0はリトライしない、1は1回リトライ
const unsigned int SEARCH_ENGINE_RECAST_FIND_TIME_SEC	= 2;		// RPC Findを再送するまでの時間
const unsigned int SEARCH_ENGINE_RECAST_FIND_TIME_NSEC	= 0;		// FIXME: このあたりチューニングが必要
const unsigned int SEARCH_ENGINE_RECAST_LIMIT		= 30;		// この限界に達するごとにRETRY_LIMIT1回分
// TEST: const unsigned int SEARCH_ENGINE_RECAST_LIMIT		= 4;



////
// ThreadPool
//
const unsigned short THREAD_POOL_INITIAL_THREADS	= 10;



////
// Default Listen Port
//
// StreamとRPCは同じポート番号
const uint16_t DEFAULT_LISTEN_PORT			= 19660;



////
// VTable
//
const unsigned int VTABLE_RANDOMIZE_INTERVAL		= 5;		// FIXME: 短くてもさほど負荷はかからないはず


}  // namespace VFIELD

#endif /* vfield.h */
