require "fs_initrd"
require "fs_proc_sys"
require "fs_ark"
require "fs_kmodule"
require "hardware"
require "disks"
require "fallback"


begin
initrdfs = InitrdFS.new
initrdfs.mounted("./testpoint")
initrdfs.mktree
VFS.setInitrdFS(initrdfs)
rescue
	fallback == 0 && retry || halt
end


procfs = ProcFS.new
procfs.mount(initrdfs.mp_proc)

sysfs = SysFS.new
sysfs.mount(initrdfs.mp_sys)

kmodule = KernelModuleFS.new(initrdfs)
kmodule.mount(initrdfs.mp_kmodule)

arkfs = ArkFS.new
arkfs.mount(initrdfs.mp_ark)
arkfs.mktree(initrdfs)


hardware = HardwareDetect.new(initrdfs, sysfs, kmodule)
hardware.detect
hardware.show
#hardware.load

begin
disks = DiskManager.new(kmodule, initrdfs, arkfs, sysfs)
fixed = disks.getBestolumeByFile("xorg.conf", ["hdd"])
fixed.move(initrdfs.mp_fixed)
rescue
	fallback == 0 && retry || halt
end
puts `ls #{initrdfs.mp_fixed}`


sleep 10

disks.clean rescue $log.warn $!
fixed.umount
kmodule.umount rescue $log.warn $!
arkfs.umount rescue $log.warn $!
sysfs.umount rescue $log.warn $!
procfs.umount rescue $log.warn $!


