require "hardware_source"
require "log"


class HardwareDetect

	class DetectedPCI
		def initialize(vendor, device, pclass, modules)
			@vendor  = vendor
			@device  = device
			@pclass  = pclass
			@modules = modules
		end
		attr_reader :vendor, :device, :pclass, :modules
	end

	class DetectedUSB
		def initialize(vendor, device, iclass, modules)
			@vendor  = vendor
			@device  = device
			@iclass  = iclass
			@modules = modules
		end
		attr_reader :vendor, :device, :iclass, :modules
	end


	def detectPCI
		sourcePCI
		pci_devices_dir_cache = @sysfs.pci_devices.to_s
		Dir.open(pci_devices_dir_cache) {|dir|
			dir.each {|dev|
				dev_dir = pci_devices_dir_cache + "/" + dev
				vendor = IO.read(dev_dir + "/vendor", 4, 2) rescue next # 開けなかったら無視
				device = IO.read(dev_dir + "/device", 4, 2) rescue next
				pclass = IO.read(dev_dir + "/class",  4, 2) rescue next
				modules = [ @pcimap_v[vendor], @pcimap_vd[vendor + device], @pcimap_c[pclass] ].flatten.compact

				@detected_pci.push( DetectedPCI.new(vendor, device, pclass, modules) )
			}
		}
	end

	def detectUSB
		sourceUSB
		usb_devices_dir_cache = @sysfs.usb_devices.to_s
		Dir.open(usb_devices_dir_cache) {|dir|
			dir.each {|dev|
				if dev =~ /^usb[0-9]+/; next; end  # usb[0-9]+はLinuxのUSBホストドライバ
				dev_dir = usb_devices_dir_cache + "/" + dev

				vendor = nil
				device = nil
				iclass = nil
				modules = Array.new
				if File.file?(dev_dir + "/idVendor") \
						&& File.file?(dev_dir + "/idProduct")
					vendor = IO.read(dev_dir + "/idVendor",  4, 0) rescue next
					device = IO.read(dev_dir + "/idProduct", 4, 0) rescue next
					if @usbmap_vd.key?(vendor + device)
						modules.concat( @usbmap_vd[vendor + device] )
					end
				end
				if File.file?(dev_dir + "/bInterfaceClass")
					bc = IO.read(dev_dir + "/bInterfaceClass", 2, 0) rescue next
					sc = IO.read(dev_dir + "/bInterfaceSubClass", 2, 0) rescue next
					iclass = bc + sc
					# classでモジュール判定に使うのはBase classのみ
					if @usbmap_ic.key?( iclass[0,2] )
						modules.concat( @usbmap_ic[ iclass[0,2] ] )
					end
				end

				@detected_usb.push( DetectedUSB.new(vendor, device, iclass, modules.uniq) )
			}
		}
	end


end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
