require "log"


class HardwareDetect
	MODULE_SCSI_STORAGE  = ["sd_mod", "sr_mod"]
	MODULE_IDE_STORAGE   = ["ide-disk", "ide-cd"]
	MODULE_SATA_STORAGE  = MODULE_SCSI_STORAGE + ["libata"] + ["ahci"]
	MODULE_PCCARD_BRIDGE = [] + ["yenta_socket"]
	MODULE_FIREWIRE_BUS  = MODULE_SCSI_STORAGE + ["sbp2"] + ["ohci1394", "pcilynx"]
	MODULE_USB_BUS       = MODULE_SCSI_STORAGE + ["usb-storage"] + ["uhci-hcd", "ohci-hcd", "ehci-hcd"]
													# usb-storageはUSB自動検出でも検出可能だが、
													# ホットプラグを考慮してここでロードする


	def getModulePCI(dev)
		mod = dev.modules

		case dev.pclass[0,2]  # Base class
			  #dev.pclass[2,2]  # Sub class

		when "01"  # Mass storage controller
			case dev.pclass[2,2]
			when "00", "07"    # SCSI storage, Serial Attached SCSI controller
				mod.concat(MODULE_SCSI_STORAGE)
			when "01", "05"    # IDE interface, ATA controller
				mod.concat(MODULE_IDE_STORAGE)
			when "06", "04"    # SATA controller, RAID bus controller
				mod.concat(MODULE_SATA_STORAGE)
			end

		when "06"  # Bridge
			case dev.pclass[2,2]
			when "05", "07"    # PCMCIA bridge, CardBus bridge
				mod.concat(MODULE_PCCARD_BRIDGE)
			end

		when "0c"  # Serial bus controller
			case dev.pclass[2,2]
			when "00"          # FieWire (IEEE 1394)
				mod.concat(MODULE_FIREWIRE_BUS)
			when "03"          # USB Controller
				mod.concat(MODULE_USB_BUS)
			end

		end

		return mod
	end

	def getModuleUSB(dev)
		# XXX: getModuleUSB: modules.usbmapだけでロード可能？
		return dev.modules
	end

	private :getModulePCI, :getModuleUSB


	def loadDetectedPCI
		load_modules = Array.new

		@detected_pci.each {|dev|
			load_modules.concat( getModulePCI(dev) )
		}

		load_modules.uniq!
		load_modules.each {|m|
			@kmodule.load(m)
		}
	end


	def loadDetectedUSB
		load_modules = Array.new
		@detected_usb.each {|dev|
			load_modules.concat( dev.modules )
		}
		load_modules.uniq!
		load_modules.each {|m|
			@kmodule.load(m)
		}
	end

	private :loadDetectedPCI, :loadDetectedUSB

end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"

