require "cleanup"
require "log"
require "breakpoint"
require "disks"
require "fallback"
require "fs_ark"
require "fs_bootmedium"
require "fs_fixed"
require "fs_initrd"
require "fs_kmodule"
require "fs_proc_sys"
require "fs_shadow"
require "fs_sysroot"
require "hardware"
require "network"
require "parameters"
require "sharedblock"


# XXX: Debug
$log.setFilterLevel(Logger::INFO)
#$log.setFilterLevel(Logger::DEBUG)
#$log.setFilterLevel(Logger::DEBUG0)


########
## VFSの初期化
initrdfs = InitrdFS.new
begin
	initrdfs.mounted("/")
	initrdfs.mktree
	VFS.setInitrdFS(initrdfs)
	LoopFS.setInitrdFS(initrdfs)
rescue
	Fallback.sh() && retry
end


########
## procとsysfs
procfs = ProcFS.new
sysfs = SysFS.new
procfs.mount(initrdfs.mp_proc)	rescue Fallback.sh() && retry
sysfs.mount(initrdfs.mp_sys)	rescue Fallback.sh() && retry


########
## ブートパラメータをパース
$param = BootParameter.new
$param.parse(procfs.cmdline) rescue Fallback.sh() && retry
$debug = BreakPoint.new
$debug.setParameter	rescue Fallback.sh() && retry



########
## Arkを作成
arkfs = ArkFS.new
begin
	$debug.breakpoint("arkfs")
	arkfs.mount(initrdfs.mp_ark)
	arkfs.mktree(initrdfs)
	$log.setLogFile(arkfs.logfile)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end
File.chown(0, 0, arkfs.point)	rescue $log.warn $!
File.chmod(0755, arkfs.point) rescue $log.warn $!



########
## 圧縮カーネルモジュールディスクをループバックマウント
kmodule = KernelModuleFS.new(initrdfs)
begin
	$debug.breakpoint("kmodule")
	kmodule.mount(arkfs, initrdfs.kmodule_image, initrdfs.mp_kmodule)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end



########
## ハードウェア検出
hardware = HardwareDetect.new(sysfs, kmodule, initrdfs.pcidb_file, initrdfs.usbids_file)
begin
	$debug.breakpoint("hardware")
	hardware.detect
	hardware.show
rescue
	Fallback.sh() && retry
end



########
## DiskManager
disks = DiskManager.new(kmodule, initrdfs, arkfs, sysfs)
begin
	$debug.breakpoint("disks")
	# XXX: USBストレージの認識前にdetectが実行されてしまう USBを検出したらsleepが必要？
	# 遅延処理も可能だが、実装していない
	#   1. 例外処理が複雑になる
	#   2. どちらにせよparameters.lodViverConfがdisksを使う
	disks.detect
rescue
	Fallback.sh() && retry
end


########
## viver.conf
begin
	$debug.breakpoint("conf")
	$param.loadViverConf(disks)
rescue
	Fallback.sh() && retry
end

begin
	kmodule.reLoadUserSpecified
rescue
	Fallback.sh() && retry
end


########
## Boot
network =  NetworkManager.new(initrdfs, kmodule)
sharedblock = SharedBlock.new(network, initrdfs, arkfs, procfs, kmodule)
bootmediumfs = BootMediumFS.new
fixedfs = FixedFS.new

$bootfrom = ""
if !$param.set?("bootstrap")
	$bootfrom = "bootmedium"
	# ブートメディアからブート
	bootmedium_retry = false
	begin
		$debug.breakpoint("fixedfs")
		bootmediumfs.mount(disks, arkfs.mp_bootmedium, bootmedium_retry)
	rescue
		# XXX: クリーンアップ処理が必要
		bootmedium_retry = true
		Fallback.sh(Fallback::NOIGNORE) && retry
	end
	begin
		# XXX: クリーンアップ処理が必要
		$debug.breakpoint("medium")
		fixedfs.mountOnMedium(arkfs, bootmediumfs, arkfs.mp_fixed) # 中でtoRAMを処理 XXX: toRAM未実装
	rescue
		Fallback.sh(Fallback::NOIGNORE) && retry
	end

else
	$bootfrom = "network"
	fixedfs_retry = false
	# ネットワークブート
	begin
		$debug.breakpoint("fixedfs")
		fixedfs.mountSharedBlock(sharedblock, arkfs.mp_fixed, fixedfs_retry) # 中でnetwork.wakeupを処理
	rescue
		# XXX: クリーンアップ処理が必要
		fixedfs_retry = true
		Fallback.sh(Fallback::NOIGNORE) && retry
	end
end


########
## Shadow
shadowfs = ShadowFS.new(procfs)
screenfs = VFS.new
begin
	$debug.breakpoint("shadowfs")
	screenfs = shadowfs.mount(arkfs, disks, arkfs.mp_shadow, arkfs.mp_screen)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end
File.chown(0, 0, shadowfs.point) rescue $log.warn $!
File.chmod(0755, shadowfs.point) rescue $log.warn $!


########
## Sysroot
sysrootfs = SysrootFS.new(initrdfs)
begin
	$debug.breakpoint("sysrootfs")
	sysrootfs.mount(fixedfs, shadowfs, initrdfs.mp_sysroot, kmodule)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end
begin
	$debug.breakpoint("mktree")
	sysrootfs.mktree
rescue
	Fallback.sh() && retry
end


########
## sysrootへファイルシステムを移動
begin
	# all fs:
	arkfs.move(sysrootfs.mp_ark)
	# on ark: shadowfs
	# on ark: screenfs
	# on ark: fixedfs
	# on ark: bootmediumfs
	kmodule.move(sysrootfs.mp_kmodule)
	sysfs.move(sysrootfs.mp_sys)
	procfs.move(sysrootfs.mp_proc)   # procは最後
rescue
	# XXX: 未実装: クリーンアップ処理orクリーンアップ不要化
	Fallback.sh() && retry
end


########
## sysrootを編集
begin
	$debug.breakpoint("edit")
	allfs = [arkfs, shadowfs, screenfs, fixedfs, bootmediumfs, kmodule, sysfs, procfs]
	sysrootfs.editToMatch(procfs, disks, allfs, network, bootmediumfs)
rescue
	Fallback.sh() && retry
end


########
## switchroot
begin
	disks.clean
	sysrootfs.do_switchroot
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end

# ここにはこない



Fallback.invokeShell
procfs.move(initrdfs.mp_proc) rescue $log.error $!
sysfs.move(initrdfs.mp_sys) rescue $log.error $!
kmodule.move(initrdfs.mp_kmodule) rescue $log.error $!
arkfs.move(initrdfs.mp_ark) rescue $log.error $!
sysrootfs.umount rescue $log.error $!
shadowfs.umount rescue $log.error $!
screenfs.mounted? && screenfs.umount rescue $log.error $!
fixedfs.umount rescue $log.error $!
bootmediumfs.umount rescue $log.error $!
disks.clean rescue $log.error $!
kmodule.umount rescue $log.error $!
$log.logEnd
arkfs.umount rescue $log.error $!
sysfs.umount rescue $log.error $!
procfs.umount rescue $log.error $!



