require "vfs"
require "log"


class DiskManager


	class BlockEntry < VFS
		@@initrdfs = nil
		@@arkfs = nil
		def self.setInitrdFS(initrdfs)
			@@initrdfs = initrdfs
		end
		def self.setArkFS(arkfs)
			@@arkfs = arkfs
		end



		def initialize(major, minor, size, name, removable, type)
			@major = major
			@minor = minor
			@size = size
			@name = name
			@removable = removable
			@type = type

			@probed = false
			@probed_fstype = nil

			# DynamicPath
			@trialpoint = @@arkfs.trial + "/trial-#{@name}-#{@major}-#{@minor}"
			@devpath = @@arkfs.dev + "/#{@name}"
			Dir.mkdir(@trialpoint) rescue $log.warn $!
			@@initrdfs.cmd_mknod(@devpath, "b", @major, @minor) rescue $log.debug $!
		end
		attr_reader :major, :minor, :size, :name, :removable, :type, :mounted_point, :probed_fstype

		def probed?
			return @probed
		end
		def probe_failed?
			return @probed == true && @probed_fstype == nil
		end
		def probed_succeeded?
			return @probed == true && @probed_fstype != nil
		end


		def guessFSType(type)
			if type.include?("flash")
				return ["vfat", "ntfs", "ext3", "hfsplus", "reiserfs", "xfs", "squashfs", "reiser4", "hfs", "udf", "ufs", "jfs", "ext2", "iso9660"]
			elsif type.include?("optical")
				return ["iso9660", "udf", "hfsplus", "hfs", "ext3", "squashfs", "ext2", "vfat", "ntfs", "xfs", "reiserfs", "reiser4", "jfs", "ufs"]
			else
				# hdd
				return ["ntfs", "vfat", "ext3", "hfsplus", "xfs", "reiserfs", "reiser4", "hfs", "squashfs", "hfs", "ufs", "jfs", "ext2", "iso9660"]
			end
		end
		private :guessFSType

		def probeFSType
			if probed?
				return @fstype
			end

			fstype_not_tested = guessFSType(@type)

			fstype_not_tested.each {|fstype|
				begin
					$log.debug0 "mount testing #{@name} as #{fstype}"
					self.mountdev(@devpath, @trialpoint, fstype, "ro")
					$log.success "probed volume:  #{@name} #{fstype} (#{@type.join(",")})"

					# マウント成功
					@probed = true
					@probed_fstype = @fstype
					return @fstype
				rescue
					$log.debug0 $!
					# マウント失敗
				end
			}

			$log.info "unknown volume: #{@name} (#{@type.join(",")})"
			@probed = true
			return @fstype  #=> nil
		end

		def mountedOnTrial?
			if @point != nil && @point.to_s =~ /^#{@@arkfs.trial}.*/
				return true
			else
				return false
			end
		end

		class NotProbedError < MountError
			def initialize(name, type)
				@name = name
				@type = type
			end
			def to_s
				return "Attempt to mount #{@name} (#{@type.join(",")}) which is not probed"
			end
		end
		def mount(path, opt)
			opt.empty? && opt = "defaults"
			if ! probed_succeeded?
				raise NotProbedError.new(@name, @type)
			end
			self.mountdev(@devpath, path, @probed_fstype, opt)
		end

	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
