require "log"


class DiskManager
	FSMODULES = ["ntfs", "vfat", "nls_cp437", "nls_iso8859_1", "ext3", "hfsplus", "xfs", "reiserfs", "reiser4", "hfs", "squashfs", "hfs", "ufs", "jfs", "ext2", "iso9660"]

	def loadFilesystemModules
		@modules_loaded == true && return
		FSMODULES.each {|m|
			@kmodule.load(m)
		}
		@modules_loaded = true
	end
	private :loadFilesystemModules


	def detectIMPL(disk_dir, disk_name)
		# disk_dirは保持しないので、DynamicPathでなくて良い

		if disk_name =~ /^\.|^loop|^ram|^fd|^nbd/
			# dot-fileとループバックとRAMディスクとFDとnbdはスキップ
			return
		end

		major = 0
		minor = 0
		size = 0
		removable = false
		partitions = Array.new

		File.open( disk_dir + "dev" ) {|file|
			major, minor = file.gets.split(":", 2).map! { |s| s.to_i }
		}
		if major == 0  # majro == 0 は読み取り失敗
			raise "read error - #{disk_dir}dev"
		end

		## XXX: マウントされていないと全部0になる？
		#File.open( disk_dir + "stat") {|file|
		#	if file.gets.split.delete_if {|x| x == "0" }.empty?
		#		# statの中身が全部0なのは、メディアが入っていない光学ドライブやカードリーダ
		#		raise "No medium inserted (optical/card)"
		#	end
		#}

		File.open( disk_dir + "size") {|file|
			size = file.gets.to_i
		}
		if size == 0
			# size == 0はメディアが入っていないscsi系ドライバ制御のデバイス
			raise "No medium inserted (scsi/sata)"
		end

		File.open( disk_dir + "removable" ) {|file|
			if file.read(1) == "1"
				removable = true
			end
		}

		for i in 1..255
			File.open( disk_dir + disk_name + i.to_s ) {|file|
				partitions.push(disk_name + i.to_s)
			} rescue break  # 開けなかったら終わり
		end


		if !partitions.empty?
			# パーティションを含んでいる BlockEntryに加えるのは個々のパーティション
			partitions.each {|part_name|
				part_dir = disk_dir + part_name + "/"

				part_major = 0
				part_minor = 0
				part_size = 0

				File.open( part_dir + "dev" ) {|file|
					part_major, part_minor = file.gets.split(":", 2).map! { |s| s.to_i }
				}
				if part_major == 0	# 読み取り失敗
					raise "read error - #{part_dir}dev" 
				end

				File.open( part_dir + "size") {|file|
					part_size = file.gets.to_i
				}
				if part_size == 0		# 読み取り失敗
					raise "read error - #{part_dir}size" 
				end

				type = guessPartition(disk_name, size, part_name, part_size, removable)
				if type.include?("extend_partition")
					# block_entriesに入れない
					$log.debug "found extend partition:  #{part_name} (#{type.join(",")})"
				else
					@block_entries.push( BlockEntry.new(part_major, part_minor, part_size, part_name, removable, type) )
					$log.debug "found partition:  #{part_name} (#{type.join(",")})"
				end
			}
		else
			# パーティションを含んでいない
			# 光学ドライブかDeviceMapper(dm-*)
			type = guessDisk(disk_name, size, removable)
			@block_entries.push( BlockEntry.new(major, minor, size, disk_name, removable, type) )
			$log.debug "found disk:  #{disk_name} (#{type.join(",")})"
		end
	end
	private :detectIMPL



	def detect(force = false)
		if force == false && @detected == true
			return
		end

		loadFilesystemModules

		Dir.open(@sysfs.block) {|blocks|
			@block_entries.clear
			blocks.each {|disk_name|
				begin
					disk_dir_cache = @sysfs.block.to_s + "/#{disk_name}/"
					detectIMPL(disk_dir_cache, disk_name)
				rescue
					$log.debug "ignored volume #{disk_name}:  #{$!}"
				end
			}
		}
		probe_threads = Array.new
		@block_entries.each {|b|
			$log.debug0 "start filesystem type probing thread for #{b.name}"
			t = Thread.new {
				b.probeFSType
			}
			# XXX: 例外は投げない
			probe_threads.push(t)
		}
		probe_threads.each { |t| t.join }

		@detected = true
	end

end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
