require "log"

module Fallback
	NOIGNORE	= "noignore"


	def self.putsRed(msg)
		if defined?($log)
			$log.error msg
		else
			puts "#{Color::RED}#{msg}#{Color::NORMAL}"
		end
	end

	def self.reboot
		self.putsRed("Rebooting...")
		# FIXME: 未実装: reboot
		exit
	end

	def self.invokeShell
		ENV['PS1'] = "#{Color::GREEN}[VIVER]# "
		system("sh")
		if defined?($param)
			$param.loadUserShellParameter("/nextparam")
		end
		return $?
	end

	def self.sh(inc = [])
		$log.error "#{$!}"
		$log.error "#{$!.backtrace.join("\n    from ")}"
		$log.flush

		code = self.invokeShell

		case(code)

		when 127  # シェル実行エラー
			self.putsRed("Can't execute shell!")
			reboot
		when 193  # reboot
			reboot

		when 190  # ignore
			if inc == NOIGNORE
				self.putsRed("Unignorable!")
				self.sh(inc)
			else
				self.putsRed("Pass throw...")
				return false
			end
		when 191  # force ignore
			self.putsRed("Force ignore!")
			return false

		when 0    # retry
			self.putsRed("Retrying...")
			return true
		else    # unknown
			self.putsRed("Unknown exit code #{code}")
			self.putsRed("Retrying...")
			return true
		end

		if defined?($param)
			# XXX: $param.loadUserCommand
		end
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
