# fs_ark
require "log"
require "fsutils"
require "vfs"

class ArkFS < VFS
	ARK_SIZE="3m"

	def mount(path)
		self.mountdev("tmpfs", path, "tmpfs", "size=#{ARK_SIZE}")
	end

	def bin
		return @point + "/bin"
	end
	def bin_relative
		return "/bin"
	end
	def mp_fixed
		return @point + "/compressed"
	end
	def mp_shadow
		return @point + "/shadow"
	end
	def mp_screen
		return @point + "/screen"
	end
	def mp_bootmedium
		return @point + "/medium"
	end
	def mp_toram
		return @point + "/toram"
	end
	def trial
		return @point + "/trial"
	end

	def logfile
		return @point + "/viver.log"
	end

	def dev
		return @point + "/dev"
	end
	
	def dev_nbd
		return @point + "/dev/nbd0"
	end
	def dev_nbd_relative
		return "/dev/nbd0"
	end

	LOOPNUM_KMODULE = 4
	LOOPNUM_SHADOW  = 5
	LOOPNUM_FIXED   = 6
	def loop_kmodule
		return @point + "/dev/loop#{LOOPNUM_KMODULE}"
	end
	def loop_shadow
		return @point + "/dev/loop#{LOOPNUM_SHADOW}"
	end
	def loop_fixed
		return @point + "/dev/loop#{LOOPNUM_FIXED}"
	end


	def mkmp(path)
		if !File.directory?(path)
			Dir.mkdir(path)
		end
	end
	private :mkmp


	def mktree(initrdfs)
		mkmp(bin)
		mkmp(mp_fixed)
		mkmp(mp_shadow)
		mkmp(mp_screen)
		mkmp(mp_bootmedium)
		mkmp(mp_toram)
		mkmp(trial)

		mkmp(dev)
		mkchardev( initrdfs, "#{self.dev}/null",            1,               3, 0666, 0, 0)  # crw-rw-rw- root:root
		mkchardev( initrdfs, "#{self.dev}/console",         5,               1, 0600, 0, 5)  # crw------- root:tty
		mkblockdev(initrdfs, dev_nbd,                      43,               0, 0660, 0, 6)  # brw-rw---- root:disk
		mkblockdev(initrdfs, loop_kmodule,                  7, LOOPNUM_KMODULE, 0660, 0, 6)  # brw-rw---- root:disk
		mkblockdev(initrdfs, loop_shadow,                   7,  LOOPNUM_SHADOW, 0660, 0, 6)  # brw-rw---- root:disk
		mkblockdev(initrdfs, loop_fixed,                    7,   LOOPNUM_FIXED, 0600, 0, 6)  # brw-rw---- root:disk

		mkmp("#{self.dev}/mapper")
		mkchardev( initrdfs, "#{self.dev}/mapper/control", 10,              63, 0660, 0, 0)  # crw-rw--- root:root
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"

