# fs_bootmedium
require "log"
require "vfs"

class BootMediumFS < VFSWrapper
	DEFAULT_IMAGE_NAME = "viver.squash"

	def mount(disks, path, force_detect = false)
		# TODO: デフォルトのヒントにinternalを入れて内部メディアを優先させる？
		# TODO: 内部メディアから起動するときはfixed=オプションをブートローダにに固定するか？
		# TODO: どちらにしてもviver.confのサポートがあれば要らない？
		@imagename, hints = $param.getFileAndHints("fixed", DEFAULT_IMAGE_NAME, [])

		disks.detect(force_detect)
		# FIXME: getBestVolumeByFile: viver.confと同様、サブディレクトリも探す
		managedfs = disks.getBestVolumeByFile(@imagename, hints)	# 例外は呼び出し元でキャッチ
			# managedfs.class == BlockEntry
		$log.success "Found boot medium #{managedfs.name} (#{managedfs.type.join(",")}) by image #{@imagename}"
		if managedfs.mountedOnTrial?
			managedfs.move(path)	# 例外は呼び出し元でキャッチ
			@basefs = managedfs
		else
			@basefs = BindFS.new
			@basefs.mount(managedfs.point, path)
		end
	end

	def getImagePath
		if !mounted?; raise NotMountedError.new("get disk image path on the volume"); end
		return @basefs.point + "/#{@imagename}"
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
