# fs_proc_sys
require "log"
require "vfs"

class ProcFS < VFS
	def mount(path)
		mounted? || self.mountdev("proc", path, "proc", "")
	end

	# Files:
	def cmdline
		return @point + "/cmdline"
	end

	def memtotal
		# KB単位で返す
		total = 0
		begin
			File.open(@point + "/meminfo") {|file|
				total = file.gets()[9..-1].to_i
			}
		rescue
			$log.warn $!
			total = 256 * 1024
		end
		return total
	end
end

class SysFS < VFS
	def mount(path)
		mounted? || self.mountdev("sysfs", path, "sysfs", "")
	end

	def block
		return @point + "/block"
	end

	def pci_devices
		return @point + "/bus/pci/devices"
	end
	def usb_devices
		return @point + "/bus/usb/devices"
	end
end

$log.debug "#{File.basename(__FILE__, ".*")} loaded"
