# fs_sysroot
require "vfs"
require "log"
require "fsutils"

class SysrootFS < VFS
	INITBRIDGE_RELATIVE = "/initbridge"
	# FIXME: viverrcは適切か？
	VIVERRC_RELATIVE = "/etc/RUNES/applyer"

	def initialize(initrdfs)
		@initrdfs = initrdfs
		super()
	end

	def mount(fixedfs, shadowfs, path, kmodule)
		#XXX: aufs/unionfs
		#kmodule.load("aufs")
		#self.mountdev("viverroot", path, "aufs", "dirs=#{shadowfs.point}:#{fixedfs.point}=ro")
		kmodule.load("unionfs")
		self.mountdev("viverroot", path, "unionfs", "dirs=#{shadowfs.point}:#{fixedfs.point}=ro")
	end

	def mp_ark
		return @point + "/VIVER"
	end
	def mp_proc
		return @point + "/proc"
	end
	def mp_sys
		return @point + "/sys"
	end
	def mp_kmodule
		return @point + "/lib/modules"
	end

	def mkmp(path)
		if !File.directory?(path)
			if File.exist?(path)
				File.delete(path)
			end
			Dir.mkdir(path)
		end
	end
	def mkmp_soft(path)
		mkmp(path) rescue $log.warn $!
	end
	private :mkmp, :mkmp_soft

	def blockdev(path, major, minor, mode, owner, group)
		mkchardev(@initrdfs, path, major, minor, mode, owner, group) rescue $log.warn $!
	end
	def chardev(path, major, minor, mode, owner, group)
		mkchardev(@initrdfs, path, major, minor, mode, owner, group) rescue $log.warn $!
	end
	def copy_soft(src, dst, mode)
		copy_file(src, dst, mode) rescue $log.warn $!
	end
	private :blockdev, :chardev, :copy_soft

	def mktree
		mkmp(mp_ark)
		mkmp(mp_proc)
		mkmp(mp_sys)
		mkmp(mp_kmodule)
	end

	def editToMatch(procfs, disks, allfs, network, bootmediumfs)
		# XXX: 不完全: editToMatch
		pc = @point.to_s

		# mkdir -p /etc /lib/modueles /proc /sys /VIVER /mnt
		mkmp(pc + "/etc")
		mkmp(pc + "/lib")
		mkmp(pc + "/lib/modules")
		mkmp(pc + "/proc")
		mkmp(pc + "/sys")
		mkmp(pc + "/VIVER")
		mkmp(pc + "/mnt")


		# /devを作成
		mkmp(pc + "/dev")
		mkmp(pc + "/dev/mapper")

		# crw------- root:tty
		# crw-rw---- root:root
		chardev(pc + "/dev/console",         5,  1, 0600, 0, 5) rescue $log.warn $!
		chardev(pc + "/dev/mapper/control", 10, 63, 0660, 0, 0) rescue $log.warn $!

		fstab = "# Added by VIVER\n"

		# rootfs / proc / sys
		fstab << "viverroot / #{@fstype} #{@opt} 0 0\n"
		fstab << "proc /proc proc defaults 0 0\n"
		fstab << "sysfs /sys sysfs defaults 0 0\n"

		# disks -> /dev/*
		# disks -> fstab
		disks.each {|b|
			# まだdisks.cleanを実行する前
			b.mountedOnTrial? || next
			begin
				# crw-rw---- root:root
				blockdev(pc + "/dev/#{b.name}", b.major, b.minor, 0660, 0, 0)
				mkmp_soft(pc + "/mnt/#{b.name}")
				# TODO: fstab書き込み時のoptの設定
				opt = "noauto,users"
				fstab << "/dev/#{b.name} /mnt/#{b.name} #{b.probed_fstype} #{opt} 0 0\n"
			rescue
				$log.warn $!
			end
		}

=begin
		# XXX: allfs -> fstab: 未実装
		allfs.each {|f|
			f.mounted? || next
			fstab << "#{chrootPath(f.dev)} #{chrootPath(f.point)} #{f.fstype} #{f.opt} 0 0"
		}
=end

		# fstab
		File.open(pc + "/etc/fstab", "w") {|w|
			w << fstab
		} rescue $log.warn $!

		# network -> /etc/resolv.conf
		if File.file?(@initrdfs.resolvconf)
			copy_soft(@initrdfs.resolvconf, pc + "/etc/resolv.conf", 0644)
		end

		# XXX: 未実装: RUNESとのインターフェース
		# $param -> /etc/RUNES/interface/VIVER/parameters
		#
		#net, route = network.getInfo
		#

		# XXX: 暫定: パラメータの書き出し
		begin
			File.open(pc + "/etc/VIVER.param", "w") {|file|
				file << "#!/bin/sh\n"
				if bootmediumfs.mounted?
					relative_image = bootmediumfs.getImagePath.to_s.squeeze("/").split("/")[2..-1].join("/") 
					file << "viver_image_path=\"/#{relative_image}\"\n"
				end
			}
		rescue
			$log.warn $!
		end
	end


	def do_switchroot
		initbridge = @point.to_s + INITBRIDGE_RELATIVE

		dosh = ""
		if $debug.key?("switch")
			dosh = "/bin/sh"
		end

		dorc = ""
		rc_full = @point.to_s + VIVERRC_RELATIVE
		if File.executable?(rc_full)
			args = "/etc/RUNES/runes /etc/RUNES/roles /etc/RUNES/interface _all "
			# FIXME: ここはclass VIVERRCを作るべきか
			if $bootfrom == "network"
				args << "_network "
			else
				args << "_disk "
			end
			optional = $param.getValue("role", "").split(",")
			args << optional.join(" ")
			dorc = "#{VIVERRC_RELATIVE} #{args}"
		end


		initbin = $param.getValue("init", "/sbin/init")

		initopt = ""
		initopt = "5" if $param.set?("5")
		initopt = "4" if $param.set?("4")
		initopt = "3" if $param.set?("3")
		initopt = "2" if $param.set?("2")
		initopt = "1" if $param.set?("1")


		File.open(initbridge, "w") {|bridge|
			bridge << <<EOF
#!/bin/sh
/bin/cat /proc/mounts > /etc/mtab
#{dosh}
#{dorc}
exec #{initbin} #{initopt}
EOF
		}
		File.chmod(0700, initbridge)

		# ログをフラッシュ
		$log.flush

		@initrdfs.exec_switch_root(@point, INITBRIDGE_RELATIVE)
		# 成功したら帰ってこない
	end

end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
