# -*-Shell-script-*-

# colors
RESET="[R"
CLEAR="c"
NORMAL="[0;39m"
RED="[1;31m"
GREEN="[1;32m"
YELLOW="[1;33m"
BLUE="[1;34m"
MAGENTA="[1;35m"
CYAN="[1;36m"
WHITE="[1;37m"


function gprintf() {
	local TEXT=$1
	[ "${1#*\\n}" ] && TEXT="$TEXT\n"
	printf -- "$RUNES_RUNE_NAME:\t$TEXT" "$@"
}

function gprintf_color() {
	local COLOR=$1
	local TEXT=$2
	shift 2
	gprintf "${COLOR}${TEXT}$YELLOW" "$@"
}

function gprintf_failure() {
	gprintf_color "$RED" "$@"
}

function gprintf_success() {
	gprintf_color "$GREEN" "$@"
}

function gprintf_info() {
	gprintf_color "$YELLOW" "$@"
}

# evalして使う
# $1=prefix  $2=namespace
function runes_cmdline() {
	local prefix
	local ns
	prefix=$1
	ns=$2

	local line
	local current_ns
	local ns_list
	line="$(cat /proc/cmdline)"
	current_ns="GLOBAL"
	nc_list=""
	local cmd
	local key
	local val
	for cmd in $line;do
		if [ "$(echo -n "$cmd" | tail --bytes=1)" = ":" ];then
			# 最後が: （名前空間指定）
			current_ns="$(echo -n "$cmd" | head -c -1)"
			[ -z "$current_ns" ] && current_ns="GLOBAL"
			ns_list="$ns_list $current_ns"
		else
			# 最後が:でない
			key=$(echo $cmd | cut -d '=' -f 1)
			val=$(echo $cmd | cut -d '=' -f 2)
			[ -z "$val" ] && val="_KEYONLY"
			eval $(echo ${prefix}nskeys_${current_ns}=\"$key=${val} \${${prefix}nskeys_${current_ns}}\")
		fi
	done

	for keyval in $(eval echo \${${prefix}nskeys_GLOBAL}) $(eval echo \${${prefix}nskeys_$ns});do
		echo $prefix$keyval
	done

	#for current_ns in $ns_list; do
	#	echo ""
	#	echo "Namespace $current_ns:"
	#	for keyval in $(eval echo \${${prefix}nskeys_${current_ns}});do
	#		key=$(echo $keyval | cut -d '=' -f 1)
	#		val=$(echo $keyval | cut -d '=' -f 2)
	#		echo "  $key = $val"
	#	done
	#done
}

# evalして使う
# $1=prefix  $2=type  type's args...
function runes_interface() {
	local prefix
	local type
	prefix="$1"
	type="$2"
	shift
	shift
	if [ "$type" == "LOCAL" ];then
		# localhost only
		local rune
		local command
		command="$2"
		rune="$1"
		shift
		shift
		local ret
		ret="$($RUNES_INTERFACE_DIR/$rune/interface $command "$@")"

		Newline=$'\n'
		ifsb="$IFS"
		IFS="${Newline}"
		for val in $ret;do
			echo $prefix$val
			#echo $val | sed -r "s/=(.*)$/=\"\\1\"/"
		done
		IFS="$ifsb"

	elif [ "$type" == "ALL" ];then
		echo "Not implemented"
		# All machines in the subnet
		# XXX: 未実装

	else
		echo "Not implemented"
		# Role specific
		# XXX: 未実装
	fi
}

