#include "argparser.h"
#include <cstring>
#include <iostream>
#include <algorithm>

namespace VFIELD {


// Log*は使えない


////
// Exception
//
ArgumentException::ArgumentException(const std::string& message) :
	// FIXME: このメッセージは適切でない
	std::runtime_error( std::string("invalid argument: ") + message ) {}

InsufficientArgumentException::InsufficientArgumentException(const std::string& arg) :
	ArgumentException( "\"" + arg + "\"" + " option requires an argument" ) {}

UnknownArgumentException:: UnknownArgumentException(const std::string& arg) :
	ArgumentException( "unrecognized option \"" + arg + "\"" ) {}

BadArgumentException::BadArgumentException(const std::string& message) :
	ArgumentException(message) {}


////
// ArgumentKey (base class)
//
ArgumentKey::ArgumentKey(const std::string& key, const std::string& comment) :
	m_key(key), m_comment(comment) {}
ArgumentKey::~ArgumentKey() {}

// fallback functions
void ArgumentKey::set(void)
	{ throw InsufficientArgumentException( m_key ); }
void ArgumentKey::set(const std::string& str)
	{ throw UnknownArgumentException( str ); }

void ArgumentKey::showUsage(void) const
{
	//  -opt           comment
	//      ^^^^^^^^^^^
	//        padding
	unsigned short padding = 2;
	if( m_key.length() < (ArgParser::USAGE_SPACE-2) ) {
		padding = ArgParser::USAGE_SPACE - m_key.length();
	}
	std::cout << "  -" << m_key
		  << std::string(padding, ' ')
		  << m_comment
		  << std::endl;
}


////
// ArgParser
//
namespace {
template <typename T>
struct PointerDeleter {
	void operator() (T* key) { delete key; }
};
}  // noname namespace
ArgParser::ArgParser() {}
ArgParser::~ArgParser()
{
	std::for_each(m_keys.begin(), m_keys.end(), PointerDeleter<ArgumentKey>() );
}


namespace {
struct RunEval {
	void operator() (ArgumentKey* key) { key->eval(); }
};
struct FindKey {
	FindKey(const std::string& find) : m_find(find) {}
	bool operator() (const ArgumentKey* key) { return key->getKey() == m_find; }
private:
	const std::string& m_find;
};
}  // noname namespace
void ArgParser::parse(int argc, char* argv[])
{
	int i = 1;
	while( i < argc ) {
		const char* current = argv[i];

		const char* next = NULL;
		if( i < (argc - 1) ) {
			next = argv[i+1];
		}

		if( current[0] != '-' ) {
			// - で始まっていないオプション
			throw UnknownArgumentException( current );
		}

		//FinderKey finder( &current[1] );
		//keys_type::const_iterator found = m_keys.find(&finder);
		keys_type::const_iterator found( std::find_if(m_keys.begin(), m_keys.end(), FindKey(&current[1])) );
		if( found == m_keys.end() ) {
			// 指定されたオプションはaddKey()されていない
			throw UnknownArgumentException( current );
		}

		if( next && next[0] != '-' ) {
			// 引数付きオプション
			// -opt data
			(*found)->set(next);
			i += 2;
		} else {
			// 単発のオプション
			// -opt
			(*found)->set();
			i++;
		}
	}

	std::for_each(m_keys.begin(), m_keys.end(), RunEval());
}


namespace {
struct eachShowUsage {
	void operator() (ArgumentKey* key) const
	{
		key->showUsage();
	}
};
}  // noname namespace
void ArgParser::showUsage(void) const
{
	std::for_each(m_keys.begin(), m_keys.end(), eachShowUsage());
}


}  // namespace VFIELD

