#ifndef VFIELD_REQUEST_H__
#define VFIELD_REQUEST_H__

#include "datarange.h"

namespace VFIELD {

////
// DataRequest
//
class DataRequest : public DataRange {  // copyable, shared buffer
public:
	DataRequest(char* buffer, pos_type start, pos_type end) :
		DataRange(start, end), m_buffer(buffer) {}
	DataRequest(char* buffer, const DataRange& position) :
		DataRange(position), m_buffer(buffer) {}
	~DataRequest() throw() {}
public:
	inline       char* buffer(void)        { return m_buffer; }	// スレッドセーフでは無い
	inline const char* buffer(void) const  { return m_buffer; }
private:
	char* m_buffer;
};


}  // namespace VFIELD

#endif /* request.h */
