#ifndef VFIELD_COMMANDER_H__
#define VFIELD_COMMANDER_H__

#include "node.h"
#include "datarange.h"
#include "locked_queue.h"
#include <list>
#include <boost/shared_ptr.hpp>

namespace VFIELD {

class NodeIdentity;
class DataRange;
class FindAckMapper;

class command_type {
public:
	typedef enum {
		RPCNotifyUp,
		ConnectSuccess,
		ConnectFailure,
		DownloadSuccess,
		DownloadFailure,
	} letter_type;

	command_type(letter_type lt, const NodeIdentity& nd, const DataRange& rg) :
		letter(lt), place_range(new DataRange(rg)), place_node(new NodeIdentity(nd)) {}

	command_type(letter_type lt, std::list<DataRange>::iterator ite) :
		letter(lt), place_progress_ite(ite) {}
public:
	const letter_type letter;
	const NodeIdentity& node(void)  { return *place_node;  }
	const DataRange&    range(void) { return *place_range; }
	std::list<DataRange>::iterator progress_ite(void) { return place_progress_ite; }
private:
	boost::shared_ptr< DataRange >		place_range;
	boost::shared_ptr< NodeIdentity >	place_node;
	std::list<DataRange>::iterator		place_progress_ite;
};


class EngineCommander : private boost::noncopyable {
public:
	typedef LockedQueue<command_type>	queue_type;
	typedef queue_type::value_ptr		value_ptr;
public:
	EngineCommander() {}
	~EngineCommander() {}
public:
	void rpcNotifyUp(const NodeIdentity& node, const DataRange& range)
		{ m_queue.push( command_type(command_type::RPCNotifyUp, node, range) );	}

	void connectSuccess(const NodeIdentity& node, const DataRange& range)
		{ m_queue.push( command_type(command_type::ConnectSuccess, node, range) );	}

	void connectFailure(const NodeIdentity& node, const DataRange& range)
		{ m_queue.push( command_type(command_type::ConnectFailure, node, range) );	}

	void downloadSuccess(std::list<DataRange>::iterator ite)
		{ m_queue.push( command_type(command_type::DownloadSuccess, ite) );		}

	void downloadFailure(std::list<DataRange>::iterator ite)
		{ m_queue.push( command_type(command_type::DownloadFailure, ite) );		}

public:
	value_ptr blocked_pop(void) { return m_queue.blocked_pop(); }
	value_ptr timed_pop(const boost::xtime& xt) { return m_queue.timed_pop(xt); }
private:
	queue_type m_queue;
};


}  // namespace VFIELD

#endif /* commander.h */
