#ifndef VFIELD_SEARCH_CONTROLLER_H__
#define VFIELD_SEARCH_CONTROLLER_H__

#include <vector>
#include <boost/utility.hpp>
#include <boost/scoped_ptr.hpp>

namespace VFIELD {


class StreamManager;
class RPCClient;
class VTable;
class ThreadPool;
class DataRange;
class BufferedRequest;
class NodeIdentity;
class SearchControllerIMPL;
class SearchController : private boost::noncopyable {
public:
	SearchController(StreamManager& smgr,
			RPCClient& rpcc,
			VTable& vtable,
			ThreadPool& threadpool );
	~SearchController();
public:
	void submitRequests(std::vector<BufferedRequest>& requests);
	void submitRequest(BufferedRequest& request);
public:
	void rpcNotifyUp(const NodeIdentity& node, const DataRange& range);
private:
	boost::scoped_ptr<SearchControllerIMPL> impl;
};


}  // namespace VFIELD

#endif /* controller.h */
