#ifndef VFIELD_VTABLE_H__
#define VFIELD_VTABLE_H__

#include "node.h"
#include "datarange.h"
#include "rw_lock.h"
#include "exception.h"
#include <netinet/in.h>
#include <vector>
#include <deque>
#include <boost/scoped_ptr.hpp>

namespace VFIELD {


////
// VTable
//
// findとcalcDuplex以外の処理は長くブロックする可能性があるので、ThreadPoolを使うこと
class RPCClient;
class DuplexRange;
class VTableEach;
class VTableIMPL;
class StreamManager;
class AutoSock;
class StrippedNodeIdentity;
class VTable {
friend class VTableEach;
public:
	VTable(RPCClient& rpcc);
	~VTable();
public:
	typedef std::vector<DuplexRange> duplex_type;		// not sorted
	void calcDuplex(pos_type image_size, duplex_type& result) const;
public:
	void strippedNodeDownDetect(const StrippedNodeIdentity& down_node);
public:  // 応答処理
	void rpcNotifyUp(const NodeIdentity& up_node, const DataRange& up_range);
	void rpcNotifyDown(const NodeIdentity& down_node, StreamManager& smgr);
	void rpcPing(const NodeIdentity& up_node);
public:
	void setImageSize(pos_type size);
	void streamJoin(AutoSock& asock, uint16_t image_id, uint64_t image_size);
public:
	void changeRandomizeSeed(void);
public:
	boost::scoped_ptr<VTableIMPL> impl;
private:
	VTable();
};



class DuplexRange : public DataRange {
public:
	typedef unsigned short duplex_type;
	DuplexRange(pos_type start, pos_type end, duplex_type duplex);
	~DuplexRange() throw();
public:
	unsigned short duplex(void) const { return m_duplex; }
friend std::ostream& operator << (std::ostream& stream, const DuplexRange& rhl)
	{ return stream << rhl.m_duplex << ": " << static_cast<DataRange>(rhl); }
private:
	duplex_type m_duplex;
};


}  // namespace VFIELD

#endif /* vtable.h */
