require "log"


class DiskManager

	def idePSMS(name)
		if name =~ /^hda/
			return ["primary", "master"]
		elsif name =~ /^hdb/
			return ["primary", "slave"]
		elsif name =~ /^hdc/
			return ["secondary", "master"]
		elsif name =~ /^hdd/
			return ["secondary", "slave"]
		else
			return []
		end
	end
	private :idePSMS


	def guessPartition(disk_name, disk_size, partition_name, partition_size, removable)
		type = Array.new

		if disk_size < 40 * 1000 * 1000 * 1000 / 512
			# sizeは512バイト単位
			# ディスク自体のサイズが40GB(HDD容量換算)より小さい
			type.push("flash")
		else
			type.push("hdd")
		end

		if partition_size <= 2
			# パーティションのサイズが２セクタ以下
			type.push("extend_partition")
		else
			type.push("partition")
		end

		if removable
			type.push("external")
		else
			type.push("internal")
		end

		if disk_name =~ /^hd/
			type.push("ide")
			type.push( idePSMS(disk_name) )
		end

		return type
	end
	private :guessPartition


	def guessDisk(name, size, removable)
		type = Array.new

		if name =~ /^md[0-9]{1,3}/
			type.push("raid")
			type.push("md")
		elsif name =~ /^dm-[0-9]{1,3}/
			type.push("raid")
			type.push("dm")
		elsif name =~ /^sr[0-9]{1,3}/ || name =~ /^hd[a-z]/
			type.push("optical")
			if size < 1024 * 1024 * 1024 / 512
				# サイズが1GB以下
				# TODO: type.push("cd")
				# こちらは不正確
				# 1GB以下しか焼いていないDVDもCDと判別される
			else
				type.push("dvd")
			end
		elsif name =~ /^st[0-9]{1,3}/
			type.push("tape")
		elsif name =~ /^sg[0-9]{1,3}/
			type.puhs("genericscsi")
		end

		if removable
			type.push("external")
		else
			type.push("internal")
		end

		if name =~ /^hd/
			type.push("ide")
			type.push( idePSMS(name) )
		end

		return type
	end
	private :guessDisk

end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
