require "fallback"
require "fs_ark"
require "fs_kmodule"
require "fs_initrd"
require "fs_proc_sys"
require "hardware"



$log.setFilterLevel(Logger::DEBUG0)


initrdfs = InitrdFS.new
begin
	initrdfs.mounted("./testpoint")
	initrdfs.mktree
	VFS.setInitrdFS(initrdfs)
	LoopFS.setInitrdFS(initrdfs)
rescue
	$log.warn $!
	exit
end


procfs = ProcFS.new
sysfs = SysFS.new
procfs.mount(initrdfs.mp_proc) rescue Fallback.sh() && retry
sysfs.mount(initrdfs.mp_sys) rescue Fallback.sh() && retry



arkfs = ArkFS.new
begin
	arkfs.mount(initrdfs.mp_ark)
	arkfs.mktree(initrdfs)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end


kmodule = KernelModuleFS.new(initrdfs)
begin
	kmodule.mount(arkfs, initrdfs.kmodule_image, initrdfs.mp_kmodule)
rescue
	Fallback.sh(Fallback::NOIGNORE) && retry
end


hardware = HardwareDetect.new(sysfs, kmodule, initrdfs.pcidb_file, initrdfs.usbids_file)
begin
	hardware.detect
	hardware.show
rescue
	$log.error $!
end

kmodule.umount rescue $log.warn $!
arkfs.umount   rescue $log.warn $!
procfs.umount  rescue $log.warn $!
sysfs.umount   rescue $log.warn $!
	

