#!/bin/sh

progname=${0#./}
system=`(uname -s) 2>/dev/null`

aclocal='aclocal'
aclocalo=
automake='automake'
autoconf='autoconf'

case ${system} in
  Linux)
    if ! which ${aclocal} >/dev/null >/dev/null 2>/dev/null; then
      aclocal='aclocal-1.8'
    fi
    if ! which ${automake} >/dev/null 2>/dev/null; then
      automake='automake-1.8'
    fi
    ;;
  FreeBSD)
    if ! which ${aclocal} >/dev/null 2>/dev/null; then
      aclocal='aclocal14'
    fi
    aclocalo='-I m4'
    if ! which ${automake} >/dev/null 2>/dev/null; then
      automake='automake14'
    fi
    if ! which ${autoconf} >/dev/null 2>/dev/null; then
      autoconf='autoconf213'
    fi
    ;;
esac

echo; echo; echo "${progname}: aclocal..."
${aclocal} ${aclocalo}
if test -f acinclude.m4.original; then
  mv --force acinclude.m4.original acinclude.m4
else
  rm --force acinclude.m4
fi

echo; echo; echo "${progname}: automake..."
${automake} --add-missing

echo; echo; echo "${progname}: autoconf..."
${autoconf}
