/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"
#include "kernel32.h"


static LRESULT WINAPI
w32combo_DefWindowProc (HWND   hWnd,
                        UINT   Msg,
                        WPARAM wParam,
                        LPARAM lParam)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!wd)
    return 0;
  switch (Msg)
    {
      case CB_GETEDITSEL:
        {
          gint st = -1, ed = -1;

          if ((wd->dwStyle & CBS_TYPEMASK) == CBS_DROPDOWNLIST)
            {
              GtkWidget *editable;

#if GTK_CHECK_VERSION(2,4,0)
              editable = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
              editable = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
              if (!gtk_editable_get_selection_bounds
                                        (GTK_EDITABLE (editable), &st, &ed))
                st = ed = -1;
            }
          if (wParam)
            *(LPDWORD)GINT_TO_POINTER (wParam) = st;
          if (lParam)
            *(LPDWORD)GINT_TO_POINTER (lParam) = ed;
          return MAKELRESULT (st, ed);
        }
      case CB_LIMITTEXT:
        if ((wd->dwStyle & CBS_TYPEMASK) != CBS_DROPDOWNLIST)
          {
            GtkWidget *entry;

#if GTK_CHECK_VERSION(2,4,0)
            entry = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
            entry = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            gtk_entry_set_max_length (GTK_ENTRY (entry),
                                                wParam > 0 ? wParam : 0xfffe);
          }
        return TRUE;
      case CB_SETEDITSEL:
        if ((wd->dwStyle & CBS_TYPEMASK) != CBS_DROPDOWNLIST)
          {
            GtkWidget *editable;

#if GTK_CHECK_VERSION(2,4,0)
            editable = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
            editable = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            gtk_editable_select_region (GTK_EDITABLE (editable),
                                                            wParam, lParam);
          }
        return TRUE;
#if GTK_CHECK_VERSION(2,4,0)
      case CB_DELETESTRING:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_remove (store, &iter);
              return w32combo_DefWindowProc (hWnd, CB_GETCOUNT, 0, 0);
            }
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_DELETESTRING:
        gtk_list_clear_items (GTK_LIST (GTK_COMBO (hWnd)->list),
                                                        wParam, wParam + 1);
        return w32combo_DefWindowProc (hWnd, CB_GETCOUNT, 0, 0);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_ADDSTRING:
        return w32combo_DefWindowProc (hWnd, CB_INSERTSTRING, -1, lParam);
      case CB_DIR:
        return CB_ERR;
#if GTK_CHECK_VERSION(2,4,0)
      case CB_GETCOUNT:
        {
          GtkTreeModel *model;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          return gtk_tree_model_iter_n_children (model, NULL);
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETCOUNT:
        {
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          lResult = g_list_length (glist);
          g_list_free (glist);
          return lResult;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
#if GTK_CHECK_VERSION(2,4,0)
      case CB_GETCURSEL:
        return gtk_combo_box_get_active (GTK_COMBO_BOX (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETCURSEL:
        {
          const gchar *text;
          gint i, length;
          GList *glist;

          text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (hWnd)->entry));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = 0; i < length; i++)
            if (g_strcmp (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                        (GTK_BIN (g_list_nth_data (glist, i))))), text) == 0)
              break;
          g_list_free (glist);
          return i < length ? i : CB_ERR;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETLBTEXT:
        {
          gchar *utf8str = NULL;
          LRESULT lResult = CB_ERR;
#if GTK_CHECK_VERSION(2,4,0)
          GtkTreeIter iter;
          GtkTreeModel *model;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
#else /* not GTK_CHECK_VERSION(2,4,0) */
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          utf8str = g_strdup (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
          g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          if (utf8str)
            {
              if (wd->widechar)
                {
                  gunichar2 *wc;

                  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                  lstrcpyW (GINT_TO_POINTER (lParam), wc);
                  lResult = lstrlenW (wc);
                  g_free (wc);
                }
              else
                {
                  gchar *mb;

                  mb = w32ldr_utf8_to_mb (utf8str);
                  g_strcpy (GINT_TO_POINTER (lParam), mb);
                  lResult = g_strlen (mb);
                  g_free (mb);
                }
              g_free (utf8str);
            }
          return lResult;
        }
      case CB_GETLBTEXTLEN:
        {
          gchar *utf8str = NULL;
          LRESULT lResult = CB_ERR;
#if GTK_CHECK_VERSION(2,4,0)
          GtkTreeIter iter;
          GtkTreeModel *model;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
#else /* not GTK_CHECK_VERSION(2,4,0) */
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          utf8str = g_strdup (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
          g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          if (utf8str)
            {
              if (wd->widechar)
                {
                  gunichar2 *wc;

                  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                  lResult = lstrlenW (wc);
                  g_free (wc);
                }
              else
                {
                  gchar *mb;

                  mb = w32ldr_utf8_to_mb (utf8str);
                  lResult = g_strlen (mb);
                  g_free (mb);
                }
              g_free (utf8str);
            }
          return lResult;
        }
#if GTK_CHECK_VERSION(2,4,0)
      case CB_INSERTSTRING:
        {
          gchar *utf8str;
          gint count, position;
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          count = w32combo_DefWindowProc (hWnd, CB_GETCOUNT, 0, 0);
          position = wParam < 0 || count < wParam ? count : wParam;
          gtk_list_store_insert (store, &iter, position);
          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          gtk_list_store_set (store, &iter, 0, utf8str, 1, 0, -1);
          g_free (utf8str);
          return position;
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_INSERTSTRING:
        {
          gchar *utf8str;
          GtkWidget *list_item;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          list_item = gtk_list_item_new_with_label (utf8str);
          g_free (utf8str);
          gtk_widget_show (list_item);
          gtk_container_add (GTK_CONTAINER (GTK_COMBO (hWnd)->list),
                                                                    list_item);
          return w32combo_DefWindowProc (hWnd, CB_GETCOUNT, 0, 0) - 1;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
#if GTK_CHECK_VERSION(2,4,0)
      case CB_RESETCONTENT:
        {
          GtkListStore *store;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          gtk_list_store_clear (store);
        }
        return CB_OKAY;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_RESETCONTENT:
        gtk_list_clear_items (GTK_LIST (GTK_COMBO (hWnd)->list), 0, G_MAXINT);
        return CB_OKAY;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
#if GTK_CHECK_VERSION(2,4,0)
      case CB_FINDSTRING:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_FINDSTRING:
        {
          gchar *utf8str;
          gint i, length;
          GList *glist;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = wParam + 1; i < length; i++)
            if (g_ascii_strncasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                            utf8str, g_strlen (utf8str)) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          for (i = 0; i <= wParam; i++)
            if (g_ascii_strncasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                            utf8str, g_strlen (utf8str)) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          g_list_free (glist);
          g_free (utf8str);
          return CB_ERR;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_SELECTSTRING:
        return w32combo_DefWindowProc (hWnd, CB_SETCURSEL,
            w32combo_DefWindowProc (hWnd, CB_FINDSTRING, wParam, lParam), 0);
#if GTK_CHECK_VERSION(2,4,0)
      case CB_SETCURSEL:
        gtk_combo_box_set_active (GTK_COMBO_BOX (hWnd), wParam);
        return wParam;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_SETCURSEL:
        {
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          if (glist)
            {
              gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (hWnd)->entry),
                            gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                                (GTK_BIN (g_list_nth_data (glist, wParam))))));
              g_list_free (glist);
            }
        }
        return wParam;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_SHOWDROPDOWN:
        return TRUE;
#if GTK_CHECK_VERSION(2,4,0)
      case CB_GETITEMDATA:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = CB_ERR;

          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 1, &lResult, -1);
          return lResult;
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETITEMDATA:
        {
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          lResult = GPOINTER_TO_INT (g_object_get_data
                    (G_OBJECT (g_list_nth_data (glist, wParam)), "user_data"));
          g_list_free (glist);
          return lResult;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
#if GTK_CHECK_VERSION(2,4,0)
      case CB_SETITEMDATA:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_combo_box_get_model
                                                    (GTK_COMBO_BOX (hWnd)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_set (store, &iter, 1, lParam, -1);
              return CB_OKAY;
            }
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_SETITEMDATA:
        {
          GList *glist;

          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          g_object_set_data (G_OBJECT (g_list_nth_data (glist, wParam)),
                                        "user_data", GINT_TO_POINTER (lParam));
          g_list_free (glist);
        }
        return CB_OKAY;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_GETDROPPEDCONTROLRECT:
        return CB_ERR;
      case CB_SETITEMHEIGHT:
        return CB_ERR;
      case CB_GETITEMHEIGHT:
        return CB_ERR;
      case CB_SETEXTENDEDUI:
        return CB_ERR;
      case CB_GETEXTENDEDUI:
        return FALSE;
      case CB_GETDROPPEDSTATE:
        return FALSE;
#if GTK_CHECK_VERSION(2,4,0)
      case CB_FINDSTRINGEXACT:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_combo_box_get_model (GTK_COMBO_BOX (hWnd));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return CB_ERR;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_FINDSTRINGEXACT:
        {
          gchar *utf8str;
          gint i, length;
          GList *glist;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          glist = gtk_container_get_children
                                    (GTK_CONTAINER (GTK_COMBO (hWnd)->list));
          length = g_list_length (glist);
          for (i = wParam + 1; i < length; i++)
            if (g_ascii_strcasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                                                utf8str) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          for (i = 0; i <= wParam; i++)
            if (g_ascii_strcasecmp (gtk_label_get_text (GTK_LABEL
                (gtk_bin_get_child (GTK_BIN (g_list_nth_data (glist, i))))),
                                                                utf8str) == 0)
              {
                g_list_free (glist);
                g_free (utf8str);
                return i;
              }
          g_list_free (glist);
          g_free (utf8str);
          return CB_ERR;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case CB_SETLOCALE:
        return CB_ERR;
      case CB_GETLOCALE:
        return CB_OKAY;
      case CB_GETTOPINDEX:
        return CB_OKAY;
      case CB_SETTOPINDEX:
        return CB_ERR;
      case CB_GETHORIZONTALEXTENT:
        return CB_OKAY;
      case CB_SETHORIZONTALEXTENT:
        return CB_ERR;
      case CB_GETDROPPEDWIDTH:
        return CB_OKAY;
      case CB_SETDROPPEDWIDTH:
        return CB_ERR;
      case CB_INITSTORAGE:
        return CB_ERR;
      case WM_GETTEXT:
        if ((wd->dwStyle & CBS_TYPEMASK) != CBS_DROPDOWNLIST)
          {
            const gchar *utf8str;
            GtkWidget *entry;

#if GTK_CHECK_VERSION(2,4,0)
            entry = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
            entry = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            utf8str = gtk_entry_get_text (GTK_ENTRY (entry));
            if (wParam > 0 && lParam && utf8str)
              {
                if (wd->widechar)
                  {
                    gunichar2 *wc;

                    wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                    lstrcpynW (GINT_TO_POINTER (lParam), wc, wParam);
                    g_free (wc);
                    return lstrlenW (GINT_TO_POINTER (lParam));
                  }
                else
                  {
                    gchar *mb;

                    mb = w32ldr_utf8_to_mb (utf8str);
                    g_strncpy (GINT_TO_POINTER (lParam), mb, wParam);
                    g_free (mb);
                    return g_strlen (GINT_TO_POINTER (lParam));
                  }
              }
          }
        return 0;
      case WM_GETTEXTLENGTH:
        if ((wd->dwStyle & CBS_TYPEMASK) != CBS_DROPDOWNLIST)
          {
            const gchar *utf8str;
            GtkWidget *entry;

#if GTK_CHECK_VERSION(2,4,0)
            entry = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
            entry = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            utf8str = gtk_entry_get_text (GTK_ENTRY (entry));
            if (utf8str)
              {
                LRESULT lResult;

                if (wd->widechar)
                  {
                    gunichar2 *wc;

                    wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                    lResult = lstrlenW (wc);
                    g_free (wc);
                  }
                else
                  {
                    gchar *mb;

                    mb = w32ldr_utf8_to_mb (utf8str);
                    lResult = g_strlen (mb);
                    g_free (mb);
                  }
                return lResult;
              }
          }
        return 0;
      case WM_SETTEXT:
        if ((wd->dwStyle & CBS_TYPEMASK) != CBS_DROPDOWNLIST)
          {
            gchar *utf8str;
            GtkWidget *entry;

            utf8str = wd->widechar
                            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1,
                                                            NULL, NULL, NULL)
                            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
#if GTK_CHECK_VERSION(2,4,0)
            entry = gtk_bin_get_child (GTK_BIN (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
            entry = GTK_COMBO (hWnd)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            gtk_entry_set_text (GTK_ENTRY (entry), utf8str);
            g_free (utf8str);
            return TRUE;
          }
        return CB_ERR;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


#if GTK_CHECK_VERSION(2,4,0)
/* ja:コンボボックスの選択が変わったとき */
static void
w32combo_combo_changed (GtkComboBox *widget,
                        gpointer     user_data)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_SELCHANGE), GPOINTER_TO_INT (widget));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_SELCHANGE), GPOINTER_TO_INT (widget));
}
#endif /* GTK_CHECK_VERSION(2,4,0) */


/* ja:エントリーの内容が変化したとき */
static void
w32combo_entry_changed (GtkEditable *editable,
                        GtkWidget   *widget)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    {
      SendMessageW (wd->hWndParent, WM_COMMAND,
            MAKEWPARAM (wd->wID, CBN_EDITCHANGE), GPOINTER_TO_INT (widget));
      SendMessageW (wd->hWndParent, WM_COMMAND,
            MAKEWPARAM (wd->wID, CBN_EDITUPDATE), GPOINTER_TO_INT (widget));
    }
  else
    {
      SendMessageA (wd->hWndParent, WM_COMMAND,
            MAKEWPARAM (wd->wID, CBN_EDITCHANGE), GPOINTER_TO_INT (widget));
      SendMessageA (wd->hWndParent, WM_COMMAND,
            MAKEWPARAM (wd->wID, CBN_EDITUPDATE), GPOINTER_TO_INT (widget));
    }
}


/* ja:フォーカス取得 */
static gboolean
w32combo_focus_in (GtkWidget     *focus,
                   GdkEventFocus *event,
                   GtkWidget     *widget)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_SETFOCUS), GPOINTER_TO_INT (widget));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_SETFOCUS), GPOINTER_TO_INT (widget));
  return FALSE;
}


/* ja:フォーカス喪失 */
static gboolean
w32combo_focus_out (GtkWidget     *focus,
                    GdkEventFocus *event,
                    GtkWidget     *widget)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_KILLFOCUS), GPOINTER_TO_INT (widget));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, CBN_KILLFOCUS), GPOINTER_TO_INT (widget));
  return FALSE;
}


GtkWidget *
w32ldr_control_create_combo (const gchar    *windowname,
                              const guint32   style,
                              const guint32   exstyle,
                              const gint      width,
                              const gint      height,
                              const guint16   id,
                              HWND            hWndParent,
                              HINSTANCE       hInstance,
                              const gboolean  widechar)
{
  GtkWidget *combo, *entry, *focus;
  W32LdrWindowData *wd;
  LPARAM lParam;
#if GTK_CHECK_VERSION(2,4,0)
  GtkCellRenderer *renderer;
  GtkListStore *store;

  store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
  combo = (style & CBS_TYPEMASK) == CBS_DROPDOWNLIST
            ? gtk_combo_box_new_with_model (GTK_TREE_MODEL (store))
            : gtk_combo_box_entry_new_with_model (GTK_TREE_MODEL (store), 0);
  g_object_unref (store);
  renderer = gtk_cell_renderer_text_new ();
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo), renderer, TRUE);
  gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (combo),
                                                    renderer, "text", 0, NULL);
  g_signal_connect (G_OBJECT (combo), "changed",
                                    G_CALLBACK (w32combo_combo_changed), NULL);
  if ((style & CBS_TYPEMASK) == CBS_DROPDOWNLIST)
    {
      entry = NULL;
      focus = combo;
    }
  else
    {
      entry = focus = gtk_bin_get_child (GTK_BIN (combo));
    }
#else /* not GTK_CHECK_VERSION(2,4,0) */
  combo = gtk_combo_new ();
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo)->entry),
                                (style & CBS_TYPEMASK) != CBS_DROPDOWNLIST);
  entry = focus = GTK_COMBO (combo)->entry;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  if (entry)
    g_signal_connect (G_OBJECT (entry), "changed",
                                G_CALLBACK (w32combo_entry_changed), combo);
  g_signal_connect (G_OBJECT (focus), "focus-in-event",
                                G_CALLBACK (w32combo_focus_in), combo);
  g_signal_connect (G_OBJECT (focus), "focus-out-event",
                                G_CALLBACK (w32combo_focus_out), combo);
  gtk_widget_add_events (focus, GDK_FOCUS_CHANGE_MASK);
  wd = g_malloc (sizeof (W32LdrWindowData));
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32combo_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = FALSE;
  wd->classname = g_strdup ("COMBOBOX");
  wd->focus = focus;
  wd->child = NULL;
  g_object_set_data (G_OBJECT (combo), "user_data", wd);
  /* ja:テキスト */
  lParam = widechar ? GPOINTER_TO_INT (w32ldr_atom_get_string_wc (windowname))
                    : GPOINTER_TO_INT (w32ldr_atom_get_string_mb (windowname));
  w32combo_DefWindowProc (combo, WM_SETTEXT, 0, lParam);
  g_free (GINT_TO_POINTER (lParam));
  return combo;
}
