/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32LVIEW_H__
#define __W32LVIEW_H__


#include "user32.h"


/* ja:リストビュー */
#define WC_LISTVIEWA "SysListView32"
#define WC_LISTVIEWW (w32ldr_tchar_to_wc("SysListView32"))
#ifdef UNICODE
# define WC_LISTVIEW WC_LISTVIEWW
#else /* not UNICODE */
# define WC_LISTVIEW WC_LISTVIEWA
#endif /* not UNICODE */
#define LVS_ICON                0x0000
#define LVS_REPORT              0x0001
#define LVS_SMALLICON           0x0002
#define LVS_LIST                0x0003
#define LVS_TYPEMASK            0x0003
#define LVS_SINGLESEL           0x0004
#define LVS_SHOWSELALWAYS       0x0008
#define LVS_SORTASCENDING       0x0010
#define LVS_SORTDESCENDING      0x0020
#define LVS_SHAREIMAGELISTS     0x0040
#define LVS_NOLABELWRAP         0x0080
#define LVS_AUTOARRANGE         0x0100
#define LVS_EDITLABELS          0x0200
#define LVS_OWNERDATA           0x1000
#define LVS_NOSCROLL            0x2000
#define LVS_TYPESTYLEMASK       0xfc00
#define LVS_ALIGNTOP            0x0000
#define LVS_ALIGNLEFT           0x0800
#define LVS_ALIGNMASK           0x0c00
#define LVS_OWNERDRAWFIXED      0x0400
#define LVS_NOCOLUMNHEADER      0x4000
#define LVS_NOSORTHEADER        0x8000
#define LVS_EX_GRIDLINES        0x0001
#define LVS_EX_SUBITEMIMAGES    0x0002
#define LVS_EX_CHECKBOXES       0x0004
#define LVS_EX_TRACKSELECT      0x0008
#define LVS_EX_HEADERDRAGDROP   0x0010
#define LVS_EX_FULLROWSELECT    0x0020
#define LVS_EX_ONECLICKACTIVATE 0x0040
#define LVS_EX_TWOCLICKACTIVATE 0x0080
#define LVS_EX_FLATSB           0x0100
#define LVS_EX_REGIONAL         0x0200
#define LVS_EX_INFOTIP          0x0400
#define LVS_EX_UNDERLINEHOT     0x0800
#define LVS_EX_UNDERLINECOLD    0x1000
#define LVS_EX_MULTIWORKAREAS   0x2000
#define LVS_EX_LABELTIP         0x4000
#define LVS_EX_BORDERSELECT     0x8000
#define LVS_EX_DOUBLEBUFFER     0x00010000
#define LVS_EX_HIDELABELS       0x00020000
#define LVS_EX_SINGLEROW        0x00040000
#define LVS_EX_SNAPTOGRID       0x00080000
#define LVS_EX_SIMPLESELECT     0x00100000
#define LVM_FIRST                    0x1000
#define LVM_GETBKCOLOR               (LVM_FIRST+0)
#define LVM_SETBKCOLOR               (LVM_FIRST+1)
#define LVM_GETIMAGELIST             (LVM_FIRST+2)
#define LVM_SETIMAGELIST             (LVM_FIRST+3)
#define LVM_GETITEMCOUNT             (LVM_FIRST+4)
#define LVM_GETITEMA                 (LVM_FIRST+5)
#define LVM_GETITEMW                 (LVM_FIRST+75)
#define LVM_SETITEMA                 (LVM_FIRST+6)
#define LVM_SETITEMW                 (LVM_FIRST+76)
#define LVM_INSERTITEMA              (LVM_FIRST+7)
#define LVM_INSERTITEMW              (LVM_FIRST+77)
#define LVM_DELETEITEM               (LVM_FIRST+8)
#define LVM_DELETEALLITEMS           (LVM_FIRST+9)
#define LVM_GETCALLBACKMASK          (LVM_FIRST+10)
#define LVM_SETCALLBACKMASK          (LVM_FIRST+11)
#define LVM_GETNEXTITEM              (LVM_FIRST+12)
#define LVM_FINDITEMA                (LVM_FIRST+13)
#define LVM_FINDITEMW                (LVM_FIRST+83)
#define LVM_GETITEMRECT              (LVM_FIRST+14)
#define LVM_SETITEMPOSITION          (LVM_FIRST+15)
#define LVM_GETITEMPOSITION          (LVM_FIRST+16)
#define LVM_GETSTRINGWIDTHA          (LVM_FIRST+17)
#define LVM_GETSTRINGWIDTHW          (LVM_FIRST+87)
#define LVM_HITTEST                  (LVM_FIRST+18)
#define LVM_ENSUREVISIBLE            (LVM_FIRST+19)
#define LVM_SCROLL                   (LVM_FIRST+20)
#define LVM_REDRAWITEMS              (LVM_FIRST+21)
#define LVM_ARRANGE                  (LVM_FIRST+22)
#define LVM_EDITLABELA               (LVM_FIRST+23)
#define LVM_EDITLABELW               (LVM_FIRST+118)
#define LVM_GETEDITCONTROL           (LVM_FIRST+24)
#define LVM_GETCOLUMNA               (LVM_FIRST+25)
#define LVM_GETCOLUMNW               (LVM_FIRST+95)
#define LVM_SETCOLUMNA               (LVM_FIRST+26)
#define LVM_SETCOLUMNW               (LVM_FIRST+96)
#define LVM_INSERTCOLUMNA            (LVM_FIRST+27)
#define LVM_INSERTCOLUMNW            (LVM_FIRST+97)
#define LVM_DELETECOLUMN             (LVM_FIRST+28)
#define LVM_GETCOLUMNWIDTH           (LVM_FIRST+29)
#define LVM_SETCOLUMNWIDTH           (LVM_FIRST+30)
#define LVM_GETHEADER                (LVM_FIRST+31)
#define LVM_CREATEDRAGIMAGE          (LVM_FIRST+33)
#define LVM_GETVIEWRECT              (LVM_FIRST+34)
#define LVM_GETTEXTCOLOR             (LVM_FIRST+35)
#define LVM_SETTEXTCOLOR             (LVM_FIRST+36)
#define LVM_GETTEXTBKCOLOR           (LVM_FIRST+37)
#define LVM_SETTEXTBKCOLOR           (LVM_FIRST+38)
#define LVM_GETTOPINDEX              (LVM_FIRST+39)
#define LVM_GETCOUNTPERPAGE          (LVM_FIRST+40)
#define LVM_GETORIGIN                (LVM_FIRST+41)
#define LVM_UPDATE                   (LVM_FIRST+42)
#define LVM_SETITEMSTATE             (LVM_FIRST+43)
#define LVM_GETITEMSTATE             (LVM_FIRST+44)
#define LVM_GETITEMTEXTA             (LVM_FIRST+45)
#define LVM_GETITEMTEXTW             (LVM_FIRST+115)
#define LVM_SETITEMTEXTA             (LVM_FIRST+46)
#define LVM_SETITEMTEXTW             (LVM_FIRST+116)
#define LVM_SETITEMCOUNT             (LVM_FIRST+47)
#define LVM_SORTITEMS                (LVM_FIRST+48)
#define LVM_SETITEMPOSITION32        (LVM_FIRST+49)
#define LVM_GETSELECTEDCOUNT         (LVM_FIRST+50)
#define LVM_GETITEMSPACING           (LVM_FIRST+51)
#define LVM_GETISEARCHSTRINGA        (LVM_FIRST+52)
#define LVM_GETISEARCHSTRINGW        (LVM_FIRST+117)
#define LVM_SETICONSPACING           (LVM_FIRST+53)
#define LVM_SETEXTENDEDLISTVIEWSTYLE (LVM_FIRST+54)
#define LVM_GETEXTENDEDLISTVIEWSTYLE (LVM_FIRST+55)
#define LVM_GETSUBITEMRECT           (LVM_FIRST+56)
#define LVM_SUBITEMHITTEST           (LVM_FIRST+57)
#define LVM_SETCOLUMNORDERARRAY      (LVM_FIRST+58)
#define LVM_GETCOLUMNORDERARRAY      (LVM_FIRST+59)
#define LVM_SETHOTITEM               (LVM_FIRST+60)
#define LVM_GETHOTITEM               (LVM_FIRST+61)
#define LVM_SETHOTCURSOR             (LVM_FIRST+62)
#define LVM_GETHOTCURSOR             (LVM_FIRST+63)
#define LVM_APPROXIMATEVIEWRECT      (LVM_FIRST+64)
#define LVM_SETWORKAREAS             (LVM_FIRST+65)
#define LVM_GETSELECTIONMARK         (LVM_FIRST+66)
#define LVM_SETSELECTIONMARK         (LVM_FIRST+67)
#define LVM_SETBKIMAGEA              (LVM_FIRST+68)
#define LVM_SETBKIMAGEW              (LVM_FIRST+138)
#define LVM_GETBKIMAGEA              (LVM_FIRST+69)
#define LVM_GETBKIMAGEW              (LVM_FIRST+139)
#define LVM_GETWORKAREAS             (LVM_FIRST+70)
#define LVM_SETHOVERTIME             (LVM_FIRST+71)
#define LVM_GETHOVERTIME             (LVM_FIRST+72)
#define LVM_GETNUMBEROFWORKAREAS     (LVM_FIRST+73)
#define LVM_SETTOOLTIPS              (LVM_FIRST+74)
#define LVM_GETTOOLTIPS              (LVM_FIRST+78)
#define LVM_GETUNICODEFORMAT         CCM_GETUNICODEFORMAT
#define LVM_SETUNICODEFORMAT         CCM_SETUNICODEFORMAT
#define LVM_SETSELECTEDCOLUMN        (LVM_FIRST+140)
#define LVM_SETTILEWIDTH             (LVM_FIRST+141)
#define LVM_SETVIEW                  (LVM_FIRST+142)
#define LVM_GETVIEW                  (LVM_FIRST+143)
#define LVM_INSERTGROUP              (LVM_FIRST+145)
#define LVM_SETGROUPINFO             (LVM_FIRST+147)
#define LVM_GETGROUPINFO             (LVM_FIRST+149)
#define LVM_REMOVEGROUP              (LVM_FIRST+150)
#define LVM_MOVEGROUP                (LVM_FIRST+151)
#define LVM_MOVEITEMTOGROUP          (LVM_FIRST+154)
#define LVM_SETGROUPMETRICS          (LVM_FIRST+155)
#define LVM_GETGROUPMETRICS          (LVM_FIRST+156)
#define LVM_ENABLEGROUPVIEW          (LVM_FIRST+157)
#define LVM_SORTGROUPS               (LVM_FIRST+158)
#define LVM_INSERTGROUPSORTED        (LVM_FIRST+159)
#define LVM_REMOVEALLGROUPS          (LVM_FIRST+160)
#define LVM_HASGROUP                 (LVM_FIRST+161)
#define LVM_SETTILEVIEWINFO          (LVM_FIRST+162)
#define LVM_GETTILEVIEWINFO          (LVM_FIRST+163)
#define LVM_SETTILEINFO              (LVM_FIRST+164)
#define LVM_GETTILEINFO              (LVM_FIRST+165)
#define LVM_SETINSERTMARK            (LVM_FIRST+166)
#define LVM_GETINSERTMARK            (LVM_FIRST+167)
#define LVM_INSERTMARKHITTEST        (LVM_FIRST+168)
#define LVM_GETINSERTMARKRECT        (LVM_FIRST+169)
#define LVM_SETINSERTMARKCOLOR       (LVM_FIRST+170)
#define LVM_GETINSERTMARKCOLOR       (LVM_FIRST+171)
#define LVM_SETINFOTIP               (LVM_FIRST+173)
#define LVM_GETSELECTEDCOLUMN        (LVM_FIRST+174)
#define LVM_ISGROUPVIEWENABLED       (LVM_FIRST+175)
#define LVM_GETOUTLINECOLOR          (LVM_FIRST+176)
#define LVM_SETOUTLINECOLOR          (LVM_FIRST+177)
#define LVM_CANCELEDITLABEL          (LVM_FIRST+179)
#define LVM_MAPINDEXTOID             (LVM_FIRST+180)
#define LVM_MAPIDTOINDEX             (LVM_FIRST+181)
#ifdef UNICODE
# define LVM_GETITEM          LVM_GETITEMW
# define LVM_SETITEM          LVM_SETITEMW
# define LVM_INSERTITEM       LVM_INSERTITEMW
# define LVM_FINDITEM         LVM_FINDITEMW
# define LVM_GETSTRINGWIDTH   LVM_GETSTRINGWIDTHW
# define LVM_EDITLABEL        LVM_EDITLABELW
# define LVM_GETCOLUMN        LVM_GETCOLUMNW
# define LVM_SETCOLUMN        LVM_SETCOLUMNW
# define LVM_INSERTCOLUMN     LVM_INSERTCOLUMNW
# define LVM_GETITEMTEXT      LVM_GETITEMTEXTW
# define LVM_SETITEMTEXT      LVM_SETITEMTEXTW
# define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGW
# define LVM_SETBKIMAGE       LVM_SETBKIMAGEW
# define LVM_GETBKIMAGE       LVM_GETBKIMAGEW
#else /* not UNICODE */
# define LVM_GETITEM          LVM_GETITEMA
# define LVM_SETITEM          LVM_SETITEMA
# define LVM_INSERTITEM       LVM_INSERTITEMA
# define LVM_FINDITEM         LVM_FINDITEMA
# define LVM_GETSTRINGWIDTH   LVM_GETSTRINGWIDTHA
# define LVM_EDITLABEL        LVM_EDITLABELA
# define LVM_GETCOLUMN        LVM_GETCOLUMNA
# define LVM_SETCOLUMN        LVM_SETCOLUMNA
# define LVM_INSERTCOLUMN     LVM_INSERTCOLUMNA
# define LVM_GETITEMTEXT      LVM_GETITEMTEXTA
# define LVM_SETITEMTEXT      LVM_SETITEMTEXTA
# define LVM_GETISEARCHSTRING LVM_GETISEARCHSTRINGA
# define LVM_SETBKIMAGE       LVM_SETBKIMAGEA
# define LVM_GETBKIMAGE       LVM_GETBKIMAGEA
#endif /* not UNICODE */
#define LVN_FIRST           (-100)
#define LVN_LAST            (-199)
#define LVN_ITEMCHANGING    (LVN_FIRST-0)
#define LVN_ITEMCHANGED     (LVN_FIRST-1)
#define LVN_INSERTITEM      (LVN_FIRST-2)
#define LVN_DELETEITEM      (LVN_FIRST-3)
#define LVN_DELETEALLITEMS  (LVN_FIRST-4)
#define LVN_BEGINLABELEDITA (LVN_FIRST-5)
#define LVN_BEGINLABELEDITW (LVN_FIRST-75)
#define LVN_ENDLABELEDITA   (LVN_FIRST-6)
#define LVN_ENDLABELEDITW   (LVN_FIRST-76)
#define LVN_COLUMNCLICK     (LVN_FIRST-8)
#define LVN_BEGINDRAG       (LVN_FIRST-9)
#define LVN_BEGINRDRAG      (LVN_FIRST-11)
#define LVN_GETDISPINFOA    (LVN_FIRST-50)
#define LVN_GETDISPINFOW    (LVN_FIRST-77)
#define LVN_SETDISPINFOA    (LVN_FIRST-51)
#define LVN_SETDISPINFOW    (LVN_FIRST-78)
#define LVN_KEYDOWN         (LVN_FIRST-55)
#ifdef UNICODE
#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITW
#define LVN_ENDLABELEDIT   LVN_ENDLABELEDITW
#define LVN_GETDISPINFO    LVN_GETDISPINFOW
#define LVN_SETDISPINFO    LVN_SETDISPINFOW
#else /* not UNICODE */
#define LVN_BEGINLABELEDIT LVN_BEGINLABELEDITA
#define LVN_ENDLABELEDIT   LVN_ENDLABELEDITA
#define LVN_GETDISPINFO    LVN_GETDISPINFOA
#define LVN_SETDISPINFO    LVN_SETDISPINFOA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _NM_LISTVIEW
{
  NMHDR hdr;
  INT iItem;
  INT iSubItem;
  UINT uNewState;
  UINT uOldState;
  UINT uChanged;
  POINT ptAction;
  LPARAM lParam;
} NM_LISTVIEW, *PNM_LISTVIEW, *LPNM_LISTVIEW;
#include "poppack.h"

#define LVSIL_NORMAL      0
#define LVSIL_SMALL       1
#define LVSIL_STATE       2
#define LVIR_BOUNDS       0x0000
#define LVIR_ICON         0x0001
#define LVIR_LABEL        0x0002
#define LVIR_SELECTBOUNDS 0x0003
#define LVNI_FOCUSED      0x0001
#define LVNI_SELECTED     0x0002
#define LVNI_CUT          0x0004
#define LVNI_DROPHILITED  0x0008
#define LVNI_ALL          0x0000
#define LVNI_ABOVE        0x0100
#define LVNI_BELOW        0x0200
#define LVNI_TOLEFT       0x0400
#define LVNI_TORIGHT      0x0800

#define LVCF_FMT      0x0001
#define LVCF_WIDTH    0x0002
#define LVCF_TEXT     0x0004
#define LVCF_SUBITEM  0x0008
#define LVCFMT_LEFT   0x0000
#define LVCFMT_RIGHT  0x0001
#define LVCFMT_CENTER 0x0002
#include "pshpack1.h"
typedef struct _LV_COLUMNA
{
  UINT mask;
  INT fmt;
  INT cx;
  LPSTR pszText;
  INT cchTextMax;
  INT iSubItem;
  INT iImage;
  INT iOrder;
} LV_COLUMNA, *PLV_COLUMNA, *LPLV_COLUMNA;
typedef struct _LV_COLUMNW
{
  UINT mask;
  INT fmt;
  INT cx;
  LPWSTR pszText;
  INT cchTextMax;
  INT iSubItem;
  INT iImage;
  INT iOrder;
} LV_COLUMNW, *PLV_COLUMNW, *LPLV_COLUMNW;
#include "poppack.h"
#ifdef UNICODE
# define LV_COLUMN LV_COLUMNW
# define PLV_COLUMN PLV_COLUMNW
# define LPLV_COLUMN LPLV_COLUMNW
#else /* not UNICODE */
# define LV_COLUMN LV_COLUMNA
# define PLV_COLUMN PLV_COLUMNA
# define LPLV_COLUMN LPLV_COLUMNA
#endif /* not UNICODE */

#define LVFI_PARAM     0x0001
#define LVFI_STRING    0x0002
#define LVFI_PARTIAL   0x0008
#define LVFI_WRAP      0x0020
#define LVFI_NEARESTXY 0x0040
#include "pshpack1.h"
typedef struct _LV_FINDINFOA
{
  UINT flags;
  LPCSTR psz;
  LPARAM lParam;
  POINT pt;
  UINT vkDirection;
} LV_FINDINFOA, *PLV_FINDINFOA, *LPLV_FINDINFOA;
typedef struct _LV_FINDINFOW
{
  UINT flags;
  LPCWSTR psz;
  LPARAM lParam;
  POINT pt;
  UINT vkDirection;
} LV_FINDINFOW, *PLV_FINDINFOW, *LPLV_FINDINFOW;
#include "poppack.h"
#ifdef UNICODE
# define LV_FINDINFO LV_FINDINFOW
# define PLV_FINDINFO PLV_FINDINFOW
# define LPLV_FINDINFO LPLV_FINDINFOW
#else /* not UNICODE */
# define LV_FINDINFO LV_FINDINFOA
# define PLV_FINDINFO PLV_FINDINFOA
# define LPLV_FINDINFO LPLV_FINDINFOA
#endif /* not UNICODE */

#define LVHT_NOWHERE         0x0001
#define LVHT_ONITEMICON      0x0002
#define LVHT_ONITEMLABEL     0x0004
#define LVHT_ONITEMSTATEICON 0x0008
#define LVHT_ONITEM          (LVHT_ONITEMICON|LVHT_ONITEMLABEL|LVHT_ONITEMSTATEICON)
#define LVHT_ABOVE           0x0008
#define LVHT_BELOW           0x0010
#define LVHT_TORIGHT         0x0020
#define LVHT_TOLEFT          0x0040
#include "pshpack1.h"
typedef struct _LV_HITTESTINFO
{
  POINT pt;
  UINT flags;
  INT iItem;
  INT iSubItem;
} LV_HITTESTINFO, *PLV_HITTESTINFO, *LPLV_HITTESTINFO;
#include "poppack.h"

#define LVIF_TEXT           0x0001
#define LVIF_IMAGE          0x0002
#define LVIF_PARAM          0x0004
#define LVIF_STATE          0x0008
#define LVIF_DI_SETITEM     0x1000
#define LVIS_FOCUSED        0x0001
#define LVIS_SELECTED       0x0002
#define LVIS_DROPHILITED    0x0008
#define LVIS_OVERLAYMASK    0x0f00
#define LVIS_STATEIMAGEMASK 0xf000
#include "pshpack1.h"
typedef struct _LV_ITEMA
{
  UINT mask;
  INT iItem;
  INT iSubItem;
  UINT state;
  UINT stateMask;
  LPSTR pszText;
  INT cchTextMax;
  INT iImage;
  LPARAM lParam;
  INT iIndent;
  INT iGroupId;
  UINT cColumns;
  PUINT puColumns;
} LV_ITEMA, *PLV_ITEMA, *LPLV_ITEMA;
typedef struct _LV_ITEMW
{
  UINT mask;
  INT iItem;
  INT iSubItem;
  UINT state;
  UINT stateMask;
  LPWSTR pszText;
  INT cchTextMax;
  INT iImage;
  LPARAM lParam;
  INT iIndent;
  INT iGroupId;
  UINT cColumns;
  PUINT puColumns;
} LV_ITEMW, *PLV_ITEMW, *LPLV_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define LV_ITEM LV_ITEMW
# define PLV_ITEM PLV_ITEMW
# define LPLV_ITEM LPLV_ITEMW
#else /* not UNICODE */
# define LV_ITEM LV_ITEMA
# define PLV_ITEM PLV_ITEMA
# define LPLV_ITEM LPLV_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _LV_DISPINFOA
{
  NMHDR hdr;
  LV_ITEMA item;
} LV_DISPINFOA, *PLV_DISPINFOA, *LPLV_DISPINFOA;
typedef struct _LV_DISPINFOW
{
  NMHDR hdr;
  LV_ITEMW item;
} LV_DISPINFOW, *PLV_DISPINFOW, *LPLV_DISPINFOW;
#include "poppack.h"
#ifdef UNICODE
# define LV_DISPINFO LV_DISPINFOW
# define PLV_DISPINFO PLV_DISPINFOW
# define LPLV_DISPINFO LPLV_DISPINFOW
#else /* not UNICODE */
# define LV_DISPINFO LV_DISPINFOA
# define PLV_DISPINFO PLV_DISPINFOA
# define LPLV_DISPINFO LPLV_DISPINFOA
#endif /* not UNICODE */

#define ListView_Arrange(hWnd,code) SendMessage(hWnd,LVM_ARRANGE,code,0)
#define ListView_CreateDragImage(hWnd,iItem,lpptUpLeft) GINT_TO_POINTER(SendMessage(hWnd,LVM_CREATEDRAGIMAGE,iItem,GPOINTER_TO_INT(lpptUpLeft)))
#define ListView_DeleteAllItems(hWnd) SendMessage(hWnd,LVM_DELETEALLITEMS,0,0)
#define ListView_DeleteColumn(hWnd,iCol) SendMessage(hWnd,LVM_DELETECOLUMN,iCol,0)
#define ListView_DeleteItems(hWnd,LVM_DELETEITEM,iItem) SendMessage(hWnd,LVM_DELETEITEM,iItem,0)
#define ListView_EditLabelA(hWnd,iItem) SendMessageA(hWnd,LVM_EDITLABELA,iItem,0)
#define ListView_EditLabelW(hWnd,iItem) SendMessageW(hWnd,LVM_EDITLABELW,iItem,0)
#define ListView_EnsureVisible(hWnd,iItem,bPartialOK) SendMessage(hWnd,LVM_ENSUREVISIBLE,iItem,bPartialOK)
#define ListView_FindItemA(hWnd,iStart,plvfi) SendMessageA(hWnd,LVM_FINDITEMA,iStart,GPOINTER_TO_INT(plvfi))
#define ListView_FindItemW(hWnd,iStart,plvfi) SendMessageW(hWnd,LVM_FINDITEMW,iStart,GPOINTER_TO_INT(plvfi))
#define ListView_GetBkColor(hWnd) SendMessage(hWnd,LVM_GETBKCOLOR,0,0)
#define ListView_GetCallbackMask(hWnd) SendMessage(hWnd,LVM_GETCALLBACKMASK,0,0)
#define ListView_GetColumnA(hWnd,iCol,pcol) SendMessageA(hWnd,LVM_GETCOLUMNA,iCol,GPOINTER_TO_INT(pcol))
#define ListView_GetColumnW(hWnd,iCol,pcol) SendMessageW(hWnd,LVM_GETCOLUMNW,iCol,GPOINTER_TO_INT(pcol))
#define ListView_GetColumnWidth(hWnd,iCol) SendMessage(hWnd,LVM_GETCOLUMNWIDTH,iCol,0)
#define ListView_GetCountPerPage(hWnd) SendMessage(hWnd,LVM_GETCOUNTPERPAGE,0,0)
#define ListView_GetEditControl(hWnd) GINT_TO_POINTER(SendMessage(hWnd,LVM_GETEDITCONTROL,0,0))
#define ListView_GetImageList(hWnd,iImageList) GINT_TO_POINTER(SendMessage(hWnd,LVM_GETIMAGELIST,iImageList,0))
#define ListView_GetISearchStringA(hWnd,lpsz) SendMessageA(hWnd,LVM_GETISEARCHSTRINGA,0,GPOINTER_TO_INT(lpsz))
#define ListView_GetISearchStringW(hWnd,lpsz) SendMessageW(hWnd,LVM_GETISEARCHSTRINGW,0,GPOINTER_TO_INT(lpsz))
#define ListView_GetItemA(hWnd,pitem) SendMessageA(hWnd,LVM_GETITEMA,0,GPOINTER_TO_INT(pitem))
#define ListView_GetItemW(hWnd,pitem) SendMessageW(hWnd,LVM_GETITEMW,0,GPOINTER_TO_INT(pitem))
#define ListView_GetItemCount(hWnd) SendMessage(hWnd,LVM_GETITEMCOUNT,0,0)
#define ListView_GetItemPosition(hWnd,iItem,ppt) SendMessage(hWnd,LVM_GETITEMPOSITION,iItem,GPOINTER_TO_INT(pitem))
#define ListView_GetItemRect(hWnd,iItem,prc,code) SendMessage(hWnd,LVM_GETITEMRECT,iItem,GPOINTER_TO_INT((prc)?(((LPRECT)(prc))->left=(code),(prc)):NULL))
#define ListView_GetItemSpacing(hWnd,bSmall) SendMessage(hWnd,LVM_GETITEMSPACING,bSmall,0)
#define ListView_GetItemState(hWnd,iItem,mask) SendMessage(hWnd,LVM_GETITEMSTATE,iItem,mask)
#define ListView_GetItemTextA(hWnd,iItem,_iSubItem,_pszText,_cchTextMax) \
{\
  LV_ITEMA lvi; \
  lvi.iSubItem = _iSubItem; \
  lvi.pszText = _pszText; \
  lvi.cchTextMax = _cchTextMax; \
  SendMessageA (hWnd, LVM_GETITEMTEXTA, iItem, GPOINTER_TO_INT (&lvi)); \
}
#define ListView_GetItemTextW(hWnd,iItem,_iSubItem,_pszText,_cchTextMax) \
{ \
  LV_ITEMW lvi; \
  lvi.iSubItem = _iSubItem; \
  lvi.pszText = _pszText; \
  lvi.cchTextMax = _cchTextMax; \
  SendMessageW (hWnd, LVM_GETITEMTEXTW, iItem, GPOINTER_TO_INT (&lvi)); \
}
#define ListView_GetNextItem(hWnd,iStart,flags) SendMessage(hWnd,LVM_GETNEXTITEM,iStart,MAKELPARAM(flags,0))
#define ListView_GetOrigin(hWnd,lpptOrg) SendMessage(hWnd,LVM_GETORIGIN,0,GPOINTER_TO_INT(lpptOrg))
#define ListView_GetSelectedCount(hWnd) SendMessage(hWnd,LVM_GETSELECTEDCOUNT,0,0)
#define ListView_GetStringWidthA(hWnd,psz) SendMessageA(hWnd,LVM_GETSTRINGWIDTHA,0,GPOINTER_TO_INT(psz))
#define ListView_GetStringWidthW(hWnd,psz) SendMessageW(hWnd,LVM_GETSTRINGWIDTHW,0,GPOINTER_TO_INT(psz))
#define ListView_GetTextBkColor(hWnd) SendMessage(hWnd,LVM_GETTEXTBKCOLOR,0,0)
#define ListView_GetTextColor(hWnd) SendMessage(hWnd,LVM_GETTEXTCOLOR,0,0)
#define ListView_GetTopIndex(hWnd) SendMessage(hWnd,LVM_GETTOPINDEX,0,0)
#define ListView_GetViewRect(hWnd,prc) SendMessage(hWnd,LVM_GETVIEWRECT,0,GPOINTER_TO_INT(prc))
#define ListView_HitTest(hWnd,pinfo) SendMessage(hWnd,LVM_HITTEST,0,GPOINTER_TO_INT(pinfo))
#define ListView_InsertColumnA(hWnd,iCol,pcol) SendMessageA(hWnd,LVM_INSERTCOLUMNA,iCol,GPOINTER_TO_INT(pcol))
#define ListView_InsertColumnW(hWnd,iCol,pcol) SendMessageW(hWnd,LVM_INSERTCOLUMNW,iCol,GPOINTER_TO_INT(pcol))
#define ListView_InsertItemA(hWnd,pitem) SendMessageA(hWnd,LVM_INSERTITEMA,0,GPOINTER_TO_INT(pitem))
#define ListView_InsertItemW(hWnd,pitem) SendMessageW(hWnd,LVM_INSERTITEMW,0,GPOINTER_TO_INT(pitem))
#define ListView_RedrawItems(hWnd,iFirst,iLast) SendMessage(hWnd,LVM_REDRAWITEMS,iFirst,iLast)
#define ListView_Scroll(hWnd,dx,dy) SendMessage(hWnd,LVM_SCROLL,dx,dy)
#define ListView_SetBkColor(hWnd,clrBk) SendMessage(hWnd,LVM_SETBKCOLOR,0,clrBk)
#define ListView_SetCallbackMask(hWnd,mask) SendMessage(hWnd,LVM_SETCALLBACKMASK,mask,0)
#define ListView_SetColumnA(hWnd,iCol,pcol) SendMessageA(hWnd,LVM_SETCOLUMNA,iCol,GPOINTER_TO_INT(pcol))
#define ListView_SetColumnW(hWnd,iCol,pcol) SendMessageW(hWnd,LVM_SETCOLUMNW,iCol,GPOINTER_TO_INT(pcol))
#define ListView_SetColumnWidth(hWnd,iCol,cx) SendMessage(hWnd,LVM_SETCOLUMNWIDTH,iCol,MAKELPARAM(cx,0))
#define ListView_SetImageList(hWnd,iImageList,himl) GINT_TO_POINTER(SendMessage(hWnd,LVM_GETIMAGELIST,iImageList,GPOINTER_TO_INT(himl)))
#define ListView_SetItemA(hWnd,pitem) SendMessageA(hWnd,LVM_SETITEMA,0,GPOINTER_TO_INT(pitem))
#define ListView_SetItemW(hWnd,pitem) SendMessageW(hWnd,LVM_SETITEMW,0,GPOINTER_TO_INT(pitem))
#define ListView_SetItemCount(hWnd,cItems) SendMessage(hWnd,LVM_SETITEMCOUNT,cItems,0)
#define ListView_SetItemPosition(hWnd,iItem,x,y) SendMessage(hWnd,LVM_SETITEMPOSITION,iItem,MAKELPARAM(x,y))
#define ListView_SetItemPosition32(hWnd,iItem,_x,_y) \
{ \
  POINT ptNewPos; \
  ptNewPos.x = _x; \
  ptNewPos.y = _y; \
  SendMessage (hWnd, LVM_SETITEMPOSITION32, iItem, GPOINTER_TO_INT (&ptNewPos)); \
}
#define ListView_SetItemState(hWnd,iItem,_state,mask) \
{ \
  LV_ITEMA lvi; \
  lvi.state = _state; \
  lvi.stateMask = mask; \
  SendMessage (hWnd, LVM_SETITEMSTATE, iItem, GPOINTER_TO_INT (&lvi)); \
}
#define ListView_SetItemTextA(hWnd,iItem,_iSubItem,_pszText) \
{ \
  LV_ITEMA lvi; \
  lvi.iSubItem = _iSubItem; \
  lvi.pszText = _pszText; \
  SendMessageA (hWnd, LVM_SETITEMTEXTA, iItem, GPOINTER_TO_INT (&lvi)); \
}
#define ListView_SetItemTextW(hWnd,iItem,_iSubItem,_pszText) \
{ \
  LV_ITEMW lvi; \
  lvi.iSubItem = _iSubItem; \
  lvi.pszText = _pszText; \
  SendMessageW (hWnd, LVM_SETITEMTEXTW, iItem, GPOINTER_TO_INT (&lvi)); \
}
#define ListView_SetTextBkColor(hWnd,clrText) SendMessage(hWnd,LVM_SETTEXTBKCOLOR,0,clrText)
#define ListView_SetTextColor(hWnd,clrText) SendMessage(hWnd,LVM_SETTEXTCOLOR,0,clrText)
#define ListView_SortItems(hWnd,pfnCompare,lParamSort) SendMessage(hWnd,LVM_SORTITEMS,lParamSort,GPOINTER_TO_INT(pfnCompare))
#define ListView_Update(hWnd,iItem) SendMessage(hWnd,LVM_UPDATE,iItem,0)
#ifdef UNICODE
# define ListView_EditLabel ListView_EditLabelW
# define ListView_FindItem ListView_FindItemW
# define ListView_GetColumn ListView_GetColumnW
# define ListView_GetISearchString ListView_GetISearchStringW
# define ListView_GetItem ListView_GetItemW
# define ListView_GetItemText ListView_GetItemTextW
# define ListView_GetStringWidth ListView_GetStringWidthW
# define ListView_InsertColumn ListView_InsertColumnW
# define ListView_InsertItem ListView_InsertItemW
# define ListView_SetColumn ListView_SetColumnW
# define ListView_SetItem ListView_SetItemW
# define ListView_SetItemText ListView_SetItemTextW
#else /* not UNICODE */
# define ListView_EditLabel ListView_EditLabelA
# define ListView_FindItem ListView_FindItemA
# define ListView_GetColumn ListView_GetColumnA
# define ListView_GetISearchString ListView_GetISearchStringA
# define ListView_GetItem ListView_GetItemA
# define ListView_GetItemText ListView_GetItemTextA
# define ListView_GetStringWidth ListView_GetStringWidthA
# define ListView_InsertColumn ListView_InsertColumnA
# define ListView_InsertItem ListView_InsertItemA
# define ListView_SetColumn ListView_SetColumnA
# define ListView_SetItem ListView_SetItemA
# define ListView_SetItemText ListView_SetItemTextA
#endif /* not UNICODE */


#endif /* not __W32LVIEW_H__ */
