/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32TOOL_H__
#define __W32TOOL_H__


#include "user32.h"


/* ja:ツールバー */
#define TOOLBARCLASSNAMEA "ToolbarWindow32"
#define TOOLBARCLASSNAMEW (w32ldr_tchar_to_wc("ToolbarWindow32"))
#ifdef UNICODE
# define TOOLBARCLASSNAME TOOLBARCLASSNAMEW
#else /* not UNICODE */
# define TOOLBARCLASSNAME TOOLBARCLASSNAMEA
#endif /* not UNICODE */
#define TBSTYLE_TOOLTIPS 0x0100
#define TBSTYLE_WRAPABLE 0x0200
#define TBSTYLE_ALTDRAG  0x0400
#define TB_ENABLEBUTTON          (WM_USER+1)
#define TB_CHECKBUTTON           (WM_USER+2)
#define TB_PRESSBUTTON           (WM_USER+3)
#define TB_HIDEBUTTON            (WM_USER+4)
#define TB_INDETERMINATE         (WM_USER+5)
#define TB_MARKBUTTON            (WM_USER+6)
#define TB_ISBUTTONENABLED       (WM_USER+9)
#define TB_ISBUTTONCHECKED       (WM_USER+10)
#define TB_ISBUTTONPRESSED       (WM_USER+11)
#define TB_ISBUTTONHIDDEN        (WM_USER+12)
#define TB_ISBUTTONINDETERMINATE (WM_USER+13)
#define TB_ISBUTTONHIGHLIGHTED   (WM_USER+14)
#define TB_SETSTATE              (WM_USER+17)
#define TB_GETSTATE              (WM_USER+18)
#define TB_ADDBITMAP             (WM_USER+19)
#define TB_ADDBUTTONSA           (WM_USER+20)
#define TB_ADDBUTTONSW           (WM_USER+68)
#define TB_HITTEST               (WM_USER+69)
#define TB_INSERTBUTTONA         (WM_USER+21)
#define TB_INSERTBUTTONW         (WM_USER+67)
#define TB_DELETEBUTTON          (WM_USER+22)
#define TB_GETBUTTON             (WM_USER+23)
#define TB_BUTTONCOUNT           (WM_USER+24)
#define TB_COMMANDTOINDEX        (WM_USER+25)
#define TB_SAVERESTOREA          (WM_USER+26)
#define TB_SAVERESTOREW          (WM_USER+76)
#define TB_CUSTOMIZE             (WM_USER+27)
#define TB_ADDSTRINGA            (WM_USER+28)
#define TB_ADDSTRINGW            (WM_USER+77)
#define TB_GETITEMRECT           (WM_USER+29)
#define TB_BUTTONSTRUCTSIZE      (WM_USER+30)
#define TB_SETBUTTONSIZE         (WM_USER+31)
#define TB_SETBITMAPSIZE         (WM_USER+32)
#define TB_AUTOSIZE              (WM_USER+33)
#define TB_GETTOOLTIPS           (WM_USER+35)
#define TB_SETTOOLTIPS           (WM_USER+36)
#define TB_SETPARENT             (WM_USER+37)
#define TB_SETROWS               (WM_USER+39)
#define TB_GETROWS               (WM_USER+40)
#define TB_GETBITMAPFLAGS        (WM_USER+41)
#define TB_SETCMDID              (WM_USER+42)
#define TB_CHANGEBITMAP          (WM_USER+43)
#define TB_GETBITMAP             (WM_USER+44)
#define TB_GETBUTTONTEXTA        (WM_USER+45)
#define TB_GETBUTTONTEXTW        (WM_USER+75)
#define TB_REPLACEBITMAP         (WM_USER+46)
#define TB_SETINDENT             (WM_USER+47)
#define TB_SETIMAGELIST          (WM_USER+48)
#define TB_GETIMAGELIST          (WM_USER+49)
#define TB_LOADIMAGES            (WM_USER+50)
#define TB_GETRECT               (WM_USER+51)
#define TB_SETHOTIMAGELIST       (WM_USER+52)
#define TB_GETHOTIMAGELIST       (WM_USER+53)
#define TB_SETDISABLEDIMAGELIST  (WM_USER+54)
#define TB_GETDISABLEDIMAGELIST  (WM_USER+55)
#define TB_SETSTYLE              (WM_USER+56)
#define TB_GETSTYLE              (WM_USER+57)
#define TB_GETBUTTONSIZE         (WM_USER+58)
#define TB_SETBUTTONWIDTH        (WM_USER+59)
#define TB_SETMAXTEXTROWS        (WM_USER+60)
#define TB_GETTEXTROWS           (WM_USER+61)
#define TB_GETOBJECT             (WM_USER+62)
#define TB_GETBUTTONINFOW        (WM_USER+63)
#define TB_GETBUTTONINFOA        (WM_USER+65)
#define TB_SETBUTTONINFOW        (WM_USER+64)
#define TB_SETBUTTONINFOA        (WM_USER+66)
#define TB_SETDRAWTEXTFLAGS      (WM_USER+70)
#define TB_GETHOTITEM            (WM_USER+71)
#define TB_SETHOTITEM            (WM_USER+72)
#define TB_SETANCHORHIGHLIGHT    (WM_USER+73)
#define TB_GETANCHORHIGHLIGHT    (WM_USER+74)
#define TB_MAPACCELERATORA       (WM_USER+78)
#define TB_MAPACCELERATORW       (WM_USER+90)
#define TB_GETINSERTMARK         (WM_USER+79)
#define TB_SETINSERTMARK         (WM_USER+80)
#define TB_INSERTMARKHITTEST     (WM_USER+81)
#define TB_MOVEBUTTON            (WM_USER+82)
#define TB_GETMAXSIZE            (WM_USER+83)
#define TB_SETEXTENDEDSTYLE      (WM_USER+84)
#define TB_GETEXTENDEDSTYLE      (WM_USER+85)
#define TB_GETPADDING            (WM_USER+86)
#define TB_SETPADDING            (WM_USER+87)
#define TB_SETINSERTMARKCOLOR    (WM_USER+88)
#define TB_GETINSERTMARKCOLOR    (WM_USER+89)
#define TB_SETCOLORSCHEME        CCM_SETCOLORSCHEME
#define TB_GETCOLORSCHEME        CCM_GETCOLORSCHEME
#define TB_SETUNICODEFORMAT      CCM_SETUNICODEFORMAT
#define TB_GETUNICODEFORMAT      CCM_GETUNICODEFORMAT
#define TB_GETSTRINGW            (WM_USER+91)
#define TB_GETSTRINGA            (WM_USER+92)
#ifdef UNICODE
# define TB_GETSTRING      TB_GETSTRINGW
# define TB_ADDBUTTONS     TB_ADDBUTTONSW
# define TB_INSERTBUTTON   TB_INSERTBUTTONW
# define TB_SAVERESTORE    TB_SAVERESTOREW
# define TB_ADDSTRING      TB_ADDSTRINGW
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTW
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOW
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOW
# define TB_MAPACCELERATOR TB_MAPACCELERATORW
#else /* not UNICODE */
# define TB_GETSTRING      TB_GETSTRINGA
# define TB_ADDBUTTONS     TB_ADDBUTTONSA
# define TB_INSERTBUTTON   TB_INSERTBUTTONA
# define TB_SAVERESTORE    TB_SAVERESTOREA
# define TB_ADDSTRING      TB_ADDSTRINGA
# define TB_GETBUTTONTEXT  TB_GETBUTTONTEXTA
# define TB_GETBUTTONINFO  TB_GETBUTTONINFOA
# define TB_SETBUTTONINFO  TB_SETBUTTONINFOA
# define TB_MAPACCELERATOR TB_MAPACCELERATORA
#endif /* not UNICODE */

#define HINST_COMMCTRL ((HINSTANCE)GINT_TO_POINTER(-1))
#define IDB_STD_SMALL_COLOR  0
#define IDB_STD_LARGE_COLOR  1
#define IDB_VIEW_SMALL_COLOR 4
#define IDB_VIEW_LARGE_COLOR 5
#define STD_CUT        0
#define STD_COPY       1
#define STD_PASTE      2
#define STD_UNDO       3
#define STD_REDOW      4
#define STD_DELETE     5
#define STD_FILENEW    6
#define STD_FILEOPEN   7
#define STD_FILESAVE   8
#define STD_PRINTPRE   9
#define STD_PROPERTIES 10
#define STD_HELP       11
#define STD_FIND       12
#define STD_REPLACE    13
#define STD_PRINT      14
#define VIEW_LARGEICONS    0
#define VIEW_SMALLICONS    1
#define VIEW_LIST          2
#define VIEW_DETAILS       3
#define VIEW_SORTNAME      4
#define VIEW_SORTSIZE      5
#define VIEW_SORTDATE      6
#define VIEW_SORTTYPE      7
#define VIEW_PARENTFOLDER  8
#define VIEW_NETCONNECT    9
#define VIEW_NETDISCONNECT 10
#define VIEW_NEWFOLDER     11

#include "pshpack1.h"
typedef struct _TBADDBITMAP
{
  HINSTANCE hInst;
  UINT nID;
} TBADDBITMAP, *PTBADDBITMAP, *LPTBADDBITMAP;
#include "poppack.h"
typedef CONST TBADDBITMAP *PCTBADDBITMAP, *LPCTBADDBITMAP;

#define TBSTATE_CHECKED       0x01
#define TBSTATE_PRESSED       0x02
#define TBSTATE_ENABLED       0x04
#define TBSTATE_HIDDEN        0x08
#define TBSTATE_INDETERMINATE 0x10
#define TBSTATE_WRAP          0x20
#define TBSTYLE_BUTTON     0x00
#define TBSTYLE_SEP        0x01
#define TBSTYLE_CHECK      0x02
#define TBSTYLE_GROUP      0x04
#define TBSTYLE_CHECKGROUP (TBSTYLE_GROUP|TBSTYLE_CHECK)
#include "pshpack1.h"
typedef struct _TBBUTTON
{
  INT iBitmap;
  INT idCommand;
  BYTE fsState;
  BYTE fsStyle;
  BYTE bReserved[2];
  DWORD dwData;
  INT iString;
} TBBUTTON, *PTBBUTTON, *LPTBBUTTON;
#include "poppack.h"
typedef CONST TBBUTTON *PCTBBUTTON, *LPCTBBUTTON;

/* ja:ツールチップ */
#define TTN_FIRST        (-520)
#define TTN_LAST         (-549)
#define TTN_SHOW         (TTN_FIRST-1)
#define TTN_POP          (TTN_FIRST-2)
#define TTN_NEEDTEXTA    (TTN_FIRST-0)
#define TTN_NEEDTEXTW    (TTN_FIRST-10)
#define TTN_GETDISPINFOA TTN_NEEDTEXTA
#define TTN_GETDISPINFOW TTN_NEEDTEXTW
#ifdef UNICODE
# define TTN_NEEDTEXT TTN_NEEDTEXTW
# define TTN_GETDISPINFO TTN_GETDISPINFOW
#else /* not UNICODE */
# define TTN_NEEDTEXT TTN_GETDISPINFOA
# define TTN_GETDISPINFO TTN_GETDISPINFOA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TOOLTIPTEXTA
{
  NMHDR hdr;
  LPSTR lpszText;
  CHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTA, *PTOOLTIPTEXTA, *LPTOOLTIPTEXTA;
typedef struct _TOOLTIPTEXTW
{
  NMHDR hdr;
  LPWSTR lpszText;
  WCHAR szText[80];
  HINSTANCE hinst;
  UINT uFlags;
} TOOLTIPTEXTW, *PTOOLTIPTEXTW, *LPTOOLTIPTEXTW;
#include "poppack.h"
#ifdef UNICODE
# define TOOLTIPTEXT TOOLTIPTEXTW
# define PTOOLTIPTEXT PTOOLTIPTEXTW
# define LPTOOLTIPTEXT LPTOOLTIPTEXTW
#else /* not UNICODE */
# define TOOLTIPTEXT TOOLTIPTEXTA
# define PTOOLTIPTEXT PTOOLTIPTEXTA
# define LPTOOLTIPTEXT LPTOOLTIPTEXTA
#endif /* not UNICODE */


#endif /* not __W32TOOL_H__ */
