/*
    avicore
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GSRFMT_H__
#define __GSRFMT_H__


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:ファイル構造体                                                           *
*                                                                             *
******************************************************************************/
#define GSR_MAIN_SIGNATURE ('G'+('S'<<8)+('R'<<16))
#define GSR_STREAM_VIDEO   0
#define GSR_STREAM_AUDIO   1
#define GSR_IF_KEYFRAME    1

#define GMH_SIZE 12 /* en:GSR Main Header */
#define GSH_SIZE 28 /* en:GSR Stream Header */
#define GIE_SIZE 16 /* en:GSR Index Entry */


#ifdef USE_GCC


/* en:GSR Main Header */
typedef struct _GsrMainHeader
{
  guint32 signature __attribute__((packed));
  guint32 flags __attribute__((packed));
  guint32 streams __attribute__((packed));
} GsrMainHeader;
/* en:GSR Stream Header */
typedef struct _GsrStreamHeader
{
  guint32 type __attribute__((packed));
  guint32 micro_sec_per_frame __attribute__((packed));
  guint32 handler __attribute__((packed));
  guint32 index __attribute__((packed));
  guint64 offset __attribute__((packed));
  guint32 format __attribute__((packed));
} GsrStreamHeader;
/* en:GSR Index Entry */
typedef struct _GsrIndexEntry
{
  guint64 offset __attribute__((packed));
  guint32 length __attribute__((packed));
  guint32 flags __attribute__((packed));
} GsrIndexEntry;


#else /* not USE_GCC */


typedef struct { guint8 dummy[GMH_SIZE]; } GsrMainHeader;
typedef struct { guint8 dummy[GSH_SIZE]; } GsrStreamHeader;
typedef struct { guint8 dummy[GIE_SIZE]; } GsrIndexEntry;


#endif /* not USE_GCC */


/******************************************************************************
*                                                                             *
* ja:構造体マクロ                                                             *
*                                                                             *
******************************************************************************/
#define gmh_get_signature(gmh) GUINT32_FROM_LE(*(guint32 *)(gmh))
#define gmh_get_flags(gmh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gmh)+4))
#define gmh_get_streams(gmh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gmh)+8))
#define gmh_set_signature(gmh,signature)                                    \
                                (*(guint32 *)(gmh)=GUINT32_TO_LE(signature))
#define gmh_set_flags(gmh,flags)                                            \
                        (*(guint32 *)((guint8 *)(gmh)+4)=GUINT32_TO_LE(flags))
#define gmh_set_streams(gmh,streams)                                        \
                    (*(guint32 *)((guint8 *)(gmh)+8)=GUINT32_TO_LE(streams))


#define gsh_get_type(gsh) GUINT32_FROM_LE(*(guint32 *)(gsh))
#define gsh_get_micro_sec_per_frame(gsh)                                    \
                            GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gsh)+4))
#define gsh_get_handler(gsh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gsh)+8))
#define gsh_get_index(gsh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gsh)+12))
#define gsh_get_offset(gsh) GUINT64_FROM_LE(*(guint64 *)((guint8 *)(gsh)+16))
#define gsh_get_format(gsh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gsh)+24))
#define gsh_set_type(gsh,type) (*(guint32 *)(gsh)=GUINT32_TO_LE(type))
#define gsh_set_micro_sec_per_frame(gsh,micro_sec_per_frame)                \
        (*(guint32 *)((guint8 *)(gsh)+4)=GUINT32_TO_LE(micro_sec_per_frame))
#define gsh_set_handler(gsh,handler)                                        \
                    (*(guint32 *)((guint8 *)(gsh)+8)=GUINT32_TO_LE(handler))
#define gsh_set_index(gsh,index)                                            \
                        (*(guint32 *)((guint8 *)(gsh)+12)=GUINT32_TO_LE(index))
#define gsh_set_offset(gsh,offset)                                         \
                    (*(guint64 *)((guint8 *)(gsh)+16)=GUINT64_TO_LE(offset))
#define gsh_set_format(gsh,format)                                          \
                    (*(guint32 *)((guint8 *)(gsh)+24)=GUINT32_TO_LE(format))


#define gie_get_offset(gie) GUINT64_FROM_LE(*(guint64 *)(gie))
#define gie_get_length(gie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gie)+8))
#define gie_get_flags(gie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(gie)+12))
#define gie_set_offset(gie,offset) (*(guint64 *)(gie)=GUINT64_TO_LE(offset))
#define gie_set_length(gie,length)                                          \
                        (*(guint32 *)((guint8 *)(gie)+8)=GUINT32_TO_LE(length))
#define gie_set_flags(gie,flags)                                            \
                        (*(guint32 *)((guint8 *)(gie)+12)=GUINT32_TO_LE(flags))


G_END_DECLS


#endif /* __GSRFMT_H__ */
