/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "kernel32.h"
#include "image.h"
#include "user32.h"
#if GLIB_CHECK_VERSION(2,6,0)
# include <glib/gi18n.h>
#endif /* GLIB_CHECK_VERSION(2,6,0) */
#if GLIB_CHECK_VERSION(2,6,0)
# include <glib/gstdio.h>
#endif /* GLIB_CHECK_VERSION(2,6,0) */
#include <time.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */
#if defined (TM_IN_SYS_TIME) && defined (HAVE_SYS_TIME_H)
# include <sys/time.h>
#endif /* defined (TM_IN_SYS_TIME) && defined (HAVE_SYS_TIME_H) */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "misc/misc.h"
#include "misc/peimage.h"
#include "misc/profile.h"


#ifdef W32LDR_HEADER
#include "misc/fileio.h"

/* ja:一般 */
#define MAX_PATH 260
#define INVALID_HANDLE_VALUE (GINT_TO_POINTER(-1))
#define DONT_RESOLVE_DLL_REFERENCES   0x00000001
#define LOAD_LIBRARY_AS_DATAFILE      0x00000002
#define LOAD_WITH_ALTERED_SEARCH_PATH 0x00000008
typedef LPVOID LPCRITICAL_SECTION;
typedef INT CALLBACK (*FARPROC)();

/* ja:ウエイト */
#define WAIT_FAILED      0xffffffff
#define WAIT_OBJECT_0    0x00000000
#define WAIT_ABANDONED   0x00000080
#define WAIT_ABANDONED_0 WAIT_ABANDONED
#define WAIT_TIMEOUT     0x00000102
#define INFINITE         0xffffffff

/* ja:プロセス */
#include "pshpack1.h"
typedef struct _PROCESS_INFORMATION
{
  HANDLE hProcess;
  HANDLE hThread;
  DWORD dwProcessId;
  DWORD dwThreadId;
} PROCESS_INFORMATION, *PPROCESS_INFORMATION, *LPPROCESS_INFORMATION;
#include "poppack.h"
#define FOREGROUND_BLUE      0x0001
#define FOREGROUND_GREEN     0x0002
#define FOREGROUND_RED       0x0004
#define FOREGROUND_INTENSITY 0x0008
#define BACKGROUND_BLUE      0x0010
#define BACKGROUND_GREEN     0x0020
#define BACKGROUND_RED       0x0040
#define BACKGROUND_INTENSITY 0x0080
#define STARTF_USESHOWWINDOW    0x00000001
#define STARTF_USESIZE          0x00000002
#define STARTF_USEPOSITION      0x00000004
#define STARTF_USECOUNTCHARS    0x00000008
#define STARTF_USEFILLATTRIBUTE 0x00000010
#define STARTF_RUNFULLSCREEN    0x00000020
#define STARTF_FORCEONFEEDBACK  0x00000040
#define STARTF_FORCEOFFFEEDBACK 0x00000080
#define STARTF_USESTDHANDLES    0x00000100
#define STARTF_USEHOTKEY        0x00000200
#include "pshpack1.h"
typedef struct _STARTUPINFOA
{
  DWORD cb;
  LPSTR lpReserved;
  LPSTR lpDesktop;
  LPSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOA, *LPSTARTUPINFOA;
typedef struct _STARTUPINFOW
{
  DWORD cb;
  LPWSTR lpReserved;
  LPWSTR lpDesktop;
  LPWSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOW, *LPSTARTUPINFOW;
#include "poppack.h"
#ifdef UNICODE
# define STARTUPINFO STARTUPINFOW
# define LPSTARTUPINFO LPSTARTUPINFOW
#else /* not UNICODE */
# define STARTUPINFO STARTUPINFOA
# define LPSTARTUPINFO LPSTARTUPINFOA
#endif /* not UNICODE */

/* ja:スレッド */
#define THREAD_BASE_PRIORITY_LOWRT 15
#define THREAD_BASE_PRIORITY_MAX   2
#define THREAD_BASE_PRIORITY_MIN   (-2)
#define THREAD_BASE_PRIORITY_IDLE  (-15)
#define THREAD_PRIORITY_LOWEST        THREAD_BASE_PRIORITY_MIN
#define THREAD_PRIORITY_BELOW_NORMAL  (THREAD_PRIORITY_LOWEST+1)
#define THREAD_PRIORITY_NORMAL        0
#define THREAD_PRIORITY_HIGHEST       THREAD_BASE_PRIORITY_MAX
#define THREAD_PRIORITY_ABOVE_NORMAL  (THREAD_PRIORITY_HIGHEST-1)
#define THREAD_PRIORITY_ERROR_RETURN  (0x7fffffff)
#define THREAD_PRIORITY_TIME_CRITICAL THREAD_BASE_PRIORITY_LOWRT
#define THREAD_PRIORITY_IDLE          THREAD_BASE_PRIORITY_IDLE

/* ja:メモリ */
#define GMEM_FIXED          0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7f72
#define GMEM_INVALID_HANDLE 0x8000
#define GHND                (GMEM_MOVEABLE|GMEM_ZEROINIT)
#define GPTR                (GMEM_FIXED|GMEM_ZEROINIT)
#define LMEM_FIXED          GMEM_FIXED
#define LMEM_MOVEABLE       GMEM_MOVEABLE
#define LMEM_NOCOMPACT      GMEM_NOCOMPACT
#define LMEM_NODISCARD      GMEM_NODISCARD
#define LMEM_ZEROINIT       GMEM_ZEROINIT
#define LMEM_MODIFY         GMEM_MODIFY
#define LMEM_DISCARDABLE    GMEM_DISCARDABLE
#define LMEM_NOT_BANKED     GMEM_NOT_BANKED
#define LMEM_SHARE          GMEM_SHARE
#define LMEM_DDESHARE       GMEM_DDESHARE
#define LMEM_NOTIFY         GMEM_NOTIFY
#define LMEM_LOWER          GMEM_NOT_BANKED
#define LMEM_VALID_FLAGS    GMEM_VALID_FLAGS
#define LMEM_INVALID_HANDLE GMEM_INVALID_HANDLE
#define LHND                GHND
#define LPTR                GPTR
#define MEM_COMMIT      0x00001000
#define MEM_RESERVE     0x00002000
#define MEM_DECOMMIT    0x00004000
#define MEM_RELEASE     0x00008000
#define MEM_RESET       0x00080000
#define MEM_TOP_DOWN    0x00100000
#define MEM_WRITE_WATCH 0x00200000
#define MEM_PHYSICAL    0x00400000
typedef LPVOID HGLOBAL, HLOCAL;
#include "pshpack1.h"
typedef struct _MEMORY_BASIC_INFORMATION
{
  LPVOID BaseAddress;
  LPVOID AllocationBase;
  DWORD AllocationProtect;
  SIZE_T RegionSize;
  DWORD State;
  DWORD Protect;
  DWORD Type;
} MEMORY_BASIC_INFORMATION, *PMEMORY_BASIC_INFORMATION, *LPMEMORY_BASIC_INFORMATION;
typedef struct tagMEMORYSTATUS
{
  DWORD dwLength;
  DWORD dwMemoryLoad;
  SIZE_T dwTotalPhys;
  SIZE_T dwAvailPhys;
  SIZE_T dwTotalPageFile;
  SIZE_T dwAvailPageFile;
  SIZE_T dwTotalVirtual;
  SIZE_T dwAvailVirtual;
} MEMORYSTATUS, *PMEMORYSTATUS, *LPMEMORYSTATUS;
#include "poppack.h"

/* ja:ファイル */
#define STD_INPUT_HANDLE         (-10)
#define STD_OUTPUT_HANDLE        (-11)
#define STD_ERROR_HANDLE         (-12)
#define INVALID_SET_FILE_POINTER (-1)
#define FILE_TYPE_UNKNOWN        0x0000
#define FILE_TYPE_DISK           0x0001
#define FILE_TYPE_CHAR           0x0002
#define FILE_TYPE_PIPE           0x0003
#define FILE_TYPE_REMOTE         0x8000
#define GENERIC_READ             0x80000000
#define GENERIC_WRITE            0x40000000
#define FILE_SHARE_READ          1
#define FILE_SHARE_WRITE         2
#define FILE_SHARE_DELETE        4
#define CREATE_NEW               1
#define CREATE_ALWAYS            2
#define OPEN_EXISTING            3
#define OPEN_ALWAYS              4
#define TRUNCATE_EXISTING        5
#define FILE_BEGIN               0
#define FILE_CURRENT             1
#define FILE_END                 2
#include "pshpack1.h"
typedef struct _OVERLAPPED
{
  ULONG_PTR Internal;
  ULONG_PTR InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
} OVERLAPPED, *POVERLAPPED, *LPOVERLAPPED;
#include "poppack.h"
/* ja:ファイル(属性) */
#define FILE_ATTRIBUTE_READONLY            0x00000001
#define FILE_ATTRIBUTE_HIDDEN              0x00000002
#define FILE_ATTRIBUTE_SYSTEM              0x00000004
#define FILE_ATTRIBUTE_DIRECTORY           0x00000010
#define FILE_ATTRIBUTE_ARCHIVE             0x00000020
#define FILE_ATTRIBUTE_NORMAL              0x00000080
#define FILE_ATTRIBUTE_TEMPORARY           0x00000100
#define FILE_ATTRIBUTE_SPARSE_FILE         0x00000200
#define FILE_ATTRIBUTE_REPARSE_POINT       0x00000400
#define FILE_ATTRIBUTE_COMPRESSED          0x00000800
#define FILE_ATTRIBUTE_OFFLINE             0x00001000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED 0x00002000
#define FILE_ATTRIBUTE_ENCRYPTED           0x00004000
/* ja:ファイル(メモリマップ) */
#define PAGE_READONLY       0x00000002
#define PAGE_READWRITE      0x00000004
#define PAGE_WRITECOPY      0x00000008
#define SEC_IMAGE           0x01000000
#define SEC_RESERVE         0x04000000
#define SEC_COMMIT          0x08000000
#define SEC_NOCACHE         0x10000000
#define FILE_MAP_COPY       1
#define FILE_MAP_WRITE      2
#define FILE_MAP_READ       4
#define FILE_MAP_ALL_ACCESS 0x000f001f
/* ja:ファイル(Win16互換) */
#define HFILE_ERROR (GINT_TO_POINTER(-1))
typedef FileIO *HFILE;
/* ja:ファイル検索 */
#include "pshpack1.h"
typedef struct _WIN32_FIND_DATAA
{
  DWORD dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeHigh;
  DWORD nFileSizeLow;
  DWORD dwReserved0;
  DWORD dwReserved1;
  CHAR cFileName[MAX_PATH];
  CHAR cAlternateFileName[14];
} WIN32_FIND_DATAA, *PWIN32_FIND_DATAA, *LPWIN32_FIND_DATAA;
typedef struct _WIN32_FIND_DATAW
{
  DWORD dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeHigh;
  DWORD nFileSizeLow;
  DWORD dwReserved0;
  DWORD dwReserved1;
  WCHAR cFileName[MAX_PATH];
  WCHAR cAlternateFileName[14];
} WIN32_FIND_DATAW, *PWIN32_FIND_DATAW, *LPWIN32_FIND_DATAW;
#include "poppack.h"
#ifdef UNICODE
# define WIN32_FIND_DATA WIN32_FIND_DATAW
# define PWIN32_FIND_DATA PWIN32_FIND_DATAW
# define LPWIN32_FIND_DATA LPWIN32_FIND_DATAW
#else /* not UNICODE */
# define WIN32_FIND_DATA WIN32_FIND_DATAA
# define PWIN32_FIND_DATA PWIN32_FIND_DATAA
# define LPWIN32_FIND_DATA LPWIN32_FIND_DATAA
#endif /* not UNICODE */

/* ja:文字列比較 */
#define CSTR_LESS_THAN    1
#define CSTR_EQUAL        2
#define CSTR_GREATER_THAN 3
#define NORM_IGNORECASE     0x00001
#define NORM_IGNORENONSPACE 0x00002
#define NORM_IGNORESYMBOLS  0x00004
#define NORM_STRINGSORT     0x01000
#define NORM_IGNOREKANATYPE 0x10000
#define NORM_IGNOREWIDTH    0x20000

/* ja:言語/ロケール/コードページ */
#define MAX_DEFAULTCHAR 2
#define MAX_LEADBYTES   12
#define CP_ACP        0
#define CP_OEMCP      1
#define CP_MACCP      2
#define CP_THREAD_ACP 3
#define CP_SYMBOL     42
#define CP_UTF7       65000
#define CP_UTF8       65001
#define LCMAP_LOWERCASE 0x00000100
#define LCMAP_UPPERCASE 0x00000200
#define LCMAP_SORTKEY   0x00000400
#define LCMAP_BYTEREV   0x00000800
#define MAKELCID(l,s)        (MAKELONG(l,s))
#define MAKELANGID(p,s)      ((((WORD)(s))<<10)|(WORD)(p))
#define PRIMARYLANGID(l)     ((WORD)(l)&0x3ff)
#define SUBLANGID(l)         ((WORD)(l)>>10)
#define LANGIDFROMLCID(lcid) ((WORD)(lcid))
#define SORTIDFROMLCID(lcid) ((WORD)((((DWORD)(lcid))>>16)&0x0f))
#define LANG_NEUTRAL                0x00
#define LANG_AFRIKAANS              0x36
#define LANG_ALBANIAN               0x1c
#define LANG_ARABIC                 0x01
#define LANG_ARMENIAN               0x2b
#define LANG_ASSAMESE               0x4d
#define LANG_AZERI                  0x2c
#define LANG_BASQUE                 0x2d
#define LANG_BENGALI                0x45
#define LANG_BULGARIAN              0x02
#define LANG_BYELORUSSIAN           0x23
#define LANG_CATALAN                0x03
#define LANG_CHINESE                0x04
#define LANG_SERBO_CROATIAN         0x1a
#define LANG_CROATIAN               LANG_SERBO_CROATIAN
#define LANG_SERBIAN                LANG_SERBO_CROATIAN
#define LANG_CZECH                  0x05
#define LANG_DANISH                 0x06
#define LANG_DUTCH                  0x13
#define LANG_ENGLISH                0x09
#define LANG_ESTONIAN               0x25
#define LANG_FAEROESE               0x38
#define LANG_FARSI                  0x29
#define LANG_FINNISH                0x0b
#define LANG_FRENCH                 0x0c
#define LANG_GAELIC                 0x3c
#define LANG_GEORGIAN               0x37
#define LANG_GERMAN                 0x07
#define LANG_GREEK                  0x08
#define LANG_GUJARATI               0x47
#define LANG_HEBREW                 0x0d
#define LANG_HINDI                  0x39
#define LANG_HUNGARIAN              0x0e
#define LANG_ICELANDIC              0x0f
#define LANG_INDONESIAN             0x21
#define LANG_ITALIAN                0x10
#define LANG_JAPANESE               0x11
#define LANG_KANNADA                0x4b
#define LANG_KAZAKH                 0x3f
#define LANG_KONKANI                0x57
#define LANG_KOREAN                 0x12
#define LANG_LATVIAN                0x26
#define LANG_LITHUANIAN             0x27
#define LANG_MACEDONIAN             0x2f
#define LANG_MALAY                  0x3e
#define LANG_MALAYALAM              0x4c
#define LANG_MALTESE                0x3a
#define LANG_MAORI                  0x28
#define LANG_MARATHI                0x4e
#define LANG_NORWEGIAN              0x14
#define LANG_ORIYA                  0x48
#define LANG_POLISH                 0x15
#define LANG_PORTUGUESE             0x16
#define LANG_PUNJABI                0x46
#define LANG_RHAETO_ROMANCE         0x17
#define LANG_ROMANIAN               0x18
#define LANG_RUSSIAN                0x19
#define LANG_SAAMI                  0x3b
#define LANG_SANSKRIT               0x4f
#define LANG_SLOVAK                 0x1b
#define LANG_SLOVENIAN              0x24
#define LANG_SORBIAN                0x2e
#define LANG_SPANISH                0x0a
#define LANG_SUTU                   0x30
#define LANG_SWAHILI                0x41
#define LANG_SWEDISH                0x1d
#define LANG_TAMIL                  0x49
#define LANG_TATAR                  0x44
#define LANG_TELUGU                 0x4a
#define LANG_THAI                   0x1e
#define LANG_TSONGA                 0x31
#define LANG_TSWANA                 0x32
#define LANG_TURKISH                0x1f
#define LANG_UKRAINIAN              0x22
#define LANG_URDU                   0x20
#define LANG_UZBEK                  0x43
#define LANG_VENDA                  0x33
#define LANG_VIETNAMESE             0x2a
#define LANG_XHOSA                  0x34
#define LANG_ZULU                   0x35
#define LANG_ESPERANTO              0x8f
#define LANG_WALON                  0x90
#define LANG_CORNISH                0x91
#define LANG_WELSH                  0x92
#define LANG_BRETON                 0x93
#define SUBLANG_NEUTRAL                 0x00
#define SUBLANG_DEFAULT                 0x01
#define SUBLANG_SYS_DEFAULT             0x02
#define SUBLANG_ARABIC                  0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA     0x01
#define SUBLANG_ARABIC_IRAQ             0x02
#define SUBLANG_ARABIC_EGYPT            0x03
#define SUBLANG_ARABIC_LIBYA            0x04
#define SUBLANG_ARABIC_ALGERIA          0x05
#define SUBLANG_ARABIC_MOROCCO          0x06
#define SUBLANG_ARABIC_TUNISIA          0x07
#define SUBLANG_ARABIC_OMAN             0x08
#define SUBLANG_ARABIC_YEMEN            0x09
#define SUBLANG_ARABIC_SYRIA            0x0a
#define SUBLANG_ARABIC_JORDAN           0x0b
#define SUBLANG_ARABIC_LEBANON          0x0c
#define SUBLANG_ARABIC_KUWAIT           0x0d
#define SUBLANG_ARABIC_UAE              0x0e
#define SUBLANG_ARABIC_BAHRAIN          0x0f
#define SUBLANG_ARABIC_QATAR            0x10
#define SUBLANG_CHINESE_TRADITIONAL     0x01
#define SUBLANG_CHINESE_SIMPLIFIED      0x02
#define SUBLANG_CHINESE_HONGKONG        0x03
#define SUBLANG_CHINESE_SINGAPORE       0x04
#define SUBLANG_CHINESE_MACAU           0x05
#define SUBLANG_DUTCH                   0x01
#define SUBLANG_DUTCH_BELGIAN           0x02
#define SUBLANG_DUTCH_SURINAM           0x03
#define SUBLANG_ENGLISH_US              0x01
#define SUBLANG_ENGLISH_UK              0x02
#define SUBLANG_ENGLISH_AUS             0x03
#define SUBLANG_ENGLISH_CAN             0x04
#define SUBLANG_ENGLISH_NZ              0x05
#define SUBLANG_ENGLISH_EIRE            0x06
#define SUBLANG_ENGLISH_SAFRICA         0x07
#define SUBLANG_ENGLISH_JAMAICA         0x08
#define SUBLANG_ENGLISH_CARRIBEAN       0x09
#define SUBLANG_ENGLISH_BELIZE          0x0a
#define SUBLANG_ENGLISH_TRINIDAD        0x0b
#define SUBLANG_ENGLISH_ZIMBABWE        0x0c
#define SUBLANG_ENGLISH_PHILIPPINES     0x0d
#define SUBLANG_FRENCH                  0x01
#define SUBLANG_FRENCH_BELGIAN          0x02
#define SUBLANG_FRENCH_CANADIAN         0x03
#define SUBLANG_FRENCH_SWISS            0x04
#define SUBLANG_FRENCH_LUXEMBOURG       0x05
#define SUBLANG_FRENCH_MONACO           0x06
#define SUBLANG_GERMAN                  0x01
#define SUBLANG_GERMAN_SWISS            0x02
#define SUBLANG_GERMAN_AUSTRIAN         0x03
#define SUBLANG_GERMAN_LUXEMBOURG       0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN    0x05
#define SUBLANG_ITALIAN                 0x01
#define SUBLANG_ITALIAN_SWISS           0x02
#define SUBLANG_KOREAN                  0x01
#define SUBLANG_KOREAN_JOHAB            0x02
#define SUBLANG_NORWEGIAN_BOKMAL        0x01
#define SUBLANG_NORWEGIAN_NYNORSK       0x02
#define SUBLANG_PORTUGUESE              0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN    0x01
#define SUBLANG_SPANISH                 0x01
#define SUBLANG_SPANISH_MEXICAN         0x02
#define SUBLANG_SPANISH_MODERN          0x03
#define SUBLANG_SPANISH_GUATEMALA       0x04
#define SUBLANG_SPANISH_COSTARICA       0x05
#define SUBLANG_SPANISH_PANAMA          0x06
#define SUBLANG_SPANISH_DOMINICAN       0x07
#define SUBLANG_SPANISH_VENEZUELA       0x08
#define SUBLANG_SPANISH_COLOMBIA        0x09
#define SUBLANG_SPANISH_PERU            0x0a
#define SUBLANG_SPANISH_ARGENTINA       0x0b
#define SUBLANG_SPANISH_ECUADOR         0x0c
#define SUBLANG_SPANISH_CHILE           0x0d
#define SUBLANG_SPANISH_URUGUAY         0x0e
#define SUBLANG_SPANISH_PARAGUAY        0x0f
#define SUBLANG_SPANISH_BOLIVIA         0x10
#define SUBLANG_SPANISH_EL_SALVADOR     0x11
#define SUBLANG_SPANISH_HONDURAS        0x12
#define SUBLANG_SPANISH_NICARAGUA       0x13
#define SUBLANG_SPANISH_PUERTO_RICO     0x14
#define SUBLANG_ROMANIAN                0x01
#define SUBLANG_ROMANIAN_MOLDAVIA       0x02
#define SUBLANG_RUSSIAN                 0x01
#define SUBLANG_RUSSIAN_MOLDAVIA        0x02
#define SUBLANG_CROATIAN                0x01
#define SUBLANG_SERBIAN                 0x02
#define SUBLANG_SERBIAN_LATIN           0x03
#define SUBLANG_SWEDISH                 0x01
#define SUBLANG_SWEDISH_FINLAND         0x02
#define SUBLANG_LITHUANIAN              0x01
#define SUBLANG_LITHUANIAN_CLASSIC      0x02
#define SUBLANG_AZERI                   0x01
#define SUBLANG_AZERI_CYRILLIC          0x02
#define SUBLANG_GAELIC                  0x01
#define SUBLANG_GAELIC_SCOTTISH         0x02
#define SUBLANG_GAELIC_MANX             0x03
#define SUBLANG_MALAY                   0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM 0x02
#define SUBLANG_UZBEK                   0x01
#define SUBLANG_UZBEK_CYRILLIC          0x02
#define SUBLANG_URDU_PAKISTAN           0x01
typedef WORD LANGID;
typedef DWORD CALID;
typedef DWORD CALTYPE;
typedef DWORD LCID;
typedef DWORD LCTYPE;
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
typedef BOOL CALLBACK (*CALINFO_ENUMPROCW)(LPWSTR);
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);
#ifdef UNICODE
# define CALINFO_ENUMPROC CALINFO_ENUMPROCW
#else /* not UNICODE */
# define CALINFO_ENUMPROC CALINFO_ENUMPROCA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
} CPINFO, *LPCPINFO;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  CHAR CodePageName[MAX_PATH];
} CPINFOEXA, *LPCPINFOEXA;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  WCHAR CodePageName[MAX_PATH];
} CPINFOEXW, *LPCPINFOEXW;
#include "poppack.h"
#ifdef UNICODE
# define CPINFOEX CPINFOEXW
# define LPCPINFOEX LPCPINFOEXW
#else /* not UNICODE */
# define CPINFOEX CPINFOEXA
# define LPCPINFOEX LPCPINFOEXA
#endif /* not UNICODE */

/* ja:環境 */
#define VER_PLATFORM_WIN32s        0
#define VER_PLATFORM_WIN32_WINDOWS 1
#define VER_PLATFORM_WIN32_NT      2
#include "pshpack1.h"
typedef union _LARGE_INTEGER
{
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
  struct
  {
    DWORD LowPart;
    LONG  HighPart;
  };
  struct
  {
    DWORD LowPart;
    LONG  HighPart;
  } u;
#else /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  struct
  {
    LONG  HighPart;
    DWORD LowPart;
  };
  struct
  {
    LONG  HighPart;
    DWORD LowPart;
  } u;
#endif /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  LONGLONG QuadPart;
} LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
typedef union _ULARGE_INTEGER
{
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
  struct
  {
    DWORD LowPart;
    DWORD HighPart;
  };
  struct
  {
    DWORD LowPart;
    DWORD HighPart;
  } u;
#else /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  struct
  {
    DWORD HighPart;
    DWORD LowPart;
  };
  struct
  {
    DWORD HighPart;
    DWORD LowPart;
  } u;
#endif /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  ULONGLONG QuadPart;
} ULARGE_INTEGER, *PULARGE_INTEGER, *LPULARGE_INTEGER;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  CHAR szCSDVersion[128];
} OSVERSIONINFOA, *POSVERSIONINFOA, *LPOSVERSIONINFOA;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  WCHAR szCSDVersion[128];
} OSVERSIONINFOW, *POSVERSIONINFOW, *LPOSVERSIONINFOW;
#include "poppack.h"
#ifdef UNICODE
# define OSVERSIONINFO OSVERSIONINFOW
# define POSVERSIONINFO POSVERSIONINFOW
# define LPOSVERSIONINFO LPOSVERSIONINFOW
#else /* not UNICODE */
# define OSVERSIONINFO OSVERSIONINFOA
# define POSVERSIONINFO POSVERSIONINFOA
# define LPOSVERSIONINFO LPOSVERSIONINFOA
#endif /* not UNICODE */
/* dwProcessorType */
#define PROCESSOR_INTEL_386     386
#define PROCESSOR_INTEL_486     486
#define PROCESSOR_INTEL_PENTIUM 586
#include "pshpack1.h"
typedef struct _SYSTEM_INFO
{
  union {
    DWORD dwOemId;
    struct {
      WORD wProcessorArchitecture;
      WORD wReserved;
    } DUMMYSTRUCTNAME;
  } DUMMYUNIONNAME;
  DWORD dwPageSize;
  LPVOID lpMinimumApplicationAddress;
  LPVOID lpMaximumApplicationAddress;
  DWORD dwActiveProcessorMask;
  DWORD dwNumberOfProcessors;
  DWORD dwProcessorType;
  DWORD dwAllocationGranularity;
  WORD wProcessorLevel;
  WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;
typedef struct _SYSTEMTIME
{
  WORD wYear;
  WORD wMonth;
  WORD wDayOfWeek;
  WORD wDay;
  WORD wHour;
  WORD wMinute;
  WORD wSecond;
  WORD wMilliseconds;
} SYSTEMTIME, *PSYSTEMTIME, *LPSYSTEMTIME;
typedef CONST SYSTEMTIME *PCSYSTEMTIME, *LPCSYSTEMTIME;
#define TIME_ZONE_ID_INVALID  0xffffffff
#define TIME_ZONE_ID_UNKNOWN  0
#define TIME_ZONE_ID_STANDARD 1
#define TIME_ZONE_ID_DAYLIGHT 2
typedef struct _TIME_ZONE_INFORMATION
{
  LONG Bias;
  WCHAR StandardName[32];
  SYSTEMTIME StandardDate;
  LONG StandardBias;
  WCHAR DaylightName[32];
  SYSTEMTIME DaylightDate;
  LONG DaylightBias;
} TIME_ZONE_INFORMATION, *PTIME_ZONE_INFORMATION, *LPTIME_ZONE_INFORMATION;
typedef CONST TIME_ZONE_INFORMATION *PCTIME_ZONE_INFORMATION, *LPCTIME_ZONE_INFORMATION;
#include "poppack.h"

/* ja:コンソール */
#include "pshpack1.h"
typedef struct tagCOORD
{
  SHORT X;
  SHORT Y;
} COORD, *PCOORD, *LPCOORD;
#include "poppack.h"

/* ja:非公開 */
#define EXCEPTION_MAXIMUM_PARAMETERS 15
#define MAXIMUM_SUPPORTED_EXTENSION 512
#define SIZE_OF_80387_REGISTERS 80
typedef struct _FLOATING_SAVE_AREA FLOATING_SAVE_AREA, *PFLOATING_SAVE_AREA, *LPFLOATING_SAVE_AREA;
typedef struct _CONTEXT86 CONTEXT86, *PCONTEXT86, *LPCONTEXT86, CONTEXT, *PCONTEXT, *LPCONTEXT;
typedef struct _EXCEPTION_FRAME EXCEPTION_FRAME, *PEXCEPTION_FRAME, *LPEXCEPTION_FRAME;
typedef struct _EXCEPTION_POINTERS EXCEPTION_POINTERS, *PEXCEPTION_POINTERS, *LPEXCEPTION_POINTERS;
typedef struct _EXCEPTION_RECORD EXCEPTION_RECORD, *PEXCEPTION_RECORD, *LPEXCEPTION_RECORD;
typedef struct _EXCEPTION_REGISTRATION_RECORD EXCEPTION_REGISTRATION_RECORD, *PEXCEPTION_REGISTRATION_RECORD, *LPEXCEPTION_REGISTRATION_RECORD;
typedef struct _SCOPETABLE SCOPETABLE, *PSCOPETABLE, *LPSCOPETABLE;
typedef DWORD (*PEXCEPTION_HANDLER)(PEXCEPTION_RECORD, PEXCEPTION_REGISTRATION_RECORD, PCONTEXT, EXCEPTION_REGISTRATION_RECORD **);
typedef DWORD (*LPEXCEPTION_HANDLER)(LPEXCEPTION_RECORD, LPEXCEPTION_REGISTRATION_RECORD, LPCONTEXT, EXCEPTION_REGISTRATION_RECORD **);
typedef LONG (CALLBACK *PTOP_LEVEL_EXCEPTION_FILTER)(PEXCEPTION_POINTERS);
typedef LONG (CALLBACK *LPTOP_LEVEL_EXCEPTION_FILTER)(LPEXCEPTION_POINTERS);
#include "pshpack1.h"
struct _FLOATING_SAVE_AREA
{
  DWORD ControlWord;
  DWORD StatusWord;
  DWORD TagWord;
  DWORD ErrorOffset;
  DWORD ErrorSelector;
  DWORD DataOffset;
  DWORD DataSelector;
  BYTE RegisterArea[SIZE_OF_80387_REGISTERS];
  DWORD Cr0NpxState;
};
struct _CONTEXT86
{
  DWORD ContextFlags;
  DWORD Dr0;
  DWORD Dr1;
  DWORD Dr2;
  DWORD Dr3;
  DWORD Dr6;
  DWORD Dr7;
  FLOATING_SAVE_AREA FloatSave;
  DWORD SegGs;
  DWORD SegFs;
  DWORD SegEs;
  DWORD SegDs;
  DWORD Edi;
  DWORD Esi;
  DWORD Ebx;
  DWORD Edx;
  DWORD Ecx;
  DWORD Eax;
  DWORD Ebp;
  DWORD Eip;
  DWORD SegCs;
  DWORD EFlags;
  DWORD Esp;
  DWORD SegSs;
  BYTE ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
};
struct _EXCEPTION_FRAME
{
  EXCEPTION_REGISTRATION_RECORD *prev;
  void (*handler)(PEXCEPTION_RECORD, PEXCEPTION_REGISTRATION_RECORD, PCONTEXT, PEXCEPTION_RECORD);
  PSCOPETABLE scopetable;
  int trylevel;
  int _ebp;
  PEXCEPTION_POINTERS xpointers;
};
struct _EXCEPTION_POINTERS
{
  PEXCEPTION_RECORD ExceptionRecord;
  PCONTEXT ContextRecord;
};
struct _EXCEPTION_RECORD
{
  DWORD ExceptionCode;
  DWORD ExceptionFlags;
  struct _EXCEPTION_RECORD *ExceptionRecord;
  PVOID ExceptionAddress;
  DWORD NumberParameters;
  ULONG_PTR ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
};
struct _EXCEPTION_REGISTRATION_RECORD
{
  struct _EXCEPTION_REGISTRATION_RECORD *Prev;
  PEXCEPTION_HANDLER Handler;
};
struct _SCOPETABLE
{
  int previousTryLevel;
  int (*lpfnFilter)(PEXCEPTION_POINTERS);
  int (*lpfnHandler)(void);
};
#include "poppack.h"
#endif /* W32LDR_HEADER */


typedef struct _W32LdrSignal
{
  gint counter;
  gchar *name;
  gint count, max;/* ja:イベントならばcount=0〜1,max<0
                        ミューテックスならばcount=0〜1,max=0
                        セマフォならば0<=count<=max,max>0
                        countが0よりも大きいならばシグナル状態
                        countが0以下ならば非シグナル状態 */
  gboolean manual;/* ja:この値はイベントのみ有効 */
#ifdef USE_THREAD
  GThread *gthread;/* ja:この値はイベントとミューテックスのみ有効 */
#endif /* USE_THREAD */
} W32LdrSignal;
typedef struct _W32LdrHandle
{
  gint counter;
  /* ja:ファイル */
  gchar *file;
  FileIO *fio;
  /* ja:マッピング */
  gpointer p;
  gchar *name;
  gssize length;
  /* ja:スレッド */
  gint priority;
#ifdef USE_THREAD
  GThread *gthread;
#endif /* USE_THREAD */
  /* ja:シグナル */
  W32LdrSignal *w32signal;
} W32LdrHandle;
typedef struct _W32LdrNlsInfo
{
  gchar *lang;
  gchar *region;
  guint16 lcid;
  gchar *langage;
  gchar *locale;
  guint acp;
  guint oemcp;
} W32LdrNlsInfo;
# ifdef USE_THREAD
G_LOCK_DEFINE_STATIC (critical);
static volatile gboolean critical = FALSE;
# endif /* USE_THREAD */
static GHashTable *ghash_signal = NULL;
static W32LdrNlsInfo nls_information[] = {
{"af",  NULL, MAKELANGID (LANG_AFRIKAANS, SUBLANG_DEFAULT),               "Afrikaans",           "Afrikaans",                    1252,  850},
{"sq",  NULL, MAKELANGID (LANG_ALBANIAN, SUBLANG_DEFAULT),                "Albanian",            "Albanian",                     1250,  852},
{"ar",  "SA", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_SAUDI_ARABIA),      "Arabic",              "Arabic (Saudi Arabia)",        1256,  720},
{"ar",  "IQ", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_IRAQ),              "Arabic",              "Arabic (Iraq)",                1256,  720},
{"ar",  "EG", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_EGYPT),             "Arabic",              "Arabic (Egypt)",               1256,  720},
{"ar",  "LY", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_LIBYA),             "Arabic",              "Arabic (Libya)",               1256,  720},
{"ar",  "DZ", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_ALGERIA),           "Arabic",              "Arabic (Algeria)",             1256,  720},
{"ar",  "MA", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_MOROCCO),           "Arabic",              "Arabic (Morocco)",             1256,  720},
{"ar",  "TN", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_TUNISIA),           "Arabic",              "Arabic (Tunisia))",            1256,  720},
{"ar",  "OM", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_OMAN),              "Arabic",              "Arabic (Oman)",                1256,  720},
{"ar",  "YE", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_YEMEN),             "Arabic",              "Arabic (Yemen)",               1256,  720},
{"ar",  "SY", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_SYRIA),             "Arabic",              "Arabic (Syria)",               1256,  720},
{"ar",  "JO", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_JORDAN),            "Arabic",              "Arabic (Jordan)",              1256,  720},
{"ar",  "LB", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_LEBANON),           "Arabic",              "Arabic (Lebanon)",             1256,  720},
{"ar",  "KW", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_KUWAIT),            "Arabic",              "Arabic (Kuwait)",              1256,  720},
{"ar",  "AE", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_UAE),               "Arabic",              "Arabic (U.A.E.)",              1256,  720},
{"ar",  "BH", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_BAHRAIN),           "Arabic",              "Arabic (Bahrain)",             1256,  720},
{"ar",  "QA", MAKELANGID (LANG_ARABIC, SUBLANG_ARABIC_QATAR),             "Arabic",              "Arabic (Qatar)",               1256,  720},
{"am",  NULL, MAKELANGID (LANG_ARMENIAN, SUBLANG_DEFAULT),                "Armenian",            "Armenian",                        0,    1},
{"az",  NULL, MAKELANGID (LANG_AZERI, SUBLANG_AZERI),                     "Azeri (Latin)",       "Azeri (Latin)",                1254,  857},
{"az",  NULL, MAKELANGID (LANG_AZERI, SUBLANG_AZERI_CYRILLIC),            "Azeri (Cyrillic)",    "Azeri (Cyrillic)",             1251,  866},
{"eu",  NULL, MAKELANGID (LANG_BASQUE, SUBLANG_DEFAULT),                  "Basque",              "Basque",                       1252,  850},
{"bn",  NULL, MAKELANGID (LANG_BENGALI, SUBLANG_DEFAULT),                 "Bengali",             "Bengali (India)",                 0,    1},
{"bg",  NULL, MAKELANGID (LANG_BULGARIAN, SUBLANG_DEFAULT),               "Bulgarian",           "Bulgarian",                    1251,  866},
{"be",  NULL, MAKELANGID (LANG_BYELORUSSIAN, SUBLANG_DEFAULT),            "Belarusian",          "Belarusian",                   1251,  866},
{"ca",  NULL, MAKELANGID (LANG_CATALAN, SUBLANG_DEFAULT),                 "Catalan",             "Catalan",                      1252,  850},
{"zh",  "TW", MAKELANGID (LANG_CHINESE, SUBLANG_CHINESE_TRADITIONAL),     "Chinese",             "Chinese (Taiwan)",              950,  950},
{"zh",  "CN", MAKELANGID (LANG_CHINESE, SUBLANG_CHINESE_SIMPLIFIED),      "Chinese",             "Chinese (PRC)",                 936,  936},
{"zh",  "HK", MAKELANGID (LANG_CHINESE, SUBLANG_CHINESE_HONGKONG),        "Chinese",             "Chinese (Hong Kong S.A.R.)",    950,  950},
{"zh",  "SG", MAKELANGID (LANG_CHINESE, SUBLANG_CHINESE_SINGAPORE),       "Chinese",             "Chinese (Singapore)",           936,  936},
{"zh",  "MO", MAKELANGID (LANG_CHINESE, SUBLANG_CHINESE_MACAU),           "Chinese",             "Chinese (Macau S.A.R.)",        950,  950},
{"sh",  NULL, MAKELANGID (LANG_SERBO_CROATIAN, SUBLANG_DEFAULT),          "Croatian",            "Croatian",                     1250,  852},
{"hr",  NULL, MAKELANGID (LANG_CROATIAN, SUBLANG_CROATIAN),               "Croatian",            "Croatian",                     1250,  852},
{"sr",  NULL, MAKELANGID (LANG_SERBIAN, SUBLANG_SERBIAN),                 "Serbian (Cyrillic)",  "Serbian (Cyrillic)",           1251,  855},
{"sr",  NULL, MAKELANGID (LANG_SERBIAN, SUBLANG_SERBIAN_LATIN),           "Serbian (Latin)",     "Serbian (Latin)",              1250,  852},
{"ca",  NULL, MAKELANGID (LANG_CZECH, SUBLANG_DEFAULT),                   "Czech",               "Czech",                        1250,  852},
{"da",  NULL, MAKELANGID (LANG_DANISH, SUBLANG_DEFAULT),                  "Danish",              "Danish",                       1252,  850},
{"nl",  NULL, MAKELANGID (LANG_DUTCH, SUBLANG_DUTCH),                     "Dutch",               "Dutch (Netherlands)",          1252,  850},
{"nl",  "BE", MAKELANGID (LANG_DUTCH, SUBLANG_DUTCH_BELGIAN),             "Dutch",               "Dutch (Belgium)",              1252,  850},
{"nl",  "SR", MAKELANGID (LANG_DUTCH, SUBLANG_DUTCH_SURINAM),             "Dutch",               "Dutch (Surinam)",              1252,  850},
{"en",  "US", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_US),              "English",             "English (United States)",      1252,  437},
{"en",  "GB", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_UK),              "English",             "English (United Kingdom)",     1252,  850},
{"en",  "UK", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_UK),              "English",             "English (United Kingdom)",     1252,  850},
{"en",  "AU", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_AUS),             "English",             "English (Australia)",          1252,  850},
{"en",  "CA", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CAN),             "English",             "English (Canada)",             1252,  850},
{"en",  "NZ", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_NZ),              "English",             "English (New Zealand)",        1252,  850},
{"en",  "IE", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_EIRE),            "English",             "English (Ireland)",            1252,  850},
{"en",  "ZA", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_SAFRICA),         "English",             "English (South Africa)",       1252,  437},
{"en",  "JM", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_JAMAICA),         "English",             "English (Jamaica)",            1252,  850},
{"en",  "AG", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "AI", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "AN", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "AW", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "BB", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "BS", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "CU", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "DM", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "DO", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "GD", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "HT", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "LC", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "MQ", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "MS", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "KN", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "KY", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "PR", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "TC", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "VC", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "VG", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "VI", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252,  850},
{"en",  "BZ", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_BELIZE),          "English",             "English (Belize)",             1252,  850},
{"en",  "TT", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_TRINIDAD),        "English",             "English (Trinidad)",           1252,  850},
{"en",  "ZW", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_ZIMBABWE),        "English",             "English (Zimbabwe)",           1252,  437},
{"en",  "PH", MAKELANGID (LANG_ENGLISH, SUBLANG_ENGLISH_PHILIPPINES),     "English",             "English (Philippines)",        1252,  437},
{"et",  NULL, MAKELANGID (LANG_ESTONIAN, SUBLANG_DEFAULT),                "Estonian",            "Estonian",                     1257,  775},
{"fo",  NULL, MAKELANGID (LANG_FAEROESE, SUBLANG_DEFAULT),                "Faeroese",            "Faeroese",                     1252,  850},
{"fa",  NULL, MAKELANGID (LANG_FARSI, SUBLANG_DEFAULT),                   "Farsi",               "Farsi",                        1256,  720},
{"fi",  NULL, MAKELANGID (LANG_FINNISH, SUBLANG_DEFAULT),                 "Finnish",             "Finnish",                      1252,  850},
{"fr",  NULL, MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH),                   "French",              "French (France)",              1252,  850},
{"fr",  "BE", MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH_BELGIAN),           "French",              "French (Belgium)",             1252,  850},
{"fr",  "CA", MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH_CANADIAN),          "French",              "French (Canada)",              1252,  850},
{"fr",  "CH", MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH_SWISS),             "French",              "French (Belgium)",             1252,  850},
{"fr",  "LU", MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH_LUXEMBOURG),        "French",              "French (Luxembourg)",          1252,  850},
{"fr",  "MC", MAKELANGID (LANG_FRENCH, SUBLANG_FRENCH_MONACO),            "French",              "French (Monaco)",              1252,  850},
{"gd",  NULL, MAKELANGID (LANG_GAELIC, SUBLANG_GAELIC),                   "Gaelic",              "Gaelic",                       1252,  850},
{"gd",  NULL, MAKELANGID (LANG_GAELIC, SUBLANG_GAELIC_SCOTTISH),          "Gaelic",              "Gaelic (Scotland)",            1252,  850},
{"gd",  "IM", MAKELANGID (LANG_GAELIC, SUBLANG_GAELIC_MANX),              "Gaelic",              "Gaelic (Manx)",                1252,  850},
{"ka",  NULL, MAKELANGID (LANG_GEORGIAN, SUBLANG_DEFAULT),                "Georgian",            "Georgian",                        0,    1},
{"de",  NULL, MAKELANGID (LANG_GERMAN, SUBLANG_GERMAN),                   "German",              "German (Germany)",             1252,  850},
{"de",  "CH", MAKELANGID (LANG_GERMAN, SUBLANG_GERMAN_SWISS),             "German",              "German (Switzerland)",         1252,  850},
{"de",  "AT", MAKELANGID (LANG_GERMAN, SUBLANG_GERMAN_AUSTRIAN),          "German",              "German (Austria)",             1252,  850},
{"de",  "LU", MAKELANGID (LANG_GERMAN, SUBLANG_GERMAN_LUXEMBOURG),        "German",              "German (Luxembourg)",          1252,  850},
{"de",  "LI", MAKELANGID (LANG_GERMAN, SUBLANG_GERMAN_LIECHTENSTEIN),     "German",              "German (Liechtenstein)",       1252,  850},
{"el",  NULL, MAKELANGID (LANG_GREEK, SUBLANG_DEFAULT),                   "Greek",               "Greek",                        1253,  737},
{"gu",  NULL, MAKELANGID (LANG_GUJARATI, SUBLANG_DEFAULT),                "Gujarati",            "Gujarati",                        0,    1},
{"el",  NULL, MAKELANGID (LANG_HEBREW, SUBLANG_DEFAULT),                  "Hebrew",              "Hebrew",                       1255,  862},
{"hi",  NULL, MAKELANGID (LANG_HINDI, SUBLANG_DEFAULT),                   "Hindi",               "Hindi",                           0,    1},
{"el",  NULL, MAKELANGID (LANG_HUNGARIAN, SUBLANG_DEFAULT),               "Hungarian",           "Hungarian",                    1250,  852},
{"is",  NULL, MAKELANGID (LANG_ICELANDIC, SUBLANG_DEFAULT),               "Icelandic",           "Icelandic",                    1252,  850},
{"id",  NULL, MAKELANGID (LANG_INDONESIAN, SUBLANG_DEFAULT),              "Indonesian",          "Indonesian",                   1252,  850},
{"it",  NULL, MAKELANGID (LANG_ITALIAN, SUBLANG_ITALIAN),                 "Italian",             "Italian (Italy)",              1252,  850},
{"it",  "CH", MAKELANGID (LANG_ITALIAN, SUBLANG_ITALIAN_SWISS),           "Italian",             "Italian (Switzerland)",        1252,  850},
{"ja",  NULL, MAKELANGID (LANG_JAPANESE, SUBLANG_DEFAULT),                "Japanese",            "Japanese",                      932,  932},
{"kn",  NULL, MAKELANGID (LANG_KANNADA, SUBLANG_DEFAULT),                 "Kannada",             "Kannada",                         0,    1},
{"kk",  NULL, MAKELANGID (LANG_KAZAKH, SUBLANG_DEFAULT),                  "Kazakh",              "Kazakh",                       1251,  866},
{"kok", NULL, MAKELANGID (LANG_KONKANI, SUBLANG_DEFAULT),                 "Konkani",             "Konkani",                         0,    1},
{"ko",  NULL, MAKELANGID (LANG_KOREAN, SUBLANG_KOREAN),                   "Korean",              "Korean",                        949,  949},
{"lv",  NULL, MAKELANGID (LANG_LATVIAN, SUBLANG_DEFAULT),                 "Latvian",             "Latvian",                      1257,  775},
{"lt",  NULL, MAKELANGID (LANG_LITHUANIAN, SUBLANG_LITHUANIAN),           "Lithuanian",          "Lithuanian",                   1257,  775},
{"lt",  NULL, MAKELANGID (LANG_LITHUANIAN, SUBLANG_LITHUANIAN_CLASSIC),   "Lithuanian",          "Lithuanian (Classic)",         1257,  775},/* ? */
{"mk",  NULL, MAKELANGID (LANG_MACEDONIAN, SUBLANG_DEFAULT),              "FYRO Macedonian",     "FYRO Macedonian",              1251,  866},
{"ms",  NULL, MAKELANGID (LANG_MALAY, SUBLANG_MALAY),                     "Malay",               "Malay (Malaysia)",             1252,  850},
{"ms",  NULL, MAKELANGID (LANG_MALAY, SUBLANG_MALAY_BRUNEI_DARUSSALAM),   "Malay",               "Malay (Brunei Darussalam)",    1252,  850},
{"ml",  NULL, MAKELANGID (LANG_MALAYALAM, SUBLANG_DEFAULT),               "Malayalam",           "Malayalam (India)",               0,    1},
{"mt",  NULL, MAKELANGID (LANG_MALTESE, SUBLANG_DEFAULT),                 "Maltese",             "Maltese",                         0,    1},
{"mi",  NULL, MAKELANGID (LANG_MAORI, SUBLANG_DEFAULT),                   "Maori",               "Maori",                           0,    1},
{"mr",  NULL, MAKELANGID (LANG_MARATHI, SUBLANG_DEFAULT),                 "Marathi",             "Marathi",                         0,    1},
{"no",  NULL, MAKELANGID (LANG_NORWEGIAN, SUBLANG_NORWEGIAN_BOKMAL),      "Norwegian (Bokmal)",  "Norwegian (Bokmal)",           1252,  850},
{"nb",  NULL, MAKELANGID (LANG_NORWEGIAN, SUBLANG_NORWEGIAN_BOKMAL),      "Norwegian (Bokmal)",  "Norwegian (Bokmal)",           1252,  850},
{"nn",  NULL, MAKELANGID (LANG_NORWEGIAN, SUBLANG_NORWEGIAN_NYNORSK),     "Norwegian (Nynorsk)", "Norwegian (Nynorsk)",          1252,  850},
{"or",  NULL, MAKELANGID (LANG_ORIYA, SUBLANG_DEFAULT),                   "Oriya",               "Oriya",                           0,    1}, /* ? */
{"pl",  NULL, MAKELANGID (LANG_POLISH, SUBLANG_DEFAULT),                  "Polish",              "Polish",                       1250,  852},
{"pt",  NULL, MAKELANGID (LANG_PORTUGUESE, SUBLANG_PORTUGUESE),           "Portuguese",          "Portuguese (Portugal)",        1250,  852},
{"pt",  "BR", MAKELANGID (LANG_PORTUGUESE, SUBLANG_PORTUGUESE_BRAZILIAN), "Portuguese",          "Portuguese (Brazil)",          1250,  852},
{"pa",  NULL, MAKELANGID (LANG_PUNJABI, SUBLANG_DEFAULT),                 "Punjabi",             "Punjabi",                         0,    1},
{"rm",  NULL, MAKELANGID (LANG_RHAETO_ROMANCE, SUBLANG_DEFAULT),          "Rhaeto Romance",      "Rhaeto Romance",                  0,    1}, /* ? */
{"ro",  NULL, MAKELANGID (LANG_ROMANIAN, SUBLANG_ROMANIAN),               "Romanian",            "Romanian (Romania)",           1250,  852},
{"ro",  "MD", MAKELANGID (LANG_ROMANIAN, SUBLANG_ROMANIAN_MOLDAVIA),      "Romanian",            "Romanian (Moldavia)",          1250,  852}, /* ? */
{"ru",  NULL, MAKELANGID (LANG_RUSSIAN, SUBLANG_RUSSIAN),                 "Russian",             "Russian (Russia)",             1251,  866},
{"ro",  "MD", MAKELANGID (LANG_RUSSIAN, SUBLANG_RUSSIAN_MOLDAVIA),        "Russian",             "Russian (Moldavia)",           1251,  866}, /* ? */
{"se",  NULL, MAKELANGID (LANG_SAAMI, SUBLANG_DEFAULT),                   "Sami (Northern)",     "Sami, Northern (Norway)",      1252,  850},
{"sa",  NULL, MAKELANGID (LANG_SANSKRIT, SUBLANG_DEFAULT),                "Sanskrit",            "Sanskrit",                        0,    1},
{"sk",  NULL, MAKELANGID (LANG_SLOVAK, SUBLANG_DEFAULT),                  "Slovak",              "Slovak",                       1250,  852},
{"sl",  NULL, MAKELANGID (LANG_SLOVENIAN, SUBLANG_DEFAULT),               "Slovenian",           "Slovenian",                    1250,  852},
{"sb",  NULL, MAKELANGID (LANG_SORBIAN, SUBLANG_DEFAULT),                 "Sorbian",             "Sorbian",                      1250,  852},
{"es",  NULL, MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH),                 "Spanish",             "Spanish (Traditional Sort)",   1252,  850},
{"es",  "MX", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_MEXICAN),         "Spanish",             "Spanish (Mexico)",             1252,  850},
{"es",  NULL, MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_MODERN),          "Spanish",             "Spanish (International Sort)", 1252,  850},
{"es",  "GT", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_GUATEMALA),       "Spanish",             "Spanish (Guatemala)",          1252,  850},
{"es",  "CR", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_COSTARICA),       "Spanish",             "Spanish (Costa Rica)",         1252,  850},
{"es",  "PA", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_PANAMA),          "Spanish",             "Spanish (Panama)",             1252,  850},
{"es",  "DO", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_DOMINICAN),       "Spanish",             "Spanish (Dominican Republic)", 1252,  850},
{"es",  "VE", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_VENEZUELA),       "Spanish",             "Spanish (Venezuela)",          1252,  850},
{"es",  "CO", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_COLOMBIA),        "Spanish",             "Spanish (Colombia)",           1252,  850},
{"es",  "PE", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_PERU),            "Spanish",             "Spanish (Peru))",              1252,  850},
{"es",  "AR", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_ARGENTINA),       "Spanish",             "Spanish (Argentina)",          1252,  850},
{"es",  "EC", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_ECUADOR),         "Spanish",             "Spanish (Ecuador)",            1252,  850},
{"es",  "CL", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_CHILE),           "Spanish",             "Spanish (Chile)",              1252,  850},
{"es",  "UY", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_URUGUAY),         "Spanish",             "Spanish (Uruguay)",            1252,  850},
{"es",  "PY", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_PARAGUAY),        "Spanish",             "Spanish (Paraguay)",           1252,  850},
{"es",  "BO", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_BOLIVIA),         "Spanish",             "Spanish (Bolivia)",            1252,  850},
{"es",  "SV", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_EL_SALVADOR),     "Spanish",             "Spanish (El Salvador)",        1252,  850},
{"es",  "HN", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_HONDURAS),        "Spanish",             "Spanish (Honduras)",           1252,  850},
{"es",  "NI", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_NICARAGUA),       "Spanish",             "Spanish (Nicaragua)",          1252,  850},
{"es",  "PR", MAKELANGID (LANG_SPANISH, SUBLANG_SPANISH_PUERTO_RICO),     "Spanish",             "Spanish (Puerto Rico)",        1252,  850},
{"sx",  NULL, MAKELANGID (LANG_SUTU, SUBLANG_DEFAULT),                    "Sutu",                "Sutu",                            0,    1}, /* ? */
{"sw",  NULL, MAKELANGID (LANG_SWAHILI, SUBLANG_DEFAULT),                 "Swahili",             "Swahili",                      1252,  437},
{"sv",  NULL, MAKELANGID (LANG_SWEDISH, SUBLANG_SWEDISH),                 "Swedish",             "Swedish",                      1252,  850},
{"sv",  "FI", MAKELANGID (LANG_SWEDISH, SUBLANG_SWEDISH_FINLAND),         "Swedish",             "Swedish (Finland)",            1252,  850},
{"ta",  NULL, MAKELANGID (LANG_TAMIL, SUBLANG_DEFAULT),                   "Tamil",               "Tamil",                           0,    1},
{"tt",  NULL, MAKELANGID (LANG_TATAR, SUBLANG_DEFAULT),                   "Tatar",               "Tatar",                        1251,  866},
{"te",  NULL, MAKELANGID (LANG_TELUGU, SUBLANG_DEFAULT),                  "Telugu",              "Telugu",                          0,    1},
{"th",  NULL, MAKELANGID (LANG_THAI, SUBLANG_DEFAULT),                    "Thai",                "Thai",                          874,  874},
{"ts",  NULL, MAKELANGID (LANG_TSONGA, SUBLANG_DEFAULT),                  "Tsonga",              "Tsonga",                          0,    1}, /* ? */
{"tn",  NULL, MAKELANGID (LANG_TSWANA, SUBLANG_DEFAULT),                  "Tswana",              "Tswana",                       1252,  850},
{"tr",  NULL, MAKELANGID (LANG_TURKISH, SUBLANG_DEFAULT),                 "Turkish",             "Turkish",                      1254,  857},
{"uk",  NULL, MAKELANGID (LANG_UKRAINIAN, SUBLANG_DEFAULT),               "Ukrainian",           "Ukrainian",                    1251,  866},
{"ur",  NULL, MAKELANGID (LANG_URDU, SUBLANG_URDU_PAKISTAN),              "Urdu",                "Urdu",                         1256,  720},
{"uz",  NULL, MAKELANGID (LANG_UZBEK, SUBLANG_UZBEK),                     "Uzbek (Latin)",       "Uzbek (Latin)",                1254,  857},
{"uz",  NULL, MAKELANGID (LANG_UZBEK, SUBLANG_UZBEK_CYRILLIC),            "Uzbek (Cyrillic)",    "Uzbek (Cyrillic)",             1251,  866},
{"ve",  NULL, MAKELANGID (LANG_VENDA, SUBLANG_DEFAULT),                   "Venda",               "Venda",                           0,    1}, /* ? */
{"vi",  NULL, MAKELANGID (LANG_VIETNAMESE, SUBLANG_DEFAULT),              "Vietnamese",          "Vietnamese",                   1258, 1258},
{"xh",  NULL, MAKELANGID (LANG_XHOSA, SUBLANG_DEFAULT),                   "Xhosa",               "Xhosa",                        1252,  850},
{"eo",  NULL, MAKELANGID (LANG_ESPERANTO, SUBLANG_DEFAULT),               "Esperanto",           "Esperanto",                       0,    1}, /* ? */
{"wa",  NULL, MAKELANGID (LANG_WALON, SUBLANG_DEFAULT),                   "Walon",               "Walon",                           0,    1}, /* ? */
{"kw",  NULL, MAKELANGID (LANG_CORNISH, SUBLANG_DEFAULT),                 "Cornish",             "Cornish",                         0,    1}, /* ? */
{"cy",  NULL, MAKELANGID (LANG_WELSH, SUBLANG_DEFAULT),                   "Welsh",               "Welsh",                        1252,  850},
{"br",  NULL, MAKELANGID (LANG_BRETON, SUBLANG_DEFAULT),                  "Breton",              "Breton",                          0,    1}, /* ? */
{NULL,  NULL, MAKELANGID (LANG_NEUTRAL, SUBLANG_NEUTRAL),                 NULL,                  NULL,                              0,    0}};


static W32LdrNlsInfo *
kernel32_nls_get_information (void)
{
  static gint nls_information_index = -1;

  if (nls_information_index < 0)
    {
      const gchar *ev;
      gint i;
#if GLIB_CHECK_VERSION(2,6,0)
      const gchar * const * name;

      name = g_get_language_names ();
#endif /* GLIB_CHECK_VERSION(2,6,0) */
      if (
#if GLIB_CHECK_VERSION(2,6,0)
            (name && name[0] && (ev = name[1]) && ev[0] != '\0') ||
#endif /* GLIB_CHECK_VERSION(2,6,0) */
             ((ev = g_getenv ("LC_ALL")) && ev[0] != '\0')
          || ((ev = g_getenv ("LC_MESSAGES")) && ev[0] != '\0')
          || ((ev = g_getenv ("LANG")) && ev[0] != '\0'))
        {
          gchar *lang;

          lang = g_strdup (ev);
          for (i = 0; g_ascii_isalpha (lang[i]); i++);
          lang[i] = '\0';
          if (ev[i] != '\0')
            {
              gchar *region;

              region = g_strdup (ev + i + 1);
              for (i = 0; g_ascii_isalpha (region[i]); i++);
              region[i] = '\0';
              for (i = 0; nls_information[i].langage; i++)
                if (nls_information[i].region
                    && g_ascii_strcasecmp (nls_information[i].lang, lang) == 0
                    && g_ascii_strcasecmp (nls_information[i].region,
                                                                region) == 0)
                  {
                    nls_information_index = i;
                    break;
                  }
              g_free (region);
            }
          if (nls_information_index < 0)
            for (i = 0; nls_information[i].langage; i++)
              if (g_ascii_strcasecmp (nls_information[i].lang, lang) == 0)
                {
                  nls_information_index = i;
                  break;
                }
          g_free (lang);
        }
      if (nls_information_index < 0)
        for (i = 0; nls_information[i].langage; i++)
          if (g_ascii_strcasecmp (nls_information[i].lang, "en") == 0)
            {
              nls_information_index = i;
              break;
            }
      if (nls_information_index < 0)
        nls_information_index = 0;
    }
  return nls_information + nls_information_index;
}


/* AddAtomA ordinal = 1, argument = 4 */
ATOM WINAPI AddAtomA (LPCSTR lpString)
{
  return GlobalAddAtomA (lpString);
}


/* AddAtomW ordinal = 2, argument = 4 */
ATOM WINAPI AddAtomW (LPCWSTR lpString)
{
  return GlobalAddAtomW (lpString);
}


/* AddConsoleAliasA ordinal = 3, argument = 12 temporary */
static DWORD WINAPI AddConsoleAliasA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddConsoleAliasW ordinal = 4, argument = 12 temporary */
static DWORD WINAPI AddConsoleAliasW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AllocConsole ordinal = 5, argument = 0 */
BOOL WINAPI AllocConsole (VOID)
{
  return TRUE;
}


/* AllocateUserPhysicalPages ordinal = 6, argument = 12 temporary */
static DWORD WINAPI AllocateUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AreFileApisANSI ordinal = 7, argument = 0 temporary */
static DWORD WINAPI AreFileApisANSI (VOID)
{
  return 0;
}


/* AssignProcessToJobObject ordinal = 8, argument = 8 temporary */
static DWORD WINAPI AssignProcessToJobObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BackupRead ordinal = 9, argument = 28 temporary */
static DWORD WINAPI BackupRead (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* BackupSeek ordinal = 10, argument = 24 temporary */
static DWORD WINAPI BackupSeek (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BackupWrite ordinal = 11, argument = 28 temporary */
static DWORD WINAPI BackupWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* BaseAttachCompleteThunk ordinal = 12, argument = 0 temporary */
static DWORD WINAPI BaseAttachCompleteThunk (VOID)
{
  return 0;
}


/* Beep ordinal = 13, argument = 8 temporary */
static DWORD WINAPI Beep (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BeginUpdateResourceA ordinal = 14, argument = 8 temporary */
static DWORD WINAPI BeginUpdateResourceA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BeginUpdateResourceW ordinal = 15, argument = 8 temporary */
static DWORD WINAPI BeginUpdateResourceW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BindIoCompletionCallback ordinal = 16, argument = 12 temporary */
static DWORD WINAPI BindIoCompletionCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBA ordinal = 17, argument = 8 temporary */
static DWORD WINAPI BuildCommDCBA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildCommDCBAndTimeoutsA ordinal = 18, argument = 12 temporary */
static DWORD WINAPI BuildCommDCBAndTimeoutsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBAndTimeoutsW ordinal = 19, argument = 12 temporary */
static DWORD WINAPI BuildCommDCBAndTimeoutsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBW ordinal = 20, argument = 8 temporary */
static DWORD WINAPI BuildCommDCBW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CallNamedPipeA ordinal = 21, argument = 28 temporary */
static DWORD WINAPI CallNamedPipeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CallNamedPipeW ordinal = 22, argument = 28 temporary */
static DWORD WINAPI CallNamedPipeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CancelDeviceWakeupRequest ordinal = 23, argument = 4 temporary */
static DWORD WINAPI CancelDeviceWakeupRequest (DWORD dwArgv0)
{
  return 0;
}


/* CancelIo ordinal = 24, argument = 4 temporary */
static DWORD WINAPI CancelIo (DWORD dwArgv0)
{
  return 0;
}


/* CancelTimerQueueTimer ordinal = 25, argument = 8 temporary */
static DWORD WINAPI CancelTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CancelWaitableTimer ordinal = 26, argument = 4 temporary */
static DWORD WINAPI CancelWaitableTimer (DWORD dwArgv0)
{
  return 0;
}


/* ChangeTimerQueueTimer ordinal = 27, argument = 16 temporary */
static DWORD WINAPI ChangeTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ClearCommBreak ordinal = 28, argument = 4 temporary */
static DWORD WINAPI ClearCommBreak (DWORD dwArgv0)
{
  return 0;
}


/* ClearCommError ordinal = 29, argument = 12 temporary */
static DWORD WINAPI ClearCommError (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CloseConsoleHandle ordinal = 30, argument = 0 temporary */
static DWORD WINAPI CloseConsoleHandle (VOID)
{
  return 0;
}


/* CloseHandle ordinal = 31, argument = 4 */
BOOL WINAPI CloseHandle (HANDLE hObject)
{
  W32LdrHandle *w32handle;

  if (!hObject || hObject == INVALID_HANDLE_VALUE)
    return FALSE;
  w32handle = hObject;
  w32handle->counter--;
  if (w32handle->counter <= 0)
    {
      /* ja:マッピング */
      if (w32handle->fio && w32handle->p && w32handle->length > 0)
        {
          goffset cur;

          cur = fileio_seek (w32handle->fio, 0, FILEIO_SEEK_CUR);
          fileio_seek (w32handle->fio, 0, FILEIO_SEEK_SET);
          fileio_write (w32handle->fio, w32handle->p, w32handle->length);
          fileio_seek (w32handle->fio, cur, FILEIO_SEEK_SET);
        }
      g_free (w32handle->p);
      g_free (w32handle->name);
      /* ja:ファイル */
      g_free (w32handle->file);
      fileio_close (w32handle->fio);
      /* ja:シグナル */
#ifdef USE_THREAD
      G_LOCK (critical);
      critical = TRUE;
#endif /* USE_THREAD */
      if (w32handle->w32signal && --w32handle->w32signal->counter <= 0)
        {
          if (ghash_signal && w32handle->w32signal->name)
            {
              g_hash_table_remove (ghash_signal, w32handle->w32signal->name);
              if (g_hash_table_size (ghash_signal) <= 0)
                {
                  g_hash_table_destroy (ghash_signal);
                  ghash_signal = NULL;
                }
            }
          g_free (w32handle->w32signal->name);
          g_free (w32handle->w32signal);
        }
#ifdef USE_THREAD
      critical = FALSE;
      G_UNLOCK (critical);
#endif /* USE_THREAD */
      g_free (w32handle);
    }
  return TRUE;
}


/* CloseProfileUserMapping ordinal = 32, argument = 0 temporary */
static DWORD WINAPI CloseProfileUserMapping (VOID)
{
  return 0;
}


/* CmdBatNotification ordinal = 33, argument = 0 temporary */
static DWORD WINAPI CmdBatNotification (VOID)
{
  return 0;
}


/* CommConfigDialogA ordinal = 34, argument = 12 temporary */
static DWORD WINAPI CommConfigDialogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CommConfigDialogW ordinal = 35, argument = 12 temporary */
static DWORD WINAPI CommConfigDialogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CompareFileTime ordinal = 36, argument = 8 */
LONG WINAPI CompareFileTime (LPCFILETIME lpFileTime1, LPCFILETIME lpFileTime2)
{
  if (lpFileTime1->dwHighDateTime < lpFileTime1->dwHighDateTime)
    return -1;
  else if (lpFileTime1->dwHighDateTime > lpFileTime1->dwHighDateTime)
    return 1;
  if (lpFileTime1->dwLowDateTime < lpFileTime1->dwLowDateTime)
    return -1;
  else if (lpFileTime1->dwLowDateTime > lpFileTime1->dwLowDateTime)
    return -1;
  return 0;
}


/* CompareStringA ordinal = 37, argument = 24 */
INT WINAPI CompareStringA (LCID Locale, DWORD dwCmpFlags, LPCSTR lpString1, INT cchCount1, LPCSTR lpString2, INT cchCount2)
{
  gssize leng1, leng2;
  gunichar2 *str1, *str2;
  INT nResult;

  leng1 = MultiByteToWideChar (CP_ACP, 0, lpString1, cchCount1, NULL, 0);
  str1 = g_malloc (leng1 * sizeof (gunichar2));
  MultiByteToWideChar (CP_ACP, 0, lpString1, cchCount1, str1, leng1);
  leng2 = MultiByteToWideChar (CP_ACP, 0, lpString2, cchCount2, NULL, 0);
  str2 = g_malloc (leng2 * sizeof (gunichar2));
  MultiByteToWideChar (CP_ACP, 0, lpString2, cchCount2, str2, leng2);
  nResult = CompareStringW (Locale, dwCmpFlags, str1, leng1, str2, leng2);
  g_free (str1);
  g_free (str2);
  return nResult;
}


/* CompareStringW ordinal = 38, argument = 24 */
INT WINAPI CompareStringW (LCID Locale, DWORD dwCmpFlags, LPCWSTR lpString1, INT cchCount1, LPCWSTR lpString2, INT cchCount2)
{
  gchar *str1, *str2;
  INT nResult = 0;

  str1 = lpString1 ? g_utf16_to_utf8 (lpString1, cchCount1, NULL, NULL, NULL)
                   : NULL;
  str2 = lpString2 ? g_utf16_to_utf8 (lpString2, cchCount2, NULL, NULL, NULL)
                   : NULL;
  if (str1 && str2)
    {
      gint result;

      if (dwCmpFlags & NORM_IGNORECASE)
        {
          gchar *tmp;

          tmp = g_utf8_strdown (str1, -1);
          g_free (str1);
          str1 = tmp;
          tmp = g_utf8_strdown (str2, -1);
          g_free (str2);
          str2 = tmp;
        }
      result = g_strcmp (str1, str2);
      nResult = result < 0 ? CSTR_LESS_THAN
              : result > 0 ? CSTR_GREATER_THAN
                           : CSTR_EQUAL;
    }
  g_free (str1);
  g_free (str2);
  return nResult;
}


/* ConnectNamedPipe ordinal = 39, argument = 8 temporary */
static DWORD WINAPI ConnectNamedPipe (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConsoleMenuControl ordinal = 40, argument = 0 temporary */
static DWORD WINAPI ConsoleMenuControl (VOID)
{
  return 0;
}


/* ContinueDebugEvent ordinal = 41, argument = 12 temporary */
static DWORD WINAPI ContinueDebugEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ConvertDefaultLocale ordinal = 42, argument = 4 temporary */
static DWORD WINAPI ConvertDefaultLocale (DWORD dwArgv0)
{
  return 0;
}


/* ConvertThreadToFiber ordinal = 43, argument = 4 temporary */
static DWORD WINAPI ConvertThreadToFiber (DWORD dwArgv0)
{
  return 0;
}


/* CopyFileA ordinal = 44, argument = 12 */
BOOL WINAPI CopyFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, BOOL bFailIfExists)
{
  gboolean result = FALSE;
  gchar *newfile;

  newfile = w32ldr_filename_from_mb (lpNewFileName);
  if (!bFailIfExists || !g_file_test (newfile, G_FILE_TEST_EXISTS))
    {
      gpointer data;
      gchar *oldfile;
      gssize length;

      oldfile = w32ldr_filename_from_mb (lpExistingFileName);
      data = fileio_load (oldfile, &length);
      g_free (oldfile);
      if (data)
        {
          result = fileio_save (newfile, data, length);
          g_free (data);
          if (result)
            {
              FileIOTime atime, mtime;

              result = fileio_gettime (oldfile, &atime, &mtime)
                    && fileio_settime (newfile, &atime, &mtime);
            }
        }
    }
  g_free (newfile);
  return result;
}


/* CopyFileExA ordinal = 45, argument = 24 temporary */
static DWORD WINAPI CopyFileExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CopyFileExW ordinal = 46, argument = 24 temporary */
static DWORD WINAPI CopyFileExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CopyFileW ordinal = 47, argument = 12 */
BOOL WINAPI CopyFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists)
{
  gboolean result = FALSE;
  gchar *newfile;

  newfile = w32ldr_filename_from_wc (lpNewFileName);
  if (!bFailIfExists || !g_file_test (newfile, G_FILE_TEST_EXISTS))
    {
      gpointer data;
      gchar *oldfile;
      gssize length;

      oldfile = w32ldr_filename_from_wc (lpExistingFileName);
      data = fileio_load (oldfile, &length);
      g_free (oldfile);
      if (data)
        {
          result = fileio_save (newfile, data, length);
          g_free (data);
          if (result)
            {
              FileIOTime atime, mtime;

              result = fileio_gettime (oldfile, &atime, &mtime)
                    && fileio_settime (newfile, &atime, &mtime);
            }
        }
    }
  g_free (newfile);
  return result;
}


/* CreateConsoleScreenBuffer ordinal = 48, argument = 20 temporary */
static DWORD WINAPI CreateConsoleScreenBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateDirectoryA ordinal = 49, argument = 8 */
BOOL WINAPI CreateDirectoryA (LPCSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_mb (lpPathName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_mkdir (path, S_IRUSR | S_IWUSR | S_IXUSR
                                    | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = mkdir (path, S_IRUSR | S_IWUSR | S_IXUSR
                                    | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (path);
  return result == 0;
}


/* CreateDirectoryExA ordinal = 50, argument = 12 temporary */
static DWORD WINAPI CreateDirectoryExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateDirectoryExW ordinal = 51, argument = 12 temporary */
static DWORD WINAPI CreateDirectoryExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateDirectoryW ordinal = 52, argument = 8 */
BOOL WINAPI CreateDirectoryW (LPCWSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_wc (lpPathName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_mkdir (path, S_IRUSR | S_IWUSR | S_IXUSR
                                    | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = mkdir (path, S_IRUSR | S_IWUSR | S_IXUSR
                                    | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (path);
  return result == 0;
}


/* CreateEventA ordinal = 53, argument = 16 */
HANDLE WINAPI CreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  HANDLE hEvent;

  utf8str = w32ldr_utf8_from_mb (lpName);
  utf16str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  hEvent = CreateEventW (lpEventAttributes, bManualReset, bInitialState,
                                                                    utf16str);
  g_free (utf16str);
  g_free (utf8str);
  return hEvent;
}


/* CreateEventW ordinal = 54, argument = 16 */
HANDLE WINAPI CreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName)
{
  gchar *name;
  W32LdrHandle *w32handle = NULL;
  W32LdrSignal *w32signal = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  name = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  if (name && ghash_signal)
    w32signal = g_hash_table_lookup (ghash_signal, name);
  if (w32signal)
    {
      g_free (name);
      if (w32signal->max >= 0)
        w32signal = NULL;
    }
  else
    {
      w32signal = g_malloc0 (sizeof (W32LdrSignal));
      w32signal->name = name;
      if (bInitialState)
        w32signal->count = 1;
      w32signal->max = -1;
      w32signal->manual = bManualReset;
#ifdef USE_THREAD
      if (!bInitialState)
        w32signal->gthread = g_thread_self ();
#endif /* USE_THREAD */
      if (name)
        {
          if (!ghash_signal)
            ghash_signal = g_hash_table_new (g_str_hash, g_str_equal);
          g_hash_table_insert (ghash_signal, name, w32signal);
        }
    }
  if (w32signal)
    {
      w32signal->counter++;
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->w32signal = w32signal;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* CreateFiber ordinal = 55, argument = 12 temporary */
static DWORD WINAPI CreateFiber (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateFiberEx ordinal = 56, argument = 20 temporary */
static DWORD WINAPI CreateFiberEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


static HANDLE
kernel32_create_file (const gchar *file,
                      DWORD        dwDesiredAccess,
                      DWORD        dwShareMode,
                      DWORD        dwCreationDisposition)
{
  guint access, share, mode;
  FileIO *fio;
  W32LdrHandle *w32handle = INVALID_HANDLE_VALUE;

  access = (dwDesiredAccess & GENERIC_READ  ? FILEIO_ACCESS_READ : 0)
         | (dwDesiredAccess & GENERIC_WRITE ? FILEIO_ACCESS_WRITE : 0);
  share = (dwShareMode & FILE_SHARE_READ  ? FILEIO_SHARE_READ : 0)
        | (dwShareMode & FILE_SHARE_WRITE ? FILEIO_SHARE_WRITE : 0);
  switch (dwCreationDisposition)
    {
      case CREATE_NEW:        mode = FILEIO_MODE_CREATE_NEW;    break;
      case CREATE_ALWAYS:     mode = FILEIO_MODE_CREATE_ALWAYS; break;
      case OPEN_EXISTING:     mode = FILEIO_MODE_OPEN_EXISTING; break;
      case OPEN_ALWAYS:       mode = FILEIO_MODE_OPEN_ALWAYS;   break;
      case TRUNCATE_EXISTING:
        if (g_file_test (file,
                            G_FILE_TEST_IS_REGULAR | G_FILE_TEST_IS_SYMLINK))
          {
            mode = FILEIO_MODE_CREATE_ALWAYS;
            break;
          }
      default: return w32handle;
    }
  fio = fileio_open (file, access, share, mode);
  if (fio)
    {
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->counter = 1;
      w32handle->file = fileio_get_full_path (file);
      w32handle->fio = fio;
    }
  return w32handle;
}


/* CreateFileA ordinal = 57, argument = 28 */
HANDLE WINAPI CreateFileA (LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
  gchar *file;
  HANDLE hFile;

  file = w32ldr_filename_from_mb (lpFileName);
  hFile = kernel32_create_file (file,
                        dwDesiredAccess, dwShareMode, dwCreationDisposition);
  g_free (file);
  return hFile;
}


static HANDLE
kernel32_create_file_mapping (HANDLE       hFile,
                              gboolean     writable,
                              gssize       length,
                              const gchar *name)
{
  W32LdrHandle *w32handle = NULL;
  HANDLE hMapFile, hMapName;
  static GHashTable *ghash_mapping_file = NULL, *ghash_mapping_name = NULL;

  if (!ghash_mapping_file)
    ghash_mapping_file = g_hash_table_new (g_str_hash, g_str_equal);
  if (!ghash_mapping_name)
    ghash_mapping_name = g_hash_table_new (g_str_hash, g_str_equal);
  hMapFile = hFile != INVALID_HANDLE_VALUE
                    ? g_hash_table_lookup (ghash_mapping_file,
                                        ((W32LdrHandle *)hFile)->file) : NULL;
  hMapName = name ? g_hash_table_lookup (ghash_mapping_name, name) : NULL;
  if (hMapFile && hMapName)
    {
      if (hMapFile == hMapName)
        w32handle = hMapFile;
    }
  if (hMapFile)
    {
      w32handle = hMapFile;
    }
  else if (hMapName)
    {
      w32handle = hMapName;
    }
  else
    {
      if (hFile != INVALID_HANDLE_VALUE)
        {
          goffset cur;

          w32handle = g_malloc0 (sizeof (W32LdrHandle));
          if (writable)
            {
              fileio_ref (((W32LdrHandle *)hFile)->fio);
              w32handle->fio = ((W32LdrHandle *)hFile)->fio;
            }
          w32handle->length = fileio_size (((W32LdrHandle *)hFile)->fio);
          if (w32handle->length < length)
            w32handle->length = length;
          w32handle->p = g_malloc0 (w32handle->length);
          cur = fileio_seek (((W32LdrHandle *)hFile)->fio, 0, FILEIO_SEEK_CUR);
          fileio_seek (((W32LdrHandle *)hFile)->fio, 0, FILEIO_SEEK_SET);
          fileio_read (((W32LdrHandle *)hFile)->fio,
                                            w32handle->p, w32handle->length);
          fileio_seek (((W32LdrHandle *)hFile)->fio, cur, FILEIO_SEEK_SET);
        }
      else if (length > 0)
        {
          w32handle = g_malloc0 (sizeof (W32LdrHandle));
          w32handle->length = length;
          w32handle->p = g_malloc0 (w32handle->length);
        }
    }
  if (w32handle)
    {
      if (!hMapFile && hFile != INVALID_HANDLE_VALUE)
        g_hash_table_insert (ghash_mapping_file,
                                    ((W32LdrHandle *)hFile)->file, w32handle);
      if (!hMapName && name)
        g_hash_table_insert (ghash_mapping_name, (gpointer)name, w32handle);
      w32handle->counter++;
    }
  return w32handle;
}


/* CreateFileMappingA ordinal = 58, argument = 24 */
HANDLE WINAPI CreateFileMappingA (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCSTR lpName)
{
  gchar *name;
  HANDLE hMap;

  name = w32ldr_utf8_from_mb (lpName);
  hMap = kernel32_create_file_mapping (hFile,
        flProtect & (PAGE_READWRITE | PAGE_WRITECOPY), dwMaximumSizeLow, name);
  g_free (name);
  return hMap;
}


/* CreateFileMappingW ordinal = 59, argument = 24 */
HANDLE WINAPI CreateFileMappingW (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCWSTR lpName)
{
  gchar *name;
  HANDLE hMap;

  name = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  hMap = kernel32_create_file_mapping (hFile,
        flProtect & (PAGE_READWRITE | PAGE_WRITECOPY), dwMaximumSizeLow, name);
  g_free (name);
  return hMap;
}


/* CreateFileW ordinal = 60, argument = 28 */
HANDLE WINAPI CreateFileW (LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
  gchar *file;
  HANDLE hFile;

  file = w32ldr_filename_from_wc (lpFileName);
  hFile = kernel32_create_file (file,
                        dwDesiredAccess, dwShareMode, dwCreationDisposition);
  g_free (file);
  return hFile;
}


/* CreateHardLinkA ordinal = 61, argument = 12 temporary */
static DWORD WINAPI CreateHardLinkA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateHardLinkW ordinal = 62, argument = 12 temporary */
static DWORD WINAPI CreateHardLinkW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateIoCompletionPort ordinal = 63, argument = 16 temporary */
static DWORD WINAPI CreateIoCompletionPort (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateJobObjectA ordinal = 64, argument = 8 temporary */
static DWORD WINAPI CreateJobObjectA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateJobObjectW ordinal = 65, argument = 8 temporary */
static DWORD WINAPI CreateJobObjectW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateMailslotA ordinal = 66, argument = 16 temporary */
static DWORD WINAPI CreateMailslotA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMailslotW ordinal = 67, argument = 16 temporary */
static DWORD WINAPI CreateMailslotW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMutexA ordinal = 68, argument = 12 */
HANDLE WINAPI CreateMutexA (LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  HANDLE hMutex;

  utf8str = w32ldr_utf8_from_mb (lpName);
  utf16str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  hMutex = CreateMutexW (lpMutexAttributes, bInitialOwner, utf16str);
  g_free (utf16str);
  g_free (utf8str);
  return hMutex;
}


/* CreateMutexW ordinal = 69, argument = 12 */
HANDLE WINAPI CreateMutexW (LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner, LPCWSTR lpName)
{
  gchar *name;
  W32LdrHandle *w32handle = NULL;
  W32LdrSignal *w32signal = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  name = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  if (name && ghash_signal)
    w32signal = g_hash_table_lookup (ghash_signal, name);
  if (w32signal)
    {
      g_free (name);
      if (w32signal->max != 0)
        w32signal = NULL;
    }
  else
    {
      w32signal = g_malloc0 (sizeof (W32LdrSignal));
      w32signal->name = name;
      if (bInitialOwner)
        w32signal->count = 1;
#ifdef USE_THREAD
      if (!bInitialOwner)
        w32signal->gthread = g_thread_self ();
#endif /* USE_THREAD */
      if (name)
        {
          if (!ghash_signal)
            ghash_signal = g_hash_table_new (g_str_hash, g_str_equal);
          g_hash_table_insert (ghash_signal, name, w32signal);
        }
    }
  if (w32signal)
    {
      w32signal->counter++;
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->w32signal = w32signal;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* CreateNamedPipeA ordinal = 70, argument = 32 temporary */
static DWORD WINAPI CreateNamedPipeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* CreateNamedPipeW ordinal = 71, argument = 32 temporary */
static DWORD WINAPI CreateNamedPipeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* CreatePipe ordinal = 72, argument = 16 temporary */
static DWORD WINAPI CreatePipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateProcessA ordinal = 73, argument = 40 */
BOOL WINAPI CreateProcessA (LPCSTR lpApplicationName, LPSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCSTR lpCurrentDirectory, LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation)
{
  return FALSE;
}


/* CreateProcessInternalA ordinal = 74, argument = 0 temporary */
static DWORD WINAPI CreateProcessInternalA (VOID)
{
  return 0;
}


/* CreateProcessInternalW ordinal = 75, argument = 0 temporary */
static DWORD WINAPI CreateProcessInternalW (VOID)
{
  return 0;
}


/* CreateProcessInternalWSecure ordinal = 76, argument = 0 temporary */
static DWORD WINAPI CreateProcessInternalWSecure (VOID)
{
  return 0;
}


/* CreateProcessW ordinal = 77, argument = 40 */
BOOL WINAPI CreateProcessW (LPCWSTR lpApplicationName, LPWSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory, LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation)
{
  return FALSE;
}


/* CreateRemoteThread ordinal = 78, argument = 28 temporary */
static DWORD WINAPI CreateRemoteThread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateSemaphoreA ordinal = 79, argument = 16 */
HANDLE WINAPI CreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  HANDLE hSemaphre;

  utf8str = w32ldr_utf8_from_mb (lpName);
  utf16str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  hSemaphre = CreateSemaphoreW (lpSemaphoreAttributes,
                                    lInitialCount, lMaximumCount, utf16str);
  g_free (utf16str);
  g_free (utf8str);
  return hSemaphre;
}


/* CreateSemaphoreW ordinal = 80, argument = 16 */
HANDLE WINAPI CreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCWSTR lpName)
{
  gchar *name;
  W32LdrHandle *w32handle = NULL;
  W32LdrSignal *w32signal = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  name = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  if (name && ghash_signal)
    w32signal = g_hash_table_lookup (ghash_signal, name);
  if (w32signal)
    {
      g_free (name);
      if (w32signal->max <= 0)
        w32signal = NULL;
    }
  else if (0 <= lInitialCount && lInitialCount <= lMaximumCount
                                                        && lMaximumCount > 0)
    {
      w32signal = g_malloc0 (sizeof (W32LdrSignal));
      w32signal->name = name;
      w32signal->count = lInitialCount;
      w32signal->max = lMaximumCount;
      if (name)
        {
          if (!ghash_signal)
            ghash_signal = g_hash_table_new (g_str_hash, g_str_equal);
          g_hash_table_insert (ghash_signal, name, w32signal);
        }
    }
  if (w32signal)
    {
      w32signal->counter++;
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->w32signal = w32signal;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* CreateTapePartition ordinal = 81, argument = 16 temporary */
static DWORD WINAPI CreateTapePartition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


#ifdef USE_THREAD
typedef struct _W32LdrKernelThread
{
  LPTHREAD_START_ROUTINE lpStartAddress;
  LPVOID lpParameter;
} W32LdrKernelThread;


static gpointer
kernel32_StartAddress (W32LdrKernelThread *w32thread)
{
  DWORD dwResult;

  dwResult = w32thread->lpStartAddress (w32thread->lpParameter);
  g_free (w32thread);
  ExitThread (dwResult);
  return GUINT_TO_POINTER (dwResult);
}
#endif /* USE_THREAD */


/* CreateThread ordinal = 82, argument = 24 */
HANDLE WINAPI CreateThread (LPSECURITY_ATTRIBUTES lpThreadAttributes, DWORD dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId)
{
  W32LdrHandle *w32handle = INVALID_HANDLE_VALUE;
#ifdef USE_THREAD
  GThread *gthread;
  W32LdrKernelThread *w32thread;

  w32thread = g_malloc (sizeof (W32LdrKernelThread));
  w32thread->lpStartAddress = lpStartAddress;
  w32thread->lpParameter = lpParameter;
  gthread = g_thread_create ((GThreadFunc)kernel32_StartAddress,
                                                        w32thread, TRUE, NULL);
  if (lpThreadId)
    *lpThreadId = GPOINTER_TO_UINT (gthread);
  if (gthread)
    {
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->counter = 1;
      w32handle->priority = THREAD_PRIORITY_NORMAL;
      w32handle->gthread = gthread;
    }
#else /* not USE_THREAD */
  lpStartAddress (w32lpParameter);
  w32handle = g_malloc0 (sizeof (W32LdrHandle));
  w32handle->counter = 1;
  w32handle->priority = THREAD_PRIORITY_NORMAL;
#endif /* not USE_THREAD */
  return w32handle;
}


/* CreateTimerQueue ordinal = 83, argument = 0 temporary */
static DWORD WINAPI CreateTimerQueue (VOID)
{
  return 0;
}


/* CreateTimerQueueTimer ordinal = 84, argument = 28 temporary */
static DWORD WINAPI CreateTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateToolhelp32Snapshot ordinal = 85, argument = 8 temporary */
static DWORD WINAPI CreateToolhelp32Snapshot (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateVirtualBuffer ordinal = 86, argument = 0 temporary */
static DWORD WINAPI CreateVirtualBuffer (VOID)
{
  return 0;
}


/* CreateWaitableTimerA ordinal = 87, argument = 12 temporary */
static DWORD WINAPI CreateWaitableTimerA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateWaitableTimerW ordinal = 88, argument = 12 temporary */
static DWORD WINAPI CreateWaitableTimerW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DebugActiveProcess ordinal = 89, argument = 4 temporary */
static DWORD WINAPI DebugActiveProcess (DWORD dwArgv0)
{
  return 0;
}


/* DebugBreak ordinal = 90, argument = 0 temporary */
static DWORD WINAPI DebugBreak (VOID)
{
  return 0;
}


/* DefineDosDeviceA ordinal = 91, argument = 12 temporary */
static DWORD WINAPI DefineDosDeviceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DefineDosDeviceW ordinal = 92, argument = 12 temporary */
static DWORD WINAPI DefineDosDeviceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DelayLoadFailureHook ordinal = 93, argument = 0 temporary */
static DWORD WINAPI DelayLoadFailureHook (VOID)
{
  return 0;
}


/* DeleteAtom ordinal = 94, argument = 4 */
ATOM WINAPI DeleteAtom (ATOM nAtom)
{
  return GlobalDeleteAtom (nAtom);
}


/* DeleteCriticalSection ordinal = 95, argument = 4 */
VOID WINAPI DeleteCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_free ((GMutex *)lpCriticalSection);
}


/* DeleteFiber ordinal = 96, argument = 4 temporary */
static DWORD WINAPI DeleteFiber (DWORD dwArgv0)
{
  return 0;
}


/* DeleteFileA ordinal = 97, argument = 4 */
BOOL WINAPI DeleteFileA (LPCSTR lpFileName)
{
  gchar *file;
  gint result;

  file = w32ldr_filename_from_mb (lpFileName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_remove (file);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = remove (file);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (file);
  return result == 0;
}


/* DeleteFileW ordinal = 98, argument = 4 */
BOOL WINAPI DeleteFileW (LPCWSTR lpFileName)
{
  gchar *file;
  gint result;

  file = w32ldr_filename_from_wc (lpFileName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_remove (file);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = remove (file);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (file);
  return result == 0;
}


/* DeleteTimerQueue ordinal = 99, argument = 4 temporary */
static DWORD WINAPI DeleteTimerQueue (DWORD dwArgv0)
{
  return 0;
}


/* DeleteTimerQueueEx ordinal = 100, argument = 8 temporary */
static DWORD WINAPI DeleteTimerQueueEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DeleteTimerQueueTimer ordinal = 101, argument = 12 temporary */
static DWORD WINAPI DeleteTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DeleteVolumeMountPointA ordinal = 102, argument = 4 temporary */
static DWORD WINAPI DeleteVolumeMountPointA (DWORD dwArgv0)
{
  return 0;
}


/* DeleteVolumeMountPointW ordinal = 103, argument = 4 temporary */
static DWORD WINAPI DeleteVolumeMountPointW (DWORD dwArgv0)
{
  return 0;
}


/* DeviceIoControl ordinal = 104, argument = 32 temporary */
static DWORD WINAPI DeviceIoControl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* DisableThreadLibraryCalls ordinal = 105, argument = 4 */
BOOL WINAPI DisableThreadLibraryCalls (HMODULE hLibModule)
{
  return TRUE;
}


/* DisconnectNamedPipe ordinal = 106, argument = 4 temporary */
static DWORD WINAPI DisconnectNamedPipe (DWORD dwArgv0)
{
  return 0;
}


/* DnsHostnameToComputerNameA ordinal = 107, argument = 12 temporary */
static DWORD WINAPI DnsHostnameToComputerNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DnsHostnameToComputerNameW ordinal = 108, argument = 12 temporary */
static DWORD WINAPI DnsHostnameToComputerNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DosDateTimeToFileTime ordinal = 109, argument = 12 temporary */
static DWORD WINAPI DosDateTimeToFileTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DosPathToSessionPathA ordinal = 110, argument = 0 temporary */
static DWORD WINAPI DosPathToSessionPathA (VOID)
{
  return 0;
}


/* DosPathToSessionPathW ordinal = 111, argument = 0 temporary */
static DWORD WINAPI DosPathToSessionPathW (VOID)
{
  return 0;
}


/* DuplicateConsoleHandle ordinal = 112, argument = 0 temporary */
static DWORD WINAPI DuplicateConsoleHandle (VOID)
{
  return 0;
}


/* DuplicateHandle ordinal = 113, argument = 28 temporary */
static DWORD WINAPI DuplicateHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* EndUpdateResourceA ordinal = 114, argument = 8 temporary */
static DWORD WINAPI EndUpdateResourceA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EndUpdateResourceW ordinal = 115, argument = 8 temporary */
static DWORD WINAPI EndUpdateResourceW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnterCriticalSection ordinal = 116, argument = 4 */
VOID WINAPI EnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_lock ((GMutex *)lpCriticalSection);
}


/* EnumCalendarInfoA ordinal = 117, argument = 16 */
BOOL WINAPI EnumCalendarInfoA (CALINFO_ENUMPROCA lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType)
{
  return FALSE;
}


/* EnumCalendarInfoExA ordinal = 118, argument = 16 temporary */
static DWORD WINAPI EnumCalendarInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumCalendarInfoExW ordinal = 119, argument = 16 temporary */
static DWORD WINAPI EnumCalendarInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumCalendarInfoW ordinal = 120, argument = 16 */
BOOL WINAPI EnumCalendarInfoW (CALINFO_ENUMPROCW lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType)
{
  return FALSE;
}


/* EnumDateFormatsA ordinal = 121, argument = 12 temporary */
static DWORD WINAPI EnumDateFormatsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsExA ordinal = 122, argument = 12 temporary */
static DWORD WINAPI EnumDateFormatsExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsExW ordinal = 123, argument = 12 temporary */
static DWORD WINAPI EnumDateFormatsExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsW ordinal = 124, argument = 12 temporary */
static DWORD WINAPI EnumDateFormatsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumLanguageGroupLocalesA ordinal = 125, argument = 16 temporary */
static DWORD WINAPI EnumLanguageGroupLocalesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumLanguageGroupLocalesW ordinal = 126, argument = 16 temporary */
static DWORD WINAPI EnumLanguageGroupLocalesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceLanguagesA ordinal = 127, argument = 20 temporary */
static DWORD WINAPI EnumResourceLanguagesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumResourceLanguagesW ordinal = 128, argument = 20 temporary */
static DWORD WINAPI EnumResourceLanguagesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumResourceNamesA ordinal = 129, argument = 16 temporary */
static DWORD WINAPI EnumResourceNamesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceNamesW ordinal = 130, argument = 16 temporary */
static DWORD WINAPI EnumResourceNamesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceTypesA ordinal = 131, argument = 12 temporary */
static DWORD WINAPI EnumResourceTypesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumResourceTypesW ordinal = 132, argument = 12 temporary */
static DWORD WINAPI EnumResourceTypesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemCodePagesA ordinal = 133, argument = 8 temporary */
static DWORD WINAPI EnumSystemCodePagesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemCodePagesW ordinal = 134, argument = 8 temporary */
static DWORD WINAPI EnumSystemCodePagesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemLanguageGroupsA ordinal = 135, argument = 12 temporary */
static DWORD WINAPI EnumSystemLanguageGroupsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemLanguageGroupsW ordinal = 136, argument = 12 temporary */
static DWORD WINAPI EnumSystemLanguageGroupsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemLocalesA ordinal = 137, argument = 8 temporary */
static DWORD WINAPI EnumSystemLocalesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemLocalesW ordinal = 138, argument = 8 temporary */
static DWORD WINAPI EnumSystemLocalesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumTimeFormatsA ordinal = 139, argument = 12 temporary */
static DWORD WINAPI EnumTimeFormatsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumTimeFormatsW ordinal = 140, argument = 12 temporary */
static DWORD WINAPI EnumTimeFormatsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumUILanguagesA ordinal = 141, argument = 12 temporary */
static DWORD WINAPI EnumUILanguagesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumUILanguagesW ordinal = 142, argument = 12 temporary */
static DWORD WINAPI EnumUILanguagesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EraseTape ordinal = 143, argument = 12 temporary */
static DWORD WINAPI EraseTape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EscapeCommFunction ordinal = 144, argument = 8 temporary */
static DWORD WINAPI EscapeCommFunction (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExitProcess ordinal = 145, argument = 4 */
VOID WINAPI ExitProcess (UINT uExitCode)
{
  exit (uExitCode);
}


static void
kernel32_ExitThread (gpointer key,
                     gpointer value,
                     gpointer user_data)
{
  W32LdrSignal *w32signal;

  w32signal = value;
#ifdef USE_THREAD
  if (w32signal->gthread == user_data)
    {
      if (!w32signal->manual)
        w32signal->count = 1;
      w32signal->gthread = NULL;
    }
#else /* not USE_THREAD */
  if (!w32signal->manual)
    w32signal->count = 1;
#endif /* not USE_THREAD */
}


/* ExitThread ordinal = 146, argument = 4 */
VOID WINAPI ExitThread (UINT uExitCode)
{
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;

  if (ghash_signal)
    g_hash_table_foreach (ghash_signal, kernel32_ExitThread, g_thread_self ());

  critical = FALSE;
  G_UNLOCK (critical);

  g_thread_exit (GUINT_TO_POINTER (uExitCode));
#else /* not USE_THREAD */
  if (ghash_signal)
    g_hash_table_foreach (ghash_signal, kernel32_ExitThread, NULL);
#endif /* not USE_THREAD */
}


/* ExitVDM ordinal = 147, argument = 0 temporary */
static DWORD WINAPI ExitVDM (VOID)
{
  return 0;
}


/* ExpandEnvironmentStringsA ordinal = 148, argument = 12 temporary */
static DWORD WINAPI ExpandEnvironmentStringsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExpandEnvironmentStringsW ordinal = 149, argument = 12 temporary */
static DWORD WINAPI ExpandEnvironmentStringsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExpungeConsoleCommandHistoryA ordinal = 150, argument = 0 temporary */
static DWORD WINAPI ExpungeConsoleCommandHistoryA (VOID)
{
  return 0;
}


/* ExpungeConsoleCommandHistoryW ordinal = 151, argument = 0 temporary */
static DWORD WINAPI ExpungeConsoleCommandHistoryW (VOID)
{
  return 0;
}


/* ExtendVirtualBuffer ordinal = 152, argument = 0 temporary */
static DWORD WINAPI ExtendVirtualBuffer (VOID)
{
  return 0;
}


/* FatalAppExitA ordinal = 153, argument = 8 temporary */
static DWORD WINAPI FatalAppExitA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FatalAppExitW ordinal = 154, argument = 8 temporary */
static DWORD WINAPI FatalAppExitW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FatalExit ordinal = 155, argument = 4 temporary */
static DWORD WINAPI FatalExit (DWORD dwArgv0)
{
  return 0;
}


/* FileTimeToDosDateTime ordinal = 156, argument = 12 temporary */
static DWORD WINAPI FileTimeToDosDateTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FileTimeToLocalFileTime ordinal = 157, argument = 8 */
BOOL WINAPI FileTimeToLocalFileTime (LPCFILETIME lpFileTime, LPFILETIME lpLocalFileTime)
{
  *lpLocalFileTime = *lpFileTime;
  return TRUE;
}


/* FileTimeToSystemTime ordinal = 158, argument = 8 */
BOOL WINAPI FileTimeToSystemTime (LPCFILETIME lpFileTime, LPSYSTEMTIME lpSystemTime)
{
  gulonglong t;
  gint days[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  if (!lpFileTime || !lpSystemTime)
    return FALSE;
  t = ((gulonglong)lpFileTime->dwHighDateTime << 32)
                                    + (gulonglong)lpFileTime->dwLowDateTime;
  lpSystemTime->wMilliseconds = t % 10000000 / 10000;
  t /= 10000000;/* ja:tは1601年1月1日からの秒数 */
  lpSystemTime->wSecond = t % 60;
  t /= 60;
  lpSystemTime->wMinute = t % 60;
  t /= 60;
  lpSystemTime->wHour = t % 24;
  t /= 24;/* ja:tは1601年1月1日からの日数 */
  lpSystemTime->wDayOfWeek = (t + 1) % 7;/* ja:1601年1月1日は月曜日 */
  lpSystemTime->wYear = t / (365 * 400 + 97) * 400 + 1601;/* ja:400年単位 */
  t %= (365 * 400 + 97);
  lpSystemTime->wYear += t / (365 * 100 + 24) * 100;/* ja:100年単位 */
  t %= (365 * 100 + 24);
  lpSystemTime->wYear += t / (365 * 4 + 1) * 4;/* ja:4年単位 */
  t %= (365 * 4 + 1);
  if (t / 365 < 4)
    {
      lpSystemTime->wYear += t / 365;
      t %= 365;
    }
  else
    {
      lpSystemTime->wYear += 3;
      t -= 365 * 3;
    }
  days[1] = (lpSystemTime->wYear % 4 == 0 && lpSystemTime->wYear % 100 != 0)
                                    && lpSystemTime->wYear % 400 == 0 ? 29 :28;
  for (lpSystemTime->wMonth = 0; lpSystemTime->wMonth < 12;
                                                        lpSystemTime->wMonth++)
    {
      if (t < days[lpSystemTime->wMonth])
        break;
      t -= days[lpSystemTime->wMonth];
    }
  lpSystemTime->wMonth++;
  lpSystemTime->wDay++;
  return TRUE;
}


/* FillConsoleOutputAttribute ordinal = 159, argument = 20 temporary */
static DWORD WINAPI FillConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FillConsoleOutputCharacterA ordinal = 160, argument = 20 temporary */
static DWORD WINAPI FillConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FillConsoleOutputCharacterW ordinal = 161, argument = 20 temporary */
static DWORD WINAPI FillConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FindAtomA ordinal = 162, argument = 4 */
ATOM WINAPI FindAtomA (LPCSTR lpString)
{
  return GlobalFindAtomA (lpString);
}


/* FindAtomW ordinal = 163, argument = 4 */
ATOM WINAPI FindAtomW (LPCWSTR lpString)
{
  return GlobalFindAtomW (lpString);
}


typedef struct _W32LdrFind
{
  GList *glist;
} W32LdrFind;
typedef struct _W32LdrFindFile
{
  gchar *name;
  DWORD dwAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeLow;
  DWORD nFileSizeHigh;
} W32LdrFindFile;


/* FindClose ordinal = 164, argument = 4 */
BOOL WINAPI FindClose (HANDLE hFind)
{
  if (!hFind || hFind == INVALID_HANDLE_VALUE)
    return FALSE;
  while (((W32LdrFind *)hFind)->glist)
    {
      W32LdrFindFile *findfile;

      findfile = ((W32LdrFind *)hFind)->glist->data;
      g_free (findfile->name);
      g_free (findfile);
      ((W32LdrFind *)hFind)->glist
                    = g_list_remove (((W32LdrFind *)hFind)->glist, findfile);
    }
  return TRUE;
}


/* FindCloseChangeNotification ordinal = 165, argument = 4 temporary */
static DWORD WINAPI FindCloseChangeNotification (DWORD dwArgv0)
{
  return 0;
}


/* FindFirstChangeNotificationA ordinal = 166, argument = 12 temporary */
static DWORD WINAPI FindFirstChangeNotificationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstChangeNotificationW ordinal = 167, argument = 12 temporary */
static DWORD WINAPI FindFirstChangeNotificationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


static DWORD
kernel32_file_get_attributes (const gchar *file)
{
  gchar *name;
  gint result;
  struct stat buf;
  DWORD dwResult;

  name = g_path_get_basename (file);
  dwResult = name && g_strcmp (name, ".") != 0 && g_strcmp (name, "..") != 0
                                && name[0] == '.' ? FILE_ATTRIBUTE_HIDDEN : 0;
  g_free (name);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_stat (file, &buf);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = stat (file, &buf);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  if (result != 0)
    return 0xffffffff;
  if (S_ISREG (buf.st_mode))
    dwResult |= FILE_ATTRIBUTE_DIRECTORY;
  if (!(buf.st_mode & S_IWUSR))
    dwResult |= FILE_ATTRIBUTE_READONLY;
  if (!(buf.st_mode & S_IRUSR))
    dwResult |= FILE_ATTRIBUTE_SYSTEM;
  return dwResult;
}


static BOOL
kernel32_file_get_time (const gchar *file,
                        LPFILETIME lpCreationTime,
                        LPFILETIME lpLastAccessTime,
                        LPFILETIME lpLastWriteTime)
{
  FileIOTime atime, mtime;

  if (!file || !fileio_gettime (file, &atime, &mtime))
    return FALSE;
  if (lpCreationTime)
    {
      FileIOSysTime stime;
      SYSTEMTIME st;

      fileio_getsystime (&mtime, &stime);
      st.wYear         = stime.year;
      st.wMonth        = stime.mon;
      st.wDayOfWeek    = stime.wday;
      st.wDay          = stime.mday;
      st.wHour         = stime.hour;
      st.wMinute       = stime.min;
      st.wSecond       = stime.sec;
      st.wMilliseconds = 0;
      SystemTimeToFileTime (&st, lpCreationTime);
    }
  if (lpLastWriteTime)
    {
      FileIOSysTime stime;
      SYSTEMTIME st;

      fileio_getsystime (&mtime, &stime);
      st.wYear         = stime.year;
      st.wMonth        = stime.mon;
      st.wDayOfWeek    = stime.wday;
      st.wDay          = stime.mday;
      st.wHour         = stime.hour;
      st.wMinute       = stime.min;
      st.wSecond       = stime.sec;
      st.wMilliseconds = 0;
      SystemTimeToFileTime (&st, lpLastWriteTime);
    }
  if (lpLastWriteTime)
    {
      FileIOSysTime stime;
      SYSTEMTIME st;

      fileio_getsystime (&mtime, &stime);
      st.wYear         = stime.year;
      st.wMonth        = stime.mon;
      st.wDayOfWeek    = stime.wday;
      st.wDay          = stime.mday;
      st.wHour         = stime.hour;
      st.wMinute       = stime.min;
      st.wSecond       = stime.sec;
      st.wMilliseconds = 0;
      SystemTimeToFileTime (&st, lpLastWriteTime);
    }
  return TRUE;
}


static BOOL
kernel32_file_get_size (const gchar *file,
                        LPDWORD      nFileSizeLow,
                        LPDWORD      nFileSizeHigh)
{
  gint result;
  struct stat buf;

#if GLIB_CHECK_VERSION(2,6,0)
  result = g_stat (file, &buf);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = stat (file, &buf);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  if (result != 0)
    return FALSE;
  if (nFileSizeLow)
    *nFileSizeLow = buf.st_size;
  if (nFileSizeHigh)
    *nFileSizeHigh = 0;
  return TRUE;
}


static W32LdrFind *
kernel32_find_first_file (const gchar *file)
{
  gchar *path;
  GDir *dir;
  W32LdrFind *find;

  path = g_path_get_dirname (file);
  dir = g_dir_open (path, 0, NULL);
  find = g_malloc0 (sizeof (W32LdrFind));
  if (dir)
    {
      gchar *utf8str, *pattern, *tmp;
      const gchar *name;
      GPatternSpec *pspec;

      tmp = g_path_get_basename (file);
      utf8str = tmp ? g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL) : NULL;
      g_free (tmp);
      pattern = utf8str ? g_utf8_strdown (utf8str, -1) : NULL;
      g_free (utf8str);
      pspec = g_pattern_spec_new (pattern);
      g_free (pattern);
      if (g_strcmp (path, "/") != 0)
        {
          if (g_pattern_match_string (pspec, "."))
            {
              W32LdrFindFile *findfile;

              findfile = g_malloc0 (sizeof (W32LdrFindFile));
              findfile->name = g_strdup (".");
              findfile->dwAttributes = FILE_ATTRIBUTE_DIRECTORY;
              find->glist = g_list_append (find->glist, findfile);
            }
          if (g_pattern_match_string (pspec, ".."))
            {
              W32LdrFindFile *findfile;

              findfile = g_malloc0 (sizeof (W32LdrFindFile));
              findfile->name = g_strdup ("..");
              findfile->dwAttributes = FILE_ATTRIBUTE_DIRECTORY;
              find->glist = g_list_append (find->glist, findfile);
            }
        }
      while ((name = g_dir_read_name (dir)))
        {
          tmp = g_filename_to_utf8 (name, -1, NULL, NULL, NULL);
          utf8str = tmp ? g_utf8_strdown (tmp, -1) : NULL;
          g_free (tmp);
          if (g_pattern_match_string (pspec, utf8str))
            {
              gchar *filename;
              W32LdrFindFile *findfile;

              filename = g_build_filename (path, name, NULL);
              findfile = g_malloc (sizeof (W32LdrFindFile));
              findfile->name = g_strdup (name);
              findfile->dwAttributes = kernel32_file_get_attributes (filename);
              kernel32_file_get_time (filename, &findfile->ftCreationTime,
                                                &findfile->ftLastAccessTime,
                                                &findfile->ftLastWriteTime);
              kernel32_file_get_size (filename, &findfile->nFileSizeLow,
                                                &findfile->nFileSizeHigh);
              g_free (filename);
              find->glist = g_list_append (find->glist, findfile);
            }
          g_free (utf8str);
        }
      g_pattern_spec_free (pspec);
      g_dir_close (dir);
    }
  g_free (path);
  return find;
}


/* FindFirstFileA ordinal = 168, argument = 8 */
HANDLE WINAPI FindFirstFileA (LPCSTR lpFileName, LPWIN32_FIND_DATAA lpFindFileData)
{
  gchar *file;
  W32LdrFind *find;

  file = w32ldr_filename_from_mb (lpFileName);
  find = kernel32_find_first_file (file);
  g_free (file);
  if (!FindNextFileA (find, lpFindFileData))
    {
      g_free (find);
      find = INVALID_HANDLE_VALUE;
    }
  return find;
}


/* FindFirstFileExA ordinal = 169, argument = 24 temporary */
static DWORD WINAPI FindFirstFileExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* FindFirstFileExW ordinal = 170, argument = 24 temporary */
static DWORD WINAPI FindFirstFileExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* FindFirstFileW ordinal = 171, argument = 8 */
HANDLE WINAPI FindFirstFileW (LPCWSTR lpFileName, LPWIN32_FIND_DATAW lpFindFileData)
{
  gchar *file;
  W32LdrFind *find;

  file = w32ldr_filename_from_wc (lpFileName);
  find = kernel32_find_first_file (file);
  g_free (file);
  if (!FindNextFileW (find, lpFindFileData))
    {
      g_free (find);
      find = INVALID_HANDLE_VALUE;
    }
  return find;
}


/* FindFirstVolumeA ordinal = 172, argument = 8 temporary */
static DWORD WINAPI FindFirstVolumeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindFirstVolumeMountPointA ordinal = 173, argument = 12 temporary */
static DWORD WINAPI FindFirstVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstVolumeMountPointW ordinal = 174, argument = 12 temporary */
static DWORD WINAPI FindFirstVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstVolumeW ordinal = 175, argument = 8 temporary */
static DWORD WINAPI FindFirstVolumeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindNextChangeNotification ordinal = 176, argument = 4 temporary */
static DWORD WINAPI FindNextChangeNotification (DWORD dwArgv0)
{
  return 0;
}


/* FindNextFileA ordinal = 177, argument = 8 */
BOOL WINAPI FindNextFileA (HANDLE hFind, LPWIN32_FIND_DATAA lpFindFileData)
{
  gchar *mb;
  W32LdrFindFile *findfile;

  if (!hFind || hFind == INVALID_HANDLE_VALUE || !((W32LdrFind *)hFind)->glist
                        || !(findfile = ((W32LdrFind *)hFind)->glist->data))
    return FALSE;
  g_memset (lpFindFileData, 0, sizeof (WIN32_FIND_DATAA));
  lpFindFileData->dwFileAttributes = findfile->dwAttributes;
  lpFindFileData->ftCreationTime = findfile->ftCreationTime;
  lpFindFileData->ftLastAccessTime = findfile->ftLastAccessTime;
  lpFindFileData->ftLastWriteTime = findfile->ftLastWriteTime;
  lpFindFileData->nFileSizeLow = findfile->nFileSizeLow;
  lpFindFileData->nFileSizeHigh = findfile->nFileSizeHigh;
  mb = w32ldr_filename_to_mb (findfile->name);
  g_strcpy (lpFindFileData->cFileName, mb);
  g_free (mb);
  g_free (findfile->name);
  g_free (findfile);
  ((W32LdrFind *)hFind)->glist = g_list_remove (((W32LdrFind *)hFind)->glist,
                                                                    findfile);
  return TRUE;
}


/* FindNextFileW ordinal = 178, argument = 8 */
BOOL WINAPI FindNextFileW (HANDLE hFind, LPWIN32_FIND_DATAW lpFindFileData)
{
  gunichar2 *wc;
  W32LdrFindFile *findfile;

  if (!hFind || hFind == INVALID_HANDLE_VALUE || !((W32LdrFind *)hFind)->glist
                        || !(findfile = ((W32LdrFind *)hFind)->glist->data))
    return FALSE;
  g_memset (lpFindFileData, 0, sizeof (WIN32_FIND_DATAW));
  lpFindFileData->dwFileAttributes = findfile->dwAttributes;
  lpFindFileData->ftCreationTime = findfile->ftCreationTime;
  lpFindFileData->ftLastAccessTime = findfile->ftLastAccessTime;
  lpFindFileData->ftLastWriteTime = findfile->ftLastWriteTime;
  lpFindFileData->nFileSizeLow = findfile->nFileSizeLow;
  lpFindFileData->nFileSizeHigh = findfile->nFileSizeHigh;
  wc = w32ldr_filename_to_wc (findfile->name);
  lstrcpyW (lpFindFileData->cFileName, wc);
  g_free (wc);
  g_free (findfile->name);
  g_free (findfile);
  ((W32LdrFind *)hFind)->glist = g_list_remove (((W32LdrFind *)hFind)->glist,
                                                                    findfile);
  return TRUE;
}


/* FindNextVolumeA ordinal = 179, argument = 12 temporary */
static DWORD WINAPI FindNextVolumeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeMountPointA ordinal = 180, argument = 12 temporary */
static DWORD WINAPI FindNextVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeMountPointW ordinal = 181, argument = 12 temporary */
static DWORD WINAPI FindNextVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeW ordinal = 182, argument = 12 temporary */
static DWORD WINAPI FindNextVolumeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindResourceA ordinal = 183, argument = 12 */
HRSRC WINAPI FindResourceA (HMODULE hModule, LPCSTR lpName, LPCSTR lpType)
{
  guint16 langid, primary, secondary;
  HRSRC hRsrc;

  langid = GetUserDefaultUILanguage ();
  hRsrc = FindResourceExA (hModule, lpType, lpName, langid);
  if (hRsrc)
    return hRsrc;
  primary = PRIMARYLANGID (langid);
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExA (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  primary = LANG_ENGLISH;
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExA (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  for (primary = 0; primary < 0x400; primary++)
    for (secondary = 0; secondary < 0x40; secondary++)
      if ((hRsrc = FindResourceExA (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
        return hRsrc;
  return NULL;
}


/* FindResourceExA ordinal = 184, argument = 16 */
HRSRC WINAPI FindResourceExA (HMODULE hModule, LPCSTR lpType, LPCSTR lpName, WORD wLanguage)
{
  gconstpointer data = NULL;

  if (hModule)
    {
      gchar *buf, *key;

      if (IS_INTRESOURCE (lpType))
        {
          buf = g_strdup_printf ("/0x%x", GPOINTER_TO_INT (lpType));
        }
      else
        {
          gchar *utf8str, *tmp;

          utf8str = w32ldr_utf8_from_mb (lpType);
          tmp = utf8str ? g_utf8_strup (utf8str, -1) : g_strdup ("");
          g_free (utf8str);
          buf = g_strdup_printf ("/%s", tmp);
          g_free (tmp);
        }
      if (IS_INTRESOURCE (lpName))
        {
          key = g_strdup_printf ("%s/0x%x/0x%x",
                                    buf, GPOINTER_TO_INT (lpName), wLanguage);
        }
      else
        {
          gchar *utf8str, *tmp;

          utf8str = w32ldr_utf8_from_mb (lpName);
          tmp = utf8str ? g_utf8_strup (utf8str, -1) : g_strdup ("");
          g_free (utf8str);
          key = g_strdup_printf ("%s/%s/0x%x", buf, tmp, wLanguage);
          g_free (tmp);
        }
      g_free (buf);
      data = peimage_file_get_resource ((const guint8 *)hModule, key);
      g_free (key);
    }
  return data;
}


/* FindResourceExW ordinal = 185, argument = 16 */
HRSRC WINAPI FindResourceExW (HMODULE hModule, LPCWSTR lpType, LPCWSTR lpName, WORD wLanguage)
{
  gconstpointer data = NULL;

  if (hModule)
    {
      gchar *buf, *key;

      if (IS_INTRESOURCE (lpType))
        {
          buf = g_strdup_printf ("/0x%x", GPOINTER_TO_INT (lpType));
        }
      else
        {
          gchar *utf8str, *tmp;

          utf8str = g_utf16_to_utf8 (lpType, -1, NULL, NULL, NULL);
          tmp = utf8str ? g_utf8_strup (utf8str, -1) : g_strdup ("");
          g_free (utf8str);
          buf = g_strdup_printf ("/%s", tmp);
          g_free (tmp);
        }
      if (IS_INTRESOURCE (lpName))
        {
          key = g_strdup_printf ("%s/0x%x/0x%x",
                                    buf, GPOINTER_TO_INT (lpName), wLanguage);
        }
      else
        {
          gchar *utf8str, *tmp;

          utf8str = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
          tmp = utf8str ? g_utf8_strup (utf8str, -1) : g_strdup ("");
          g_free (utf8str);
          key = g_strdup_printf ("%s/%s/0x%x", buf, tmp, wLanguage);
          g_free (tmp);
        }
      g_free (buf);
      data = peimage_file_get_resource ((const guint8 *)hModule, key);
      g_free (key);
    }
  return data;
}


/* FindResourceW ordinal = 186, argument = 12 */
HRSRC WINAPI FindResourceW (HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType)
{
  guint16 langid, primary, secondary;
  HRSRC hRsrc;

  langid = GetUserDefaultUILanguage ();
  hRsrc = FindResourceExW (hModule, lpType, lpName, langid);
  if (hRsrc)
    return hRsrc;
  primary = PRIMARYLANGID (langid);
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExW (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  primary = LANG_ENGLISH;
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExW (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  for (primary = 0; primary < 0x400; primary++)
    for (secondary = 0; secondary < 0x40; secondary++)
      if ((hRsrc = FindResourceExW (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
        return hRsrc;
  return NULL;
}


/* FindVolumeClose ordinal = 187, argument = 4 temporary */
static DWORD WINAPI FindVolumeClose (DWORD dwArgv0)
{
  return 0;
}


/* FindVolumeMountPointClose ordinal = 188, argument = 4 temporary */
static DWORD WINAPI FindVolumeMountPointClose (DWORD dwArgv0)
{
  return 0;
}


/* FlushConsoleInputBuffer ordinal = 189, argument = 4 temporary */
static DWORD WINAPI FlushConsoleInputBuffer (DWORD dwArgv0)
{
  return 0;
}


/* FlushFileBuffers ordinal = 190, argument = 4 */
BOOL WINAPI FlushFileBuffers (HANDLE hFile)
{
  return TRUE;
}


/* FlushInstructionCache ordinal = 191, argument = 12 temporary */
static DWORD WINAPI FlushInstructionCache (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FlushViewOfFile ordinal = 192, argument = 8 temporary */
static DWORD WINAPI FlushViewOfFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FoldStringA ordinal = 193, argument = 20 temporary */
static DWORD WINAPI FoldStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FoldStringW ordinal = 194, argument = 20 temporary */
static DWORD WINAPI FoldStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FormatMessageA ordinal = 195, argument = 28 temporary */
static DWORD WINAPI FormatMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* FormatMessageW ordinal = 196, argument = 28 temporary */
static DWORD WINAPI FormatMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* FreeConsole ordinal = 197, argument = 0 temporary */
static DWORD WINAPI FreeConsole (VOID)
{
  return 0;
}


/* FreeEnvironmentStringsA ordinal = 198, argument = 4 */
BOOL WINAPI FreeEnvironmentStringsA (LPSTR lpszEnvironmentBlock)
{
  if (!lpszEnvironmentBlock)
    return FALSE;
  g_free (lpszEnvironmentBlock);
  return TRUE;
}


/* FreeEnvironmentStringsW ordinal = 199, argument = 4 */
BOOL WINAPI FreeEnvironmentStringsW (LPWSTR lpszEnvironmentBlock)
{
  if (!lpszEnvironmentBlock)
    return FALSE;
  g_free (lpszEnvironmentBlock);
  return TRUE;
}


/* FreeLibrary ordinal = 200, argument = 4 */
BOOL WINAPI FreeLibrary (HMODULE hModule)
{
  return w32ldr_module_free (hModule);
}


/* FreeLibraryAndExitThread ordinal = 201, argument = 8 temporary */
static DWORD WINAPI FreeLibraryAndExitThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FreeResource ordinal = 202, argument = 4 */
BOOL WINAPI FreeResource (HGLOBAL hResData)
{
  return TRUE;
}


/* FreeUserPhysicalPages ordinal = 203, argument = 12 temporary */
static DWORD WINAPI FreeUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FreeVirtualBuffer ordinal = 204, argument = 0 temporary */
static DWORD WINAPI FreeVirtualBuffer (VOID)
{
  return 0;
}


/* GenerateConsoleCtrlEvent ordinal = 205, argument = 8 temporary */
static DWORD WINAPI GenerateConsoleCtrlEvent (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetACP ordinal = 206, argument = 0 */
UINT WINAPI GetACP (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = kernel32_nls_get_information ();
  return nls_info->acp == 0 ? 1252 : nls_info->acp;
}


/* GetAtomNameA ordinal = 207, argument = 12 */
UINT WINAPI GetAtomNameA (ATOM nAtom, LPSTR lpBuffer, INT nSize)
{
  return GlobalGetAtomNameA (nAtom, lpBuffer, nSize);
}


/* GetAtomNameW ordinal = 208, argument = 12 */
UINT WINAPI GetAtomNameW (ATOM nAtom, LPWSTR lpBuffer, INT nSize)
{
  return GlobalGetAtomNameW (nAtom, lpBuffer, nSize);
}


/* GetBinaryType ordinal = 209, argument = 8 temporary */
/* DWORD WINAPI GetBinaryType (DWORD dwArgv0, DWORD dwArgv1) */


/* GetBinaryTypeA ordinal = 210, argument = 8 temporary */
static DWORD WINAPI GetBinaryTypeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBinaryTypeW ordinal = 211, argument = 8 temporary */
static DWORD WINAPI GetBinaryTypeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCPInfo ordinal = 212, argument = 8 */
BOOL WINAPI GetCPInfo (UINT CodePage, LPCPINFO lpCPInfo)
{
  gint i;
  CPINFOEXA CPInfoExA;

  if (!lpCPInfo || !GetCPInfoExA (CodePage, 0, &CPInfoExA))
    return FALSE;
  lpCPInfo->MaxCharSize = CPInfoExA.MaxCharSize;
  for (i = 0; i < MAX_DEFAULTCHAR; i++)
    lpCPInfo->DefaultChar[i] = CPInfoExA.DefaultChar[i];
  for (i = 0; i < MAX_LEADBYTES; i++)
    lpCPInfo->LeadByte[i] = CPInfoExA.LeadByte[i];
  return TRUE;
}


/* GetCPInfoExA ordinal = 213, argument = 12 */
BOOL WINAPI GetCPInfoExA (UINT CodePage, DWORD dwFlags, LPCPINFOEXA lpCPInfoEx)
{
  if (!lpCPInfoEx)
    return FALSE;
  g_memset (lpCPInfoEx, 0, sizeof (CPINFOEXA));
  lpCPInfoEx->DefaultChar[0] = '?';
  lpCPInfoEx->UnicodeDefaultChar = '?';
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP: lpCPInfoEx->CodePage = GetACP (); break;
      case CP_OEMCP: lpCPInfoEx->CodePage = GetOEMCP (); break;
      default:       lpCPInfoEx->CodePage = CodePage;
    }
  switch (lpCPInfoEx->CodePage)
    {
      case  437: g_strcpy (lpCPInfoEx->CodePageName, "US (OEM)"); break;
      case  720: g_strcpy (lpCPInfoEx->CodePageName, "Arabic (OEM)"); break;
      case  737: g_strcpy (lpCPInfoEx->CodePageName, "Greek (OEM)"); break;
      case  775: g_strcpy (lpCPInfoEx->CodePageName, "Baltic (OEM)"); break;
      case  850: g_strcpy (lpCPInfoEx->CodePageName, "Multilingual Latin I (OEM)"); break;
      case  852: g_strcpy (lpCPInfoEx->CodePageName, "Latin II (OEM)"); break;
      case  855: g_strcpy (lpCPInfoEx->CodePageName, "Cyrillic (OEM)"); break;
      case  857: g_strcpy (lpCPInfoEx->CodePageName, "Turkish (OEM)"); break;
      case  858: g_strcpy (lpCPInfoEx->CodePageName, "Multilingual Latin I + Euro (OEM)"); break;
      case  862: g_strcpy (lpCPInfoEx->CodePageName, "Hebrew (OEM)"); break;
      case  866: g_strcpy (lpCPInfoEx->CodePageName, "Russian (OEM)"); break;
      case  874: g_strcpy (lpCPInfoEx->CodePageName, "Thai"); break;
      case  932: g_strcpy (lpCPInfoEx->CodePageName, "Japanese Shift-JIS"); break;
      case  936: g_strcpy (lpCPInfoEx->CodePageName, "Simplified Chinese GBK"); break;
      case  949: g_strcpy (lpCPInfoEx->CodePageName, "Korean"); break;
      case  950: g_strcpy (lpCPInfoEx->CodePageName, "Traditional Chinese Big5"); break;
      case 1250: g_strcpy (lpCPInfoEx->CodePageName, "Central Europe"); break;
      case 1251: g_strcpy (lpCPInfoEx->CodePageName, "Cyrillic"); break;
      case 1252: g_strcpy (lpCPInfoEx->CodePageName, "Latin I"); break;
      case 1253: g_strcpy (lpCPInfoEx->CodePageName, "Greek"); break;
      case 1254: g_strcpy (lpCPInfoEx->CodePageName, "Turkish"); break;
      case 1255: g_strcpy (lpCPInfoEx->CodePageName, "Hebrew"); break;
      case 1256: g_strcpy (lpCPInfoEx->CodePageName, "Arabic"); break;
      case 1257: g_strcpy (lpCPInfoEx->CodePageName, "Baltic"); break;
      case 1258: g_strcpy (lpCPInfoEx->CodePageName, "Vietnam"); break;
      default:   g_strcpy (lpCPInfoEx->CodePageName, "Latin I"); lpCPInfoEx->CodePage = 1252;
    }
  switch (lpCPInfoEx->CodePage)
    {
      case  932:
        lpCPInfoEx->MaxCharSize = 2;
        lpCPInfoEx->LeadByte[0] = 0x81; lpCPInfoEx->LeadByte[1] = 0x9f;
        lpCPInfoEx->LeadByte[2] = 0xe0; lpCPInfoEx->LeadByte[3] = 0xfc;
        break;
      case  936:
      case  949:
      case  950:
        lpCPInfoEx->MaxCharSize = 2;
        lpCPInfoEx->LeadByte[0] = 0x81; lpCPInfoEx->LeadByte[1] = 0xfe;
        break;
      default:
        lpCPInfoEx->MaxCharSize = 1;
    }
  return TRUE;
}


/* GetCPInfoExW ordinal = 214, argument = 12 */
BOOL WINAPI GetCPInfoExW (UINT CodePage, DWORD dwFlags, LPCPINFOEXW lpCPInfoEx)
{
  gint i;
  CPINFOEXA CPInfoExA;

  if (!lpCPInfoEx || !GetCPInfoExA (CodePage, dwFlags, &CPInfoExA))
    return FALSE;
  lpCPInfoEx->MaxCharSize = CPInfoExA.MaxCharSize;
  for (i = 0; i < MAX_DEFAULTCHAR; i++)
    lpCPInfoEx->DefaultChar[i] = CPInfoExA.DefaultChar[i];
  for (i = 0; i < MAX_LEADBYTES; i++)
    lpCPInfoEx->LeadByte[i] = CPInfoExA.LeadByte[i];
  lpCPInfoEx->UnicodeDefaultChar = CPInfoExA.UnicodeDefaultChar;
  lpCPInfoEx->CodePage = CPInfoExA.CodePage;
  for (i = 0; i < MAX_PATH; i++)
    lpCPInfoEx->CodePageName[i] = CPInfoExA.CodePageName[i];
  return TRUE;
}


/* GetCalendarInfoA ordinal = 215, argument = 24 temporary */
static DWORD WINAPI GetCalendarInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCalendarInfoW ordinal = 216, argument = 24 temporary */
static DWORD WINAPI GetCalendarInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCommConfig ordinal = 217, argument = 12 temporary */
static DWORD WINAPI GetCommConfig (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetCommMask ordinal = 218, argument = 8 temporary */
static DWORD WINAPI GetCommMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommModemStatus ordinal = 219, argument = 8 temporary */
static DWORD WINAPI GetCommModemStatus (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommProperties ordinal = 220, argument = 8 temporary */
static DWORD WINAPI GetCommProperties (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommState ordinal = 221, argument = 8 temporary */
static DWORD WINAPI GetCommState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommTimeouts ordinal = 222, argument = 8 temporary */
static DWORD WINAPI GetCommTimeouts (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommandLineA ordinal = 223, argument = 0 */
LPSTR WINAPI GetCommandLineA (VOID)
{
  static gchar *prgname = NULL;

  if (!prgname)
    {
      gchar *tmp;

      tmp = g_get_prgname ();
      prgname = w32ldr_utf8_to_mb (tmp);
      g_free (tmp);
    }
  return prgname;
}


/* GetCommandLineW ordinal = 224, argument = 0 */
LPWSTR WINAPI GetCommandLineW (VOID)
{
  static gunichar2 *prgname = NULL;

  if (!prgname)
    {
      gchar *tmp;

      tmp = g_get_prgname ();
      prgname = tmp ? g_utf8_to_utf16 (tmp, -1, NULL, NULL, NULL) : NULL;
      g_free (tmp);
    }
  return prgname;
}


/* GetCompressedFileSizeA ordinal = 225, argument = 8 temporary */
static DWORD WINAPI GetCompressedFileSizeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCompressedFileSizeW ordinal = 226, argument = 8 temporary */
static DWORD WINAPI GetCompressedFileSizeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetComputerNameA ordinal = 227, argument = 8 temporary */
static DWORD WINAPI GetComputerNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetComputerNameExA ordinal = 228, argument = 12 temporary */
static DWORD WINAPI GetComputerNameExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetComputerNameExW ordinal = 229, argument = 12 temporary */
static DWORD WINAPI GetComputerNameExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetComputerNameW ordinal = 230, argument = 8 temporary */
static DWORD WINAPI GetComputerNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasA ordinal = 231, argument = 16 temporary */
static DWORD WINAPI GetConsoleAliasA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetConsoleAliasExesA ordinal = 232, argument = 8 temporary */
static DWORD WINAPI GetConsoleAliasExesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasExesLengthA ordinal = 233, argument = 0 temporary */
static DWORD WINAPI GetConsoleAliasExesLengthA (VOID)
{
  return 0;
}


/* GetConsoleAliasExesLengthW ordinal = 234, argument = 0 temporary */
static DWORD WINAPI GetConsoleAliasExesLengthW (VOID)
{
  return 0;
}


/* GetConsoleAliasExesW ordinal = 235, argument = 8 temporary */
static DWORD WINAPI GetConsoleAliasExesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasW ordinal = 236, argument = 16 temporary */
static DWORD WINAPI GetConsoleAliasW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetConsoleAliasesA ordinal = 237, argument = 12 temporary */
static DWORD WINAPI GetConsoleAliasesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetConsoleAliasesLengthA ordinal = 238, argument = 4 temporary */
static DWORD WINAPI GetConsoleAliasesLengthA (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleAliasesLengthW ordinal = 239, argument = 4 temporary */
static DWORD WINAPI GetConsoleAliasesLengthW (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleAliasesW ordinal = 240, argument = 12 temporary */
static DWORD WINAPI GetConsoleAliasesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetConsoleCP ordinal = 241, argument = 0 temporary */
static DWORD WINAPI GetConsoleCP (VOID)
{
  return 0;
}


/* GetConsoleCharType ordinal = 242, argument = 0 temporary */
static DWORD WINAPI GetConsoleCharType (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryA ordinal = 243, argument = 0 temporary */
static DWORD WINAPI GetConsoleCommandHistoryA (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryLengthA ordinal = 244, argument = 0 temporary */
static DWORD WINAPI GetConsoleCommandHistoryLengthA (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryLengthW ordinal = 245, argument = 0 temporary */
static DWORD WINAPI GetConsoleCommandHistoryLengthW (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryW ordinal = 246, argument = 0 temporary */
static DWORD WINAPI GetConsoleCommandHistoryW (VOID)
{
  return 0;
}


/* GetConsoleCursorInfo ordinal = 247, argument = 8 temporary */
static DWORD WINAPI GetConsoleCursorInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleCursorMode ordinal = 248, argument = 0 temporary */
static DWORD WINAPI GetConsoleCursorMode (VOID)
{
  return 0;
}


/* GetConsoleDisplayMode ordinal = 249, argument = 4 temporary */
static DWORD WINAPI GetConsoleDisplayMode (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleFontInfo ordinal = 250, argument = 0 temporary */
static DWORD WINAPI GetConsoleFontInfo (VOID)
{
  return 0;
}


/* GetConsoleFontSize ordinal = 251, argument = 8 temporary */
static DWORD WINAPI GetConsoleFontSize (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleHardwareState ordinal = 252, argument = 0 temporary */
static DWORD WINAPI GetConsoleHardwareState (VOID)
{
  return 0;
}


/* GetConsoleInputExeNameA ordinal = 253, argument = 0 temporary */
static DWORD WINAPI GetConsoleInputExeNameA (VOID)
{
  return 0;
}


/* GetConsoleInputExeNameW ordinal = 254, argument = 0 temporary */
static DWORD WINAPI GetConsoleInputExeNameW (VOID)
{
  return 0;
}


/* GetConsoleInputWaitHandle ordinal = 255, argument = 0 temporary */
static DWORD WINAPI GetConsoleInputWaitHandle (VOID)
{
  return 0;
}


/* GetConsoleKeyboardLayoutNameA ordinal = 256, argument = 0 temporary */
static DWORD WINAPI GetConsoleKeyboardLayoutNameA (VOID)
{
  return 0;
}


/* GetConsoleKeyboardLayoutNameW ordinal = 257, argument = 0 temporary */
static DWORD WINAPI GetConsoleKeyboardLayoutNameW (VOID)
{
  return 0;
}


/* GetConsoleMode ordinal = 258, argument = 8 temporary */
static DWORD WINAPI GetConsoleMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleNlsMode ordinal = 259, argument = 0 temporary */
static DWORD WINAPI GetConsoleNlsMode (VOID)
{
  return 0;
}


/* GetConsoleOutputCP ordinal = 260, argument = 0 temporary */
static DWORD WINAPI GetConsoleOutputCP (VOID)
{
  return 0;
}


/* GetConsoleScreenBufferInfo ordinal = 261, argument = 8 temporary */
static DWORD WINAPI GetConsoleScreenBufferInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleTitleA ordinal = 262, argument = 8 temporary */
static DWORD WINAPI GetConsoleTitleA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleTitleW ordinal = 263, argument = 8 temporary */
static DWORD WINAPI GetConsoleTitleW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleWindow ordinal = 264, argument = 0 temporary */
static DWORD WINAPI GetConsoleWindow (VOID)
{
  return 0;
}


/* GetCurrencyFormatA ordinal = 265, argument = 24 temporary */
static DWORD WINAPI GetCurrencyFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCurrencyFormatW ordinal = 266, argument = 24 temporary */
static DWORD WINAPI GetCurrencyFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCurrentConsoleFont ordinal = 267, argument = 12 temporary */
static DWORD WINAPI GetCurrentConsoleFont (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetCurrentDirectoryA ordinal = 268, argument = 8 */
DWORD WINAPI GetCurrentDirectoryA (DWORD nBufferLength, LPSTR lpBuffer)
{
  gchar *path, *mb;
  DWORD dwResult;

  path = g_get_current_dir ();
  mb = w32ldr_filename_to_mb (path);
  g_free (path);
  dwResult = g_strlen (mb);
  if (!lpBuffer || nBufferLength <= dwResult)
    dwResult++;
  else
    g_strcpy (lpBuffer, mb);
  g_free (mb);
  return dwResult;
}


/* GetCurrentDirectoryW ordinal = 269, argument = 8 */
DWORD WINAPI GetCurrentDirectoryW (DWORD nBufferLength, LPWSTR lpBuffer)
{
  gchar *path;
  gunichar2 *wc;
  DWORD dwResult;

  path = g_get_current_dir ();
  wc = w32ldr_filename_to_wc (path);
  g_free (path);
  dwResult = lstrlenW (wc);
  if (!lpBuffer || nBufferLength <= dwResult)
    dwResult++;
  else
    lstrcpyW (lpBuffer, wc);
  g_free (wc);
  return dwResult;
}


/* GetCurrentProcess ordinal = 270, argument = 0 */
HANDLE WINAPI GetCurrentProcess (VOID)
{
  return GINT_TO_POINTER (-1);
}


/* GetCurrentProcessId ordinal = 271, argument = 0 temporary */
static DWORD WINAPI GetCurrentProcessId (VOID)
{
  return 0;
}


/* GetCurrentThread ordinal = 272, argument = 0 */
HANDLE WINAPI GetCurrentThread (VOID)
{
#ifdef USE_THREAD
  static W32LdrHandle *w32handle = INVALID_HANDLE_VALUE;

  if (w32handle == INVALID_HANDLE_VALUE)
    {
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->counter = 1;
      w32handle->priority = THREAD_PRIORITY_NORMAL;
      w32handle->gthread = g_thread_self ();
    }
  return w32handle;
#else /* not USE_THREAD */
  return GUINT_TO_POINTER (0xfffffffe);
#endif /* not USE_THREAD */
}


/* GetCurrentThreadId ordinal = 273, argument = 0 */
DWORD WINAPI GetCurrentThreadId (VOID)
{
#ifdef USE_THREAD
  static W32LdrHandle *w32handle = INVALID_HANDLE_VALUE;

  if (w32handle == INVALID_HANDLE_VALUE)
    {
      w32handle = g_malloc0 (sizeof (W32LdrHandle));
      w32handle->counter = 1;
      w32handle->priority = THREAD_PRIORITY_NORMAL;
      w32handle->gthread = g_thread_self ();
    }
  return (DWORD)w32handle;
#else /* not USE_THREAD */
  return 0xfffffffe;
#endif /* not USE_THREAD */
}


/* GetDateFormatA ordinal = 274, argument = 24 temporary */
static DWORD WINAPI GetDateFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetDateFormatW ordinal = 275, argument = 24 temporary */
static DWORD WINAPI GetDateFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetDefaultCommConfigA ordinal = 276, argument = 12 temporary */
static DWORD WINAPI GetDefaultCommConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetDefaultCommConfigW ordinal = 277, argument = 12 temporary */
static DWORD WINAPI GetDefaultCommConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetDefaultSortkeySize ordinal = 278, argument = 0 temporary */
static DWORD WINAPI GetDefaultSortkeySize (VOID)
{
  return 0;
}


/* GetDevicePowerState ordinal = 279, argument = 8 temporary */
static DWORD WINAPI GetDevicePowerState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDiskFreeSpaceA ordinal = 280, argument = 20 */
BOOL GetDiskFreeSpaceA (LPCSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters)
{
  if (lpRootPathName && (g_ascii_toupper (lpRootPathName[0]) != 'C'
                    || lpRootPathName[1] != ':' || lpRootPathName[2] != '\\'
                                                || lpRootPathName[3] != '\0'))
    return FALSE;
  if (lpSectorsPerCluster)
    *lpSectorsPerCluster = 8;
  if (lpBytesPerSector)
    *lpBytesPerSector = 512;
  if (lpNumberOfFreeClusters)
    *lpNumberOfFreeClusters = 134217728;
  if (lpTotalNumberOfClusters)
    *lpTotalNumberOfClusters = 134217728;
  return TRUE;
}


/* GetDiskFreeSpaceExA ordinal = 281, argument = 16 */
BOOL WINAPI GetDiskFreeSpaceExA (LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes)
{
  if (lpDirectoryName && (g_ascii_toupper (lpDirectoryName[0]) != 'C'
                || lpDirectoryName[1] != ':' || lpDirectoryName[2] != '\\'))
    return FALSE;
  if (lpFreeBytesAvailableToCaller)
    {
      lpFreeBytesAvailableToCaller->LowPart = 0;
      lpFreeBytesAvailableToCaller->HighPart = 128;
    }
  if (lpTotalNumberOfBytes)
    {
      lpTotalNumberOfBytes->LowPart = 0;
      lpTotalNumberOfBytes->HighPart = 256;
    }
  if (lpTotalNumberOfFreeBytes)
    {
      lpTotalNumberOfFreeBytes->LowPart = 0;
      lpTotalNumberOfFreeBytes->HighPart = 128;
    }
  return TRUE;
}


/* GetDiskFreeSpaceExW ordinal = 282, argument = 16 */
BOOL WINAPI GetDiskFreeSpaceExW (LPCWSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes)
{
  if (lpDirectoryName && (g_unichar_toupper (lpDirectoryName[0]) != 'C'
                || lpDirectoryName[1] != ':' || lpDirectoryName[2] != '\\'))
    return FALSE;
  return GetDiskFreeSpaceExA (NULL, lpFreeBytesAvailableToCaller,
                            lpTotalNumberOfBytes, lpTotalNumberOfFreeBytes);
}


/* GetDiskFreeSpaceW ordinal = 283, argument = 20 */
BOOL WINAPI GetDiskFreeSpaceW (LPCWSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters)
{
  if (lpRootPathName && (g_unichar_toupper (lpRootPathName[0]) != 'C'
                    || lpRootPathName[1] != ':' || lpRootPathName[2] != '\\'
                                                || lpRootPathName[3] != '\0'))
    return FALSE;
  return GetDiskFreeSpaceA (NULL, lpSectorsPerCluster, lpBytesPerSector,
                            lpNumberOfFreeClusters, lpTotalNumberOfClusters);
}


/* GetDriveTypeA ordinal = 284, argument = 4 temporary */
static DWORD WINAPI GetDriveTypeA (DWORD dwArgv0)
{
  return 0;
}


/* GetDriveTypeW ordinal = 285, argument = 4 temporary */
static DWORD WINAPI GetDriveTypeW (DWORD dwArgv0)
{
  return 0;
}


/* GetEnvironmentStrings ordinal = 286, argument = 0 */
/* LPVOID WINAPI GetEnvironmentStrings (VOID) */


/* GetEnvironmentStringsA ordinal = 287, argument = 0 */
LPVOID WINAPI GetEnvironmentStringsA (VOID)
{
  return g_malloc0 (sizeof (CHAR) * 2);
}


/* GetEnvironmentStringsW ordinal = 288, argument = 0 */
LPVOID WINAPI GetEnvironmentStringsW (VOID)
{
  return g_malloc0 (sizeof (WCHAR) * 2);
}


/* GetEnvironmentVariableA ordinal = 289, argument = 12 */
DWORD WINAPI GetEnvironmentVariableA (LPCSTR lpName, LPSTR lpBuffer, DWORD nSize)
{
  gsize leng;
  gchar *name, *utf8str, *mb;
  const gchar *ev;

  utf8str = w32ldr_utf8_from_mb (lpName);
  name = utf8str ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  ev = g_getenv (name);
  g_free (name);
  if (!ev)
    return 0;
  utf8str = g_filename_to_utf8 (ev, -1, NULL, NULL, NULL);
  mb = w32ldr_utf8_to_mb (utf8str);
  g_free (utf8str);
  leng = g_strlen (mb);
  if (!lpBuffer || nSize <= leng)
    {
      g_free (mb);
      return leng + 1;
    }
  g_strcpy (lpBuffer, mb);
  g_free (mb);
  return leng;
}


/* GetEnvironmentVariableW ordinal = 290, argument = 12 */
DWORD WINAPI GetEnvironmentVariableW (LPCWSTR lpName, LPWSTR lpBuffer, DWORD nSize)
{
  gsize leng;
  gchar *name, *utf8str;
  gunichar2 *wc;
  const gchar *ev;

  utf8str = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  name = utf8str ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  ev = g_getenv (name);
  g_free (name);
  if (!ev)
    return 0;
  utf8str = g_filename_to_utf8 (ev, -1, NULL, NULL, NULL);
  wc = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  if (!wc)
    return 0;
  leng = lstrlenW (wc);
  if (!lpBuffer || nSize <= leng)
    {
      g_free (wc);
      return leng + 1;
    }
  lstrcpyW (lpBuffer, wc);
  g_free (wc);
  return leng;
}


/* GetExitCodeProcess ordinal = 291, argument = 8 temporary */
static DWORD WINAPI GetExitCodeProcess (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetExitCodeThread ordinal = 292, argument = 8 temporary */
static DWORD WINAPI GetExitCodeThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileAttributesA ordinal = 293, argument = 4 */
DWORD WINAPI GetFileAttributesA (LPCSTR lpFileName)
{
  gchar *file;
  DWORD dwResult;

  file = w32ldr_filename_from_mb (lpFileName);
  dwResult = kernel32_file_get_attributes (file);
  g_free (file);
  return dwResult;
}


/* GetFileAttributesExA ordinal = 294, argument = 12 temporary */
static DWORD WINAPI GetFileAttributesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileAttributesExW ordinal = 295, argument = 12 temporary */
static DWORD WINAPI GetFileAttributesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileAttributesW ordinal = 296, argument = 4 */
DWORD WINAPI GetFileAttributesW (LPCWSTR lpFileName)
{
  gchar *file;
  DWORD dwResult;

  file = w32ldr_filename_from_wc (lpFileName);
  dwResult = kernel32_file_get_attributes (file);
  g_free (file);
  return dwResult;
}


/* GetFileInformationByHandle ordinal = 297, argument = 8 temporary */
static DWORD WINAPI GetFileInformationByHandle (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileSize ordinal = 298, argument = 8 */
DWORD WINAPI GetFileSize (HANDLE hFile, LPDWORD lpFileSizeHigh)
{
  goffset size;

  size = hFile && hFile != INVALID_HANDLE_VALUE
                            ? fileio_size (((W32LdrHandle *)hFile)->fio) : -1;
  if (lpFileSizeHigh)
    *lpFileSizeHigh = size >= 0 ? size >> 32 : 0xffffffff;
  return size;
}


/* GetFileSizeEx ordinal = 299, argument = 8 temporary */
static DWORD WINAPI GetFileSizeEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileTime ordinal = 300, argument = 16 */
BOOL WINAPI GetFileTime (HANDLE hFile, LPFILETIME lpCreationTime, LPFILETIME lpLastAccessTime, LPFILETIME lpLastWriteTime)
{
  const gchar *file;

  return hFile && hFile != INVALID_HANDLE_VALUE
                    && (file = fileio_getname (((W32LdrHandle *)hFile)->fio))
                    && kernel32_file_get_time (file,
                            lpCreationTime, lpLastAccessTime, lpLastWriteTime);
}


/* GetFileType ordinal = 301, argument = 4 */
DWORD WINAPI GetFileType (HANDLE hFile)
{
  return FILE_TYPE_DISK;
}


/* GetFullPathNameA ordinal = 302, argument = 16 */
DWORD WINAPI GetFullPathNameA (LPCSTR lpFileName, DWORD nBufferLength, LPSTR lpBuffer, LPSTR *lpFilePart)
{
  gchar *file, *path;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_mb (lpFileName);
  path = fileio_get_full_path (file);
  g_free (file);
  file = w32ldr_filename_to_mb (path);
  g_free (path);
  if (file)
    {
      dwResult = g_strlen (file);
      if (dwResult < nBufferLength)
        {
          g_strcpy (lpBuffer, file);
          if (lpFilePart)
            {
              LPSTR p;

              *lpFilePart = lpBuffer;
              for (p = lpBuffer; *p != '\0'; p += IsDBCSLeadByte (*p) ? 2 : 1)
                if (*p == '\\')
                  *lpFilePart = p;
            }
        }
      else
        {
          dwResult++;
        }
      g_free (file);
    }
  return dwResult;
}


/* GetFullPathNameW ordinal = 303, argument = 16 */
DWORD WINAPI GetFullPathNameW (LPCWSTR lpFileName, DWORD nBufferLength, LPWSTR lpBuffer, LPWSTR *lpFilePart)
{
  gchar *file, *path;
  gunichar2 *full;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_wc (lpFileName);
  path = fileio_get_full_path (file);
  g_free (file);
  full = w32ldr_filename_to_wc (path);
  g_free (path);
  if (full)
    {
      dwResult = lstrlenW (full);
      if (dwResult < nBufferLength)
        {
          lstrcpyW (lpBuffer, full);
          if (lpFilePart)
            {
              gunichar2 *p;

              *lpFilePart = lpBuffer;
              for (p = lpBuffer; *p != '\0'; p++)
                if (*p == '\\')
                  *lpFilePart = p;
            }
        }
      else
        {
          dwResult++;
        }
      g_free (full);
    }
  return dwResult;
}


/* GetHandleInformation ordinal = 304, argument = 8 temporary */
static DWORD WINAPI GetHandleInformation (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetLargestConsoleWindowSize ordinal = 305, argument = 4 temporary */
static DWORD WINAPI GetLargestConsoleWindowSize (DWORD dwArgv0)
{
  return 0;
}


/* GetLastError ordinal = 306, argument = 0 */
DWORD WINAPI GetLastError (VOID)
{
  return 0;
}


/* GetLinguistLangSize ordinal = 307, argument = 0 temporary */
static DWORD WINAPI GetLinguistLangSize (VOID)
{
  return 0;
}


/* GetLocalTime ordinal = 308, argument = 4 */
VOID WINAPI GetLocalTime (LPSYSTEMTIME lpSystemTime)
{
  if (lpSystemTime)
    {
      time_t t;
      struct tm *tm;

      t = time (NULL);
      tm = localtime (&t);
      if (tm)
        {
          lpSystemTime->wYear = tm->tm_year + 1900;
          lpSystemTime->wMonth = tm->tm_mon + 1;
          lpSystemTime->wDayOfWeek = tm->tm_wday;
          lpSystemTime->wDay = tm->tm_mday;
          lpSystemTime->wHour = tm->tm_hour;
          lpSystemTime->wMinute = tm->tm_min;
          lpSystemTime->wSecond = tm->tm_sec;
        }
      else
        {
          lpSystemTime->wYear = 1980;
          lpSystemTime->wMonth = 1;
          lpSystemTime->wDayOfWeek = 2;
          lpSystemTime->wDay = 1;
          lpSystemTime->wHour = 0;
          lpSystemTime->wMinute = 0;
          lpSystemTime->wSecond = 0;
        }
      lpSystemTime->wMilliseconds = 0;
    }
}


/* GetLocaleInfoA ordinal = 309, argument = 16 */
INT WINAPI GetLocaleInfoA (LCID Locale, LCTYPE LCType, LPSTR lpLCData, INT cchData)
{
  if (lpLCData && cchData > 0)
    lpLCData[0] = '\0';
  return 0;
}


/* GetLocaleInfoW ordinal = 310, argument = 16 */
INT WINAPI GetLocaleInfoW (LCID Locale, LCTYPE LCType, LPWSTR lpLCData, INT cchData)
{
  if (lpLCData && cchData > 0)
    lpLCData[0] = '\0';
  return 0;
}


/* GetLogicalDriveStringsA ordinal = 311, argument = 8 */
DWORD WINAPI GetLogicalDriveStringsA (DWORD nBufferLength, LPSTR lpBuffer)
{
  if (nBufferLength < 4)
    return 5;
  lpBuffer[0] = 'c';
  lpBuffer[1] = ':';
  lpBuffer[2] = '\\';
  lpBuffer[3] = '\0';
  lpBuffer[4] = '\0';
  return 4;
}


/* GetLogicalDriveStringsW ordinal = 312, argument = 8 */
DWORD WINAPI GetLogicalDriveStringsW (DWORD nBufferLength, LPWSTR lpBuffer)
{
  if (nBufferLength < 4)
    return 5;
  lpBuffer[0] = 'c';
  lpBuffer[1] = ':';
  lpBuffer[2] = '\\';
  lpBuffer[3] = '\0';
  lpBuffer[4] = '\0';
  return 4;
}


/* GetLogicalDrives ordinal = 313, argument = 0 temporary */
static DWORD WINAPI GetLogicalDrives (VOID)
{
  return 0;
}


/* GetLongPathNameA ordinal = 314, argument = 12 temporary */
static DWORD WINAPI GetLongPathNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLongPathNameW ordinal = 315, argument = 12 temporary */
static DWORD WINAPI GetLongPathNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMailslotInfo ordinal = 316, argument = 20 temporary */
static DWORD WINAPI GetMailslotInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetModuleFileNameA ordinal = 317, argument = 12 */
DWORD WINAPI GetModuleFileNameA (HMODULE hModule, LPSTR lpFilename, DWORD nSize)
{
  gchar *file;

  if (!lpFilename || nSize <= 0)
    return 0;
  file = w32ldr_filename_to_mb (hModule ? w32ldr_module_get_filename (hModule)
                                        : g_get_prgname ());
  g_strncpy (lpFilename, file, nSize);
  g_free (file);
  return g_strlen (lpFilename);
}


/* GetModuleFileNameW ordinal = 318, argument = 12 */
DWORD WINAPI GetModuleFileNameW (HMODULE hModule, LPWSTR lpFilename, DWORD nSize)
{
  gunichar2 *file;

  if (!lpFilename || nSize <= 0)
    return 0;
  file = w32ldr_filename_to_wc (hModule ? w32ldr_module_get_filename (hModule)
                                        : g_get_prgname ());
  lstrcpynW (lpFilename, file, nSize);
  g_free (file);
  return lstrlenW (lpFilename);
}


/* GetModuleHandleA ordinal = 319, argument = 4 */
HMODULE WINAPI GetModuleHandleA (LPCSTR lpModuleName)
{
  gpointer memory;
  gchar *file;

  file = w32ldr_filename_from_mb (lpModuleName);
  memory = w32ldr_module_get_library (file);
  g_free (file);
  return memory;
}


/* GetModuleHandleW ordinal = 320, argument = 4 */
HMODULE WINAPI GetModuleHandleW (LPCWSTR lpModuleName)
{
  gpointer memory;
  gchar *file;

  file = w32ldr_filename_from_wc (lpModuleName);
  memory = w32ldr_module_get_library (file);
  g_free (file);
  return memory;
}


/* GetNamedPipeHandleStateA ordinal = 321, argument = 28 temporary */
static DWORD WINAPI GetNamedPipeHandleStateA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetNamedPipeHandleStateW ordinal = 322, argument = 28 temporary */
static DWORD WINAPI GetNamedPipeHandleStateW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetNamedPipeInfo ordinal = 323, argument = 20 temporary */
static DWORD WINAPI GetNamedPipeInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetNextVDMCommand ordinal = 324, argument = 0 temporary */
static DWORD WINAPI GetNextVDMCommand (VOID)
{
  return 0;
}


/* GetNlsSectionName ordinal = 325, argument = 0 temporary */
static DWORD WINAPI GetNlsSectionName (VOID)
{
  return 0;
}


/* GetNumberFormatA ordinal = 326, argument = 24 temporary */
static DWORD WINAPI GetNumberFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetNumberFormatW ordinal = 327, argument = 24 temporary */
static DWORD WINAPI GetNumberFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetNumberOfConsoleFonts ordinal = 328, argument = 0 temporary */
static DWORD WINAPI GetNumberOfConsoleFonts (VOID)
{
  return 0;
}


/* GetNumberOfConsoleInputEvents ordinal = 329, argument = 8 temporary */
static DWORD WINAPI GetNumberOfConsoleInputEvents (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetNumberOfConsoleMouseButtons ordinal = 330, argument = 4 temporary */
static DWORD WINAPI GetNumberOfConsoleMouseButtons (DWORD dwArgv0)
{
  return 0;
}


/* GetOEMCP ordinal = 331, argument = 0 */
UINT WINAPI GetOEMCP (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = kernel32_nls_get_information ();
  return nls_info->oemcp == 1 ? 850 : nls_info->oemcp;
}


/* GetOverlappedResult ordinal = 332, argument = 16 temporary */
static DWORD WINAPI GetOverlappedResult (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPriorityClass ordinal = 333, argument = 4 temporary */
static DWORD WINAPI GetPriorityClass (DWORD dwArgv0)
{
  return 0;
}


/* GetPrivateProfileIntA ordinal = 334, argument = 16 */
UINT WINAPI GetPrivateProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault, LPCSTR lpFileName)
{
  gchar *utf8str;
  gunichar2 *group, *key, *file;
  UINT uResult;

  utf8str = w32ldr_utf8_from_mb (lpAppName);
  group = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpKeyName);
  key = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpFileName);
  file = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  uResult = GetPrivateProfileIntW (group, key, nDefault, file);
  g_free (group);
  g_free (key);
  g_free (file);
  return uResult;
}


/* GetPrivateProfileIntW ordinal = 335, argument = 16 */
UINT WINAPI GetPrivateProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault, LPCWSTR lpFileName)
{
  gboolean read = FALSE;
  gchar *group, *key;
  gint i;
  UINT uResult;

  uResult = nDefault;
  group = lpAppName ? g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL) : NULL;
  key = lpKeyName ? g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL) : NULL;
  for (i = 0; i < 2 && !read; i++)
    {
      gchar *file, *tmp, **groups;
      GKeyFile *key_file;

      tmp = w32ldr_filename_from_wc (lpFileName);
      file = peimage_dir_get_filename (tmp,
                                i == 0 ? PEIMAGE_DIR_HOME : PEIMAGE_DIR_DATA);
      g_free (tmp);
      key_file = g_key_file_new ();
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_free (file);
      groups = g_key_file_get_groups (key_file, NULL);
      if (groups)
        {
          gint j;

          for (j = 0; groups[j] && !read; j++)
            if (g_ascii_strcasecmp (groups[j], group) == 0)
              {
                gchar **keys;

                keys = g_key_file_get_keys (key_file, groups[j], NULL, NULL);
                if (keys)
                  {
                    gint k;

                    for (k = 0; keys[k] && !read; k++)
                      if (g_ascii_strcasecmp (keys[k], key) == 0)
                        {
                          uResult = g_key_file_get_integer (key_file,
                                                    groups[j], keys[k], NULL);
                          read = TRUE;
                        }
                    g_strfreev (keys);
                  }
              }
          g_strfreev (groups);
        }
      g_key_file_free (key_file);
    }
  g_free (group);
  g_free (key);
  return uResult;
}


static GList *
kernel32_inifile_enum_section (const gchar *file)
{
  gint i;
  GList *glist = NULL;

  for (i = 0; i < 2; i++)
    {
      gchar *tmp, **groups;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      tmp = peimage_dir_get_filename (file,
                                i == 0 ? PEIMAGE_DIR_HOME : PEIMAGE_DIR_DATA);
      g_key_file_load_from_file (key_file, tmp, G_KEY_FILE_NONE, NULL);
      g_free (tmp);
      groups = g_key_file_get_groups (key_file, NULL);
      if (groups)
        {
          gint j;

          for (j = 0; groups[j]; j++)
            if (!g_list_find_custom (glist, groups[j],
                                            (GCompareFunc)g_ascii_strcasecmp))
              glist = g_list_append (glist, g_strdup (groups[j]));
          g_strfreev (groups);
        }
      g_key_file_free (key_file);
    }
  return glist;
}


static GList *
kernel32_inifile_enum_key (const gchar *file,
                           const gchar *group)
{
  gint i;
  GList *glist = NULL, *glist_pair = NULL;

  for (i = 0; i < 2; i++)
    {
      gchar *tmp, **groups;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      tmp = peimage_dir_get_filename (file,
                                i == 0 ? PEIMAGE_DIR_HOME : PEIMAGE_DIR_DATA);
      g_key_file_load_from_file (key_file, tmp, G_KEY_FILE_NONE, NULL);
      g_free (tmp);
      groups = g_key_file_get_groups (key_file, NULL);
      if (groups)
        {
          gint j;

          for (j = 0; groups[j]; j++)
            if (g_ascii_strcasecmp (groups[j], group) == 0)
              {
                gchar **keys;

                keys = g_key_file_get_keys (key_file, groups[j], NULL, NULL);
                if (keys)
                  {
                    gint k;

                    for (k = 0; keys[k]; k++)
                      if (!g_list_find_custom (glist, keys[k],
                                            (GCompareFunc)g_ascii_strcasecmp))
                        {
                          gchar *str;

                          glist = g_list_append (glist, g_strdup (keys[k]));
                          str = g_key_file_get_string (key_file,
                                                    groups[j], keys[k], NULL);
                          glist_pair = g_list_append (glist,
                                        g_strconcat (keys[k], "=", str, NULL));
                          g_free (str);
                        }
                    g_strfreev (keys);
                  }
              }
          g_strfreev (groups);
        }
      g_key_file_free (key_file);
    }
  g_list_foreach (glist, (GFunc)g_free, NULL);
  g_list_free (glist);
  return glist_pair;
}


/* GetPrivateProfileSectionA ordinal = 336, argument = 16 */
DWORD WINAPI GetPrivateProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName)
{
  gchar *file, *group, *result = NULL;
  GList *glist;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_mb (lpFileName);
  group = w32ldr_utf8_from_mb (lpAppName);
  glist = kernel32_inifile_enum_key (file, group);
  g_free (file);
  g_free (group);
  for (glist = g_list_first (glist);
                            glist; glist = g_list_delete_link (glist, glist))
    {
      gchar *mb;
      gsize leng;

      mb = w32ldr_utf8_to_mb (glist->data);
      g_free (glist->data);
      leng = g_strlen (mb) + 1;
      result = g_realloc (result, (dwResult + leng) * sizeof (gchar));
      g_memmove (result + dwResult, mb, leng * sizeof (gchar));
      dwResult += leng;
    }
  if (nSize < dwResult)
    {
      g_memmove (lpReturnedString, result, dwResult * sizeof (gchar));
      lpReturnedString[dwResult] = '\0';
    }
  else
    {
      dwResult = nSize - 2;
    }
  g_free (result);
  return dwResult;
}


/* GetPrivateProfileSectionNamesA ordinal = 337, argument = 12 */
DWORD WINAPI GetPrivateProfileSectionNamesA (LPSTR lpszReturnBuffer, DWORD nSize, LPCSTR lpFileName)
{
  gchar *file, *result = NULL;
  GList *glist;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_mb (lpFileName);
  glist = kernel32_inifile_enum_section (file);
  g_free (file);
  for (glist = g_list_first (glist);
                            glist; glist = g_list_delete_link (glist, glist))
    {
      gchar *mb;
      gsize leng;

      mb = w32ldr_utf8_to_mb (glist->data);
      g_free (glist->data);
      leng = g_strlen (mb) + 1;
      result = g_realloc (result, (dwResult + leng) * sizeof (gchar));
      g_memmove (result + dwResult, mb, leng * sizeof (gchar));
      dwResult += leng;
    }
  if (nSize < dwResult)
    {
      g_memmove (lpszReturnBuffer, result, dwResult * sizeof (gchar));
      lpszReturnBuffer[dwResult] = '\0';
    }
  else
    {
      dwResult = nSize - 2;
    }
  g_free (result);
  return dwResult;
}


/* GetPrivateProfileSectionNamesW ordinal = 338, argument = 12 temporary */
static DWORD WINAPI GetPrivateProfileSectionNamesW (LPWSTR lpszReturnBuffer, DWORD nSize, LPCWSTR lpFileName)
{
  gchar *file, *result = NULL;
  GList *glist;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_wc (lpFileName);
  glist = kernel32_inifile_enum_section (file);
  g_free (file);
  for (glist = g_list_first (glist);
                            glist; glist = g_list_delete_link (glist, glist))
    {
      gunichar2 *wc;
      gsize leng;

      wc = g_utf8_to_utf16 (glist->data, -1, NULL, NULL, NULL);
      g_free (glist->data);
      leng = lstrlenW (wc) + 1;
      result = g_realloc (result, (dwResult + leng) * sizeof (gunichar2));
      g_memmove (result + dwResult, wc, leng * sizeof (gunichar2));
      dwResult += leng;
    }
  if (nSize < dwResult)
    {
      g_memmove (lpszReturnBuffer, result, dwResult * sizeof (gunichar2));
      lpszReturnBuffer[dwResult] = '\0';
    }
  else
    {
      dwResult = nSize - 2;
    }
  g_free (result);
  return dwResult;
}


/* GetPrivateProfileSectionW ordinal = 339, argument = 16 */
DWORD WINAPI GetPrivateProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName)
{
  gchar *file, *group, *result = NULL;
  GList *glist;
  DWORD dwResult = 0;

  file = w32ldr_filename_from_wc (lpFileName);
  group = lpAppName ? g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL) : NULL;
  glist = kernel32_inifile_enum_key (file, group);
  g_free (file);
  g_free (group);
  for (glist = g_list_first (glist);
                            glist; glist = g_list_delete_link (glist, glist))
    {
      gsize leng;
      gunichar2 *wc;

      wc = g_utf8_to_utf16 (glist->data, -1, NULL, NULL, NULL);
      g_free (glist->data);
      leng = lstrlenW (wc) + 1;
      result = g_realloc (result, (dwResult + leng) * sizeof (gunichar2));
      g_memmove (result + dwResult, wc, leng * sizeof (gunichar2));
      dwResult += leng;
    }
  if (nSize < dwResult)
    {
      g_memmove (lpReturnedString, result, dwResult * sizeof (gunichar2));
      lpReturnedString[dwResult] = '\0';
    }
  else
    {
      dwResult = nSize - 2;
    }
  g_free (result);
  return dwResult;
}


static gchar *
kernel32_inifile_get_string (const gchar *file,
                             const gchar *group,
                             const gchar *key)
{
  gchar *str = NULL;
  gint i;

  for (i = 0; i < 2 && !str; i++)
    {
      gchar *tmp, **groups;
      GKeyFile *key_file;

      key_file = g_key_file_new ();
      tmp = peimage_dir_get_filename (file,
                                i == 0 ? PEIMAGE_DIR_HOME : PEIMAGE_DIR_DATA);
      g_key_file_load_from_file (key_file, tmp, G_KEY_FILE_NONE, NULL);
      g_free (tmp);
      groups = g_key_file_get_groups (key_file, NULL);
      if (groups)
        {
          gint j;

          for (j = 0; groups[j] && !str; j++)
            if (g_ascii_strcasecmp (groups[j], group) == 0)
              {
                gchar **keys;

                keys = g_key_file_get_keys (key_file, groups[j], NULL, NULL);
                if (keys)
                  {
                    gint k;

                    for (k = 0; keys[k] && !str; k++)
                      if (g_ascii_strcasecmp (keys[k], key) == 0)
                        str = g_key_file_get_string (key_file,
                                                    groups[j], keys[k], NULL);
                    g_strfreev (keys);
                  }
              }
          g_strfreev (groups);
        }
      g_key_file_free (key_file);
    }
  return str;
}


/* GetPrivateProfileStringA ordinal = 340, argument = 24 */
DWORD WINAPI GetPrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName)
{
  gchar *file, *group, *key, *str, *mb;

  file = w32ldr_filename_from_mb (lpFileName);
  group = w32ldr_utf8_from_mb (lpAppName);
  key = w32ldr_utf8_from_mb (lpKeyName);
  str = kernel32_inifile_get_string (file, group, key);
  g_free (file);
  g_free (group);
  g_free (key);
  if (str)
    {
      mb = w32ldr_utf8_to_mb (str);
      g_free (str);
    }
  else
    {
      mb = NULL;
    }
  lstrcpynA (lpReturnedString, mb ? mb : lpDefault, nSize);
  g_free (mb);
  return g_strlen (lpReturnedString);
}


/* GetPrivateProfileStringW ordinal = 341, argument = 24 */
DWORD WINAPI GetPrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName)
{
  gchar *file, *group, *key, *str;
  gunichar2 *wc;

  file = w32ldr_filename_from_wc (lpFileName);
  group = lpAppName ? g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL) : NULL;
  key = lpKeyName ? g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL) : NULL;
  str = kernel32_inifile_get_string (file, group, key);
  g_free (file);
  g_free (group);
  g_free (key);
  if (str)
    {
      wc = g_utf8_to_utf16 (str, -1, NULL, NULL, NULL);
      g_free (str);
    }
  else
    {
      wc = NULL;
    }
  lstrcpynW (lpReturnedString, wc ? wc : lpDefault, nSize);
  g_free (wc);
  return lstrlenW (lpReturnedString);
}


/* GetPrivateProfileStructA ordinal = 342, argument = 20 */
BOOL WINAPI GetPrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile)
{
  gpointer array;
  gchar *file, *group, *key, *str;
  gsize leng;

  file = w32ldr_filename_from_mb (szFile);
  group = w32ldr_utf8_from_mb (lpszSection);
  key = w32ldr_utf8_from_mb (lpszKey);
  str = kernel32_inifile_get_string (file, group, key);
  g_free (file);
  g_free (group);
  g_free (key);
  if (!str)
    return FALSE;
  array = misc_str_to_array (&leng, 8, str, 16, FALSE);
  if (!array)
    return FALSE;
  g_memmove (lpStruct, array, MIN (uSizeStruct, leng));
  g_free (array);
  return TRUE;
}


/* GetPrivateProfileStructW ordinal = 343, argument = 20 */
BOOL WINAPI GetPrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile)
{
  gpointer array;
  gchar *file, *group, *key, *str;
  gsize leng;

  file = w32ldr_filename_from_wc (szFile);
  group = lpszSection ? g_utf16_to_utf8 (lpszSection, -1, NULL, NULL, NULL)
                      : NULL;
  key = lpszKey ? g_utf16_to_utf8 (lpszKey, -1, NULL, NULL, NULL) : NULL;
  str = kernel32_inifile_get_string (file, group, key);
  g_free (file);
  g_free (group);
  g_free (key);
  if (!str)
    return FALSE;
  array = misc_str_to_array (&leng, 8, str, 16, FALSE);
  if (!array)
    return FALSE;
  g_memmove (lpStruct, array, MIN (uSizeStruct, leng));
  g_free (array);
  return TRUE;
}


/* GetProcAddress ordinal = 344, argument = 8 */
FARPROC WINAPI GetProcAddress (HMODULE hModule, LPCSTR lpProcName)
{
  return hModule ? GPOINTER_TO_UINT (lpProcName) < 0x10000
                ? peimage_file_get_proc ((const guint8 *)hModule,
                                                GPOINTER_TO_UINT (lpProcName))
                : peimage_file_get_func ((const guint8 *)hModule, lpProcName)
                : NULL;
}


/* GetProcessAffinityMask ordinal = 345, argument = 12 */
BOOL WINAPI GetProcessAffinityMask (HANDLE hProcess, LPDWORD lpProcessAffinityMask, LPDWORD lpSystemAffinityMask)
{
  return FALSE;
}


static LPDWORD **lpHeap = NULL;


/* GetProcessHeap ordinal = 346, argument = 0 */
HANDLE WINAPI GetProcessHeap (VOID)
{
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (!lpHeap)
    {
      lpHeap = g_malloc (sizeof (LPDWORD *) * 2);
      lpHeap[0] = g_malloc0 (sizeof (LPDWORD));
      lpHeap[1] = GINT_TO_POINTER (-1);
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return GINT_TO_POINTER (1);
}


/* GetProcessHeaps ordinal = 347, argument = 8 */
DWORD WINAPI GetProcessHeaps (DWORD NumberOfHeaps, HANDLE *ProcessHeaps)
{
  gint i;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (!lpHeap)
    {
      lpHeap = g_malloc (sizeof (LPDWORD *) * 2);
      lpHeap[0] = g_malloc0 (sizeof (LPDWORD));
      lpHeap[1] = GINT_TO_POINTER (-1);
    }
  for (i = 0; i < NumberOfHeaps && lpHeap[i] != GINT_TO_POINTER (-1); i++)
    ProcessHeaps[i] = GINT_TO_POINTER (i + 1);
  while (lpHeap[i] != GINT_TO_POINTER (-1))
    i++;
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return i;
}


/* GetProcessIoCounters ordinal = 348, argument = 8 temporary */
static DWORD WINAPI GetProcessIoCounters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessPriorityBoost ordinal = 349, argument = 8 temporary */
static DWORD WINAPI GetProcessPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessShutdownParameters ordinal = 350, argument = 8 temporary */
static DWORD WINAPI GetProcessShutdownParameters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessTimes ordinal = 351, argument = 20 temporary */
static DWORD WINAPI GetProcessTimes (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetProcessVersion ordinal = 352, argument = 4 temporary */
static DWORD WINAPI GetProcessVersion (DWORD dwArgv0)
{
  return 0;
}


/* GetProcessWorkingSetSize ordinal = 353, argument = 12 temporary */
static DWORD WINAPI GetProcessWorkingSetSize (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetProfileIntA ordinal = 354, argument = 12 */
UINT WINAPI GetProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault)
{
  return GetPrivateProfileIntA (lpAppName, lpKeyName, nDefault, "win.ini");
}


/* GetProfileIntW ordinal = 355, argument = 12 */
UINT WINAPI GetProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return GetPrivateProfileIntW (lpAppName, lpKeyName, nDefault, file);
}


/* GetProfileSectionA ordinal = 356, argument = 12 */
DWORD WINAPI GetProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize)
{
  return GetPrivateProfileSectionA (lpAppName, lpReturnedString, nSize,
                                                                    "win.ini");
}


/* GetProfileSectionW ordinal = 357, argument = 12 */
DWORD WINAPI GetProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return GetPrivateProfileSectionW (lpAppName, lpReturnedString, nSize, file);
}


/* GetProfileStringA ordinal = 358, argument = 20 */
DWORD WINAPI GetProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize)
{
  return GetPrivateProfileStringA (lpAppName, lpKeyName, lpDefault,
                                        lpReturnedString, nSize, "win.ini");
}


/* GetProfileStringW ordinal = 359, argument = 20 */
DWORD WINAPI GetProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return GetPrivateProfileStringW (lpAppName, lpKeyName, lpDefault,
                                                lpReturnedString, nSize, file);
}


/* GetQueuedCompletionStatus ordinal = 360, argument = 20 temporary */
static DWORD WINAPI GetQueuedCompletionStatus (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetShortPathNameA ordinal = 361, argument = 12 */
DWORD WINAPI GetShortPathNameA (LPCSTR lpszLongPath, LPSTR lpszShortPath, DWORD cchBuffer)
{
  g_strncpy (lpszShortPath, lpszLongPath, cchBuffer);
  return g_strlen (lpszShortPath);
}


/* GetShortPathNameW ordinal = 362, argument = 12 */
DWORD WINAPI GetShortPathNameW (LPCWSTR lpszLongPath, LPWSTR lpszShortPath, DWORD cchBuffer)
{
  lstrcpynW (lpszShortPath, lpszLongPath, cchBuffer);
  return lstrlenW (lpszShortPath);
}


/* GetStartupInfoA ordinal = 363, argument = 4 */
VOID WINAPI GetStartupInfoA (LPSTARTUPINFOA lpsi)
{
  if (lpsi && lpsi->cb >= sizeof (STARTUPINFOA))
    {
      static gchar title[1] = {'\0'};
      gint width, height;

      width = gdk_screen_width ();
      height = gdk_screen_height ();
      lpsi->cb = sizeof (STARTUPINFOA);
      lpsi->lpReserved = NULL;
      lpsi->lpDesktop = NULL;
      lpsi->lpTitle = title;
      lpsi->dwX = width / 6;
      lpsi->dwY = height / 6;
      lpsi->dwXSize = width * 2 / 3;
      lpsi->dwYSize = height * 2 / 3;
      lpsi->dwXCountChars = 80;
      lpsi->dwYCountChars = 25;
      lpsi->dwFillAttribute = FOREGROUND_GREEN | FOREGROUND_RED
                                                            | BACKGROUND_RED;
      lpsi->dwFlags = STARTF_USESHOWWINDOW | STARTF_USEPOSITION
                            | STARTF_USESIZE | STARTF_USECOUNTCHARS
                            | STARTF_USEFILLATTRIBUTE | STARTF_USESTDHANDLES;
      lpsi->wShowWindow = SW_SHOWNORMAL;
      lpsi->cbReserved2 = 0;
      lpsi->lpReserved2 = NULL;
      lpsi->hStdInput = GetStdHandle (STD_INPUT_HANDLE);
      lpsi->hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
      lpsi->hStdError = GetStdHandle (STD_ERROR_HANDLE);
    }
}


/* GetStartupInfoW ordinal = 364, argument = 4 */
VOID WINAPI GetStartupInfoW (LPSTARTUPINFOW lpsi)
{
  if (lpsi && lpsi->cb >= sizeof (STARTUPINFOW))
    {
      static gunichar2 title[1] = {'\0'};
      gint width, height;

      width = gdk_screen_width ();
      height = gdk_screen_height ();
      lpsi->cb = sizeof (STARTUPINFOW);
      lpsi->lpReserved = NULL;
      lpsi->lpDesktop = NULL;
      lpsi->lpTitle = title;
      lpsi->dwX = width / 6;
      lpsi->dwY = height / 6;
      lpsi->dwXSize = width * 2 / 3;
      lpsi->dwYSize = height * 2 / 3;
      lpsi->dwXCountChars = 80;
      lpsi->dwYCountChars = 25;
      lpsi->dwFillAttribute = FOREGROUND_GREEN | FOREGROUND_RED
                                                            | BACKGROUND_RED;
      lpsi->dwFlags = STARTF_USESHOWWINDOW | STARTF_USEPOSITION
                            | STARTF_USESIZE | STARTF_USECOUNTCHARS
                            | STARTF_USEFILLATTRIBUTE | STARTF_USESTDHANDLES;
      lpsi->wShowWindow = SW_SHOWNORMAL;
      lpsi->cbReserved2 = 0;
      lpsi->lpReserved2 = NULL;
      lpsi->hStdInput = GetStdHandle (STD_INPUT_HANDLE);
      lpsi->hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
      lpsi->hStdError = GetStdHandle (STD_ERROR_HANDLE);
    }
}


/* GetStdHandle ordinal = 365, argument = 4 */
HANDLE WINAPI GetStdHandle (DWORD nStdHandle)
{
  return INVALID_HANDLE_VALUE;
}


/* GetStringTypeA ordinal = 366, argument = 20 */
BOOL WINAPI GetStringTypeA (LCID Locale, DWORD dwInfoType, LPCSTR lpSrcStr, INT cchSrc, LPWORD lpCharType)
{
  if (!lpSrcStr || !lpCharType)
    return FALSE;
  g_memset (lpCharType, 0,
                (cchSrc < 0 ? g_strlen (lpSrcStr) : cchSrc) * sizeof (WORD));
  return TRUE;
}


/* GetStringTypeExA ordinal = 367, argument = 20 temporary */
static DWORD WINAPI GetStringTypeExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetStringTypeExW ordinal = 368, argument = 20 temporary */
static DWORD WINAPI GetStringTypeExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetStringTypeW ordinal = 369, argument = 16 */
BOOL WINAPI GetStringTypeW (DWORD dwInfoType, LPCWSTR lpSrcStr, INT cchSrc, LPWORD lpCharType)
{
  if (!lpSrcStr || !lpCharType)
    return FALSE;
  g_memset (lpCharType, 0,
                (cchSrc < 0 ? lstrlenW (lpSrcStr) : cchSrc) * sizeof (WORD));
  return TRUE;
}


/* GetSystemDefaultLCID ordinal = 370, argument = 0 */
DWORD WINAPI GetSystemDefaultLCID (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = kernel32_nls_get_information ();
  return nls_info->lcid;
}


/* GetSystemDefaultLangID ordinal = 371, argument = 0 */
LANGID WINAPI GetSystemDefaultLangID (VOID)
{
  return LANGIDFROMLCID (GetSystemDefaultLCID ());
}


/* GetSystemDefaultUILanguage ordinal = 372, argument = 0 */
LANGID WINAPI GetSystemDefaultUILanguage (VOID)
{
  return GetSystemDefaultLangID ();
}


/* GetSystemDirectoryA ordinal = 373, argument = 8 */
UINT WINAPI GetSystemDirectoryA (LPSTR lpBuffer, UINT uSize)
{
  gsize leng;
  gchar *dir;

  dir = w32ldr_filename_to_mb (peimage_dir_get_path (PEIMAGE_DIR_SYSTEM));
  leng = g_strlen (dir) + 1;
  if (lpBuffer && uSize >= leng)
    {
      g_strncpy (lpBuffer, dir, uSize);
      leng--;
    }
  return leng;
}


/* GetSystemDirectoryW ordinal = 374, argument = 8 */
UINT WINAPI GetSystemDirectoryW (LPWSTR lpBuffer, UINT uSize)
{
  gsize leng;
  gunichar2 *dir;

  dir = w32ldr_filename_to_wc (peimage_dir_get_path (PEIMAGE_DIR_SYSTEM));
  leng = lstrlenW (dir) + 1;
  if (lpBuffer && uSize >= leng)
    {
      lstrcpynW (lpBuffer, dir, uSize);
      leng--;
    }
  return leng;
}


/* GetSystemInfo ordinal = 375, argument = 4 */
VOID WINAPI GetSystemInfo (LPSYSTEM_INFO lpSystemInfo)
{
  if (lpSystemInfo)
    {
      lpSystemInfo->DUMMYUNIONNAME.dwOemId = 0;
      lpSystemInfo->dwPageSize = 0x1000;
      lpSystemInfo->lpMinimumApplicationAddress
                                            = GUINT_TO_POINTER (0x00400000);
      lpSystemInfo->lpMaximumApplicationAddress
                                            = GUINT_TO_POINTER (0x7fffffff);
      lpSystemInfo->dwActiveProcessorMask = 0;
      lpSystemInfo->dwNumberOfProcessors = 1;
      lpSystemInfo->dwProcessorType = PROCESSOR_INTEL_386;
      lpSystemInfo->dwAllocationGranularity = 0x10000;
      lpSystemInfo->wProcessorLevel = 0;
      lpSystemInfo->wProcessorRevision = 0;
    }
}


/* GetSystemPowerStatus ordinal = 376, argument = 4 temporary */
static DWORD WINAPI GetSystemPowerStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemTime ordinal = 377, argument = 4 */
VOID WINAPI GetSystemTime (LPSYSTEMTIME lpSystemTime)
{
  if (lpSystemTime)
    {
      time_t t;
      struct tm *tm;

      t = time (NULL);
      tm = gmtime (&t);
      if (tm)
        {
          lpSystemTime->wYear = tm->tm_year + 1900;
          lpSystemTime->wMonth = tm->tm_mon + 1;
          lpSystemTime->wDayOfWeek = tm->tm_wday;
          lpSystemTime->wDay = tm->tm_mday;
          lpSystemTime->wHour = tm->tm_hour;
          lpSystemTime->wMinute = tm->tm_min;
          lpSystemTime->wSecond = tm->tm_sec;
        }
      else
        {
          lpSystemTime->wYear = 1980;
          lpSystemTime->wMonth = 1;
          lpSystemTime->wDayOfWeek = 2;
          lpSystemTime->wDay = 1;
          lpSystemTime->wHour = 0;
          lpSystemTime->wMinute = 0;
          lpSystemTime->wSecond = 0;
        }
      lpSystemTime->wMilliseconds = 0;
    }
}


/* GetSystemTimeAdjustment ordinal = 378, argument = 12 temporary */
static DWORD WINAPI GetSystemTimeAdjustment (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetSystemTimeAsFileTime ordinal = 379, argument = 4 */
VOID WINAPI GetSystemTimeAsFileTime (LPFILETIME lpSystemTimeAsFileTime)
{
  SYSTEMTIME st;

  GetSystemTime (&st);
  SystemTimeToFileTime (&st, lpSystemTimeAsFileTime);
}


/* GetSystemWindowsDirectoryA ordinal = 380, argument = 8 temporary */
static DWORD WINAPI GetSystemWindowsDirectoryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSystemWindowsDirectoryW ordinal = 381, argument = 8 temporary */
static DWORD WINAPI GetSystemWindowsDirectoryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTapeParameters ordinal = 382, argument = 16 temporary */
static DWORD WINAPI GetTapeParameters (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTapePosition ordinal = 383, argument = 20 temporary */
static DWORD WINAPI GetTapePosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTapeStatus ordinal = 384, argument = 4 temporary */
static DWORD WINAPI GetTapeStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetTempFileNameA ordinal = 385, argument = 16 */
UINT WINAPI GetTempFileNameA (LPCSTR lpPathName, LPCSTR lpPrefixString, UINT uUnique, LPSTR lpTempFileName)
{
  gchar *str, *unique;
  guint u;

  if (!lpPathName || !lpTempFileName)
    return 0;
  g_strcpy (lpTempFileName, lpPathName);
  g_strcpy (lpTempFileName, "\\");
  if (lpPrefixString)
    g_strcpy (lpTempFileName, lpPrefixString);
  u = (uUnique == 0 ? GetTickCount () : uUnique) & 0xffff;
  str = misc_str_from_val (u, 16, -4, FALSE);
  unique = g_ascii_strdown (str, -1);
  g_free (str);
  g_strcpy (lpTempFileName, unique);
  g_free (unique);
  return u;
}


/* GetTempFileNameW ordinal = 386, argument = 16 */
UINT WINAPI GetTempFileNameW (LPCWSTR lpPathName, LPCWSTR lpPrefixString, UINT uUnique, LPWSTR lpTempFileName)
{
  gchar *str, *unique;
  gunichar2 *utf16str;
  guint u;
  WCHAR wSep[2] = {'\\', '\0'};

  if (!lpPathName || !lpTempFileName)
    return 0;
  lstrcpyW (lpTempFileName, lpPathName);
  lstrcpyW (lpTempFileName, wSep);
  if (lpPrefixString)
    lstrcpyW (lpTempFileName, lpPrefixString);
  u = (uUnique == 0 ? GetTickCount () : uUnique) & 0xffff;
  str = misc_str_from_val (u, 16, -4, FALSE);
  unique = g_ascii_strdown (str, -1);
  g_free (str);
  utf16str = unique ? g_utf8_to_utf16 (unique, -1, NULL, NULL, NULL) : NULL;
  g_free (unique);
  lstrcpyW (lpTempFileName, utf16str);
  g_free (utf16str);
  return u;
}


/* GetTempPathA ordinal = 387, argument = 8 */
DWORD WINAPI GetTempPathA (DWORD nBufferLength, LPSTR lpBuffer)
{
  gsize leng;
  gchar *dir;

  dir = w32ldr_filename_to_mb (peimage_dir_get_path (PEIMAGE_DIR_TEMP));
  leng = g_strlen (dir) + 1;
  if (lpBuffer && nBufferLength >= leng)
    {
      g_strncpy (lpBuffer, dir, nBufferLength);
      leng--;
    }
  return leng;
}


/* GetTempPathW ordinal = 388, argument = 8 */
DWORD WINAPI GetTempPathW (DWORD nBufferLength, LPWSTR lpBuffer)
{
  gsize leng;
  gunichar2 *dir;

  dir = w32ldr_filename_to_wc (peimage_dir_get_path (PEIMAGE_DIR_TEMP));
  leng = lstrlenW (dir) + 1;
  if (lpBuffer && nBufferLength >= leng)
    {
      lstrcpynW (lpBuffer, dir, nBufferLength);
      leng--;
    }
  return leng;
}


/* GetThreadContext ordinal = 389, argument = 8 temporary */
static DWORD WINAPI GetThreadContext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetThreadLocale ordinal = 390, argument = 0 */
LCID WINAPI GetThreadLocale (VOID)
{
  return GetACP ();
}


/* GetThreadPriority ordinal = 391, argument = 4 */
INT WINAPI GetThreadPriority (HANDLE hThread)
{
  W32LdrHandle *w32handle;

  w32handle = hThread;
#ifdef USE_THREAD
  return w32handle && w32handle != INVALID_HANDLE_VALUE && w32handle->gthread
                        ? w32handle->priority : THREAD_PRIORITY_ERROR_RETURN;
#else /* not USE_THREAD */
  return w32handle && w32handle != INVALID_HANDLE_VALUE
                        ? w32handle->priority : THREAD_PRIORITY_ERROR_RETURN;
#endif /* not USE_THREAD */
}


/* GetThreadPriorityBoost ordinal = 392, argument = 8 temporary */
static DWORD WINAPI GetThreadPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetThreadSelectorEntry ordinal = 393, argument = 12 temporary */
static DWORD WINAPI GetThreadSelectorEntry (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetThreadTimes ordinal = 394, argument = 20 temporary */
static DWORD WINAPI GetThreadTimes (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTickCount ordinal = 395, argument = 0 */
DWORD WINAPI GetTickCount (VOID)
{
  GTimeVal timeval;

  g_get_current_time (&timeval);
  return (guint64)timeval.tv_sec * 1000 + timeval.tv_usec / 1000;
}


/* GetTimeFormatA ordinal = 396, argument = 24 temporary */
static DWORD WINAPI GetTimeFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetTimeFormatW ordinal = 397, argument = 24 temporary */
static DWORD WINAPI GetTimeFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetTimeZoneInformation ordinal = 398, argument = 4 */
DWORD WINAPI GetTimeZoneInformation (LPTIME_ZONE_INFORMATION lpTimeZoneInformation)
{
  if (!lpTimeZoneInformation)
    return TIME_ZONE_ID_INVALID;
  g_memset (lpTimeZoneInformation, 0 ,sizeof (TIME_ZONE_INFORMATION));
  return TIME_ZONE_ID_STANDARD;
}


/* GetUserDefaultLCID ordinal = 399, argument = 0 */
DWORD WINAPI GetUserDefaultLCID (VOID)
{
  return GetSystemDefaultLCID ();
}


/* GetUserDefaultLangID ordinal = 400, argument = 0 */
LANGID WINAPI GetUserDefaultLangID (VOID)
{
  return LANGIDFROMLCID (GetUserDefaultLCID ());
}


/* GetUserDefaultUILanguage ordinal = 401, argument = 0 */
LANGID WINAPI GetUserDefaultUILanguage (VOID)
{
  return GetUserDefaultLangID ();
}


/* GetVDMCurrentDirectories ordinal = 402, argument = 0 temporary */
static DWORD WINAPI GetVDMCurrentDirectories (VOID)
{
  return 0;
}


/* GetVersion ordinal = 403, argument = 0 */
DWORD WINAPI GetVersion (VOID)
{
  return 0;
}


/* GetVersionExA ordinal = 404, argument = 4 */
BOOL WINAPI GetVersionExA (LPOSVERSIONINFOA lpVersionInfo)
{
  if (!lpVersionInfo)
    return FALSE;
  lpVersionInfo->dwMajorVersion = 0;
  lpVersionInfo->dwMinorVersion = 0;
  lpVersionInfo->dwBuildNumber = 0;
  lpVersionInfo->dwPlatformId = VER_PLATFORM_WIN32_WINDOWS;
  g_strcpy (lpVersionInfo->szCSDVersion, "w32loader");
  return TRUE;
}


/* GetVersionExW ordinal = 405, argument = 4 */
BOOL WINAPI GetVersionExW (LPOSVERSIONINFOW lpVersionInfo)
{
  if (!lpVersionInfo)
    return FALSE;
  lpVersionInfo->dwMajorVersion = 0;
  lpVersionInfo->dwMinorVersion = 0;
  lpVersionInfo->dwBuildNumber = 0;
  lpVersionInfo->dwPlatformId = VER_PLATFORM_WIN32_WINDOWS;
  lpVersionInfo->szCSDVersion[0] = 'w';
  lpVersionInfo->szCSDVersion[1] = '3';
  lpVersionInfo->szCSDVersion[2] = '2';
  lpVersionInfo->szCSDVersion[3] = 'l';
  lpVersionInfo->szCSDVersion[4] = 'o';
  lpVersionInfo->szCSDVersion[5] = 'a';
  lpVersionInfo->szCSDVersion[6] = 'd';
  lpVersionInfo->szCSDVersion[7] = 'e';
  lpVersionInfo->szCSDVersion[8] = 'r';
  lpVersionInfo->szCSDVersion[9] = '\0';
  return TRUE;
}


/* GetVolumeInformationA ordinal = 406, argument = 32 temporary */
static DWORD WINAPI GetVolumeInformationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetVolumeInformationW ordinal = 407, argument = 32 temporary */
static DWORD WINAPI GetVolumeInformationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetVolumeNameForVolumeMountPointA ordinal = 408, argument = 12 temporary */
static DWORD WINAPI GetVolumeNameForVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumeNameForVolumeMountPointW ordinal = 409, argument = 12 temporary */
static DWORD WINAPI GetVolumeNameForVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumePathNameA ordinal = 410, argument = 12 temporary */
static DWORD WINAPI GetVolumePathNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumePathNameW ordinal = 411, argument = 12 temporary */
static DWORD WINAPI GetVolumePathNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetWindowsDirectoryA ordinal = 412, argument = 8 temporary */
static DWORD WINAPI GetWindowsDirectoryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowsDirectoryW ordinal = 413, argument = 8 temporary */
static DWORD WINAPI GetWindowsDirectoryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWriteWatch ordinal = 414, argument = 24 temporary */
static DWORD WINAPI GetWriteWatch (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GlobalAddAtomA ordinal = 415, argument = 4 */
ATOM WINAPI GlobalAddAtomA (LPCSTR lpString)
{
  return w32ldr_atom_add_name_mb (lpString);
}


/* GlobalAddAtomW ordinal = 416, argument = 4 */
ATOM WINAPI GlobalAddAtomW (LPCWSTR lpString)
{
  return w32ldr_atom_add_name_wc (lpString);
}


/* GlobalAlloc ordinal = 417, argument = 8 */
HGLOBAL WINAPI GlobalAlloc (UINT uFlags, UINT uBytes)
{
  LPUINT hMem;

  if (uBytes <= 0 || !(hMem = g_malloc0 (uBytes + sizeof (UINT) * 2)))
    return NULL;
  hMem[0] = uFlags;
  hMem[1] = uBytes;
  return hMem + 2;
}


/* GlobalCompact ordinal = 418, argument = 4 temporary */
static DWORD WINAPI GlobalCompact (DWORD dwArgv0)
{
  return 0;
}


/* GlobalDeleteAtom ordinal = 419, argument = 4 */
ATOM WINAPI GlobalDeleteAtom (ATOM nAtom)
{
  return w32ldr_atom_delete_atom (nAtom) ? 0 : nAtom;
}


/* GlobalFindAtomA ordinal = 420, argument = 4 */
ATOM WINAPI GlobalFindAtomA (LPCSTR lpString)
{
  return w32ldr_atom_find_name_mb (lpString);
}


/* GlobalFindAtomW ordinal = 421, argument = 4 */
ATOM WINAPI GlobalFindAtomW (LPCWSTR lpString)
{
  return w32ldr_atom_find_name_wc (lpString);
}


/* GlobalFix ordinal = 422, argument = 4 temporary */
static DWORD WINAPI GlobalFix (DWORD dwArgv0)
{
  return 0;
}


/* GlobalFlags ordinal = 423, argument = 4 */
UINT WINAPI GlobalFlags (HGLOBAL hMem)
{
  return hMem ? ((LPUINT)hMem)[-2] : GMEM_INVALID_HANDLE;
}


/* GlobalFree ordinal = 424, argument = 4 */
HGLOBAL WINAPI GlobalFree (HGLOBAL hMem)
{
  if (hMem)
    g_free ((LPUINT)hMem - 2);
  return NULL;
}


/* GlobalGetAtomNameA ordinal = 425, argument = 12 */
UINT WINAPI GlobalGetAtomNameA (ATOM nAtom, LPSTR lpBuffer, INT nSize)
{
  gchar *mb;
  UINT uResult = 0;

  mb = w32ldr_atom_get_name_mb (nAtom);
  if (mb)
    {
      uResult = g_strlen (mb);
      if (uResult < nSize)
        g_strcpy (lpBuffer, mb);
      else
        uResult = 0;
      g_free (mb);
    }
  return uResult;
}


/* GlobalGetAtomNameW ordinal = 426, argument = 12 */
UINT WINAPI GlobalGetAtomNameW (ATOM nAtom, LPWSTR lpBuffer, INT nSize)
{
  gunichar2 *wc;
  UINT uResult = 0;

  wc = w32ldr_atom_get_name_wc (nAtom);
  if (wc)
    {
      uResult = lstrlenW (wc);
      if (uResult < nSize)
        lstrcpyW (lpBuffer, wc);
      else
        uResult = 0;
      g_free (wc);
    }
  return uResult;
}


/* GlobalHandle ordinal = 427, argument = 4 */
HGLOBAL WINAPI GlobalHandle (LPCVOID pMem)
{
  return (HGLOBAL)pMem;
}


/* GlobalLock ordinal = 428, argument = 4 */
LPVOID WINAPI GlobalLock (HGLOBAL hMem)
{
  return hMem;
}


/* GlobalMemoryStatus ordinal = 429, argument = 4 temporary */
static DWORD WINAPI GlobalMemoryStatus (DWORD dwArgv0)
{
  return 0;
}


/* GlobalMemoryStatusEx ordinal = 430, argument = 4 temporary */
static DWORD WINAPI GlobalMemoryStatusEx (DWORD dwArgv0)
{
  return 0;
}


/* GlobalReAlloc ordinal = 431, argument = 12 */
HGLOBAL WINAPI GlobalReAlloc (HGLOBAL hMem, UINT uBytes, UINT uFlags)
{
  if (!hMem)
    return GlobalAlloc (uFlags, uBytes);
  if (uBytes <= 0)
    {
      g_free ((LPUINT)hMem - 2);
      return NULL;
    }
  hMem = g_realloc ((LPUINT)hMem - 2, uBytes + sizeof (UINT) * 2);
  if (!hMem)
    return NULL;
  if (((LPUINT)hMem)[1] < uBytes)
    g_memset ((guint8 *)hMem + sizeof (UINT) * 2 + ((LPUINT)hMem)[1], 0,
                                                uBytes - ((LPUINT)hMem)[1]);
  ((LPUINT)hMem)[1] = uBytes;
  return (LPUINT)hMem + 2;
}


/* GlobalSize ordinal = 432, argument = 4 */
UINT WINAPI GlobalSize (HGLOBAL hMem)
{
  return hMem ? ((LPUINT)hMem)[-1] : 0;
}


/* GlobalUnWire ordinal = 433, argument = 4 temporary */
static DWORD WINAPI GlobalUnWire (DWORD dwArgv0)
{
  return 0;
}


/* GlobalUnfix ordinal = 434, argument = 4 temporary */
static DWORD WINAPI GlobalUnfix (DWORD dwArgv0)
{
  return 0;
}


/* GlobalUnlock ordinal = 435, argument = 4 */
UINT WINAPI GlobalUnlock (HGLOBAL hMem)
{
  return FALSE;
}


/* GlobalWire ordinal = 436, argument = 4 temporary */
static DWORD WINAPI GlobalWire (DWORD dwArgv0)
{
  return 0;
}


/* Heap32First ordinal = 437, argument = 12 temporary */
static DWORD WINAPI Heap32First (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Heap32ListFirst ordinal = 438, argument = 8 temporary */
static DWORD WINAPI Heap32ListFirst (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Heap32ListNext ordinal = 439, argument = 8 temporary */
static DWORD WINAPI Heap32ListNext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Heap32Next ordinal = 440, argument = 4 temporary */
static DWORD WINAPI Heap32Next (DWORD dwArgv0)
{
  return 0;
}


/* HeapAlloc ordinal = 441, argument = 12 */
LPVOID WINAPI HeapAlloc (HANDLE hHeap, DWORD dwFlags, DWORD dwBytes)
{
  if (hHeap)
    {
      LPDWORD hMem;

      hMem = g_malloc0 (dwBytes + sizeof (DWORD) * 2);
      if (hMem)
        {
          gint i, index;
          LPDWORD *lpdwHeap;

          hMem[0] = dwFlags;
          hMem[1] = dwBytes;
          index = GPOINTER_TO_INT (hHeap) - 1;
#ifdef USE_THREAD
          G_LOCK (critical);
          critical = TRUE;
#endif /* USE_THREAD */
          lpdwHeap = lpHeap[index];
          for (i = 0; lpdwHeap[i]; i++);
          lpHeap[index] = lpdwHeap = g_realloc (lpHeap[index],
                                                (i + 2) * sizeof (LPDWORD));
          lpdwHeap[i] = hMem;
          lpdwHeap[i + 1] = NULL;
#ifdef USE_THREAD
          critical = FALSE;
          G_UNLOCK (critical);
#endif /* USE_THREAD */
          return hMem + 2;
        }
    }
  return NULL;
}


/* HeapCompact ordinal = 442, argument = 8 temporary */
static DWORD WINAPI HeapCompact (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* HeapCreate ordinal = 443, argument = 12 */
HANDLE WINAPI HeapCreate (DWORD flOptions, DWORD dwInitialSize, DWORD dwMaximumSize)
{
  gint i;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (lpHeap)
    {
      for (i = 0; lpHeap[i] != GINT_TO_POINTER (-1); i++)
        if (!lpHeap[i])
          break;
    }
  else
    {
      lpHeap = g_malloc (sizeof (LPDWORD *) * 3);
      lpHeap[0] = g_malloc0 (sizeof (LPDWORD));
      lpHeap[2] = GINT_TO_POINTER (-1);
      i = 1;
    }
  if (lpHeap[i] == GINT_TO_POINTER (-1))
    {
      lpHeap = g_realloc (lpHeap, (i + 2) * sizeof (LPDWORD *));
      lpHeap[i + 1] = GINT_TO_POINTER (-1);
    }
  lpHeap[i] = g_malloc0 (sizeof (LPDWORD));
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return GINT_TO_POINTER (i + 1);
}


/* HeapCreateTagsW ordinal = 444, argument = 0 temporary */
static DWORD WINAPI HeapCreateTagsW (VOID)
{
  return 0;
}


/* HeapDestroy ordinal = 445, argument = 4 */
BOOL WINAPI HeapDestroy (HANDLE hHeap)
{
  gint i, index;
  LPDWORD *lpdwHeap;

  index = GPOINTER_TO_INT (hHeap) - 1;
  if (index <= 0)
    return FALSE;
  lpdwHeap = lpHeap[index];
  lpHeap[index] = NULL;
  for (i = 0; lpdwHeap[i]; i++)
    g_free (lpdwHeap[i]);
  g_free (lpdwHeap);
  if (lpHeap[index + 1] == GINT_TO_POINTER (-1))
    {
      while (!lpHeap[index])
        index--;
      lpHeap = g_realloc (lpHeap, (index + 2) * sizeof (LPDWORD *));
      lpHeap[index + 1] = GINT_TO_POINTER (-1);
    }
  return TRUE;
}


/* HeapExtend ordinal = 446, argument = 0 temporary */
static DWORD WINAPI HeapExtend (VOID)
{
  return 0;
}


/* HeapFree ordinal = 447, argument = 12 */
BOOL WINAPI HeapFree (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem)
{
  gboolean result = FALSE;

  if (hHeap && lpMem)
    {
      gint i, index;
      LPDWORD *lpdwHeap;

      index = GPOINTER_TO_INT (hHeap) - 1;
#ifdef USE_THREAD
      G_LOCK (critical);
      critical = TRUE;
#endif /* USE_THREAD */
      lpdwHeap = lpHeap[index];
      for (i = 0; lpdwHeap[i]; i++)
        if (lpdwHeap[i] == (LPDWORD)lpMem - 2)
          {
            g_free (lpdwHeap[i]);
            while (lpdwHeap[i])
              {
                lpdwHeap[i] = lpdwHeap[i + 1];
                i++;
              }
            lpHeap[index] = g_realloc (lpHeap[index], i * sizeof (LPDWORD));
            result = TRUE;
            break;
          }
#ifdef USE_THREAD
      critical = FALSE;
      G_UNLOCK (critical);
#endif /* USE_THREAD */
    }
  return result;
}


/* HeapLock ordinal = 448, argument = 4 temporary */
static DWORD WINAPI HeapLock (DWORD dwArgv0)
{
  return 0;
}


/* HeapQueryInformation ordinal = 449, argument = 20 temporary */
static DWORD WINAPI HeapQueryInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* HeapQueryTagW ordinal = 450, argument = 0 temporary */
static DWORD WINAPI HeapQueryTagW (VOID)
{
  return 0;
}


/* HeapReAlloc ordinal = 451, argument = 16 */
LPVOID WINAPI HeapReAlloc (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem, DWORD dwBytes)
{
  gpointer result = NULL;

  if (hHeap)
    {
      gint i, index;
      LPDWORD *lpdwHeap;

      if (!lpMem)
        return HeapAlloc (hHeap, dwFlags, dwBytes);
      index = GPOINTER_TO_INT (hHeap) - 1;
#ifdef USE_THREAD
      G_LOCK (critical);
      critical = TRUE;
#endif /* USE_THREAD */
      lpdwHeap = lpHeap[index];
      for (i = 0; lpdwHeap[i]; i++)
        if (lpdwHeap[i] == (LPDWORD)lpMem - 2)
          {
            lpdwHeap[i] = g_realloc (lpdwHeap[i],
                                                dwBytes + sizeof (DWORD) * 2);
            if ((lpdwHeap[i])[1] < dwBytes)
              g_memset ((guint8 *)(lpdwHeap[i] + 2) + (lpdwHeap[i])[1], 0,
                                                dwBytes - (lpdwHeap[i])[1]);
            (lpdwHeap[i])[0] = dwFlags;
            (lpdwHeap[i])[1] = dwBytes;
            result = lpdwHeap[i] + 2;
            break;
          }
#ifdef USE_THREAD
      critical = FALSE;
      G_UNLOCK (critical);
#endif /* USE_THREAD */
    }
  return result;
}


/* HeapSetInformation ordinal = 452, argument = 16 temporary */
static DWORD WINAPI HeapSetInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* HeapSize ordinal = 453, argument = 12 */
DWORD WINAPI HeapSize (HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem)
{
  return lpMem ? ((LPDWORD)lpMem)[-1] : 0;
}


/* HeapSummary ordinal = 454, argument = 0 temporary */
static DWORD WINAPI HeapSummary (VOID)
{
  return 0;
}


/* HeapUnlock ordinal = 455, argument = 4 temporary */
static DWORD WINAPI HeapUnlock (DWORD dwArgv0)
{
  return 0;
}


/* HeapUsage ordinal = 456, argument = 0 temporary */
static DWORD WINAPI HeapUsage (VOID)
{
  return 0;
}


/* HeapValidate ordinal = 457, argument = 12 temporary */
static DWORD WINAPI HeapValidate (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* HeapWalk ordinal = 458, argument = 8 temporary */
static DWORD WINAPI HeapWalk (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InitAtomTable ordinal = 459, argument = 4 */
BOOL WINAPI InitAtomTable (DWORD nSize)
{
  return TRUE;
}


/* InitializeCriticalSection ordinal = 460, argument = 4 */
VOID WINAPI InitializeCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  lpCriticalSection = (LPCRITICAL_SECTION)g_mutex_new ();
}


/* InitializeCriticalSectionAndSpinCount ordinal = 461, argument = 8 temporary */
static DWORD WINAPI InitializeCriticalSectionAndSpinCount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InterlockedCompareExchange ordinal = 462, argument = 12 */
PVOID WINAPI InterlockedCompareExchange (PVOID *Destination, PVOID Exchange, PVOID Comperand)
{
  PVOID pResult;

  pResult = *Destination;
  if (*Destination == Comperand)
    *Destination = Exchange;
  return pResult;
}


/* InterlockedDecrement ordinal = 463, argument = 4 */
LONG WINAPI InterlockedDecrement (LPLONG lpAddend)
{
  InterlockedExchangeAdd (lpAddend, -1);
  return lpAddend ? *lpAddend : 0;
}


/* InterlockedExchange ordinal = 464, argument = 8 */
LONG WINAPI InterlockedExchange (LPLONG Target, LONG Value)
{
  LONG lResult = 0;

  if (Target)
    {
      lResult = *Target;
      *Target = Value;
    }
  return lResult;
}


/* InterlockedExchangeAdd ordinal = 465, argument = 8 */
LONG WINAPI InterlockedExchangeAdd (PLONG lpAddend, LONG Increment)
{
  LONG lResult = 0;

  if (lpAddend)
    {
      lResult = *lpAddend;
      *lpAddend += Increment;
    }
  return lResult;
}


/* InterlockedIncrement ordinal = 466, argument = 4 */
LONG WINAPI InterlockedIncrement (LPLONG lpAddend)
{
  InterlockedExchangeAdd (lpAddend, 1);
  return lpAddend ? *lpAddend : 0;
}


/* InvalidateConsoleDIBits ordinal = 467, argument = 0 temporary */
static DWORD WINAPI InvalidateConsoleDIBits (VOID)
{
  return 0;
}


/* IsBadCodePtr ordinal = 468, argument = 4 */
BOOL WINAPI IsBadCodePtr (FARPROC lpfn)
{
  return TRUE;
}


/* IsBadHugeReadPtr ordinal = 469, argument = 8 temporary */
static DWORD WINAPI IsBadHugeReadPtr (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadHugeWritePtr ordinal = 470, argument = 8 temporary */
static DWORD WINAPI IsBadHugeWritePtr (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadReadPtr ordinal = 471, argument = 8 */
BOOL WINAPI IsBadReadPtr (LPVOID lp, UINT ucb)
{
  return TRUE;
}


/* IsBadStringPtrA ordinal = 472, argument = 8 temporary */
static DWORD WINAPI IsBadStringPtrA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadStringPtrW ordinal = 473, argument = 8 temporary */
static DWORD WINAPI IsBadStringPtrW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadWritePtr ordinal = 474, argument = 8 */
BOOL WINAPI IsBadWritePtr (LPVOID lp, UINT ucb)
{
  return TRUE;
}


/* IsDBCSLeadByte ordinal = 475, argument = 4 */
BOOL WINAPI IsDBCSLeadByte (BYTE bTestChar)
{
  return IsDBCSLeadByteEx (CP_ACP, bTestChar);
}


/* IsDBCSLeadByteEx ordinal = 476, argument = 8 */
BOOL IsDBCSLeadByteEx (UINT CodePage, BYTE bTestChar)
{
  CPINFO CPInfo;

  if (GetCPInfo (CodePage, &CPInfo))
    {
      gint i;

      for (i = 0; CPInfo.LeadByte[i] != 0; i += 2)
        if (CPInfo.LeadByte[i] <= bTestChar
                                        && bTestChar <= CPInfo.LeadByte[i + 1])
          return TRUE;
    }
  return FALSE;
}


/* IsDebuggerPresent ordinal = 477, argument = 0 temporary */
static DWORD WINAPI IsDebuggerPresent (VOID)
{
  return 0;
}


/* IsProcessorFeaturePresent ordinal = 478, argument = 4 temporary */
static DWORD WINAPI IsProcessorFeaturePresent (DWORD dwArgv0)
{
  return 0;
}


/* IsSystemResumeAutomatic ordinal = 479, argument = 0 temporary */
static DWORD WINAPI IsSystemResumeAutomatic (VOID)
{
  return 0;
}


/* IsValidCodePage ordinal = 480, argument = 4 temporary */
static DWORD WINAPI IsValidCodePage (DWORD dwArgv0)
{
  return 0;
}


/* IsValidLanguageGroup ordinal = 481, argument = 8 temporary */
static DWORD WINAPI IsValidLanguageGroup (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsValidLocale ordinal = 482, argument = 8 temporary */
static DWORD WINAPI IsValidLocale (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LCMapStringA ordinal = 483, argument = 24 */
INT WINAPI LCMapStringA (LCID Locale, DWORD dwMapFlags, LPCSTR lpSrcStr, INT cchSrc, LPSTR lpDestStr, INT cchDest)
{
  gint leng;

  if (!lpSrcStr)
    return 0;
  leng = cchSrc >= 0 ? cchSrc : g_strlen (lpSrcStr) + 1;
  if (!lpDestStr || cchDest <= 0)
    return leng;
  if (leng > cchDest)
    return 0;
  if (dwMapFlags & LCMAP_SORTKEY)
    g_memset (lpDestStr, 0, leng);
  else
    g_strcpy (lpDestStr, lpSrcStr);
  return leng;
}


/* LCMapStringW ordinal = 484, argument = 24 */
INT WINAPI LCMapStringW (LCID Locale, DWORD dwMapFlags, LPCWSTR lpSrcStr, INT cchSrc, LPWSTR lpDestStr, INT cchDest)
{
  gint leng;

  if (!lpSrcStr)
    return 0;
  leng = cchSrc >= 0 ? cchSrc : lstrlenW (lpSrcStr) + 1;
  if (!lpDestStr || cchDest <= 0)
    return leng;
  if (leng > cchDest)
    return 0;
  if (dwMapFlags & LCMAP_SORTKEY)
    g_memset (lpDestStr, 0, leng);
  else
    lstrcpyW (lpDestStr, lpSrcStr);
  return leng;
}


/* LeaveCriticalSection ordinal = 485, argument = 4 */
VOID WINAPI LeaveCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_unlock ((GMutex *)lpCriticalSection);
}


/* LoadLibraryA ordinal = 486, argument = 4 */
HINSTANCE WINAPI LoadLibraryA (LPCSTR lpFileName)
{
  return LoadLibraryExA (lpFileName, NULL, 0);
}


/* LoadLibraryExA ordinal = 487, argument = 12 */
HINSTANCE WINAPI LoadLibraryExA (LPCSTR lpLibFileName, HANDLE hFile, DWORD dwFlags)
{
  gpointer memory;
  gchar *file;

  file = w32ldr_filename_from_mb (lpLibFileName);
  memory = w32ldr_module_load_library (file,
                                        !(dwFlags & LOAD_LIBRARY_AS_DATAFILE));
  g_free (file);
  return memory;
}


/* LoadLibraryExW ordinal = 488, argument = 12 */
HINSTANCE WINAPI LoadLibraryExW (LPCWSTR lpLibFileName, HANDLE hFile, DWORD dwFlags)
{
  gpointer memory;
  gchar *file;

  file = w32ldr_filename_from_wc (lpLibFileName);
  memory = w32ldr_module_load_library (file,
                                        !(dwFlags & LOAD_LIBRARY_AS_DATAFILE));
  g_free (file);
  return memory;
}


/* LoadLibraryW ordinal = 489, argument = 4 */
HINSTANCE WINAPI LoadLibraryW (LPCWSTR lpFileName)
{
  return LoadLibraryExW (lpFileName, NULL, 0);
}


/* LoadModule ordinal = 490, argument = 8 temporary */
static DWORD WINAPI LoadModule (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadResource ordinal = 491, argument = 8 */
HGLOBAL WINAPI LoadResource (HMODULE hModule, HRSRC hResInfo)
{
  return hModule && hResInfo ? (LPBYTE)hModule
                + ((PIMAGE_RESOURCE_DATA_ENTRY)hResInfo)->OffsetToData : NULL;
}


/* LocalAlloc ordinal = 492, argument = 8 */
HLOCAL WINAPI LocalAlloc (UINT uFlags, UINT uBytes)
{
  return GlobalAlloc (uFlags, uBytes);
}


/* LocalCompact ordinal = 493, argument = 4 temporary */
static DWORD WINAPI LocalCompact (DWORD dwArgv0)
{
  return 0;
}


/* LocalFileTimeToFileTime ordinal = 494, argument = 8 */
BOOL WINAPI LocalFileTimeToFileTime (LPCFILETIME lpLocalFileTime, LPFILETIME lpFileTime)
{
  *lpFileTime = *lpLocalFileTime;
  return TRUE;
}


/* LocalFlags ordinal = 495, argument = 4 */
UINT WINAPI LocalFlags (HLOCAL hMem)
{
  return GlobalFlags (hMem);
}


/* LocalFree ordinal = 496, argument = 4 */
HLOCAL WINAPI LocalFree (HLOCAL hMem)
{
  return GlobalFree (hMem);
}


/* LocalHandle ordinal = 497, argument = 4 */
HLOCAL WINAPI LocalHandle (LPCVOID pMem)
{
  return GlobalHandle (pMem);
}


/* LocalLock ordinal = 498, argument = 4 */
LPVOID WINAPI LocalLock (HLOCAL hMem)
{
  return GlobalLock (hMem);
}


/* LocalReAlloc ordinal = 499, argument = 12 */
HLOCAL WINAPI LocalReAlloc (HLOCAL hMem, UINT uBytes, UINT uFlags)
{
  return GlobalReAlloc (hMem, uBytes, uFlags);
}


/* LocalShrink ordinal = 500, argument = 8 temporary */
static DWORD WINAPI LocalShrink (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LocalSize ordinal = 501, argument = 4 */
UINT WINAPI LocalSize (HLOCAL hMem)
{
  return GlobalSize (hMem);
}


/* LocalUnlock ordinal = 502, argument = 4 */
UINT WINAPI LocalUnlock (HLOCAL hMem)
{
  return GlobalUnlock (hMem);
}


/* LockFile ordinal = 503, argument = 20 temporary */
static DWORD WINAPI LockFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LockFileEx ordinal = 504, argument = 24 temporary */
static DWORD WINAPI LockFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LockResource ordinal = 505, argument = 4 */
LPVOID WINAPI LockResource (HGLOBAL hResData)
{
  return hResData;
}


/* MapUserPhysicalPages ordinal = 506, argument = 12 temporary */
static DWORD WINAPI MapUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapUserPhysicalPagesScatter ordinal = 507, argument = 12 temporary */
static DWORD WINAPI MapUserPhysicalPagesScatter (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapViewOfFile ordinal = 508, argument = 20 */
LPVOID WINAPI MapViewOfFile (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap)
{
  if (!hFileMappingObject || !((W32LdrHandle *)hFileMappingObject)->p
        || ((W32LdrHandle *)hFileMappingObject)->length
                                    < dwFileOffsetLow + dwNumberOfBytesToMap)
    return NULL;
  return (guint8 *)((W32LdrHandle *)hFileMappingObject)->p + dwFileOffsetLow;
}


/* MapViewOfFileEx ordinal = 509, argument = 24 */
LPVOID WINAPI MapViewOfFileEx (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap, LPVOID lpBaseAddress)
{
  return NULL;
}


/* Module32First ordinal = 510, argument = 8 temporary */
static DWORD WINAPI Module32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32FirstW ordinal = 511, argument = 8 temporary */
static DWORD WINAPI Module32FirstW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32Next ordinal = 512, argument = 8 temporary */
static DWORD WINAPI Module32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32NextW ordinal = 513, argument = 8 temporary */
static DWORD WINAPI Module32NextW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MoveFileA ordinal = 514, argument = 8 */
BOOL WINAPI MoveFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName)
{
  gchar *oldfile, *newfile;
  gint result;

  oldfile = w32ldr_filename_from_mb (lpExistingFileName);
  newfile = w32ldr_filename_from_mb (lpNewFileName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_rename (oldfile, newfile);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = rename (oldfile, newfile);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (oldfile);
  g_free (newfile);
  return result == 0;
}


/* MoveFileExA ordinal = 515, argument = 12 */
BOOL WINAPI MoveFileExA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, DWORD dwFlags)
{
  return MoveFileA (lpExistingFileName, lpNewFileName);
}


/* MoveFileExW ordinal = 516, argument = 12 */
BOOL WINAPI MoveFileExW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, DWORD dwFlags)
{
  return MoveFileW (lpExistingFileName, lpNewFileName);
}


/* MoveFileW ordinal = 517, argument = 8 */
BOOL WINAPI MoveFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName)
{
  gchar *oldfile, *newfile;
  gint result;

  oldfile = w32ldr_filename_from_wc (lpExistingFileName);
  newfile = w32ldr_filename_from_wc (lpNewFileName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_rename (oldfile, newfile);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = rename (oldfile, newfile);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (oldfile);
  g_free (newfile);
  return result == 0;
}


/* MoveFileWithProgressA ordinal = 518, argument = 20 temporary */
static DWORD WINAPI MoveFileWithProgressA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MoveFileWithProgressW ordinal = 519, argument = 20 temporary */
static DWORD WINAPI MoveFileWithProgressW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MulDiv ordinal = 520, argument = 12 */
INT WINAPI MulDiv (INT nNumber, INT nNumerator, INT nDenominator)
{
  if (nDenominator == 0)
    return -1;
  return (glonglong)nNumber * (glonglong)nNumerator / (glonglong)nDenominator;
}


/* MultiByteToWideChar ordinal = 521, argument = 24 */
INT WINAPI MultiByteToWideChar (UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, INT cchMultiByte, LPWSTR lpWideCharStr, INT cchWideChar)
{
  gsize bytes_read, bytes_written, bytes_read_prev = (gsize)-1;
  gssize len;
  gchar *charset, *mb;
  gunichar2 *wc;
  gint result;
  GError *error = NULL;

  if (!lpMultiByteStr || cchMultiByte == 0)
    return 0;
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP:
      case CP_THREAD_ACP:
      case CP_SYMBOL:
        charset = g_strdup_printf ("CP%d", GetACP ());
        break;
      case CP_OEMCP:
        charset = g_strdup_printf ("CP%d", GetOEMCP ());
        break;
      case CP_UTF7:
        charset = g_strdup ("UTF-7");
        break;
      case CP_UTF8:
        charset = g_strdup ("UTF-8");
        break;
      default:
        charset = g_strdup_printf ("CP%d", CodePage);
    }
  len = (cchMultiByte < 0 ? g_strlen (lpMultiByteStr) + 1 : cchMultiByte)
                                                            * sizeof (gchar);
  mb = g_memdup (lpMultiByteStr, len * sizeof (gchar));
  while ((g_clear_error (&error),
            !(wc = (gunichar2 *)g_convert (mb, len, "UTF-16LE", charset,
                                        &bytes_read, &bytes_written, &error)))
                                    && bytes_read_prev != bytes_read && error
                                    && g_error_matches (error, G_CONVERT_ERROR,
                                            G_CONVERT_ERROR_ILLEGAL_SEQUENCE))
    {
      mb[bytes_read] = '?';
      bytes_read_prev = bytes_read;
    }
  g_free (mb);
  g_free (charset);
  if (wc)
    {
      result = bytes_written / sizeof (gunichar2);
    }
  else
    {
      gint i;

      /* ja:キャラクターセットが無効 */
      wc = g_malloc (len * sizeof (gunichar2));
      for (i = 0; i < len; i++)
        wc[i] = lpMultiByteStr[i] & 0x80 ? '?' : lpMultiByteStr[i];
      result = len;
    }
  if (lpWideCharStr && cchWideChar > 0)
    {
      if (result > cchWideChar)
        result = cchWideChar;
      g_memmove (lpWideCharStr, wc, result * sizeof (gunichar2));
    }
  g_free (wc);
  return result;
}


/* NlsConvertIntegerToString ordinal = 522, argument = 0 temporary */
static DWORD WINAPI NlsConvertIntegerToString (VOID)
{
  return 0;
}


/* NlsGetCacheUpdateCount ordinal = 523, argument = 0 temporary */
static DWORD WINAPI NlsGetCacheUpdateCount (VOID)
{
  return 0;
}


/* NlsResetProcessLocale ordinal = 524, argument = 0 temporary */
static DWORD WINAPI NlsResetProcessLocale (VOID)
{
  return 0;
}


/* OpenConsoleW ordinal = 525, argument = 0 temporary */
static DWORD WINAPI OpenConsoleW (VOID)
{
  return 0;
}


/* OpenDataFile ordinal = 526, argument = 0 temporary */
static DWORD WINAPI OpenDataFile (VOID)
{
  return 0;
}


/* OpenEventA ordinal = 527, argument = 12 */
HANDLE WINAPI OpenEventA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  HANDLE hEvent;

  utf8str = w32ldr_utf8_from_mb (lpName);
  utf16str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  hEvent = OpenEventW (dwDesiredAccess, bInheritHandle, utf16str);
  g_free (utf16str);
  g_free (utf8str);
  return hEvent;
}


/* OpenEventW ordinal = 528, argument = 12 */
HANDLE WINAPI OpenEventW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
  W32LdrHandle *w32handle = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (ghash_signal && lpName)
    {
      gchar *name;

      name = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
      if (name)
        {
          W32LdrSignal *w32signal;

          w32signal = g_hash_table_lookup (ghash_signal, name);
          g_free (name);
          if (w32signal && w32signal->max < 0)
            {
              w32signal->counter++;
              w32handle = g_malloc0 (sizeof (W32LdrHandle));
              w32handle->w32signal = w32signal;
            }
        }
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* OpenFile ordinal = 529, argument = 12 temporary */
static DWORD WINAPI OpenFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenFileMappingA ordinal = 530, argument = 12 */
HANDLE WINAPI OpenFileMappingA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName)
{
  return CreateFileMappingA (INVALID_HANDLE_VALUE,
                                            NULL, PAGE_READONLY, 0, 0, lpName);
}


/* OpenFileMappingW ordinal = 531, argument = 12 */
HANDLE WINAPI OpenFileMappingW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
  return CreateFileMappingW (INVALID_HANDLE_VALUE,
                                            NULL, PAGE_READONLY, 0, 0, lpName);
}


/* OpenJobObjectA ordinal = 532, argument = 12 temporary */
static DWORD WINAPI OpenJobObjectA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenJobObjectW ordinal = 533, argument = 12 temporary */
static DWORD WINAPI OpenJobObjectW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenMutexA ordinal = 534, argument = 12 */
HANDLE WINAPI OpenMutexA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *name;
  HANDLE hMutex;

  utf8str = w32ldr_utf8_from_mb (lpName);
  name = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  hMutex = OpenMutexW (dwDesiredAccess, bInheritHandle, name);
  g_free (name);
  return hMutex;
}


/* OpenMutexW ordinal = 535, argument = 12 */
HANDLE WINAPI OpenMutexW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
  W32LdrHandle *w32handle = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (ghash_signal && lpName)
    {
      gchar *name;

      name = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
      if (name)
        {
          W32LdrSignal *w32signal;

          w32signal = g_hash_table_lookup (ghash_signal, name);
          g_free (name);
          if (w32signal && w32signal->max == 0)
            {
              w32signal->counter++;
              w32handle = g_malloc0 (sizeof (W32LdrHandle));
              w32handle->w32signal = w32signal;
            }
        }
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* OpenProcess ordinal = 536, argument = 12 temporary */
static DWORD WINAPI OpenProcess (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenProfileUserMapping ordinal = 537, argument = 0 temporary */
static DWORD WINAPI OpenProfileUserMapping (VOID)
{
  return 0;
}


/* OpenSemaphoreA ordinal = 538, argument = 12 */
HANDLE WINAPI OpenSemaphoreA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName)
{
  gchar *utf8str;
  gunichar2 *utf16str;
  HANDLE hSemaphore;

  utf8str = w32ldr_utf8_from_mb (lpName);
  utf16str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  hSemaphore = OpenSemaphoreW (dwDesiredAccess, bInheritHandle, utf16str);
  g_free (utf16str);
  g_free (utf8str);
  return hSemaphore;
}


/* OpenSemaphoreW ordinal = 539, argument = 12 */
HANDLE WINAPI OpenSemaphoreW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
  W32LdrHandle *w32handle = NULL;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (ghash_signal && lpName)
    {
      gchar *name;

      name = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
      if (name)
        {
          W32LdrSignal *w32signal;

          w32signal = g_hash_table_lookup (ghash_signal, name);
          g_free (name);
          if (w32signal && w32signal->max > 0)
            {
              w32signal->counter++;
              w32handle = g_malloc0 (sizeof (W32LdrHandle));
              w32handle->w32signal = w32signal;
            }
        }
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return w32handle;
}


/* OpenThread ordinal = 540, argument = 12 temporary */
static DWORD WINAPI OpenThread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWaitableTimerA ordinal = 541, argument = 12 temporary */
static DWORD WINAPI OpenWaitableTimerA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWaitableTimerW ordinal = 542, argument = 12 temporary */
static DWORD WINAPI OpenWaitableTimerW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OutputDebugStringA ordinal = 543, argument = 4 */
VOID WINAPI OutputDebugStringA (LPCSTR lpOutputString)
{
  gchar *str;

  str = w32ldr_utf8_from_mb (lpOutputString);
  if (str)
    {
      g_print ("%s", str);
      g_free (str);
    }
}


/* OutputDebugStringW ordinal = 544, argument = 4 */
VOID WINAPI OutputDebugStringW (LPCWSTR lpOutputString)
{
  if (lpOutputString)
    {
      gchar *str;

      str = g_utf16_to_utf8 (lpOutputString, -1, NULL, NULL, NULL);
      if (str)
        {
          g_print ("%s", str);
          g_free (str);
        }
    }
}


/* PeekConsoleInputA ordinal = 545, argument = 16 temporary */
static DWORD WINAPI PeekConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PeekConsoleInputW ordinal = 546, argument = 16 temporary */
static DWORD WINAPI PeekConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PeekNamedPipe ordinal = 547, argument = 24 temporary */
static DWORD WINAPI PeekNamedPipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* PostQueuedCompletionStatus ordinal = 548, argument = 16 temporary */
static DWORD WINAPI PostQueuedCompletionStatus (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PrepareTape ordinal = 549, argument = 12 temporary */
static DWORD WINAPI PrepareTape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PrivCopyFileExW ordinal = 550, argument = 0 temporary */
static DWORD WINAPI PrivCopyFileExW (VOID)
{
  return 0;
}


/* PrivMoveFileIdentityW ordinal = 551, argument = 0 temporary */
static DWORD WINAPI PrivMoveFileIdentityW (VOID)
{
  return 0;
}


/* Process32First ordinal = 552, argument = 8 temporary */
static DWORD WINAPI Process32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32FirstW ordinal = 553, argument = 8 temporary */
static DWORD WINAPI Process32FirstW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32Next ordinal = 554, argument = 8 temporary */
static DWORD WINAPI Process32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32NextW ordinal = 555, argument = 8 temporary */
static DWORD WINAPI Process32NextW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ProcessIdToSessionId ordinal = 556, argument = 8 temporary */
static DWORD WINAPI ProcessIdToSessionId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PulseEvent ordinal = 557, argument = 4 */
BOOL WINAPI PulseEvent (HANDLE hEvent)
{
#ifdef USE_THREAD
  BOOL fResult;

  fResult = SetEvent (hEvent);
  if (fResult)
    {
      Sleep (100);
      fResult = ResetEvent (hEvent);
    }
  return fResult;
#else /* not USE_THREAD */
  return TRUE;
#endif /* not USE_THREAD */
}


/* PurgeComm ordinal = 558, argument = 8 temporary */
static DWORD WINAPI PurgeComm (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* QueryDosDeviceA ordinal = 559, argument = 12 temporary */
static DWORD WINAPI QueryDosDeviceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryDosDeviceW ordinal = 560, argument = 12 temporary */
static DWORD WINAPI QueryDosDeviceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryInformationJobObject ordinal = 561, argument = 20 temporary */
static DWORD WINAPI QueryInformationJobObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryPerformanceCounter ordinal = 562, argument = 4 */
BOOL WINAPI QueryPerformanceCounter (LARGE_INTEGER *lpPerformanceCount)
{
  return FALSE;
}


/* QueryPerformanceFrequency ordinal = 563, argument = 4 */
BOOL WINAPI QueryPerformanceFrequency (LARGE_INTEGER *lpFrequency)
{
  return FALSE;
}


/* QueryWin31IniFilesMappedToRegistry ordinal = 564, argument = 0 temporary */
static DWORD WINAPI QueryWin31IniFilesMappedToRegistry (VOID)
{
  return 0;
}


/* QueueUserAPC ordinal = 565, argument = 12 temporary */
static DWORD WINAPI QueueUserAPC (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueueUserWorkItem ordinal = 566, argument = 12 temporary */
static DWORD WINAPI QueueUserWorkItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RaiseException ordinal = 567, argument = 16 */
VOID WINAPI RaiseException (DWORD dwExceptionCode, DWORD dwExceptionFlags, DWORD nNumberOfArguments, CONST ULONG_PTR *lpArguments)
{
}


/* ReadConsoleA ordinal = 568, argument = 20 temporary */
static DWORD WINAPI ReadConsoleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleInputA ordinal = 569, argument = 16 temporary */
static DWORD WINAPI ReadConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ReadConsoleInputExA ordinal = 570, argument = 0 temporary */
static DWORD WINAPI ReadConsoleInputExA (VOID)
{
  return 0;
}


/* ReadConsoleInputExW ordinal = 571, argument = 0 temporary */
static DWORD WINAPI ReadConsoleInputExW (VOID)
{
  return 0;
}


/* ReadConsoleInputW ordinal = 572, argument = 16 temporary */
static DWORD WINAPI ReadConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ReadConsoleOutputA ordinal = 573, argument = 20 temporary */
static DWORD WINAPI ReadConsoleOutputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputAttribute ordinal = 574, argument = 20 temporary */
static DWORD WINAPI ReadConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputCharacterA ordinal = 575, argument = 20 temporary */
static DWORD WINAPI ReadConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputCharacterW ordinal = 576, argument = 20 temporary */
static DWORD WINAPI ReadConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputW ordinal = 577, argument = 20 temporary */
static DWORD WINAPI ReadConsoleOutputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleW ordinal = 578, argument = 20 temporary */
static DWORD WINAPI ReadConsoleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadDirectoryChangesW ordinal = 579, argument = 32 temporary */
static DWORD WINAPI ReadDirectoryChangesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* ReadFile ordinal = 580, argument = 20 */
BOOL WINAPI ReadFile (HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped)
{
  gssize bytes_read;

  if (lpNumberOfBytesRead)
    *lpNumberOfBytesRead = 0;
  if (hFile == INVALID_HANDLE_VALUE)
    return FALSE;
  if (nNumberOfBytesToRead <= 0)
    return TRUE;
  bytes_read = fileio_read (((W32LdrHandle *)hFile)->fio,
                                            lpBuffer, nNumberOfBytesToRead);
  if (lpNumberOfBytesRead)
    *lpNumberOfBytesRead = bytes_read;
  return bytes_read >= 0;
}


/* ReadFileEx ordinal = 581, argument = 20 temporary */
static DWORD WINAPI ReadFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadFileScatter ordinal = 582, argument = 20 temporary */
static DWORD WINAPI ReadFileScatter (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadProcessMemory ordinal = 583, argument = 20 temporary */
static DWORD WINAPI ReadProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegisterConsoleIME ordinal = 584, argument = 0 temporary */
static DWORD WINAPI RegisterConsoleIME (VOID)
{
  return 0;
}


/* RegisterConsoleOS2 ordinal = 585, argument = 0 temporary */
static DWORD WINAPI RegisterConsoleOS2 (VOID)
{
  return 0;
}


/* RegisterConsoleVDM ordinal = 586, argument = 0 temporary */
static DWORD WINAPI RegisterConsoleVDM (VOID)
{
  return 0;
}


/* RegisterWaitForInputIdle ordinal = 587, argument = 0 temporary */
static DWORD WINAPI RegisterWaitForInputIdle (VOID)
{
  return 0;
}


/* RegisterWaitForSingleObject ordinal = 588, argument = 24 temporary */
static DWORD WINAPI RegisterWaitForSingleObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RegisterWaitForSingleObjectEx ordinal = 589, argument = 20 temporary */
static DWORD WINAPI RegisterWaitForSingleObjectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegisterWowBaseHandlers ordinal = 590, argument = 0 temporary */
static DWORD WINAPI RegisterWowBaseHandlers (VOID)
{
  return 0;
}


/* RegisterWowExec ordinal = 591, argument = 0 temporary */
static DWORD WINAPI RegisterWowExec (VOID)
{
  return 0;
}


/* ReleaseMutex ordinal = 592, argument = 4 */
BOOL WINAPI ReleaseMutex (HANDLE hMutex)
{
  W32LdrHandle *w32handle;
  BOOL fResult = FALSE;

  w32handle = hMutex;
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
  if (w32handle && w32handle->w32signal && w32handle->w32signal->max == 0
                        && w32handle->w32signal->count <= 0
                        && w32handle->w32signal->gthread == g_thread_self ())
    {
      w32handle->w32signal->count = 1;
      w32handle->w32signal->gthread = NULL;
      fResult = TRUE;
    }
  critical = FALSE;
  G_UNLOCK (critical);
#else /* not USE_THREAD */
  if (w32handle && w32handle->w32signal && w32handle->w32signal->max == 0
                                        && w32handle->w32signal->count <= 0)
    {
      w32handle->w32signal->count = 1;
      fResult = TRUE;
    }
#endif /* not USE_THREAD */
  return fResult;
}


/* ReleaseSemaphore ordinal = 593, argument = 12 */
BOOL WINAPI ReleaseSemaphore (HANDLE hSemaphore, LONG lReleaseCount, LPLONG lpPreviousCount)
{
  W32LdrHandle *w32handle;
  BOOL fResult = FALSE;

  w32handle = hSemaphore;
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (w32handle && w32handle->w32signal && w32handle->w32signal->max > 0)
    {
      if (lpPreviousCount)
        *lpPreviousCount = w32handle->w32signal->count;
      w32handle->w32signal->count += lReleaseCount;
      if (w32handle->w32signal->count > w32handle->w32signal->max)
        w32handle->w32signal->count = w32handle->w32signal->max;
      fResult = TRUE;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return fResult;
}


/* RemoveDirectoryA ordinal = 594, argument = 4 */
BOOL WINAPI RemoveDirectoryA (LPCSTR lpPathName)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_mb (lpPathName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_rmdir (path);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = rmdir (path);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (path);
  return result == 0;
}


/* RemoveDirectoryW ordinal = 595, argument = 4 */
BOOL WINAPI RemoveDirectoryW (LPCWSTR lpPathName)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_wc (lpPathName);
#if GLIB_CHECK_VERSION(2,6,0)
  result = g_rmdir (path);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  result = rmdir (path);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
  g_free (path);
  return result == 0;
}


/* ReplaceFile ordinal = 596, argument = 24 temporary */
/* DWORD WINAPI ReplaceFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5) */


/* ReplaceFileA ordinal = 597, argument = 24 temporary */
static DWORD WINAPI ReplaceFileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ReplaceFileW ordinal = 598, argument = 24 temporary */
static DWORD WINAPI ReplaceFileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RequestDeviceWakeup ordinal = 599, argument = 4 temporary */
static DWORD WINAPI RequestDeviceWakeup (DWORD dwArgv0)
{
  return 0;
}


/* RequestWakeupLatency ordinal = 600, argument = 4 temporary */
static DWORD WINAPI RequestWakeupLatency (DWORD dwArgv0)
{
  return 0;
}


/* ResetEvent ordinal = 601, argument = 4 */
BOOL WINAPI ResetEvent (HANDLE hEvent)
{
  W32LdrHandle *w32handle;
  BOOL fResult = FALSE;

  w32handle = hEvent;
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (w32handle && w32handle->w32signal && w32handle->w32signal->max < 0)
    {
      w32handle->w32signal->count = 0;
#ifdef USE_THREAD
      w32handle->w32signal->gthread = g_thread_self ();
#endif /* USE_THREAD */
      fResult = TRUE;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return fResult;
}


/* ResetWriteWatch ordinal = 602, argument = 8 temporary */
static DWORD WINAPI ResetWriteWatch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResumeThread ordinal = 603, argument = 4 */
DWORD WINAPI ResumeThread (HANDLE hThread)
{
  return -1;
}


/* RtlFillMemory ordinal = 604, argument = 12 temporary */
static DWORD WINAPI RtlFillMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RtlMoveMemory ordinal = 605, argument = 12 temporary */
static DWORD WINAPI RtlMoveMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RtlUnwind ordinal = 606, argument = 16 */
VOID WINAPI RtlUnwind (PVOID TargetFrame, PVOID TargetIp, PEXCEPTION_RECORD ExceptionRecord, PVOID ReturnValue)
{
}


/* RtlZeroMemory ordinal = 607, argument = 8 temporary */
static DWORD WINAPI RtlZeroMemory (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ScrollConsoleScreenBufferA ordinal = 608, argument = 20 temporary */
static DWORD WINAPI ScrollConsoleScreenBufferA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ScrollConsoleScreenBufferW ordinal = 609, argument = 20 temporary */
static DWORD WINAPI ScrollConsoleScreenBufferW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SearchPathA ordinal = 610, argument = 24 temporary */
static DWORD WINAPI SearchPathA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SearchPathW ordinal = 611, argument = 24 temporary */
static DWORD WINAPI SearchPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetCPGlobal ordinal = 612, argument = 0 temporary */
static DWORD WINAPI SetCPGlobal (VOID)
{
  return 0;
}


/* SetCalendarInfoA ordinal = 613, argument = 16 temporary */
static DWORD WINAPI SetCalendarInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetCalendarInfoW ordinal = 614, argument = 16 temporary */
static DWORD WINAPI SetCalendarInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetCommBreak ordinal = 615, argument = 4 temporary */
static DWORD WINAPI SetCommBreak (DWORD dwArgv0)
{
  return 0;
}


/* SetCommConfig ordinal = 616, argument = 12 temporary */
static DWORD WINAPI SetCommConfig (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetCommMask ordinal = 617, argument = 8 temporary */
static DWORD WINAPI SetCommMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCommState ordinal = 618, argument = 8 temporary */
static DWORD WINAPI SetCommState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCommTimeouts ordinal = 619, argument = 8 temporary */
static DWORD WINAPI SetCommTimeouts (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameA ordinal = 620, argument = 4 temporary */
static DWORD WINAPI SetComputerNameA (DWORD dwArgv0)
{
  return 0;
}


/* SetComputerNameExA ordinal = 621, argument = 8 temporary */
static DWORD WINAPI SetComputerNameExA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameExW ordinal = 622, argument = 8 temporary */
static DWORD WINAPI SetComputerNameExW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameW ordinal = 623, argument = 4 temporary */
static DWORD WINAPI SetComputerNameW (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleActiveScreenBuffer ordinal = 624, argument = 4 temporary */
static DWORD WINAPI SetConsoleActiveScreenBuffer (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleCP ordinal = 625, argument = 4 temporary */
static DWORD WINAPI SetConsoleCP (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleCommandHistoryMode ordinal = 626, argument = 0 temporary */
static DWORD WINAPI SetConsoleCommandHistoryMode (VOID)
{
  return 0;
}


/* SetConsoleCtrlHandler ordinal = 627, argument = 8 temporary */
static DWORD WINAPI SetConsoleCtrlHandler (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursor ordinal = 628, argument = 8 temporary */
static DWORD WINAPI SetConsoleCursor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursorInfo ordinal = 629, argument = 8 temporary */
static DWORD WINAPI SetConsoleCursorInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursorMode ordinal = 630, argument = 0 temporary */
static DWORD WINAPI SetConsoleCursorMode (VOID)
{
  return 0;
}


/* SetConsoleCursorPosition ordinal = 631, argument = 8 temporary */
static DWORD WINAPI SetConsoleCursorPosition (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleDisplayMode ordinal = 632, argument = 0 temporary */
static DWORD WINAPI SetConsoleDisplayMode (VOID)
{
  return 0;
}


/* SetConsoleFont ordinal = 633, argument = 0 temporary */
static DWORD WINAPI SetConsoleFont (VOID)
{
  return 0;
}


/* SetConsoleHardwareState ordinal = 634, argument = 0 temporary */
static DWORD WINAPI SetConsoleHardwareState (VOID)
{
  return 0;
}


/* SetConsoleIcon ordinal = 635, argument = 0 temporary */
static DWORD WINAPI SetConsoleIcon (VOID)
{
  return 0;
}


/* SetConsoleInputExeNameA ordinal = 636, argument = 0 temporary */
static DWORD WINAPI SetConsoleInputExeNameA (VOID)
{
  return 0;
}


/* SetConsoleInputExeNameW ordinal = 637, argument = 0 temporary */
static DWORD WINAPI SetConsoleInputExeNameW (VOID)
{
  return 0;
}


/* SetConsoleKeyShortcuts ordinal = 638, argument = 0 temporary */
static DWORD WINAPI SetConsoleKeyShortcuts (VOID)
{
  return 0;
}


/* SetConsoleLocalEUDC ordinal = 639, argument = 0 temporary */
static DWORD WINAPI SetConsoleLocalEUDC (VOID)
{
  return 0;
}


/* SetConsoleMaximumWindowSize ordinal = 640, argument = 0 temporary */
static DWORD WINAPI SetConsoleMaximumWindowSize (VOID)
{
  return 0;
}


/* SetConsoleMenuClose ordinal = 641, argument = 0 temporary */
static DWORD WINAPI SetConsoleMenuClose (VOID)
{
  return 0;
}


/* SetConsoleMode ordinal = 642, argument = 8 temporary */
static DWORD WINAPI SetConsoleMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleNlsMode ordinal = 643, argument = 0 temporary */
static DWORD WINAPI SetConsoleNlsMode (VOID)
{
  return 0;
}


/* SetConsoleNumberOfCommandsA ordinal = 644, argument = 0 temporary */
static DWORD WINAPI SetConsoleNumberOfCommandsA (VOID)
{
  return 0;
}


/* SetConsoleNumberOfCommandsW ordinal = 645, argument = 0 temporary */
static DWORD WINAPI SetConsoleNumberOfCommandsW (VOID)
{
  return 0;
}


/* SetConsoleOS2OemFormat ordinal = 646, argument = 0 temporary */
static DWORD WINAPI SetConsoleOS2OemFormat (VOID)
{
  return 0;
}


/* SetConsoleOutputCP ordinal = 647, argument = 4 temporary */
static DWORD WINAPI SetConsoleOutputCP (DWORD dwArgv0)
{
  return 0;
}


/* SetConsolePalette ordinal = 648, argument = 0 temporary */
static DWORD WINAPI SetConsolePalette (VOID)
{
  return 0;
}


/* SetConsoleScreenBufferSize ordinal = 649, argument = 8 */
BOOL WINAPI SetConsoleScreenBufferSize (HANDLE hConsoleOutput, COORD dwSize)
{
  return TRUE;
}


/* SetConsoleTextAttribute ordinal = 650, argument = 8 temporary */
static DWORD WINAPI SetConsoleTextAttribute (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleTitleA ordinal = 651, argument = 4 temporary */
static DWORD WINAPI SetConsoleTitleA (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleTitleW ordinal = 652, argument = 4 temporary */
static DWORD WINAPI SetConsoleTitleW (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleWindowInfo ordinal = 653, argument = 12 temporary */
static DWORD WINAPI SetConsoleWindowInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetCriticalSectionSpinCount ordinal = 654, argument = 8 temporary */
static DWORD WINAPI SetCriticalSectionSpinCount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCurrentDirectoryA ordinal = 655, argument = 4 */
BOOL WINAPI SetCurrentDirectoryA (LPCSTR lpPathName)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_mb (lpPathName);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_chdir (path);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = chdir (path);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (path);
  return result == 0;
}


/* SetCurrentDirectoryW ordinal = 656, argument = 4 */
BOOL WINAPI SetCurrentDirectoryW (LPCWSTR lpPathName)
{
  gchar *path;
  gint result;

  path = w32ldr_filename_from_wc (lpPathName);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_chdir (path);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = chdir (path);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (path);
  return result == 0;
}


/* SetDefaultCommConfigA ordinal = 657, argument = 12 temporary */
static DWORD WINAPI SetDefaultCommConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetDefaultCommConfigW ordinal = 658, argument = 12 temporary */
static DWORD WINAPI SetDefaultCommConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetEndOfFile ordinal = 659, argument = 4 */
BOOL WINAPI SetEndOfFile (HANDLE hFile)
{
  return hFile ? fileio_eof (((W32LdrHandle *)hFile)->fio) : FALSE;
}


/* SetEnvironmentVariableA ordinal = 660, argument = 8 */
BOOL WINAPI SetEnvironmentVariableA (LPCSTR lpName, LPCSTR lpValue)
{
#if GLIB_CHECK_VERSION(2,4,0)
  gchar *name, *utf8str;
  BOOL fResult = FALSE;

  utf8str = w32ldr_utf8_from_mb (lpName);
  name = utf8str ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  if (name)
    {
      if (lpValue)
        {
          gchar *value;

          utf8str = w32ldr_utf8_from_mb (lpValue);
          value = utf8str ? g_filename_from_utf8 (utf8str, -1,
                                                    NULL, NULL, NULL) : NULL;
          g_free (utf8str);
          if (value)
            {
              fResult = g_setenv (name, value, TRUE);
              g_free (value);
            }
        }
      else
        {
          g_unsetenv (name);
          fResult = TRUE;
        }
    }
  return fResult;
#else /* not GLIB_CHECK_VERSION(2,4,0) */
  return FALSE;
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
}


/* SetEnvironmentVariableW ordinal = 661, argument = 8 */
BOOL WINAPI SetEnvironmentVariableW (LPCWSTR lpName, LPCWSTR lpValue)
{
#if GLIB_CHECK_VERSION(2,4,0)
  gchar *name, *utf8str;
  BOOL fResult = FALSE;

  utf8str = lpName ? g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL) : NULL;
  name = utf8str ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  if (name)
    {
      if (lpValue)
        {
          gchar *value;

          utf8str = lpValue ? g_utf16_to_utf8 (lpValue, -1,
                                                    NULL, NULL, NULL) : NULL;
          value = utf8str ? g_filename_from_utf8 (utf8str, -1,
                                                    NULL, NULL, NULL) : NULL;
          g_free (utf8str);
          if (value)
            {
              fResult = g_setenv (name, value, TRUE);
              g_free (value);
            }
        }
      else
        {
          g_unsetenv (name);
          fResult = TRUE;
        }
    }
  return fResult;
#else /* not GLIB_CHECK_VERSION(2,4,0) */
  return FALSE;
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
}


/* SetErrorMode ordinal = 662, argument = 4 temporary */
static DWORD WINAPI SetErrorMode (DWORD dwArgv0)
{
  return 0;
}


/* SetEvent ordinal = 663, argument = 4 */
BOOL WINAPI SetEvent (HANDLE hEvent)
{
  W32LdrHandle *w32handle;
  BOOL fResult = FALSE;

  w32handle = hEvent;
#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  if (w32handle && w32handle->w32signal && w32handle->w32signal->max < 0)
    {
      w32handle->w32signal->count = 1;
#ifdef USE_THREAD
      w32handle->w32signal->gthread = NULL;
#endif /* USE_THREAD */
      fResult = TRUE;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return fResult;
}


/* SetFileApisToANSI ordinal = 664, argument = 0 temporary */
static DWORD WINAPI SetFileApisToANSI (VOID)
{
  return 0;
}


/* SetFileApisToOEM ordinal = 665, argument = 0 temporary */
static DWORD WINAPI SetFileApisToOEM (VOID)
{
  return 0;
}


/* SetFileAttributesA ordinal = 666, argument = 8 temporary */
static DWORD WINAPI SetFileAttributesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFileAttributesW ordinal = 667, argument = 8 temporary */
static DWORD WINAPI SetFileAttributesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFilePointer ordinal = 668, argument = 16 */
DWORD WINAPI SetFilePointer (HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod)
{
  guint whence;

  switch (dwMoveMethod)
    {
      case FILE_BEGIN: whence = FILEIO_SEEK_SET; break;
      case FILE_END:   whence = FILEIO_SEEK_END; break;
      default:         whence = FILEIO_SEEK_CUR;
    }
  return fileio_seek (((W32LdrHandle *)hFile)->fio, lDistanceToMove, whence);
}


/* SetFilePointerEx ordinal = 669, argument = 20 temporary */
static DWORD WINAPI SetFilePointerEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetFileTime ordinal = 670, argument = 16 */
BOOL WINAPI SetFileTime (HANDLE hFile, LPCFILETIME lpCreationTime, LPCFILETIME lpLastAccessTime, LPCFILETIME lpLastWriteTime)
{
  const gchar *file;
  FileIOTime atime, mtime;

  if (!hFile || hFile == INVALID_HANDLE_VALUE
                    || !(file = fileio_getname (((W32LdrHandle *)hFile)->fio))
                                    || !fileio_gettime (file, &atime, &mtime))
    return FALSE;
  if (lpLastAccessTime)
    {
      FileIOSysTime stime;
      SYSTEMTIME st;

      FileTimeToSystemTime (lpLastAccessTime, &st);
      stime.year = st.wYear;
      stime.mon  = st.wMonth;
      stime.mday = st.wDay;
      stime.hour = st.wHour;
      stime.min  = st.wMinute;
      stime.sec  = st.wSecond;
      stime.wday = st.wDayOfWeek;
      fileio_setsystime (&atime, &stime);
    }
  if (lpLastWriteTime)
    {
      FileIOSysTime stime;
      SYSTEMTIME st;

      FileTimeToSystemTime (lpLastWriteTime, &st);
      stime.year = st.wYear;
      stime.mon  = st.wMonth;
      stime.mday = st.wDay;
      stime.hour = st.wHour;
      stime.min  = st.wMinute;
      stime.sec  = st.wSecond;
      stime.wday = st.wDayOfWeek;
      fileio_setsystime (&mtime, &stime);
    }
  return fileio_settime (file, &atime, &mtime);
}


/* SetHandleCount ordinal = 671, argument = 4 */
UINT WINAPI SetHandleCount (UINT uNumber)
{
  return MIN (uNumber, 256);
}


/* SetHandleInformation ordinal = 672, argument = 12 temporary */
static DWORD WINAPI SetHandleInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetInformationJobObject ordinal = 673, argument = 16 temporary */
static DWORD WINAPI SetInformationJobObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetLastConsoleEventActive ordinal = 674, argument = 0 temporary */
static DWORD WINAPI SetLastConsoleEventActive (VOID)
{
  return 0;
}


/* SetLastError ordinal = 675, argument = 4 */
VOID WINAPI SetLastError (DWORD dwErrCode)
{
}


/* SetLocalTime ordinal = 676, argument = 4 temporary */
static DWORD WINAPI SetLocalTime (DWORD dwArgv0)
{
  return 0;
}


/* SetLocaleInfoA ordinal = 677, argument = 12 temporary */
static DWORD WINAPI SetLocaleInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetLocaleInfoW ordinal = 678, argument = 12 temporary */
static DWORD WINAPI SetLocaleInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetMailslotInfo ordinal = 679, argument = 8 temporary */
static DWORD WINAPI SetMailslotInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMessageWaitingIndicator ordinal = 680, argument = 8 temporary */
static DWORD WINAPI SetMessageWaitingIndicator (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetNamedPipeHandleState ordinal = 681, argument = 16 temporary */
static DWORD WINAPI SetNamedPipeHandleState (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPriorityClass ordinal = 682, argument = 8 temporary */
static DWORD WINAPI SetPriorityClass (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessAffinityMask ordinal = 683, argument = 8 */
BOOL WINAPI SetProcessAffinityMask (HANDLE hProcess, DWORD dwProcessAffinityMask)
{
  return FALSE;
}


/* SetProcessPriorityBoost ordinal = 684, argument = 8 temporary */
static DWORD WINAPI SetProcessPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessShutdownParameters ordinal = 685, argument = 8 temporary */
static DWORD WINAPI SetProcessShutdownParameters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessWorkingSetSize ordinal = 686, argument = 12 temporary */
static DWORD WINAPI SetProcessWorkingSetSize (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetStdHandle ordinal = 687, argument = 8 */
BOOL WINAPI SetStdHandle (DWORD nStdHandle, HANDLE hHandle)
{
  return FALSE;
}


/* SetSystemPowerState ordinal = 688, argument = 8 temporary */
static DWORD WINAPI SetSystemPowerState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSystemTime ordinal = 689, argument = 4 temporary */
static DWORD WINAPI SetSystemTime (DWORD dwArgv0)
{
  return 0;
}


/* SetSystemTimeAdjustment ordinal = 690, argument = 8 temporary */
static DWORD WINAPI SetSystemTimeAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTapeParameters ordinal = 691, argument = 12 temporary */
static DWORD WINAPI SetTapeParameters (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetTapePosition ordinal = 692, argument = 24 temporary */
static DWORD WINAPI SetTapePosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetTermsrvAppInstallMode ordinal = 693, argument = 0 temporary */
static DWORD WINAPI SetTermsrvAppInstallMode (VOID)
{
  return 0;
}


/* SetThreadAffinityMask ordinal = 694, argument = 8 */
DWORD WINAPI SetThreadAffinityMask (HANDLE hThread, DWORD dwThreadAffinityMask)
{
  return FALSE;
}


/* SetThreadContext ordinal = 695, argument = 8 temporary */
static DWORD WINAPI SetThreadContext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadExecutionState ordinal = 696, argument = 4 temporary */
static DWORD WINAPI SetThreadExecutionState (DWORD dwArgv0)
{
  return 0;
}


/* SetThreadIdealProcessor ordinal = 697, argument = 8 temporary */
static DWORD WINAPI SetThreadIdealProcessor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadLocale ordinal = 698, argument = 4 temporary */
static DWORD WINAPI SetThreadLocale (DWORD dwArgv0)
{
  return 0;
}


/* SetThreadPriority ordinal = 699, argument = 8 */
BOOL WINAPI SetThreadPriority (HANDLE hThread, INT nPriority)
{
#ifdef USE_THREAD
  GThreadPriority priority;
#endif /* USE_THREAD */
  W32LdrHandle *w32handle;

  w32handle = hThread;
#ifdef USE_THREAD
  if (!w32handle || w32handle == INVALID_HANDLE_VALUE || !w32handle->gthread)
#else /* not USE_THREAD */
  if (!w32handle || w32handle == INVALID_HANDLE_VALUE)
#endif /* not USE_THREAD */
    return FALSE;
  w32handle->priority = nPriority;
#ifdef USE_THREAD
  if (nPriority >= THREAD_PRIORITY_TIME_CRITICAL)
    priority = G_THREAD_PRIORITY_URGENT;
  else if (nPriority >= THREAD_PRIORITY_HIGHEST)
    priority = G_THREAD_PRIORITY_HIGH;
  else if (nPriority <= THREAD_PRIORITY_LOWEST)
    priority = G_THREAD_PRIORITY_LOW;
  else
    priority = G_THREAD_PRIORITY_NORMAL;
  g_thread_set_priority (w32handle->gthread, priority);
#endif /* USE_THREAD */
  return TRUE;
}


/* SetThreadPriorityBoost ordinal = 700, argument = 8 temporary */
static DWORD WINAPI SetThreadPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTimeZoneInformation ordinal = 701, argument = 4 */
BOOL WINAPI SetTimeZoneInformation (LPCTIME_ZONE_INFORMATION lpTimeZoneInformation)
{
  return lpTimeZoneInformation != NULL;
}


/* SetTimerQueueTimer ordinal = 702, argument = 24 temporary */
static DWORD WINAPI SetTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetUnhandledExceptionFilter ordinal = 703, argument = 4 */
LPTOP_LEVEL_EXCEPTION_FILTER WINAPI SetUnhandledExceptionFilter (LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter)
{
  return NULL;
}


/* SetVDMCurrentDirectories ordinal = 704, argument = 0 temporary */
static DWORD WINAPI SetVDMCurrentDirectories (VOID)
{
  return 0;
}


/* SetVolumeLabelA ordinal = 705, argument = 8 temporary */
static DWORD WINAPI SetVolumeLabelA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeLabelW ordinal = 706, argument = 8 temporary */
static DWORD WINAPI SetVolumeLabelW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeMountPointA ordinal = 707, argument = 8 temporary */
static DWORD WINAPI SetVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeMountPointW ordinal = 708, argument = 8 temporary */
static DWORD WINAPI SetVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetWaitableTimer ordinal = 709, argument = 24 temporary */
static DWORD WINAPI SetWaitableTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetupComm ordinal = 710, argument = 12 temporary */
static DWORD WINAPI SetupComm (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ShowConsoleCursor ordinal = 711, argument = 0 temporary */
static DWORD WINAPI ShowConsoleCursor (VOID)
{
  return 0;
}


/* SignalObjectAndWait ordinal = 712, argument = 16 temporary */
static DWORD WINAPI SignalObjectAndWait (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SizeofResource ordinal = 713, argument = 8 */
DWORD WINAPI SizeofResource (HMODULE hModule, HRSRC hResInfo)
{
  return hResInfo ? ((PIMAGE_RESOURCE_DATA_ENTRY)hResInfo)->Size : 0;
}


/* Sleep ordinal = 714, argument = 4 */
VOID WINAPI Sleep (DWORD dwMilliseconds)
{
  usleep (dwMilliseconds * 1000);
}


/* SleepEx ordinal = 715, argument = 8 temporary */
static DWORD WINAPI SleepEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SuspendThread ordinal = 716, argument = 4 */
DWORD WINAPI SuspendThread (HANDLE hThread)
{
  return -1;
}


/* SwitchToFiber ordinal = 717, argument = 4 temporary */
static DWORD WINAPI SwitchToFiber (DWORD dwArgv0)
{
  return 0;
}


/* SwitchToThread ordinal = 718, argument = 0 temporary */
static DWORD WINAPI SwitchToThread (VOID)
{
  return 0;
}


/* SystemTimeToFileTime ordinal = 719, argument = 8 */
BOOL WINAPI SystemTimeToFileTime (LPCSYSTEMTIME lpSystemTime, LPFILETIME lpFileTime)
{
  gint i, year;
  gulonglong t;
  gint days[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  if (!lpSystemTime || !lpFileTime || lpSystemTime->wYear < 1601)
    return FALSE;
  year = lpSystemTime->wYear - 1601;
  t = year / 400 * (365 * 400 + 97);/* ja:400年単位 */
  year %= 400;
  t += year / 100 * (365 * 100 + 24);/* ja:100年単位 */
  year %= 100;
  t += year / 4 * (365 * 4 + 1) + (year % 4) * 365;/* ja:4年単位,1年単位 */
  days[1] = (lpSystemTime->wYear % 4 == 0 && lpSystemTime->wYear % 100 != 0)
                                    && lpSystemTime->wYear % 400 == 0 ? 29 :28;
  for (i = 0; i < lpSystemTime->wMonth - 1; i++)
    t += days[i];
  t = (t + lpSystemTime->wDay) * 24;/* ja:時間 */
  t = (t + lpSystemTime->wHour) * 60;/* ja:分 */
  t = (t + lpSystemTime->wMinute) * 60;/* ja:秒 */
  t = (t + lpSystemTime->wSecond) * 1000;/* ja:ミリ秒 */
  t = (t + lpSystemTime->wMilliseconds) * 10000;/* ja:100ナノ秒 */
  lpFileTime->dwHighDateTime = t >> 32;
  lpFileTime->dwLowDateTime = t & 0xffffffff;
  return TRUE;
}


/* SystemTimeToTzSpecificLocalTime ordinal = 720, argument = 12 temporary */
static DWORD WINAPI SystemTimeToTzSpecificLocalTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TerminateJobObject ordinal = 721, argument = 8 temporary */
static DWORD WINAPI TerminateJobObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TerminateProcess ordinal = 722, argument = 8 */
BOOL WINAPI TerminateProcess (HANDLE hProcess, UINT uExitCode)
{
  return TRUE;
}


/* TerminateThread ordinal = 723, argument = 8 temporary */
static DWORD WINAPI TerminateThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TermsrvAppInstallMode ordinal = 724, argument = 0 temporary */
static DWORD WINAPI TermsrvAppInstallMode (VOID)
{
  return 0;
}


/* Thread32First ordinal = 725, argument = 8 temporary */
static DWORD WINAPI Thread32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Thread32Next ordinal = 726, argument = 8 temporary */
static DWORD WINAPI Thread32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TlsAlloc ordinal = 727, argument = 0 */
DWORD WINAPI TlsAlloc (VOID)
{
  return GPOINTER_TO_UINT (g_malloc (sizeof (LPVOID)));
}


/* TlsFree ordinal = 728, argument = 4 */
BOOL WINAPI TlsFree (DWORD dwTlsIndex)
{
  g_free (GUINT_TO_POINTER (dwTlsIndex));
  return TRUE;
}


/* TlsGetValue ordinal = 729, argument = 4 */
LPVOID WINAPI TlsGetValue (DWORD dwTlsIndex)
{
  return *(LPVOID *)(GUINT_TO_POINTER (dwTlsIndex));
}


/* TlsSetValue ordinal = 730, argument = 8 */
BOOL WINAPI TlsSetValue (DWORD dwTlsIndex, LPVOID lpTlsValue)
{
  *(LPVOID *)(GUINT_TO_POINTER (dwTlsIndex)) = lpTlsValue;
  return TRUE;
}


/* Toolhelp32ReadProcessMemory ordinal = 731, argument = 20 temporary */
static DWORD WINAPI Toolhelp32ReadProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* TransactNamedPipe ordinal = 732, argument = 28 temporary */
static DWORD WINAPI TransactNamedPipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* TransmitCommChar ordinal = 733, argument = 8 temporary */
static DWORD WINAPI TransmitCommChar (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TrimVirtualBuffer ordinal = 734, argument = 0 temporary */
static DWORD WINAPI TrimVirtualBuffer (VOID)
{
  return 0;
}


/* TryEnterCriticalSection ordinal = 735, argument = 4 */
BOOL WINAPI TryEnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  return g_mutex_trylock ((GMutex *)lpCriticalSection);
}


/* UTRegister ordinal = 736, argument = 0 temporary */
static DWORD WINAPI UTRegister (VOID)
{
  return 0;
}


/* UTUnRegister ordinal = 737, argument = 0 temporary */
static DWORD WINAPI UTUnRegister (VOID)
{
  return 0;
}


/* UnhandledExceptionFilter ordinal = 738, argument = 4 temporary */
static DWORD WINAPI UnhandledExceptionFilter (DWORD dwArgv0)
{
  return 0;
}


/* UnlockFile ordinal = 739, argument = 20 temporary */
static DWORD WINAPI UnlockFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* UnlockFileEx ordinal = 740, argument = 20 temporary */
static DWORD WINAPI UnlockFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* UnmapViewOfFile ordinal = 741, argument = 4 */
BOOL WINAPI UnmapViewOfFile (LPCVOID lpBaseAddress)
{
  return TRUE;
}


/* UnregisterConsoleIME ordinal = 742, argument = 0 temporary */
static DWORD WINAPI UnregisterConsoleIME (VOID)
{
  return 0;
}


/* UnregisterWait ordinal = 743, argument = 4 temporary */
static DWORD WINAPI UnregisterWait (DWORD dwArgv0)
{
  return 0;
}


/* UnregisterWaitEx ordinal = 744, argument = 8 temporary */
static DWORD WINAPI UnregisterWaitEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UpdateResourceA ordinal = 745, argument = 24 temporary */
static DWORD WINAPI UpdateResourceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* UpdateResourceW ordinal = 746, argument = 24 temporary */
static DWORD WINAPI UpdateResourceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* VDMConsoleOperation ordinal = 747, argument = 0 temporary */
static DWORD WINAPI VDMConsoleOperation (VOID)
{
  return 0;
}


/* VDMOperationStarted ordinal = 748, argument = 0 temporary */
static DWORD WINAPI VDMOperationStarted (VOID)
{
  return 0;
}


/* ValidateLCType ordinal = 749, argument = 0 temporary */
static DWORD WINAPI ValidateLCType (VOID)
{
  return 0;
}


/* ValidateLocale ordinal = 750, argument = 0 temporary */
static DWORD WINAPI ValidateLocale (VOID)
{
  return 0;
}


/* VerLanguageNameA ordinal = 751, argument = 12 */
DWORD WINAPI VerLanguageNameA (DWORD wLang, LPSTR szLang, DWORD nSize)
{
  gsize leng = 0;
  gint i;

  for (i = 0; nls_information[i].langage; i++)
    if (LANGIDFROMLCID (nls_information[i].lcid) == LANGIDFROMLCID (wLang))
      {
        gchar *mb;

        mb = w32ldr_utf8_to_mb (nls_information[i].locale);
        leng = g_strlen (mb);
        if (szLang && leng < nSize)
          g_strcpy (szLang, mb);
        else
          leng++;
        g_free (mb);
        break;
      }
  return leng;
}


/* VerLanguageNameW ordinal = 752, argument = 12 */
DWORD WINAPI VerLanguageNameW (DWORD wLang, LPWSTR szLang, DWORD nSize)
{
  gsize leng = 0;
  gint i;

  for (i = 0; nls_information[i].langage; i++)
    if (LANGIDFROMLCID (nls_information[i].lcid) == LANGIDFROMLCID (wLang))
      {
        gunichar2 *wc;

        wc = g_utf8_to_utf16 (nls_information[i].locale, -1, NULL, NULL, NULL);
        leng = lstrlenW (wc);
        if (szLang && leng < nSize)
          lstrcpyW (szLang, wc);
        else
          leng++;
        g_free (wc);
        break;
      }
  return leng;
}


/* VerSetConditionMask ordinal = 753, argument = 16 temporary */
static DWORD WINAPI VerSetConditionMask (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VerifyConsoleIoHandle ordinal = 754, argument = 0 temporary */
static DWORD WINAPI VerifyConsoleIoHandle (VOID)
{
  return 0;
}


/* VerifyVersionInfoA ordinal = 755, argument = 16 temporary */
static DWORD WINAPI VerifyVersionInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VerifyVersionInfoW ordinal = 756, argument = 16 temporary */
static DWORD WINAPI VerifyVersionInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


typedef struct _W32LdrVirtual
{
  gpointer p;
  gsize len;
} W32LdrVirtual;
static GList *glist_virtual = NULL;


/* VirtualAlloc ordinal = 757, argument = 16 */
LPVOID WINAPI VirtualAlloc (LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect)
{
  gpointer result = NULL;
  GList *glist;

#ifdef USE_THREAD
  G_LOCK (critical);
  critical = TRUE;
#endif /* USE_THREAD */
  for (glist = g_list_first (glist_virtual); glist;
                                                glist = g_list_next (glist))
    {
      W32LdrVirtual *w32vir;

      w32vir = glist->data;
      if (GPOINTER_TO_UINT (w32vir->p) <= GPOINTER_TO_UINT (lpAddress)
                            && GPOINTER_TO_UINT (lpAddress) + dwSize
                                <= GPOINTER_TO_UINT (w32vir->p) + w32vir->len)
        {
          result = lpAddress;
          break;
        }
    }
  if (!result)
    {
      W32LdrVirtual *w32vir;

      w32vir = g_malloc (sizeof (W32LdrVirtual));
      w32vir->p = g_malloc0 (dwSize);
      w32vir->len = dwSize;
      glist_virtual = g_list_append (glist_virtual, w32vir);
      result = w32vir->p;
    }
#ifdef USE_THREAD
  critical = FALSE;
  G_UNLOCK (critical);
#endif /* USE_THREAD */
  return result;
}


/* VirtualAllocEx ordinal = 758, argument = 20 temporary */
static DWORD WINAPI VirtualAllocEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* VirtualBufferExceptionHandler ordinal = 759, argument = 0 temporary */
static DWORD WINAPI VirtualBufferExceptionHandler (VOID)
{
  return 0;
}


/* VirtualFree ordinal = 760, argument = 12 */
BOOL WINAPI VirtualFree (LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType)
{
  gboolean result;

  if (dwFreeType & MEM_RELEASE)
    {
      result = FALSE;
      if (dwSize <= 0)
        {
          GList *glist;

#ifdef USE_THREAD
          G_LOCK (critical);
          critical = TRUE;
#endif /* USE_THREAD */
          for (glist = g_list_first (glist_virtual); glist;
                                                glist = g_list_next (glist))
            {
              W32LdrVirtual *w32vir;

              w32vir = glist->data;
              if (w32vir->p == lpAddress)
                {
                  glist_virtual = g_list_remove (glist_virtual, w32vir);
                  g_free (w32vir);
                  g_free (lpAddress);
                  result = TRUE;
                  break;
                }
            }
#ifdef USE_THREAD
          critical = FALSE;
          G_UNLOCK (critical);
#endif /* USE_THREAD */
        }
    }
  else
    {
      result = TRUE;
    }
  return result;
}


/* VirtualFreeEx ordinal = 761, argument = 16 temporary */
static DWORD WINAPI VirtualFreeEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VirtualLock ordinal = 762, argument = 8 */
BOOL WINAPI VirtualLock (LPVOID lpAddress, DWORD dwSize)
{
  return TRUE;
}


/* VirtualProtect ordinal = 763, argument = 16 */
BOOL WINAPI VirtualProtect (LPVOID lpAddress, DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect)
{
  return TRUE;
}


/* VirtualProtectEx ordinal = 764, argument = 20 temporary */
static DWORD WINAPI VirtualProtectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* VirtualQuery ordinal = 765, argument = 12 */
DWORD WINAPI VirtualQuery (LPCVOID lpAddress, PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength)
{
  return sizeof (MEMORY_BASIC_INFORMATION);
}


/* VirtualQueryEx ordinal = 766, argument = 16 temporary */
static DWORD WINAPI VirtualQueryEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VirtualUnlock ordinal = 767, argument = 8 */
BOOL WINAPI VirtualUnlock (LPVOID lpAddress, DWORD dwSize)
{
  return TRUE;
}


/* WaitCommEvent ordinal = 768, argument = 12 temporary */
static DWORD WINAPI WaitCommEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WaitForDebugEvent ordinal = 769, argument = 8 temporary */
static DWORD WINAPI WaitForDebugEvent (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WaitForMultipleObjects ordinal = 770, argument = 16 */
DWORD WINAPI WaitForMultipleObjects (DWORD nCount, CONST HANDLE *lpHandles, BOOL fWaitAll, DWORD dwMilliseconds)
{
  gboolean *signaled;
  gint i;
  W32LdrHandle **w32handle;
  DWORD dwResult = WAIT_FAILED;
#ifdef USE_THREAD
  gulong microseconds;
  GTimer *gtimer;
  GThread *gthread;
#endif /* USE_THREAD */

  if (nCount < 0 || !lpHandles)
    return dwResult;
  for (i = 0; i < nCount; i++)
    if (!lpHandles[i] || lpHandles[i] == INVALID_HANDLE_VALUE)
      return dwResult;
  w32handle = (W32LdrHandle **)lpHandles;
  signaled = g_malloc0 (nCount * sizeof (gboolean));
#ifdef USE_THREAD
  gthread = g_thread_self ();
  gtimer = g_timer_new ();
  while ((DWORD)(g_timer_elapsed (gtimer, &microseconds) * 1000)
                                                            < dwMilliseconds)
    {
#endif /* USE_THREAD */
      for (i = 0; i < nCount; i++)
        if (!signaled[i])
          {
#ifdef USE_THREAD
            G_LOCK (critical);
            critical = TRUE;
#endif /* USE_THREAD */
            if (w32handle[i]->w32signal && w32handle[i]->w32signal->max < 0)
              { /* ja:イベント */
                if (w32handle[i]->w32signal->count > 0)
                  {
                    w32handle[i]->w32signal->count = 0;
                    dwResult = WAIT_OBJECT_0 + i;
                    signaled[i] = TRUE;
                  }
              }
            else if (w32handle[i]->w32signal
                                        && w32handle[i]->w32signal->max == 0)
              { /* ja:ミューテックス */
#ifdef USE_THREAD
                if (w32handle[i]->w32signal->count > 0
                                || w32handle[i]->w32signal->gthread == gthread)
#else /* not USE_THREAD */
                if (w32handle[i]->w32signal->count > 0)
#endif /* not USE_THREAD */
                  {
                    w32handle[i]->w32signal->count = 0;
#ifdef USE_THREAD
                    w32handle[i]->w32signal->gthread = gthread;
#endif /* USE_THREAD */
                    dwResult = WAIT_OBJECT_0 + i;
                    signaled[i] = TRUE;
                  }
#ifdef USE_THREAD
                else if (!w32handle[i]->w32signal->gthread)
                  {
                    w32handle[i]->w32signal->count = 0;
                    w32handle[i]->w32signal->gthread = g_thread_self ();
                    dwResult = WAIT_ABANDONED_0 + i;
                    signaled[i] = TRUE;
                  }
#endif /* USE_THREAD */
              }
            else if (w32handle[i]->w32signal
                                        && w32handle[i]->w32signal->max > 0)
              { /* ja:セマフォ */
                if (w32handle[i]->w32signal->count > 0)
                  {
                    w32handle[i]->w32signal->count--;
                    dwResult = WAIT_OBJECT_0 + i;
                    signaled[i] = TRUE;
                  }
              }
#ifdef USE_THREAD
            else if (w32handle[i]->gthread)
              { /* ja:スレッド */
                g_thread_join (w32handle[i]->gthread);
                dwResult = WAIT_OBJECT_0 + i;
                signaled[i] = TRUE;
              }
            critical = FALSE;
            G_UNLOCK (critical);
#endif /* USE_THREAD */
          }
      if (fWaitAll)
        {
          /* ja:すべてシグナル状態になる必要がある
                                    (1つでもシグナル状態にならなければ継続) */
          for (i = 0; i < nCount; i++)
            if (!signaled[i])
              break;
          if (i >= nCount)
            goto loop;
        }
      else
        {
          /* ja:1つでもシグナル状態になればよい
                                    (1つもシグナル状態にならなければ継続) */
          if (dwResult != WAIT_FAILED)
            goto loop;
        }
#ifdef USE_THREAD
      g_thread_yield ();
    }
#endif /* USE_THREAD */
  dwResult = WAIT_TIMEOUT;
  loop:
#ifdef USE_THREAD
  g_timer_destroy (gtimer);
#endif /* USE_THREAD */
  g_free (signaled);
  return dwResult;
}


/* WaitForMultipleObjectsEx ordinal = 771, argument = 20 temporary */
static DWORD WINAPI WaitForMultipleObjectsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WaitForSingleObject ordinal = 772, argument = 8 */
DWORD WINAPI WaitForSingleObject (HANDLE hHandle, DWORD dwMilliseconds)
{
  return WaitForMultipleObjects (1, &hHandle, TRUE, dwMilliseconds);
}


/* WaitForSingleObjectEx ordinal = 773, argument = 12 temporary */
static DWORD WINAPI WaitForSingleObjectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WaitNamedPipeA ordinal = 774, argument = 8 temporary */
static DWORD WINAPI WaitNamedPipeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WaitNamedPipeW ordinal = 775, argument = 8 temporary */
static DWORD WINAPI WaitNamedPipeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WideCharToMultiByte ordinal = 776, argument = 32 */
INT WINAPI WideCharToMultiByte (UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, INT cchWideChar, LPSTR lpMultiByteStr, INT cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar)
{
  gsize bytes_done = 0, bytes_read, bytes_stored = 0, bytes_written, leng;
  gssize len;
  gchar *charset, *mb = NULL;
  gint result;
  GError *error = NULL;

  if (!lpWideCharStr || cchWideChar == 0)
    return 0;
  leng = g_strlen (lpDefaultChar);
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP:
      case CP_THREAD_ACP:
      case CP_SYMBOL:
        charset = g_strdup_printf ("CP%d", GetACP ());
        break;
      case CP_OEMCP:
        charset = g_strdup_printf ("CP%d", GetOEMCP ());
        break;
      case CP_UTF7:
        charset = g_strdup ("UTF-7");
        break;
      case CP_UTF8:
        charset = g_strdup ("UTF-8");
        break;
      default:
        charset = g_strdup_printf ("CP%d", CodePage);
    }
  len = (cchWideChar < 0 ? lstrlenW (lpWideCharStr) + 1 : cchWideChar)
                                                        * sizeof (gunichar2);
  if (lpUsedDefaultChar)
    *lpUsedDefaultChar = FALSE;
  while (len - bytes_done > 0)
    {
      gchar *tmp;

      tmp = g_convert ((const gchar *)lpWideCharStr + bytes_done,
                                        len - bytes_done,
                                        charset, "UTF-16LE",
                                        &bytes_read, &bytes_written, &error);
      if (!tmp && error && g_error_matches (error, G_CONVERT_ERROR,
                                            G_CONVERT_ERROR_ILLEGAL_SEQUENCE)
                                        && bytes_read >= sizeof (gunichar2))
        tmp = g_convert ((const gchar *)lpWideCharStr + bytes_done,
                                        bytes_read,
                                        charset, "UTF-16LE",
                                        &bytes_read, &bytes_written, NULL);
      g_clear_error (&error);
      if (tmp)
        {
          bytes_done += bytes_read;
          mb = g_realloc (mb, bytes_stored + bytes_written);
          g_memmove (mb + bytes_stored, tmp, bytes_written);
          bytes_stored += bytes_written;
        }
      if (len - bytes_done > 0)
        {
          bytes_done += sizeof (gunichar2);
          if (lpDefaultChar)
            {
              mb = g_realloc (mb, bytes_stored + leng);
              g_memmove (mb + bytes_stored, lpDefaultChar, leng);
              bytes_stored += leng;
            }
          else
            {
              mb = g_realloc (mb, bytes_stored + 1);
              mb[bytes_stored++] = '?';
            }
          if (lpUsedDefaultChar)
            *lpUsedDefaultChar = TRUE;
        }
    }
  g_free (charset);
  result = bytes_stored / sizeof (gchar);
  if (lpMultiByteStr && cchMultiByte > 0)
    {
      if (result > cchMultiByte)
        result = cchMultiByte;
      g_memmove (lpMultiByteStr, mb, result * sizeof (gchar));
    }
  g_free (mb);
  return result;
}


/* WinExec ordinal = 777, argument = 8 temporary */
static DWORD WINAPI WinExec (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WriteConsoleA ordinal = 778, argument = 20 */
BOOL WINAPI WriteConsoleA (HANDLE hConsoleOutput, LPCVOID lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved)
{
  gchar *buf, *str;

  if (!lpBuffer)
    return FALSE;
  buf = g_malloc ((nNumberOfCharsToWrite + 1) * sizeof (gchar));
  g_memmove (buf, lpBuffer, nNumberOfCharsToWrite * sizeof (gchar));
  buf[nNumberOfCharsToWrite] = '\0';
  str = w32ldr_utf8_from_mb (buf);
  g_free (buf);
  g_print ("%s", str);
  g_free (str);
  if (lpNumberOfCharsWritten)
    *lpNumberOfCharsWritten = nNumberOfCharsToWrite;
  return TRUE;
}


/* WriteConsoleInputA ordinal = 779, argument = 16 temporary */
static DWORD WINAPI WriteConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WriteConsoleInputVDMA ordinal = 780, argument = 0 temporary */
static DWORD WINAPI WriteConsoleInputVDMA (VOID)
{
  return 0;
}


/* WriteConsoleInputVDMW ordinal = 781, argument = 0 temporary */
static DWORD WINAPI WriteConsoleInputVDMW (VOID)
{
  return 0;
}


/* WriteConsoleInputW ordinal = 782, argument = 16 temporary */
static DWORD WINAPI WriteConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WriteConsoleOutputA ordinal = 783, argument = 20 temporary */
static DWORD WINAPI WriteConsoleOutputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputAttribute ordinal = 784, argument = 20 temporary */
static DWORD WINAPI WriteConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputCharacterA ordinal = 785, argument = 20 temporary */
static DWORD WINAPI WriteConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputCharacterW ordinal = 786, argument = 20 temporary */
static DWORD WINAPI WriteConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputW ordinal = 787, argument = 20 temporary */
static DWORD WINAPI WriteConsoleOutputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleW ordinal = 788, argument = 20 */
BOOL WINAPI WriteConsoleW (HANDLE hConsoleOutput, LPCVOID lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved)
{
  gchar *str;

  if (!lpBuffer)
    return FALSE;
  str = g_utf16_to_utf8 (lpBuffer, nNumberOfCharsToWrite, NULL, NULL, NULL);
  g_print ("%s", str);
  g_free (str);
  if (lpNumberOfCharsWritten)
    *lpNumberOfCharsWritten = nNumberOfCharsToWrite;
  return TRUE;
}


/* WriteFile ordinal = 789, argument = 20 */
BOOL WINAPI WriteFile (HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped)
{
  gssize bytes_written;

  if (lpNumberOfBytesWritten)
    *lpNumberOfBytesWritten = 0;
  if (hFile == INVALID_HANDLE_VALUE)
    return FALSE;
  if (nNumberOfBytesToWrite <= 0)
    return TRUE;
  bytes_written = fileio_write (((W32LdrHandle *)hFile)->fio,
                                            lpBuffer, nNumberOfBytesToWrite);
  if (lpNumberOfBytesWritten)
    *lpNumberOfBytesWritten = bytes_written;
  return bytes_written >= 0;
}


/* WriteFileEx ordinal = 790, argument = 20 temporary */
static DWORD WINAPI WriteFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteFileGather ordinal = 791, argument = 20 temporary */
static DWORD WINAPI WriteFileGather (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WritePrivateProfileSectionA ordinal = 792, argument = 12 */
BOOL WINAPI WritePrivateProfileSectionA (LPCSTR lpAppName, LPCSTR lpString, LPCSTR lpFileName)
{
  gsize i, leng;
  gchar *utf8str;
  gunichar2 *group, *file, *str;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpAppName);
  group = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpFileName);
  file = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  for (i = 2; lpString[i - 2] == '\0' && lpString[i - 1] == '\0'; i++);
  leng = MultiByteToWideChar (CP_ACP, 0, lpString, i, NULL, 0);
  str = g_malloc (leng * sizeof (gunichar2));
  MultiByteToWideChar (CP_ACP, 0, lpString, i, str, leng);
  fResult = WritePrivateProfileSectionW (group, str, file);
  g_free (group);
  g_free (file);
  g_free (str);
  return fResult;
}


/* WritePrivateProfileSectionW ordinal = 793, argument = 12 */
BOOL WINAPI WritePrivateProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString, LPCWSTR lpFileName)
{
  gint i;
  BOOL fResult = TRUE;

  for (i = 0; lpString[i] != '\0' && fResult; i++)
    {
      gint j;

      for (j = 0; lpString[i + j] != '\0' && lpString[i + j] != '='; j++);
      if (lpString[i + j] == '\0')
        {
          fResult = FALSE;
        }
      else
        {
          gsize leng;
          gunichar2 *key, *str;

          key = g_malloc ((j + 1) * sizeof (gunichar2));
          g_memmove (key, lpString + i, j * sizeof (gunichar2));
          key[j++] = '\0';
          leng = lstrlenW (lpString + i + j);
          str = g_malloc ((leng + 1) * sizeof (gunichar2));
          lstrcpyW (str, lpString + i + j);
          fResult = WritePrivateProfileStringW (lpAppName, key, str,
                                                                lpFileName);
          g_free (key);
          g_free (str);
        }
    }
  return fResult;
}


/* WritePrivateProfileStringA ordinal = 794, argument = 16 */
BOOL WINAPI WritePrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString, LPCSTR lpFileName)
{
  gchar *utf8str;
  gunichar2 *group, *key, *str, *file;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpAppName);
  group = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpKeyName);
  key = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpString);
  str = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  utf8str = w32ldr_utf8_from_mb (lpFileName);
  file = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  fResult = WritePrivateProfileStringW (group, key, str, file);
  g_free (group);
  g_free (key);
  g_free (str);
  g_free (file);
  return fResult;
}


/* WritePrivateProfileStringW ordinal = 795, argument = 16 */
BOOL WINAPI WritePrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString, LPCWSTR lpFileName)
{
  gboolean result = FALSE, written = FALSE;
  gchar *group, *key, *file, *str, *tmp, **groups;
  GKeyFile *key_file;

  group = lpAppName ? g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL) : NULL;
  key = lpKeyName ? g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL) : NULL;
  str = lpString ? g_utf16_to_utf8 (lpString, -1, NULL, NULL, NULL) : NULL;
  tmp = w32ldr_filename_from_wc (lpFileName);
  g_free (tmp);
  file = peimage_dir_get_filename (tmp, PEIMAGE_DIR_HOME);
  key_file = g_key_file_new ();
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
  groups = g_key_file_get_groups (key_file, NULL);
  if (groups)
    {
      gint i;

      for (i = 0; groups[i] && !written; i++)
        if (g_ascii_strcasecmp (groups[i], group) == 0)
          {
            gchar **keys;

            keys = g_key_file_get_keys (key_file, groups[i], NULL, NULL);
            if (keys)
              {
                gint j;

                for (j = 0; keys[j] && !written; j++)
                  if (g_ascii_strcasecmp (keys[j], key) == 0)
                    {
                      if (str)
                        {
                          g_key_file_set_string (key_file,
                                                    groups[i], keys[j], str);
                          written = TRUE;
                        }
                      else
                        {
                          g_key_file_remove_key (key_file,
                                                    groups[i], keys[j], NULL);
                        }
                      result = TRUE;
                    }
                g_strfreev (keys);
              }
          }
      g_strfreev (groups);
    }
  g_free (group);
  g_free (key);
  g_free (str);
  if (result)
    {
      gsize length;

      str = g_key_file_to_data (key_file, &length, NULL);
      g_key_file_free (key_file);
      if (str)
        {
          result = fileio_save (file, str, length);
          g_free (file);
          g_free (str);
        }
    }
  g_free (file);
  return result;
}


/* WritePrivateProfileStructA ordinal = 796, argument = 20 */
BOOL WINAPI WritePrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile)
{
  gchar *str, *mb;
  BOOL fResult;

  str = misc_str_from_array (lpStruct, uSizeStruct, 8, 16, -2, FALSE);
  mb = w32ldr_utf8_to_mb (str);
  g_free (str);
  fResult = WritePrivateProfileStringA (lpszSection, lpszKey, mb, szFile);
  g_free (mb);
  return fResult;
}


/* WritePrivateProfileStructW ordinal = 797, argument = 20 */
BOOL WINAPI WritePrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile)
{
  gchar *str;
  gunichar2 *wc;
  BOOL fResult;

  str = misc_str_from_array (lpStruct, uSizeStruct, 8, 16, -2, FALSE);
  wc = str ? g_utf8_to_utf16 (str, -1, NULL, NULL, NULL) : NULL;
  g_free (str);
  fResult = WritePrivateProfileStringW (lpszSection, lpszKey, wc, szFile);
  g_free (wc);
  return fResult;
}


/* WriteProcessMemory ordinal = 798, argument = 20 temporary */
static DWORD WINAPI WriteProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteProfileSectionA ordinal = 799, argument = 8 */
BOOL WINAPI WriteProfileSectionA (LPCSTR lpAppName, LPCSTR lpString)
{
  return WritePrivateProfileSectionA (lpAppName, lpString, "win.ini");
}


/* WriteProfileSectionW ordinal = 800, argument = 8 */
BOOL WINAPI WriteProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return WritePrivateProfileSectionW (lpAppName, lpString, file);
}


/* WriteProfileStringA ordinal = 801, argument = 12 */
BOOL WINAPI WriteProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString)
{
  return WritePrivateProfileStringA (lpAppName, lpKeyName, lpString,
                                                                    "win.ini");
}


/* WriteProfileStringW ordinal = 802, argument = 12 */
BOOL WINAPI WriteProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return WritePrivateProfileStringW (lpAppName, lpKeyName, lpString, file);
}


/* WriteTapemark ordinal = 803, argument = 16 temporary */
static DWORD WINAPI WriteTapemark (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* _hread ordinal = 804, argument = 12 temporary */
static DWORD WINAPI _hread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* _hwrite ordinal = 805, argument = 12 temporary */
static DWORD WINAPI _hwrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* _lclose ordinal = 806, argument = 4 */
HFILE WINAPI _lclose (HFILE hFile)
{
  return fileio_close (hFile) ? GINT_TO_POINTER (0) : HFILE_ERROR;
}


/* _lcreat ordinal = 807, argument = 8 */
HFILE WINAPI _lcreat (LPCSTR lpPathName, INT iAttribute)
{
  return HFILE_ERROR;
}


/* _llseek ordinal = 808, argument = 12 */
LONG WINAPI _llseek (HFILE hFile, LONG lOffset, INT iOrigin)
{
  guint whence;

  switch (iOrigin)
    {
      case FILE_BEGIN: whence = FILEIO_SEEK_SET; break;
      case FILE_END:   whence = FILEIO_SEEK_END; break;
      default:         whence = FILEIO_SEEK_CUR;
    }
  return fileio_seek (hFile, lOffset, whence);
}


/* _lopen ordinal = 809, argument = 8 */
HFILE WINAPI _lopen (LPCSTR lpPathName, INT iReadWrite)
{
  gchar *file;
  FileIO *fio;

  file = w32ldr_filename_from_mb (lpPathName);
  fio = fileio_open (file,
            FILEIO_ACCESS_READ, FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
  g_free (file);
  return fio;
}


/* _lread ordinal = 810, argument = 12 */
UINT WINAPI _lread (HFILE hFile, LPVOID lpBuffer, UINT uBytes)
{
  return fileio_read (hFile, lpBuffer, uBytes);
}


/* _lwrite ordinal = 811, argument = 12 */
UINT WINAPI _lwrite (HFILE hFile, LPVOID lpBuffer, UINT uBytes)
{
  return GPOINTER_TO_UINT (HFILE_ERROR);
}


/* lstrcat ordinal = 812, argument = 8 */
/* LPSTR WINAPI lstrcat (LPSTR lpString1, LPCSTR lpString2) */


/* lstrcatA ordinal = 813, argument = 8 */
LPSTR WINAPI lstrcatA (LPSTR lpString1, LPCSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_strcat (lpString1, lpString2);
  return lpString1;
}


/* lstrcatW ordinal = 814, argument = 8 */
LPWSTR WINAPI lstrcatW (LPWSTR lpString1, LPCWSTR lpString2)
{
  gunichar2 *str1;
  const gunichar2 *str2;

  if (!lpString1 || !lpString2)
    return NULL;
  for (str1 = lpString1; *str1 != '\0'; str1++);
  for (str2 = lpString2; *str2 != '\0'; str1++, str2++)
    *str1 = *str2;
  *str1 = '\0';
  return lpString1;
}


/* lstrcmp ordinal = 815, argument = 8 */
/* INT WINAPI lstrcmp (LPCSTR lpString1, LPCSTR lpString2) */


/* lstrcmpA ordinal = 816, argument = 8 */
INT WINAPI lstrcmpA (LPCSTR lpString1, LPCSTR lpString2)
{
  return g_strcmp (lpString1, lpString2);
}


/* lstrcmpW ordinal = 817, argument = 8 */
INT WINAPI lstrcmpW (LPCWSTR lpString1, LPCWSTR lpString2)
{
  const gunichar2 *str1, *str2;

  if (!lpString1 || !lpString2)
    return 0;
  for (str1 = lpString1, str2 = lpString2;
                                *str1 != '\0' && *str2 != '\0'; str1++, str2++)
    if (*str1 != *str2)
      break;
  return *str1 - *str2;
}


/* lstrcmpi ordinal = 818, argument = 8 */
/* INT WINAPI lstrcmpi (LPCSTR lpString1, LPCSTR lpString2) */


/* lstrcmpiA ordinal = 819, argument = 8 */
INT WINAPI lstrcmpiA (LPCSTR lpString1, LPCSTR lpString2)
{
  gchar *str1, *str2;
  gint result;

  str1 = w32ldr_utf8_from_mb (lpString1);
  str2 = w32ldr_utf8_from_mb (lpString2);
  result = g_ascii_strcasecmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* lstrcmpiW ordinal = 820, argument = 8 */
INT WINAPI lstrcmpiW (LPCWSTR lpString1, LPCWSTR lpString2)
{
  gchar *str1, *str2, *tmp;
  gint result;

  tmp = lpString1 ? g_utf16_to_utf8 (lpString1, -1, NULL, NULL, NULL) : NULL;
  if (tmp)
    {
      str1 = g_utf8_strdown (tmp, -1);
      g_free (tmp);
    }
  else
    {
      str1 = NULL;
    }
  tmp = lpString2 ? g_utf16_to_utf8 (lpString2, -1, NULL, NULL, NULL) : NULL;
  if (tmp)
    {
      str2 = g_utf8_strdown (tmp, -1);
      g_free (tmp);
    }
  else
    {
      str2 = NULL;
    }
  result = g_strcmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* lstrcpy ordinal = 821, argument = 8 */
/* LPSTR WINAPI lstrcpy (LPSTR lpString1, LPCSTR lpString2) */


/* lstrcpyA ordinal = 822, argument = 8 */
LPSTR WINAPI lstrcpyA (LPSTR lpString1, LPCSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_strcpy (lpString1, lpString2);
  return lpString1;
}


/* lstrcpyW ordinal = 823, argument = 8 */
LPWSTR WINAPI lstrcpyW (LPWSTR lpString1, LPCWSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_memmove (lpString1, lpString2,
                            (lstrlenW (lpString2) + 1) * sizeof (gunichar2));
  return lpString1;
}


/* lstrcpyn ordinal = 824, argument = 12 */
/* LPSTR WINAPI lstrcpyn (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength) */


/* lstrcpynA ordinal = 825, argument = 12 */
LPSTR WINAPI lstrcpynA (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength)
{
  if (!lpString1 || !lpString2 || iMaxLength <= 0)
    return NULL;
  g_strlcpy (lpString1, lpString2, iMaxLength);
  return lpString1;
}


/* lstrcpynW ordinal = 826, argument = 12 */
LPWSTR WINAPI lstrcpynW (LPWSTR lpString1, LPCWSTR lpString2, INT iMaxLength)
{
  gsize leng;

  if (!lpString1 || !lpString2 || iMaxLength <= 0)
    return NULL;
  leng = MIN (iMaxLength - 1, lstrlenW (lpString2));
  g_memmove (lpString1, lpString2, leng * sizeof (WCHAR));
  lpString1[leng] = '\0';
  return lpString1;
}


/* lstrlen ordinal = 827, argument = 4 */
/* INT WINAPI lstrlen (LPCSTR lpString) */


/* lstrlenA ordinal = 828, argument = 4 */
INT WINAPI lstrlenA (LPCSTR lpString)
{
  return lpString ? g_strlen (lpString) : 0;
}


/* lstrlenW ordinal = 829, argument = 4 */
INT WINAPI lstrlenW (LPCWSTR lpString)
{
  gint i;

  if (!lpString)
    return 0;
  for (i = 0; lpString[i] != '\0'; i++);
  return i;
}


W32LdrExport w32ldr_kernel32_exports[] = {
{ 0,   1, "AddAtomA",                              AddAtomA},
{ 0,   2, "AddAtomW",                              AddAtomW},
{-1,   3, "AddConsoleAliasA",                      AddConsoleAliasA},
{-1,   4, "AddConsoleAliasW",                      AddConsoleAliasW},
{ 0,   5, "AllocConsole",                          AllocConsole},
{-1,   6, "AllocateUserPhysicalPages",             AllocateUserPhysicalPages},
{-1,   7, "AreFileApisANSI",                       AreFileApisANSI},
{-1,   8, "AssignProcessToJobObject",              AssignProcessToJobObject},
{-1,   9, "BackupRead",                            BackupRead},
{-1,  10, "BackupSeek",                            BackupSeek},
{-1,  11, "BackupWrite",                           BackupWrite},
{-1,  12, "BaseAttachCompleteThunk",               BaseAttachCompleteThunk},
{-1,  13, "Beep",                                  Beep},
{-1,  14, "BeginUpdateResourceA",                  BeginUpdateResourceA},
{-1,  15, "BeginUpdateResourceW",                  BeginUpdateResourceW},
{-1,  16, "BindIoCompletionCallback",              BindIoCompletionCallback},
{-1,  17, "BuildCommDCBA",                         BuildCommDCBA},
{-1,  18, "BuildCommDCBAndTimeoutsA",              BuildCommDCBAndTimeoutsA},
{-1,  19, "BuildCommDCBAndTimeoutsW",              BuildCommDCBAndTimeoutsW},
{-1,  20, "BuildCommDCBW",                         BuildCommDCBW},
{-1,  21, "CallNamedPipeA",                        CallNamedPipeA},
{-1,  22, "CallNamedPipeW",                        CallNamedPipeW},
{-1,  23, "CancelDeviceWakeupRequest",             CancelDeviceWakeupRequest},
{-1,  24, "CancelIo",                              CancelIo},
{-1,  25, "CancelTimerQueueTimer",                 CancelTimerQueueTimer},
{-1,  26, "CancelWaitableTimer",                   CancelWaitableTimer},
{-1,  27, "ChangeTimerQueueTimer",                 ChangeTimerQueueTimer},
{-1,  28, "ClearCommBreak",                        ClearCommBreak},
{-1,  29, "ClearCommError",                        ClearCommError},
{-1,  30, "CloseConsoleHandle",                    CloseConsoleHandle},
{ 0,  31, "CloseHandle",                           CloseHandle},
{-1,  32, "CloseProfileUserMapping",               CloseProfileUserMapping},
{-1,  33, "CmdBatNotification",                    CmdBatNotification},
{-1,  34, "CommConfigDialogA",                     CommConfigDialogA},
{-1,  35, "CommConfigDialogW",                     CommConfigDialogW},
{ 0,  36, "CompareFileTime",                       CompareFileTime},
{ 0,  37, "CompareStringA",                        CompareStringA},
{ 0,  38, "CompareStringW",                        CompareStringW},
{-1,  39, "ConnectNamedPipe",                      ConnectNamedPipe},
{-1,  40, "ConsoleMenuControl",                    ConsoleMenuControl},
{-1,  41, "ContinueDebugEvent",                    ContinueDebugEvent},
{-1,  42, "ConvertDefaultLocale",                  ConvertDefaultLocale},
{-1,  43, "ConvertThreadToFiber",                  ConvertThreadToFiber},
{ 0,  44, "CopyFileA",                             CopyFileA},
{-1,  45, "CopyFileExA",                           CopyFileExA},
{-1,  46, "CopyFileExW",                           CopyFileExW},
{ 0,  47, "CopyFileW",                             CopyFileW},
{-1,  48, "CreateConsoleScreenBuffer",             CreateConsoleScreenBuffer},
{ 0,  49, "CreateDirectoryA",                      CreateDirectoryA},
{-1,  50, "CreateDirectoryExA",                    CreateDirectoryExA},
{-1,  51, "CreateDirectoryExW",                    CreateDirectoryExW},
{ 0,  52, "CreateDirectoryW",                      CreateDirectoryW},
{ 0,  53, "CreateEventA",                          CreateEventA},
{ 0,  54, "CreateEventW",                          CreateEventW},
{-1,  55, "CreateFiber",                           CreateFiber},
{-1,  56, "CreateFiberEx",                         CreateFiberEx},
{ 0,  57, "CreateFileA",                           CreateFileA},
{ 0,  58, "CreateFileMappingA",                    CreateFileMappingA},
{ 0,  59, "CreateFileMappingW",                    CreateFileMappingW},
{ 0,  60, "CreateFileW",                           CreateFileW},
{-1,  61, "CreateHardLinkA",                       CreateHardLinkA},
{-1,  62, "CreateHardLinkW",                       CreateHardLinkW},
{-1,  63, "CreateIoCompletionPort",                CreateIoCompletionPort},
{-1,  64, "CreateJobObjectA",                      CreateJobObjectA},
{-1,  65, "CreateJobObjectW",                      CreateJobObjectW},
{-1,  66, "CreateMailslotA",                       CreateMailslotA},
{-1,  67, "CreateMailslotW",                       CreateMailslotW},
{ 0,  68, "CreateMutexA",                          CreateMutexA},
{ 0,  69, "CreateMutexW",                          CreateMutexW},
{-1,  70, "CreateNamedPipeA",                      CreateNamedPipeA},
{-1,  71, "CreateNamedPipeW",                      CreateNamedPipeW},
{-1,  72, "CreatePipe",                            CreatePipe},
{ 0,  73, "CreateProcessA",                        CreateProcessA},
{-1,  74, "CreateProcessInternalA",                CreateProcessInternalA},
{-1,  75, "CreateProcessInternalW",                CreateProcessInternalW},
{-1,  76, "CreateProcessInternalWSecure",          CreateProcessInternalWSecure},
{ 0,  77, "CreateProcessW",                        CreateProcessW},
{-1,  78, "CreateRemoteThread",                    CreateRemoteThread},
{ 0,  79, "CreateSemaphoreA",                      CreateSemaphoreA},
{ 0,  80, "CreateSemaphoreW",                      CreateSemaphoreW},
{-1,  81, "CreateTapePartition",                   CreateTapePartition},
{ 0,  82, "CreateThread",                          CreateThread},
{-1,  83, "CreateTimerQueue",                      CreateTimerQueue},
{-1,  84, "CreateTimerQueueTimer",                 CreateTimerQueueTimer},
{-1,  85, "CreateToolhelp32Snapshot",              CreateToolhelp32Snapshot},
{-1,  86, "CreateVirtualBuffer",                   CreateVirtualBuffer},
{-1,  87, "CreateWaitableTimerA",                  CreateWaitableTimerA},
{-1,  88, "CreateWaitableTimerW",                  CreateWaitableTimerW},
{-1,  89, "DebugActiveProcess",                    DebugActiveProcess},
{-1,  90, "DebugBreak",                            DebugBreak},
{-1,  91, "DefineDosDeviceA",                      DefineDosDeviceA},
{-1,  92, "DefineDosDeviceW",                      DefineDosDeviceW},
{-1,  93, "DelayLoadFailureHook",                  DelayLoadFailureHook},
{ 0,  94, "DeleteAtom",                            DeleteAtom},
{ 0,  95, "DeleteCriticalSection",                 DeleteCriticalSection},
{-1,  96, "DeleteFiber",                           DeleteFiber},
{ 0,  97, "DeleteFileA",                           DeleteFileA},
{ 0,  98, "DeleteFileW",                           DeleteFileW},
{-1,  99, "DeleteTimerQueue",                      DeleteTimerQueue},
{-1, 100, "DeleteTimerQueueEx",                    DeleteTimerQueueEx},
{-1, 101, "DeleteTimerQueueTimer",                 DeleteTimerQueueTimer},
{-1, 102, "DeleteVolumeMountPointA",               DeleteVolumeMountPointA},
{-1, 103, "DeleteVolumeMountPointW",               DeleteVolumeMountPointW},
{-1, 104, "DeviceIoControl",                       DeviceIoControl},
{ 0, 105, "DisableThreadLibraryCalls",             DisableThreadLibraryCalls},
{-1, 106, "DisconnectNamedPipe",                   DisconnectNamedPipe},
{-1, 107, "DnsHostnameToComputerNameA",            DnsHostnameToComputerNameA},
{-1, 108, "DnsHostnameToComputerNameW",            DnsHostnameToComputerNameW},
{-1, 109, "DosDateTimeToFileTime",                 DosDateTimeToFileTime},
{-1, 110, "DosPathToSessionPathA",                 DosPathToSessionPathA},
{-1, 111, "DosPathToSessionPathW",                 DosPathToSessionPathW},
{-1, 112, "DuplicateConsoleHandle",                DuplicateConsoleHandle},
{-1, 113, "DuplicateHandle",                       DuplicateHandle},
{-1, 114, "EndUpdateResourceA",                    EndUpdateResourceA},
{-1, 115, "EndUpdateResourceW",                    EndUpdateResourceW},
{ 0, 116, "EnterCriticalSection",                  EnterCriticalSection},
{ 0, 117, "EnumCalendarInfoA",                     EnumCalendarInfoA},
{-1, 118, "EnumCalendarInfoExA",                   EnumCalendarInfoExA},
{-1, 119, "EnumCalendarInfoExW",                   EnumCalendarInfoExW},
{ 0, 120, "EnumCalendarInfoW",                     EnumCalendarInfoW},
{-1, 121, "EnumDateFormatsA",                      EnumDateFormatsA},
{-1, 122, "EnumDateFormatsExA",                    EnumDateFormatsExA},
{-1, 123, "EnumDateFormatsExW",                    EnumDateFormatsExW},
{-1, 124, "EnumDateFormatsW",                      EnumDateFormatsW},
{-1, 125, "EnumLanguageGroupLocalesA",             EnumLanguageGroupLocalesA},
{-1, 126, "EnumLanguageGroupLocalesW",             EnumLanguageGroupLocalesW},
{-1, 127, "EnumResourceLanguagesA",                EnumResourceLanguagesA},
{-1, 128, "EnumResourceLanguagesW",                EnumResourceLanguagesW},
{-1, 129, "EnumResourceNamesA",                    EnumResourceNamesA},
{-1, 130, "EnumResourceNamesW",                    EnumResourceNamesW},
{-1, 131, "EnumResourceTypesA",                    EnumResourceTypesA},
{-1, 132, "EnumResourceTypesW",                    EnumResourceTypesW},
{-1, 133, "EnumSystemCodePagesA",                  EnumSystemCodePagesA},
{-1, 134, "EnumSystemCodePagesW",                  EnumSystemCodePagesW},
{-1, 135, "EnumSystemLanguageGroupsA",             EnumSystemLanguageGroupsA},
{-1, 136, "EnumSystemLanguageGroupsW",             EnumSystemLanguageGroupsW},
{-1, 137, "EnumSystemLocalesA",                    EnumSystemLocalesA},
{-1, 138, "EnumSystemLocalesW",                    EnumSystemLocalesW},
{-1, 139, "EnumTimeFormatsA",                      EnumTimeFormatsA},
{-1, 140, "EnumTimeFormatsW",                      EnumTimeFormatsW},
{-1, 141, "EnumUILanguagesA",                      EnumUILanguagesA},
{-1, 142, "EnumUILanguagesW",                      EnumUILanguagesW},
{-1, 143, "EraseTape",                             EraseTape},
{-1, 144, "EscapeCommFunction",                    EscapeCommFunction},
{ 0, 145, "ExitProcess",                           ExitProcess},
{ 0, 146, "ExitThread",                            ExitThread},
{-1, 147, "ExitVDM",                               ExitVDM},
{-1, 148, "ExpandEnvironmentStringsA",             ExpandEnvironmentStringsA},
{-1, 149, "ExpandEnvironmentStringsW",             ExpandEnvironmentStringsW},
{-1, 150, "ExpungeConsoleCommandHistoryA",         ExpungeConsoleCommandHistoryA},
{-1, 151, "ExpungeConsoleCommandHistoryW",         ExpungeConsoleCommandHistoryW},
{-1, 152, "ExtendVirtualBuffer",                   ExtendVirtualBuffer},
{-1, 153, "FatalAppExitA",                         FatalAppExitA},
{-1, 154, "FatalAppExitW",                         FatalAppExitW},
{-1, 155, "FatalExit",                             FatalExit},
{-1, 156, "FileTimeToDosDateTime",                 FileTimeToDosDateTime},
{ 0, 157, "FileTimeToLocalFileTime",               FileTimeToLocalFileTime},
{ 0, 158, "FileTimeToSystemTime",                  FileTimeToSystemTime},
{-1, 159, "FillConsoleOutputAttribute",            FillConsoleOutputAttribute},
{-1, 160, "FillConsoleOutputCharacterA",           FillConsoleOutputCharacterA},
{-1, 161, "FillConsoleOutputCharacterW",           FillConsoleOutputCharacterW},
{ 0, 162, "FindAtomA",                             FindAtomA},
{ 0, 163, "FindAtomW",                             FindAtomW},
{ 0, 164, "FindClose",                             FindClose},
{-1, 165, "FindCloseChangeNotification",           FindCloseChangeNotification},
{-1, 166, "FindFirstChangeNotificationA",          FindFirstChangeNotificationA},
{-1, 167, "FindFirstChangeNotificationW",          FindFirstChangeNotificationW},
{ 0, 168, "FindFirstFileA",                        FindFirstFileA},
{-1, 169, "FindFirstFileExA",                      FindFirstFileExA},
{-1, 170, "FindFirstFileExW",                      FindFirstFileExW},
{ 0, 171, "FindFirstFileW",                        FindFirstFileW},
{-1, 172, "FindFirstVolumeA",                      FindFirstVolumeA},
{-1, 173, "FindFirstVolumeMountPointA",            FindFirstVolumeMountPointA},
{-1, 174, "FindFirstVolumeMountPointW",            FindFirstVolumeMountPointW},
{-1, 175, "FindFirstVolumeW",                      FindFirstVolumeW},
{-1, 176, "FindNextChangeNotification",            FindNextChangeNotification},
{ 0, 177, "FindNextFileA",                         FindNextFileA},
{ 0, 178, "FindNextFileW",                         FindNextFileW},
{-1, 179, "FindNextVolumeA",                       FindNextVolumeA},
{-1, 180, "FindNextVolumeMountPointA",             FindNextVolumeMountPointA},
{-1, 181, "FindNextVolumeMountPointW",             FindNextVolumeMountPointW},
{-1, 182, "FindNextVolumeW",                       FindNextVolumeW},
{ 0, 183, "FindResourceA",                         FindResourceA},
{ 0, 184, "FindResourceExA",                       FindResourceExA},
{ 0, 185, "FindResourceExW",                       FindResourceExW},
{ 0, 186, "FindResourceW",                         FindResourceW},
{-1, 187, "FindVolumeClose",                       FindVolumeClose},
{-1, 188, "FindVolumeMountPointClose",             FindVolumeMountPointClose},
{-1, 189, "FlushConsoleInputBuffer",               FlushConsoleInputBuffer},
{ 0, 190, "FlushFileBuffers",                      FlushFileBuffers},
{-1, 191, "FlushInstructionCache",                 FlushInstructionCache},
{-1, 192, "FlushViewOfFile",                       FlushViewOfFile},
{-1, 193, "FoldStringA",                           FoldStringA},
{-1, 194, "FoldStringW",                           FoldStringW},
{-1, 195, "FormatMessageA",                        FormatMessageA},
{-1, 196, "FormatMessageW",                        FormatMessageW},
{-1, 197, "FreeConsole",                           FreeConsole},
{ 0, 198, "FreeEnvironmentStringsA",               FreeEnvironmentStringsA},
{ 0, 199, "FreeEnvironmentStringsW",               FreeEnvironmentStringsW},
{ 0, 200, "FreeLibrary",                           FreeLibrary},
{-1, 201, "FreeLibraryAndExitThread",              FreeLibraryAndExitThread},
{ 0, 202, "FreeResource",                          FreeResource},
{-1, 203, "FreeUserPhysicalPages",                 FreeUserPhysicalPages},
{-1, 204, "FreeVirtualBuffer",                     FreeVirtualBuffer},
{-1, 205, "GenerateConsoleCtrlEvent",              GenerateConsoleCtrlEvent},
{ 0, 206, "GetACP",                                GetACP},
{ 0, 207, "GetAtomNameA",                          GetAtomNameA},
{ 0, 208, "GetAtomNameW",                          GetAtomNameW},
{-1, 209, "GetBinaryType",                         GetBinaryTypeA},
{-1, 210, "GetBinaryTypeA",                        GetBinaryTypeA},
{-1, 211, "GetBinaryTypeW",                        GetBinaryTypeW},
{ 0, 212, "GetCPInfo",                             GetCPInfo},
{ 0, 213, "GetCPInfoExA",                          GetCPInfoExA},
{ 0, 214, "GetCPInfoExW",                          GetCPInfoExW},
{-1, 215, "GetCalendarInfoA",                      GetCalendarInfoA},
{-1, 216, "GetCalendarInfoW",                      GetCalendarInfoW},
{-1, 217, "GetCommConfig",                         GetCommConfig},
{-1, 218, "GetCommMask",                           GetCommMask},
{-1, 219, "GetCommModemStatus",                    GetCommModemStatus},
{-1, 220, "GetCommProperties",                     GetCommProperties},
{-1, 221, "GetCommState",                          GetCommState},
{-1, 222, "GetCommTimeouts",                       GetCommTimeouts},
{ 0, 223, "GetCommandLineA",                       GetCommandLineA},
{ 0, 224, "GetCommandLineW",                       GetCommandLineW},
{-1, 225, "GetCompressedFileSizeA",                GetCompressedFileSizeA},
{-1, 226, "GetCompressedFileSizeW",                GetCompressedFileSizeW},
{-1, 227, "GetComputerNameA",                      GetComputerNameA},
{-1, 228, "GetComputerNameExA",                    GetComputerNameExA},
{-1, 229, "GetComputerNameExW",                    GetComputerNameExW},
{-1, 230, "GetComputerNameW",                      GetComputerNameW},
{-1, 231, "GetConsoleAliasA",                      GetConsoleAliasA},
{-1, 232, "GetConsoleAliasExesA",                  GetConsoleAliasExesA},
{-1, 233, "GetConsoleAliasExesLengthA",            GetConsoleAliasExesLengthA},
{-1, 234, "GetConsoleAliasExesLengthW",            GetConsoleAliasExesLengthW},
{-1, 235, "GetConsoleAliasExesW",                  GetConsoleAliasExesW},
{-1, 236, "GetConsoleAliasW",                      GetConsoleAliasW},
{-1, 237, "GetConsoleAliasesA",                    GetConsoleAliasesA},
{-1, 238, "GetConsoleAliasesLengthA",              GetConsoleAliasesLengthA},
{-1, 239, "GetConsoleAliasesLengthW",              GetConsoleAliasesLengthW},
{-1, 240, "GetConsoleAliasesW",                    GetConsoleAliasesW},
{-1, 241, "GetConsoleCP",                          GetConsoleCP},
{-1, 242, "GetConsoleCharType",                    GetConsoleCharType},
{-1, 243, "GetConsoleCommandHistoryA",             GetConsoleCommandHistoryA},
{-1, 244, "GetConsoleCommandHistoryLengthA",       GetConsoleCommandHistoryLengthA},
{-1, 245, "GetConsoleCommandHistoryLengthW",       GetConsoleCommandHistoryLengthW},
{-1, 246, "GetConsoleCommandHistoryW",             GetConsoleCommandHistoryW},
{-1, 247, "GetConsoleCursorInfo",                  GetConsoleCursorInfo},
{-1, 248, "GetConsoleCursorMode",                  GetConsoleCursorMode},
{-1, 249, "GetConsoleDisplayMode",                 GetConsoleDisplayMode},
{-1, 250, "GetConsoleFontInfo",                    GetConsoleFontInfo},
{-1, 251, "GetConsoleFontSize",                    GetConsoleFontSize},
{-1, 252, "GetConsoleHardwareState",               GetConsoleHardwareState},
{-1, 253, "GetConsoleInputExeNameA",               GetConsoleInputExeNameA},
{-1, 254, "GetConsoleInputExeNameW",               GetConsoleInputExeNameW},
{-1, 255, "GetConsoleInputWaitHandle",             GetConsoleInputWaitHandle},
{-1, 256, "GetConsoleKeyboardLayoutNameA",         GetConsoleKeyboardLayoutNameA},
{-1, 257, "GetConsoleKeyboardLayoutNameW",         GetConsoleKeyboardLayoutNameW},
{-1, 258, "GetConsoleMode",                        GetConsoleMode},
{-1, 259, "GetConsoleNlsMode",                     GetConsoleNlsMode},
{-1, 260, "GetConsoleOutputCP",                    GetConsoleOutputCP},
{-1, 261, "GetConsoleScreenBufferInfo",            GetConsoleScreenBufferInfo},
{-1, 262, "GetConsoleTitleA",                      GetConsoleTitleA},
{-1, 263, "GetConsoleTitleW",                      GetConsoleTitleW},
{-1, 264, "GetConsoleWindow",                      GetConsoleWindow},
{-1, 265, "GetCurrencyFormatA",                    GetCurrencyFormatA},
{-1, 266, "GetCurrencyFormatW",                    GetCurrencyFormatW},
{-1, 267, "GetCurrentConsoleFont",                 GetCurrentConsoleFont},
{ 0, 268, "GetCurrentDirectoryA",                  GetCurrentDirectoryA},
{ 0, 269, "GetCurrentDirectoryW",                  GetCurrentDirectoryW},
{ 0, 270, "GetCurrentProcess",                     GetCurrentProcess},
{-1, 271, "GetCurrentProcessId",                   GetCurrentProcessId},
{ 0, 272, "GetCurrentThread",                      GetCurrentThread},
{ 0, 273, "GetCurrentThreadId",                    GetCurrentThreadId},
{-1, 274, "GetDateFormatA",                        GetDateFormatA},
{-1, 275, "GetDateFormatW",                        GetDateFormatW},
{-1, 276, "GetDefaultCommConfigA",                 GetDefaultCommConfigA},
{-1, 277, "GetDefaultCommConfigW",                 GetDefaultCommConfigW},
{-1, 278, "GetDefaultSortkeySize",                 GetDefaultSortkeySize},
{-1, 279, "GetDevicePowerState",                   GetDevicePowerState},
{ 0, 280, "GetDiskFreeSpaceA",                     GetDiskFreeSpaceA},
{ 0, 281, "GetDiskFreeSpaceExA",                   GetDiskFreeSpaceExA},
{ 0, 282, "GetDiskFreeSpaceExW",                   GetDiskFreeSpaceExW},
{ 0, 283, "GetDiskFreeSpaceW",                     GetDiskFreeSpaceW},
{-1, 284, "GetDriveTypeA",                         GetDriveTypeA},
{-1, 285, "GetDriveTypeW",                         GetDriveTypeW},
{ 0, 286, "GetEnvironmentStrings",                 GetEnvironmentStringsA},
{ 0, 287, "GetEnvironmentStringsA",                GetEnvironmentStringsA},
{ 0, 288, "GetEnvironmentStringsW",                GetEnvironmentStringsW},
{ 0, 289, "GetEnvironmentVariableA",               GetEnvironmentVariableA},
{ 0, 290, "GetEnvironmentVariableW",               GetEnvironmentVariableW},
{-1, 291, "GetExitCodeProcess",                    GetExitCodeProcess},
{-1, 292, "GetExitCodeThread",                     GetExitCodeThread},
{ 0, 293, "GetFileAttributesA",                    GetFileAttributesA},
{-1, 294, "GetFileAttributesExA",                  GetFileAttributesExA},
{-1, 295, "GetFileAttributesExW",                  GetFileAttributesExW},
{ 0, 296, "GetFileAttributesW",                    GetFileAttributesW},
{-1, 297, "GetFileInformationByHandle",            GetFileInformationByHandle},
{ 0, 298, "GetFileSize",                           GetFileSize},
{-1, 299, "GetFileSizeEx",                         GetFileSizeEx},
{ 0, 300, "GetFileTime",                           GetFileTime},
{ 0, 301, "GetFileType",                           GetFileType},
{ 0, 302, "GetFullPathNameA",                      GetFullPathNameA},
{ 0, 303, "GetFullPathNameW",                      GetFullPathNameW},
{-1, 304, "GetHandleInformation",                  GetHandleInformation},
{-1, 305, "GetLargestConsoleWindowSize",           GetLargestConsoleWindowSize},
{ 0, 306, "GetLastError",                          GetLastError},
{-1, 307, "GetLinguistLangSize",                   GetLinguistLangSize},
{ 0, 308, "GetLocalTime",                          GetLocalTime},
{ 0, 309, "GetLocaleInfoA",                        GetLocaleInfoA},
{ 0, 310, "GetLocaleInfoW",                        GetLocaleInfoW},
{ 0, 311, "GetLogicalDriveStringsA",               GetLogicalDriveStringsA},
{ 0, 312, "GetLogicalDriveStringsW",               GetLogicalDriveStringsW},
{-1, 313, "GetLogicalDrives",                      GetLogicalDrives},
{-1, 314, "GetLongPathNameA",                      GetLongPathNameA},
{-1, 315, "GetLongPathNameW",                      GetLongPathNameW},
{-1, 316, "GetMailslotInfo",                       GetMailslotInfo},
{ 0, 317, "GetModuleFileNameA",                    GetModuleFileNameA},
{ 0, 318, "GetModuleFileNameW",                    GetModuleFileNameW},
{ 0, 319, "GetModuleHandleA",                      GetModuleHandleA},
{ 0, 320, "GetModuleHandleW",                      GetModuleHandleW},
{-1, 321, "GetNamedPipeHandleStateA",              GetNamedPipeHandleStateA},
{-1, 322, "GetNamedPipeHandleStateW",              GetNamedPipeHandleStateW},
{-1, 323, "GetNamedPipeInfo",                      GetNamedPipeInfo},
{-1, 324, "GetNextVDMCommand",                     GetNextVDMCommand},
{-1, 325, "GetNlsSectionName",                     GetNlsSectionName},
{-1, 326, "GetNumberFormatA",                      GetNumberFormatA},
{-1, 327, "GetNumberFormatW",                      GetNumberFormatW},
{-1, 328, "GetNumberOfConsoleFonts",               GetNumberOfConsoleFonts},
{-1, 329, "GetNumberOfConsoleInputEvents",         GetNumberOfConsoleInputEvents},
{-1, 330, "GetNumberOfConsoleMouseButtons",        GetNumberOfConsoleMouseButtons},
{ 0, 331, "GetOEMCP",                              GetOEMCP},
{-1, 332, "GetOverlappedResult",                   GetOverlappedResult},
{-1, 333, "GetPriorityClass",                      GetPriorityClass},
{ 0, 334, "GetPrivateProfileIntA",                 GetPrivateProfileIntA},
{ 0, 335, "GetPrivateProfileIntW",                 GetPrivateProfileIntW},
{ 0, 336, "GetPrivateProfileSectionA",             GetPrivateProfileSectionA},
{ 0, 337, "GetPrivateProfileSectionNamesA",        GetPrivateProfileSectionNamesA},
{-1, 338, "GetPrivateProfileSectionNamesW",        GetPrivateProfileSectionNamesW},
{ 0, 339, "GetPrivateProfileSectionW",             GetPrivateProfileSectionW},
{ 0, 340, "GetPrivateProfileStringA",              GetPrivateProfileStringA},
{ 0, 341, "GetPrivateProfileStringW",              GetPrivateProfileStringW},
{ 0, 342, "GetPrivateProfileStructA",              GetPrivateProfileStructA},
{ 0, 343, "GetPrivateProfileStructW",              GetPrivateProfileStructW},
{ 0, 344, "GetProcAddress",                        GetProcAddress},
{ 0, 345, "GetProcessAffinityMask",                GetProcessAffinityMask},
{ 0, 346, "GetProcessHeap",                        GetProcessHeap},
{ 0, 347, "GetProcessHeaps",                       GetProcessHeaps},
{-1, 348, "GetProcessIoCounters",                  GetProcessIoCounters},
{-1, 349, "GetProcessPriorityBoost",               GetProcessPriorityBoost},
{-1, 350, "GetProcessShutdownParameters",          GetProcessShutdownParameters},
{-1, 351, "GetProcessTimes",                       GetProcessTimes},
{-1, 352, "GetProcessVersion",                     GetProcessVersion},
{-1, 353, "GetProcessWorkingSetSize",              GetProcessWorkingSetSize},
{ 0, 354, "GetProfileIntA",                        GetProfileIntA},
{ 0, 355, "GetProfileIntW",                        GetProfileIntW},
{ 0, 356, "GetProfileSectionA",                    GetProfileSectionA},
{ 0, 357, "GetProfileSectionW",                    GetProfileSectionW},
{ 0, 358, "GetProfileStringA",                     GetProfileStringA},
{ 0, 359, "GetProfileStringW",                     GetProfileStringW},
{-1, 360, "GetQueuedCompletionStatus",             GetQueuedCompletionStatus},
{ 0, 361, "GetShortPathNameA",                     GetShortPathNameA},
{ 0, 362, "GetShortPathNameW",                     GetShortPathNameW},
{ 0, 363, "GetStartupInfoA",                       GetStartupInfoA},
{ 0, 364, "GetStartupInfoW",                       GetStartupInfoW},
{ 0, 365, "GetStdHandle",                          GetStdHandle},
{ 0, 366, "GetStringTypeA",                        GetStringTypeA},
{-1, 367, "GetStringTypeExA",                      GetStringTypeExA},
{-1, 368, "GetStringTypeExW",                      GetStringTypeExW},
{ 0, 369, "GetStringTypeW",                        GetStringTypeW},
{ 0, 370, "GetSystemDefaultLCID",                  GetSystemDefaultLCID},
{ 0, 371, "GetSystemDefaultLangID",                GetSystemDefaultLangID},
{ 0, 372, "GetSystemDefaultUILanguage",            GetSystemDefaultUILanguage},
{ 0, 373, "GetSystemDirectoryA",                   GetSystemDirectoryA},
{ 0, 374, "GetSystemDirectoryW",                   GetSystemDirectoryW},
{ 0, 375, "GetSystemInfo",                         GetSystemInfo},
{-1, 376, "GetSystemPowerStatus",                  GetSystemPowerStatus},
{ 0, 377, "GetSystemTime",                         GetSystemTime},
{-1, 378, "GetSystemTimeAdjustment",               GetSystemTimeAdjustment},
{ 0, 379, "GetSystemTimeAsFileTime",               GetSystemTimeAsFileTime},
{-1, 380, "GetSystemWindowsDirectoryA",            GetSystemWindowsDirectoryA},
{-1, 381, "GetSystemWindowsDirectoryW",            GetSystemWindowsDirectoryW},
{-1, 382, "GetTapeParameters",                     GetTapeParameters},
{-1, 383, "GetTapePosition",                       GetTapePosition},
{-1, 384, "GetTapeStatus",                         GetTapeStatus},
{ 0, 385, "GetTempFileNameA",                      GetTempFileNameA},
{ 0, 386, "GetTempFileNameW",                      GetTempFileNameW},
{ 0, 387, "GetTempPathA",                          GetTempPathA},
{ 0, 388, "GetTempPathW",                          GetTempPathW},
{-1, 389, "GetThreadContext",                      GetThreadContext},
{ 0, 390, "GetThreadLocale",                       GetThreadLocale},
{ 0, 391, "GetThreadPriority",                     GetThreadPriority},
{-1, 392, "GetThreadPriorityBoost",                GetThreadPriorityBoost},
{-1, 393, "GetThreadSelectorEntry",                GetThreadSelectorEntry},
{-1, 394, "GetThreadTimes",                        GetThreadTimes},
{ 0, 395, "GetTickCount",                          GetTickCount},
{-1, 396, "GetTimeFormatA",                        GetTimeFormatA},
{-1, 397, "GetTimeFormatW",                        GetTimeFormatW},
{ 0, 398, "GetTimeZoneInformation",                GetTimeZoneInformation},
{ 0, 399, "GetUserDefaultLCID",                    GetUserDefaultLCID},
{ 0, 400, "GetUserDefaultLangID",                  GetUserDefaultLangID},
{ 0, 401, "GetUserDefaultUILanguage",              GetUserDefaultUILanguage},
{-1, 402, "GetVDMCurrentDirectories",              GetVDMCurrentDirectories},
{ 0, 403, "GetVersion",                            GetVersion},
{ 0, 404, "GetVersionExA",                         GetVersionExA},
{ 0, 405, "GetVersionExW",                         GetVersionExW},
{-1, 406, "GetVolumeInformationA",                 GetVolumeInformationA},
{-1, 407, "GetVolumeInformationW",                 GetVolumeInformationW},
{-1, 408, "GetVolumeNameForVolumeMountPointA",     GetVolumeNameForVolumeMountPointA},
{-1, 409, "GetVolumeNameForVolumeMountPointW",     GetVolumeNameForVolumeMountPointW},
{-1, 410, "GetVolumePathNameA",                    GetVolumePathNameA},
{-1, 411, "GetVolumePathNameW",                    GetVolumePathNameW},
{-1, 412, "GetWindowsDirectoryA",                  GetWindowsDirectoryA},
{-1, 413, "GetWindowsDirectoryW",                  GetWindowsDirectoryW},
{-1, 414, "GetWriteWatch",                         GetWriteWatch},
{ 0, 415, "GlobalAddAtomA",                        GlobalAddAtomA},
{ 0, 416, "GlobalAddAtomW",                        GlobalAddAtomW},
{ 0, 417, "GlobalAlloc",                           GlobalAlloc},
{-1, 418, "GlobalCompact",                         GlobalCompact},
{ 0, 419, "GlobalDeleteAtom",                      GlobalDeleteAtom},
{ 0, 420, "GlobalFindAtomA",                       GlobalFindAtomA},
{ 0, 421, "GlobalFindAtomW",                       GlobalFindAtomW},
{-1, 422, "GlobalFix",                             GlobalFix},
{ 0, 423, "GlobalFlags",                           GlobalFlags},
{ 0, 424, "GlobalFree",                            GlobalFree},
{ 0, 425, "GlobalGetAtomNameA",                    GlobalGetAtomNameA},
{ 0, 426, "GlobalGetAtomNameW",                    GlobalGetAtomNameW},
{ 0, 427, "GlobalHandle",                          GlobalHandle},
{ 0, 428, "GlobalLock",                            GlobalLock},
{-1, 429, "GlobalMemoryStatus",                    GlobalMemoryStatus},
{-1, 430, "GlobalMemoryStatusEx",                  GlobalMemoryStatusEx},
{ 0, 431, "GlobalReAlloc",                         GlobalReAlloc},
{ 0, 432, "GlobalSize",                            GlobalSize},
{-1, 433, "GlobalUnWire",                          GlobalUnWire},
{-1, 434, "GlobalUnfix",                           GlobalUnfix},
{ 0, 435, "GlobalUnlock",                          GlobalUnlock},
{-1, 436, "GlobalWire",                            GlobalWire},
{-1, 437, "Heap32First",                           Heap32First},
{-1, 438, "Heap32ListFirst",                       Heap32ListFirst},
{-1, 439, "Heap32ListNext",                        Heap32ListNext},
{-1, 440, "Heap32Next",                            Heap32Next},
{ 0, 441, "HeapAlloc",                             HeapAlloc},
{-1, 442, "HeapCompact",                           HeapCompact},
{ 0, 443, "HeapCreate",                            HeapCreate},
{-1, 444, "HeapCreateTagsW",                       HeapCreateTagsW},
{ 0, 445, "HeapDestroy",                           HeapDestroy},
{-1, 446, "HeapExtend",                            HeapExtend},
{ 0, 447, "HeapFree",                              HeapFree},
{-1, 448, "HeapLock",                              HeapLock},
{-1, 449, "HeapQueryInformation",                  HeapQueryInformation},
{-1, 450, "HeapQueryTagW",                         HeapQueryTagW},
{ 0, 451, "HeapReAlloc",                           HeapReAlloc},
{-1, 452, "HeapSetInformation",                    HeapSetInformation},
{ 0, 453, "HeapSize",                              HeapSize},
{-1, 454, "HeapSummary",                           HeapSummary},
{-1, 455, "HeapUnlock",                            HeapUnlock},
{-1, 456, "HeapUsage",                             HeapUsage},
{-1, 457, "HeapValidate",                          HeapValidate},
{-1, 458, "HeapWalk",                              HeapWalk},
{ 0, 459, "InitAtomTable",                         InitAtomTable},
{ 0, 460, "InitializeCriticalSection",             InitializeCriticalSection},
{-1, 461, "InitializeCriticalSectionAndSpinCount", InitializeCriticalSectionAndSpinCount},
{ 0, 462, "InterlockedCompareExchange",            InterlockedCompareExchange},
{ 0, 463, "InterlockedDecrement",                  InterlockedDecrement},
{ 0, 464, "InterlockedExchange",                   InterlockedExchange},
{ 0, 465, "InterlockedExchangeAdd",                InterlockedExchangeAdd},
{ 0, 466, "InterlockedIncrement",                  InterlockedIncrement},
{-1, 467, "InvalidateConsoleDIBits",               InvalidateConsoleDIBits},
{ 0, 468, "IsBadCodePtr",                          IsBadCodePtr},
{-1, 469, "IsBadHugeReadPtr",                      IsBadHugeReadPtr},
{-1, 470, "IsBadHugeWritePtr",                     IsBadHugeWritePtr},
{ 0, 471, "IsBadReadPtr",                          IsBadReadPtr},
{-1, 472, "IsBadStringPtrA",                       IsBadStringPtrA},
{-1, 473, "IsBadStringPtrW",                       IsBadStringPtrW},
{ 0, 474, "IsBadWritePtr",                         IsBadWritePtr},
{ 0, 475, "IsDBCSLeadByte",                        IsDBCSLeadByte},
{ 0, 476, "IsDBCSLeadByteEx",                      IsDBCSLeadByteEx},
{-1, 477, "IsDebuggerPresent",                     IsDebuggerPresent},
{-1, 478, "IsProcessorFeaturePresent",             IsProcessorFeaturePresent},
{-1, 479, "IsSystemResumeAutomatic",               IsSystemResumeAutomatic},
{-1, 480, "IsValidCodePage",                       IsValidCodePage},
{-1, 481, "IsValidLanguageGroup",                  IsValidLanguageGroup},
{-1, 482, "IsValidLocale",                         IsValidLocale},
{ 0, 483, "LCMapStringA",                          LCMapStringA},
{ 0, 484, "LCMapStringW",                          LCMapStringW},
{ 0, 485, "LeaveCriticalSection",                  LeaveCriticalSection},
{ 0, 486, "LoadLibraryA",                          LoadLibraryA},
{ 0, 487, "LoadLibraryExA",                        LoadLibraryExA},
{ 0, 488, "LoadLibraryExW",                        LoadLibraryExW},
{ 0, 489, "LoadLibraryW",                          LoadLibraryW},
{-1, 490, "LoadModule",                            LoadModule},
{ 0, 491, "LoadResource",                          LoadResource},
{ 0, 492, "LocalAlloc",                            LocalAlloc},
{-1, 493, "LocalCompact",                          LocalCompact},
{ 0, 494, "LocalFileTimeToFileTime",               LocalFileTimeToFileTime},
{ 0, 495, "LocalFlags",                            LocalFlags},
{ 0, 496, "LocalFree",                             LocalFree},
{ 0, 497, "LocalHandle",                           LocalHandle},
{ 0, 498, "LocalLock",                             LocalLock},
{ 0, 499, "LocalReAlloc",                          LocalReAlloc},
{-1, 500, "LocalShrink",                           LocalShrink},
{ 0, 501, "LocalSize",                             LocalSize},
{ 0, 502, "LocalUnlock",                           LocalUnlock},
{-1, 503, "LockFile",                              LockFile},
{-1, 504, "LockFileEx",                            LockFileEx},
{ 0, 505, "LockResource",                          LockResource},
{-1, 506, "MapUserPhysicalPages",                  MapUserPhysicalPages},
{-1, 507, "MapUserPhysicalPagesScatter",           MapUserPhysicalPagesScatter},
{ 0, 508, "MapViewOfFile",                         MapViewOfFile},
{ 0, 509, "MapViewOfFileEx",                       MapViewOfFileEx},
{-1, 510, "Module32First",                         Module32First},
{-1, 511, "Module32FirstW",                        Module32FirstW},
{-1, 512, "Module32Next",                          Module32Next},
{-1, 513, "Module32NextW",                         Module32NextW},
{ 0, 514, "MoveFileA",                             MoveFileA},
{ 0, 515, "MoveFileExA",                           MoveFileExA},
{ 0, 516, "MoveFileExW",                           MoveFileExW},
{ 0, 517, "MoveFileW",                             MoveFileW},
{-1, 518, "MoveFileWithProgressA",                 MoveFileWithProgressA},
{-1, 519, "MoveFileWithProgressW",                 MoveFileWithProgressW},
{ 0, 520, "MulDiv",                                MulDiv},
{ 0, 521, "MultiByteToWideChar",                   MultiByteToWideChar},
{-1, 522, "NlsConvertIntegerToString",             NlsConvertIntegerToString},
{-1, 523, "NlsGetCacheUpdateCount",                NlsGetCacheUpdateCount},
{-1, 524, "NlsResetProcessLocale",                 NlsResetProcessLocale},
{-1, 525, "OpenConsoleW",                          OpenConsoleW},
{-1, 526, "OpenDataFile",                          OpenDataFile},
{ 0, 527, "OpenEventA",                            OpenEventA},
{ 0, 528, "OpenEventW",                            OpenEventW},
{-1, 529, "OpenFile",                              OpenFile},
{ 0, 530, "OpenFileMappingA",                      OpenFileMappingA},
{ 0, 531, "OpenFileMappingW",                      OpenFileMappingW},
{-1, 532, "OpenJobObjectA",                        OpenJobObjectA},
{-1, 533, "OpenJobObjectW",                        OpenJobObjectW},
{ 0, 534, "OpenMutexA",                            OpenMutexA},
{ 0, 535, "OpenMutexW",                            OpenMutexW},
{-1, 536, "OpenProcess",                           OpenProcess},
{-1, 537, "OpenProfileUserMapping",                OpenProfileUserMapping},
{ 0, 538, "OpenSemaphoreA",                        OpenSemaphoreA},
{ 0, 539, "OpenSemaphoreW",                        OpenSemaphoreW},
{-1, 540, "OpenThread",                            OpenThread},
{-1, 541, "OpenWaitableTimerA",                    OpenWaitableTimerA},
{-1, 542, "OpenWaitableTimerW",                    OpenWaitableTimerW},
{ 0, 543, "OutputDebugStringA",                    OutputDebugStringA},
{ 0, 544, "OutputDebugStringW",                    OutputDebugStringW},
{-1, 545, "PeekConsoleInputA",                     PeekConsoleInputA},
{-1, 546, "PeekConsoleInputW",                     PeekConsoleInputW},
{-1, 547, "PeekNamedPipe",                         PeekNamedPipe},
{-1, 548, "PostQueuedCompletionStatus",            PostQueuedCompletionStatus},
{-1, 549, "PrepareTape",                           PrepareTape},
{-1, 550, "PrivCopyFileExW",                       PrivCopyFileExW},
{-1, 551, "PrivMoveFileIdentityW",                 PrivMoveFileIdentityW},
{-1, 552, "Process32First",                        Process32First},
{-1, 553, "Process32FirstW",                       Process32FirstW},
{-1, 554, "Process32Next",                         Process32Next},
{-1, 555, "Process32NextW",                        Process32NextW},
{-1, 556, "ProcessIdToSessionId",                  ProcessIdToSessionId},
{ 0, 557, "PulseEvent",                            PulseEvent},
{-1, 558, "PurgeComm",                             PurgeComm},
{-1, 559, "QueryDosDeviceA",                       QueryDosDeviceA},
{-1, 560, "QueryDosDeviceW",                       QueryDosDeviceW},
{-1, 561, "QueryInformationJobObject",             QueryInformationJobObject},
{ 0, 562, "QueryPerformanceCounter",               QueryPerformanceCounter},
{ 0, 563, "QueryPerformanceFrequency",             QueryPerformanceFrequency},
{-1, 564, "QueryWin31IniFilesMappedToRegistry",    QueryWin31IniFilesMappedToRegistry},
{-1, 565, "QueueUserAPC",                          QueueUserAPC},
{-1, 566, "QueueUserWorkItem",                     QueueUserWorkItem},
{ 0, 567, "RaiseException",                        RaiseException},
{-1, 568, "ReadConsoleA",                          ReadConsoleA},
{-1, 569, "ReadConsoleInputA",                     ReadConsoleInputA},
{-1, 570, "ReadConsoleInputExA",                   ReadConsoleInputExA},
{-1, 571, "ReadConsoleInputExW",                   ReadConsoleInputExW},
{-1, 572, "ReadConsoleInputW",                     ReadConsoleInputW},
{-1, 573, "ReadConsoleOutputA",                    ReadConsoleOutputA},
{-1, 574, "ReadConsoleOutputAttribute",            ReadConsoleOutputAttribute},
{-1, 575, "ReadConsoleOutputCharacterA",           ReadConsoleOutputCharacterA},
{-1, 576, "ReadConsoleOutputCharacterW",           ReadConsoleOutputCharacterW},
{-1, 577, "ReadConsoleOutputW",                    ReadConsoleOutputW},
{-1, 578, "ReadConsoleW",                          ReadConsoleW},
{-1, 579, "ReadDirectoryChangesW",                 ReadDirectoryChangesW},
{ 0, 580, "ReadFile",                              ReadFile},
{-1, 581, "ReadFileEx",                            ReadFileEx},
{-1, 582, "ReadFileScatter",                       ReadFileScatter},
{-1, 583, "ReadProcessMemory",                     ReadProcessMemory},
{-1, 584, "RegisterConsoleIME",                    RegisterConsoleIME},
{-1, 585, "RegisterConsoleOS2",                    RegisterConsoleOS2},
{-1, 586, "RegisterConsoleVDM",                    RegisterConsoleVDM},
{-1, 587, "RegisterWaitForInputIdle",              RegisterWaitForInputIdle},
{-1, 588, "RegisterWaitForSingleObject",           RegisterWaitForSingleObject},
{-1, 589, "RegisterWaitForSingleObjectEx",         RegisterWaitForSingleObjectEx},
{-1, 590, "RegisterWowBaseHandlers",               RegisterWowBaseHandlers},
{-1, 591, "RegisterWowExec",                       RegisterWowExec},
{ 0, 592, "ReleaseMutex",                          ReleaseMutex},
{ 0, 593, "ReleaseSemaphore",                      ReleaseSemaphore},
{ 0, 594, "RemoveDirectoryA",                      RemoveDirectoryA},
{ 0, 595, "RemoveDirectoryW",                      RemoveDirectoryW},
{-1, 596, "ReplaceFile",                           ReplaceFileA},
{-1, 597, "ReplaceFileA",                          ReplaceFileA},
{-1, 598, "ReplaceFileW",                          ReplaceFileW},
{-1, 599, "RequestDeviceWakeup",                   RequestDeviceWakeup},
{-1, 600, "RequestWakeupLatency",                  RequestWakeupLatency},
{ 0, 601, "ResetEvent",                            ResetEvent},
{-1, 602, "ResetWriteWatch",                       ResetWriteWatch},
{ 0, 603, "ResumeThread",                          ResumeThread},
{-1, 604, "RtlFillMemory",                         RtlFillMemory},
{-1, 605, "RtlMoveMemory",                         RtlMoveMemory},
{ 0, 606, "RtlUnwind",                             RtlUnwind},
{-1, 607, "RtlZeroMemory",                         RtlZeroMemory},
{-1, 608, "ScrollConsoleScreenBufferA",            ScrollConsoleScreenBufferA},
{-1, 609, "ScrollConsoleScreenBufferW",            ScrollConsoleScreenBufferW},
{-1, 610, "SearchPathA",                           SearchPathA},
{-1, 611, "SearchPathW",                           SearchPathW},
{-1, 612, "SetCPGlobal",                           SetCPGlobal},
{-1, 613, "SetCalendarInfoA",                      SetCalendarInfoA},
{-1, 614, "SetCalendarInfoW",                      SetCalendarInfoW},
{-1, 615, "SetCommBreak",                          SetCommBreak},
{-1, 616, "SetCommConfig",                         SetCommConfig},
{-1, 617, "SetCommMask",                           SetCommMask},
{-1, 618, "SetCommState",                          SetCommState},
{-1, 619, "SetCommTimeouts",                       SetCommTimeouts},
{-1, 620, "SetComputerNameA",                      SetComputerNameA},
{-1, 621, "SetComputerNameExA",                    SetComputerNameExA},
{-1, 622, "SetComputerNameExW",                    SetComputerNameExW},
{-1, 623, "SetComputerNameW",                      SetComputerNameW},
{-1, 624, "SetConsoleActiveScreenBuffer",          SetConsoleActiveScreenBuffer},
{-1, 625, "SetConsoleCP",                          SetConsoleCP},
{-1, 626, "SetConsoleCommandHistoryMode",          SetConsoleCommandHistoryMode},
{-1, 627, "SetConsoleCtrlHandler",                 SetConsoleCtrlHandler},
{-1, 628, "SetConsoleCursor",                      SetConsoleCursor},
{-1, 629, "SetConsoleCursorInfo",                  SetConsoleCursorInfo},
{-1, 630, "SetConsoleCursorMode",                  SetConsoleCursorMode},
{-1, 631, "SetConsoleCursorPosition",              SetConsoleCursorPosition},
{-1, 632, "SetConsoleDisplayMode",                 SetConsoleDisplayMode},
{-1, 633, "SetConsoleFont",                        SetConsoleFont},
{-1, 634, "SetConsoleHardwareState",               SetConsoleHardwareState},
{-1, 635, "SetConsoleIcon",                        SetConsoleIcon},
{-1, 636, "SetConsoleInputExeNameA",               SetConsoleInputExeNameA},
{-1, 637, "SetConsoleInputExeNameW",               SetConsoleInputExeNameW},
{-1, 638, "SetConsoleKeyShortcuts",                SetConsoleKeyShortcuts},
{-1, 639, "SetConsoleLocalEUDC",                   SetConsoleLocalEUDC},
{-1, 640, "SetConsoleMaximumWindowSize",           SetConsoleMaximumWindowSize},
{-1, 641, "SetConsoleMenuClose",                   SetConsoleMenuClose},
{-1, 642, "SetConsoleMode",                        SetConsoleMode},
{-1, 643, "SetConsoleNlsMode",                     SetConsoleNlsMode},
{-1, 644, "SetConsoleNumberOfCommandsA",           SetConsoleNumberOfCommandsA},
{-1, 645, "SetConsoleNumberOfCommandsW",           SetConsoleNumberOfCommandsW},
{-1, 646, "SetConsoleOS2OemFormat",                SetConsoleOS2OemFormat},
{-1, 647, "SetConsoleOutputCP",                    SetConsoleOutputCP},
{-1, 648, "SetConsolePalette",                     SetConsolePalette},
{ 0, 649, "SetConsoleScreenBufferSize",            SetConsoleScreenBufferSize},
{-1, 650, "SetConsoleTextAttribute",               SetConsoleTextAttribute},
{-1, 651, "SetConsoleTitleA",                      SetConsoleTitleA},
{-1, 652, "SetConsoleTitleW",                      SetConsoleTitleW},
{-1, 653, "SetConsoleWindowInfo",                  SetConsoleWindowInfo},
{-1, 654, "SetCriticalSectionSpinCount",           SetCriticalSectionSpinCount},
{ 0, 655, "SetCurrentDirectoryA",                  SetCurrentDirectoryA},
{ 0, 656, "SetCurrentDirectoryW",                  SetCurrentDirectoryW},
{-1, 657, "SetDefaultCommConfigA",                 SetDefaultCommConfigA},
{-1, 658, "SetDefaultCommConfigW",                 SetDefaultCommConfigW},
{ 0, 659, "SetEndOfFile",                          SetEndOfFile},
{ 0, 660, "SetEnvironmentVariableA",               SetEnvironmentVariableA},
{ 0, 661, "SetEnvironmentVariableW",               SetEnvironmentVariableW},
{-1, 662, "SetErrorMode",                          SetErrorMode},
{ 0, 663, "SetEvent",                              SetEvent},
{-1, 664, "SetFileApisToANSI",                     SetFileApisToANSI},
{-1, 665, "SetFileApisToOEM",                      SetFileApisToOEM},
{-1, 666, "SetFileAttributesA",                    SetFileAttributesA},
{-1, 667, "SetFileAttributesW",                    SetFileAttributesW},
{ 0, 668, "SetFilePointer",                        SetFilePointer},
{-1, 669, "SetFilePointerEx",                      SetFilePointerEx},
{ 0, 670, "SetFileTime",                           SetFileTime},
{ 0, 671, "SetHandleCount",                        SetHandleCount},
{-1, 672, "SetHandleInformation",                  SetHandleInformation},
{-1, 673, "SetInformationJobObject",               SetInformationJobObject},
{-1, 674, "SetLastConsoleEventActive",             SetLastConsoleEventActive},
{ 0, 675, "SetLastError",                          SetLastError},
{-1, 676, "SetLocalTime",                          SetLocalTime},
{-1, 677, "SetLocaleInfoA",                        SetLocaleInfoA},
{-1, 678, "SetLocaleInfoW",                        SetLocaleInfoW},
{-1, 679, "SetMailslotInfo",                       SetMailslotInfo},
{-1, 680, "SetMessageWaitingIndicator",            SetMessageWaitingIndicator},
{-1, 681, "SetNamedPipeHandleState",               SetNamedPipeHandleState},
{-1, 682, "SetPriorityClass",                      SetPriorityClass},
{ 0, 683, "SetProcessAffinityMask",                SetProcessAffinityMask},
{-1, 684, "SetProcessPriorityBoost",               SetProcessPriorityBoost},
{-1, 685, "SetProcessShutdownParameters",          SetProcessShutdownParameters},
{-1, 686, "SetProcessWorkingSetSize",              SetProcessWorkingSetSize},
{ 0, 687, "SetStdHandle",                          SetStdHandle},
{-1, 688, "SetSystemPowerState",                   SetSystemPowerState},
{-1, 689, "SetSystemTime",                         SetSystemTime},
{-1, 690, "SetSystemTimeAdjustment",               SetSystemTimeAdjustment},
{-1, 691, "SetTapeParameters",                     SetTapeParameters},
{-1, 692, "SetTapePosition",                       SetTapePosition},
{-1, 693, "SetTermsrvAppInstallMode",              SetTermsrvAppInstallMode},
{ 0, 694, "SetThreadAffinityMask",                 SetThreadAffinityMask},
{-1, 695, "SetThreadContext",                      SetThreadContext},
{-1, 696, "SetThreadExecutionState",               SetThreadExecutionState},
{-1, 697, "SetThreadIdealProcessor",               SetThreadIdealProcessor},
{-1, 698, "SetThreadLocale",                       SetThreadLocale},
{ 0, 699, "SetThreadPriority",                     SetThreadPriority},
{-1, 700, "SetThreadPriorityBoost",                SetThreadPriorityBoost},
{ 0, 701, "SetTimeZoneInformation",                SetTimeZoneInformation},
{-1, 702, "SetTimerQueueTimer",                    SetTimerQueueTimer},
{ 0, 703, "SetUnhandledExceptionFilter",           SetUnhandledExceptionFilter},
{-1, 704, "SetVDMCurrentDirectories",              SetVDMCurrentDirectories},
{-1, 705, "SetVolumeLabelA",                       SetVolumeLabelA},
{-1, 706, "SetVolumeLabelW",                       SetVolumeLabelW},
{-1, 707, "SetVolumeMountPointA",                  SetVolumeMountPointA},
{-1, 708, "SetVolumeMountPointW",                  SetVolumeMountPointW},
{-1, 709, "SetWaitableTimer",                      SetWaitableTimer},
{-1, 710, "SetupComm",                             SetupComm},
{-1, 711, "ShowConsoleCursor",                     ShowConsoleCursor},
{-1, 712, "SignalObjectAndWait",                   SignalObjectAndWait},
{ 0, 713, "SizeofResource",                        SizeofResource},
{ 0, 714, "Sleep",                                 Sleep},
{-1, 715, "SleepEx",                               SleepEx},
{ 0, 716, "SuspendThread",                         SuspendThread},
{-1, 717, "SwitchToFiber",                         SwitchToFiber},
{-1, 718, "SwitchToThread",                        SwitchToThread},
{ 0, 719, "SystemTimeToFileTime",                  SystemTimeToFileTime},
{-1, 720, "SystemTimeToTzSpecificLocalTime",       SystemTimeToTzSpecificLocalTime},
{-1, 721, "TerminateJobObject",                    TerminateJobObject},
{ 0, 722, "TerminateProcess",                      TerminateProcess},
{-1, 723, "TerminateThread",                       TerminateThread},
{-1, 724, "TermsrvAppInstallMode",                 TermsrvAppInstallMode},
{-1, 725, "Thread32First",                         Thread32First},
{-1, 726, "Thread32Next",                          Thread32Next},
{ 0, 727, "TlsAlloc",                              TlsAlloc},
{ 0, 728, "TlsFree",                               TlsFree},
{ 0, 729, "TlsGetValue",                           TlsGetValue},
{ 0, 730, "TlsSetValue",                           TlsSetValue},
{-1, 731, "Toolhelp32ReadProcessMemory",           Toolhelp32ReadProcessMemory},
{-1, 732, "TransactNamedPipe",                     TransactNamedPipe},
{-1, 733, "TransmitCommChar",                      TransmitCommChar},
{-1, 734, "TrimVirtualBuffer",                     TrimVirtualBuffer},
{ 0, 735, "TryEnterCriticalSection",               TryEnterCriticalSection},
{-1, 736, "UTRegister",                            UTRegister},
{-1, 737, "UTUnRegister",                          UTUnRegister},
{-1, 738, "UnhandledExceptionFilter",              UnhandledExceptionFilter},
{-1, 739, "UnlockFile",                            UnlockFile},
{-1, 740, "UnlockFileEx",                          UnlockFileEx},
{ 0, 741, "UnmapViewOfFile",                       UnmapViewOfFile},
{-1, 742, "UnregisterConsoleIME",                  UnregisterConsoleIME},
{-1, 743, "UnregisterWait",                        UnregisterWait},
{-1, 744, "UnregisterWaitEx",                      UnregisterWaitEx},
{-1, 745, "UpdateResourceA",                       UpdateResourceA},
{-1, 746, "UpdateResourceW",                       UpdateResourceW},
{-1, 747, "VDMConsoleOperation",                   VDMConsoleOperation},
{-1, 748, "VDMOperationStarted",                   VDMOperationStarted},
{-1, 749, "ValidateLCType",                        ValidateLCType},
{-1, 750, "ValidateLocale",                        ValidateLocale},
{ 0, 751, "VerLanguageNameA",                      VerLanguageNameA},
{ 0, 752, "VerLanguageNameW",                      VerLanguageNameW},
{-1, 753, "VerSetConditionMask",                   VerSetConditionMask},
{-1, 754, "VerifyConsoleIoHandle",                 VerifyConsoleIoHandle},
{-1, 755, "VerifyVersionInfoA",                    VerifyVersionInfoA},
{-1, 756, "VerifyVersionInfoW",                    VerifyVersionInfoW},
{ 0, 757, "VirtualAlloc",                          VirtualAlloc},
{-1, 758, "VirtualAllocEx",                        VirtualAllocEx},
{-1, 759, "VirtualBufferExceptionHandler",         VirtualBufferExceptionHandler},
{ 0, 760, "VirtualFree",                           VirtualFree},
{-1, 761, "VirtualFreeEx",                         VirtualFreeEx},
{ 0, 762, "VirtualLock",                           VirtualLock},
{ 0, 763, "VirtualProtect",                        VirtualProtect},
{-1, 764, "VirtualProtectEx",                      VirtualProtectEx},
{ 0, 765, "VirtualQuery",                          VirtualQuery},
{-1, 766, "VirtualQueryEx",                        VirtualQueryEx},
{ 0, 767, "VirtualUnlock",                         VirtualUnlock},
{-1, 768, "WaitCommEvent",                         WaitCommEvent},
{-1, 769, "WaitForDebugEvent",                     WaitForDebugEvent},
{ 0, 770, "WaitForMultipleObjects",                WaitForMultipleObjects},
{-1, 771, "WaitForMultipleObjectsEx",              WaitForMultipleObjectsEx},
{ 0, 772, "WaitForSingleObject",                   WaitForSingleObject},
{-1, 773, "WaitForSingleObjectEx",                 WaitForSingleObjectEx},
{-1, 774, "WaitNamedPipeA",                        WaitNamedPipeA},
{-1, 775, "WaitNamedPipeW",                        WaitNamedPipeW},
{ 0, 776, "WideCharToMultiByte",                   WideCharToMultiByte},
{-1, 777, "WinExec",                               WinExec},
{ 0, 778, "WriteConsoleA",                         WriteConsoleA},
{-1, 779, "WriteConsoleInputA",                    WriteConsoleInputA},
{-1, 780, "WriteConsoleInputVDMA",                 WriteConsoleInputVDMA},
{-1, 781, "WriteConsoleInputVDMW",                 WriteConsoleInputVDMW},
{-1, 782, "WriteConsoleInputW",                    WriteConsoleInputW},
{-1, 783, "WriteConsoleOutputA",                   WriteConsoleOutputA},
{-1, 784, "WriteConsoleOutputAttribute",           WriteConsoleOutputAttribute},
{-1, 785, "WriteConsoleOutputCharacterA",          WriteConsoleOutputCharacterA},
{-1, 786, "WriteConsoleOutputCharacterW",          WriteConsoleOutputCharacterW},
{-1, 787, "WriteConsoleOutputW",                   WriteConsoleOutputW},
{ 0, 788, "WriteConsoleW",                         WriteConsoleW},
{ 0, 789, "WriteFile",                             WriteFile},
{-1, 790, "WriteFileEx",                           WriteFileEx},
{-1, 791, "WriteFileGather",                       WriteFileGather},
{ 0, 792, "WritePrivateProfileSectionA",           WritePrivateProfileSectionA},
{ 0, 793, "WritePrivateProfileSectionW",           WritePrivateProfileSectionW},
{ 0, 794, "WritePrivateProfileStringA",            WritePrivateProfileStringA},
{ 0, 795, "WritePrivateProfileStringW",            WritePrivateProfileStringW},
{ 0, 796, "WritePrivateProfileStructA",            WritePrivateProfileStructA},
{ 0, 797, "WritePrivateProfileStructW",            WritePrivateProfileStructW},
{-1, 798, "WriteProcessMemory",                    WriteProcessMemory},
{ 0, 799, "WriteProfileSectionA",                  WriteProfileSectionA},
{ 0, 800, "WriteProfileSectionW",                  WriteProfileSectionW},
{ 0, 801, "WriteProfileStringA",                   WriteProfileStringA},
{ 0, 802, "WriteProfileStringW",                   WriteProfileStringW},
{-1, 803, "WriteTapemark",                         WriteTapemark},
{-1, 804, "_hread",                                _hread},
{-1, 805, "_hwrite",                               _hwrite},
{ 0, 806, "_lclose",                               _lclose},
{ 0, 807, "_lcreat",                               _lcreat},
{ 0, 808, "_llseek",                               _llseek},
{ 0, 809, "_lopen",                                _lopen},
{ 0, 810, "_lread",                                _lread},
{ 0, 811, "_lwrite",                               _lwrite},
{ 0, 812, "lstrcat",                               lstrcatA},
{ 0, 813, "lstrcatA",                              lstrcatA},
{ 0, 814, "lstrcatW",                              lstrcatW},
{ 0, 815, "lstrcmp",                               lstrcmpA},
{ 0, 816, "lstrcmpA",                              lstrcmpA},
{ 0, 817, "lstrcmpW",                              lstrcmpW},
{ 0, 818, "lstrcmpi",                              lstrcmpiA},
{ 0, 819, "lstrcmpiA",                             lstrcmpiA},
{ 0, 820, "lstrcmpiW",                             lstrcmpiW},
{ 0, 821, "lstrcpy",                               lstrcpyA},
{ 0, 822, "lstrcpyA",                              lstrcpyA},
{ 0, 823, "lstrcpyW",                              lstrcpyW},
{ 0, 824, "lstrcpyn",                              lstrcpynA},
{ 0, 825, "lstrcpynA",                             lstrcpynA},
{ 0, 826, "lstrcpynW",                             lstrcpynW},
{ 0, 827, "lstrlen",                               lstrlenA},
{ 0, 828, "lstrlenA",                              lstrlenA},
{ 0, 829, "lstrlenW",                              lstrlenW},
{-1,   0, NULL,                                    NULL}};
