/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "w32pen.h"


/******************************************************************************
*                                                                             *
******************************************************************************/
G_DEFINE_TYPE (W32LdrPen, w32ldr_pen, G_TYPE_OBJECT);


static void
w32ldr_pen_class_init (W32LdrPenClass *klass)
{
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
w32ldr_pen_init (W32LdrPen *w32pen)
{
  w32pen->color.pixel = 0;
  w32pen->color.red = 0;
  w32pen->color.green = 0;
  w32pen->color.blue = 0;
}


/******************************************************************************
*                                                                             *
* ja:ペン関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrPen *
w32ldr_pen_new (void)
{
  return W32LDR_PEN (g_object_new (W32LDR_TYPE_PEN, NULL));
}


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrPen *
w32ldr_pen_new_with_color (GdkColor *color)
{
  W32LdrPen *w32pen;

  w32pen = w32ldr_pen_new ();
  w32ldr_pen_set_color (w32pen, color);
  return w32pen;
}


/*  ja:ペンをコピーする
    w32pen,オブジェクト
       RET,オブジェクト                                                     */
W32LdrPen *
w32ldr_pen_copy (W32LdrPen *w32pen)
{
  return W32LDR_IS_PEN (w32pen)
                        ? w32ldr_pen_new_with_color (&w32pen->color) : NULL;
}


/*  ja:ペンの色を取得する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_get_color (W32LdrPen *w32pen,
                      GdkColor  *color)
{
  if (W32LDR_IS_PEN (w32pen) && color)
    *color = w32pen->color;
}


/*  ja:ペンの色を設定する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_set_color (W32LdrPen *w32pen,
                      GdkColor  *color)
{
  if (W32LDR_IS_PEN (w32pen) && color)
    w32pen->color = *color;
}
