/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __W32LDR_PEN_H__
#define __W32LDR_PEN_H__


#include "gcommon.h"


G_BEGIN_DECLS


#define W32LDR_TYPE_PEN            (w32ldr_pen_get_type ())
#define W32LDR_PEN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), W32LDR_TYPE_PEN, W32LdrPen))
#define W32LDR_PEN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), W32LDR_TYPE_PEN, W32LdrPenClass))
#define W32LDR_IS_PEN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), W32LDR_TYPE_PEN))
#define W32LDR_IS_PEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), W32LDR_TYPE_PEN))
#define W32LDR_PEN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), W32LDR_TYPE_PEN, W32LdrPenClass))


typedef struct _W32LdrPen      W32LdrPen;
typedef struct _W32LdrPenClass W32LdrPenClass;


struct _W32LdrPen
{
  /*< private >*/
  GObject  parent;
  GdkColor color;
};
struct _W32LdrPenClass
{
  GObjectClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_pen_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ペン関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrPen *
w32ldr_pen_new (void);


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrPen *
w32ldr_pen_new_with_color (GdkColor *color);


/*  ja:ペンをコピーする
    w32pen,オブジェクト
       RET,オブジェクト                                                     */
W32LdrPen *
w32ldr_pen_copy (W32LdrPen *w32pen);


/*  ja:ペンの色を取得する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_get_color (W32LdrPen *w32pen,
                      GdkColor  *color);


/*  ja:ペンの色を設定する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_set_color (W32LdrPen *w32pen,
                      GdkColor  *color);


G_END_DECLS


#endif /* __W32LDR_PEN_H__ */
