/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"
#include "commctrl.h"
#include "kernel32.h"


typedef struct _W32LdrStatusData
{
  W32LdrWindowData wd;
  gchar *text[256];
  GtkWidget *status[256];
} W32LdrStatusData;


static LRESULT WINAPI
w32stat_DefWindowProc (HWND   hWnd,
                       UINT   Msg,
                       WPARAM wParam,
                       LPARAM lParam)
{
  W32LdrWindowData *wd;
  W32LdrStatusData *sd;

  sd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!sd)
    return 0;
  wd = &sd->wd;
  switch (Msg)
    {
      case SB_SETTEXTA:
      case SB_SETTEXTW:
        {
          gint index;
          GtkWidget *status;

          index = LOBYTE (wParam);
          status = sd->status[index];
          if (status)
            {
              gchar *utf8str;
              guint context_id;

              utf8str = lParam ? Msg == SB_SETTEXTW
                            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam),
                                                        -1, NULL, NULL, NULL)
                            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam))
                            : NULL;
              context_id = gtk_statusbar_get_context_id
                                            (GTK_STATUSBAR (status), "Status");
              gtk_statusbar_pop (GTK_STATUSBAR (status), context_id);
              if (utf8str)
                gtk_statusbar_push (GTK_STATUSBAR (status), context_id,
                                                                    utf8str);
              g_free (sd->text[index]);
              sd->text[index] = utf8str;
              return TRUE;
            }
        }
        return FALSE;
      case SB_GETTEXTA:
      case SB_GETTEXTW:
        if (lParam)
          {
            gchar *utf8str;

            utf8str = sd->text[LOBYTE (wParam)];
            if (Msg == SB_SETTEXTW)
              {
                gunichar2 *wc;

                if (utf8str)
                  {
                    wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                    lstrcpyW (GINT_TO_POINTER (lParam), wc);
                    g_free (wc);
                    return lstrlenW (GINT_TO_POINTER (lParam));
                  }
                wc = GINT_TO_POINTER (lParam);
                *wc = '\0';
              }
            else
              {
                gchar *mb;

                if (utf8str)
                  {
                    mb = w32ldr_utf8_to_mb (utf8str);
                    g_strcpy (GINT_TO_POINTER (lParam), mb);
                    g_free (mb);
                    return g_strlen (GINT_TO_POINTER (lParam));
                  }
                mb = GINT_TO_POINTER (lParam);
                *mb = '\0';
              }
          }
        return 0;
      case SB_GETTEXTLENGTHA:
      case SB_GETTEXTLENGTHW:
        {
          gchar *utf8str;

          utf8str = sd->text[LOBYTE (wParam)];
          if (utf8str)
            {
              LRESULT lResult = 0;

              if (Msg == SB_SETTEXTW)
                {
                  gunichar2 *wc;

                  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                  lResult = lstrlenW (wc);
                  g_free (wc);
                }
              else
                {
                  gchar *mb;

                  mb = w32ldr_utf8_to_mb (utf8str);
                  lResult = g_strlen (mb);
                  g_free (mb);
                }
              return lResult;
            }
        }
        return 0;
      case SB_SETPARTS:
        if (0 < wParam && wParam <= 255)
          {
            gint i;

            for (i = 0; i < wParam; i++)
              if (!sd->status[i])
                {
                  sd->status[i] = gtk_statusbar_new ();
                  if (GTK_WIDGET_VISIBLE (sd->status[255]))
                    gtk_widget_hide (sd->status[i]);
                  else
                    gtk_widget_show (sd->status[i]);
                  gtk_box_pack_start (GTK_BOX (hWnd), sd->status[i],
                                                                TRUE, TRUE, 0);
                }
            for (i = 0; i < wParam - 1; i++)
              gtk_statusbar_set_has_resize_grip
                                        (GTK_STATUSBAR (sd->status[i]), FALSE);
            gtk_statusbar_set_has_resize_grip
                                    (GTK_STATUSBAR (sd->status[wParam - 1]),
                                                wd->dwStyle & SBARS_SIZEGRIP);
            for (i = wParam; i < 255; i++)
              {
                if (sd->text[i])
                  {
                    g_free (sd->text[i]);
                    sd->text[i] = NULL;
                  }
                if (sd->status[i])
                  {
                    gtk_container_remove (GTK_CONTAINER (hWnd), sd->status[i]);
                    sd->status[i] = NULL;
                  }
              }
            return TRUE;
          }
        return FALSE;
      case SB_GETPARTS:
        {
          gint parts;

          for (parts = 0; sd->status[parts]; parts++);
          if (lParam)
            {
              gint i;
              LPINT lpnParts;

              lpnParts = GINT_TO_POINTER (lParam);
              for (i = 0; i < MIN (parts - 1, wParam); i++)
                lpnParts[i] = (SPACING + 2) * i + 3;
              if (parts <= wParam)
                lpnParts[parts - 1] = -1;
            }
          return parts;
        }
        return 0;
      case SB_GETBORDERS:
        if (lParam)
          {
            LPINT lpnBorders;

            lpnBorders = GINT_TO_POINTER (lParam);
            lpnBorders[0] = 1;
            lpnBorders[1] = 1;
            lpnBorders[2] = SPACING;
            return TRUE;
          }
        return FALSE;
      case SB_SETMINHEIGHT:
        return 0;
      case SB_SIMPLE:
        {
          gint i;

          for (i = 0; i < 255 && sd->status[i]; i++)
            if (wParam)
              gtk_widget_hide (sd->status[i]);
            else
              gtk_widget_show (sd->status[i]);
          if (wParam)
            gtk_widget_show (sd->status[255]);
          else
            gtk_widget_hide (sd->status[255]);
        }
        return TRUE;
      case SB_GETRECT:
        if (wParam < 255 && lParam && sd->status[wParam])
          {
            LPRECT lprcPart;

            lprcPart = GINT_TO_POINTER (lParam);
            lprcPart->left = (SPACING + 2) * wParam + 1;
            lprcPart->top = 1;
            lprcPart->right = lprcPart->left + 1;
            lprcPart->bottom = lprcPart->top + 1;
            return TRUE;
          }
        return FALSE;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


/* ja:破棄 */
static void
w32stat_destroy (GtkWidget *widget,
                 gpointer   user_data)
{
  gint i;
  W32LdrStatusData *sd;

  sd = g_object_get_data (G_OBJECT (widget), "user_data");
  for (i = 0; i < 256; i++)
    {
      g_free (sd->text[i]);
      sd->text[i] = NULL;
    }
}


GtkWidget *
w32ldr_control_create_stat (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar)
{
  gint i;
  GtkWidget *hbox, *status0, *status1;
  W32LdrWindowData *wd;
  W32LdrStatusData *sd;
  W32LdrOverlapData *od;

  if (!hWndParent || !GTK_IS_WINDOW (hWndParent))
    return NULL;
  hbox = gtk_hbox_new (FALSE, SPACING);
  status0 = gtk_statusbar_new ();
  status1 = gtk_statusbar_new ();
  gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (status0),
                                                    style & SBARS_SIZEGRIP);
  gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (status1),
                                                    style & SBARS_SIZEGRIP);
  gtk_widget_show (status0);
  gtk_widget_hide (status1);
  gtk_box_pack_start (GTK_BOX (hbox), status0, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), status1, TRUE, TRUE, 0);
  g_signal_connect (G_OBJECT (hbox), "destroy",
                                        G_CALLBACK (w32stat_destroy), NULL);
  sd = g_malloc (sizeof (W32LdrStatusData));
  wd = &sd->wd;
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32stat_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = TRUE;
  wd->classname = g_strdup ("msctls_statusbar32");
  wd->focus = NULL;
  wd->child = NULL;
  g_memset (sd->text, 0, sizeof (gchar *) * 256);
  g_memset (sd->status, 0, sizeof (GtkWidget *) * 256);
  sd->status[0] = status0;
  sd->status[255] = status1;
  g_object_set_data (G_OBJECT (hbox), "user_data", wd);
  /* ja:子ウインドウとして登録 */
  od = g_object_get_data (G_OBJECT (hWndParent), "user_data");
  i = 0;
  if (od->wd.child)
    while (od->wd.child[i])
      i++;
  od->wd.child = g_realloc (od->wd.child, sizeof (GtkWidget *) * (i + 2));
  od->wd.child[i] = hbox;
  od->wd.child[i + 1] = NULL;
  /* ja:テーブルに配置する */
  gtk_table_attach (GTK_TABLE (od->table), hbox, 0, 2, 3, 4,
                                            GTK_EXPAND | GTK_FILL, 0, 0, 0);
  return hbox;
}
