/*
    avicore
    copyright (c) 2000-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Core                                                                    *
*                                                                             *
******************************************************************************/
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "avicore.h"
#include "chunk.h"
#include "other.h"


/*	AVIե
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
static void avi_get_file(AviEdit *avi_edit,gint pos)
{
	while (pos<avi_edit->offset && avi_edit->file->prev!=NULL) {
		avi_edit->file=avi_edit->file->prev;
		avi_edit->offset-=avi_edit->file->length;
	}
	while (avi_edit->offset+avi_edit->file->length<=pos
											&& avi_edit->file->next!=NULL) {
		avi_edit->offset+=avi_edit->file->length;
		avi_edit->file=avi_edit->file->next;
	}
}


/*	AVIեʬΥ
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
static void avi_split_file(AviEdit *avi_edit,gint pos)
{
	AviFile *avi_file;

	if (pos<0 || avi_edit->length<=pos)
		return;

	/* ֤ */
	avi_get_file(avi_edit,pos);/* AVIե */
	if (avi_edit->offset==pos)
		return;/* եڤܤ˰פ */

	/* ΥեʬΥ */
	avi_file=g_malloc(sizeof(AviFile));
	if (avi_edit->file->fd!=-1) {
		if ((avi_file->fd=open(avi_edit->file->name,O_RDONLY))==-1)
			avi_file->fd=dup(avi_edit->file->fd);
		else
			flock(avi_file->fd,LOCK_SH);
	} else {
		avi_file->fd=-1;
	}
	avi_file->data=avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL
		?g_memdup(avi_edit->file->data,bm_image_bytes(avi_edit->file->bmih))
																		:NULL;
	avi_file->name=g_strdup(avi_edit->file->name);
	avi_file->start=pos-avi_edit->offset+avi_edit->file->start;
	avi_file->length=avi_edit->file->length-(pos-avi_edit->offset);
	avi_file->entries=avi_edit->file->entries;
	avi_file->param=avi_edit->file->param;
	avi_file->index=g_memdup(avi_edit->file->index,
									avi_edit->file->entries*sizeof(AviIndex));
	avi_file->bmih=avi_edit->file->bmih!=NULL?g_memdup(avi_edit->file->bmih,
								bm_header_bytes(avi_edit->file->bmih)):NULL;
	avi_file->wfx=avi_edit->file->wfx!=NULL?g_memdup(avi_edit->file->wfx,
									wf_header_bytes(avi_edit->file->wfx)):NULL;
	/* Υեѹ */
	avi_edit->file->length-=avi_file->length;
	/* ꥹȤ */
	avi_file->prev=avi_edit->file;
	avi_file->next=avi_edit->file->next;
	avi_file->prev->next=avi_file;
	if (avi_file->next!=NULL)
		avi_file->next->prev=avi_file;
	avi_get_file(avi_edit,pos);
}


/******************************************************************************
*                                                                             *
* AVIե빽¤δؿ                                                       *
*                                                                             *
******************************************************************************/
/*	AVIAVIե빽¤Τ
	 file,ե̾
	param,ȥ꡼ֹ
	 type,streamtypeAUDIO/streamtypeVIDEO
	 rate,졼
	scale,
	  RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_avi(gchar *file,gint param,
									guint32 *type,guint32 *rate,guint32 *scale)
{
	gint i;
	guint32 size;
	off_t offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	AviIndexEntry avi_index;
	AviStreamHeader *ash;
	Chunk *ck;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եबhdrlLIST󥯤õ */
	while (chunk_form(avi_file->fd)!=make4cc('h','d','r','l'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եबstrlLIST󥯤õ */
	for (i=0;i<=param;i++)
		do
			if (!chunk_next(avi_file->fd,ck)) {
				chunk_free(ck);
				close(avi_file->fd);
				g_free(avi_file);
				return NULL;
			}
		while (chunk_form(avi_file->fd)!=make4cc('s','t','r','l'));
	/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* strh󥯤õ(AviStreamHeader) */
	while (chunk_id(avi_file->fd)!=make4cc('s','t','r','h'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	/* strh󥯤Υ(AviStreamHeader) */
	if ((size=chunk_size(avi_file->fd))==-1 || size<ASH_SIZE) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	ash=g_malloc(ASH_SIZE);
	/* strh󥯤(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strh) */
	if (!chunk_in(avi_file->fd,ck)
		/* AviStreamHeaderɤ߹ */
				|| read(avi_file->fd,ash,ASH_SIZE)!=ASH_SIZE
		/*  */
				|| (ash_get_type(ash)!=streamtypeAUDIO
										&& ash_get_type(ash)!=streamtypeVIDEO)
		/* strh󥯤Ф(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
				|| !chunk_out(avi_file->fd,ck)
		/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
				|| !chunk_out(avi_file->fd,ck)
		/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
				|| !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file);
		return NULL;
	}
	/* strf󥯤õ(BitmapInfoHeader)|(WaveFormatEx) */
	while (chunk_id(avi_file->fd)!=make4cc('s','t','r','f'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
	/* strf󥯤Υ(BitmapInfoHeader)|(WaveFormatEx) */
	if ((size=chunk_size(avi_file->fd))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file);
		return NULL;
	}
	if (ash_get_type(ash)==streamtypeVIDEO) {
		if (size<BMIH_SIZE) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
		avi_file->bmih=g_malloc(size);
		avi_file->wfx=NULL;
	} else {
		if (size<WFX_SIZE-sizeof(guint16)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file);
			return NULL;
		}
		avi_file->wfx=g_malloc(MAX(size,WFX_SIZE));
		wfx_set_size(avi_file->wfx,0);
		avi_file->bmih=NULL;
	}
	/* strf󥯤(BitmapInfoHeader)|(WaveFormatEx)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strf) */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* BitmapInfoHeader|WaveFormatExɤ߹ */
	if (read(avi_file->fd,ash_get_type(ash)==streamtypeVIDEO
			?(gpointer)avi_file->bmih:(gpointer)avi_file->wfx,size)!=size) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* ࡼӡ󥯤ذư */

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* movi󥯤õ */
	while (chunk_form(avi_file->fd)!=make4cc('m','o','v','i'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* եΥեåȤ */
	if ((offset=lseek(avi_file->fd,0,SEEK_CUR))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	offset+=sizeof(guint32)+sizeof(guint32);/* moviΥեå */
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* ǥå󥯤ذư */

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* idx1󥯤õ */
	while (chunk_id(avi_file->fd)!=make4cc('i','d','x','1'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* idx1󥯤Υ */
	/* idx1󥯤(RIFF'AVI ' -> idx1) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(ash);
		g_free(avi_file->bmih);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* ǥåɤ߹ */
	avi_file->entries=0;
	avi_file->index=NULL;
	for (i=0;i<size/AIE_SIZE;i++) {
		if (read(avi_file->fd,&avi_index,AIE_SIZE)!=AIE_SIZE) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(ash);
			g_free(avi_file->bmih);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
		if (((aie_get_ckid(&avi_index)&0xff)-'0')*10
							+((aie_get_ckid(&avi_index)>>8)&0xff)-'0'==param) {
			avi_file->index=g_realloc(avi_file->index,
											(avi_file->entries+1)*AIE_SIZE);
			avi_file->index[avi_file->entries].offset
								=aie_get_offset(&avi_index)
									+offset+sizeof(guint32)+sizeof(guint32);
			avi_file->index[avi_file->entries].size=aie_get_length(&avi_index);
			avi_file->index[avi_file->entries].flags=aie_get_flags(&avi_index);
			avi_file->entries++;
		}
	}
	/* ǥåȥإå */
	if (ash_get_type(ash)==streamtypeVIDEO) {
		avi_file->length=avi_file->entries;
	} else {
		avi_file->length=0;
		for (i=0;i<avi_file->entries;i++)
			avi_file->length+=avi_file->index[i].size
										/wfx_get_block_align(avi_file->wfx);
	}
	/*  */
	if (type!=NULL)
		*type=ash_get_type(ash);
	if (rate!=NULL)
		*rate=ash_get_rate(ash);
	if (scale!=NULL)
		*scale=ash_get_scale(ash);
	g_free(ash);
	/* ե */
	avi_file->data=NULL;				/*  */
	return avi_file;
}


/*	ӥåȥޥåפAVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_bitmap(gchar *file)
{
	guint32 size;
	AviFile *avi_file;
	BitmapInfoHeader *bmih0,*bmih1;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* ˥إåɤ߹ */
	if (lseek(avi_file->fd,BMFH_SIZE,SEEK_SET)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	avi_file->bmih=g_malloc(BMIH_SIZE);
	if (read(avi_file->fd,avi_file->bmih,BMIH_SIZE)!=BMIH_SIZE) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* إåΥ׻ */
	size=bm_header_bytes(avi_file->bmih);
	/* إåɤ߹ */
	avi_file->bmih=g_realloc(avi_file->bmih,size);
	if (lseek(avi_file->fd,BMFH_SIZE,SEEK_SET)==-1
							|| read(avi_file->fd,avi_file->bmih,size)!=size) {
		close(avi_file->fd);
		g_free(avi_file->bmih);
		g_free(avi_file);
		return NULL;
	}
	/* ᡼ɤ߹ */
	if (bmih_get_compression(avi_file->bmih)==BI_RGB
					|| bmih_get_compression(avi_file->bmih)==BI_BITFIELDS) {
		/* ̵ */
		size=bm_image_bytes(avi_file->bmih);
		avi_file->data=g_malloc(size);
		if (read(avi_file->fd,avi_file->data,size)!=size) {
			close(avi_file->fd);
			g_free(avi_file->bmih);
			g_free(avi_file->data);
			g_free(avi_file);
			return NULL;
		}
	} else if (bmih_get_compression(avi_file->bmih)==BI_RLE4
							|| bmih_get_compression(avi_file->bmih)==BI_RLE8) {
		/*  */
		bmih0=g_malloc(size+bmih_get_size_image(avi_file->bmih));
		memcpy(bmih0,avi_file->bmih,size);
		if (read(avi_file->fd,(guint8 *)bmih0+size,bmih_get_size_image(bmih0))
												!=bmih_get_size_image(bmih0)) {
			g_free(bmih0);
			close(avi_file->fd);
			g_free(avi_file->bmih);
			g_free(avi_file);
			return NULL;
		}
		bmih1=g_malloc(bx_all_bytes(
				bmih_get_width(bmih0),bmih_get_height(bmih0),
				bmih_get_bit_count(bmih0),BI_RGB,bmih_get_color_used(bmih0)));
		bitmap_expand(bmih0,bmih1);
		g_free(bmih0);
		/* ŸDIB򥳥ԡ */
		size=bm_header_bytes(bmih1);
		avi_file->bmih=g_realloc(avi_file->bmih,size);
		memcpy(avi_file->bmih,bmih1,size);
		avi_file->data=g_memdup((guint8 *)bmih1+size,
											bm_image_bytes(avi_file->bmih));
		g_free(bmih1);
	} else {
		close(avi_file->fd);
		g_free(avi_file->bmih);
		g_free(avi_file->data);
		g_free(avi_file);
		return NULL;
	}
	if (close(avi_file->fd)!=0) {
		g_free(avi_file->bmih);
		g_free(avi_file->data);
		g_free(avi_file);
		return NULL;
	}
	/* ե */
	avi_file->fd=-1;					/* եǥ꥿ */
	avi_file->length=1;
	avi_file->entries=1;				/* ǥåο */
	/* ǥͭ */
	avi_file->wfx=NULL;					/* ꥸʥΥեޥå */
	/* ǥå */
	avi_file->index=g_malloc(sizeof(AviIndex));
	avi_file->index[0].offset=0;
	avi_file->index[0].size=size;
	avi_file->index[0].flags=0;
	return avi_file;
}


/*	WAVEե뤫AVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_wave(gchar *file)
{
	guint32 size;
	off_t offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	Chunk *ck;

	avi_file=g_malloc(sizeof(AviFile));
	/* ե򳫤 */
	if ((avi_file->fd=open(file,O_RDONLY))==-1) {
		g_free(avi_file);
		return NULL;
	}
	if (flock(avi_file->fd,LOCK_SH)==-1) {
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	/* fmt󥯤õ */
	while (chunk_id(avi_file->fd)!=make4cc('f','m','t',' ')) {
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file);
			return NULL;
		}
	}
	/* fmt󥯤Υ */
	/* fmt󥯤(RIFF'AVI ' -> fmt) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	if (size<WFX_SIZE-sizeof(guint16)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file);
		return NULL;
	}
	avi_file->wfx=g_malloc(MAX(size,WFX_SIZE));
	wfx_set_size(avi_file->wfx,0);
	/* WaveFormatExɤ߹ */
	if (read(avi_file->fd,avi_file->wfx,size)!=size) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(avi_file->fd);
	/* RIFF󥯤 */
	if (!chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* data󥯤õ */
	while (chunk_id(avi_file->fd)!=make4cc('d','a','t','a'))
		if (!chunk_next(avi_file->fd,ck)) {
			chunk_free(ck);
			close(avi_file->fd);
			g_free(avi_file->wfx);
			g_free(avi_file);
			return NULL;
		}
	/* data󥯤Υ */
	/* data󥯤(RIFF'AVI ' -> data) */
	if ((size=chunk_size(avi_file->fd))==-1 || !chunk_in(avi_file->fd,ck)) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* եΥեåȤ */
	if ((offset=lseek(avi_file->fd,0,SEEK_CUR))==-1) {
		chunk_free(ck);
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}
	/* 󥯥ݥ󥿤 */
	if (!chunk_free(ck)) {
		close(avi_file->fd);
		g_free(avi_file->wfx);
		g_free(avi_file);
		return NULL;
	}

	/* ե */
	avi_file->data=NULL;				/*  */
	avi_file->length=size/wfx_get_block_align(avi_file->wfx);
	avi_file->entries=1;				/* ǥåο */
	/* ӥǥͭ */
	avi_file->bmih=NULL;				/* ꥸʥΥեޥå */
	/* ǥå */
	avi_file->index=g_malloc(sizeof(AviIndex));
	avi_file->index[0].offset=offset;
	avi_file->index[0].size=size;
	avi_file->index[0].flags=0;
	return avi_file;
}


/*	AVIAVIե빽¤Τ
	 file,ե̾
	param,ȥ꡼ֹ
	 type,streamtypeAUDIO/streamtypeVIDEO
	 rate,졼
	scale,
	  RET,AVIե빽¤,NULL:顼										*/
static AviFile *avi_open_file(gchar *file,gint param,
									guint32 *type,guint32 *rate,guint32 *scale)
{
	AviFile *avi_file=NULL;

	/* եηʬ */
	switch (avi_file_type(file)) {
		case 0:/* AVI */
			avi_file=avi_open_avi(file,param,type,rate,scale);
			break;
		case 1:/* ӥåȥޥå */
			avi_file=param==0?avi_open_bitmap(file):NULL;
			if (avi_file!=NULL) {
				if (type!=NULL)
					*type=streamtypeVIDEO;
				if (rate!=NULL)
					*rate=15;
				if (scale!=NULL)
					*scale=1;
			}
			break;
		case 2:/* WAVEե */
			avi_file=param==0?avi_open_wave(file):NULL;
			if (avi_file!=NULL) {
				if (type!=NULL)
					*type=streamtypeAUDIO;
				if (rate!=NULL)
					*rate=wfx_get_average_bytes_per_sec(avi_file->wfx);
				if (scale!=NULL)
					*scale=wfx_get_block_align(avi_file->wfx);
			}
	}
	if (avi_file!=NULL) {
		avi_file->name=get_full_path(file);	/* ե̾ */
		avi_file->start=0;					/* ͭϰ */
		avi_file->param=param;				/* ȥ꡼ֹ */
		/* ꥹ */
		avi_file->prev=NULL;
		avi_file->next=NULL;
	}
	return avi_file;
}


/*	AVIե빽¤Τ
	avi_file,AVIե빽¤
	     RET,TRUE:ｪλ,FALSE:顼										*/
static gboolean avi_release_file(AviFile *avi_file)
{
	gboolean result;

	result=avi_file->fd==-1 || close(avi_file->fd)==0;
	g_free(avi_file->name);
	g_free(avi_file->index);
	g_free(avi_file->bmih);
	g_free(avi_file->wfx);
	g_free(avi_file);
	return result;
}


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVI															*/
void avi_file_init(void)
{
}


/*	AVIλ															*/
void avi_file_exit(void)
{
}


/******************************************************************************
*                                                                             *
* AVIϴؿ()                                                         *
*                                                                             *
******************************************************************************/
/*	եȽ̤
	file,ե̾
	 RET,0:AVI,1:ӥåȥޥå,2:WAVEե,3:ʥꥪ֥,-1:	*/
gint avi_file_type(gchar *file)
{
	int fd;
	guint8 buffer[12];			/* եȽѤΥХåե */

	/* ե򳫤 */
	if ((fd=open(file,O_RDONLY))==-1)
		return -1;
	if (flock(fd,LOCK_SH)==-1
					|| read(fd,buffer,sizeof(guint8)*12)!=sizeof(guint8)*12) {
		close(fd);
		return -1;
	}
	/* إåʬɤ߹ */
	if (close(fd)!=0)
		return -1;
	/* եηʬ */
	if (buffer[0]=='R' && buffer[1]=='I' && buffer[2]=='F' && buffer[3]=='F'
										&& buffer[8]=='A' && buffer[9]=='V'
										&& buffer[10]=='I' && buffer[11]==' ')
		return 0;/* AVI */
	else if (buffer[0]=='B' && buffer[1]=='M')
		return 1;/* ӥåȥޥå */
	else if (buffer[0]=='R' && buffer[1]=='I'
										&& buffer[2]=='F' && buffer[3]=='F'
										&& buffer[8]=='W' && buffer[9]=='A'
										&& buffer[10]=='V' && buffer[11]=='E')
		return 2;/* WAVEե */
	else if (buffer[0]=='#' && buffer[1]=='V' && buffer[2]=='M'
										&& buffer[3]=='A' && buffer[4]=='I'
										&& buffer[5]=='D' && buffer[6]=='\n')
		return 3;/* ʥꥪ֥ */
	return -1;
}


/*	AVIΥȥ꡼ο
	file,ե̾
	 RET,ȥ꡼ο,0:顼											*/
guint32 avi_main_streams(gchar *file)
{
	int fd;
	guint8 buffer[12];			/* եȽѤΥХåե */
	AviMainHeader amh;
	Chunk *ck;

	/* ե򳫤 */
	if ((fd=open(file,O_RDONLY))==-1)
		return 0;
	/* إåʬɤ߹ */
	if (flock(fd,LOCK_SH)==-1
					|| read(fd,buffer,sizeof(guint8)*12)!=sizeof(guint8)*12) {
		close(fd);
		return 0;
	}
	if (buffer[0]!='R' || buffer[1]!='I' || buffer[2]!='F' || buffer[3]!='F'
									|| buffer[8]!='A' || buffer[9]!='V'
									|| buffer[10]!='I' || buffer[11]!=' ') {
		close(fd);
		return 0;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(fd);
	/* RIFF󥯤 */
	if (!chunk_in(fd,ck)) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* եबhdrlLIST󥯤õ */
	while (chunk_form(fd)!=make4cc('h','d','r','l'))
		if (!chunk_next(fd,ck)) {
			chunk_free(ck);
			close(fd);
			return 0;
		}
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (!chunk_in(fd,ck)) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* avih󥯤õ(AviMainHeader) */
	while (chunk_id(fd)!=make4cc('a','v','i','h'))
		if (!chunk_next(fd,ck)) {
			chunk_free(ck);
			close(fd);
			return 0;
		}
	/* avih󥯤Υ(AviMainHeader) */
	/* avih󥯤(AviMainHeader) (RIFF'AVI ' -> LIST'hdrl' -> avih) */
	/* AviMainHeaderɤ߹ */
	if (chunk_size(fd)!=AMH_SIZE || !chunk_in(fd,ck)
										|| read(fd,&amh,AMH_SIZE)!=AMH_SIZE) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* 󥯥ݥ󥿤 */
	return chunk_free(ck) & (close(fd)==0)?amh_get_streams(&amh):0;
}


/*	AVIե뤫鳫
	 file,ե̾
	param,ȥ꡼ֹ
	  RET,AVIԽϥɥ,NULL:顼										*/
AviEdit *avi_open(gchar *file,gint param)
{
	AviEdit *avi_edit;

	/*  */
	avi_edit=g_malloc(sizeof(AviEdit));
	avi_edit->offset=0;
	avi_edit->buf=NULL;
	avi_edit->pos=-1;					/* Ǹ˼ե졼 */

	if ((avi_edit->file=avi_open_file(file,param,&avi_edit->type,
									&avi_edit->rate,&avi_edit->scale))==NULL) {
		g_free(avi_edit);
		return NULL;
	}
	/* ŸΥեޥå */
	if (avi_edit->type==streamtypeVIDEO) {
		if (bmih_get_compression(avi_edit->file->bmih)
													==make4cc('D','I','B',' ')
				|| bmih_get_compression(avi_edit->file->bmih)==BI_RGB
				|| bmih_get_compression(avi_edit->file->bmih)==BI_BITFIELDS) {
			avi_edit->bmih=g_memdup(avi_edit->file->bmih,
										bm_header_bytes(avi_edit->file->bmih));
			if (bmih_get_compression(avi_edit->bmih)==make4cc('D','I','B',' '))
				bmih_set_compression(avi_edit->bmih,BI_RGB);
		} else {
			/*  */
			avi_release_file(avi_edit->file);
			g_free(avi_edit);
			return NULL;
		}
		/* ǥͭ */
		avi_edit->wfx=NULL;				/* ŸΥեޥå */
	} else {
		if (wfx_get_format_tag(avi_edit->file->wfx)==WAVE_FORMAT_PCM) {
			avi_edit->wfx=g_memdup(avi_edit->file->wfx,
										wf_header_bytes(avi_edit->file->wfx));
		} else {
			/*  */
			avi_release_file(avi_edit->file);
			g_free(avi_edit);
			return NULL;
		}
		/* ӥǥͭ */
		avi_edit->bmih=NULL;			/* ŸΥեޥå */
	}
	/*  */
	avi_edit->length=avi_edit->file->length;
	return avi_edit;
}


/*	AVIĤ
	avi_edit,AVIԽϥɥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_release(AviEdit *avi_edit)
{
	AviFile *avi_file;

	while (avi_edit->file!=NULL) {
		avi_file=avi_edit->file->next;
		avi_release_file(avi_edit->file);
		avi_edit->file=avi_file;
	}
	g_free(avi_edit->bmih);
	g_free(avi_edit->wfx);
	g_free(avi_edit->buf);
	g_free(avi_edit);
	return TRUE;
}


/*	AVIΥǡΥХȿ
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	     RET,Хȿ														*/
gint avi_sample_size(AviEdit *avi_edit,gint start,gint samples)
{
	gint i,length;

	/* Ȱ֤ȥץĴ */
	if (start<0)
		return 0;
	if (samples>avi_edit->length-start)
		samples=avi_edit->length-start;
	if (samples<=0)
		return 0;
	switch (avi_edit->type) {
		case streamtypeVIDEO:/* ӥǥ */
			avi_get_file(avi_edit,start);/* AVIե */
			length=0;
			for (i=start;i<start+samples;i++) {
				if (i-avi_edit->offset>=avi_edit->file->length) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
				}
				length+=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].size;
			}
			return length;
		case streamtypeAUDIO:/* ǥ */
			return wfx_get_block_align(avi_edit->wfx)*samples;
	}
	return 0;
}


/*	AVIΥǡɤ߹
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	  buffer,ǡǼХåե
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read(AviEdit *avi_edit,gint start,gint samples,gpointer buffer)
{
	gint i,dif,length;
	guint32 size;
	off_t offset;

	/* Ȱ֤ȥץĴ */
	if (samples<=0 || start<0 || avi_edit->length<start+samples)
		return FALSE;
	avi_get_file(avi_edit,start);/* AVIե */
	switch (avi_edit->type) {
		case streamtypeVIDEO:/* ӥǥ */
			for (i=start;i<start+samples;i++) {
				if (i-avi_edit->offset>=avi_edit->file->length) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
				}
				offset=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].offset;
				size=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].size;
				if (avi_edit->file->data==NULL) {
					/* ե */
					if (lseek(avi_edit->file->fd,offset,SEEK_SET)==-1
								|| read(avi_edit->file->fd,buffer,size)!=size)
						return FALSE;
				} else {
					/*  */
					memcpy(buffer,(guint8 *)avi_edit->file->data+offset,size);
				}
				(guint8 *)buffer+=size;
			}
			return TRUE;
		case streamtypeAUDIO:/* ǥ */
			length=start-avi_edit->offset+avi_edit->file->start;
			dif=0;
			for (i=0;dif<=length;i++)
				dif+=avi_edit->file->index[i].size
										/wfx_get_block_align(avi_edit->wfx);
			dif-=avi_edit->file->index[--i].size
										/wfx_get_block_align(avi_edit->wfx);
			dif=length-dif;
			while (samples>0) {
				if (avi_edit->offset+avi_edit->file->length<=start) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
					dif=0;
					for (i=0;dif<=avi_edit->file->start;i++)
						dif+=avi_edit->file->index[i].size
										/wfx_get_block_align(avi_edit->wfx);
					dif-=avi_edit->file->index[--i].size
										/wfx_get_block_align(avi_edit->wfx);
					dif=length-dif;
				}
				offset=(off_t)dif*wfx_get_block_align(avi_edit->wfx);
				size=MIN(wfx_get_block_align(avi_edit->wfx)*samples,
										avi_edit->file->index[i].size-offset);
				offset+=avi_edit->file->index[i].offset;
				if (avi_edit->file->data==NULL) {
					/* ե */
					if (lseek(avi_edit->file->fd,offset,SEEK_SET)==-1
								|| read(avi_edit->file->fd,buffer,size)!=size)
						return FALSE;
				} else {
					/*  */
					memcpy(buffer,(guint8 *)avi_edit->file->data+offset,size);
				}
				(guint8 *)buffer+=size;
				start+=size/wfx_get_block_align(avi_edit->wfx);
				samples-=size/wfx_get_block_align(avi_edit->wfx);
				dif=0;
				i++;
			}
			return TRUE;
	}
	return FALSE;
}


/*	AVIΥեޥåȤΥ
	avi_edit,AVIԽϥɥ
	     RET,եޥåȤΥХȿ,0:顼								*/
gint avi_format_size(AviEdit *avi_edit)
{
	switch (avi_edit->type) {
		case streamtypeVIDEO:/* ӥǥ */
			return bm_header_bytes(avi_edit->bmih);
		case streamtypeAUDIO:/* ǥ */
			return wf_header_bytes(avi_edit->wfx);
	}
	return 0;
}


/*	AVIΥեޥåȤɤ߹
	avi_edit,AVIԽϥɥ
	  format,ХåեؤΥݥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read_format(AviEdit *avi_edit,gpointer format)
{
	switch (avi_edit->type) {
		case streamtypeVIDEO:/* ӥǥ */
			memcpy(format,avi_edit->bmih,bm_header_bytes(avi_edit->bmih));
			return TRUE;
		case streamtypeAUDIO:/* ǥ */
			memcpy(format,avi_edit->wfx,wf_header_bytes(avi_edit->wfx));
			return TRUE;
	}
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ե졼ؿ(ߤ)                                                        *
*                                                                             *
******************************************************************************/
/*	DIBŸ줿ե졼
	 avi_edit,AVIԽϥɥ
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	      RET,ѥåDIBؤΥݥ,NULL:顼								*/
BitmapInfoHeader *avi_get_frame(AviEdit *avi_edit,gint pos,
														gint width,gint height)
{
	gint i,size;
	BitmapInfoHeader *bmih0,*bmih1;

	if (avi_edit->type!=streamtypeVIDEO)
		return NULL;
	if (avi_edit->pos==pos && bmih_get_width(avi_edit->buf)==width
									&& bmih_get_height(avi_edit->buf)==height)
		return avi_edit->buf;		/* ƱȤ */
	if (pos<0 || avi_edit->length<=pos)
		return NULL;				/* ϰϳ */
	avi_get_file(avi_edit,pos);		/* AVIե */
	if (bmih_get_compression(avi_edit->file->bmih)==make4cc('D','I','B',' ')
				|| bmih_get_compression(avi_edit->file->bmih)==BI_RGB
				|| bmih_get_compression(avi_edit->file->bmih)==BI_BITFIELDS) {
		/* ̥ե졼Υå */
		for (i=pos-avi_edit->offset+avi_edit->file->start;i>0;i--)
			if (avi_edit->file->index[i].size>0)
				break;
		/* ᡼ΥǡΥȤ顼 */
		if (bm_image_bytes(avi_edit->file->bmih)>avi_edit->file->index[i].size)
			return NULL;
		size=bm_header_bytes(avi_edit->file->bmih);
		bmih0=g_malloc(size+avi_edit->file->index[i].size);
		/* إå */
		memcpy(bmih0,avi_edit->file->bmih,size);
		/* ᡼ */
		if (avi_edit->file->data==NULL) {
			/* ե */
			lseek(avi_edit->file->fd,avi_edit->file->index[i].offset,SEEK_SET);
			read(avi_edit->file->fd,(guint8 *)bmih0+size,
												avi_edit->file->index[i].size);
		} else {
			/*  */
			memcpy((guint8 *)bmih0+size,
				(guint8 *)avi_edit->file->data+avi_edit->file->index[i].offset,
												avi_edit->file->index[i].size);
		}
	} else {
		/* ̤ƤȤ顼 */
		return NULL;
	}
	/* 32ӥåȤѴ */
	if (bmih_get_bit_count(bmih0)!=32) {
		bmih1=g_malloc(bx_all_bytes(bmih_get_width(bmih0),
										bmih_get_height(bmih0),32,BI_RGB,0));
		bitmap_convert_32(bmih0,bmih1);
		g_free(bmih0);
		bmih0=bmih1;
	}
	/* Ѵ */
	if (bmih_get_width(bmih0)!=width || bmih_get_height(bmih0)!=height) {
		bmih1=g_malloc(bx_all_bytes(width,height,32,BI_RGB,0));
		bmih_set_width(bmih1,width);
		bmih_set_height(bmih1,height);
		bitmap_zoom_32(bmih0,bmih1);
		g_free(bmih0);
		bmih0=bmih1;
	}
	g_free(avi_edit->buf);
	avi_edit->pos=pos;
	avi_edit->buf=bmih0;
	return bmih0;
}


/*	ե졼बե졼फȽꤹ
	avi_edit,AVIԽϥɥ
	     pos,ե졼(ץֹ)
	     RET,TRUE:ե졼,FALSE:󥭡ե졼							*/
gboolean avi_is_keyframe(AviEdit *avi_edit,gint pos)
{
	if (avi_edit->type==streamtypeVIDEO) {
		/* ӥǥ */
		avi_get_file(avi_edit,pos);/* AVIե */
		return (avi_edit->file->index[pos-avi_edit->offset].flags
														&AVIIF_KEYFRAME)!=0;
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* Խؿ(줿)                                                            *
*                                                                             *
******************************************************************************/
/*	AVI
	avi_edit,AVIԽϥɥ
	   start,Ϥ륵ץֹ
	 samples,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_delete(AviEdit *avi_edit,gint start,gint samples)
{
	AviFile *p,*q,*r;

	/* Ȱ֤ȥץĴ */
	if (start<0)
		return FALSE;
	if (samples>avi_edit->length-start)
		samples=avi_edit->length-start;
	if (samples<=0 || avi_edit->length<=samples)
		return FALSE;
	/* å */
	if (start<=avi_edit->pos && avi_edit->pos<start+samples) {
		g_free(avi_edit->buf);
		avi_edit->buf=NULL;
		avi_edit->pos=-1;
	} else if (start+samples<=avi_edit->pos) {
		avi_edit->pos-=samples;
	}

	avi_split_file(avi_edit,start);/* AVIեʬ䤹 */
	p=avi_edit->file;
	if (start+samples<avi_edit->length) {
		/* ֤ʬ䤹 */
		avi_split_file(avi_edit,start+samples);
		q=avi_edit->file;
	} else {
		/* ޤǺ */
		q=NULL;
	}
	/* ֤˰ư */
	while (start-1<avi_edit->offset && avi_edit->file->prev!=NULL) {
		avi_edit->file=avi_edit->file->prev;
		avi_edit->offset-=avi_edit->file->length;
	}
	while (p!=q) {
		if (avi_edit->file==p)
			avi_edit->file=avi_edit->file->next;
		if (p->prev!=NULL)
			p->prev->next=p->next;
		if (p->next!=NULL)
			p->next->prev=p->prev;
		r=p->next;
		avi_release_file(p);
		p=r;
	}
	/* ץ򸺤餹 */
	avi_edit->length-=samples;
	return TRUE;
}


/*	AVI򥳥ԡ
	avi_edit,AVIԽϥɥ
	   start,ԡϤ륵ץֹ
	 samples,ץ
	     RET,AVIԽϥɥ,NULL:顼									*/
AviEdit *avi_copy(AviEdit *avi_edit,gint start,gint samples)
{
	AviEdit *avi_copy;
	AviFile *avi_file;

	/* Ȱ֤ȥץĴ */
	if (start<0)
		return NULL;
	if (samples>avi_edit->length-start)
		samples=avi_edit->length-start;
	if (samples<=0 || avi_edit->length<samples)
		return NULL;

	avi_get_file(avi_edit,start);/* AVIե */

	/*  */
	avi_copy=g_malloc(sizeof(AviEdit));
	avi_copy->offset=0;
	avi_copy->type=avi_edit->type;	/* streamtypeAUDIO/streamtypeVIDEO */
	avi_copy->length=0;				/* ץ */
	avi_copy->rate=avi_edit->rate;
	avi_copy->scale=avi_edit->scale;	/* ratescale=1ô֤Υե졼 */
	avi_copy->buf=NULL;
	avi_copy->file=NULL;
	/* ӥǥͭ */						/* ŸΥեޥå */
	avi_copy->bmih=avi_edit->bmih!=NULL?g_memdup(avi_edit->bmih,
										bm_header_bytes(avi_edit->bmih)):NULL;
	avi_copy->pos=-1;						/* Ǹ˼ե졼 */
	/* ǥͭ */					/* ŸΥեޥå */
	avi_copy->wfx=avi_edit->wfx!=NULL?g_memdup(avi_edit->wfx,
										wf_header_bytes(avi_edit->wfx)):NULL;

	while (samples>0) {
		/* ԡ */
		avi_file=g_malloc(sizeof(AviFile));

		if (avi_edit->file->fd!=-1) {
			if ((avi_file->fd=open(avi_edit->file->name,O_RDONLY))==-1)
				avi_file->fd=dup(avi_edit->file->fd);
			else
				flock(avi_file->fd,LOCK_SH);
		} else {
			avi_file->fd=-1;
		}
		avi_file->data=avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL
									?g_memdup(avi_edit->file->data,
									bm_image_bytes(avi_edit->file->bmih)):NULL;
		avi_file->name=g_strdup(avi_edit->file->name);
		avi_file->start=start-avi_edit->offset+avi_edit->file->start;
		avi_file->length
				=MIN(avi_edit->file->length-(start-avi_edit->offset),samples);
		avi_file->entries=avi_edit->file->entries;
		avi_file->param=avi_edit->file->param;
		avi_file->index=g_memdup(avi_edit->file->index,
									avi_edit->file->entries*sizeof(AviIndex));
		avi_file->bmih=avi_edit->file->bmih!=NULL
												?g_memdup(avi_edit->file->bmih,
								bm_header_bytes(avi_edit->file->bmih)):NULL;
		avi_file->wfx=avi_edit->file->wfx!=NULL?g_memdup(avi_edit->file->wfx,
									wf_header_bytes(avi_edit->file->wfx)):NULL;
		/* ꥹȤ */
		avi_copy->length+=avi_file->length;
		avi_file->prev=avi_copy->file;
		avi_file->next=NULL;
		if (avi_copy->file!=NULL) {
			avi_copy->file->next=avi_file;
			avi_copy->offset+=avi_copy->file->length;
		}
		avi_copy->file=avi_file;
		/*  */
		if (avi_edit->file->next!=NULL) {
			avi_edit->offset+=avi_edit->file->length;
			avi_edit->file=avi_edit->file->next;
		}
		start+=avi_file->length;
		samples-=avi_file->length;
	}
	return avi_copy;
}


/*	AVIŽդ
	avi_dst,ŽդAVIԽϥɥ
	    pos,Žդ륵ץֹ
	avi_src,ŽդAVIԽϥɥ
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_paste(AviEdit *avi_dst,gint pos,AviEdit *avi_src)
{
	gint length;
	AviFile *p,*q;

	/* 㤦ޤϰϳʤХ顼 */
	if (avi_dst->type!=avi_src->type || pos<0 || avi_dst->length<pos)
		return FALSE;
	if (avi_dst->type==streamtypeAUDIO) {
		/* ǥ */
		length=wf_header_bytes(avi_dst->wfx);
		if (length!=wf_header_bytes(avi_src->wfx)
								|| memcmp(avi_dst->wfx,avi_src->wfx,length)!=0)
			return FALSE;/* եޥåȤۤʤ */
	}
	/* å */
	if (pos<=avi_dst->pos)
		avi_dst->pos+=avi_src->length;
	if (pos<avi_dst->length) {
		/* Žդ֤ʬ䤹 */
		avi_split_file(avi_dst,pos);
		p=avi_dst->file->prev;
		q=avi_dst->file;
	} else {
		/* Žդ */
		while (avi_dst->file->next!=NULL) {
			avi_dst->offset+=avi_dst->file->length;
			avi_dst->file=avi_dst->file->next;
		}
		p=avi_dst->file;
		q=NULL;
	}
	/* Ƭذư */
	while (avi_src->file->prev!=NULL)
		avi_src->file=avi_src->file->prev;
	avi_src->file->prev=p;
	if (p!=NULL)
		p->next=avi_src->file;
	/* ذư */
	while (avi_src->file->next!=NULL)
		avi_src->file=avi_src->file->next;
	avi_src->file->next=q;
	if (q!=NULL)
		q->prev=avi_src->file;
	/* ꥹȤΥեåȤꤹ */
	if (pos<=avi_dst->offset)
		avi_dst->offset+=avi_src->length;
	/* ץäŽդ˴ */
	avi_dst->length+=avi_src->length;
	g_free(avi_src->buf);
	g_free(avi_src->bmih);
	g_free(avi_src->wfx);
	g_free(avi_src);
	/* Ŭ */
	if (p!=NULL && p->name!=NULL && p->next->name!=NULL
									&& strcmp(p->name,p->next->name)==0
									&& p->start+p->length==p->next->start) {
		p->length+=p->next->length;
		p=p->next;
		if (avi_dst->file==p) {
			avi_dst->file=avi_dst->file->prev;
			avi_dst->offset-=avi_dst->file->length;
		}
		if (p->prev!=NULL)
			p->prev->next=p->next;
		if (p->next!=NULL)
			p->next->prev=p->prev;
		avi_release_file(p);
	}
	if (q!=NULL && q->name!=NULL && q->prev->name!=NULL
								&& strcmp(q->name,q->prev->name)==0
								&& q->prev->start+q->prev->length==q->start) {
		if (avi_dst->file==q) {
			avi_dst->file=avi_dst->file->prev;
			avi_dst->offset-=avi_dst->file->length;
		}
		q->prev->length+=q->length;
		if (q->prev!=NULL)
			q->prev->next=q->next;
		if (q->next!=NULL)
			q->next->prev=q->prev;
		avi_release_file(q);
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ʥꥪ֥ȴؿ(פ)                                            *
*                                                                             *
******************************************************************************/
/*	AVIΰ򥷥ʥꥪ֥ȤѴ
	avi_edit,AVIԽϥɥؤΥݥ
	  stream,ȥ꡼ֹ
	   start,ѴϤ륵ץֹ
	 samples,ץ
	     RET,ʥꥪ֥,NULL:顼								*/
static gchar *avi_at_scenario(AviEdit *avi_edit,
										gint stream,gint start,gint samples)
{
	gchar *text,*scenario=NULL;
	gint i,j,leng,length=0,size;

	/* Ȱ֤ȥץĴ */
	if (start<0)
		return NULL;
	if (samples>avi_edit->length-start)
		samples=avi_edit->length-start;
	if (samples<=0 || avi_edit->length<samples)
		return NULL;

	while (samples>0) {
		avi_get_file(avi_edit,start);/* AVIե */
		if (avi_edit->file->name!=NULL) {
			/* ե */
			text=g_strdup_printf("%d,file,\'%s\',%d,%d,%d\n",stream,
				avi_edit->file->name,avi_edit->file->param,
				avi_edit->file->start+start-avi_edit->offset,
				MIN(avi_edit->file->length-(start-avi_edit->offset),samples));
			samples-=avi_edit->file->length-(start-avi_edit->offset);
			start+=avi_edit->file->length-(start-avi_edit->offset);
		} else if (avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL) {
			/* ӥåȥޥå */
			text=g_strdup_printf("%d,bitmap,%d,\\\n",
									stream,bm_all_bytes(avi_edit->file->bmih));
			j=0;
			leng=strlen(text);
			size=bm_header_bytes(avi_edit->file->bmih);
			for (i=0;i<size;i++) {
				text=g_realloc(text,(leng+4+(j%16==0?1:0)
											+(j%16==15?2:0))*sizeof(gchar));
				if (j%16==0)
					text[leng++]='\t';
				g_snprintf(text+leng,4,"%02X,",
										((guint8 *)avi_edit->file->bmih)[i]);
				leng+=3;
				if (j%15==0) {
					text[leng++]='\\';
					text[leng++]='\n';
				}
				j++;
			}
			size=bm_image_bytes(avi_edit->file->bmih);
			for (i=0;i<size;i++) {
				text=g_realloc(text,(leng+4+(j%16==0?1:0)
											+(j%16==15?2:0))*sizeof(gchar));
				if (j%16==0)
					text[leng++]='\t';
				g_snprintf(text+leng,4,"%02X,",
										((guint8 *)avi_edit->file->data)[i]);
				leng+=3;
				if (j%15==0 && i<size-1) {
					text[leng++]='\\';
					text[leng++]='\n';
				}
				j++;
			}
			text[leng-1]='\n';
			start++;
			samples--;
		} else {
			g_free(scenario);
			return NULL;
		}
		leng=strlen(text);
		scenario=g_realloc(scenario,(length+leng+1)*sizeof(gchar));
		memcpy(scenario+length,text,leng);
		g_free(text);
		length+=leng;
	}
	scenario[length]='\0';
	return scenario;
}


/*	AVI򥷥ʥꥪ֥ȤѴ
	  avi_edit,AVIԽϥɥؤΥݥ
	interleave,TRUE:󥿡꡼֤,FALSE:󥿡꡼֤ʤ
	       RET,ʥꥪ֥,NULL:顼								*/
gchar *avi_to_scenario(AviEdit *avi_edit[],gboolean interleave)
{
	gchar *text,*scenario=NULL;
	gint i,leng,length=0,streams,current=0,*pos,samples,timer=0,times;

	/* إå */
	scenario=g_strdup("#VMAID\n-1,Video maid scenario object,0\n\n");
	length=strlen(scenario);
	for (i=0;avi_edit[i]!=NULL;i++) {
		switch (avi_edit[i]->type) {
			case streamtypeAUDIO:
				text=g_strdup_printf("%d,type,audio\n",i);
				break;
			case streamtypeVIDEO:
				text=g_strdup_printf(	"%d,type,video\n"
										"%d,rate,%u\n"
										"%d,scale,%u\n"
										"%d,bmih,%d,%d,%d,%d,%d\n",
						i,
						i,avi_edit[i]->rate,
						i,avi_edit[i]->scale,
						i,bmih_get_width(avi_edit[i]->bmih),
							bmih_get_height(avi_edit[i]->bmih),
							bmih_get_bit_count(avi_edit[i]->bmih),
							bmih_get_x_pixels_per_meter(avi_edit[i]->bmih),
							bmih_get_y_pixels_per_meter(avi_edit[i]->bmih));
				break;
			default:
				g_free(scenario);
				return NULL;
		}
		leng=strlen(text);
		scenario=g_realloc(scenario,(length+leng+2)*sizeof(gchar));
		memcpy(scenario+length,text,leng);
		g_free(text);
		length+=leng;
	}
	if (i<=0) {
		g_free(scenario);
		return NULL;
	}
	scenario[length++]='\n';
	scenario[length]='\0';
	/*  */
	if (interleave) {
		/* 󥿡꡼ */
		for (streams=0;avi_edit[streams]!=NULL;streams++);
		/* Ǥ1ô֤Υե졼ʤȥ꡼õ */
		for (current=0;current<streams;current++)
			if (avi_edit[current]->type==streamtypeVIDEO)
				break;
		if (current>=streams) {
			current=-1;
			times=1000;
		} else {
			for (i=0;i<streams;i++)
				if (avi_edit[i]->type==streamtypeVIDEO
						&& (gint64)avi_edit[i]->rate*avi_edit[current]->scale
						<(gint64)avi_edit[current]->rate*avi_edit[i]->scale)
					current=i;
			times=avi_length_time(avi_edit[current])
												/avi_length(avi_edit[current]);
		}
		pos=g_malloc(streams*sizeof(gint));
		memset(pos,0,streams*sizeof(gint));
		while (TRUE) {
			/* ٤ƽϤ齪λ */
			for (i=0;i<streams;i++)
				if (pos[i]<avi_edit[i]->length)
					break;
			if (i>=streams)
				break;
			for (i=0;i<streams;i++)
				if (pos[i]<avi_edit[i]->length) {
					samples=current>0?i==current?1:avi_time_to_sample(
							avi_edit[i],avi_sample_to_time(avi_edit[current],
														pos[current]+1))-pos[i]
								:avi_time_to_sample(avi_edit[i],timer)-pos[i];
					if ((text=avi_at_scenario(avi_edit[i],i,pos[i],samples))
																	!=NULL) {
						leng=strlen(text);
						scenario=g_realloc(scenario,
												(length+leng+1)*sizeof(gchar));
						memcpy(scenario+length,text,leng);
						g_free(text);
						length+=leng;
						if (i!=current)
							pos[i]+=samples;
					}
				}
			if (current>=0) {
				pos[current]++;
				if (avi_edit[current]->length<=pos[current])
					current=-1;
			} else {
				timer+=times;
			}
		}
		g_free(pos);
	} else {
		/* 󥤥󥿡꡼ */
		for (i=0;avi_edit[i]!=NULL;i++) {
			text=avi_at_scenario(avi_edit[i],i,0,avi_edit[i]->length);
			leng=strlen(text);
			scenario=g_realloc(scenario,(length+leng+1)*sizeof(gchar));
			memcpy(scenario+length,text,leng);
			g_free(text);
			length+=leng;
		}
	}
	scenario[length]='\0';
	return scenario;
}


/*	ʥꥪ֥ȤAVI
	scenario,ʥꥪ֥
	     RET,AVIԽϥɥؤΥݥ,NULL:顼						*/
AviEdit **avi_from_scenario(gchar *scenario)
{
	gboolean quote[2];
	gchar **lines,**cmd,*text;
	gint i,j,stream,count=0,leng,param,start,length,value,size;
	guint32 type;
	AviEdit **avi_edit=NULL;
	AviFile *avi_file;

	/* صԤ򿿤βԤѴ */
	text=g_strdup(scenario);
	j=0;
	for (i=0;text[i]!='\0';i++)
		if (text[i]!='\\' || text[i+1]!='\n')
			text[j++]=text[i];
	text[j]='\0';
	lines=g_strsplit(text,"\n",G_MAXINT);
	g_free(text);
	for (i=0;lines[i]!=NULL;i++) {
		/* ʬ,ޤԤˤ */
		quote[0]=quote[1]=FALSE;
		for (j=0;(lines[i])[j]!='\0';j++)
			if ((lines[i])[j]=='\'' && quote[1]==FALSE) {
				quote[0]=!quote[0];
			} else if ((lines[i])[j]=='\"' && quote[0]==FALSE) {
				quote[1]=!quote[1];
			} else if (quote[0]==FALSE && quote[1]==FALSE) {
				if ((lines[i])[j]==',') {
					(lines[i])[j]='\n';
				} else if ((lines[i])[j]=='#') {
					(lines[i])[j]='\0';
					break;
				}
			}
		g_strstrip(lines[i]);
		cmd=g_strsplit(lines[i],"\n",G_MAXINT);
		for (j=0;cmd[j]!=NULL;j++) {
			g_strstrip(cmd[j]);
			leng=strlen(cmd[j])-1;
			if (leng>=1 && (((cmd[j])[0]=='\'' && (cmd[j])[leng]=='\'')
							|| ((cmd[j])[0]=='\"' && (cmd[j])[leng]=='\"'))) {
				memmove(cmd[j],cmd[j]+1,--leng*sizeof(gchar));
				(cmd[j])[leng]='\0';
			}
		}
		if (cmd[0]!=NULL && cmd[1]!=NULL
							&& strval(&stream,cmd[0],10,TRUE) && stream>=0) {
			if (count<=stream) {/* ĥ */
				avi_edit=g_realloc(avi_edit,(stream+1)*sizeof(AviEdit *));
				memset(avi_edit+count,0,(stream-count+1)*sizeof(AviEdit *));
				count=stream+1;
			}
			if (avi_edit[stream]==NULL) {/*  */
				avi_edit[stream]=g_malloc(sizeof(AviEdit));
				avi_edit[stream]->offset=0;
				avi_edit[stream]->file=NULL;
				avi_edit[stream]->type=0;
				avi_edit[stream]->length=0;
				avi_edit[stream]->rate=0;
				avi_edit[stream]->scale=0;
				avi_edit[stream]->buf=NULL;
				avi_edit[stream]->bmih=NULL;
				avi_edit[stream]->pos=-1;
				avi_edit[stream]->wfx=NULL;
			}
			if (g_strcasecmp(cmd[1],"type")==0 && cmd[2]!=NULL) {
				if (g_strcasecmp(cmd[2],"audio")==0)
					avi_edit[stream]->type=streamtypeAUDIO;
				else if (g_strcasecmp(cmd[2],"video")==0)
					avi_edit[stream]->type=streamtypeVIDEO;
			} else if (g_strcasecmp(cmd[1],"rate")==0 && cmd[2]!=NULL) {
				if (strval(&value,cmd[2],10,FALSE))
					avi_edit[stream]->rate=value;
			} else if (g_strcasecmp(cmd[1],"scale")==0 && cmd[2]!=NULL) {
				if (strval(&value,cmd[2],10,FALSE))
					avi_edit[stream]->scale=value;
			} else if (g_strcasecmp(cmd[1],"bmih")==0) {
				for (j=2;cmd[j]!=NULL;j++);
				if (j>=7) {
					if (avi_edit[stream]->bmih==NULL) {/*  */
						avi_edit[stream]->bmih=g_malloc(BMIH_SIZE);
						bmih_set_size(avi_edit[stream]->bmih,BMIH_SIZE);
						bmih_set_width(avi_edit[stream]->bmih,0);
						bmih_set_height(avi_edit[stream]->bmih,0);
						bmih_set_planes(avi_edit[stream]->bmih,1);
						bmih_set_bit_count(avi_edit[stream]->bmih,0);
						bmih_set_compression(avi_edit[stream]->bmih,BI_RGB);
						bmih_set_size_image(avi_edit[stream]->bmih,0);
						bmih_set_x_pixels_per_meter(avi_edit[stream]->bmih,0);
						bmih_set_y_pixels_per_meter(avi_edit[stream]->bmih,0);
						bmih_set_color_used(avi_edit[stream]->bmih,0);
						bmih_set_color_important(avi_edit[stream]->bmih,0);
					}
					if (strval(&value,cmd[2],10,TRUE) && value>0)
						bmih_set_width(avi_edit[stream]->bmih,value);
					if (strval(&value,cmd[3],10,TRUE) && value>0)
						bmih_set_height(avi_edit[stream]->bmih,value);
					if (strval(&value,cmd[4],10,FALSE))
						switch (value) {
						case  1:
							bmih_set_bit_count(avi_edit[stream]->bmih,1);
							bmih_set_color_used(avi_edit[stream]->bmih,2);
							break;
						case  4:
							bmih_set_bit_count(avi_edit[stream]->bmih,4);
							bmih_set_color_used(avi_edit[stream]->bmih,16);
							break;
						case  8:
							bmih_set_bit_count(avi_edit[stream]->bmih,8);
							bmih_set_color_used(avi_edit[stream]->bmih,256);
							break;
						case 16:
						case 24:
						case 32:
							bmih_set_bit_count(avi_edit[stream]->bmih,value);
							bmih_set_color_used(avi_edit[stream]->bmih,0);
						}
					if (strval(&value,cmd[5],10,FALSE))
						bmih_set_x_pixels_per_meter(avi_edit[stream]->bmih,
																		value);
					if (strval(&value,cmd[6],10,FALSE))
						bmih_set_x_pixels_per_meter(avi_edit[stream]->bmih,
																		value);
					if (bmih_get_width(avi_edit[stream]->bmih)<=0
							|| bmih_get_height(avi_edit[stream]->bmih)<=0
							|| bmih_get_bit_count(avi_edit[stream]->bmih)==0) {
						g_free(avi_edit[stream]->bmih);
						avi_edit[stream]->bmih=NULL;
					} else {
						avi_edit[stream]->bmih
								=g_realloc(avi_edit[stream]->bmih,
									bm_header_bytes(avi_edit[stream]->bmih));
					}
				}
			} else if (g_strcasecmp(cmd[1],"file")==0 && cmd[2]!=NULL) {
				if (cmd[3]==NULL || !strval(&param,cmd[3],10,FALSE))
					param=0;
				avi_file=avi_open_file(cmd[2],param,&type,
								avi_edit[stream]->rate<=0
											?&avi_edit[stream]->rate:NULL,
								avi_edit[stream]->scale<=0
											?&avi_edit[stream]->scale:NULL);
				if (avi_edit[stream]->type==0) {
					avi_edit[stream]->type=type;
				} else if (avi_edit[stream]->type!=type) {
					avi_release_file(avi_file);
					avi_file=NULL;
				}
				if (avi_file!=NULL) {
					if (cmd[3]==NULL || cmd[4]==NULL
											|| !strval(&start,cmd[4],10,TRUE))
						start=-1;
					if (cmd[3]==NULL || cmd[4]==NULL || cmd[5]==NULL
											|| !strval(&length,cmd[5],10,TRUE))
						length=-1;
					if (0<start && start<avi_file->length) {
						avi_file->start=start;
						avi_file->length-=start;
					}
					if (0<length && length<avi_file->length)
						avi_file->length=length;
					if (avi_edit[stream]->file==NULL) {
						/* Ƭ */
						avi_edit[stream]->file=avi_file;
					} else if (strcmp(avi_edit[stream]->file->name,
															avi_file->name)==0
							&& avi_edit[stream]->file->start
							+avi_edit[stream]->file->length==avi_file->start) {
						/* Ϣ³ */
						avi_edit[stream]->file->length+=avi_file->length;
						avi_release_file(avi_file);
					} else {
						/* ɲ */
						avi_edit[stream]->file->next=avi_file;
						avi_file->prev=avi_edit[stream]->file;
						avi_edit[stream]->file=avi_file;
					}
				}
			} else if (g_strcasecmp(cmd[1],"bitmap")==0 && cmd[2]!=NULL
											&& strval(&size,cmd[2],10,FALSE)
											&& size>BMIH_SIZE) {
				avi_file=g_malloc(sizeof(AviFile));
				avi_file->data=NULL;			/*  */
				/* إåɤ߹ */
				avi_file->bmih=g_malloc(BMIH_SIZE);
				for (j=0;j<BMIH_SIZE && cmd[j+3]!=NULL;j++) {
					if (!strval(&value,cmd[j+3],16,FALSE))
						break;
					((guint8 *)avi_file->bmih)[j]=value;
				}
				if (j!=BMIH_SIZE) {
					g_free(avi_file->bmih);
					g_free(avi_file);
					avi_file=NULL;
				} else {
					/* إåλĤɤ߹ */
					length=bm_header_bytes(avi_file->bmih);
					if (length>=size || bm_all_bytes(avi_file->bmih)!=size) {
						g_free(avi_file->bmih);
						g_free(avi_file);
					} else {
						avi_file->bmih=g_realloc(avi_file->bmih,length);
						while (j<length && cmd[j+3]!=NULL) {
							if (!strval(&value,cmd[j+3],16,FALSE))
								break;
							((guint8 *)avi_file->bmih)[j++]=value;
						}
						if (j!=length) {
							g_free(avi_file->bmih);
							g_free(avi_file);
							avi_file=NULL;
						} else {
							/* Τɤ߹ */
							avi_file->data=g_malloc(size-length);
							while (j<size && cmd[j+3]!=NULL) {
								if (!strval(&value,cmd[j+3],16,FALSE))
									break;
								((guint8 *)avi_file->data)[j-length]=value;
								j++;
							}
							if (j!=size) {
								g_free(avi_file->data);
								g_free(avi_file->bmih);
								g_free(avi_file);
								avi_file=NULL;
							}
						}
					}
				}
				if (avi_file!=NULL) {
					avi_file->fd=-1;			/* եǥ꥿ */
					avi_file->name=NULL;		/* ե̾ */
					avi_file->start=0;
					avi_file->length=1;			/* ͭϰ */
					avi_file->entries=1;		/* ǥåο */
					avi_file->param=0;			/* ȥ꡼ֹ */
					/* ǥå */
					avi_file->index=g_malloc(sizeof(AviIndex));
					avi_file->index[0].offset=0;
					avi_file->index[0].size=size;
					avi_file->index[0].flags=0;
					/* ǥͭ */
					avi_file->wfx=NULL;			/* ꥸʥΥեޥå */
					/* ꥹ */
					avi_file->next=NULL;
					if (avi_edit[stream]->file==NULL) {
						/* Ƭ */
						avi_file->prev=NULL;
						avi_edit[stream]->file=avi_file;
					} else {
						/* ɲ */
						avi_edit[stream]->file->next=avi_file;
						avi_file->prev=avi_edit[stream]->file;
						avi_edit[stream]->file=avi_file;
					}
				}
			}
		}
		g_strfreev(cmd);
	}
	g_strfreev(lines);
	if (avi_edit!=NULL) {
		for (i=0;i<count;i++) {
			/* ץ */
			if (avi_edit[i]->file!=NULL) {
				while (avi_edit[i]->file->prev!=NULL)
					avi_edit[i]->file=avi_edit[i]->file->prev;
				for (avi_file=avi_edit[i]->file;avi_file!=NULL;
													avi_file=avi_file->next)
					avi_edit[i]->length+=avi_file->length;
			}
			if (avi_edit[i]->length<=0) {
				avi_release(avi_edit[i]);
				avi_edit[i]=NULL;
			}
			/* ŸΥեޥå */
			if (avi_edit[i]!=NULL && avi_edit[i]->bmih==NULL
									&& avi_edit[i]->type==streamtypeVIDEO) {
				if (bmih_get_compression(avi_edit[i]->file->bmih)==BI_BITFIELDS
					|| bmih_get_compression(avi_edit[i]->file->bmih)==BI_RGB
					|| bmih_get_compression(avi_edit[i]->file->bmih)
												==make4cc('D','I','B',' ')) {
					avi_edit[i]->bmih=g_memdup(avi_edit[i]->file->bmih,
									bm_header_bytes(avi_edit[i]->file->bmih));
					if (bmih_get_compression(avi_edit[i]->bmih)
													==make4cc('D','I','B',' '))
						bmih_set_compression(avi_edit[i]->bmih,BI_RGB);
				} else {
					/*  */
					avi_release(avi_edit[i]);
					avi_edit[i]=NULL;
				}
			} else if (avi_edit[i]!=NULL && avi_edit[i]->wfx==NULL
									&& avi_edit[i]->type==streamtypeAUDIO) {
				if (wfx_get_format_tag(avi_edit[i]->file->wfx)
														==WAVE_FORMAT_PCM) {
					avi_edit[i]->wfx=g_memdup(avi_edit[i]->file->wfx,
									wf_header_bytes(avi_edit[i]->file->wfx));
				} else {
					/*  */
					avi_release(avi_edit[i]);
					avi_edit[i]=NULL;
				}
			}
//			g_print("type=%X,rate=%u,scale=%u,length=%d\n",avi_edit[i]->type,avi_edit[i]->rate,avi_edit[i]->scale,avi_edit[i]->length);
//			for (avi_file=avi_edit[i]->file;avi_file!=NULL;
//													avi_file=avi_file->next)
//				g_print("%s,start=%d,length=%d\n",avi_file->name,avi_file->start,avi_file->length);
		}
		j=0;
		for (i=0;i<count;i++)
			if (avi_edit[i]!=NULL)
				avi_edit[j++]=avi_edit[i];
		if (j>0) {
			avi_edit=g_realloc(avi_edit,(j+1)*sizeof(AviEdit *));
			avi_edit[j]=NULL;
		} else {
			g_free(avi_edit);
			avi_edit=NULL;
		}
	}
	return avi_edit;
}


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
#define AVI_HEADERSIZE 2048


const static guint8 rgb2[8]={0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00};
const static guint8 rgb16[64]={
			0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,
			0x00,0xFF,0xFF,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,
			0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x00,
			0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
			0xFF,0xFF,0xFF,0x00};
const static guint8 rgb256[1024]={
			0x00,0x00,0x00,0x00,0x55,0x00,0x00,0x00,0xAA,0x00,0x00,0x00,
			0xFF,0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x55,0x24,0x00,0x00,
			0xAA,0x24,0x00,0x00,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x00,
			0x55,0x49,0x00,0x00,0xAA,0x49,0x00,0x00,0xFF,0x49,0x00,0x00,
			0x00,0x6D,0x00,0x00,0x55,0x6D,0x00,0x00,0xAA,0x6D,0x00,0x00,
			0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,0x00,0x55,0x92,0x00,0x00,
			0xAA,0x92,0x00,0x00,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x00,
			0x55,0xB6,0x00,0x00,0xAA,0xB6,0x00,0x00,0xFF,0xB6,0x00,0x00,
			0x00,0xDB,0x00,0x00,0x55,0xDB,0x00,0x00,0xAA,0xDB,0x00,0x00,
			0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,0x00,0x55,0xFF,0x00,0x00,
			0xAA,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x24,0x00,
			0x55,0x00,0x24,0x00,0xAA,0x00,0x24,0x00,0xFF,0x00,0x24,0x00,
			0x00,0x24,0x24,0x00,0x55,0x24,0x24,0x00,0xAA,0x24,0x24,0x00,
			0xFF,0x24,0x24,0x00,0x00,0x49,0x24,0x00,0x55,0x49,0x24,0x00,
			0xAA,0x49,0x24,0x00,0xFF,0x49,0x24,0x00,0x00,0x6D,0x24,0x00,
			0x55,0x6D,0x24,0x00,0xAA,0x6D,0x24,0x00,0xFF,0x6D,0x24,0x00,
			0x00,0x92,0x24,0x00,0x55,0x92,0x24,0x00,0xAA,0x92,0x24,0x00,
			0xFF,0x92,0x24,0x00,0x00,0xB6,0x24,0x00,0x55,0xB6,0x24,0x00,
			0xAA,0xB6,0x24,0x00,0xFF,0xB6,0x24,0x00,0x00,0xDB,0x24,0x00,
			0x55,0xDB,0x24,0x00,0xAA,0xDB,0x24,0x00,0xFF,0xDB,0x24,0x00,
			0x00,0xFF,0x24,0x00,0x55,0xFF,0x24,0x00,0xAA,0xFF,0x24,0x00,
			0xFF,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x55,0x00,0x49,0x00,
			0xAA,0x00,0x49,0x00,0xFF,0x00,0x49,0x00,0x00,0x24,0x49,0x00,
			0x55,0x24,0x49,0x00,0xAA,0x24,0x49,0x00,0xFF,0x24,0x49,0x00,
			0x00,0x49,0x49,0x00,0x55,0x49,0x49,0x00,0xAA,0x49,0x49,0x00,
			0xFF,0x49,0x49,0x00,0x00,0x6D,0x49,0x00,0x55,0x6D,0x49,0x00,
			0xAA,0x6D,0x49,0x00,0xFF,0x6D,0x49,0x00,0x00,0x92,0x49,0x00,
			0x55,0x92,0x49,0x00,0xAA,0x92,0x49,0x00,0xFF,0x92,0x49,0x00,
			0x00,0xB6,0x49,0x00,0x55,0xB6,0x49,0x00,0xAA,0xB6,0x49,0x00,
			0xFF,0xB6,0x49,0x00,0x00,0xDB,0x49,0x00,0x55,0xDB,0x49,0x00,
			0xAA,0xDB,0x49,0x00,0xFF,0xDB,0x49,0x00,0x00,0xFF,0x49,0x00,
			0x55,0xFF,0x49,0x00,0xAA,0xFF,0x49,0x00,0xFF,0xFF,0x49,0x00,
			0x00,0x00,0x6D,0x00,0x55,0x00,0x6D,0x00,0xAA,0x00,0x6D,0x00,
			0xFF,0x00,0x6D,0x00,0x00,0x24,0x6D,0x00,0x55,0x24,0x6D,0x00,
			0xAA,0x24,0x6D,0x00,0xFF,0x24,0x6D,0x00,0x00,0x49,0x6D,0x00,
			0x55,0x49,0x6D,0x00,0xAA,0x49,0x6D,0x00,0xFF,0x49,0x6D,0x00,
			0x00,0x6D,0x6D,0x00,0x55,0x6D,0x6D,0x00,0xAA,0x6D,0x6D,0x00,
			0xFF,0x6D,0x6D,0x00,0x00,0x92,0x6D,0x00,0x55,0x92,0x6D,0x00,
			0xAA,0x92,0x6D,0x00,0xFF,0x92,0x6D,0x00,0x00,0xB6,0x6D,0x00,
			0x55,0xB6,0x6D,0x00,0xAA,0xB6,0x6D,0x00,0xFF,0xB6,0x6D,0x00,
			0x00,0xDB,0x6D,0x00,0x55,0xDB,0x6D,0x00,0xAA,0xDB,0x6D,0x00,
			0xFF,0xDB,0x6D,0x00,0x00,0xFF,0x6D,0x00,0x55,0xFF,0x6D,0x00,
			0xAA,0xFF,0x6D,0x00,0xFF,0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,
			0x55,0x00,0x92,0x00,0xAA,0x00,0x92,0x00,0xFF,0x00,0x92,0x00,
			0x00,0x24,0x92,0x00,0x55,0x24,0x92,0x00,0xAA,0x24,0x92,0x00,
			0xFF,0x24,0x92,0x00,0x00,0x49,0x92,0x00,0x55,0x49,0x92,0x00,
			0xAA,0x49,0x92,0x00,0xFF,0x49,0x92,0x00,0x00,0x6D,0x92,0x00,
			0x55,0x6D,0x92,0x00,0xAA,0x6D,0x92,0x00,0xFF,0x6D,0x92,0x00,
			0x00,0x92,0x92,0x00,0x55,0x92,0x92,0x00,0xAA,0x92,0x92,0x00,
			0xFF,0x92,0x92,0x00,0x00,0xB6,0x92,0x00,0x55,0xB6,0x92,0x00,
			0xAA,0xB6,0x92,0x00,0xFF,0xB6,0x92,0x00,0x00,0xDB,0x92,0x00,
			0x55,0xDB,0x92,0x00,0xAA,0xDB,0x92,0x00,0xFF,0xDB,0x92,0x00,
			0x00,0xFF,0x92,0x00,0x55,0xFF,0x92,0x00,0xAA,0xFF,0x92,0x00,
			0xFF,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x55,0x00,0xB6,0x00,
			0xAA,0x00,0xB6,0x00,0xFF,0x00,0xB6,0x00,0x00,0x24,0xB6,0x00,
			0x55,0x24,0xB6,0x00,0xAA,0x24,0xB6,0x00,0xFF,0x24,0xB6,0x00,
			0x00,0x49,0xB6,0x00,0x55,0x49,0xB6,0x00,0xAA,0x49,0xB6,0x00,
			0xFF,0x49,0xB6,0x00,0x00,0x6D,0xB6,0x00,0x55,0x6D,0xB6,0x00,
			0xAA,0x6D,0xB6,0x00,0xFF,0x6D,0xB6,0x00,0x00,0x92,0xB6,0x00,
			0x55,0x92,0xB6,0x00,0xAA,0x92,0xB6,0x00,0xFF,0x92,0xB6,0x00,
			0x00,0xB6,0xB6,0x00,0x55,0xB6,0xB6,0x00,0xAA,0xB6,0xB6,0x00,
			0xFF,0xB6,0xB6,0x00,0x00,0xDB,0xB6,0x00,0x55,0xDB,0xB6,0x00,
			0xAA,0xDB,0xB6,0x00,0xFF,0xDB,0xB6,0x00,0x00,0xFF,0xB6,0x00,
			0x55,0xFF,0xB6,0x00,0xAA,0xFF,0xB6,0x00,0xFF,0xFF,0xB6,0x00,
			0x00,0x00,0xDB,0x00,0x55,0x00,0xDB,0x00,0xAA,0x00,0xDB,0x00,
			0xFF,0x00,0xDB,0x00,0x00,0x24,0xDB,0x00,0x55,0x24,0xDB,0x00,
			0xAA,0x24,0xDB,0x00,0xFF,0x24,0xDB,0x00,0x00,0x49,0xDB,0x00,
			0x55,0x49,0xDB,0x00,0xAA,0x49,0xDB,0x00,0xFF,0x49,0xDB,0x00,
			0x00,0x6D,0xDB,0x00,0x55,0x6D,0xDB,0x00,0xAA,0x6D,0xDB,0x00,
			0xFF,0x6D,0xDB,0x00,0x00,0x92,0xDB,0x00,0x55,0x92,0xDB,0x00,
			0xAA,0x92,0xDB,0x00,0xFF,0x92,0xDB,0x00,0x00,0xB6,0xDB,0x00,
			0x55,0xB6,0xDB,0x00,0xAA,0xB6,0xDB,0x00,0xFF,0xB6,0xDB,0x00,
			0x00,0xDB,0xDB,0x00,0x55,0xDB,0xDB,0x00,0xAA,0xDB,0xDB,0x00,
			0xFF,0xDB,0xDB,0x00,0x00,0xFF,0xDB,0x00,0x55,0xFF,0xDB,0x00,
			0xAA,0xFF,0xDB,0x00,0xFF,0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,
			0x55,0x00,0xFF,0x00,0xAA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
			0x00,0x24,0xFF,0x00,0x55,0x24,0xFF,0x00,0xAA,0x24,0xFF,0x00,
			0xFF,0x24,0xFF,0x00,0x00,0x49,0xFF,0x00,0x55,0x49,0xFF,0x00,
			0xAA,0x49,0xFF,0x00,0xFF,0x49,0xFF,0x00,0x00,0x6D,0xFF,0x00,
			0x55,0x6D,0xFF,0x00,0xAA,0x6D,0xFF,0x00,0xFF,0x6D,0xFF,0x00,
			0x00,0x92,0xFF,0x00,0x55,0x92,0xFF,0x00,0xAA,0x92,0xFF,0x00,
			0xFF,0x92,0xFF,0x00,0x00,0xB6,0xFF,0x00,0x55,0xB6,0xFF,0x00,
			0xAA,0xB6,0xFF,0x00,0xFF,0xB6,0xFF,0x00,0x00,0xDB,0xFF,0x00,
			0x55,0xDB,0xFF,0x00,0xAA,0xDB,0xFF,0x00,0xFF,0xDB,0xFF,0x00,
			0x00,0xFF,0xFF,0x00,0x55,0xFF,0xFF,0x00,0xAA,0xFF,0xFF,0x00,
			0xFF,0xFF,0xFF,0x00};


/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_bitmap(AviEdit *avi_edit,gchar *file,gint start,gint end,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gboolean result=TRUE;
	gchar *format,*dir,*name,*ext;
	gint i,s,length;
	BitmapFileHeader bmfh;
	BitmapInfoHeader *bmih0,*bmih1,*bmih2=NULL;

	dir=g_dirname(file);
	name=g_strdup(g_basename(file));
	for (i=strlen(name)-1;i>=0;i--)
		if (name[i]=='.')
			break;
	if (i>=0) {
		ext=g_strdup(name+i);
		name[i]='\0';
	} else {
		ext=g_strdup("");
	}
	for (i=0,s=end;s!=0;s/=10)
		i++;
	format=g_strdup_printf("%s/%s%%0%dd%s",dir,name,i,ext);
	g_free(dir);
	g_free(name);
	g_free(ext);

	bmih0=g_malloc(bx_header_bytes(bmih_get_width(avi_edit->bmih),
									bmih_get_height(avi_edit->bmih),
									bmih_get_bit_count(avi_edit->bmih),
									bmih_get_compression(avi_edit->bmih),0));
	memcpy(bmih0,avi_edit->bmih,BMIH_SIZE);
	bmih_set_color_used(bmih0,0);
	bmih_set_color_important(bmih0,0);
	switch (bmih_get_bit_count(bmih0)) {
		case 1:memcpy((guint8 *)bmih0+BMIH_SIZE,rgb2,RGBQUAD_SIZE*2);break;
		case 4:memcpy((guint8 *)bmih0+BMIH_SIZE,rgb16,RGBQUAD_SIZE*16);break;
		case 8:memcpy((guint8 *)bmih0+BMIH_SIZE,rgb256,RGBQUAD_SIZE*256);
	}

	memset(&bmfh,0,BMFH_SIZE);
	bmfh_set_type(&bmfh,0x4d42);
	bmfh_set_size(&bmfh,bm_all_bytes(bmih0)+BMFH_SIZE);
	bmfh_set_off_bits(&bmfh,bm_header_bytes(bmih0)+BMFH_SIZE);

	for (i=start;i<=end;i++) {
		/* ǥå */
		if (!func((i-start)*100/(end-start+1),user_data))
			break;

		if ((bmih1=avi_get_frame(avi_edit,i,bmih_get_width(bmih0),
											bmih_get_height(bmih0)))==NULL) {
			result=FALSE;
			break;
		}
		length=bm_all_bytes(bmih0);
		bmih2=g_realloc(bmih2,length);
		memcpy(bmih2,bmih0,bm_header_bytes(bmih0));
		switch (bmih_get_bit_count(bmih0)) {
			case 1:bitmap_diffuse_1(bmih1,bmih2);break;
			case 4:bitmap_diffuse_4(bmih1,bmih2);break;
			case 8:bitmap_diffuse_8(bmih1,bmih2);break;
			case 16:bitmap_convert_16(bmih1,bmih2);break;
			case 24:bitmap_convert_24(bmih1,bmih2);break;
			default:memcpy(bmih2,bmih1,length);
		}
		name=start==end?g_strdup(file):g_strdup_printf(format,i);
		fd=open(name,O_CREAT|O_EXCL|O_WRONLY,
							S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
		g_free(name);
		if (fd==-1) {
			result=FALSE;
			break;
		}
		if (flock(fd,LOCK_EX)==-1 || write(fd,&bmfh,BMFH_SIZE)!=BMFH_SIZE
										|| write(fd,bmih2,length)!=length) {
			close(fd);
			result=FALSE;
			break;
		}
		if (close(fd)!=0) {
			result=FALSE;
			break;
		}
	}
	g_free(format);
	g_free(bmih0);
	g_free(bmih2);
	return result;
}


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_wave(AviEdit *avi_edit,gchar *file,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gint length,pos=0,samples,written=0,header;
	guint8 *p,*data;

	/* إå׻ */
	header=	sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'WAVE' */
			+sizeof(guint32)									/* 'fmt ' */
			+sizeof(guint32)									/*  */
			+((wf_header_bytes(avi_edit->wfx)+1)&~1)			/* ¤ */
			+sizeof(guint32)									/* 'data' */
			+sizeof(guint32);									/*  */
	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
						S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))==-1)
		return FALSE;
	if (flock(fd,LOCK_EX)==-1 || lseek(fd,header,SEEK_SET)==-1) {
		close(fd);
		return FALSE;
	}
	/* ǡ */
	length=avi_sample_size(avi_edit,0,1);
	if (length<65536) {
		samples=65536/length;
		length*=samples;
	} else {
		samples=1;
	}
	data=g_malloc(length);
	while (pos<avi_edit->length) {
		/* ǥå */
		if (!func(pos*100/avi_edit->length,user_data))
			break;
		if (avi_edit->length<pos+samples) {
			samples=avi_edit->length-pos;
			length=avi_sample_size(avi_edit,pos,samples);
		}
		avi_read(avi_edit,pos,samples,data);
		pos+=samples;
		if (write(fd,data,length)!=length) {
			close(fd);
			g_free(data);
			return FALSE;
		}
		written+=length;
	}
	if ((written&1)!=0) {
		data[0]=0;
		if (write(fd,data,1)!=1) {
			close(fd);
			g_free(data);
			return FALSE;
		}
	}
	/* إåꤹ */
	p=data=g_realloc(data,header);
	*(guint32 *)p=GUINT32_TO_LE(make4cc('R','I','F','F'));
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(header-sizeof(guint32)*2+((written+1)&~1));
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('W','A','V','E'));
	((guint32 *)p)++;											/* 'WAVE' */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('f','m','t',' '));
	((guint32 *)p)++;											/* 'fmt ' */
	*(guint32 *)p=GUINT32_TO_LE(wf_header_bytes(avi_edit->wfx));
	((guint32 *)p)++;											/*  */
	memcpy(p,avi_edit->wfx,wf_header_bytes(avi_edit->wfx));
	if ((wf_header_bytes(avi_edit->wfx)&1)!=0)
		p[wf_header_bytes(avi_edit->wfx)]=0;
	p+=(wf_header_bytes(avi_edit->wfx)+1)&~1;
	*(guint32 *)p=GUINT32_TO_LE(make4cc('d','a','t','a'));
	((guint32 *)p)++;											/* 'data' */
	*(guint32 *)p=GUINT32_TO_LE(written);						/*  */
	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,header)!=header) {
		close(fd);
		g_free(data);
		return FALSE;
	}
	g_free(data);
	return close(fd)==0;
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save(AviEdit *avi_edit[],gchar *file,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gpointer *fmt;
	gchar **name;		/* ̾ؤΥݥ */
	gint i,j,current,longer,*pos,*strf,samples,timer=0,times,length;
	gint streams,audio=1,video=1;	/* ȥ꡼ο */
	gint head,header;	/* 饤Ȥ줿إåΥ,إåΥ */
	gint entries=0;		/* AviIndexEntry¤Το */
	guint8 *p,*data=NULL;
	guint32 fourcc,size;
	AviIndexEntry *index=NULL;
	BitmapInfoHeader *bmih;
	off_t offset;		/* եΥեå */

	for (streams=0;avi_edit[streams]!=NULL;streams++);
	for (i=0;i<streams;i++)
		if (avi_edit[i]->type==streamtypeVIDEO)
			break;
	if (i>=streams)
		return avi_save_wave(avi_edit[0],file,func,user_data);

	/* ȥ꡼̾ */
	name=g_malloc(streams*sizeof(gchar *));
	for (i=0;i<streams;i++)
		switch (avi_edit[i]->type) {
			case streamtypeAUDIO:
				name[i]=g_strdup_printf("Audio #%d",audio++);
				break;
			case streamtypeVIDEO:
				name[i]=g_strdup_printf("Video #%d",video++);
				break;
			default:
				while (i>0)
					g_free(name[--i]);
				g_free(name);
				return FALSE;
		}

	/* إå׻ */
	header=sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'AVI ' */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'hdrl' */
					+sizeof(guint32)							/* 'avih' */
					+sizeof(guint32)							/*  */
					+((AMH_SIZE+1)&~1)							/* ¤ */
				+sizeof(guint32)								/* 'JUNK' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32);								/* 'movi' */
	fmt=g_malloc(streams*sizeof(gpointer));
	strf=g_malloc(streams*sizeof(gint));
	for (i=0;i<streams;i++) {
		switch (avi_edit[i]->type) {
			case streamtypeVIDEO:/* ӥǥ */
				strf[i]=bx_header_bytes(bmih_get_width(avi_edit[i]->bmih),
									bmih_get_height(avi_edit[i]->bmih),
									bmih_get_bit_count(avi_edit[i]->bmih),
									bmih_get_compression(avi_edit[i]->bmih),0);
				fmt[i]=g_malloc(strf[i]);
				memcpy(fmt[i],avi_edit[i]->bmih,BMIH_SIZE);
				bmih_set_color_used(fmt[i],0);
				bmih_set_color_important(fmt[i],0);
				switch (bmih_get_bit_count(fmt[i])) {
					case 1:memcpy((guint8 *)fmt[i]+BMIH_SIZE,rgb2,
														RGBQUAD_SIZE*2);break;
					case 4:memcpy((guint8 *)fmt[i]+BMIH_SIZE,rgb16,
														RGBQUAD_SIZE*16);break;
					case 8:memcpy((guint8 *)fmt[i]+BMIH_SIZE,rgb256,
														RGBQUAD_SIZE*256);
				}
				break;
			case streamtypeAUDIO:/* ǥ */
				strf[i]=wf_header_bytes(avi_edit[i]->wfx);
				fmt[i]=g_memdup(avi_edit[i]->wfx,strf[i]);
				break;
			default:
				while (i>0)
					g_free(fmt[--i]);
				for (i=0;i<streams;i++)
					g_free(name[i]);
				g_free(name);
				g_free(fmt);
				g_free(strf);
				return FALSE;
		}
		header+=sizeof(guint32)									/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'strl' */
					+sizeof(guint32) 							/* 'strh' */
					+sizeof(guint32)							/*  */
					+((ASH_SIZE+1)&~1)							/* ¤ */
					+sizeof(guint32) 							/* 'strf' */
					+sizeof(guint32)							/*  */
					+((strf[i]+1)&~1)							/* ¤ */
					+sizeof(guint32) 							/* 'strn' */
					+sizeof(guint32)							/*  */
					+((strlen(name[i])+1)&~1);					/* ʸ */
	}
	head=(header/AVI_HEADERSIZE+1)*AVI_HEADERSIZE;

	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
					S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))==-1) {
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		return FALSE;
	}
	if (flock(fd,LOCK_EX)==-1 || lseek(fd,head,SEEK_SET)==-1) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		return FALSE;
	}
	offset=head;

	/* Ǥ1ô֤Υե졼ʤȥ꡼õ */
	for (current=0;current<streams;current++)
		if (avi_edit[current]->type==streamtypeVIDEO)
			break;
	if (current>=streams) {
		current=-1;
		times=1000;
	} else {
		for (i=0;i<streams;i++)
			if (avi_edit[i]->type==streamtypeVIDEO
						&& (gint64)avi_edit[i]->rate*avi_edit[current]->scale
						<(gint64)avi_edit[current]->rate*avi_edit[i]->scale)
				current=i;
		times=avi_length_time(avi_edit[current])/avi_length(avi_edit[current]);
	}
	/* Ǥ֤Ĺե졼õ */
	longer=0;
	for (i=1;i<streams;i++)
		if (avi_length_time(avi_edit[longer])<avi_length_time(avi_edit[i]))
			longer=i;
	pos=g_malloc(streams*sizeof(gint));
	memset(pos,0,streams*sizeof(gint));
	while (TRUE) {
		/* ǥå */
		if (!func(pos[i]*100/avi_edit[longer]->length,user_data))
			break;
		/* ٤ƽϤ齪λ */
		for (i=0;i<streams;i++)
			if (pos[i]<avi_edit[i]->length)
				break;
		if (i>=streams)
			break;
		for (i=0;i<streams;i++)
			if (pos[i]<avi_edit[i]->length) {
				samples=MIN(current>=0
								?i==current?1:avi_time_to_sample(avi_edit[i],
										avi_sample_to_time(avi_edit[current],
														pos[current]+1))-pos[i]
								:avi_time_to_sample(avi_edit[i],timer)-pos[i],
							avi_edit[i]->length-pos[i]);
				if (samples>0) {
					if (avi_edit[i]->type==streamtypeVIDEO) {
						for (j=0;j<samples;j++) {
							bmih=avi_get_frame(avi_edit[i],pos[i]+j,
													bmih_get_width(fmt[i]),
													bmih_get_height(fmt[i]));
							if (bmih==NULL) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(name[i]);
									g_free(fmt[i]);
								}
								g_free(name);
								g_free(fmt);
								g_free(strf);
								g_free(data);
								g_free(index);
								return FALSE;
							}
							length=bm_all_bytes(fmt[i]);
							data=g_realloc(data,length);
							memcpy(data,fmt[i],bm_header_bytes(fmt[i]));
							switch (bmih_get_bit_count(fmt[i])) {
								case 1:bitmap_diffuse_1(bmih,
											(BitmapInfoHeader *)data);break;
								case 4:bitmap_diffuse_4(bmih,
											(BitmapInfoHeader *)data);break;
								case 8:bitmap_diffuse_8(bmih,
											(BitmapInfoHeader *)data);break;
								case 16:bitmap_convert_16(bmih,
											(BitmapInfoHeader *)data);break;
								case 24:bitmap_convert_24(bmih,
											(BitmapInfoHeader *)data);break;
								default:memcpy(data,bmih,length);
							}
							length=bm_image_bytes(fmt[i]);
							memmove(data,data+bm_header_bytes(fmt[i]),length);
							if ((length&1)!=0)
								data[length]=0;
							fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','d','b'));
							size=GUINT32_TO_LE(length);
							if (write(fd,&fourcc,sizeof(guint32))
														!=sizeof(guint32)
									|| write(fd,&size,sizeof(guint32))
														!=sizeof(guint32)
									|| write(fd,data,(length+1)&~1)
														!=((length+1)&~1)) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(name[i]);
									g_free(fmt[i]);
								}
								g_free(name);
								g_free(fmt);
								g_free(strf);
								g_free(data);
								g_free(index);
								return FALSE;
							}
							/* ǥå */
							index=g_realloc(index,(entries+1)*AIE_SIZE);
							p=(guint8 *)index+entries++*AIE_SIZE;
							aie_set_type(p,make4cc(i/10+'0',i%10+'0','d','b'));
							aie_set_flags(p,AVIIF_KEYFRAME);
							aie_set_offset(p,offset-head+sizeof(guint32));
							aie_set_length(p,length);
							offset+=((length+1)&~1)+sizeof(guint32)*2;
						}
					} else {
						length=avi_sample_size(avi_edit[i],pos[i],samples);
						data=g_realloc(data,(length+1)&~1);
						avi_read(avi_edit[i],pos[i],samples,data);
						if ((length&1)!=0)
							data[length]=0;
						fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','w','b'));
						size=GUINT32_TO_LE(length);
						if (write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,data,(length+1)&~1)!=((length+1)&~1)) {
							close(fd);
							for (i=0;i<streams;i++) {
								g_free(name[i]);
								g_free(fmt[i]);
							}
							g_free(name);
							g_free(fmt);
							g_free(strf);
							g_free(data);
							g_free(index);
							return FALSE;
						}
						/* ǥå */
						index=g_realloc(index,(entries+1)*AIE_SIZE);
						p=(guint8 *)index+entries++*AIE_SIZE;
						aie_set_type(p,make4cc(i/10+'0',i%10+'0','w','b'));
						aie_set_flags(p,0);
						aie_set_offset(p,offset-head+sizeof(guint32));
						aie_set_length(p,length);
						offset+=((length+1)&~1)+sizeof(guint32)*2;
					}
					if (i!=current)
						pos[i]+=samples;
				}
			}
		if (current>=0) {
			pos[current]++;
			if (avi_edit[current]->length<=pos[current])
				current=-1;
		} else {
			timer+=times;
		}
	}
	g_free(data);

	/* å */
	current=-1;
	for (i=0;i<streams;i++)
		if (pos[i]<=0)
			break;
	if (i>=streams)
		for (i=0;i<streams;i++)
			if (avi_edit[i]->type==streamtypeVIDEO
									&& (current==-1 || pos[i]>pos[current]))
				current=i;

	/* ǥå */
	fourcc=GUINT32_TO_LE(make4cc('i','d','x','1'));
	size=GUINT32_TO_LE(entries*AIE_SIZE);
	if (current<0 || write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,index,entries*AIE_SIZE)!=entries*AIE_SIZE) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		g_free(data);
		g_free(index);
		return FALSE;
	}
	g_free(index);

	/* إåꤹ */
	data=g_malloc(head);
	memset(data,0,head);
	p=data;

	*(guint32 *)p=GUINT32_TO_LE(make4cc('R','I','F','F'));
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(offset+entries*AIE_SIZE);
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('A','V','I',' '));
	((guint32 *)p)++;											/* 'AVI ' */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('L','I','S','T'));
	((guint32 *)p)++;											/* 'LIST' */
	*(guint32 *)p=GUINT32_TO_LE(sizeof(guint32)				/* 'hdrl' */
								+sizeof(guint32)			/* 'avih' */
								+sizeof(guint32)			/*  */
								+AMH_SIZE);					/* ¤ */
	for (i=0;i<streams;i++)
		*(guint32 *)p+=GUINT32_TO_LE(
				sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)							/*  */
				+sizeof(guint32)							/* 'strl' */
					+sizeof(guint32) 						/* 'strh' */
					+sizeof(guint32)						/*  */
					+ASH_SIZE								/* ¤ */
					+sizeof(guint32) 						/* 'strf' */
					+sizeof(guint32)						/*  */
					+((strf[i]+1)&~1)						/* ¤ */
					+sizeof(guint32) 						/* 'strn' */
					+sizeof(guint32)						/*  */
					+((strlen(name[i])+1)&~1));				/* ʸ */
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('h','d','r','l'));
	((guint32 *)p)++;											/* 'hdrl' */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('a','v','i','h'));
	((guint32 *)p)++;											/* 'avih' */
	*(guint32 *)p=GUINT32_TO_LE(AMH_SIZE);
	((guint32 *)p)++;											/*  */
	amh_set_micro_sec_per_frame(p,0);
	amh_set_padding_granularity(p,AVI_HEADERSIZE);
	amh_set_flags(p,AVIF_HASINDEX | AVIF_MUSTUSEINDEX);
	amh_set_total_frames(p,pos[current]);
	for (i=0;i<streams;i++)
		if (pos[i]>0)
			amh_set_streams(p,amh_get_streams(p)+1);
	amh_set_width(p,bmih_get_width(fmt[current]));
	amh_set_height(p,bmih_get_height(fmt[current]));
	p+=AMH_SIZE;												/* ¤ */

	for (i=0;i<streams;i++)
		if (pos[i]>0) {
			*(guint32 *)p=GUINT32_TO_LE(make4cc('L','I','S','T'));
			((guint32 *)p)++;									/* 'LIST' */
			*(guint32 *)p=GUINT32_TO_LE(
						sizeof(guint32)						/* 'strl' */
						+sizeof(guint32) 					/* 'strh' */
						+sizeof(guint32)					/*  */
						+ASH_SIZE							/* ¤ */
						+sizeof(guint32) 					/* 'strf' */
						+sizeof(guint32)					/*  */
						+((strf[i]+1)&~1)					/* ¤ */
						+sizeof(guint32) 					/* 'strn' */
						+sizeof(guint32)					/*  */
						+((strlen(name[i])+1)&~1));			/* ʸ */
			((guint32 *)p)++;									/*  */
			*(guint32 *)p=GUINT32_TO_LE(make4cc('s','t','r','l'));
			((guint32 *)p)++;									/* 'strl' */

			*(guint32 *)p=GUINT32_TO_LE(make4cc('s','t','r','h'));
			((guint32 *)p)++;									/* 'strh' */
			*(guint32 *)p=GUINT32_TO_LE(ASH_SIZE);
			((guint32 *)p)++;									/*  */
			ash_set_type(p,avi_edit[i]->type);
			if (avi_edit[i]->type==streamtypeVIDEO)
				ash_set_handler(p,
					(bmih_get_compression(avi_edit[i]->bmih)==BI_RGB
					|| bmih_get_compression(avi_edit[i]->bmih)==BI_BITFIELDS)
									?GUINT32_TO_LE(make4cc('D','I','B',' '))
									:bmih_get_compression(avi_edit[i]->bmih));
			ash_set_scale(p,avi_edit[i]->scale);
			ash_set_rate(p,avi_edit[i]->rate);
			ash_set_length(p,pos[i]);
			ash_set_quality(p,-1);
			if (avi_edit[i]->type==streamtypeVIDEO) {
				ash_set_frame_right(p,bmih_get_width(avi_edit[i]->bmih));
				ash_set_frame_top(p,bmih_get_height(avi_edit[i]->bmih));
			}
			p+=ASH_SIZE;										/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(make4cc('s','t','r','f'));
			((guint32 *)p)++;									/* 'strf' */
			*(guint32 *)p=GUINT32_TO_LE((strf[i]+1)&~1);
			((guint32 *)p)++;									/*  */
			memcpy(p,fmt[i],strf[i]);
			p+=(strf[i]+1)&~1;									/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(make4cc('s','t','r','n'));
			((guint32 *)p)++;									/* 'strn' */
			*(guint32 *)p=GUINT32_TO_LE((strlen(name[i])+1)&~1);
			((guint32 *)p)++;									/*  */
			memcpy(p,name[i],strlen(name[i]));
			p+=(strlen(name[i])+1)&~1;							/* ʸ */
		}

	*(guint32 *)p=GUINT32_TO_LE(make4cc('J','U','N','K'));
	((guint32 *)p)++;											/* 'JUNK' */
	*(guint32 *)p=GUINT32_TO_LE(head-header);					/*  */

	p=data+head-sizeof(guint32);
	*(guint32 *)p=GUINT32_TO_LE(make4cc('m','o','v','i'));
	((guint32 *)p)--;											/* 'movi' */
	*(guint32 *)p=GUINT32_TO_LE(offset-head+sizeof(guint32));
	((guint32 *)p)--;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(make4cc('L','I','S','T'));		/* 'LIST' */

	for (i=0;i<streams;i++) {
		g_free(name[i]);
		g_free(fmt[i]);
	}
	g_free(name);
	g_free(fmt);
	g_free(strf);
	g_free(pos);

	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,head)!=head) {
		close(fd);
		g_free(data);
		return FALSE;
	}

	g_free(data);
	return close(fd)==0;
}
