/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include "iso10646.h"


/******************************************************************************
*                                                                             *
* ISO-10646                                                                   *
*                                                                             *
******************************************************************************/
gint iso10646_multibyte_to_widechar(gchar *src,gint srclen,
													guint16 *dst,gint dstlen)
{
	gint i,leng;

	if (src==NULL)
		return 0;
	leng=srclen<0?strlen(src)+1:srclen;
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=(src[i]&0x80)==0?src[i]:'?';
	return i;
}


gint iso10646_widechar_to_multibyte(guint16 *src,gint srclen,
														gchar *dst,gint dstlen)
{
	gint i,leng;

	if (src==NULL)
		return 0;
	if (srclen<0) {
		for (leng=0;src[leng]>0;leng++);
		leng++;
	} else {
		leng=srclen;
	}
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=src[i]<0x80?src[i]:'?';
}
