/*
    dllloader
    (C)Copyright 2000, 2001 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "kernel32.h"
#include "module.h"
#include "windef.h"
#include "misc/profile.h"


/******************************************************************************
*                                                                             *
*                                                                           *
*                                                                             *
******************************************************************************/
static VOID WINAPI RtlUnwind(PVOID TargetFrame,PVOID TargetIp,
					PVOID ExceptionRecord
					/*PEXCEPTION_RECORD ExceptionRecord*/,PVOID ReturnValue)
{
	g_message("RtlUnwind in kernel32 called\n");
}


/******************************************************************************
*                                                                             *
* 黻                                                                        *
*                                                                             *
******************************************************************************/
static INT WINAPI MulDiv(INT nNumber,INT nNumerator,INT nDenominator)
{
	if (nDenominator==0)
		return -1;
	return (gint64)nNumber*(gint64)nNumerator/(gint64)nDenominator;
}


/******************************************************************************
*                                                                             *
*                                                                       *
*                                                                             *
******************************************************************************/
typedef HANDLE HLOCAL;


static HLOCAL WINAPI LocalAlloc(UINT uFlags,UINT uBytes)
{
	return g_malloc0(uBytes);
}


static HLOCAL WINAPI LocalDiscard(HLOCAL hlocMem)
{
	return hlocMem;
}


static UINT WINAPI LocalFlags(HLOCAL hMem)
{
	return 0;
}


static HLOCAL WINAPI LocalFree(HLOCAL hMem)
{
	g_free(hMem);
	return NULL;
}


static HLOCAL WINAPI LocalHandle(LPCVOID pMem)
{
	return (HLOCAL)pMem;
}


static LPVOID WINAPI LocalLock(HLOCAL hMem)
{
	return hMem;
}


static HLOCAL WINAPI LocalReAlloc(HLOCAL hMem,UINT uBytes,UINT uFlags)
{
	return g_realloc(hMem,uBytes);
}


static UINT WINAPI LocalSize(HLOCAL hMem)
{
	return 0;
}


static UINT WINAPI LocalUnlock(HLOCAL hMem)
{
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ϥɥ                                                                    *
*                                                                             *
******************************************************************************/
#define STD_INPUT_HANDLE		-10
#define STD_OUTPUT_HANDLE		-11
#define STD_ERROR_HANDLE		-12
#define INVALID_HANDLE_VALUE	-1


static HANDLE WINAPI GetStdHandle(DWORD nStdHandle)
{
	switch (nStdHandle) {
		case STD_INPUT_HANDLE:
			return (HANDLE)stdin;
		case STD_OUTPUT_HANDLE:
			return (HANDLE)stdout;
		case STD_ERROR_HANDLE:
			return (HANDLE)stderr;
	}
	return (HANDLE)INVALID_HANDLE_VALUE;
}


/******************************************************************************
*                                                                             *
* ⥸塼                                                                  *
*                                                                             *
******************************************************************************/
static DWORD WINAPI GetModuleFileNameA(HMODULE hModule,
												LPSTR lpFilename,DWORD nSize)
{
	if (lpFilename==NULL)
		return 0;
	strncpy(lpFilename,g_get_prgname(),nSize);
	lpFilename[nSize-1]='\0';
	return strlen(lpFilename);
}


/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static LPSTR WINAPI lstrcatA(LPSTR lpString1,LPCSTR lpString2)
{
	return lpString1!=NULL && lpString2!=NULL?strcat(lpString1,lpString2):NULL;
}


static LPSTR WINAPI lstrcpyA(LPSTR lpString1,LPCSTR lpString2)
{
	return lpString1!=NULL && lpString2!=NULL?strcpy(lpString1,lpString2):NULL;
}


static INT WINAPI lstrlenA(LPCSTR lpString)
{
	return lpString!=NULL?strlen(lpString):0;
}


static INT WINAPI lstrcmpiA(LPCSTR lpString1,LPCSTR lpString2)
{
	return g_strcasecmp(lpString1,lpString2);
}


static INT WINAPI MultiByteToWideChar(UINT CodePage,DWORD dwFlags,
  LPCSTR lpMultiByteStr,INT cchMultiByte,LPWSTR lpWideCharStr,INT cchWideChar)
{
	gchar *mbuf;
	gint i;
	GdkWChar *wbuf;
	INT nResult;

	if (cchMultiByte<=0 || lpWideCharStr==NULL || cchWideChar<=0)
		return (cchMultiByte>=0?cchMultiByte:strlen(lpMultiByteStr))+1;
	if (cchMultiByte>0) {
		mbuf=g_malloc(cchMultiByte+1);
		memcpy(mbuf,lpMultiByteStr,cchMultiByte);
		mbuf[cchMultiByte]='\0';
	} else {
		mbuf=g_strdup(lpMultiByteStr);
	}
	wbuf=g_malloc(cchWideChar*sizeof(GdkWChar));
	nResult=gdk_mbstowcs(wbuf,mbuf,cchWideChar);
	g_free(mbuf);
	for (i=0;i<cchWideChar;i++)
		lpWideCharStr[i]=wbuf[i];
	g_free(wbuf);
	return nResult;
}


/******************************************************************************
*                                                                             *
* 󥽡                                                                  *
*                                                                             *
******************************************************************************/
static BOOL WINAPI AllocConsole(VOID)
{
	return TRUE;
}


static BOOL WINAPI SetConsoleScreenBufferSize(HANDLE hConsoleOutput,
																DWORD dwSize)
{
	return TRUE;
}


static BOOL WINAPI WriteConsoleA(HANDLE hConsoleOutput,CONST VOID *lpBuffer,
					DWORD nNumberOfCharsToWrite,LPDWORD lpNumberOfCharsWritten,
															LPVOID lpReserved)
{
	gint i;

	if (lpBuffer==NULL)
		return FALSE;
	for (i=0;i<nNumberOfCharsToWrite;i++)
		g_print("%c",((gchar *)lpBuffer)[i]);
	if (lpNumberOfCharsWritten!=NULL)
		*lpNumberOfCharsWritten=i;
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ե                                                              *
*                                                                             *
******************************************************************************/
static UINT WINAPI GetPrivateProfileIntA(LPCSTR lpAppName,LPCSTR lpKeyName,
												INT nDefault,LPCSTR lpFileName)
{
	gchar *file;
	Profile *profile;
	INT nValue=nDefault;

	if (lpAppName==NULL || lpKeyName==NULL)
		return nDefault;
	file=g_strdup_printf("%s/.%s",g_get_home_dir(),
			lpFileName==NULL?g_basename(g_get_prgname()):(gchar *)lpFileName);
	if ((profile=profile_open(file))!=NULL) {
		if (!profile_get_value(profile,lpAppName,lpKeyName,
								&nValue,sizeof(INT),PROFILE_VALUE_TYPE_INT))
			nValue=nDefault;
		profile_close(profile);
	}
	g_free(file);
	return nValue;
}


static BOOL WINAPI WritePrivateProfileStringA(
		LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpString,LPCSTR lpFileName)
{
	gchar *file;
	Profile *profile;
	BOOL fResult=FALSE;

	if (lpAppName==NULL)
		return FALSE;
	file=g_strdup_printf("%s/.%s",g_get_home_dir(),
			lpFileName==NULL?g_basename(g_get_prgname()):(gchar *)lpFileName);
	if ((profile=profile_open(file))!=NULL) {
		if (lpKeyName==NULL)
			fResult=profile_delete_section(profile,lpAppName);
		else if (lpString==NULL)
			fResult=profile_delete_key(profile,lpAppName,lpKeyName);
		else
			fResult=profile_set_value(profile,lpAppName,lpKeyName,
									(const gpointer)lpString,strlen(lpString),
													PROFILE_VALUE_TYPE_STRING);
		profile_close(profile);
	}
	g_free(file);
	return fResult;
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in kernel32 called\n");
}


static SymbolInfo symbol_infos[]={
	{"RtlUnwind",RtlUnwind},
	{"MulDiv",MulDiv},
	{"LocalAlloc",LocalAlloc},
	{"LocalDiscard",LocalDiscard},
	{"LocalFlags",LocalFlags},
	{"LocalFree",LocalFree},
	{"LocalHandle",LocalHandle},
	{"LocalLock",LocalLock},
	{"LocalReAlloc",LocalReAlloc},
	{"LocalSize",LocalSize},
	{"LocalUnlock",LocalUnlock},
	{"GetStdHandle",GetStdHandle},
	{"GetModuleFileNameA",GetModuleFileNameA},
	{"lstrcatA",lstrcatA},
	{"lstrcpyA",lstrcpyA},
	{"lstrlenA",lstrlenA},
	{"lstrcmpiA",lstrcmpiA},
	{"MultiByteToWideChar",MultiByteToWideChar},
	{"AllocConsole",AllocConsole},
	{"SetConsoleScreenBufferSize",SetConsoleScreenBufferSize},
	{"WriteConsoleA",WriteConsoleA},
	{"GetPrivateProfileIntA",GetPrivateProfileIntA},
	{"WritePrivateProfileStringA",WritePrivateProfileStringA},
	{NULL,UnknownSymbol}
};


SymbolInfo *kernel32_get_export_symbols(void)
{
	module_register("kernel32.dll",symbol_infos);
	return symbol_infos;
}
