/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include "module.h"


typedef struct ModuleList_Tag {
	gchar *file;
	SymbolInfo *symbol_infos;
	struct ModuleList_Tag *prev;
	struct ModuleList_Tag *next;
} ModuleList;


ModuleList *mod_list=NULL;


static ModuleList *module_find(const char *file)
{
	ModuleList *p;

	if (mod_list==NULL)
		return NULL;

	if (file==NULL) {
		for (p=mod_list;p!=NULL && p->file!=NULL;p=p->prev);
	} else {
		for (p=mod_list;p!=NULL;p=p->prev)
			if (g_strcasecmp(p->file,file)==0)
				return p;
	}

	return p;
}


gboolean module_register(const gchar *file,SymbolInfo *symbol_infos)
{
	if (module_find(file)!=NULL)
		return TRUE;
	if (mod_list==NULL) {
		mod_list=g_malloc(sizeof(ModuleList));
		mod_list->next=mod_list->prev=NULL;
	} else {
		mod_list->next=g_malloc(sizeof(ModuleList));
		mod_list->next->prev=mod_list;
		mod_list->next->next=NULL;
		mod_list=mod_list->next;
	}

	mod_list->file=file!=NULL?g_strdup(file):NULL;
	mod_list->symbol_infos=symbol_infos;

	return TRUE;
}

static gboolean module_delete(ModuleList *p)
{
	if (p!=NULL) {
		if (mod_list==p)
			mod_list=mod_list->prev;
		if (p->prev!=NULL)
			p->prev->next=p->next;
		if (p->next!=NULL)
			p->next->prev=p->prev;
		g_free(p->file);
		g_free(p->symbol_infos);
		g_free(p);
		return TRUE;
	}
	return FALSE;
}


gboolean module_deregister(const gchar *file)
{
	return module_delete(module_find(file));
}


SymbolInfo *module_lookup(const gchar *file)
{
	ModuleList *p;

	return (p=module_find(file))!=NULL?p->symbol_infos:NULL;
}
