/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <ctype.h>
#include <string.h>
#include "msvcrt.h"
#include "module.h"
#include "windef.h"


/******************************************************************************
*                                                                             *
* 黻                                                                        *
*                                                                             *
******************************************************************************/
static int _adjust_fdiv=0;


/******************************************************************************
*                                                                             *
*                                                                           *
*                                                                             *
******************************************************************************/
static int msvcrt_initterm(void **arg1, void **arg2)
{
	BOOL (*initterm_func)(void);

	while (arg1<arg2) {
		if ((initterm_func=(BOOL(*)(void))*arg1))
			initterm_func();
		arg1++;
	}
	return 0;
}


/******************************************************************************
*                                                                             *
*                                                                       *
*                                                                             *
******************************************************************************/
static void *msvcrt_malloc(size_t size)
{
	return g_malloc(size);
}


static void msvcrt_free(void *memblock)
{
	g_free(memblock);
}


static void *msvcrt_new(size_t size)
{
	return msvcrt_malloc(size);
}


static void msvcrt_delete(void *memblock)
{
	msvcrt_free(memblock);
}


/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static int msvcrt_isalnum(int c)
{
	return isalnum(c);
}


static char *msvcrt_strchr(const char *string,int c)
{
	return strchr(string,c);
}


char *msvcrt_strrchr(const char *string,int c)
{
	return strrchr(string,c);
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in msvcrt called\n");
}


static SymbolInfo symbol_infos[]={
	{"_adjust_fdiv",&_adjust_fdiv},
	{"_initterm",msvcrt_initterm},
	{"malloc",msvcrt_malloc},
	{"free",msvcrt_free},
	{"??2@YAPAXI@Z",msvcrt_new},
	{"??3@YAXPAX@Z",msvcrt_delete},
	{"isalnum",msvcrt_isalnum},
	{"strchr",msvcrt_strchr},
	{"strrchr",msvcrt_strrchr},
	{NULL,UnknownSymbol}
};


SymbolInfo *msvcrt_get_export_symbols(void)
{
	module_register("msvcrt.dll",symbol_infos);
	return symbol_infos;
}
