/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "user32.h"
#include "iso10646.h"
#include "module.h"
#include "pe_image.h"
#include "windef.h"
#include "winuser.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ɥ                                                                  *
*                                                                             *
******************************************************************************/
#define GWL_USERDATA	(-21)
#define GWL_EXSTYLE		(-20)
#define GWL_STYLE		(-16)
#define GWL_ID			(-12)
#define GWL_HWNDPARENT	(-8)
#define GWL_HINSTANCE	(-6)
#define GWL_WNDPROC		(-4)
#define DWL_MSGRESULT	0
#define DWL_DLGPROC		4
#define DWL_USER		8


static LONG WINAPI GetWindowLongA(HWND hWnd,INT nIndex)
{
	WindowExtraData *wed;

	if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL)
		switch (nIndex) {
			case GWL_USERDATA:	return wed->dwUserData;
			case GWL_EXSTYLE:	return wed->dwExStyle;
			case GWL_STYLE:		return wed->dwStyle;
			case GWL_ID:		return wed->wID;
			case GWL_HWNDPARENT:return (LONG)wed->hWndParent;
			case GWL_HINSTANCE:	return (LONG)wed->hInstance;
			case GWL_WNDPROC:	return (LONG)wed->lpfnWndProc;
			case DWL_MSGRESULT:	return wed->lResult;
			case DWL_DLGPROC:	return (LONG)wed->lpDialogFunc;
			case DWL_USER:		return wed->dwUser;
		}
	return 0;
}


static LONG WINAPI SetWindowLongA(HWND hWnd,INT nIndex,LONG dwNewLong)
{
	LONG dwOldLong=0;
	WindowExtraData *wed;

	if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL)
		switch (nIndex) {
			case GWL_USERDATA:
				dwOldLong=wed->dwUserData;
				wed->dwUserData=dwNewLong;
				break;
			case GWL_EXSTYLE:
				dwOldLong=wed->dwExStyle;
				wed->dwExStyle=dwNewLong;
				break;
			case GWL_STYLE:
				dwOldLong=wed->dwStyle;
				wed->dwStyle=dwNewLong;
				break;
			case GWL_ID:
				dwOldLong=wed->wID;
				wed->wID=dwNewLong;
				break;
			case GWL_HWNDPARENT:
				dwOldLong=(DWORD)wed->hWndParent;
				wed->hWndParent=(HWND)dwNewLong;
				break;
			case GWL_HINSTANCE:
				dwOldLong=(DWORD)wed->hInstance;
				wed->hInstance=(HINSTANCE)dwNewLong;
				break;
			case GWL_WNDPROC:
				dwOldLong=(DWORD)wed->lpfnWndProc;
				wed->lpfnWndProc=(WNDPROC)dwNewLong;
				break;
			case DWL_MSGRESULT:
				dwOldLong=wed->lResult;
				wed->lResult=dwNewLong;
				break;
			case DWL_DLGPROC:
				dwOldLong=(DWORD)wed->lpDialogFunc;
				wed->lpDialogFunc=(DLGPROC)dwNewLong;
				break;
			case DWL_USER:
				dwOldLong=wed->dwUser;
				wed->dwUser=dwNewLong;
		}
	return dwOldLong;
}


static HWND WINAPI GetDlgItem(HWND hDlg,INT nIDDlgItem)
{
	gint i;
	WindowExtraData *dlg,*wed;

	if (hDlg!=NULL && (dlg=gtk_object_get_user_data(GTK_OBJECT(hDlg)))!=NULL)
		for (i=0;dlg->child[i]!=NULL;i++)
			if ((wed=gtk_object_get_user_data(GTK_OBJECT(dlg->child[i])))!=NULL
												&& wed->wID==(WORD)nIDDlgItem)
				return dlg->child[i];
	return NULL;
}


static BOOL WINAPI SetWindowTextA(HWND hWnd,LPCSTR lpString)
{
	return FALSE;
}


/******************************************************************************
*                                                                             *
* GDI                                                                         *
*                                                                             *
******************************************************************************/
#include "pshpack1.h"
typedef struct tagPOINT {
	LONG x;
	LONG y;
} POINT,*PPOINT,*LPPOINT;
typedef struct tagRECT {
	INT left;
	INT top;
	INT right;
	INT bottom;
} RECT,*PRECT,*LPRECT;
typedef const RECT *LPCRECT;
#include "poppack.h"


static BOOL WINAPI ScreenToClient(HWND hWnd,LPPOINT lpPoint)
{
	return FALSE;
}


static BOOL WINAPI GetWindowRect(HWND hWnd,LPRECT lpRect)
{
	gint x,y,width,height;

	if (hWnd==NULL)
		return FALSE;
	gdk_window_get_root_origin(GTK_WIDGET(hWnd)->window,&x,&y);
	gdk_window_get_size(GTK_WIDGET(hWnd)->window,&width,&height);
	lpRect->left=x;
	lpRect->top=y;
	lpRect->right=x+width;
	lpRect->bottom=y+height;
	return TRUE;
}


static HDC WINAPI BeginPaint(HWND hWnd,LPVOID/*LPPAINTSTRUCT*/ lpPaint)
{
	return NULL;
}


static BOOL WINAPI EndPaint(HWND hWnd,LPCVOID/*PAINTSTRUCT **/ lpPaint)
{
	return FALSE;
}


static HDC WINAPI GetDC(HWND hWnd)
{
	return NULL;
}


static INT WINAPI ReleaseDC(HWND hWnd,HDC hDC)
{
	return 0;
}


/******************************************************************************
*                                                                             *
* å                                                                  *
*                                                                             *
******************************************************************************/
static LRESULT WINAPI SendMessageA(HWND hWnd,
										UINT Msg,WPARAM wParam,LPARAM lParam)
{
	return hWnd!=NULL?
			((WindowExtraData *)gtk_object_get_user_data(GTK_OBJECT(hWnd)))->
										lpfnWndProc(hWnd,Msg,wParam,lParam):0;
}


static LONG WINAPI SendDlgItemMessageA(HWND hDlg,INT nIDDlgItem,
										UINT Msg,WPARAM wParam,LPARAM lParam)
{
	return SendMessageA(GetDlgItem(hDlg,nIDDlgItem),Msg,wParam,lParam);
}


/******************************************************************************
*                                                                             *
* ꥽                                                                    *
*                                                                             *
******************************************************************************/
/* Predefined resource types */
#define RT_CURSOR		1
#define RT_BITMAP		2
#define RT_ICON			3
#define RT_MENU			4
#define RT_DIALOG		5
#define RT_STRING		6
#define RT_FONTDIR		7
#define RT_FONT			8
#define RT_ACCELERATOR	9
#define RT_RCDATA		10
#define RT_MESSAGETABLE	11
#define RT_GROUP_CURSOR	12
#define RT_GROUP_ICON	14
#define RT_VERSION		16
#define RT_DLGINCLUDE	17
#define RT_PLUGPLAY		19
#define RT_VXD			20
#define RT_ANICURSOR	21
#define RT_ANIICON		22
#define RT_HTML			23


typedef HANDLE HRSRC;
typedef HANDLE HBITMAP;


static HRSRC WINAPI FindResourceExA(HMODULE hModule,
									LPCSTR lpType,LPCSTR lpName,WORD wLanguage)
{
	guint8 *data;
	gchar *buf,*key;

	buf=(gint)lpType<0x10000?g_strdup_printf("/0x%x",(gint)lpType)
							:g_strdup_printf("/%s",lpType);
	key=(gint)lpName<0x10000
					?g_strdup_printf("%s/0x%x/0x%x",buf,(gint)lpName,wLanguage)
					:g_strdup_printf("%s/%s/0x%x",buf,lpName,wLanguage);
	g_free(buf);
	g_strdown(key);
	data=g_hash_table_lookup(((PE_image *)hModule)->resource,key);
	g_free(key);
	return data;
}


static HRSRC WINAPI FindResourceA(HMODULE hModule,LPCSTR lpName,LPCSTR lpType)
{
	gint primary,secondary;
	HRSRC hRsrc;

	for (primary=0;primary<0x400;primary++)
		for (secondary=0;secondary<0x40;secondary++)
			if ((hRsrc=FindResourceExA(hModule,lpType,lpName,
											(secondary<<10)|primary))!=NULL)
				return hRsrc;
	return NULL;
}


static HGLOBAL WINAPI LoadResource(HMODULE hModule,HRSRC hResInfo)
{
	return (LPDWORD)hResInfo+1;
}


static DWORD WINAPI SizeofResource(HMODULE hModule,HRSRC hResInfo)
{
	return *(LPDWORD)hResInfo;
}


static INT WINAPI LoadStringA(HINSTANCE hInstance,UINT uID,
												LPSTR lpBuffer,INT nBufferMax)
{
	gint i;
	guint16 *data;
	HRSRC hRsrc;

	if (lpBuffer==NULL || nBufferMax<=0)
		return 0;
	memset(lpBuffer,0,nBufferMax);

	if ((hRsrc=FindResourceA(hInstance,
						(LPCSTR)((uID>>4)&0xffff)+1,(LPCSTR)RT_STRING))!=NULL
							&& (data=LoadResource(hInstance,hRsrc))!=NULL) {
		for (i=0;i<(uID&0x0f);i++)
			data+=*data+1;
		iso10646_widechar_to_multibyte(data,-1,lpBuffer,nBufferMax);
		lpBuffer[nBufferMax-1]='\0';
	}

	return strlen(lpBuffer);
}


static HBITMAP WINAPI LoadBitmapA(HINSTANCE hInstance,LPCSTR lpBitmapName)
{
	return FindResourceA(hInstance,lpBitmapName,(LPCSTR)RT_BITMAP);
}


/******************************************************************************
*                                                                             *
*                                                                   *
*                                                                             *
******************************************************************************/
#include "pshpack2.h"

/* FIXME: use this instead of LPCVOID for CreateDialogIndirectParam
   and DialogBoxIndirectParam */
typedef struct tagDLGTEMPLATE
{
	DWORD style;
	DWORD dwExtendedStyle;
	WORD cdit;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
} DLGTEMPLATE;

typedef DLGTEMPLATE *LPDLGTEMPLATE;
typedef const DLGTEMPLATE *LPCDLGTEMPLATE;

typedef struct tagDLGITEMTEMPLATE
{
	DWORD style;
	DWORD dwExtendedStyle;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
	WORD id;
} DLGITEMTEMPLATE;

typedef DLGITEMTEMPLATE *PDLGITEMTEMPLATE;
typedef DLGITEMTEMPLATE *LPDLGITEMTEMPLATE;

#include "poppack.h"


/* ܥ󤬲줿Ȥ */
#define dialog_button_toggled dialog_button_clicked
static void dialog_button_clicked(GtkWidget *widget,gpointer user_data)
{
	WindowExtraData *wed;

	wed=gtk_object_get_user_data(GTK_OBJECT(widget));
	wed->lpDialogFunc(wed->hWndParent,WM_COMMAND,
							MAKEWPARAM(wed->wID,BN_CLICKED),(LPARAM)widget);
}


/* Ĥܥ󤬲줿 */
static gboolean dialog_delete(GtkWidget *widget,
										GdkEvent *event,WindowExtraData *wed)
{
	wed->lpDialogFunc(widget,WM_COMMAND,
								MAKEWPARAM(IDCANCEL,BN_CLICKED),(LPARAM)NULL);
	return TRUE;
}


/* ESC줿 */
static gboolean dialog_key_press(GtkWidget *widget,
									GdkEventKey *event,WindowExtraData *wed)
{
	if (event->keyval==GDK_Escape)
		wed->lpDialogFunc(widget,WM_COMMAND,
								MAKEWPARAM(IDCANCEL,BN_CLICKED),(LPARAM)NULL);
	return FALSE;
}


/* ˴ */
static void dialog_widget_destroy(GtkWidget *widget,gpointer user_data)
{
	WindowExtraData *wed;

	wed=gtk_object_get_user_data(GTK_OBJECT(widget));
	g_free(wed->child);
	g_free(wed->sister);
	g_free(wed);
}


static guint16 *dlg_string_next(guint16 *data)
{
	if (*data==0xffff) {
		data+=2;
	} else {
		while (*data!=0)
			data++;
		data++;
	}
	return data;
}
#define DLG_STRING_NEXT(data) ((data)=dlg_string_next(data))


static INT WINAPI DialogBoxIndirectParam(HINSTANCE hInstance,
					LPCDLGTEMPLATE lpDialogTemplate,
					HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam)
{
	gchar *title;
	gint i,j,leng,w,width=0,h,height=0,cdit=0;
	guint key=GDK_VoidSymbol;
	guint16 *data,atom;
	GtkAccelGroup *accel;
	GtkStyle *style;
	GtkWidget *dialog,*fixed,*widget,*focus=NULL;
	INT nResult;
	LPDLGITEMTEMPLATE lpDialogItem;
	WindowExtraData *dlg,*wed;

	if (lpDialogTemplate==NULL || lpDialogFunc==NULL)
		return -1;

	dlg=g_malloc(sizeof(WindowExtraData));
	dlg->dwStyle=lpDialogTemplate->style;
	dlg->dwExStyle=lpDialogTemplate->dwExtendedStyle;
	dlg->lpfnWndProc=DefWindowProc;
	dlg->hInstance=hInstance;
	dlg->hWndParent=hWndParent;
	dlg->wID=0;
	dlg->dwUserData=0;
	dlg->lpDialogFunc=lpDialogFunc;
	dlg->lResult=-1;
	dlg->dwUser=0;
	dlg->child=g_malloc((lpDialogTemplate->cdit+1)*sizeof(GtkWidget *));
	dlg->sister=NULL;

	data=(guint16 *)(lpDialogTemplate+1);
	/* Menu name */
	DLG_STRING_NEXT(data);
	/* Class name */
	DLG_STRING_NEXT(data);
	/* Dialog Title */
	if (*data==0xffff) {
		title=g_strdup("Dialog");
	} else {
		leng=iso10646_widechar_to_multibyte(data,-1,NULL,-1);
		title=g_malloc(leng*sizeof(gchar));
		iso10646_widechar_to_multibyte(data,-1,title,leng);
	}
	DLG_STRING_NEXT(data);
	/* Font Point */
	data++;
	/* Font Face */
	DLG_STRING_NEXT(data);

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),title);
	g_free(title);
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
										GTK_SIGNAL_FUNC(dialog_key_press),dlg);
	gtk_signal_connect(GTK_OBJECT(dialog),"delete-event",
										GTK_SIGNAL_FUNC(dialog_delete),dlg);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_widget_realize(dialog);
	gtk_object_set_user_data(GTK_OBJECT(dialog),dlg);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ե */
	style=gtk_widget_get_style(GTK_WIDGET(dialog));
	for (i=0;i<256;i++)
		if (isalnum(i)) {
			w=gdk_char_width(style->font,i);
			if (width<w)
				width=w;
			h=gdk_char_height(style->font,i);
			if (height<h)
				height=h;
		}
	width=MIN((height+1)/2,width);
	/* ե */
	fixed=gtk_fixed_new();
	gtk_widget_set_usize(fixed,
				lpDialogTemplate->cx*width/4,lpDialogTemplate->cy*height/8);
	gtk_container_add(GTK_CONTAINER(dialog),fixed);

	for (i=0;i<lpDialogTemplate->cdit;i++) {
		/* Dialog Item */
		if (((DWORD)data-(DWORD)lpDialogTemplate)%sizeof(DWORD)!=0)
			data++;
		lpDialogItem=(LPDLGITEMTEMPLATE)data;
		widget=NULL;

		wed=g_malloc(sizeof(WindowExtraData));
		wed->dwStyle=lpDialogItem->style;
		wed->dwExStyle=lpDialogItem->dwExtendedStyle;
		wed->lpfnWndProc=DefWindowProc;
		wed->hInstance=hInstance;
		wed->hWndParent=dialog;
		wed->wID=lpDialogItem->id;
		wed->dwUserData=0;
		wed->lpDialogFunc=lpDialogFunc;
		wed->lResult=-1;
		wed->dwUser=0;
		wed->child=NULL;
		wed->sister=NULL;

		data=(guint16 *)(lpDialogItem+1);
		/* Class name */
		atom=*data==0xffff?data[1]:0;
		DLG_STRING_NEXT(data);
		/* Dialog Title */
		if (*data==0xffff) {
			title=NULL;
		} else {
			leng=iso10646_widechar_to_multibyte(data,-1,NULL,-1);
			title=g_malloc(leng*sizeof(gchar));
			iso10646_widechar_to_multibyte(data,-1,title,leng);
		}
		DLG_STRING_NEXT(data);
		/* Creation Data */
		DLG_STRING_NEXT(data);

		switch (atom) {
		case 0x0080:/* ܥ */
			switch (lpDialogItem->style&0xf) {
			case BS_PUSHBUTTON:
			case BS_DEFPUSHBUTTON:
				widget=gtk_button_new_with_label(NULL);
				gtk_signal_connect(GTK_OBJECT(widget),"clicked",
												dialog_button_clicked,NULL);
				break;
			case BS_AUTOCHECKBOX:
				widget=gtk_check_button_new_with_label(NULL);
				gtk_signal_connect(GTK_OBJECT(widget),"toggled",
												dialog_button_toggled,NULL);
				break;
			default:
				g_print("Unsupported Dialog Item Button.\n");
			}
			if (widget!=NULL) {
				for (j=0;j<title[j]!='\0';j++)
					if (title[j]=='&')
						title[j]='_';
				key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(widget)->child),
												title!=NULL?title:"Button");
				if (key!=GDK_VoidSymbol) {
					gtk_widget_add_accelerator(widget,"clicked",
													accel,key,GDK_MOD1_MASK,0);
					key=GDK_VoidSymbol;
				}
				switch (lpDialogItem->style&0x00000300L) {
				case BS_LEFT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
															GTK_JUSTIFY_LEFT);
					break;
				case BS_RIGHT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
															GTK_JUSTIFY_RIGHT);
					break;
				case BS_CENTER:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
														GTK_JUSTIFY_CENTER);
				}
				gtk_widget_set_usize(widget,
						lpDialogItem->cx*width/4,lpDialogItem->cy*height/8);
				if (focus==NULL)
					focus=widget;
			}
			break;
		case 0x0081:/* ǥ */
			g_print("Unsupported Dialog Item Edit.\n");
			break;
		case 0x0082:/* ƥå */
			switch (lpDialogItem->style&0x1F) {
			case SS_LEFT:
			case SS_CENTER:
			case SS_RIGHT:
			case SS_LEFTNOWORDWRAP:
				if ((lpDialogItem->style&SS_NOPREFIX)!=0) {
					widget=gtk_label_new(title!=NULL?title:"Static");
					key=GDK_VoidSymbol;
				} else {
					widget=gtk_label_new(NULL);
					for (j=0;j<title[j]!='\0';j++)
						if (title[j]=='&')
							title[j]='_';
					key=gtk_label_parse_uline(GTK_LABEL(widget),
												title!=NULL?title:"Static");
				}
				gtk_label_set_line_wrap(GTK_LABEL(widget),
								(lpDialogItem->style&0x1F)!=SS_LEFTNOWORDWRAP);
				switch (lpDialogItem->style&0x1F) {
				case SS_CENTER:
					gtk_label_set_justify(GTK_LABEL(widget),
														GTK_JUSTIFY_CENTER);
					break;
				case SS_RIGHT:
					gtk_label_set_justify(GTK_LABEL(widget),GTK_JUSTIFY_RIGHT);
					break;
				default:gtk_label_set_justify(GTK_LABEL(widget),
															GTK_JUSTIFY_LEFT);
				}
				break;
			default:
				g_print("Unsupported Dialog Item Static.\n");
			}
			if (widget!=NULL)
				gtk_widget_set_usize(widget,
						lpDialogItem->cx*width/4,lpDialogItem->cy*height/8);
			break;
		case 0x0083:/* ꥹȥܥå */
			g_print("Unsupported Dialog Item ListBox.\n");
			break;
		case 0x0084:/* С */
			g_print("Unsupported Dialog Item ScrollBar.\n");
			break;
		case 0x0085:/* ܥܥå */
			widget=gtk_combo_new();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(widget)->entry),
								(lpDialogItem->style&0xf)!=CBS_DROPDOWNLIST);
			if (key!=GDK_VoidSymbol) {
				gtk_widget_add_accelerator(GTK_COMBO(widget)->entry,
									"grab-focus",accel,key,GDK_MOD1_MASK,0);
				key=GDK_VoidSymbol;
			}
			if (focus==NULL)
				focus=widget;
			break;
		case 0x0000:/* 桼 */
			g_print("User-defined Dialog Item.\n");
			break;
		default:
			g_print("Unknown Dialog Item.\n");
		}
		g_free(title);
		if (widget==NULL) {
			g_free(wed);
		} else {
			gtk_signal_connect_after(GTK_OBJECT(widget),"destroy",
												dialog_widget_destroy,NULL);
			gtk_object_set_user_data(GTK_OBJECT(widget),wed);
			gtk_fixed_put(GTK_FIXED(fixed),widget,
							lpDialogItem->x*width/4,lpDialogItem->y*height/8);
			if ((lpDialogItem->style&WS_DISABLED)!=0)
				gtk_widget_set_sensitive(widget,FALSE);
			if ((lpDialogItem->style&WS_VISIBLE)!=0)
				gtk_widget_show(widget);
			if (wed->sister!=NULL)
				for (j=0;wed->sister[j]!=NULL;j++) {
					if ((lpDialogItem->style&WS_DISABLED)!=0)
						gtk_widget_set_sensitive(wed->sister[j],FALSE);
					if ((lpDialogItem->style&WS_VISIBLE)!=0)
						gtk_widget_show(wed->sister[j]);
				}
			dlg->child[cdit++]=widget;
		}
	}
	if (dlg->child!=NULL)
		dlg->child[cdit]=NULL;

	/* ɽ */
	if (focus!=NULL)
		gtk_widget_grab_focus(focus);
	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,FALSE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show(fixed);
	gtk_widget_show(dialog);
	lpDialogFunc(dialog,WM_INITDIALOG,(WPARAM)focus,dwInitParam);
	gtk_main();

	nResult=dlg->lResult;
	g_free(dlg->child);
	g_free(dlg);
	return nResult;
}


static INT WINAPI DialogBoxParamA(HINSTANCE hInstance,LPCSTR lpTemplateName,
					HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam)
{
	LPCDLGTEMPLATE lpDialogTemplate;
	HRSRC hRsrc;

	return (hRsrc=FindResourceA(hInstance,
									lpTemplateName,(LPCSTR)RT_DIALOG))!=NULL
					&& (lpDialogTemplate=LoadResource(hInstance,hRsrc))!=NULL
		?DialogBoxIndirectParam(hInstance,lpDialogTemplate,
									hWndParent,lpDialogFunc,dwInitParam):-1;
}


static BOOL WINAPI EndDialog(HWND hDlg,INT nResult)
{
	WindowExtraData *wed;

	if (hDlg!=NULL && (wed=gtk_object_get_user_data(GTK_OBJECT(hDlg)))!=NULL) {
		wed->lResult=nResult;
		gtk_widget_destroy(GTK_WIDGET(hDlg));
		return TRUE;
	}
	return FALSE;
}


static BOOL WINAPI CheckDlgButton(HWND hDlg,INT nIDButton,UINT uCheck)
{
	GtkWidget *widget;

	if (uCheck!=BST_INDETERMINATE
								&& (widget=GetDlgItem(hDlg,nIDButton))!=NULL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),
														uCheck==BST_CHECKED);
		return TRUE;
	}
	return FALSE;
}


static UINT WINAPI IsDlgButtonChecked(HWND hDlg,INT nIDButton)
{
	return SendMessageA(GetDlgItem(hDlg,nIDButton),BM_GETCHECK,0,0);
}


/******************************************************************************
*                                                                             *
* åܥå                                                          *
*                                                                             *
******************************************************************************/
#define MB_OK				0x00000000
#define MB_OKCANCEL			0x00000001
#define MB_ABORTRETRYIGNORE	0x00000002
#define MB_YESNOCANCEL		0x00000003
#define MB_YESNO			0x00000004
#define MB_RETRYCANCEL		0x00000005
#define MB_TYPEMASK			0x0000000F
#define MB_DEFBUTTON1		0x00000000
#define MB_DEFBUTTON2		0x00000100
#define MB_DEFBUTTON3		0x00000200
#define MB_DEFBUTTON4		0x00000300
#define MB_DEFMASK			0x00000F00


static INT WINAPI MessageBoxA(HWND hWnd,
									LPCSTR lpText,LPCSTR lpCaption,UINT uType)
{
	gint def;

	switch (uType&MB_DEFMASK) {
		case MB_DEFBUTTON2:def=1;break;
		case MB_DEFBUTTON3:def=2;break;
		case MB_DEFBUTTON4:def=3;break;
		default:def=0;
	}
	switch (uType&MB_TYPEMASK) {
		case MB_ABORTRETRYIGNORE:
			switch (misc_message_box(lpCaption,lpText,def,
										"_Abort","_Retry","_Ignore",NULL)) {
				case  1:return IDRETRY;
				case  2:return IDIGNORE;
			}
			return IDABORT;
		case MB_OK:
			misc_message_box(lpCaption,lpText,def,"OK",NULL);
			return IDOK;
		case MB_OKCANCEL:
			return misc_message_box(lpCaption,lpText,def,"OK","Cancel",NULL)>=0
																?IDOK:IDCANCEL;
		case MB_RETRYCANCEL:
			return misc_message_box(lpCaption,lpText,
							def,"_Retry","Cancel",NULL)>=0?IDRETRY:IDCANCEL;
		case MB_YESNO:
			return misc_message_box(lpCaption,lpText,def,"_Yes","_No",NULL)>=0
																?IDYES:IDNO;
		case MB_YESNOCANCEL:
			switch (misc_message_box(lpCaption,lpText,
											def,"_Yes","_No","Cancel",NULL)) {
				case  0:return IDYES;
				case  1:return IDNO;
			}
			return IDCANCEL;
	}
	return IDCANCEL;
}


/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static INT WINAPI wsprintfA(LPSTR lpOut,LPCSTR lpFmt,...)
{
	va_list va;

	va_start(va,lpFmt);
	vsprintf(lpOut,lpFmt,va);
	va_end(va);
	return strlen(lpOut);
}


static INT WINAPI wvsprintfA(LPSTR lpOutput,LPCSTR lpFormat,va_list arglist)
{
  return vsprintf(lpOutput,lpFormat,arglist);
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in user32 called\n");
}


static SymbolInfo symbol_infos[]={
	{"GetWindowLongA",GetWindowLongA},
	{"SetWindowLongA",SetWindowLongA},
	{"GetDlgItem",GetDlgItem},
	{"SetWindowTextA",SetWindowTextA},
	{"ScreenToClient",ScreenToClient},
	{"GetWindowRect",GetWindowRect},
	{"BeginPaint",BeginPaint},
	{"EndPaint",EndPaint},
	{"GetDC",GetDC},
	{"ReleaseDC",ReleaseDC},
	{"SendMessageA",SendMessageA},
	{"SendDlgItemMessageA",SendDlgItemMessageA},
	{"FindResourceExA",FindResourceExA},
	{"FindResourceA",FindResourceA},
	{"LoadResource",LoadResource},
	{"SizeofResource",SizeofResource},
	{"LoadStringA",LoadStringA},
	{"LoadBitmapA",	LoadBitmapA},
	{"DialogBoxIndirectParam",DialogBoxIndirectParam},
	{"DialogBoxParamA",DialogBoxParamA},
	{"EndDialog",EndDialog},
	{"CheckDlgButton",CheckDlgButton},
	{"IsDlgButtonChecked",IsDlgButtonChecked},
	{"MessageBoxA",MessageBoxA},
	{"wsprintfA",wsprintfA},
	{"wvsprintfA",wvsprintfA},
	{NULL,UnknownSymbol}
};


SymbolInfo *user32_get_export_symbols(void)
{
	module_register("user32.dll",symbol_infos);
	return symbol_infos;
}
