/*
    dllloader
    (C)Copyright 2000, 2001 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __WINDEF_H__
#define __WINDEF_H__


#include <glib.h>


#define __stdcall __attribute__((__stdcall__))
#define CALLBACK __stdcall
#define PASCAL __stdcall
#define WINAPI __stdcall


/* Macros to split words and longs. */
#define LOBYTE(w)				((BYTE)(WORD)(w))
#define HIBYTE(w)				((BYTE)((WORD)(w) >> 8))
#define LOWORD(l)				((WORD)(DWORD)(l))
#define HIWORD(l)				((WORD)((DWORD)(l) >> 16))
#define SLOWORD(l)				((SHORT)(LONG)(l))
#define SHIWORD(l)				((SHORT)((LONG)(l) >> 16))
#define MAKEWORD(low,high)		((WORD)(((BYTE)(low)) \
												| ((WORD)((BYTE)(high))) << 8))
#define MAKELONG(low,high)		((LONG)(((WORD)(low)) \
											| (((DWORD)((WORD)(high))) << 16)))
#define MAKELPARAM(low,high)	((LPARAM)MAKELONG(low,high))
#define MAKEWPARAM(low,high)	((WPARAM)MAKELONG(low,high))
#define MAKELRESULT(low,high)	((LRESULT)MAKELONG(low,high))


/* { */
#define CONST const
typedef gint32 BOOL;
typedef void VOID;
typedef gint8 CHAR;
typedef guint8 UCHAR;
typedef gint16 SHORT;
typedef guint16 USHORT;
typedef gint32 INT;
typedef guint32 UINT;
typedef gint32 LONG;
typedef guint32 ULONG;
/* |C^ */
typedef BOOL *PBOOL;
typedef BOOL *LPBOOL;
typedef VOID *PVOID;
typedef VOID *LPVOID;
typedef CONST VOID *PCVOID;
typedef CONST VOID *LPCVOID;
typedef CHAR *CHAR_PTR;
typedef UCHAR *UCHAR_PTR;
typedef SHORT *SHORT_PTR;
typedef USHORT *USHORT_PTR;
typedef INT *INT_PTR;
typedef UINT *UINT_PTR;
typedef LONG *LONG_PTR;
typedef ULONG *ULONG_PTR;
/* WORD */
typedef UCHAR BYTE;
typedef USHORT WORD;
typedef ULONG DWORD;
typedef BYTE *PBYTE;
typedef BYTE *LPBYTE;
typedef WORD *PWORD;
typedef WORD *LPWORD;
typedef DWORD *PDWORD;
typedef DWORD *LPDWORD;
/*  */
typedef USHORT WCHAR;
typedef CHAR *PSTR;
typedef CHAR *LPSTR;
typedef CONST CHAR *PCSTR;
typedef CONST CHAR *LPCSTR;
typedef WCHAR *PWSTR;
typedef WCHAR *LPWSTR;
typedef CONST WCHAR *PCWSTR;
typedef CONST WCHAR *LPCWSTR;
/* R[obN */
typedef LONG LRESULT;
typedef LONG LPARAM;
typedef LONG WPARAM;
/* nh */
typedef LPVOID HANDLE;
typedef HANDLE HDC;
typedef HANDLE HGDI;
typedef HANDLE HGLOBAL;
typedef HANDLE HINSTANCE;
typedef HANDLE HMODULE;
typedef HANDLE HWND;
/* ֐ */
typedef LRESULT CALLBACK (*FARPROC)(VOID);
typedef BOOL CALLBACK (*WNDENUMPROC)(HWND,LPARAM);
typedef BOOL CALLBACK (*DllEntryProc)(HMODULE,DWORD,LPVOID);
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);
typedef BOOL CALLBACK (*DLGPROC)(HWND,UINT,WPARAM,LPARAM);
typedef LRESULT CALLBACK (*WNDPROC)(HWND,UINT,WPARAM,LPARAM);


#endif
